/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.queue;

import java.io.UnsupportedEncodingException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.recipes.queue.ItemSerializer;
import org.apache.curator.framework.recipes.queue.MultiItem;
import org.apache.curator.framework.recipes.queue.QueueSerializer;

public class PublicStringSerializer {
    private static QueueSerializer<String> INSTANCE = new StringSerializer();

    public static QueueSerializer<String> serializer() {
        return INSTANCE;
    }

    public static byte[] serialize(String item) throws Exception {
        final AtomicReference<String> ref = new AtomicReference<String>(item);
        MultiItem<String> multiItem = new MultiItem<String>(){

            @Override
            public String nextItem() throws Exception {
                return ref.getAndSet(null);
            }
        };
        return ItemSerializer.serialize(multiItem, INSTANCE);
    }

    public static String deserialize(byte[] bytes) throws Exception {
        MultiItem<String> items = ItemSerializer.deserialize(bytes, INSTANCE);
        return items.nextItem();
    }

    private static class StringSerializer
    implements QueueSerializer<String> {
        private StringSerializer() {
        }

        @Override
        public byte[] serialize(String item) {
            try {
                return item == null ? new byte[]{} : item.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        @Override
        public String deserialize(byte[] bytes) {
            try {
                return bytes == null ? "" : new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }
}

