/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.gateway.handlers.http.policy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.fusesource.gateway.handlers.http.MappedServices;
import org.fusesource.gateway.handlers.http.ProxyMappingDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.MultiMap;
import org.vertx.java.core.http.HttpClientResponse;
import org.vertx.java.core.http.HttpServerRequest;

public class ReverseUriPolicy
implements Handler<HttpClientResponse> {
    private static final transient Logger LOG = LoggerFactory.getLogger(ReverseUriPolicy.class);
    private final MappedServices mappedServices;
    private final HttpServerRequest request;
    private final Handler<HttpClientResponse> delegate;
    private final ProxyMappingDetails proxyMappingDetails;
    private final String[] rewriteHeaders = new String[]{"Location", "Content-Location", "URI"};

    public ReverseUriPolicy(MappedServices mappedServices, HttpServerRequest request, Handler<HttpClientResponse> delegate, ProxyMappingDetails proxyMappingDetails) {
        this.mappedServices = mappedServices;
        this.request = request;
        this.delegate = delegate;
        this.proxyMappingDetails = proxyMappingDetails;
    }

    @Override
    public void handle(HttpClientResponse clientResponse) {
        this.delegate.handle(clientResponse);
        MultiMap headers = clientResponse.headers();
        for (String headerName : this.rewriteHeaders) {
            List<String> headerValues = headers.getAll(headerName);
            int size = headerValues.size();
            if (size <= 0) continue;
            ArrayList<String> newHeaders = new ArrayList<String>(size);
            Iterator<String> i$ = headerValues.iterator();
            while (i$.hasNext()) {
                String headerValue;
                String newValue = headerValue = i$.next();
                if (headerValue == null || headerValue.length() <= 0) continue;
                newValue = this.proxyMappingDetails.rewriteBackendUrl(headerValue);
            }
            LOG.info("Rewriting header " + headerName + " from: " + headerValues + " to: " + newHeaders);
            headers.set(headerName, newHeaders);
        }
    }
}

