/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.gateway.loadbalancer;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.fusesource.gateway.loadbalancer.ClientRequestFacade;
import org.fusesource.gateway.loadbalancer.LoadBalancer;

public class RoundRobinLoadBalancer<T>
implements LoadBalancer<T> {
    AtomicInteger counter = new AtomicInteger(-1);

    @Override
    public T choose(List<T> things, ClientRequestFacade requestFacade) {
        int size = things.size();
        if (size > 0) {
            int value = this.counter.incrementAndGet();
            int index = value % size;
            if (index < 0) {
                index = 0;
            } else if (index >= size) {
                index = size - 1;
            }
            return things.get(index);
        }
        return null;
    }
}

