/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.MultiMap;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpClient;
import org.vertx.java.core.http.HttpClientRequest;
import org.vertx.java.core.http.HttpClientResponse;
import org.vertx.java.core.http.WebSocket;
import org.vertx.java.core.http.WebSocketVersion;
import org.vertx.java.core.http.impl.ClientConnection;
import org.vertx.java.core.http.impl.DefaultHttpClientRequest;
import org.vertx.java.core.http.impl.HttpPool;
import org.vertx.java.core.http.impl.PriorityHttpConnectionPool;
import org.vertx.java.core.http.impl.VertxHttpHandler;
import org.vertx.java.core.http.impl.ws.DefaultWebSocketFrame;
import org.vertx.java.core.http.impl.ws.WebSocketFrame;
import org.vertx.java.core.impl.Closeable;
import org.vertx.java.core.impl.DefaultContext;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.impl.ExceptionDispatchHandler;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.net.impl.TCPSSLHelper;
import org.vertx.java.core.net.impl.VertxEventLoopGroup;

public class DefaultHttpClient
implements HttpClient {
    private static final ExceptionDispatchHandler EXCEPTION_DISPATCH_HANDLER = new ExceptionDispatchHandler();
    final VertxInternal vertx;
    final Map<Channel, ClientConnection> connectionMap = new ConcurrentHashMap<Channel, ClientConnection>();
    private final DefaultContext actualCtx;
    private final TCPSSLHelper tcpHelper = new TCPSSLHelper();
    private Bootstrap bootstrap;
    private Handler<Throwable> exceptionHandler;
    private int port = 80;
    private String host = "localhost";
    private final HttpPool pool = new PriorityHttpConnectionPool(){

        @Override
        protected void connect(Handler<ClientConnection> connectHandler, Handler<Throwable> connectErrorHandler, DefaultContext context) {
            DefaultHttpClient.this.internalConnect(connectHandler, connectErrorHandler);
        }
    };
    private boolean keepAlive = true;
    private boolean configurable = true;
    private boolean closed;
    private final Closeable closeHook = new Closeable(){

        @Override
        public void close(Handler<AsyncResult<Void>> doneHandler) {
            DefaultHttpClient.this.close();
            doneHandler.handle(new DefaultFutureResult<Void>((Void)null));
        }
    };

    public DefaultHttpClient(VertxInternal vertx) {
        this.vertx = vertx;
        this.actualCtx = vertx.getOrCreateContext();
        this.actualCtx.addCloseHook(this.closeHook);
    }

    @Override
    public DefaultHttpClient exceptionHandler(Handler<Throwable> handler) {
        this.checkClosed();
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public DefaultHttpClient setMaxPoolSize(int maxConnections) {
        this.checkClosed();
        this.checkConfigurable();
        this.pool.setMaxPoolSize(maxConnections);
        return this;
    }

    @Override
    public int getMaxPoolSize() {
        this.checkClosed();
        return this.pool.getMaxPoolSize();
    }

    @Override
    public DefaultHttpClient setKeepAlive(boolean keepAlive) {
        this.checkClosed();
        this.checkConfigurable();
        this.keepAlive = keepAlive;
        return this;
    }

    @Override
    public boolean isKeepAlive() {
        this.checkClosed();
        return this.keepAlive;
    }

    @Override
    public DefaultHttpClient setPort(int port) {
        this.checkClosed();
        this.checkConfigurable();
        this.port = port;
        return this;
    }

    @Override
    public int getPort() {
        this.checkClosed();
        return this.port;
    }

    @Override
    public DefaultHttpClient setHost(String host) {
        this.checkClosed();
        this.checkConfigurable();
        this.host = host;
        return this;
    }

    @Override
    public String getHost() {
        this.checkClosed();
        return this.host;
    }

    @Override
    public HttpClient connectWebsocket(String uri, Handler<WebSocket> wsConnect) {
        this.checkClosed();
        this.connectWebsocket(uri, WebSocketVersion.RFC6455, wsConnect);
        return this;
    }

    @Override
    public HttpClient connectWebsocket(String uri, WebSocketVersion wsVersion, Handler<WebSocket> wsConnect) {
        this.checkClosed();
        this.connectWebsocket(uri, wsVersion, null, wsConnect);
        return this;
    }

    @Override
    public HttpClient connectWebsocket(final String uri, final WebSocketVersion wsVersion, final MultiMap headers, final Handler<WebSocket> wsConnect) {
        this.checkClosed();
        this.configurable = false;
        this.getConnection(new Handler<ClientConnection>(){

            @Override
            public void handle(ClientConnection conn) {
                if (!conn.isClosed()) {
                    conn.toWebSocket(uri, wsVersion, headers, wsConnect);
                } else {
                    DefaultHttpClient.this.connectWebsocket(uri, wsVersion, headers, wsConnect);
                }
            }
        }, this.exceptionHandler, this.actualCtx);
        return this;
    }

    @Override
    public HttpClient getNow(String uri, Handler<HttpClientResponse> responseHandler) {
        this.checkClosed();
        this.getNow(uri, null, responseHandler);
        return this;
    }

    @Override
    public HttpClient getNow(String uri, MultiMap headers, Handler<HttpClientResponse> responseHandler) {
        this.checkClosed();
        HttpClientRequest req = this.get(uri, responseHandler);
        if (headers != null) {
            req.headers().set(headers);
        }
        req.end();
        return this;
    }

    @Override
    public HttpClientRequest options(String uri, Handler<HttpClientResponse> responseHandler) {
        this.checkClosed();
        return this.doRequest("OPTIONS", uri, responseHandler);
    }

    @Override
    public HttpClientRequest get(String uri, Handler<HttpClientResponse> responseHandler) {
        this.checkClosed();
        return this.doRequest("GET", uri, responseHandler);
    }

    @Override
    public HttpClientRequest head(String uri, Handler<HttpClientResponse> responseHandler) {
        this.checkClosed();
        return this.doRequest("HEAD", uri, responseHandler);
    }

    @Override
    public HttpClientRequest post(String uri, Handler<HttpClientResponse> responseHandler) {
        this.checkClosed();
        return this.doRequest("POST", uri, responseHandler);
    }

    @Override
    public HttpClientRequest put(String uri, Handler<HttpClientResponse> responseHandler) {
        this.checkClosed();
        return this.doRequest("PUT", uri, responseHandler);
    }

    @Override
    public HttpClientRequest delete(String uri, Handler<HttpClientResponse> responseHandler) {
        this.checkClosed();
        return this.doRequest("DELETE", uri, responseHandler);
    }

    @Override
    public HttpClientRequest trace(String uri, Handler<HttpClientResponse> responseHandler) {
        this.checkClosed();
        return this.doRequest("TRACE", uri, responseHandler);
    }

    @Override
    public HttpClientRequest connect(String uri, Handler<HttpClientResponse> responseHandler) {
        this.checkClosed();
        return this.doRequest("CONNECT", uri, responseHandler);
    }

    @Override
    public HttpClientRequest patch(String uri, Handler<HttpClientResponse> responseHandler) {
        this.checkClosed();
        return this.doRequest("PATCH", uri, responseHandler);
    }

    @Override
    public HttpClientRequest request(String method, String uri, Handler<HttpClientResponse> responseHandler) {
        this.checkClosed();
        return this.doRequest(method, uri, responseHandler);
    }

    @Override
    public void close() {
        this.checkClosed();
        this.pool.close();
        for (ClientConnection conn : this.connectionMap.values()) {
            conn.close();
        }
        this.actualCtx.removeCloseHook(this.closeHook);
        this.closed = true;
    }

    @Override
    public DefaultHttpClient setSSL(boolean ssl) {
        this.checkClosed();
        this.checkConfigurable();
        this.tcpHelper.setSSL(ssl);
        return this;
    }

    @Override
    public DefaultHttpClient setVerifyHost(boolean verifyHost) {
        this.checkClosed();
        this.checkConfigurable();
        this.tcpHelper.setVerifyHost(verifyHost);
        return this;
    }

    @Override
    public DefaultHttpClient setKeyStorePath(String path) {
        this.checkClosed();
        this.checkConfigurable();
        this.tcpHelper.setKeyStorePath(path);
        return this;
    }

    @Override
    public DefaultHttpClient setKeyStorePassword(String pwd) {
        this.checkClosed();
        this.checkConfigurable();
        this.tcpHelper.setKeyStorePassword(pwd);
        return this;
    }

    @Override
    public DefaultHttpClient setTrustStorePath(String path) {
        this.checkClosed();
        this.checkConfigurable();
        this.tcpHelper.setTrustStorePath(path);
        return this;
    }

    @Override
    public DefaultHttpClient setTrustStorePassword(String pwd) {
        this.checkClosed();
        this.checkConfigurable();
        this.tcpHelper.setTrustStorePassword(pwd);
        return this;
    }

    @Override
    public DefaultHttpClient setTrustAll(boolean trustAll) {
        this.checkClosed();
        this.checkConfigurable();
        this.tcpHelper.setTrustAll(trustAll);
        return this;
    }

    @Override
    public DefaultHttpClient setTCPNoDelay(boolean tcpNoDelay) {
        this.checkClosed();
        this.checkConfigurable();
        this.tcpHelper.setTCPNoDelay(tcpNoDelay);
        return this;
    }

    @Override
    public DefaultHttpClient setSendBufferSize(int size) {
        this.checkClosed();
        this.checkConfigurable();
        this.tcpHelper.setSendBufferSize(size);
        return this;
    }

    @Override
    public DefaultHttpClient setReceiveBufferSize(int size) {
        this.checkClosed();
        this.checkConfigurable();
        this.tcpHelper.setReceiveBufferSize(size);
        return this;
    }

    @Override
    public DefaultHttpClient setTCPKeepAlive(boolean keepAlive) {
        this.checkClosed();
        this.checkConfigurable();
        this.tcpHelper.setTCPKeepAlive(keepAlive);
        return this;
    }

    @Override
    public DefaultHttpClient setReuseAddress(boolean reuse) {
        this.checkClosed();
        this.checkConfigurable();
        this.tcpHelper.setReuseAddress(reuse);
        return this;
    }

    @Override
    public DefaultHttpClient setSoLinger(int linger) {
        this.checkClosed();
        this.checkConfigurable();
        this.tcpHelper.setSoLinger(linger);
        return this;
    }

    @Override
    public DefaultHttpClient setTrafficClass(int trafficClass) {
        this.checkClosed();
        this.checkConfigurable();
        this.tcpHelper.setTrafficClass(trafficClass);
        return this;
    }

    @Override
    public DefaultHttpClient setConnectTimeout(int timeout) {
        this.checkClosed();
        this.checkConfigurable();
        this.tcpHelper.setConnectTimeout(timeout);
        return this;
    }

    @Override
    public boolean isTCPNoDelay() {
        this.checkClosed();
        return this.tcpHelper.isTCPNoDelay();
    }

    @Override
    public int getSendBufferSize() {
        this.checkClosed();
        return this.tcpHelper.getSendBufferSize();
    }

    @Override
    public int getReceiveBufferSize() {
        this.checkClosed();
        return this.tcpHelper.getReceiveBufferSize();
    }

    @Override
    public boolean isTCPKeepAlive() {
        this.checkClosed();
        return this.tcpHelper.isTCPKeepAlive();
    }

    @Override
    public boolean isReuseAddress() {
        this.checkClosed();
        return this.tcpHelper.isReuseAddress();
    }

    @Override
    public int getSoLinger() {
        this.checkClosed();
        return this.tcpHelper.getSoLinger();
    }

    @Override
    public int getTrafficClass() {
        this.checkClosed();
        return this.tcpHelper.getTrafficClass();
    }

    @Override
    public int getConnectTimeout() {
        this.checkClosed();
        return this.tcpHelper.getConnectTimeout();
    }

    @Override
    public boolean isSSL() {
        this.checkClosed();
        return this.tcpHelper.isSSL();
    }

    @Override
    public boolean isVerifyHost() {
        this.checkClosed();
        return this.tcpHelper.isVerifyHost();
    }

    @Override
    public boolean isTrustAll() {
        this.checkClosed();
        return this.tcpHelper.isTrustAll();
    }

    @Override
    public String getKeyStorePath() {
        this.checkClosed();
        return this.tcpHelper.getKeyStorePath();
    }

    @Override
    public String getKeyStorePassword() {
        this.checkClosed();
        return this.tcpHelper.getKeyStorePassword();
    }

    @Override
    public String getTrustStorePath() {
        this.checkClosed();
        return this.tcpHelper.getTrustStorePath();
    }

    @Override
    public String getTrustStorePassword() {
        this.checkClosed();
        return this.tcpHelper.getTrustStorePassword();
    }

    @Override
    public HttpClient setUsePooledBuffers(boolean pooledBuffers) {
        this.checkClosed();
        this.checkConfigurable();
        this.tcpHelper.setUsePooledBuffers(pooledBuffers);
        return this;
    }

    @Override
    public boolean isUsePooledBuffers() {
        this.checkClosed();
        return this.tcpHelper.isUsePooledBuffers();
    }

    void getConnection(Handler<ClientConnection> handler, Handler<Throwable> connectionExceptionHandler, DefaultContext context) {
        this.pool.getConnection(handler, connectionExceptionHandler, context);
    }

    void returnConnection(ClientConnection conn) {
        this.pool.returnConnection(conn);
    }

    void handleException(Exception e) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(e);
        } else {
            this.vertx.reportException(e);
        }
    }

    VertxInternal getVertx() {
        return this.vertx;
    }

    void internalConnect(final Handler<ClientConnection> connectHandler, final Handler<Throwable> connectErrorHandler) {
        if (this.bootstrap == null) {
            VertxEventLoopGroup pool = new VertxEventLoopGroup();
            pool.addWorker(this.actualCtx.getEventLoop());
            this.bootstrap = new Bootstrap();
            this.bootstrap.group(pool);
            this.bootstrap.channel(NioSocketChannel.class);
            this.tcpHelper.checkSSL(this.vertx);
            this.bootstrap.handler(new ChannelInitializer<Channel>(){

                @Override
                protected void initChannel(Channel ch) throws Exception {
                    ChannelPipeline pipeline = ch.pipeline();
                    pipeline.addLast("exceptionDispatcher", (ChannelHandler)EXCEPTION_DISPATCH_HANDLER);
                    if (DefaultHttpClient.this.tcpHelper.isSSL()) {
                        SSLEngine engine = DefaultHttpClient.this.tcpHelper.getSSLContext().createSSLEngine(DefaultHttpClient.this.host, DefaultHttpClient.this.port);
                        if (DefaultHttpClient.this.tcpHelper.isVerifyHost()) {
                            SSLParameters sslParameters = engine.getSSLParameters();
                            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
                            engine.setSSLParameters(sslParameters);
                        }
                        engine.setUseClientMode(true);
                        pipeline.addLast("ssl", (ChannelHandler)new SslHandler(engine));
                    }
                    pipeline.addLast("codec", (ChannelHandler)new HttpClientCodec());
                    pipeline.addLast("handler", (ChannelHandler)new ClientHandler());
                }
            });
        }
        this.tcpHelper.applyConnectionOptions(this.bootstrap);
        ChannelFuture future = this.bootstrap.connect(new InetSocketAddress(this.host, this.port));
        future.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                final Channel ch = channelFuture.channel();
                if (channelFuture.isSuccess()) {
                    if (DefaultHttpClient.this.tcpHelper.isSSL()) {
                        SslHandler sslHandler = ch.pipeline().get(SslHandler.class);
                        Future<Channel> fut = sslHandler.handshakeFuture();
                        fut.addListener(new GenericFutureListener<Future<Channel>>(){

                            @Override
                            public void operationComplete(Future<Channel> future) throws Exception {
                                if (future.isSuccess()) {
                                    DefaultHttpClient.this.connected(ch, connectHandler);
                                } else {
                                    DefaultHttpClient.this.failed(ch, connectErrorHandler, new SSLHandshakeException("Failed to create SSL connection"));
                                }
                            }
                        });
                    } else {
                        DefaultHttpClient.this.connected(ch, connectHandler);
                    }
                } else {
                    DefaultHttpClient.this.failed(ch, connectErrorHandler, channelFuture.cause());
                }
            }
        });
    }

    private HttpClientRequest doRequest(String method, String uri, Handler<HttpClientResponse> responseHandler) {
        this.configurable = false;
        return new DefaultHttpClientRequest(this, method, uri, responseHandler, this.actualCtx);
    }

    private final void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Client is closed");
        }
    }

    private final void checkConfigurable() {
        if (!this.configurable) {
            throw new IllegalStateException("Can't set property after connect has been called");
        }
    }

    private void connected(final Channel ch, final Handler<ClientConnection> connectHandler) {
        this.actualCtx.execute(ch.eventLoop(), new Runnable(){

            @Override
            public void run() {
                DefaultHttpClient.this.createConn(ch, connectHandler);
            }
        });
    }

    private void createConn(Channel ch, Handler<ClientConnection> connectHandler) {
        ClientConnection conn = new ClientConnection(this.vertx, this, ch, this.tcpHelper.isSSL(), this.host, this.port, this.keepAlive, this.actualCtx);
        conn.closeHandler(new VoidHandler(){

            @Override
            public void handle() {
                DefaultHttpClient.this.pool.connectionClosed();
            }
        });
        this.connectionMap.put(ch, conn);
        connectHandler.handle(conn);
    }

    private void failed(final Channel ch, Handler<Throwable> connectionExceptionHandler, final Throwable t) {
        final Handler<Throwable> exHandler = connectionExceptionHandler == null ? this.exceptionHandler : connectionExceptionHandler;
        this.actualCtx.execute(ch.eventLoop(), new Runnable(){

            @Override
            public void run() {
                DefaultHttpClient.this.pool.connectionClosed();
                try {
                    ch.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (exHandler != null) {
                    exHandler.handle(t);
                } else {
                    DefaultHttpClient.this.actualCtx.reportException(t);
                }
            }
        });
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private class ClientHandler
    extends VertxHttpHandler<ClientConnection> {
        private boolean closeFrameSent;

        public ClientHandler() {
            super(DefaultHttpClient.this.vertx, DefaultHttpClient.this.connectionMap);
        }

        @Override
        protected DefaultContext getContext(ClientConnection connection) {
            return DefaultHttpClient.this.actualCtx;
        }

        @Override
        protected void doMessageReceived(ClientConnection conn, ChannelHandlerContext ctx, Object msg) {
            if (conn == null || conn.isClosed()) {
                return;
            }
            boolean valid = false;
            if (msg instanceof HttpResponse) {
                HttpResponse response = (HttpResponse)msg;
                conn.handleResponse(response);
                valid = true;
            }
            if (msg instanceof HttpContent) {
                HttpContent chunk = (HttpContent)msg;
                if (chunk.content().isReadable()) {
                    Buffer buff = new Buffer(chunk.content().slice());
                    conn.handleResponseChunk(buff);
                }
                if (chunk instanceof LastHttpContent) {
                    conn.handleResponseEnd((LastHttpContent)chunk);
                }
                valid = true;
            } else if (msg instanceof WebSocketFrame) {
                WebSocketFrame frame = (WebSocketFrame)msg;
                switch (frame.getType()) {
                    case BINARY: 
                    case TEXT: {
                        conn.handleWsFrame(frame);
                        break;
                    }
                    case PING: {
                        ctx.writeAndFlush(new DefaultWebSocketFrame(WebSocketFrame.FrameType.PONG, frame.getBinaryData()));
                        break;
                    }
                    case CLOSE: {
                        if (this.closeFrameSent) break;
                        ctx.writeAndFlush(frame).addListener(ChannelFutureListener.CLOSE);
                        this.closeFrameSent = true;
                    }
                }
                valid = true;
            }
            if (!valid) {
                throw new IllegalStateException("Invalid object " + msg);
            }
        }
    }
}

