/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl.cgbystrom;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.CharsetUtil;
import java.util.List;

public class FlashPolicyHandler
extends ByteToMessageDecoder {
    private static final String XML = "<cross-domain-policy><allow-access-from domain=\"*\" to-ports=\"*\" /></cross-domain-policy>";
    private final ByteBuf policyResponse;

    public FlashPolicyHandler() {
        this(Unpooled.copiedBuffer(XML, CharsetUtil.UTF_8));
    }

    public FlashPolicyHandler(ByteBuf policyResponse) {
        this.policyResponse = policyResponse;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        boolean isFlashPolicyRequest;
        if (buffer.readableBytes() < 2) {
            return;
        }
        short magic1 = buffer.getUnsignedByte(buffer.readerIndex());
        short magic2 = buffer.getUnsignedByte(buffer.readerIndex() + 1);
        boolean bl = isFlashPolicyRequest = magic1 == 60 && magic2 == 112;
        if (isFlashPolicyRequest) {
            buffer.skipBytes(buffer.readableBytes());
            FlashPolicyHandler.removeAllPipelineHandlers(ctx.pipeline());
            ctx.writeAndFlush(this.policyResponse).addListener(ChannelFutureListener.CLOSE);
            return;
        }
        ctx.pipeline().remove(this);
    }

    private static void removeAllPipelineHandlers(ChannelPipeline pipeline) {
        while (pipeline.first() != null) {
            pipeline.removeFirst();
        }
    }
}

