/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.sockjs.impl;

import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.VertxFactory;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServer;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.HttpServerResponse;
import org.vertx.java.core.http.RouteMatcher;
import org.vertx.java.core.http.ServerWebSocket;
import org.vertx.java.core.http.impl.WebSocketMatcher;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.sockjs.EventBusBridge;
import org.vertx.java.core.sockjs.EventBusBridgeHook;
import org.vertx.java.core.sockjs.SockJSServer;
import org.vertx.java.core.sockjs.SockJSSocket;
import org.vertx.java.core.sockjs.impl.BaseTransport;
import org.vertx.java.core.sockjs.impl.EventSourceTransport;
import org.vertx.java.core.sockjs.impl.HtmlFileTransport;
import org.vertx.java.core.sockjs.impl.JsonPTransport;
import org.vertx.java.core.sockjs.impl.RawWebSocketTransport;
import org.vertx.java.core.sockjs.impl.Session;
import org.vertx.java.core.sockjs.impl.Transport;
import org.vertx.java.core.sockjs.impl.WebSocketTransport;
import org.vertx.java.core.sockjs.impl.XhrTransport;

public class DefaultSockJSServer
implements SockJSServer,
Handler<HttpServerRequest> {
    private static final Logger log = LoggerFactory.getLogger(DefaultSockJSServer.class);
    private final VertxInternal vertx;
    private RouteMatcher rm = new RouteMatcher();
    private WebSocketMatcher wsMatcher = new WebSocketMatcher();
    private final Map<String, Session> sessions;
    private EventBusBridgeHook hook;
    private static final String IFRAME_TEMPLATE = "<!DOCTYPE html>\n<html>\n<head>\n  <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\" />\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n  <script>\n    document.domain = document.domain;\n    _sockjs_onload = function(){SockJS.bootstrap_iframe();};\n  </script>\n  <script src=\"{{ sockjs_url }}\"></script>\n</head>\n<body>\n  <h2>Don't panic!</h2>\n  <p>This is a SockJS hidden iframe. It's used for cross domain magic.</p>\n</body>\n</html>";

    public DefaultSockJSServer(VertxInternal vertx, final HttpServer httpServer) {
        this.vertx = vertx;
        this.sessions = vertx.sharedData().getMap("_vertx.sockjssessions");
        this.rm.noMatch(httpServer.requestHandler());
        this.wsMatcher.noMatch(new Handler<WebSocketMatcher.Match>(){
            Handler<ServerWebSocket> wsHandler;
            {
                this.wsHandler = httpServer.websocketHandler();
            }

            @Override
            public void handle(WebSocketMatcher.Match match) {
                if (this.wsHandler != null) {
                    this.wsHandler.handle(match.ws);
                }
            }
        });
        httpServer.requestHandler(this);
        httpServer.websocketHandler(this.wsMatcher);
        vertx.setPeriodic(5000L, new Handler<Long>(){

            @Override
            public void handle(Long timerID) {
                if (httpServer.requestHandler() != DefaultSockJSServer.this) {
                    log.warn("You have overwritten the Http server request handler AFTER the SockJSServer has been created which will stop the SockJSServer from functioning. Make sure you set http request handler BEFORE you create the SockJSServer");
                }
            }
        });
    }

    @Override
    public void handle(HttpServerRequest req) {
        if (log.isTraceEnabled()) {
            log.trace("Got request in sockjs server: " + req.uri());
        }
        this.rm.handle(req);
    }

    private static JsonObject setDefaults(JsonObject config) {
        if ((config = config.copy()).getNumber("session_timeout") == null) {
            config.putNumber("session_timeout", 5000L);
        }
        if (config.getBoolean("insert_JSESSIONID") == null) {
            config.putBoolean("insert_JSESSIONID", true);
        }
        if (config.getNumber("heartbeat_period") == null) {
            config.putNumber("heartbeat_period", 25000L);
        }
        if (config.getNumber("max_bytes_streaming") == null) {
            config.putNumber("max_bytes_streaming", 131072);
        }
        if (config.getString("prefix") == null) {
            config.putString("prefix", "/");
        }
        if (config.getString("library_url") == null) {
            config.putString("library_url", "http://cdn.sockjs.org/sockjs-0.3.4.min.js");
        }
        if (config.getArray("disabled_transports") == null) {
            config.putArray("disabled_transports", new JsonArray());
        }
        return config;
    }

    @Override
    public SockJSServer setHook(EventBusBridgeHook hook) {
        this.hook = hook;
        return this;
    }

    @Override
    public SockJSServer installApp(JsonObject config, Handler<SockJSSocket> sockHandler) {
        String prefix = (config = DefaultSockJSServer.setDefaults(config)).getString("prefix");
        if (prefix == null || prefix.equals("") || prefix.endsWith("/")) {
            throw new IllegalArgumentException("Invalid prefix: " + prefix);
        }
        this.rm.getWithRegEx(prefix + "\\/?", new Handler<HttpServerRequest>(){

            @Override
            public void handle(HttpServerRequest req) {
                if (log.isTraceEnabled()) {
                    log.trace("Returning welcome response");
                }
                req.response().headers().set("Content-Type", "text/plain; charset=UTF-8");
                req.response().end("Welcome to SockJS!\n");
            }
        });
        String iframeHTML = IFRAME_TEMPLATE.replace("{{ sockjs_url }}", config.getString("library_url"));
        Handler<HttpServerRequest> iframeHandler = this.createIFrameHandler(iframeHTML);
        this.rm.getWithRegEx(prefix + "\\/iframe\\.html", iframeHandler);
        this.rm.getWithRegEx(prefix + "\\/iframe-[^\\/]*\\.html", iframeHandler);
        this.rm.postWithRegEx(prefix + "\\/chunking_test", this.createChunkingTestHandler());
        this.rm.optionsWithRegEx(prefix + "\\/chunking_test", BaseTransport.createCORSOptionsHandler(config, "OPTIONS, POST"));
        this.rm.getWithRegEx(prefix + "\\/info", BaseTransport.createInfoHandler(config));
        this.rm.optionsWithRegEx(prefix + "\\/info", BaseTransport.createCORSOptionsHandler(config, "OPTIONS, GET"));
        HashSet<String> enabledTransports = new HashSet<String>();
        enabledTransports.add(Transport.EVENT_SOURCE.toString());
        enabledTransports.add(Transport.HTML_FILE.toString());
        enabledTransports.add(Transport.JSON_P.toString());
        enabledTransports.add(Transport.WEBSOCKET.toString());
        enabledTransports.add(Transport.XHR.toString());
        for (Object tr : config.getArray("disabled_transports", new JsonArray())) {
            enabledTransports.remove(tr);
        }
        if (enabledTransports.contains(Transport.XHR.toString())) {
            new XhrTransport(this.vertx, this.rm, prefix, this.sessions, config, sockHandler);
        }
        if (enabledTransports.contains(Transport.EVENT_SOURCE.toString())) {
            new EventSourceTransport(this.vertx, this.rm, prefix, this.sessions, config, sockHandler);
        }
        if (enabledTransports.contains(Transport.HTML_FILE.toString())) {
            new HtmlFileTransport(this.vertx, this.rm, prefix, this.sessions, config, sockHandler);
        }
        if (enabledTransports.contains(Transport.JSON_P.toString())) {
            new JsonPTransport(this.vertx, this.rm, prefix, this.sessions, config, sockHandler);
        }
        if (enabledTransports.contains(Transport.WEBSOCKET.toString())) {
            new WebSocketTransport(this.vertx, this.wsMatcher, this.rm, prefix, this.sessions, config, sockHandler);
            new RawWebSocketTransport(this.vertx, this.wsMatcher, this.rm, prefix, sockHandler);
        }
        this.rm.getWithRegEx(prefix + "\\/.+", new Handler<HttpServerRequest>(){

            @Override
            public void handle(HttpServerRequest req) {
                if (log.isTraceEnabled()) {
                    log.trace("Request: " + req.uri() + " does not match, returning 404");
                }
                req.response().setStatusCode(404);
                req.response().end();
            }
        });
        return this;
    }

    @Override
    public SockJSServer bridge(JsonObject sjsConfig, JsonArray inboundPermitted, JsonArray outboundPermitted) {
        EventBusBridge busBridge = new EventBusBridge(this.vertx, inboundPermitted, outboundPermitted);
        if (this.hook != null) {
            busBridge.setHook(this.hook);
        }
        this.installApp(sjsConfig, busBridge);
        return this;
    }

    @Override
    public SockJSServer bridge(JsonObject sjsConfig, JsonArray inboundPermitted, JsonArray outboundPermitted, long authTimeout) {
        EventBusBridge busBridge = new EventBusBridge(this.vertx, inboundPermitted, outboundPermitted, authTimeout);
        if (this.hook != null) {
            busBridge.setHook(this.hook);
        }
        this.installApp(sjsConfig, busBridge);
        return this;
    }

    @Override
    public SockJSServer bridge(JsonObject sjsConfig, JsonArray inboundPermitted, JsonArray outboundPermitted, long authTimeout, String authAddress) {
        EventBusBridge busBridge = new EventBusBridge(this.vertx, inboundPermitted, outboundPermitted, authTimeout, authAddress);
        if (this.hook != null) {
            busBridge.setHook(this.hook);
        }
        this.installApp(sjsConfig, busBridge);
        return this;
    }

    private Handler<HttpServerRequest> createChunkingTestHandler() {
        return new Handler<HttpServerRequest>(){

            private void setTimeout(List<TimeoutInfo> timeouts, long delay, Buffer buff) {
                timeouts.add(new TimeoutInfo(delay, buff));
            }

            private void runTimeouts(List<TimeoutInfo> timeouts, HttpServerResponse response) {
                Iterator<TimeoutInfo> iter = timeouts.iterator();
                this.nextTimeout(timeouts, iter, response);
            }

            private void nextTimeout(final List<TimeoutInfo> timeouts, final Iterator<TimeoutInfo> iter, final HttpServerResponse response) {
                if (iter.hasNext()) {
                    final TimeoutInfo timeout = iter.next();
                    DefaultSockJSServer.this.vertx.setTimer(timeout.timeout, new Handler<Long>(){

                        @Override
                        public void handle(Long id) {
                            response.write(timeout.buff);
                            this.nextTimeout(timeouts, iter, response);
                        }
                    });
                } else {
                    timeouts.clear();
                }
            }

            @Override
            public void handle(HttpServerRequest req) {
                req.response().headers().set("Content-Type", "application/javascript; charset=UTF-8");
                BaseTransport.setCORS(req);
                req.response().setChunked(true);
                Buffer h = new Buffer(2);
                h.appendString("h\n");
                Buffer hs = new Buffer(2050);
                for (int i = 0; i < 2048; ++i) {
                    hs.appendByte((byte)32);
                }
                hs.appendString("h\n");
                ArrayList<TimeoutInfo> timeouts = new ArrayList<TimeoutInfo>();
                this.setTimeout(timeouts, 0L, h);
                this.setTimeout(timeouts, 1L, hs);
                this.setTimeout(timeouts, 5L, h);
                this.setTimeout(timeouts, 25L, h);
                this.setTimeout(timeouts, 125L, h);
                this.setTimeout(timeouts, 625L, h);
                this.setTimeout(timeouts, 3125L, h);
                this.runTimeouts(timeouts, req.response());
            }

            class TimeoutInfo {
                final long timeout;
                final Buffer buff;

                TimeoutInfo(long timeout, Buffer buff) {
                    this.timeout = timeout;
                    this.buff = buff;
                }
            }
        };
    }

    private Handler<HttpServerRequest> createIFrameHandler(final String iframeHTML) {
        final String etag = DefaultSockJSServer.getMD5String(iframeHTML);
        return new Handler<HttpServerRequest>(){

            @Override
            public void handle(HttpServerRequest req) {
                try {
                    if (log.isTraceEnabled()) {
                        log.trace("In Iframe handler");
                    }
                    if (etag != null && etag.equals(req.headers().get("if-none-match"))) {
                        req.response().setStatusCode(304);
                        req.response().end();
                    } else {
                        req.response().headers().set("Content-Type", "text/html; charset=UTF-8");
                        req.response().headers().set("Cache-Control", "public,max-age=31536000");
                        long oneYear = 1471228928L;
                        String expires = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz").format(new Date(System.currentTimeMillis() + oneYear));
                        req.response().headers().set("Expires", expires);
                        req.response().headers().set("ETag", etag);
                        req.response().end(iframeHTML);
                    }
                }
                catch (Exception e) {
                    log.error("Failed to server iframe", e);
                }
            }
        };
    }

    private static String getMD5String(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytes = md.digest(str.getBytes("UTF-8"));
            StringBuilder sb = new StringBuilder();
            for (byte b : bytes) {
                sb.append(Integer.toHexString(b + 127));
            }
            return sb.toString();
        }
        catch (Exception e) {
            log.error("Failed to generate MD5 for iframe, If-None-Match headers will be ignored");
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        Vertx vertx = VertxFactory.newVertx();
        HttpServer httpServer = vertx.createHttpServer();
        DefaultSockJSServer sjsServer = (DefaultSockJSServer)vertx.createSockJSServer(httpServer);
        sjsServer.installTestApplications();
        httpServer.listen(8081);
        Thread.sleep(Long.MAX_VALUE);
    }

    public void installTestApplications() {
        this.installApp(new JsonObject().putString("prefix", "/echo").putNumber("max_bytes_streaming", 4096), new Handler<SockJSSocket>(){

            @Override
            public void handle(final SockJSSocket sock) {
                sock.dataHandler(new Handler<Buffer>(){

                    @Override
                    public void handle(Buffer buff) {
                        sock.write(buff);
                    }
                });
            }
        });
        this.installApp(new JsonObject().putString("prefix", "/close").putNumber("max_bytes_streaming", 4096), new Handler<SockJSSocket>(){

            @Override
            public void handle(SockJSSocket sock) {
                sock.close();
            }
        });
        JsonArray disabled = new JsonArray();
        disabled.add(Transport.WEBSOCKET.toString());
        this.installApp(new JsonObject().putString("prefix", "/disabled_websocket_echo").putNumber("max_bytes_streaming", 4096).putArray("disabled_transports", disabled), new Handler<SockJSSocket>(){

            @Override
            public void handle(final SockJSSocket sock) {
                sock.dataHandler(new Handler<Buffer>(){

                    @Override
                    public void handle(Buffer buff) {
                        sock.write(buff);
                    }
                });
            }
        });
        this.installApp(new JsonObject().putString("prefix", "/ticker").putNumber("max_bytes_streaming", 4096), new Handler<SockJSSocket>(){

            @Override
            public void handle(final SockJSSocket sock) {
                final long timerID = DefaultSockJSServer.this.vertx.setPeriodic(1000L, new Handler<Long>(){

                    @Override
                    public void handle(Long id) {
                        sock.write(new Buffer("tick!"));
                    }
                });
                sock.endHandler(new VoidHandler(){

                    @Override
                    public void handle() {
                        DefaultSockJSServer.this.vertx.cancelTimer(timerID);
                    }
                });
            }
        });
        this.installApp(new JsonObject().putString("prefix", "/amplify").putNumber("max_bytes_streaming", 4096), new Handler<SockJSSocket>(){

            @Override
            public void handle(final SockJSSocket sock) {
                sock.dataHandler(new Handler<Buffer>(){

                    @Override
                    public void handle(Buffer data) {
                        String str = data.toString();
                        int n = Integer.valueOf(str);
                        if (n < 0 || n > 19) {
                            n = 1;
                        }
                        int num = (int)Math.pow(2.0, n);
                        Buffer buff = new Buffer(num);
                        for (int i = 0; i < num; ++i) {
                            buff.appendByte((byte)120);
                        }
                        sock.write(buff);
                    }
                });
            }
        });
        this.installApp(new JsonObject().putString("prefix", "/broadcast").putNumber("max_bytes_streaming", 4096), new Handler<SockJSSocket>(){
            final Set<String> connections;
            {
                this.connections = DefaultSockJSServer.this.vertx.sharedData().getSet("conns");
            }

            @Override
            public void handle(final SockJSSocket sock) {
                this.connections.add(sock.writeHandlerID());
                sock.dataHandler(new Handler<Buffer>(){

                    @Override
                    public void handle(Buffer buffer) {
                        for (String actorID : connections) {
                            DefaultSockJSServer.this.vertx.eventBus().publish(actorID, buffer);
                        }
                    }
                });
                sock.endHandler(new VoidHandler(){

                    @Override
                    public void handle() {
                        connections.remove(sock.writeHandlerID());
                    }
                });
            }
        });
        this.installApp(new JsonObject().putString("prefix", "/cookie_needed_echo").putNumber("max_bytes_streaming", 4096).putBoolean("insert_JSESSIONID", true), new Handler<SockJSSocket>(){

            @Override
            public void handle(final SockJSSocket sock) {
                sock.dataHandler(new Handler<Buffer>(){

                    @Override
                    public void handle(Buffer buff) {
                        sock.write(buff);
                    }
                });
            }
        });
    }
}

