/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.http;

import io.fabric8.gateway.handlers.http.HttpGatewayHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.http.HttpServer;
import org.vertx.java.core.http.ServerWebSocket;

public class HttpGatewayServer {
    private static final transient Logger LOG = LoggerFactory.getLogger(HttpGatewayServer.class);
    private final Vertx vertx;
    private final HttpGatewayHandler handler;
    private final int port;
    private String host;
    private HttpServer server;
    private Handler<ServerWebSocket> websocketHandler;

    public HttpGatewayServer(Vertx vertx, HttpGatewayHandler handler, Handler<ServerWebSocket> websocketHandler, int port) {
        this.vertx = vertx;
        this.handler = handler;
        this.websocketHandler = websocketHandler;
        this.port = port;
    }

    public String toString() {
        return "HttpGatewayServer{port=" + this.port + ", host='" + this.host + '\'' + '}';
    }

    public void init() {
        this.server = this.vertx.createHttpServer();
        this.server.requestHandler((Handler)this.handler);
        if (this.websocketHandler != null) {
            this.server.setWebSocketSubProtocols(new String[]{"v10.stomp", "v11.stomp", "v12.stomp", "mqttv3.1", "mqttv3.1.1"});
            this.server.websocketHandler(this.websocketHandler);
        }
        if (this.host != null) {
            LOG.info("Listening on port " + this.port + " and host " + this.host);
            this.server = this.server.listen(this.port, this.host);
        } else {
            LOG.info("Listening on port " + this.port);
            this.server = this.server.listen(this.port);
        }
    }

    public void destroy() {
        this.server.close();
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Vertx getVertx() {
        return this.vertx;
    }
}

