/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl.ssl;

import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.apache.qpid.proton.engine.TransportException;
import org.apache.qpid.proton.engine.impl.ByteBufferUtils;
import org.apache.qpid.proton.engine.impl.TransportInput;
import org.apache.qpid.proton.engine.impl.TransportOutput;
import org.apache.qpid.proton.engine.impl.ssl.ProtonSslEngine;
import org.apache.qpid.proton.engine.impl.ssl.SslTransportWrapper;

public class SimpleSslTransportWrapper
implements SslTransportWrapper {
    private static final Logger _logger = Logger.getLogger(SimpleSslTransportWrapper.class.getName());
    private final ProtonSslEngine _sslEngine;
    private final TransportInput _underlyingInput;
    private final TransportOutput _underlyingOutput;
    private boolean _tail_closed = false;
    private final ByteBuffer _inputBuffer;
    private boolean _head_closed = true;
    private final ByteBuffer _outputBuffer;
    private final ByteBuffer _head;
    private final ByteBuffer _decodedInputBuffer;
    private ByteBuffer _readOnlyOutputBufferView;
    private String _cipherName;
    private String _protocolName;

    SimpleSslTransportWrapper(ProtonSslEngine sslEngine, TransportInput underlyingInput, TransportOutput underlyingOutput) {
        this._underlyingInput = underlyingInput;
        this._underlyingOutput = underlyingOutput;
        this._sslEngine = sslEngine;
        int effectiveAppBufferMax = this._sslEngine.getEffectiveApplicationBufferSize();
        int packetSize = this._sslEngine.getPacketBufferSize();
        this._inputBuffer = ByteBufferUtils.newWriteableBuffer(packetSize);
        this._outputBuffer = ByteBufferUtils.newWriteableBuffer(packetSize);
        this._head = this._outputBuffer.asReadOnlyBuffer();
        this._head.limit(0);
        this._decodedInputBuffer = ByteBufferUtils.newReadableBuffer(effectiveAppBufferMax);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Constructed " + this);
        }
    }

    private void unwrapInput() throws TransportException {
        try {
            SSLEngineResult.Status sslResultStatus;
            SSLEngineResult.HandshakeStatus handshakeStatus;
            boolean keepLooping = true;
            do {
                this._decodedInputBuffer.compact();
                SSLEngineResult result = this._sslEngine.unwrap(this._inputBuffer, this._decodedInputBuffer);
                this._decodedInputBuffer.flip();
                this.runDelegatedTasks(result);
                this.updateCipherAndProtocolName(result);
                this.logEngineClientModeAndResult(result, "input");
                sslResultStatus = result.getStatus();
                handshakeStatus = result.getHandshakeStatus();
                if (sslResultStatus != SSLEngineResult.Status.OK && sslResultStatus != SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                    throw new IllegalStateException("Unexpected SSL Engine state " + (Object)((Object)sslResultStatus));
                }
                if (result.bytesProduced() <= 0) continue;
                if (handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                    _logger.warning("WARN unexpectedly produced bytes for the underlying input when handshaking");
                }
                ByteBufferUtils.pourAll(this._decodedInputBuffer, this._underlyingInput);
            } while (keepLooping = handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && sslResultStatus != SSLEngineResult.Status.BUFFER_UNDERFLOW);
        }
        catch (SSLException e) {
            throw new TransportException("Problem during input. useClientMode: " + this._sslEngine.getUseClientMode(), e);
        }
    }

    private void wrapOutput() {
        boolean keepWrapping = this.hasSpaceForSslPacket(this._outputBuffer);
        while (keepWrapping) {
            int pending = this._underlyingOutput.pending();
            if (pending == -1) {
                this._head_closed = true;
                keepWrapping = false;
            }
            ByteBuffer clearOutputBuffer = this._underlyingOutput.head();
            try {
                if (clearOutputBuffer.hasRemaining()) {
                    SSLEngineResult result = this._sslEngine.wrap(clearOutputBuffer, this._outputBuffer);
                    this.logEngineClientModeAndResult(result, "output");
                    SSLEngineResult.Status sslResultStatus = result.getStatus();
                    if (sslResultStatus == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                        throw new IllegalStateException("Insufficient space to perform wrap into encoded output buffer. Buffer: " + this._outputBuffer);
                    }
                    if (sslResultStatus != SSLEngineResult.Status.OK) {
                        throw new RuntimeException("Unexpected SSLEngineResult status " + (Object)((Object)sslResultStatus));
                    }
                    this.runDelegatedTasks(result);
                    this.updateCipherAndProtocolName(result);
                    keepWrapping = result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && this.hasSpaceForSslPacket(this._outputBuffer);
                    continue;
                }
                keepWrapping = false;
            }
            catch (SSLException e) {
                throw new TransportException("Problem during output. useClientMode: " + this._sslEngine.getUseClientMode(), e);
            }
            finally {
                this._underlyingOutput.pop(clearOutputBuffer.position());
            }
        }
    }

    private boolean hasSpaceForSslPacket(ByteBuffer byteBuffer) {
        return byteBuffer.remaining() >= this._sslEngine.getPacketBufferSize();
    }

    @Override
    public String getCipherName() {
        return this._cipherName;
    }

    @Override
    public String getProtocolName() {
        return this._protocolName;
    }

    private void updateCipherAndProtocolName(SSLEngineResult result) {
        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            this._cipherName = this._sslEngine.getCipherSuite();
            this._protocolName = this._sslEngine.getProtocol();
        }
    }

    private void runDelegatedTasks(SSLEngineResult result) {
        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            Runnable runnable;
            while ((runnable = this._sslEngine.getDelegatedTask()) != null) {
                runnable.run();
            }
            SSLEngineResult.HandshakeStatus hsStatus = this._sslEngine.getHandshakeStatus();
            if (hsStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                throw new RuntimeException("handshake shouldn't need additional tasks");
            }
        }
    }

    private void logEngineClientModeAndResult(SSLEngineResult result, String direction) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "useClientMode = " + this._sslEngine.getUseClientMode() + " direction = " + direction + " " + this.resultToString(result));
        }
    }

    private String resultToString(SSLEngineResult result) {
        return "[SSLEngineResult status = " + (Object)((Object)result.getStatus()) + " handshakeStatus = " + (Object)((Object)result.getHandshakeStatus()) + " bytesConsumed = " + result.bytesConsumed() + " bytesProduced = " + result.bytesProduced() + "]";
    }

    @Override
    public int capacity() {
        if (this._tail_closed) {
            return -1;
        }
        return this._inputBuffer.remaining();
    }

    @Override
    public ByteBuffer tail() {
        if (this._tail_closed) {
            throw new TransportException("tail closed");
        }
        return this._inputBuffer;
    }

    @Override
    public void process() throws TransportException {
        if (this._tail_closed) {
            throw new TransportException("tail closed");
        }
        this._inputBuffer.flip();
        try {
            this.unwrapInput();
        }
        catch (TransportException e) {
            this._inputBuffer.position(this._inputBuffer.limit());
            this._tail_closed = true;
            throw e;
        }
        finally {
            this._inputBuffer.compact();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close_tail() {
        try {
            this._underlyingInput.close_tail();
        }
        finally {
            this._tail_closed = true;
        }
    }

    @Override
    public int pending() {
        this.wrapOutput();
        this._head.limit(this._outputBuffer.position());
        if (this._head_closed && this._outputBuffer.position() == 0) {
            return -1;
        }
        return this._outputBuffer.position();
    }

    @Override
    public ByteBuffer head() {
        this.pending();
        return this._head;
    }

    @Override
    public void pop(int bytes) {
        this._outputBuffer.flip();
        this._outputBuffer.position(bytes);
        this._outputBuffer.compact();
        this._head.position(0);
        this._head.limit(this._outputBuffer.position());
    }

    @Override
    public void close_head() {
        this._underlyingOutput.close_head();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SimpleSslTransportWrapper [sslEngine=").append(this._sslEngine).append(", inputBuffer=").append(this._inputBuffer).append(", outputBuffer=").append(this._outputBuffer).append(", decodedInputBuffer=").append(this._decodedInputBuffer).append(", cipherName=").append(this._cipherName).append(", protocolName=").append(this._protocolName).append("]");
        return builder.toString();
    }
}

