/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway;

import io.fabric8.gateway.ServiceDetails;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ServiceMap {
    private final ConcurrentMap<String, PathMap> map = new ConcurrentHashMap<String, PathMap>();

    public List<ServiceDetails> getServices(String path) {
        return this.getPathMap(path).getServices();
    }

    public List<String> getPaths() {
        return new ArrayList<String>(this.map.keySet());
    }

    public void serviceUpdated(String path, ServiceDetails service) {
        if (!service.getServices().isEmpty()) {
            this.getPathMap(path).update(service);
        }
    }

    public void serviceRemoved(String path, ServiceDetails service) {
        this.getPathMap(path).remove(service);
    }

    protected PathMap getPathMap(String path) {
        PathMap initial = new PathMap(path);
        PathMap answer = this.map.putIfAbsent(path, initial);
        if (answer == null) {
            answer = initial;
        }
        return answer;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.map.toString();
    }

    protected static class PathMap {
        private final String path;
        private final ConcurrentMap<String, Map<String, ServiceDetails>> pathMap = new ConcurrentHashMap<String, Map<String, ServiceDetails>>();

        public PathMap(String path) {
            this.path = path;
        }

        public List<ServiceDetails> getServices() {
            ArrayList<ServiceDetails> answer = new ArrayList<ServiceDetails>();
            for (Map containerMap : this.pathMap.values()) {
                answer.addAll(containerMap.values());
            }
            return answer;
        }

        public void update(ServiceDetails service) {
            ConcurrentHashMap<String, ServiceDetails> initial = new ConcurrentHashMap<String, ServiceDetails>();
            ConcurrentHashMap<String, ServiceDetails> containerMap = this.pathMap.putIfAbsent(service.getId(), initial);
            if (containerMap == null) {
                containerMap = initial;
            }
            containerMap.put(service.getContainer(), service);
        }

        public void remove(ServiceDetails service) {
            Map containerMap = (Map)this.pathMap.get(service.getId());
            if (containerMap != null) {
                containerMap.remove(service.getContainer());
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + this.pathMap.toString();
        }
    }
}

