/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.detecting.protocol.ssl;

import io.fabric8.gateway.SocketWrapper;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.streams.ReadStream;
import org.vertx.java.core.streams.WriteStream;

public class SslSocketWrapper
extends SocketWrapper
implements ReadStream<SslSocketWrapper>,
WriteStream<SslSocketWrapper> {
    private Handler<Void> plainDrainHandler;
    private final SocketWrapper next;
    private SSLEngine engine;
    private Handler<Throwable> plainExceptionHandler;
    private boolean failed = false;
    private Buffer encryptedReadBuffer;
    private boolean encryptedReadBufferUnderflow;
    private boolean encryptedReadEOF = false;
    private Buffer plainReadBuffer;
    private Handler<Void> plainEndHandler;
    private Handler<Buffer> plainDataHandler;
    private int readPaused = 0;
    private boolean writeOverflow;
    private Buffer plainWriteBuffer;
    private Buffer encryptedWriteBuffer;
    private final Handler<Void> drainHandler = new Handler<Void>(){

        public void handle(Void aVoid) {
            SslSocketWrapper.this.writeOverflow = false;
            SslSocketWrapper.this.pumpWrites();
        }
    };

    public void putBackHeader(Buffer buffer) {
        if (this.engine != null) {
            throw new IllegalStateException("putBackHeader must be called before init");
        }
        this.encryptedReadBuffer = buffer;
    }

    private void pumpReads() {
        this.pumpReads(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pumpReads(boolean allowHandshake) {
        boolean pump = true;
        while (pump) {
            pump = false;
            if (this.readPaused > 0 || this.failed) {
                return;
            }
            if (this.encryptedReadBuffer != null && this.plainReadBuffer == null && !this.encryptedReadBufferUnderflow) {
                ByteBuffer input = ByteBuffer.wrap(this.encryptedReadBuffer.getBytes());
                ByteBuffer output = ByteBuffer.allocate(this.engine.getSession().getApplicationBufferSize());
                try {
                    boolean done = false;
                    while (!done) {
                        done = true;
                        SSLEngineResult result = this.engine.unwrap(input, output);
                        block2 : switch (result.getStatus()) {
                            case CLOSED: {
                                this.engine.closeInbound();
                                break;
                            }
                            case BUFFER_UNDERFLOW: {
                                this.encryptedReadBufferUnderflow = true;
                                break;
                            }
                            case OK: {
                                switch (this.engine.getHandshakeStatus()) {
                                    case NEED_TASK: 
                                    case NEED_WRAP: {
                                        break block2;
                                    }
                                }
                                done = !input.hasRemaining();
                                break;
                            }
                            case BUFFER_OVERFLOW: {
                                throw new SSLException("BUFFER_OVERFLOW");
                            }
                        }
                        output.flip();
                        if (output.remaining() > 0) {
                            pump = true;
                            int len = output.remaining();
                            if (this.plainReadBuffer == null) {
                                this.plainReadBuffer = new Buffer(len);
                            }
                            this.plainReadBuffer.appendBytes(output.array(), output.arrayOffset() + output.position(), len);
                        }
                        output.clear();
                    }
                }
                catch (SSLException e) {
                    this.onFailure(e);
                    return;
                }
                finally {
                    int len = input.remaining();
                    if (len > 0) {
                        if (input.position() != 0) {
                            this.encryptedReadBuffer = new Buffer(len);
                            this.encryptedReadBuffer.appendBytes(input.array(), input.arrayOffset() + input.position(), len);
                        }
                    } else {
                        this.encryptedReadBuffer = null;
                    }
                }
            }
            if (this.plainReadBuffer != null && this.readPaused == 0) {
                pump = true;
                Buffer data = this.plainReadBuffer;
                this.plainReadBuffer = null;
                Handler<Buffer> handler = this.plainDataHandler;
                if (handler != null) {
                    handler.handle((Object)data);
                }
            }
            if (this.encryptedReadBuffer == null && this.plainReadBuffer == null && this.encryptedReadEOF) {
                this.encryptedReadEOF = false;
                Handler<Void> handler = this.plainEndHandler;
                if (handler != null) {
                    handler.handle(null);
                }
            }
            if (this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) continue;
            if (allowHandshake) {
                this.handshake();
            }
            return;
        }
    }

    public SslSocketWrapper dataHandler(Handler<Buffer> handler) {
        if (this.plainDataHandler != null && handler == null) {
            this.pause();
        }
        boolean needsResume = this.plainDataHandler == null && handler != null;
        this.plainDataHandler = handler;
        if (needsResume) {
            this.resume();
        }
        return this;
    }

    public SslSocketWrapper endHandler(Handler<Void> voidHandler) {
        this.plainEndHandler = voidHandler;
        return this;
    }

    public SslSocketWrapper pause() {
        ++this.readPaused;
        if (this.readPaused == 1) {
            this.next.readStream().pause();
        }
        return this;
    }

    public SslSocketWrapper resume() {
        --this.readPaused;
        if (this.readPaused == 0) {
            this.next.readStream().resume();
        }
        this.pumpReads();
        return this;
    }

    public SslSocketWrapper exceptionHandler(Handler<Throwable> throwableHandler) {
        this.plainExceptionHandler = throwableHandler;
        return this;
    }

    public SslSocketWrapper drainHandler(Handler<Void> voidHandler) {
        this.plainDrainHandler = voidHandler;
        return this;
    }

    public boolean writeQueueFull() {
        return this.plainWriteBuffer != null;
    }

    public SslSocketWrapper write(Buffer buffer) {
        if (this.plainWriteBuffer == null) {
            this.plainWriteBuffer = buffer;
        } else {
            this.plainWriteBuffer.appendBuffer(buffer);
        }
        this.pumpWrites();
        return this;
    }

    public SslSocketWrapper setWriteQueueMaxSize(int i) {
        return this;
    }

    private void pumpWrites() {
        this.pumpWrites(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pumpWrites(boolean allowHandshake) {
        boolean pump = true;
        while (pump) {
            pump = false;
            if (this.failed) {
                return;
            }
            if (this.plainWriteBuffer != null) {
                ByteBuffer input = ByteBuffer.wrap(this.plainWriteBuffer.getBytes());
                ByteBuffer output = ByteBuffer.allocate(this.engine.getSession().getPacketBufferSize());
                try {
                    boolean done = false;
                    while (!done) {
                        done = true;
                        SSLEngineResult result = this.engine.wrap(input, output);
                        block2 : switch (result.getStatus()) {
                            case OK: {
                                switch (this.engine.getHandshakeStatus()) {
                                    case NEED_TASK: 
                                    case NEED_UNWRAP: {
                                        break block2;
                                    }
                                }
                                done = !input.hasRemaining();
                                break;
                            }
                            case CLOSED: {
                                throw new SSLException("CLOSED");
                            }
                            case BUFFER_UNDERFLOW: {
                                break;
                            }
                            case BUFFER_OVERFLOW: {
                                done = false;
                            }
                        }
                        output.flip();
                        int len = output.remaining();
                        if (len > 0) {
                            pump = true;
                            if (this.encryptedWriteBuffer == null) {
                                this.encryptedWriteBuffer = new Buffer(len);
                            }
                            this.encryptedWriteBuffer.appendBytes(output.array(), output.arrayOffset() + output.position(), len);
                        }
                        output.clear();
                    }
                }
                catch (SSLException e) {
                    this.onFailure(e);
                    return;
                }
                finally {
                    int len = input.remaining();
                    if (len > 0) {
                        if (input.position() != 0) {
                            this.plainWriteBuffer = new Buffer(len);
                            this.plainWriteBuffer.appendBytes(input.array(), input.arrayOffset() + input.position(), len);
                        }
                    } else {
                        this.plainWriteBuffer = null;
                    }
                }
            }
            if (this.encryptedWriteBuffer != null && !this.writeOverflow) {
                if (this.next.writeStream().writeQueueFull()) {
                    this.writeOverflow = true;
                    this.next.writeStream().drainHandler(this.drainHandler);
                } else {
                    pump = true;
                    Buffer data = this.encryptedWriteBuffer;
                    this.encryptedWriteBuffer = null;
                    this.next.writeStream().write(data);
                }
            }
            if (this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) continue;
            if (allowHandshake) {
                this.handshake();
            }
            return;
        }
    }

    public ReadStream readStream() {
        return this;
    }

    public WriteStream writeStream() {
        return this;
    }

    @Override
    public void close() {
        this.next.close();
    }

    @Override
    public InetSocketAddress localAddress() {
        return this.next.localAddress();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return this.next.remoteAddress();
    }

    @Override
    public Object stream() {
        return this;
    }

    public SslSocketWrapper(SocketWrapper plainWrapper) {
        this.next = plainWrapper;
        this.pause();
    }

    public void initClient(SSLContext sslContext, String host, int port, String disabledCypherSuites, String enabledCipherSuites) {
        assert (this.engine == null);
        this.engine = sslContext.createSSLEngine(host, port);
        this.engine.setUseClientMode(true);
        this.initCipherSuites(disabledCypherSuites, enabledCipherSuites);
        this.init();
    }

    public void initServer(SSLContext sslContext, ClientAuth clientAuth, String disabledCypherSuites, String enabledCipherSuites) {
        assert (this.engine == null);
        this.engine = sslContext.createSSLEngine();
        this.engine.setUseClientMode(false);
        switch (clientAuth) {
            case WANT: {
                this.engine.setWantClientAuth(true);
                break;
            }
            case NEED: {
                this.engine.setNeedClientAuth(true);
                break;
            }
            case NONE: {
                this.engine.setWantClientAuth(false);
            }
        }
        this.initCipherSuites(disabledCypherSuites, enabledCipherSuites);
        this.init();
    }

    private void initCipherSuites(String disabledCypherSuites, String enabledCipherSuites) {
        if (enabledCipherSuites != null) {
            this.engine.setEnabledCipherSuites(SslSocketWrapper.splitOnCommas(enabledCipherSuites));
        } else {
            this.engine.setEnabledCipherSuites(this.engine.getSupportedCipherSuites());
        }
        if (disabledCypherSuites != null) {
            String[] disabledList = SslSocketWrapper.splitOnCommas(disabledCypherSuites);
            ArrayList<String> enabled = new ArrayList<String>();
            for (String suite : this.engine.getEnabledCipherSuites()) {
                boolean add = true;
                for (String disabled : disabledList) {
                    if (!suite.contains(disabled)) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                enabled.add(suite);
            }
            this.engine.setEnabledCipherSuites(enabled.toArray(new String[enabled.size()]));
        }
    }

    private void init() {
        this.next.readStream().dataHandler((Handler)new Handler<Buffer>(){

            public void handle(Buffer buffer) {
                if (SslSocketWrapper.this.encryptedReadBuffer == null) {
                    SslSocketWrapper.this.encryptedReadBuffer = buffer;
                } else {
                    SslSocketWrapper.this.encryptedReadBuffer.appendBuffer(buffer);
                }
                SslSocketWrapper.this.encryptedReadBufferUnderflow = false;
                SslSocketWrapper.this.pumpReads();
            }
        });
        this.next.readStream().endHandler((Handler)new Handler<Void>(){

            public void handle(Void x) {
                SslSocketWrapper.this.encryptedReadEOF = true;
            }
        });
        this.next.readStream().exceptionHandler((Handler)new Handler<Throwable>(){

            public void handle(Throwable error) {
                SslSocketWrapper.this.onFailure(error);
            }
        });
    }

    private static String[] splitOnCommas(String value) {
        ArrayList<String> rc = new ArrayList<String>();
        for (String x : value.split(",")) {
            rc.add(x.trim());
        }
        return rc.toArray(new String[rc.size()]);
    }

    public void handshake() {
        if (this.failed) {
            return;
        }
        try {
            block11: while (true) {
                SSLEngineResult.HandshakeStatus status = this.engine.getHandshakeStatus();
                switch (status) {
                    case FINISHED: 
                    case NOT_HANDSHAKING: {
                        return;
                    }
                    case NEED_TASK: {
                        Runnable task = this.engine.getDelegatedTask();
                        if (task == null) continue block11;
                        task.run();
                        continue block11;
                    }
                    case NEED_WRAP: {
                        if (this.plainWriteBuffer == null) {
                            this.plainWriteBuffer = new Buffer();
                        }
                        this.pumpWrites(false);
                        continue block11;
                    }
                    case NEED_UNWRAP: {
                        if (this.encryptedReadBuffer != null) {
                            this.pumpReads(false);
                            continue block11;
                        }
                        return;
                    }
                }
                System.err.println("Unexpected ssl engine handshake status: " + (Object)((Object)status));
            }
        }
        finally {
            SSLEngineResult.HandshakeStatus status = this.engine.getHandshakeStatus();
            if (status == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                this.pumpWrites(false);
                this.pumpReads(false);
            }
        }
    }

    private void onFailure(Throwable error) {
        this.failed = true;
        Handler<Throwable> handler = this.plainExceptionHandler;
        if (handler != null) {
            handler.handle((Object)error);
        }
    }

    public static enum ClientAuth {
        WANT,
        NEED,
        NONE;

    }
}

