/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.impl;

import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.proton.ProtonUnsupportedOperationException;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Decimal128;
import org.apache.qpid.proton.amqp.Decimal32;
import org.apache.qpid.proton.amqp.Decimal64;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.UnsignedShort;
import org.apache.qpid.proton.codec.Data;
import org.apache.qpid.proton.codec.impl.ArrayElement;
import org.apache.qpid.proton.codec.impl.BinaryElement;
import org.apache.qpid.proton.codec.impl.BooleanElement;
import org.apache.qpid.proton.codec.impl.ByteElement;
import org.apache.qpid.proton.codec.impl.CharElement;
import org.apache.qpid.proton.codec.impl.DataDecoder;
import org.apache.qpid.proton.codec.impl.Decimal128Element;
import org.apache.qpid.proton.codec.impl.Decimal32Element;
import org.apache.qpid.proton.codec.impl.Decimal64Element;
import org.apache.qpid.proton.codec.impl.DescribedTypeElement;
import org.apache.qpid.proton.codec.impl.DoubleElement;
import org.apache.qpid.proton.codec.impl.Element;
import org.apache.qpid.proton.codec.impl.FloatElement;
import org.apache.qpid.proton.codec.impl.IntegerElement;
import org.apache.qpid.proton.codec.impl.ListElement;
import org.apache.qpid.proton.codec.impl.LongElement;
import org.apache.qpid.proton.codec.impl.MapElement;
import org.apache.qpid.proton.codec.impl.NullElement;
import org.apache.qpid.proton.codec.impl.ShortElement;
import org.apache.qpid.proton.codec.impl.StringElement;
import org.apache.qpid.proton.codec.impl.SymbolElement;
import org.apache.qpid.proton.codec.impl.TimestampElement;
import org.apache.qpid.proton.codec.impl.UUIDElement;
import org.apache.qpid.proton.codec.impl.UnsignedByteElement;
import org.apache.qpid.proton.codec.impl.UnsignedIntegerElement;
import org.apache.qpid.proton.codec.impl.UnsignedLongElement;
import org.apache.qpid.proton.codec.impl.UnsignedShortElement;

public class DataImpl
implements Data {
    private Element _first;
    private Element _current;
    private Element _parent;

    @Override
    public void free() {
        this._first = null;
        this._current = null;
    }

    @Override
    public void clear() {
        this._first = null;
        this._current = null;
        this._parent = null;
    }

    @Override
    public long size() {
        return this._first == null ? 0L : (long)this._first.size();
    }

    @Override
    public void rewind() {
        this._current = null;
        this._parent = null;
    }

    @Override
    public Data.DataType next() {
        Element next;
        Element element = this._current == null ? (this._parent == null ? this._first : this._parent.child()) : (next = this._current.next());
        if (next != null) {
            this._current = next;
        }
        return next == null ? null : next.getDataType();
    }

    @Override
    public Data.DataType prev() {
        Element prev;
        this._current = prev = this._current == null ? null : this._current.prev();
        return prev == null ? null : prev.getDataType();
    }

    @Override
    public boolean enter() {
        if (this._current != null && this._current.canEnter()) {
            this._parent = this._current;
            this._current = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean exit() {
        if (this._parent != null) {
            Element parent;
            this._current = parent = this._parent;
            this._parent = this._current.parent();
            return true;
        }
        return false;
    }

    @Override
    public boolean lookup(String name) {
        throw new ProtonUnsupportedOperationException();
    }

    @Override
    public Data.DataType type() {
        return this._current == null ? null : this._current.getDataType();
    }

    @Override
    public Binary encode() {
        int size = 0;
        for (Element elt = this._first; elt != null; elt = elt.next()) {
            size += elt.size();
        }
        byte[] data = new byte[size];
        ByteBuffer buf = ByteBuffer.wrap(data);
        this.encode(buf);
        return new Binary(data);
    }

    @Override
    public long encode(ByteBuffer buf) {
        int size = 0;
        for (Element elt = this._first; elt != null; elt = elt.next()) {
            int eltSize = elt.size();
            if (eltSize <= buf.remaining()) {
                size += elt.encode(buf);
                continue;
            }
            size += eltSize;
        }
        return size;
    }

    @Override
    public long decode(ByteBuffer buf) {
        return DataDecoder.decode(buf, this);
    }

    private void putElement(Element element) {
        if (this._first == null) {
            this._first = element;
        } else if (this._current == null) {
            element = this._parent.addChild(element);
        } else {
            if (this._parent != null) {
                element = this._parent.checkChild(element);
            }
            this._current.setNext(element);
        }
        this._current = element;
    }

    @Override
    public void putList() {
        this.putElement(new ListElement(this._parent, this._current));
    }

    @Override
    public void putMap() {
        this.putElement(new MapElement(this._parent, this._current));
    }

    @Override
    public void putArray(boolean described, Data.DataType type) {
        this.putElement(new ArrayElement(this._parent, this._current, described, type));
    }

    @Override
    public void putDescribed() {
        this.putElement(new DescribedTypeElement(this._parent, this._current));
    }

    @Override
    public void putNull() {
        this.putElement(new NullElement(this._parent, this._current));
    }

    @Override
    public void putBoolean(boolean b) {
        this.putElement(new BooleanElement(this._parent, this._current, b));
    }

    @Override
    public void putUnsignedByte(UnsignedByte ub) {
        this.putElement(new UnsignedByteElement(this._parent, this._current, ub));
    }

    @Override
    public void putByte(byte b) {
        this.putElement(new ByteElement(this._parent, this._current, b));
    }

    @Override
    public void putUnsignedShort(UnsignedShort us) {
        this.putElement(new UnsignedShortElement(this._parent, this._current, us));
    }

    @Override
    public void putShort(short s) {
        this.putElement(new ShortElement(this._parent, this._current, s));
    }

    @Override
    public void putUnsignedInteger(UnsignedInteger ui) {
        this.putElement(new UnsignedIntegerElement(this._parent, this._current, ui));
    }

    @Override
    public void putInt(int i) {
        this.putElement(new IntegerElement(this._parent, this._current, i));
    }

    @Override
    public void putChar(int c) {
        this.putElement(new CharElement(this._parent, this._current, c));
    }

    @Override
    public void putUnsignedLong(UnsignedLong ul) {
        this.putElement(new UnsignedLongElement(this._parent, this._current, ul));
    }

    @Override
    public void putLong(long l) {
        this.putElement(new LongElement(this._parent, this._current, l));
    }

    @Override
    public void putTimestamp(Date t) {
        this.putElement(new TimestampElement(this._parent, this._current, t));
    }

    @Override
    public void putFloat(float f) {
        this.putElement(new FloatElement(this._parent, this._current, f));
    }

    @Override
    public void putDouble(double d) {
        this.putElement(new DoubleElement(this._parent, this._current, d));
    }

    @Override
    public void putDecimal32(Decimal32 d) {
        this.putElement(new Decimal32Element(this._parent, this._current, d));
    }

    @Override
    public void putDecimal64(Decimal64 d) {
        this.putElement(new Decimal64Element(this._parent, this._current, d));
    }

    @Override
    public void putDecimal128(Decimal128 d) {
        this.putElement(new Decimal128Element(this._parent, this._current, d));
    }

    @Override
    public void putUUID(UUID u) {
        this.putElement(new UUIDElement(this._parent, this._current, u));
    }

    @Override
    public void putBinary(Binary bytes) {
        this.putElement(new BinaryElement(this._parent, this._current, bytes));
    }

    @Override
    public void putBinary(byte[] bytes) {
        this.putBinary(new Binary(bytes));
    }

    @Override
    public void putString(String string) {
        this.putElement(new StringElement(this._parent, this._current, string));
    }

    @Override
    public void putSymbol(Symbol symbol) {
        this.putElement(new SymbolElement(this._parent, this._current, symbol));
    }

    @Override
    public void putObject(Object o) {
        if (o == null) {
            this.putNull();
        } else if (o instanceof Boolean) {
            this.putBoolean((Boolean)o);
        } else if (o instanceof UnsignedByte) {
            this.putUnsignedByte((UnsignedByte)o);
        } else if (o instanceof Byte) {
            this.putByte((Byte)o);
        } else if (o instanceof UnsignedShort) {
            this.putUnsignedShort((UnsignedShort)o);
        } else if (o instanceof Short) {
            this.putShort((Short)o);
        } else if (o instanceof UnsignedInteger) {
            this.putUnsignedInteger((UnsignedInteger)o);
        } else if (o instanceof Integer) {
            this.putInt((Integer)o);
        } else if (o instanceof Character) {
            this.putChar(((Character)o).charValue());
        } else if (o instanceof UnsignedLong) {
            this.putUnsignedLong((UnsignedLong)o);
        } else if (o instanceof Long) {
            this.putLong((Long)o);
        } else if (o instanceof Date) {
            this.putTimestamp((Date)o);
        } else if (o instanceof Float) {
            this.putFloat(((Float)o).floatValue());
        } else if (o instanceof Double) {
            this.putDouble((Double)o);
        } else if (o instanceof Decimal32) {
            this.putDecimal32((Decimal32)o);
        } else if (o instanceof Decimal64) {
            this.putDecimal64((Decimal64)o);
        } else if (o instanceof Decimal128) {
            this.putDecimal128((Decimal128)o);
        } else if (o instanceof UUID) {
            this.putUUID((UUID)o);
        } else if (o instanceof Binary) {
            this.putBinary((Binary)o);
        } else if (o instanceof String) {
            this.putString((String)o);
        } else if (o instanceof Symbol) {
            this.putSymbol((Symbol)o);
        } else if (o instanceof DescribedType) {
            this.putDescribedType((DescribedType)o);
        } else if (o instanceof Object[]) {
            this.putJavaArray((Object[])o);
        } else if (o instanceof List) {
            this.putJavaList((List)o);
        } else if (o instanceof Map) {
            this.putJavaMap((Map)o);
        } else {
            throw new IllegalArgumentException("Unknown type " + o.getClass().getSimpleName());
        }
    }

    @Override
    public void putJavaMap(Map<Object, Object> map) {
        this.putMap();
        this.enter();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            this.putObject(entry.getKey());
            this.putObject(entry.getValue());
        }
        this.exit();
    }

    @Override
    public void putJavaList(List<Object> list) {
        this.putList();
        this.enter();
        for (Object o : list) {
            this.putObject(o);
        }
        this.exit();
    }

    @Override
    public void putJavaArray(Object[] array) {
        throw new ProtonUnsupportedOperationException();
    }

    @Override
    public void putDescribedType(DescribedType dt) {
        this.putElement(new DescribedTypeElement(this._parent, this._current));
        this.enter();
        this.putObject(dt.getDescriptor());
        this.putObject(dt.getDescribed());
        this.exit();
    }

    @Override
    public long getList() {
        if (this._current instanceof ListElement) {
            return ((ListElement)this._current).count();
        }
        throw new IllegalStateException("Current value not list");
    }

    @Override
    public long getMap() {
        if (this._current instanceof MapElement) {
            return ((MapElement)this._current).count();
        }
        throw new IllegalStateException("Current value not map");
    }

    @Override
    public long getArray() {
        if (this._current instanceof ArrayElement) {
            return ((ArrayElement)this._current).count();
        }
        throw new IllegalStateException("Current value not array");
    }

    @Override
    public boolean isArrayDescribed() {
        if (this._current instanceof ArrayElement) {
            return ((ArrayElement)this._current).isDescribed();
        }
        throw new IllegalStateException("Current value not array");
    }

    @Override
    public Data.DataType getArrayType() {
        if (this._current instanceof ArrayElement) {
            return ((ArrayElement)this._current).getArrayDataType();
        }
        throw new IllegalStateException("Current value not array");
    }

    @Override
    public boolean isDescribed() {
        return this._current != null && this._current.getDataType() == Data.DataType.DESCRIBED;
    }

    @Override
    public boolean isNull() {
        return this._current != null && this._current.getDataType() == Data.DataType.NULL;
    }

    @Override
    public boolean getBoolean() {
        if (this._current instanceof BooleanElement) {
            return ((BooleanElement)this._current).getValue();
        }
        throw new IllegalStateException("Current value not boolean");
    }

    @Override
    public UnsignedByte getUnsignedByte() {
        if (this._current instanceof UnsignedByteElement) {
            return ((UnsignedByteElement)this._current).getValue();
        }
        throw new IllegalStateException("Current value not unsigned byte");
    }

    @Override
    public byte getByte() {
        if (this._current instanceof ByteElement) {
            return ((ByteElement)this._current).getValue();
        }
        throw new IllegalStateException("Current value not byte");
    }

    @Override
    public UnsignedShort getUnsignedShort() {
        if (this._current instanceof UnsignedShortElement) {
            return ((UnsignedShortElement)this._current).getValue();
        }
        throw new IllegalStateException("Current value not unsigned short");
    }

    @Override
    public short getShort() {
        if (this._current instanceof ShortElement) {
            return ((ShortElement)this._current).getValue();
        }
        throw new IllegalStateException("Current value not short");
    }

    @Override
    public UnsignedInteger getUnsignedInteger() {
        if (this._current instanceof UnsignedIntegerElement) {
            return ((UnsignedIntegerElement)this._current).getValue();
        }
        throw new IllegalStateException("Current value not unsigned integer");
    }

    @Override
    public int getInt() {
        if (this._current instanceof IntegerElement) {
            return ((IntegerElement)this._current).getValue();
        }
        throw new IllegalStateException("Current value not integer");
    }

    @Override
    public int getChar() {
        if (this._current instanceof CharElement) {
            return ((CharElement)this._current).getValue();
        }
        throw new IllegalStateException("Current value not char");
    }

    @Override
    public UnsignedLong getUnsignedLong() {
        if (this._current instanceof UnsignedLongElement) {
            return ((UnsignedLongElement)this._current).getValue();
        }
        throw new IllegalStateException("Current value not unsigned long");
    }

    @Override
    public long getLong() {
        if (this._current instanceof LongElement) {
            return ((LongElement)this._current).getValue();
        }
        throw new IllegalStateException("Current value not long");
    }

    @Override
    public Date getTimestamp() {
        if (this._current instanceof TimestampElement) {
            return ((TimestampElement)this._current).getValue();
        }
        throw new IllegalStateException("Current value not timestamp");
    }

    @Override
    public float getFloat() {
        if (this._current instanceof FloatElement) {
            return ((FloatElement)this._current).getValue().floatValue();
        }
        throw new IllegalStateException("Current value not float");
    }

    @Override
    public double getDouble() {
        if (this._current instanceof DoubleElement) {
            return ((DoubleElement)this._current).getValue();
        }
        throw new IllegalStateException("Current value not double");
    }

    @Override
    public Decimal32 getDecimal32() {
        if (this._current instanceof Decimal32Element) {
            return ((Decimal32Element)this._current).getValue();
        }
        throw new IllegalStateException("Current value not decimal32");
    }

    @Override
    public Decimal64 getDecimal64() {
        if (this._current instanceof Decimal64Element) {
            return ((Decimal64Element)this._current).getValue();
        }
        throw new IllegalStateException("Current value not decimal32");
    }

    @Override
    public Decimal128 getDecimal128() {
        if (this._current instanceof Decimal128Element) {
            return ((Decimal128Element)this._current).getValue();
        }
        throw new IllegalStateException("Current value not decimal32");
    }

    @Override
    public UUID getUUID() {
        if (this._current instanceof UUIDElement) {
            return ((UUIDElement)this._current).getValue();
        }
        throw new IllegalStateException("Current value not uuid");
    }

    @Override
    public Binary getBinary() {
        if (this._current instanceof BinaryElement) {
            return ((BinaryElement)this._current).getValue();
        }
        throw new IllegalStateException("Current value not binary");
    }

    @Override
    public String getString() {
        if (this._current instanceof StringElement) {
            return ((StringElement)this._current).getValue();
        }
        throw new IllegalStateException("Current value not string");
    }

    @Override
    public Symbol getSymbol() {
        if (this._current instanceof SymbolElement) {
            return ((SymbolElement)this._current).getValue();
        }
        throw new IllegalStateException("Current value not symbol");
    }

    @Override
    public Object getObject() {
        return this._current.getValue();
    }

    @Override
    public Map<Object, Object> getJavaMap() {
        if (this._current instanceof MapElement) {
            return ((MapElement)this._current).getValue();
        }
        throw new IllegalStateException("Current value not map");
    }

    @Override
    public List<Object> getJavaList() {
        if (this._current instanceof ListElement) {
            return ((ListElement)this._current).getValue();
        }
        throw new IllegalStateException("Current value not list");
    }

    @Override
    public Object[] getJavaArray() {
        if (this._current instanceof ArrayElement) {
            return ((ArrayElement)this._current).getValue();
        }
        throw new IllegalStateException("Current value not array");
    }

    @Override
    public DescribedType getDescribedType() {
        if (this._current instanceof DescribedTypeElement) {
            return ((DescribedTypeElement)this._current).getValue();
        }
        throw new IllegalStateException("Current value not described type");
    }

    @Override
    public void copy(Data src) {
        throw new ProtonUnsupportedOperationException();
    }

    @Override
    public void append(Data src) {
        throw new ProtonUnsupportedOperationException();
    }

    @Override
    public void appendn(Data src, int limit) {
        throw new ProtonUnsupportedOperationException();
    }

    @Override
    public void narrow() {
        throw new ProtonUnsupportedOperationException();
    }

    @Override
    public void widen() {
        throw new ProtonUnsupportedOperationException();
    }
}

