/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.transport.Disposition;
import org.apache.qpid.proton.amqp.transport.Flow;
import org.apache.qpid.proton.amqp.transport.Role;
import org.apache.qpid.proton.amqp.transport.Transfer;
import org.apache.qpid.proton.engine.impl.DeliveryImpl;
import org.apache.qpid.proton.engine.impl.ReceiverImpl;
import org.apache.qpid.proton.engine.impl.SessionImpl;
import org.apache.qpid.proton.engine.impl.TransportDelivery;
import org.apache.qpid.proton.engine.impl.TransportImpl;
import org.apache.qpid.proton.engine.impl.TransportLink;
import org.apache.qpid.proton.engine.impl.TransportReceiver;

class TransportSession {
    private final TransportImpl _transport;
    private final SessionImpl _session;
    private int _localChannel = -1;
    private int _remoteChannel = -1;
    private boolean _openSent;
    private UnsignedInteger _handleMax = UnsignedInteger.valueOf(1024);
    private UnsignedInteger _outgoingDeliveryId = UnsignedInteger.ZERO;
    private UnsignedInteger _incomingWindowSize = UnsignedInteger.ZERO;
    private UnsignedInteger _outgoingWindowSize = UnsignedInteger.ZERO;
    private UnsignedInteger _nextOutgoingId = UnsignedInteger.ONE;
    private UnsignedInteger _nextIncomingId = null;
    private TransportLink[] _remoteHandleMap = new TransportLink[1024];
    private TransportLink[] _localHandleMap = new TransportLink[1024];
    private Map<String, TransportLink> _halfOpenLinks = new HashMap<String, TransportLink>();
    private UnsignedInteger _incomingDeliveryId = null;
    private UnsignedInteger _remoteIncomingWindow;
    private UnsignedInteger _remoteOutgoingWindow;
    private UnsignedInteger _remoteNextIncomingId = this._nextOutgoingId;
    private UnsignedInteger _remoteNextOutgoingId;
    private Map<UnsignedInteger, DeliveryImpl> _unsettledIncomingDeliveriesById = new HashMap<UnsignedInteger, DeliveryImpl>();
    private Map<UnsignedInteger, DeliveryImpl> _unsettledOutgoingDeliveriesById = new HashMap<UnsignedInteger, DeliveryImpl>();
    private int _unsettledIncomingSize;
    private boolean _endReceived;
    private boolean _beginSent;

    TransportSession(TransportImpl transport, SessionImpl session) {
        this._transport = transport;
        this._session = session;
    }

    public SessionImpl getSession() {
        return this._session;
    }

    public int getLocalChannel() {
        return this._localChannel;
    }

    public void setLocalChannel(int localChannel) {
        this._localChannel = localChannel;
    }

    public int getRemoteChannel() {
        return this._remoteChannel;
    }

    public void setRemoteChannel(int remoteChannel) {
        this._remoteChannel = remoteChannel;
    }

    public boolean isOpenSent() {
        return this._openSent;
    }

    public void setOpenSent(boolean openSent) {
        this._openSent = openSent;
    }

    public boolean isRemoteChannelSet() {
        return this._remoteChannel != -1;
    }

    public boolean isLocalChannelSet() {
        return this._localChannel != -1;
    }

    public void unsetLocalChannel() {
        this._localChannel = -1;
    }

    public void unsetRemoteChannel() {
        this._remoteChannel = -1;
    }

    public UnsignedInteger getHandleMax() {
        return this._handleMax;
    }

    public UnsignedInteger getIncomingWindowSize() {
        return this._incomingWindowSize;
    }

    public void updateWindows() {
        int size = this._transport.getMaxFrameSize();
        this._incomingWindowSize = size <= 0 ? UnsignedInteger.valueOf(Integer.MAX_VALUE) : UnsignedInteger.valueOf((this._session.getIncomingCapacity() - this._session.getIncomingBytes()) / size);
        int outgoingDeliveries = this._session.getOutgoingDeliveries();
        if (size <= 0) {
            this._outgoingWindowSize = UnsignedInteger.valueOf(outgoingDeliveries);
        } else {
            int outgoingBytes = this._session.getOutgoingBytes();
            int frames = outgoingBytes / size;
            if (outgoingBytes % size > 0) {
                ++frames;
            }
            this._outgoingWindowSize = frames > outgoingDeliveries ? UnsignedInteger.valueOf(frames) : UnsignedInteger.valueOf(outgoingDeliveries);
        }
    }

    public UnsignedInteger getOutgoingDeliveryId() {
        return this._outgoingDeliveryId;
    }

    void incrementOutgoingDeliveryId() {
        this._outgoingDeliveryId = this._outgoingDeliveryId.add(UnsignedInteger.ONE);
    }

    public UnsignedInteger getOutgoingWindowSize() {
        return this._outgoingWindowSize;
    }

    public UnsignedInteger getNextOutgoingId() {
        return this._nextOutgoingId;
    }

    public TransportLink getLinkFromRemoteHandle(UnsignedInteger handle) {
        return this._remoteHandleMap[handle.intValue()];
    }

    public UnsignedInteger allocateLocalHandle(TransportLink transportLink) {
        for (int i = 0; i < this._localHandleMap.length; ++i) {
            if (this._localHandleMap[i] != null) continue;
            UnsignedInteger rc = UnsignedInteger.valueOf(i);
            this._localHandleMap[i] = transportLink;
            transportLink.setLocalHandle(rc);
            return rc;
        }
        return UnsignedInteger.MAX_VALUE;
    }

    public void addLinkRemoteHandle(TransportLink link, UnsignedInteger remoteHandle) {
        this._remoteHandleMap[remoteHandle.intValue()] = link;
    }

    public void addLinkLocalHandle(TransportLink link, UnsignedInteger localhandle) {
        this._localHandleMap[localhandle.intValue()] = link;
    }

    public void freeLocalHandle(UnsignedInteger handle) {
        this._localHandleMap[handle.intValue()] = null;
    }

    public void freeRemoteHandle(UnsignedInteger handle) {
        this._remoteHandleMap[handle.intValue()] = null;
    }

    public TransportLink resolveHalfOpenLink(String name) {
        return this._halfOpenLinks.remove(name);
    }

    public void addHalfOpenLink(TransportLink link) {
        this._halfOpenLinks.put(link.getName(), link);
    }

    public void handleTransfer(Transfer transfer, Binary payload) {
        DeliveryImpl delivery;
        TransportReceiver transportReceiver;
        this.incrementNextIncomingId();
        if (transfer.getDeliveryId() == null || transfer.getDeliveryId().equals(this._incomingDeliveryId)) {
            transportReceiver = (TransportReceiver)this.getLinkFromRemoteHandle(transfer.getHandle());
            ReceiverImpl receiver = transportReceiver.getReceiver();
            Binary deliveryTag = transfer.getDeliveryTag();
            delivery = this._unsettledIncomingDeliveriesById.get(this._incomingDeliveryId);
            delivery.getTransportDelivery().incrementSessionSize();
        } else {
            this._incomingDeliveryId = transfer.getDeliveryId();
            transportReceiver = (TransportReceiver)this.getLinkFromRemoteHandle(transfer.getHandle());
            ReceiverImpl receiver = transportReceiver.getReceiver();
            Binary deliveryTag = transfer.getDeliveryTag();
            delivery = receiver.delivery(deliveryTag.getArray(), deliveryTag.getArrayOffset(), deliveryTag.getLength());
            TransportDelivery transportDelivery = new TransportDelivery(this._incomingDeliveryId, delivery, transportReceiver);
            delivery.setTransportDelivery(transportDelivery);
            this._unsettledIncomingDeliveriesById.put(this._incomingDeliveryId, delivery);
            this.getSession().incrementIncomingDeliveries(1);
        }
        if (transfer.getState() != null) {
            delivery.setRemoteDeliveryState(transfer.getState());
        }
        ++this._unsettledIncomingSize;
        if (payload != null) {
            if (delivery.getDataLength() == 0) {
                delivery.setData(payload.getArray());
                delivery.setDataLength(payload.getLength());
                delivery.setDataOffset(payload.getArrayOffset());
            } else {
                byte[] data = new byte[delivery.getDataLength() + payload.getLength()];
                System.arraycopy(delivery.getData(), delivery.getDataOffset(), data, 0, delivery.getDataLength());
                System.arraycopy(payload.getArray(), payload.getArrayOffset(), data, delivery.getDataLength(), payload.getLength());
                delivery.setData(data);
                delivery.setDataOffset(0);
                delivery.setDataLength(data.length);
            }
            this.getSession().incrementIncomingBytes(payload.getLength());
        }
        delivery.updateWork();
        if (!transfer.getMore() && !transfer.getAborted()) {
            delivery.setComplete();
            delivery.getLink().getTransportLink().decrementLinkCredit();
            delivery.getLink().getTransportLink().incrementDeliveryCount();
        }
        if (Boolean.TRUE == transfer.getSettled()) {
            delivery.setRemoteSettled(true);
        }
        this._incomingWindowSize = this._incomingWindowSize.subtract(UnsignedInteger.ONE);
        if (this._incomingWindowSize.equals(UnsignedInteger.ZERO)) {
            delivery.getLink().modified();
        }
    }

    public void freeLocalChannel() {
        this._localChannel = -1;
    }

    private void setRemoteIncomingWindow(UnsignedInteger incomingWindow) {
        this._remoteIncomingWindow = incomingWindow;
    }

    void decrementRemoteIncomingWindow() {
        this._remoteIncomingWindow = this._remoteIncomingWindow.subtract(UnsignedInteger.ONE);
    }

    private void setRemoteOutgoingWindow(UnsignedInteger outgoingWindow) {
        this._remoteOutgoingWindow = outgoingWindow;
    }

    void handleFlow(Flow flow) {
        UnsignedInteger inext = flow.getNextIncomingId();
        UnsignedInteger iwin = flow.getIncomingWindow();
        if (inext != null) {
            this.setRemoteNextIncomingId(inext);
            this.setRemoteIncomingWindow(inext.add(iwin).subtract(this._nextOutgoingId));
        } else {
            this.setRemoteIncomingWindow(iwin);
        }
        this.setRemoteNextOutgoingId(flow.getNextOutgoingId());
        this.setRemoteOutgoingWindow(flow.getOutgoingWindow());
        if (flow.getHandle() != null) {
            TransportLink transportLink = this.getLinkFromRemoteHandle(flow.getHandle());
            transportLink.handleFlow(flow);
        }
    }

    private void setRemoteNextOutgoingId(UnsignedInteger nextOutgoingId) {
        this._remoteNextOutgoingId = nextOutgoingId;
    }

    private void setRemoteNextIncomingId(UnsignedInteger remoteNextIncomingId) {
        this._remoteNextIncomingId = remoteNextIncomingId;
    }

    void handleDisposition(Disposition disposition) {
        Map<UnsignedInteger, DeliveryImpl> unsettledDeliveries;
        UnsignedInteger id = disposition.getFirst();
        UnsignedInteger last = disposition.getLast() == null ? id : disposition.getLast();
        Map<UnsignedInteger, DeliveryImpl> map = unsettledDeliveries = disposition.getRole() == Role.RECEIVER ? this._unsettledOutgoingDeliveriesById : this._unsettledIncomingDeliveriesById;
        while (id.compareTo(last) <= 0) {
            DeliveryImpl delivery = unsettledDeliveries.get(id);
            if (delivery != null) {
                if (disposition.getState() != null) {
                    delivery.setRemoteDeliveryState(disposition.getState());
                }
                if (Boolean.TRUE.equals(disposition.getSettled())) {
                    delivery.setRemoteSettled(true);
                    unsettledDeliveries.remove(id);
                }
                delivery.updateWork();
            }
            id = id.add(UnsignedInteger.ONE);
        }
    }

    void addUnsettledOutgoing(UnsignedInteger deliveryId, DeliveryImpl delivery) {
        this._unsettledOutgoingDeliveriesById.put(deliveryId, delivery);
    }

    public boolean hasOutgoingCredit() {
        return this._remoteIncomingWindow == null ? false : this._remoteIncomingWindow.compareTo(UnsignedInteger.ZERO) > 0;
    }

    void incrementOutgoingId() {
        this._nextOutgoingId = this._nextOutgoingId.add(UnsignedInteger.ONE);
    }

    public void settled(TransportDelivery transportDelivery) {
        if (transportDelivery.getTransportLink().getLink() instanceof ReceiverImpl) {
            this._unsettledIncomingDeliveriesById.remove(transportDelivery.getDeliveryId());
            this.getSession().modified();
        } else {
            this._unsettledOutgoingDeliveriesById.remove(transportDelivery.getDeliveryId());
            this.getSession().modified();
        }
    }

    public UnsignedInteger getNextIncomingId() {
        return this._nextIncomingId;
    }

    public void setNextIncomingId(UnsignedInteger nextIncomingId) {
        this._nextIncomingId = nextIncomingId;
    }

    public void incrementNextIncomingId() {
        this._nextIncomingId = this._nextIncomingId.add(UnsignedInteger.ONE);
    }

    public boolean endReceived() {
        return this._endReceived;
    }

    public void receivedEnd() {
        this._endReceived = true;
    }

    public boolean beginSent() {
        return this._beginSent;
    }

    public void sentBegin() {
        this._beginSent = true;
    }
}

