/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.impl;

import java.nio.ByteBuffer;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.codec.Data;
import org.apache.qpid.proton.codec.impl.AbstractElement;
import org.apache.qpid.proton.codec.impl.DescribedTypeImpl;
import org.apache.qpid.proton.codec.impl.Element;

class ArrayElement
extends AbstractElement<Object[]> {
    private final boolean _described;
    private final Data.DataType _arrayType;
    private ConstructorType _constructorType;
    private Element _first;
    static ConstructorType TINY = ConstructorType.TINY;
    static ConstructorType SMALL = ConstructorType.SMALL;
    static ConstructorType LARGE = ConstructorType.LARGE;

    ArrayElement(Element parent, Element prev, boolean described, Data.DataType type) {
        super(parent, prev);
        this._described = described;
        this._arrayType = type;
        if (this._arrayType == null) {
            throw new NullPointerException("Array type cannot be null");
        }
        if (this._arrayType == Data.DataType.DESCRIBED) {
            throw new IllegalArgumentException("Array type cannot be DESCRIBED");
        }
        switch (this._arrayType) {
            case UINT: 
            case ULONG: 
            case LIST: {
                this.setConstructorType(TINY);
                break;
            }
            default: {
                this.setConstructorType(SMALL);
            }
        }
    }

    ConstructorType constructorType() {
        return this._constructorType;
    }

    void setConstructorType(ConstructorType type) {
        this._constructorType = type;
    }

    @Override
    public int size() {
        int bodySize;
        ConstructorType oldConstructorType;
        int count = 0;
        do {
            bodySize = 1;
            oldConstructorType = this._constructorType;
            for (Element element = this._first; element != null; element = element.next()) {
                ++count;
                bodySize += element.size();
            }
        } while (oldConstructorType != this.constructorType());
        if (this.isDescribed()) {
            ++bodySize;
            if (count != 0) {
                --count;
            }
        }
        if (this.isElementOfArray()) {
            ArrayElement parent = (ArrayElement)this.parent();
            if (parent.constructorType() == SMALL) {
                if (count <= 255 && bodySize <= 254) {
                    bodySize += 2;
                } else {
                    parent.setConstructorType(LARGE);
                    bodySize += 8;
                }
            } else {
                bodySize += 8;
            }
        } else {
            bodySize = count <= 255 && bodySize <= 254 ? (bodySize += 3) : (bodySize += 9);
        }
        return bodySize;
    }

    @Override
    public Object[] getValue() {
        if (this.isDescribed()) {
            Object[] rVal = new DescribedType[(int)this.count()];
            Object descriptor = this._first == null ? null : this._first.getValue();
            int i = 0;
            for (Element element = this._first == null ? null : this._first.next(); element != null; element = element.next()) {
                rVal[i++] = new DescribedTypeImpl(descriptor, element.getValue());
            }
            return rVal;
        }
        Object[] rVal = new Object[(int)this.count()];
        int i = 0;
        for (Element element = this._first; element != null; element = element.next()) {
            rVal[i++] = element.getValue();
        }
        return rVal;
    }

    @Override
    public Data.DataType getDataType() {
        return Data.DataType.ARRAY;
    }

    @Override
    public int encode(ByteBuffer b) {
        int size = this.size();
        int count = (int)this.count();
        if (b.remaining() >= size) {
            if (!this.isElementOfArray()) {
                if (size > 257 || count > 255) {
                    b.put((byte)-16);
                    b.putInt(size - 5);
                    b.putInt(count);
                } else {
                    b.put((byte)-32);
                    b.put((byte)(size - 2));
                    b.put((byte)count);
                }
            } else {
                ArrayElement parent = (ArrayElement)this.parent();
                if (parent.constructorType() == SMALL) {
                    b.put((byte)(size - 1));
                    b.put((byte)count);
                } else {
                    b.putInt(size - 4);
                    b.putInt(count);
                }
            }
            Element element = this._first;
            if (this.isDescribed()) {
                b.put((byte)0);
                if (element == null) {
                    b.put((byte)64);
                } else {
                    element.encode(b);
                    element = element.next();
                }
            }
            switch (this._arrayType) {
                case NULL: {
                    b.put((byte)64);
                    break;
                }
                case BOOL: {
                    b.put((byte)86);
                    break;
                }
                case UBYTE: {
                    b.put((byte)80);
                    break;
                }
                case BYTE: {
                    b.put((byte)81);
                    break;
                }
                case USHORT: {
                    b.put((byte)96);
                    break;
                }
                case SHORT: {
                    b.put((byte)97);
                    break;
                }
                case UINT: {
                    switch (this.constructorType()) {
                        case TINY: {
                            b.put((byte)67);
                            break;
                        }
                        case SMALL: {
                            b.put((byte)82);
                            break;
                        }
                        case LARGE: {
                            b.put((byte)112);
                        }
                    }
                    break;
                }
                case INT: {
                    b.put(this._constructorType == SMALL ? (byte)84 : 113);
                    break;
                }
                case CHAR: {
                    b.put((byte)115);
                    break;
                }
                case ULONG: {
                    switch (this.constructorType()) {
                        case TINY: {
                            b.put((byte)68);
                            break;
                        }
                        case SMALL: {
                            b.put((byte)83);
                            break;
                        }
                        case LARGE: {
                            b.put((byte)-128);
                        }
                    }
                    break;
                }
                case LONG: {
                    b.put(this._constructorType == SMALL ? (byte)85 : -127);
                    break;
                }
                case TIMESTAMP: {
                    b.put((byte)-125);
                    break;
                }
                case FLOAT: {
                    b.put((byte)114);
                    break;
                }
                case DOUBLE: {
                    b.put((byte)-126);
                    break;
                }
                case DECIMAL32: {
                    b.put((byte)116);
                    break;
                }
                case DECIMAL64: {
                    b.put((byte)-124);
                    break;
                }
                case DECIMAL128: {
                    b.put((byte)-108);
                    break;
                }
                case UUID: {
                    b.put((byte)-104);
                    break;
                }
                case BINARY: {
                    b.put(this._constructorType == SMALL ? (byte)-96 : -80);
                    break;
                }
                case STRING: {
                    b.put(this._constructorType == SMALL ? (byte)-95 : -79);
                    break;
                }
                case SYMBOL: {
                    b.put(this._constructorType == SMALL ? (byte)-93 : -77);
                    break;
                }
                case ARRAY: {
                    b.put(this._constructorType == SMALL ? (byte)-32 : -16);
                    break;
                }
                case LIST: {
                    b.put((byte)(this._constructorType == TINY ? 69 : (this._constructorType == SMALL ? -64 : -48)));
                    break;
                }
                case MAP: {
                    b.put(this._constructorType == SMALL ? (byte)-63 : -47);
                }
            }
            while (element != null) {
                element.encode(b);
                element = element.next();
            }
            return size;
        }
        return 0;
    }

    @Override
    public boolean canEnter() {
        return true;
    }

    @Override
    public Element child() {
        return this._first;
    }

    @Override
    public Element addChild(Element element) {
        if (this.isDescribed() || element.getDataType() == this._arrayType) {
            this._first = element;
            return element;
        }
        Element replacement = this.coerce(element);
        if (replacement != null) {
            return replacement;
        }
        throw new IllegalArgumentException("Attempting to add instance of " + (Object)((Object)element.getDataType()) + " to array of " + (Object)((Object)this._arrayType));
    }

    private Element coerce(Element element) {
        return null;
    }

    @Override
    public Element checkChild(Element element) {
        if (element.getDataType() != this._arrayType) {
            Element replacement = this.coerce(element);
            if (replacement != null) {
                return replacement;
            }
            throw new IllegalArgumentException("Attempting to add instance of " + (Object)((Object)element.getDataType()) + " to array of " + (Object)((Object)this._arrayType));
        }
        return element;
    }

    public long count() {
        int count = 0;
        for (Element elt = this._first; elt != null; elt = elt.next()) {
            ++count;
        }
        if (this.isDescribed() && count != 0) {
            --count;
        }
        return count;
    }

    public boolean isDescribed() {
        return this._described;
    }

    public Data.DataType getArrayDataType() {
        return this._arrayType;
    }

    static enum ConstructorType {
        TINY,
        SMALL,
        LARGE;

    }
}

