/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.gateway.CallDetailRecord;
import io.fabric8.gateway.handlers.http.HttpGateway;
import io.fabric8.gateway.handlers.http.MappedServices;
import io.fabric8.gateway.handlers.http.ProxyMappingDetails;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpClient;
import org.vertx.java.core.http.HttpClientRequest;
import org.vertx.java.core.http.HttpClientResponse;
import org.vertx.java.core.http.HttpHeaders;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.HttpServerResponse;

public class HttpGatewayHandler
implements Handler<HttpServerRequest> {
    private static final transient Logger LOG = LoggerFactory.getLogger(HttpGatewayHandler.class);
    private final Vertx vertx;
    private final HttpGateway httpGateway;
    private final ObjectMapper mapper = new ObjectMapper();
    private boolean addMissingTrailingSlashes = true;

    public HttpGatewayHandler(Vertx vertx, HttpGateway httpGateway) {
        this.vertx = vertx;
        this.httpGateway = httpGateway;
    }

    public void handle(HttpServerRequest request) {
        long callStart = System.nanoTime();
        LOG.debug("Proxying request: {} {}", (Object)request.method(), (Object)request.uri());
        Map<String, MappedServices> mappingRules = this.httpGateway.getMappedServices();
        try {
            if (this.isMappingIndexRequest(request)) {
                this.doReturnIndex(request, mappingRules);
            } else {
                this.doRouteRequest(mappingRules, request);
            }
            CallDetailRecord cdr = new CallDetailRecord(System.nanoTime() - callStart, null);
            this.httpGateway.addCallDetailRecord(cdr);
        }
        catch (Throwable e) {
            LOG.error("Caught: " + e, e);
            CallDetailRecord cdr = new CallDetailRecord(System.nanoTime() - callStart, new Date() + ":" + e.getMessage());
            this.httpGateway.addCallDetailRecord(cdr);
            request.response().setStatusCode(404);
            StringWriter buffer = new StringWriter();
            e.printStackTrace(new PrintWriter(buffer));
            request.response().setStatusMessage("Error: " + e + "\nStack Trace: " + buffer);
            request.response().close();
        }
    }

    protected void doReturnIndex(HttpServerRequest request, Map<String, MappedServices> mappingRules) throws IOException {
        String json = this.mappingRulesToJson(mappingRules);
        HttpServerResponse response = request.response();
        response.headers().set(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json");
        if ("HEAD".equals(request.method())) {
            String contentLength = String.valueOf(new Buffer(json).length());
            response.putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)contentLength).end();
        } else {
            response.end(json);
        }
        response.setStatusCode(200);
    }

    protected String mappingRulesToJson(Map<String, MappedServices> rules) throws IOException {
        HashMap<String, List<String>> data = new HashMap<String, List<String>>();
        Set<Map.Entry<String, MappedServices>> entries = rules.entrySet();
        for (Map.Entry<String, MappedServices> entry : entries) {
            String key = entry.getKey();
            MappedServices value = entry.getValue();
            List<String> serviceUrls = value.getServiceUrls();
            data.put(key, serviceUrls);
        }
        return this.mapper.writeValueAsString(data);
    }

    protected void doRouteRequest(Map<String, MappedServices> mappingRules, final HttpServerRequest request) {
        String uri;
        String uri2 = uri = request.uri();
        if (this.addMissingTrailingSlashes) {
            uri2 = HttpGatewayHandler.normalizeUri(uri);
        }
        HttpClient client = null;
        String remaining = null;
        String prefix = null;
        String proxyServiceUrl = null;
        String reverseServiceUrl = null;
        MappedServices mappedServices = null;
        URL clientURL = null;
        Set<Map.Entry<String, MappedServices>> entries = mappingRules.entrySet();
        for (Map.Entry<String, MappedServices> entry : entries) {
            boolean uri2Matches;
            String path = entry.getKey();
            mappedServices = entry.getValue();
            String pathPrefix = path;
            boolean uriMatches = uri.startsWith(pathPrefix);
            boolean bl = uri2Matches = uri2 != null && uri2.startsWith(pathPrefix);
            if (!uriMatches && !uri2Matches) continue;
            int pathPrefixLength = pathPrefix.length();
            remaining = uri2Matches && pathPrefixLength < uri2.length() ? uri2.substring(pathPrefixLength) : (pathPrefixLength < uri.length() ? uri.substring(pathPrefixLength) : null);
            proxyServiceUrl = mappedServices.chooseService(request);
            if (proxyServiceUrl == null) continue;
            try {
                clientURL = new URL(proxyServiceUrl);
                client = this.createClient(clientURL);
                prefix = clientURL.getPath();
                reverseServiceUrl = request.absoluteURI().resolve(pathPrefix).toString();
                if (!reverseServiceUrl.endsWith("/")) break;
                reverseServiceUrl = reverseServiceUrl.substring(0, reverseServiceUrl.length() - 1);
                break;
            }
            catch (MalformedURLException e) {
                LOG.warn("Failed to parse URL: " + proxyServiceUrl + ". " + e, (Throwable)e);
            }
        }
        if (client != null) {
            String servicePath;
            String string = servicePath = prefix != null ? prefix : "";
            if (servicePath.length() > 0 && !servicePath.endsWith("/")) {
                servicePath = servicePath + "/";
            }
            if (remaining != null) {
                servicePath = servicePath + remaining;
            }
            LOG.info("Proxying request {} to service path: {} on service: {} reverseServiceUrl: {}", new Object[]{uri, servicePath, proxyServiceUrl, reverseServiceUrl});
            final HttpClient finalClient = client;
            Handler<HttpClientResponse> responseHandler = new Handler<HttpClientResponse>(){

                public void handle(HttpClientResponse clientResponse) {
                    LOG.debug("Proxying response: {}", (Object)clientResponse.statusCode());
                    request.response().setStatusCode(clientResponse.statusCode());
                    request.response().headers().set(clientResponse.headers());
                    HttpGatewayHandler.this.applyChunkedEncoding(request.response());
                    clientResponse.dataHandler((Handler)new Handler<Buffer>(){

                        public void handle(Buffer data) {
                            LOG.debug("Proxying response body: {}", (Object)data);
                            request.response().write(data);
                        }
                    });
                    clientResponse.endHandler((Handler)new VoidHandler(){

                        public void handle() {
                            request.response().end();
                            finalClient.close();
                        }
                    });
                }
            };
            if (mappedServices != null) {
                ProxyMappingDetails proxyMappingDetails = new ProxyMappingDetails(proxyServiceUrl, reverseServiceUrl, servicePath);
                responseHandler = mappedServices.wrapResponseHandlerInPolicies(request, responseHandler, proxyMappingDetails);
            }
            final HttpClientRequest clientRequest = client.request(request.method(), servicePath, (Handler)responseHandler);
            clientRequest.headers().set(request.headers());
            clientRequest.setChunked(true);
            request.dataHandler((Handler)new Handler<Buffer>(){

                public void handle(Buffer data) {
                    LOG.debug("Proxying request body: {}", (Object)data);
                    clientRequest.write(data);
                }
            });
            request.endHandler((Handler)new VoidHandler(){

                public void handle() {
                    LOG.debug("end of the request");
                    clientRequest.end();
                }
            });
        } else {
            LOG.info("Could not find matching proxy path for {} from paths: {}", (Object)uri, mappingRules.keySet());
            request.response().setStatusCode(404);
            request.response().close();
        }
    }

    protected boolean isMappingIndexRequest(HttpServerRequest request) {
        if (this.httpGateway == null || !this.httpGateway.isEnableIndex()) {
            return false;
        }
        String uri = request.uri();
        return uri == null || uri.length() == 0 || uri.equals("/");
    }

    protected HttpClient createClient(URL url) throws MalformedURLException {
        HttpClient client = this.vertx.createHttpClient();
        client.setHost(url.getHost());
        client.setPort(url.getPort());
        return client;
    }

    protected static String normalizeUri(String value) {
        try {
            String result = null;
            URI uri = new URI(value);
            String path = uri.getPath();
            if (!path.endsWith("/")) {
                result = value.replaceFirst(Pattern.quote(path), path + "/");
            }
            return result;
        }
        catch (URISyntaxException e) {
            LOG.debug("Exception caught while normalizing URI path - proceeding with the original path value", (Throwable)e);
            return null;
        }
    }

    public void setAddMissingTrailingSlashes(boolean addMissingTrailingSlashes) {
        this.addMissingTrailingSlashes = addMissingTrailingSlashes;
    }

    protected void applyChunkedEncoding(HttpServerResponse re) {
        switch (re.getStatusCode()) {
            case 204: {
                re.setChunked(false);
                break;
            }
            default: {
                re.setChunked(true);
            }
        }
    }
}

