/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.loadbalancer;

import io.fabric8.gateway.loadbalancer.ClientRequestFacade;
import io.fabric8.gateway.loadbalancer.LoadBalancer;
import io.fabric8.gateway.loadbalancer.RoundRobinLoadBalancer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class StickyLoadBalancer
implements LoadBalancer {
    private final LoadBalancer firstRequestLoadBalancer;
    private final int maximumCacheSize;
    private final Map<String, Object> requestCache;

    public StickyLoadBalancer() {
        this(10000);
    }

    public StickyLoadBalancer(int maximumCacheSize) {
        this(maximumCacheSize, new RoundRobinLoadBalancer());
    }

    public StickyLoadBalancer(int maximumCacheSize, LoadBalancer firstRequestLoadBalancer) {
        this.firstRequestLoadBalancer = firstRequestLoadBalancer;
        this.maximumCacheSize = maximumCacheSize;
        this.requestCache = new LinkedHashMap(maximumCacheSize + 1, 0.75f, true){

            public boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > StickyLoadBalancer.this.maximumCacheSize;
            }
        };
    }

    public String toString() {
        return "StickyLoadBalancer{maximumCacheSize=" + this.maximumCacheSize + '}';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T choose(List<T> services, ClientRequestFacade requestFacade) {
        Object answer;
        String clientKey = requestFacade.getClientRequestKey();
        Map<String, Object> map = this.requestCache;
        synchronized (map) {
            answer = this.requestCache.get(clientKey);
            if (!(answer != null && services.contains(answer) || (answer = this.firstRequestLoadBalancer.choose(services, requestFacade)) == null)) {
                this.requestCache.put(clientKey, answer);
            }
        }
        return (T)answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Map<String, Object> map = this.requestCache;
        synchronized (map) {
            this.requestCache.clear();
        }
    }
}

