/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.tcp;

import io.fabric8.gateway.ServiceMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.net.NetServer;
import org.vertx.java.core.net.NetSocket;

public class TcpGateway {
    private static final transient Logger LOG = LoggerFactory.getLogger(TcpGateway.class);
    private final Vertx vertx;
    private final ServiceMap serviceMap;
    private final int port;
    private final String protocol;
    private final Handler<NetSocket> handler;
    private String host;
    private NetServer server;

    public TcpGateway(Vertx vertx, ServiceMap serviceMap, int port, String protocol, Handler<NetSocket> handler) {
        this.vertx = vertx;
        this.serviceMap = serviceMap;
        this.port = port;
        this.protocol = protocol;
        this.handler = handler;
    }

    public String toString() {
        return "TcpGateway{protocol='" + this.protocol + '\'' + ", port=" + this.port + ", host='" + this.host + '\'' + '}';
    }

    public void init() {
        this.server = this.vertx.createNetServer().connectHandler(this.handler);
        if (this.host != null) {
            LOG.info("Listening on port " + this.port + " and host " + this.host + " for protocol: " + this.protocol);
            this.server = this.server.listen(this.port, this.host);
        } else {
            LOG.info("Listening on port " + this.port + " for protocol: " + this.protocol);
            this.server = this.server.listen(this.port);
        }
    }

    public void destroy() {
        this.server.close();
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public ServiceMap getServiceMap() {
        return this.serviceMap;
    }

    public String getProtocol() {
        return this.protocol;
    }
}

