/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.detecting;

import io.fabric8.common.util.ShutdownTracker;
import io.fabric8.common.util.Strings;
import io.fabric8.gateway.ServiceDetails;
import io.fabric8.gateway.ServiceMap;
import io.fabric8.gateway.SocketWrapper;
import io.fabric8.gateway.handlers.detecting.DetectingGatewayMBean;
import io.fabric8.gateway.handlers.detecting.DetectingGatewayNetSocketHandler;
import io.fabric8.gateway.handlers.detecting.FutureHandler;
import io.fabric8.gateway.handlers.detecting.Protocol;
import io.fabric8.gateway.handlers.detecting.protocol.ssl.SslConfig;
import io.fabric8.gateway.handlers.detecting.protocol.ssl.SslSocketWrapper;
import io.fabric8.gateway.handlers.loadbalancer.ClientRequestFacadeFactory;
import io.fabric8.gateway.handlers.loadbalancer.ConnectionParameters;
import io.fabric8.gateway.loadbalancer.ClientRequestFacade;
import io.fabric8.gateway.loadbalancer.LoadBalancer;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.net.NetClient;
import org.vertx.java.core.net.NetServer;
import org.vertx.java.core.net.NetSocket;
import org.vertx.java.core.streams.Pump;
import org.vertx.java.core.streams.ReadStream;
import org.vertx.java.core.streams.WriteStream;

public class DetectingGateway
implements DetectingGatewayMBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(DetectingGateway.class);
    Vertx vertx;
    ServiceMap serviceMap;
    LoadBalancer serviceLoadBalancer;
    String defaultVirtualHost;
    ArrayList<Protocol> protocols;
    int maxProtocolIdentificationLength;
    ClientRequestFacadeFactory clientRequestFacadeFactory = new ClientRequestFacadeFactory("PROTOCOL_SESSION_ID, PROTOCOL_CLIENT_ID, REMOTE_ADDRESS");
    final AtomicReference<InetSocketAddress> httpGateway = new AtomicReference();
    SslConfig sslConfig;
    long connectionTimeout = 5000L;
    final AtomicLong receivedConnectionAttempts = new AtomicLong();
    final AtomicLong successfulConnectionAttempts = new AtomicLong();
    final AtomicLong failedConnectionAttempts = new AtomicLong();
    Set<SocketWrapper> socketsConnecting = Collections.synchronizedSet(new HashSet());
    Set<ConnectedSocketInfo> socketsConnected = Collections.synchronizedSet(new HashSet());
    private volatile ShutdownTracker shutdownTracker = new ShutdownTracker();
    private int port;
    private String host;
    private NetServer server;
    private FutureHandler<AsyncResult<NetServer>> listenFuture = new FutureHandler<AsyncResult<NetServer>>(){

        @Override
        public void handle(AsyncResult<NetServer> event) {
            if (event.succeeded()) {
                LOG.info(String.format("Gateway listening on %s:%d for protocols: %s", DetectingGateway.this.server.host(), DetectingGateway.this.server.port(), DetectingGateway.this.getProtocolNames()));
            }
            super.handle(event);
        }
    };
    private DetectingGatewayNetSocketHandler connectHandler;
    SSLContext sslContext;
    SslSocketWrapper.ClientAuth clientAuth = SslSocketWrapper.ClientAuth.WANT;

    public String toString() {
        return "DetectingGateway{, port=" + this.port + ", host='" + this.host + '\'' + ", protocols='" + this.getProtocolNames() + '\'' + '}';
    }

    public void init() {
        this.connectHandler = new DetectingGatewayNetSocketHandler(this);
        this.server = this.vertx.createNetServer().connectHandler((Handler)this.connectHandler);
        this.server = this.host != null ? this.server.listen(this.port, this.host, this.listenFuture) : this.server.listen(this.port, this.listenFuture);
    }

    public void destroy() {
        LOG.info("{} destroy() invoked.", (Object)DetectingGateway.class.getName());
        Handler<AsyncResult<Void>> closeHandler = new Handler<AsyncResult<Void>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(AsyncResult<Void> voidAsyncResult) {
                try {
                    Set<Object> set = DetectingGateway.this.socketsConnecting;
                    synchronized (set) {
                        for (SocketWrapper socketWrapper : new ArrayList<SocketWrapper>(DetectingGateway.this.socketsConnecting)) {
                            DetectingGateway.this.handleConnectFailure(socketWrapper, "Triggered destroy() on DetectingGateway class");
                        }
                    }
                    set = DetectingGateway.this.socketsConnected;
                    synchronized (set) {
                        for (ConnectedSocketInfo connectedSocketInfo : new ArrayList<ConnectedSocketInfo>(DetectingGateway.this.socketsConnected)) {
                            DetectingGateway.this.handleShutdown(connectedSocketInfo);
                        }
                    }
                }
                finally {
                    DetectingGateway.this.server = null;
                    DetectingGateway.this.connectHandler.setGateway(null);
                    DetectingGateway.this.connectHandler = null;
                }
                LOG.info("Finished close() server {}.", (Object)DetectingGateway.this.server);
            }
        };
        this.server.close((Handler)closeHandler);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getBoundPort() throws Exception {
        return ((NetServer)FutureHandler.result(this.listenFuture)).port();
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    public void setServiceMap(ServiceMap serviceMap) {
        this.serviceMap = serviceMap;
    }

    public LoadBalancer getServiceLoadBalancer() {
        return this.serviceLoadBalancer;
    }

    public void setServiceLoadBalancer(LoadBalancer serviceLoadBalancer) {
        this.serviceLoadBalancer = serviceLoadBalancer;
    }

    public String getDefaultVirtualHost() {
        return this.defaultVirtualHost;
    }

    public void setDefaultVirtualHost(String defaultVirtualHost) {
        this.defaultVirtualHost = defaultVirtualHost;
    }

    public ArrayList<Protocol> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(ArrayList<Protocol> protocols) {
        this.protocols = new ArrayList<Protocol>(protocols);
        int max = 0;
        for (Protocol protocol : protocols) {
            if (protocol.getMaxIdentificationLength() <= max) continue;
            max = protocol.getMaxIdentificationLength();
        }
        this.maxProtocolIdentificationLength = max;
    }

    public Collection<String> getProtocolNames() {
        ArrayList<String> rc = new ArrayList<String>(this.protocols.size());
        for (Protocol protocol : this.protocols) {
            rc.add(protocol.getProtocolName());
        }
        return rc;
    }

    public void setShutdownTacker(ShutdownTracker shutdownTracker) {
        this.shutdownTracker = shutdownTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(final SocketWrapper socket) {
        ReadStream<ReadStream> readStream;
        LOG.trace("Handling Socket: {}", (Object)socket.remoteAddress());
        Set<SocketWrapper> set = this.socketsConnecting;
        synchronized (set) {
            try {
                if (this.socketsConnecting.contains(socket)) {
                    throw new AssertionError((Object)"Socket existed in the socketsConnecting set");
                }
            }
            catch (Throwable e) {
                LOG.debug("Could not accept connection from: " + socket.remoteAddress(), e);
                socket.close();
                return;
            }
            try {
                this.shutdownTracker.retain();
            }
            catch (Throwable e) {
                LOG.debug("Was not able to shutdownTracker.retain(): Could not accept connection from: " + socket.remoteAddress(), e);
                socket.close();
                return;
            }
            this.receivedConnectionAttempts.incrementAndGet();
            this.socketsConnecting.add(socket);
            if (this.connectionTimeout > 0L) {
                this.vertx.setTimer(this.connectionTimeout, (Handler)new Handler<Long>(){

                    public void handle(Long timerID) {
                        DetectingGateway.this.handleConnectFailure(socket, String.format("Gateway client '%s' protocol detection timeout.", socket.remoteAddress()));
                    }
                });
            }
            readStream = socket.readStream();
            readStream.exceptionHandler((Handler)new Handler<Throwable>(){

                public void handle(Throwable e) {
                    DetectingGateway.this.handleConnectFailure(socket, String.format("Failed to route gateway client '%s' due to: %s", socket.remoteAddress(), e));
                }
            });
            readStream.endHandler((Handler)new Handler<Void>(){

                public void handle(Void event) {
                    DetectingGateway.this.handleConnectFailure(socket, String.format("Gateway client '%s' closed the connection before it could be routed.", socket.remoteAddress()));
                }
            });
        }
        readStream.dataHandler((Handler)new Handler<Buffer>(){
            Buffer received = new Buffer();
            {
                LOG.debug("Inititalized new Handler[{}] for socket: {}", (Object)this, (Object)socket.remoteAddress());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(Buffer event) {
                this.received.appendBuffer(event);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Socket received following data: {}", (Object)event.copy().toString().replaceAll("\r", " "));
                    LOG.trace("Data handled by Handler {}", (Object)this.toString());
                }
                for (final Protocol protocol : DetectingGateway.this.protocols) {
                    if (!protocol.matches(this.received)) continue;
                    if ("ssl".equals(protocol.getProtocolName())) {
                        LOG.info(String.format("SSL Connection from '%s'", socket.remoteAddress()));
                        String disabledCypherSuites = null;
                        String enabledCipherSuites = null;
                        if (DetectingGateway.this.sslConfig != null) {
                            disabledCypherSuites = DetectingGateway.this.sslConfig.getDisabledCypherSuites();
                            enabledCipherSuites = DetectingGateway.this.sslConfig.getEnabledCipherSuites();
                        }
                        if (DetectingGateway.this.sslContext == null) {
                            try {
                                if (DetectingGateway.this.sslConfig != null) {
                                    DetectingGateway.this.sslContext = SSLContext.getInstance(DetectingGateway.this.sslConfig.getProtocol());
                                    DetectingGateway.this.sslContext.init(DetectingGateway.this.sslConfig.getKeyManagers(), DetectingGateway.this.sslConfig.getTrustManagers(), null);
                                } else {
                                    DetectingGateway.this.sslContext = SSLContext.getDefault();
                                }
                            }
                            catch (Exception e) {
                                DetectingGateway.this.handleConnectFailure(socket, "Could initialize SSL: " + e);
                                return;
                            }
                        }
                        if (DetectingGateway.this.socketsConnecting.remove(socket)) {
                            SslSocketWrapper sslSocketWrapper = new SslSocketWrapper(socket);
                            sslSocketWrapper.putBackHeader(this.received);
                            sslSocketWrapper.initServer(DetectingGateway.this.sslContext, DetectingGateway.this.clientAuth, disabledCypherSuites, enabledCipherSuites);
                            DetectingGateway.this.receivedConnectionAttempts.decrementAndGet();
                            try {
                                DetectingGateway.this.handle(sslSocketWrapper);
                            }
                            finally {
                                DetectingGateway.this.shutdownTracker.release();
                            }
                            return;
                        }
                        DetectingGateway.this.handleConnectFailure(socket, "Could not accept SSL connection from: " + socket.remoteAddress() + "socket wasn't present in connecting socket set.");
                        return;
                    }
                    if ("http".equals(protocol.getProtocolName())) {
                        InetSocketAddress target = DetectingGateway.this.getHttpGateway();
                        if (target != null) {
                            URI url;
                            try {
                                url = new URI("http://" + target.getHostString() + ":" + target.getPort());
                                LOG.info(String.format("Connecting '%s' to '%s:%d' using the http protocol", socket.remoteAddress(), url.getHost(), url.getPort()));
                            }
                            catch (URISyntaxException e) {
                                DetectingGateway.this.handleConnectFailure(socket, "Could not build valid connect URI: " + e);
                                return;
                            }
                            ConnectionParameters params = new ConnectionParameters();
                            params.protocol = "http";
                            DetectingGateway.this.createClient(params, socket, url, this.received);
                            return;
                        }
                        DetectingGateway.this.handleConnectFailure(socket, "No http gateway available for the http protocol");
                        return;
                    }
                    protocol.snoopConnectionParameters(socket, this.received, new Handler<ConnectionParameters>(){

                        public void handle(ConnectionParameters connectionParameters) {
                            if (connectionParameters.protocol == null) {
                                connectionParameters.protocol = protocol.getProtocolName();
                            }
                            if (connectionParameters.protocolSchemes == null) {
                                connectionParameters.protocolSchemes = protocol.getProtocolSchemes();
                            }
                            DetectingGateway.this.route(socket, connectionParameters, received);
                        }
                    });
                    return;
                }
                if (this.received.length() >= DetectingGateway.this.maxProtocolIdentificationLength) {
                    DetectingGateway.this.handleConnectFailure(socket, "Connection did not use one of the enabled protocols " + DetectingGateway.this.getProtocolNames());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConnectFailure(SocketWrapper socket, String reason) {
        LOG.debug("Handling ConnectFailure for Socket: [{}] with reason: [{}]", (Object)socket.remoteAddress(), (Object)reason);
        if (this.socketsConnecting.remove(socket)) {
            LOG.trace("Socket: [{}] found and removed from socketsConnecting Set", (Object)socket.remoteAddress());
            try {
                if (reason != null) {
                    LOG.warn(reason);
                }
                this.failedConnectionAttempts.incrementAndGet();
                LOG.trace("Closing Socket: [{}]", (Object)socket.remoteAddress());
                socket.close();
            }
            finally {
                LOG.trace("Releasing shutdownTracker for Socket: [{}]", (Object)socket.remoteAddress());
                this.shutdownTracker.release();
            }
        }
    }

    public void route(SocketWrapper socket, ConnectionParameters params, Buffer received) {
        NetClient client = null;
        if (params.protocolVirtualHost == null) {
            params.protocolVirtualHost = this.defaultVirtualHost;
        }
        HashSet<String> schemes = new HashSet<String>(Arrays.asList(params.protocolSchemes));
        if (params.protocolVirtualHost != null) {
            ClientRequestFacade clientRequestFacade;
            ServiceDetails serviceDetails;
            List<ServiceDetails> services = this.serviceMap.getServices(params.protocolVirtualHost);
            if (services.isEmpty() && !params.protocolVirtualHost.equals(this.defaultVirtualHost)) {
                params.protocolVirtualHost = this.defaultVirtualHost;
                services = this.serviceMap.getServices(params.protocolVirtualHost);
            }
            LOG.debug(String.format("%d services match the virtual host", services.size()));
            if (!services.isEmpty() && (serviceDetails = this.serviceLoadBalancer.choose(services, clientRequestFacade = this.clientRequestFacadeFactory.create(socket, params))) != null) {
                List<String> urlStrings = serviceDetails.getServices();
                LOG.debug("Selected service exposes the following URLS: {}", urlStrings);
                for (String urlString : urlStrings) {
                    if (!Strings.notEmpty((String)urlString)) continue;
                    try {
                        URI uri = new URI(urlString);
                        String urlProtocol = uri.getScheme();
                        if (!schemes.contains(urlProtocol)) continue;
                        if (!socket.remoteAddress().toString().equals(clientRequestFacade.getClientRequestKey())) {
                            LOG.info(String.format("Connecting client from '%s' (with key '%s') requesting virtual host '%s' to '%s:%d' using the %s protocol", socket.remoteAddress(), clientRequestFacade.getClientRequestKey(), params.protocolVirtualHost, uri.getHost(), uri.getPort(), params.protocol));
                        } else {
                            LOG.info(String.format("Connecting client from '%s' requesting virtual host '%s' to '%s:%d' using the %s protocol", socket.remoteAddress(), params.protocolVirtualHost, uri.getHost(), uri.getPort(), params.protocol));
                        }
                        client = this.createClient(params, socket, uri, received);
                        break;
                    }
                    catch (URISyntaxException e) {
                        LOG.warn("Failed to parse URI: " + urlString + ". " + e, (Throwable)e);
                    }
                }
            }
        }
        if (client == null) {
            this.handleConnectFailure(socket, String.format("No endpoint available for virtual host '%s' and protocol %s", params.protocolVirtualHost, params.protocol));
        }
    }

    private NetClient createClient(final ConnectionParameters params, final SocketWrapper socketFromClient, final URI url, final Buffer received) {
        final NetClient netClient = this.vertx.createNetClient();
        socketFromClient.readStream().pause();
        return netClient.connect(url.getPort(), url.getHost(), (Handler)new Handler<AsyncResult<NetSocket>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(AsyncResult<NetSocket> asyncSocket) {
                if (!asyncSocket.succeeded()) {
                    DetectingGateway.this.handleConnectFailure(socketFromClient, String.format("Could not connect to '%s'", url));
                } else {
                    socketFromClient.readStream().resume();
                    NetSocket socketToServer = (NetSocket)asyncSocket.result();
                    DetectingGateway.this.successfulConnectionAttempts.incrementAndGet();
                    if (DetectingGateway.this.socketsConnecting.remove(socketFromClient)) {
                        final ConnectedSocketInfo connectedInfo = new ConnectedSocketInfo(params, url, socketFromClient, netClient);
                        Set<ConnectedSocketInfo> set = DetectingGateway.this.socketsConnected;
                        synchronized (set) {
                            DetectingGateway.this.socketsConnected.add(connectedInfo);
                            Handler<Void> endHandler = new Handler<Void>(){

                                public void handle(Void event) {
                                    DetectingGateway.this.handleShutdown(connectedInfo);
                                }
                            };
                            Handler<Throwable> exceptionHandler = new Handler<Throwable>(){

                                public void handle(Throwable event) {
                                    DetectingGateway.this.handleShutdown(connectedInfo);
                                }
                            };
                            socketFromClient.readStream().endHandler((Handler)endHandler);
                            socketFromClient.readStream().exceptionHandler((Handler)exceptionHandler);
                            socketToServer.endHandler((Handler)endHandler);
                            socketToServer.exceptionHandler((Handler)exceptionHandler);
                        }
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Sending out to destination socket: {}", (Object)received);
                        }
                        socketToServer.write(received);
                        Pump.createPump((ReadStream)socketToServer, socketFromClient.writeStream()).start();
                        Pump.createPump(socketFromClient.readStream(), (WriteStream)socketToServer).start();
                        LOG.debug("socketFromClient {} has been connected to socketToServer {}", (Object)socketFromClient.remoteAddress(), (Object)socketToServer.remoteAddress());
                    } else {
                        DetectingGateway.this.handleConnectFailure(socketFromClient, "Could not create a new client for: " + socketFromClient.remoteAddress() + "socket wasn't present in connecting socket set.");
                        return;
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleShutdown(ConnectedSocketInfo connectedInfo) {
        LOG.debug("Handling Shutdown for Socket: [{}]", (Object)connectedInfo);
        if (this.socketsConnected.remove(connectedInfo)) {
            LOG.trace("Socket: [{}] found and removed from socketsConnected Set", (Object)connectedInfo);
            try {
                try {
                    connectedInfo.from.close();
                }
                finally {
                    connectedInfo.to.close();
                }
            }
            finally {
                LOG.trace("Releasing shutdownTracker for Socket: [{}]", (Object)connectedInfo);
                this.shutdownTracker.release();
            }
        }
    }

    public ServiceMap getServiceMap() {
        return this.serviceMap;
    }

    public InetSocketAddress getHttpGateway() {
        return this.httpGateway.get();
    }

    public void setHttpGateway(InetSocketAddress value) {
        this.httpGateway.set(value);
    }

    public SslConfig getSslConfig() {
        return this.sslConfig;
    }

    public void setSslConfig(SslConfig sslConfig) {
        this.sslConfig = sslConfig;
    }

    @Override
    public long getReceivedConnectionAttempts() {
        return this.receivedConnectionAttempts.get();
    }

    @Override
    public long getSuccessfulConnectionAttempts() {
        return this.successfulConnectionAttempts.get();
    }

    @Override
    public long getFailedConnectionAttempts() {
        return this.failedConnectionAttempts.get();
    }

    @Override
    public String[] getConnectingClients() {
        ArrayList<String> rc = new ArrayList<String>();
        for (SocketWrapper socket : this.socketsConnecting) {
            rc.add(socket.remoteAddress().toString());
        }
        return rc.toArray(new String[rc.size()]);
    }

    @Override
    public String[] getConnectedClients() {
        ArrayList<String> rc = new ArrayList<String>();
        for (ConnectedSocketInfo info : this.socketsConnected) {
            rc.add(info.from.remoteAddress().toString());
        }
        return rc.toArray(new String[rc.size()]);
    }

    @Override
    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    static class ConnectedSocketInfo {
        private final ConnectionParameters params;
        private final URI url;
        private final SocketWrapper from;
        private final NetClient to;

        public ConnectedSocketInfo(ConnectionParameters params, URI url, SocketWrapper from, NetClient to) {
            this.params = params;
            this.url = url;
            this.from = from;
            this.to = to;
        }

        public String toString() {
            return "ConnectedSocketInfo{params=" + this.params + ", url=" + this.url + ", from=" + this.from.localAddress() + ", to=" + this.from.remoteAddress() + '}';
        }
    }
}

