/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.detecting.protocol.amqp;

import io.fabric8.gateway.handlers.detecting.protocol.ProtocolDecoder;
import io.fabric8.gateway.handlers.detecting.protocol.amqp.AmqpEvent;
import io.fabric8.gateway.handlers.detecting.protocol.amqp.AmqpHeader;
import io.fabric8.gateway.handlers.detecting.protocol.amqp.AmqpProtocol;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.buffer.Buffer;

class AmqpProtocolDecoder
extends ProtocolDecoder<AmqpEvent> {
    private static final transient Logger LOG = LoggerFactory.getLogger(AmqpProtocolDecoder.class);
    private final AmqpProtocol protocol;
    private final ProtocolDecoder.Action<AmqpEvent> readFrameSize = new ProtocolDecoder.Action<AmqpEvent>(){

        @Override
        public AmqpEvent apply() throws IOException {
            Buffer sizeBytes = AmqpProtocolDecoder.this.peekBytes(4);
            if (sizeBytes != null) {
                int size = sizeBytes.getInt(0);
                if (size < 8) {
                    throw new IOException(String.format("specified frame size %d is smaller than minimum frame size", size));
                }
                if (size > ((AmqpProtocolDecoder)AmqpProtocolDecoder.this).protocol.maxFrameSize) {
                    throw new IOException(String.format("specified frame size %d is larger than maximum frame size", size));
                }
                AmqpProtocolDecoder.this.nextDecodeAction = AmqpProtocolDecoder.this.readFrame(size);
                return (AmqpEvent)AmqpProtocolDecoder.this.nextDecodeAction.apply();
            }
            return null;
        }
    };

    public AmqpProtocolDecoder(AmqpProtocol protocol) {
        this.protocol = protocol;
    }

    @Override
    protected ProtocolDecoder.Action<AmqpEvent> initialDecodeAction() {
        return new ProtocolDecoder.Action<AmqpEvent>(){

            @Override
            public AmqpEvent apply() throws IOException {
                Buffer magic = AmqpProtocolDecoder.this.readBytes(8);
                if (magic != null) {
                    AmqpProtocolDecoder.this.nextDecodeAction = AmqpProtocolDecoder.this.readFrameSize;
                    return new AmqpEvent(AmqpEvent.Type.HEADER, magic, new AmqpHeader(magic));
                }
                return null;
            }
        };
    }

    private final ProtocolDecoder.Action<AmqpEvent> readFrame(final int size) {
        return new ProtocolDecoder.Action<AmqpEvent>(){

            @Override
            public AmqpEvent apply() throws IOException {
                Buffer frameData = AmqpProtocolDecoder.this.readBytes(size);
                if (frameData != null) {
                    AmqpProtocolDecoder.this.nextDecodeAction = AmqpProtocolDecoder.this.readFrameSize;
                    return new AmqpEvent(AmqpEvent.Type.FRAME, frameData, null);
                }
                return null;
            }
        };
    }

    public void skipProtocolHeader() {
        this.nextDecodeAction = this.readFrameSize;
    }

    public void readProtocolHeader() {
        this.nextDecodeAction = this.initialDecodeAction();
    }
}

