/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.detecting.protocol;

import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.vertx.java.core.buffer.Buffer;

public class BufferSupport {
    private static final Field bufferField;

    public static Buffer chomp(Buffer self) {
        return self.getBuffer(0, self.length() - 1);
    }

    public static Buffer trim(Buffer self) {
        return BufferSupport.trimEnd(BufferSupport.trimFront(self));
    }

    public static Buffer trimFront(Buffer self) {
        int pos;
        int length = self.length();
        for (pos = 0; pos < length && self.getByte(pos) <= 32; ++pos) {
        }
        return pos == 0 ? self : self.getBuffer(pos, length);
    }

    public static Buffer trimEnd(Buffer self) {
        int length;
        int pos;
        for (pos = length = self.length(); pos > 0 && self.getByte(pos - 1) <= 32; --pos) {
        }
        return pos == length - 1 ? self : self.getBuffer(0, pos);
    }

    public static int indexOf(Buffer self, byte value) {
        return BufferSupport.indexOf(self, 0, self.length(), value);
    }

    public static int indexOf(Buffer self, int start, byte value) {
        return BufferSupport.indexOf(self, start, self.length(), value);
    }

    public static int indexOf(Buffer self, int start, int end, byte value) {
        int max = Math.min(end, self.length());
        while (start < end) {
            if (self.getByte(start) == value) {
                return start;
            }
            ++start;
        }
        return -1;
    }

    public static boolean startsWith(Buffer self, Buffer needle) {
        return BufferSupport.indexOf(self, 0, needle.length(), needle) == 0;
    }

    public static boolean startsWith(Buffer self, int start, Buffer needle) {
        return BufferSupport.indexOf(self, start, start + needle.length(), needle) == 0;
    }

    public static int indexOf(Buffer self, int start, Buffer needle) {
        return BufferSupport.indexOf(self, start, self.length(), needle);
    }

    public static int indexOf(Buffer self, Buffer needle) {
        return BufferSupport.indexOf(self, 0, self.length(), needle);
    }

    public static int indexOf(Buffer self, int start, int end, Buffer needle) {
        int max = Math.min(end, self.length() - needle.length());
        for (int i = start; i <= max; ++i) {
            if (!BufferSupport.matches(self, i, needle)) continue;
            return i;
        }
        return -1;
    }

    public static boolean matches(Buffer self, int pos, Buffer needle) {
        int needleLength = needle.length();
        for (int i = 0; i < needleLength; ++i) {
            if (self.getByte(pos + i) == needle.getByte(i)) continue;
            return false;
        }
        return true;
    }

    private static ByteBuf getNettyByteBuf(Buffer self) {
        try {
            return (ByteBuf)bufferField.get(self);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setLength(Buffer self, int length) {
        BufferSupport.getNettyByteBuf(self).capacity(length);
    }

    public static final Buffer[] split(Buffer self, byte separator) {
        int pos;
        ArrayList<Buffer> rc = new ArrayList<Buffer>();
        int nextStart = pos = 0;
        int end = self.length();
        while (pos < end) {
            if (self.getByte(pos) == separator) {
                if (nextStart < pos) {
                    rc.add(self.getBuffer(nextStart, pos));
                }
                nextStart = pos + 1;
            }
            ++pos;
        }
        if (nextStart < pos) {
            rc.add(self.getBuffer(nextStart, pos));
        }
        return rc.toArray(new Buffer[rc.size()]);
    }

    public static Buffer toBuffer(ByteBuffer buff) {
        Buffer self = new Buffer(buff.remaining());
        while (buff.hasRemaining()) {
            self.appendByte(buff.get());
        }
        return self;
    }

    static {
        try {
            bufferField = Buffer.class.getDeclaredField("buffer");
            bufferField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

