/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.detecting.protocol.openwire;

import io.fabric8.gateway.SocketWrapper;
import io.fabric8.gateway.handlers.detecting.Protocol;
import io.fabric8.gateway.handlers.detecting.protocol.BufferSupport;
import io.fabric8.gateway.handlers.detecting.protocol.openwire.OpenwireProtocolDecoder;
import io.fabric8.gateway.handlers.detecting.protocol.openwire.command.Command;
import io.fabric8.gateway.handlers.detecting.protocol.openwire.command.WireFormatInfo;
import io.fabric8.gateway.handlers.loadbalancer.ConnectionParameters;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;

public class OpenwireProtocol
implements Protocol {
    private static final transient Logger LOG = LoggerFactory.getLogger(OpenwireProtocol.class);
    public static Buffer MAGIC = new Buffer(new byte[]{65, 99, 116, 105, 118, 101, 77, 81});
    public int maxFrameSize = 0x6400000;
    private static final String[] SCHEMES = new String[]{"tcp", "nio"};

    @Override
    public String getProtocolName() {
        return "openwire";
    }

    @Override
    public String[] getProtocolSchemes() {
        return SCHEMES;
    }

    @Override
    public int getMaxIdentificationLength() {
        return 5 + MAGIC.length();
    }

    @Override
    public boolean matches(Buffer buffer) {
        return buffer.length() >= 4 + MAGIC.length() && BufferSupport.indexOf(buffer, 5, MAGIC) >= 0;
    }

    @Override
    public void snoopConnectionParameters(final SocketWrapper socket, Buffer received, final Handler<ConnectionParameters> handler) {
        OpenwireProtocolDecoder h = new OpenwireProtocolDecoder(this);
        h.errorHandler(new Handler<String>(){

            public void handle(String error) {
                LOG.info("Openwire protocol decoding error: " + error);
                socket.close();
            }
        });
        h.codecHandler(new Handler<Command>(){

            public void handle(Command event) {
                if (event instanceof WireFormatInfo) {
                    WireFormatInfo info = (WireFormatInfo)event;
                    ConnectionParameters parameters = new ConnectionParameters();
                    try {
                        parameters.protocolVirtualHost = info.getHost();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    handler.handle((Object)parameters);
                } else {
                    LOG.info("Expected a WireFormatInfo frame");
                    socket.close();
                }
            }
        });
        socket.readStream().dataHandler((Handler)h);
        h.handle(received);
    }
}

