/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.servlet;

import io.fabric8.gateway.model.HttpProxyRuleBase;
import io.fabric8.gateway.servlet.HttpMappingResult;
import io.fabric8.gateway.support.MappingResult;
import io.fabric8.gateway.support.MappingRuleResolver;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpMappingRuleResolver {
    private MappingRuleResolver resolver = new MappingRuleResolver();

    public HttpMappingResult findMappingRule(HttpServletRequest request, HttpServletResponse response) {
        String requestURI = request.getRequestURI();
        String contextPath = request.getContextPath();
        MappingResult answer = null;
        if (contextPath != null && contextPath.length() > 0 && !contextPath.equals("/")) {
            String requestWithoutContextPath = requestURI.substring(contextPath.length());
            answer = this.resolver.findMappingRule(requestWithoutContextPath);
        }
        if (answer == null) {
            answer = this.resolver.findMappingRule(requestURI);
        }
        return answer != null ? new HttpMappingResult(answer) : null;
    }

    public void setMappingRules(HttpProxyRuleBase mappingRules) {
        this.resolver.setMappingRules(mappingRules);
    }

    public HttpProxyRuleBase getMappingRules() {
        return this.resolver.getMappingRules();
    }
}

