<!-- BEGIN MUNGE: UNVERSIONED_WARNING -->

<!-- BEGIN STRIP_FOR_RELEASE -->

<img src="http://kubernetes.io/img/warning.png" alt="WARNING"
     width="25" height="25">
<img src="http://kubernetes.io/img/warning.png" alt="WARNING"
     width="25" height="25">
<img src="http://kubernetes.io/img/warning.png" alt="WARNING"
     width="25" height="25">
<img src="http://kubernetes.io/img/warning.png" alt="WARNING"
     width="25" height="25">
<img src="http://kubernetes.io/img/warning.png" alt="WARNING"
     width="25" height="25">

<h2>PLEASE NOTE: This document applies to the HEAD of the source tree</h2>

If you are using a released version of Kubernetes, you should
refer to the docs that go with that version.

<strong>
The latest 1.0.x release of this document can be found
[here](http://releases.k8s.io/release-1.0/docs/user-guide/walkthrough/k8s201.md).

Documentation for other releases can be found at
[releases.k8s.io](http://releases.k8s.io).
</strong>
--

<!-- END STRIP_FOR_RELEASE -->

<!-- END MUNGE: UNVERSIONED_WARNING -->

# Kubernetes 201 - Labels, Replication Controllers, Services and Health Checking

If you went through [Kubernetes 101](README.md), you learned about kubectl, pods, volumes, and multiple containers.
For Kubernetes 201, we will pick up where 101 left off and cover some slightly more advanced topics in Kubernetes, related to application productionization, deployment and
scaling.

In order for the kubectl usage examples to work, make sure you have an examples directory locally, either from [a release](https://k8s.io/kubernetes/releases) or [the source](https://k8s.io/kubernetes).

**Table of Contents**
<!-- BEGIN MUNGE: GENERATED_TOC -->

- [Kubernetes 201 - Labels, Replication Controllers, Services and Health Checking](#kubernetes-201---labels-replication-controllers-services-and-health-checking)
  - [Labels](#labels)
  - [Replication Controllers](#replication-controllers)
      - [Replication Controller Management](#replication-controller-management)
  - [Services](#services)
      - [Service Management](#service-management)
  - [Health Checking](#health-checking)
      - [Process Health Checking](#process-health-checking)
      - [Application Health Checking](#application-health-checking)
  - [What's Next?](#whats-next)

<!-- END MUNGE: GENERATED_TOC -->


## Labels

Having already learned about Pods and how to create them, you may be struck by an urge to create many, many pods.  Please do!  But eventually you will need a system to organize these pods into groups.  The system for achieving this in Kubernetes is Labels.  Labels are key-value pairs that are attached to each object in Kubernetes.  Label selectors can be passed along with a RESTful `list` request to the apiserver to retrieve a list of objects which match that label selector.

To add a label, add a labels section under metadata in the pod definition:

```yaml
  labels:
    app: nginx
```

For example, here is the nginx pod definition with labels ([pod-nginx-with-label.yaml](pod-nginx-with-label.yaml)):

<!-- BEGIN MUNGE: EXAMPLE pod-nginx-with-label.yaml -->

```yaml
apiVersion: v1
kind: Pod
metadata:
  name: nginx
  labels:
    app: nginx
spec:
  containers:
  - name: nginx
    image: nginx
    ports:
    - containerPort: 80
```

[Download example](pod-nginx-with-label.yaml)
<!-- END MUNGE: EXAMPLE pod-nginx-with-label.yaml -->

Create the labeled pod ([pod-nginx-with-label.yaml](pod-nginx-with-label.yaml)):

```console
$ kubectl create -f docs/user-guide/walkthrough/pod-nginx-with-label.yaml
```

List all pods with the label `app=nginx`:

```console
$ kubectl get pods -l app=nginx
```

For more information, see [Labels](../labels.md).
They are a core concept used by two additional Kubernetes building blocks: Replication Controllers and Services.


## Replication Controllers

OK, now you know how to make awesome, multi-container, labeled pods and you want to use them to build an application, you might be tempted to just start building a whole bunch of individual pods, but if you do that, a whole host of operational concerns pop up.  For example: how will you scale the number of pods up or down and how will you ensure that all pods are homogenous?

Replication controllers are the objects to answer these questions.  A replication controller combines a template for pod creation (a "cookie-cutter" if you will) and a number of desired replicas, into a single Kubernetes object.  The replication controller also contains a label selector that identifies the set of objects managed by the replication controller.  The replication controller constantly measures the size of this set relative to the desired size, and takes action by creating or deleting pods.

For example, here is a replication controller that instantiates two nginx pods ([replication-controller.yaml](replication-controller.yaml)):

<!-- BEGIN MUNGE: EXAMPLE replication-controller.yaml -->

```yaml
apiVersion: v1
kind: ReplicationController
metadata:
  name: nginx-controller
spec:
  replicas: 2
  # selector identifies the set of Pods that this
  # replication controller is responsible for managing
  selector:
    app: nginx
  # podTemplate defines the 'cookie cutter' used for creating
  # new pods when necessary
  template:
    metadata:
      labels:
        # Important: these labels need to match the selector above
        # The api server enforces this constraint.
        app: nginx
    spec:
      containers:
      - name: nginx
        image: nginx
        ports:
        - containerPort: 80
```

[Download example](replication-controller.yaml)
<!-- END MUNGE: EXAMPLE replication-controller.yaml -->

#### Replication Controller Management

Create an nginx replication controller ([replication-controller.yaml](replication-controller.yaml)):

```console
$ kubectl create -f docs/user-guide/walkthrough/replication-controller.yaml
```

List all replication controllers:

```console
$ kubectl get rc
```

Delete the replication controller by name:

```console
$ kubectl delete rc nginx-controller
```

For more information, see [Replication Controllers](../replication-controller.md).


## Services

Once you have a replicated set of pods, you need an abstraction that enables connectivity between the layers of your application.  For example, if you have a replication controller managing your backend jobs, you don't want to have to reconfigure your front-ends whenever you re-scale your backends.  Likewise, if the pods in your backends are scheduled (or rescheduled) onto different machines, you can't be required to re-configure your front-ends.  In Kubernetes, the service abstraction achieves these goals.  A service provides a way to refer to a set of pods (selected by labels) with a single static IP address. It may also provide load balancing, if supported by the provider.

For example, here is a service that balances across the pods created in the previous nginx replication controller example ([service.yaml](service.yaml)):

<!-- BEGIN MUNGE: EXAMPLE service.yaml -->

```yaml
apiVersion: v1
kind: Service
metadata:
  name: nginx-service
spec:
  ports:
  - port: 8000 # the port that this service should serve on
    # the container on each pod to connect to, can be a name
    # (e.g. 'www') or a number (e.g. 80)
    targetPort: 80
    protocol: TCP
  # just like the selector in the replication controller,
  # but this time it identifies the set of pods to load balance
  # traffic to.
  selector:
    app: nginx
```

[Download example](service.yaml)
<!-- END MUNGE: EXAMPLE service.yaml -->

#### Service Management

Create an nginx service ([service.yaml](service.yaml)):

```console
$ kubectl create -f docs/user-guide/walkthrough/service.yaml
```

List all services:

```console
$ kubectl get services
```

On most providers, the service IPs are not externally accessible. The easiest way to test that the service is working is to create a busybox pod and exec commands on it remotely. See the [command execution documentation](../kubectl/kubectl_exec.md) for details.

Provided the service IP is accessible, you should be able to access its http endpoint with curl on port 80:

```console
$ export SERVICE_IP=$(kubectl get service nginx-service -o=template -t={{.spec.clusterIP}})
$ export SERVICE_PORT=$(kubectl get service nginx-service -o=template '-t={{(index .spec.ports 0).port}}')
$ curl http://${SERVICE_IP}:${SERVICE_PORT}
```

To delete the service by name:

```console
$ kubectl delete service nginx-controller
```

When created, each service is assigned a unique IP address.  This address is tied to the lifespan of the Service, and will not change while the Service is alive.  Pods can be configured to talk to the service, and know that communication to the service will be automatically load-balanced out to some pod that is a member of the set identified by the label selector in the Service.

For more information, see [Services](../services.md).


## Health Checking

When I write code it never crashes, right?  Sadly the [Kubernetes issues list](https://k8s.io/kubernetes/issues) indicates otherwise...

Rather than trying to write bug-free code, a better approach is to use a management system to perform periodic health checking
and repair of your application.  That way a system outside of your application itself is responsible for monitoring the
application and taking action to fix it.  It's important that the system be outside of the application, since if
your application fails and the health checking agent is part of your application, it may fail as well and you'll never know.
In Kubernetes, the health check monitor is the Kubelet agent.

#### Process Health Checking

The simplest form of health-checking is just process level health checking.  The Kubelet constantly asks the Docker daemon
if the container process is still running, and if not, the container process is restarted.  In all of the Kubernetes examples
you have run so far, this health checking was actually already enabled.  It's on for every single container that runs in
Kubernetes.

#### Application Health Checking

However, in many cases this low-level health checking is insufficient.  Consider, for example, the following code:

```go
lockOne := sync.Mutex{}
lockTwo := sync.Mutex{}

go func() {
  lockOne.Lock();
  lockTwo.Lock();
  ...
}()

lockTwo.Lock();
lockOne.Lock();
```

This is a classic example of a problem in computer science known as ["Deadlock"](https://en.wikipedia.org/wiki/Deadlock). From Docker's perspective your application is
still operating and the process is still running, but from your application's perspective your code is locked up and will never respond correctly.

To address this problem, Kubernetes supports user implemented application health-checks.  These checks are performed by the
Kubelet to ensure that your application is operating correctly for a definition of "correctly" that _you_ provide.

Currently, there are three types of application health checks that you can choose from:

   * HTTP Health Checks - The Kubelet will call a web hook.  If it returns between 200 and 399, it is considered success, failure otherwise. See health check examples [here](../liveness/).
   * Container Exec - The Kubelet will execute a command inside your container.  If it exits with status 0 it will be considered a success. See health check examples [here](../liveness/).
   * TCP Socket - The Kubelet will attempt to open a socket to your container.  If it can establish a connection, the container is considered healthy, if it can't it is considered a failure.

In all cases, if the Kubelet discovers a failure the container is restarted.

The container health checks are configured in the `livenessProbe` section of your container config. There you can also specify an `initialDelaySeconds` that is a grace period from when the container is started to when health checks are performed, to enable your container to perform any necessary initialization.

Here is an example config for a pod with an HTTP health check ([pod-with-http-healthcheck.yaml](pod-with-http-healthcheck.yaml)):

<!-- BEGIN MUNGE: EXAMPLE pod-with-http-healthcheck.yaml -->

```yaml
apiVersion: v1
kind: Pod
metadata:
  name: pod-with-healthcheck
spec:
  containers:
  - name: nginx
    image: nginx
    # defines the health checking
    livenessProbe:
      # an http probe
      httpGet:
        path: /_status/healthz
        port: 80
      # length of time to wait for a pod to initialize
      # after pod startup, before applying health checking
      initialDelaySeconds: 30
      timeoutSeconds: 1
    ports:
    - containerPort: 80
```

[Download example](pod-with-http-healthcheck.yaml)
<!-- END MUNGE: EXAMPLE pod-with-http-healthcheck.yaml -->

For more information about health checking, see [Container Probes](../pod-states.md#container-probes).


## What's Next?

For a complete application see the [guestbook example](../../../examples/guestbook/).


<!-- BEGIN MUNGE: GENERATED_ANALYTICS -->
[![Analytics](https://kubernetes-site.appspot.com/UA-36037335-10/GitHub/docs/user-guide/walkthrough/k8s201.md?pixel)]()
<!-- END MUNGE: GENERATED_ANALYTICS -->
