/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public final class ExecParseUtils {
    public static final String WHITESPACE = " ";
    public static final String QUOTE_CHAR = "\"";

    private ExecParseUtils() {
    }

    public static List<String> splitToWhiteSpaceSeparatedTokens(String input) {
        if (input == null) {
            return new ArrayList<String>();
        }
        StringTokenizer tokenizer = new StringTokenizer(input.trim(), "\" ", true);
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder quotedText = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (QUOTE_CHAR.equals(token)) {
                quotedText.append(QUOTE_CHAR);
                String buffer = quotedText.toString();
                if (!ExecParseUtils.isSingleQuoted(buffer) && !ExecParseUtils.isDoubleQuoted(buffer)) continue;
                tokens.add(buffer.substring(1, buffer.length() - 1));
                quotedText = new StringBuilder();
                continue;
            }
            if (WHITESPACE.equals(token)) {
                if (quotedText.length() <= 0) continue;
                quotedText.append(WHITESPACE);
                continue;
            }
            if (quotedText.length() > 0) {
                quotedText.append(token);
                continue;
            }
            tokens.add(token);
        }
        if (quotedText.length() > 0) {
            throw new IllegalArgumentException("Invalid quoting found in args " + quotedText);
        }
        return tokens;
    }

    protected static boolean isSingleQuoted(String input) {
        if (input == null || input.trim().length() == 0) {
            return false;
        }
        return input.matches("(^\"{1}([^\"]+)\"{1})");
    }

    protected static boolean isDoubleQuoted(String input) {
        if (input == null || input.trim().length() == 0) {
            return false;
        }
        return input.matches("(^\"{2}([^\"]+)\"{2})");
    }
}

