/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.impl;

import io.fabric8.patch.management.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class OSGiPatchHelper {
    private File karafHome;
    private BundleContext bundleContext;

    public OSGiPatchHelper(File karafHome, BundleContext bundleContext) {
        this.karafHome = karafHome;
        this.bundleContext = bundleContext;
    }

    public Map<String, Bundle> getCoreBundles(Bundle[] allBundles) throws IOException {
        HashMap<String, Bundle> coreBundles = new HashMap<String, Bundle>();
        Properties props = new Properties();
        FileInputStream stream = new FileInputStream(new File(this.karafHome, "etc/startup.properties"));
        props.load(stream);
        HashSet<String> locations = new HashSet<String>();
        for (String startupBundle : props.stringPropertyNames()) {
            locations.add(Utils.pathToMvnurl((String)startupBundle));
        }
        for (Bundle b : allBundles) {
            String symbolicName = Utils.stripSymbolicName((String)b.getSymbolicName());
            if ("org.apache.felix.framework".equals(symbolicName)) {
                coreBundles.put(symbolicName, b);
                continue;
            }
            if ("org.ops4j.pax.url.mvn".equals(symbolicName)) {
                coreBundles.put(symbolicName, b);
                continue;
            }
            if (!locations.contains(b.getLocation())) continue;
            coreBundles.put(symbolicName, b);
        }
        IOUtils.closeQuietly(stream);
        return coreBundles;
    }

    public String[] getBundleIdentity(String url) throws IOException {
        String vr;
        URL loc = new URL(url);
        String newUrl = Utils.mvnurlToPath((String)url);
        File repoLocation = new File(Utils.getSystemRepository((File)this.karafHome, (BundleContext)this.bundleContext), newUrl);
        if (repoLocation.isFile()) {
            loc = repoLocation.toURI().toURL();
        }
        JarInputStream jis = new JarInputStream(loc.openStream());
        jis.close();
        Manifest manifest = jis.getManifest();
        Attributes att = manifest != null ? manifest.getMainAttributes() : null;
        String sn = att != null ? att.getValue("Bundle-SymbolicName") : null;
        String string = vr = att != null ? att.getValue("Bundle-Version") : null;
        if (sn == null || vr == null) {
            return null;
        }
        return new String[]{sn, vr};
    }
}

