/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.impl;

import io.fabric8.patch.Service;
import io.fabric8.patch.impl.OSGiPatchHelper;
import io.fabric8.patch.impl.Presentation;
import io.fabric8.patch.management.Artifact;
import io.fabric8.patch.management.BackupService;
import io.fabric8.patch.management.BundleUpdate;
import io.fabric8.patch.management.FeatureUpdate;
import io.fabric8.patch.management.Patch;
import io.fabric8.patch.management.PatchData;
import io.fabric8.patch.management.PatchDetailsRequest;
import io.fabric8.patch.management.PatchException;
import io.fabric8.patch.management.PatchKind;
import io.fabric8.patch.management.PatchManagement;
import io.fabric8.patch.management.PatchResult;
import io.fabric8.patch.management.Pending;
import io.fabric8.patch.management.Utils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import org.apache.commons.io.FileUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.utils.manifest.Attribute;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Directive;
import org.apache.felix.utils.manifest.Parser;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Conditional;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.apache.karaf.util.bundles.BundleUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.component.ComponentContext;

@Component(immediate=true, metatype=false)
@org.apache.felix.scr.annotations.Service(value={Service.class})
public class ServiceImpl
implements Service {
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String DATE = "date";
    private static final String BUNDLES = "bundle";
    private static final String UPDATES = "update";
    private static final String COUNT = "count";
    private static final String RANGE = "range";
    private static final String SYMBOLIC_NAME = "symbolic-name";
    private static final String NEW_VERSION = "new-version";
    private static final String NEW_LOCATION = "new-location";
    private static final String OLD_VERSION = "old-version";
    private static final String OLD_LOCATION = "old-location";
    private static final String STARTUP = "startup";
    private static final String OVERRIDES = "overrides";
    private BundleContext bundleContext;
    private File patchDir;
    @Reference(referenceInterface=PatchManagement.class, cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    private PatchManagement patchManagement;
    @Reference(referenceInterface=FeaturesService.class, cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    private FeaturesService featuresService;
    @Reference(referenceInterface=BackupService.class, cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    private BackupService backupService;
    private File karafHome;
    private File repository;
    private OSGiPatchHelper helper;

    @Activate
    void activate(ComponentContext componentContext) throws IOException {
        this.bundleContext = componentContext.getBundleContext().getBundle(0L).getBundleContext();
        String dir = this.bundleContext.getProperty("fuse.patch.location");
        if (dir != null) {
            this.patchDir = new File(dir);
        } else {
            dir = this.bundleContext.getProperty("fabric8.patch.location");
            if (dir != null) {
                this.patchDir = new File(dir);
            } else {
                if (this.patchManagement.isStandaloneChild()) {
                    this.patchDir = new File(System.getProperty("karaf.home"), "patches");
                }
                if (this.patchDir == null) {
                    this.patchDir = this.bundleContext.getDataFile("patches");
                }
            }
        }
        if (!this.patchDir.isDirectory()) {
            this.patchDir.mkdirs();
            if (!this.patchDir.isDirectory()) {
                throw new PatchException("Unable to create patch folder");
            }
        }
        this.karafHome = new File(this.bundleContext.getProperty("karaf.home"));
        this.repository = new File(this.bundleContext.getProperty("karaf.default.repository"));
        this.helper = new OSGiPatchHelper(this.karafHome, this.bundleContext);
        this.load(true);
        this.resumePendingPatchTasks();
    }

    private void resumePendingPatchTasks() throws IOException {
        File[] pendingPatches = this.patchDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.exists() && pathname.getName().endsWith(".pending");
            }
        });
        if (pendingPatches == null || pendingPatches.length == 0) {
            return;
        }
        for (File pending : pendingPatches) {
            File file;
            File patchFile;
            Pending what = Pending.valueOf((String)FileUtils.readFileToString(pending));
            String name = pending.getName().replaceFirst("\\.pending$", "");
            if (this.patchManagement.isStandaloneChild()) {
                if (!name.endsWith("." + System.getProperty("karaf.name") + ".patch")) continue;
                name = name.replaceFirst("\\." + System.getProperty("karaf.name"), "");
            }
            if (!(patchFile = new File(pending.getParentFile(), name)).isFile()) {
                System.out.println("Ignoring patch result file: " + patchFile.getName());
                continue;
            }
            PatchData patchData = PatchData.load((InputStream)new FileInputStream(patchFile));
            Patch patch = this.patchManagement.loadPatch(new PatchDetailsRequest(patchData.getId()));
            System.out.printf("Resume %s of %spatch \"%s\"%n", what == Pending.ROLLUP_INSTALLATION ? "installation" : "rollback", patch.getPatchData().isRollupPatch() ? "rollup " : "", patch.getPatchData().getId());
            PatchResult result = patch.getResult();
            if (this.patchManagement.isStandaloneChild() && (result = (PatchResult)result.getChildPatches().get(System.getProperty("karaf.name"))) == null) {
                System.out.println("Ignoring patch result file: " + patchFile.getName());
                continue;
            }
            LinkedHashSet<String> newRepositories = new LinkedHashSet<String>();
            LinkedHashSet<String> features = new LinkedHashSet<String>();
            for (FeatureUpdate featureUpdate : result.getFeatureUpdates()) {
                if (featureUpdate.getName() == null && featureUpdate.getPreviousRepository() != null) {
                    newRepositories.add(featureUpdate.getPreviousRepository());
                    continue;
                }
                if (featureUpdate.getNewRepository() == null) {
                    newRepositories.add(featureUpdate.getPreviousRepository());
                    features.add(String.format("%s|%s", featureUpdate.getName(), featureUpdate.getPreviousVersion()));
                    continue;
                }
                if (what == Pending.ROLLUP_INSTALLATION) {
                    newRepositories.add(featureUpdate.getNewRepository());
                    features.add(String.format("%s|%s", featureUpdate.getName(), featureUpdate.getNewVersion()));
                    continue;
                }
                newRepositories.add(featureUpdate.getPreviousRepository());
                features.add(String.format("%s|%s", featureUpdate.getName(), featureUpdate.getPreviousVersion()));
            }
            for (String repo : newRepositories) {
                System.out.println("Restoring feature repository: " + repo);
                try {
                    this.featuresService.addRepository(URI.create(repo));
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                    e.printStackTrace(System.err);
                    System.err.flush();
                }
            }
            for (String f : features) {
                String[] fv = f.split("\\|");
                System.out.printf("Restoring feature %s/%s%n", fv[0], fv[1]);
                try {
                    this.featuresService.installFeature(fv[0], fv[1]);
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                    e.printStackTrace(System.err);
                    System.err.flush();
                }
            }
            for (BundleUpdate update : result.getBundleUpdates()) {
                if (!update.isIndependent()) continue;
                String location = null;
                if (update.getNewVersion() == null) {
                    System.out.printf("Restoring bundle %s from %s%n", update.getSymbolicName(), update.getPreviousLocation());
                    location = update.getPreviousLocation();
                } else if (what == Pending.ROLLUP_INSTALLATION) {
                    System.out.printf("Updating bundle %s from %s%n", update.getSymbolicName(), update.getNewLocation());
                    location = update.getNewLocation();
                } else {
                    System.out.printf("Downgrading bundle %s from %s%n", update.getSymbolicName(), update.getPreviousLocation());
                    location = update.getPreviousLocation();
                }
                try {
                    Bundle b = this.bundleContext.installBundle(location);
                    if (update.getStartLevel() > -1) {
                        ((BundleStartLevel)b.adapt(BundleStartLevel.class)).setStartLevel(update.getStartLevel());
                    }
                    switch (update.getState()) {
                        case 1: 
                        case 2: 
                        case 8: 
                        case 16: {
                            break;
                        }
                        case 4: {
                            break;
                        }
                        case 32: {
                            b.start();
                        }
                    }
                }
                catch (BundleException e) {
                    System.err.println(" - " + e.getMessage());
                    System.err.flush();
                }
            }
            pending.delete();
            System.out.printf("%spatch \"%s\" %s successfully%n", patch.getPatchData().isRollupPatch() ? "Rollup " : "", patchData.getId(), what == Pending.ROLLUP_INSTALLATION ? "installed" : "rolled back");
            if (what != Pending.ROLLUP_ROLLBACK) continue;
            List bases = patch.getResult().getKarafBases();
            Iterator iterator = bases.iterator();
            while (iterator.hasNext()) {
                String s = (String)iterator.next();
                if (!s.startsWith(System.getProperty("karaf.name"))) continue;
                iterator.remove();
            }
            result.setPending(null);
            patch.getResult().store();
            if (patch.getResult().getKarafBases().size() == 0) {
                file = new File(this.patchDir, patchData.getId() + ".patch.result");
                file.delete();
            }
            if (!this.patchManagement.isStandaloneChild() || !(file = new File(this.patchDir, patchData.getId() + "." + System.getProperty("karaf.name") + ".patch.result")).isFile()) continue;
            file.delete();
        }
    }

    public Iterable<Patch> getPatches() {
        return Collections.unmodifiableCollection(this.load(true).values());
    }

    public Patch getPatch(String id) {
        return this.patchManagement.loadPatch(new PatchDetailsRequest(id));
    }

    public Iterable<Patch> download(URL url) {
        if ("file".equals(url.getProtocol())) {
            try {
                if (!new File(url.toURI()).isFile()) {
                    throw new PatchException("Path " + url.getPath() + " doesn't exist or is not a file");
                }
            }
            catch (URISyntaxException e) {
                throw new PatchException(e.getMessage(), (Throwable)e);
            }
        }
        try {
            List patchesData = this.patchManagement.fetchPatches(url);
            ArrayList<Patch> patches = new ArrayList<Patch>(patchesData.size());
            for (PatchData patchData : patchesData) {
                Patch patch = this.patchManagement.trackPatch(patchData);
                patches.add(patch);
            }
            return patches;
        }
        catch (Exception e) {
            throw new PatchException("Unable to download patch from url " + url, (Throwable)e);
        }
    }

    private Map<String, Patch> load(boolean details) {
        List patchesList = this.patchManagement.listPatches(details);
        HashMap<String, Patch> patches = new HashMap<String, Patch>();
        for (Patch patch : patchesList) {
            patches.put(patch.getPatchData().getId(), patch);
        }
        return patches;
    }

    public void cliInstall(String[] ids) {
        ArrayList<Patch> patches = new ArrayList<Patch>();
        for (String id : ids) {
            Patch patch = this.getPatch(id);
            if (patch == null) {
                throw new IllegalArgumentException("Unknown patch: " + id);
            }
            patches.add(patch);
        }
        this.install(patches, false, false);
    }

    public PatchResult install(Patch patch, boolean simulate) {
        return this.install(patch, simulate, true);
    }

    public PatchResult install(Patch patch, boolean simulate, boolean synchronous) {
        Map<String, PatchResult> results = this.install(Collections.singleton(patch), simulate, synchronous);
        return results.get(patch.getPatchData().getId());
    }

    private Map<String, PatchResult> install(final Collection<Patch> patches, boolean simulate, boolean synchronous) {
        PatchKind kind = this.checkConsistency(patches);
        this.checkPrerequisites(patches);
        this.checkStandaloneChild(patches);
        String transaction = null;
        try {
            Patch results = new LinkedHashMap();
            Bundle[] allBundles = this.bundleContext.getBundles();
            final HashMap<Bundle, String> bundleUpdateLocations = new HashMap<Bundle, String>();
            LinkedHashMap<String, BundleUpdate> updatesForBundleKeys = new LinkedHashMap<String, BundleUpdate>();
            LinkedHashMap<String, FeatureUpdate> updatesForFeatureKeys = new LinkedHashMap<String, FeatureUpdate>();
            BundleVersionHistory history = this.createBundleVersionHistory();
            transaction = this.patchManagement.beginInstallation(kind);
            Map<String, Bundle> coreBundles = this.helper.getCoreBundles(allBundles);
            for (Patch patch : patches) {
                List<FeatureUpdate> featureUpdatesInThisPatch = null;
                if (kind == PatchKind.ROLLUP) {
                    featureUpdatesInThisPatch = this.featureUpdatesInPatch(patch, updatesForFeatureKeys, kind);
                    this.helper.sortFeatureUpdates(featureUpdatesInThisPatch);
                }
                List<BundleUpdate> bundleUpdatesInThisPatch = this.bundleUpdatesInPatch(patch, allBundles, bundleUpdateLocations, history, updatesForBundleKeys, kind, coreBundles, featureUpdatesInThisPatch);
                this.patchManagement.install(transaction, patch, bundleUpdatesInThisPatch);
                if (!simulate) {
                    this.installMigratorBundle(patch);
                }
                PatchResult result = null;
                if (patch.getResult() != null) {
                    result = patch.getResult();
                    if (this.patchManagement.isStandaloneChild()) {
                        PatchResult childResult = new PatchResult(patch.getPatchData(), simulate, System.currentTimeMillis(), bundleUpdatesInThisPatch, featureUpdatesInThisPatch, result);
                        result.addChildResult(System.getProperty("karaf.name"), childResult);
                    }
                } else {
                    result = new PatchResult(patch.getPatchData(), simulate, System.currentTimeMillis(), bundleUpdatesInThisPatch, featureUpdatesInThisPatch);
                }
                result.getKarafBases().add(String.format("%s | %s", System.getProperty("karaf.name"), System.getProperty("karaf.base")));
                results.put(patch.getPatchData().getId(), result);
            }
            if (kind == PatchKind.NON_ROLLUP) {
                for (Map.Entry entry : bundleUpdateLocations.entrySet()) {
                    Bundle bundle = (Bundle)entry.getKey();
                    if (bundle.getSymbolicName() == null || !"org.ops4j.pax.url.mvn".equals(Utils.stripSymbolicName((String)bundle.getSymbolicName()))) continue;
                    URL location = new URL((String)entry.getValue());
                    System.out.printf("Special update of bundle \"%s\" from \"%s\"%n", bundle.getSymbolicName(), location);
                    if (!simulate) {
                        BundleUtils.update(bundle, location);
                        bundle.start();
                    }
                    bundleUpdateLocations.put(bundle, location.toString());
                }
            }
            Presentation.displayFeatureUpdates(updatesForFeatureKeys.values(), true);
            Presentation.displayBundleUpdates(updatesForBundleKeys.values(), true);
            if (kind == PatchKind.ROLLUP) {
                Patch patch;
                if (!simulate) {
                    if (patches.size() == 1) {
                        patch = patches.iterator().next();
                        PatchResult patchResult = (PatchResult)results.get(patch.getPatchData().getId());
                        patch.setResult(patchResult);
                        if (this.patchManagement.isStandaloneChild()) {
                            this.backupService.backupDataFiles((PatchResult)patchResult.getChildPatches().get(System.getProperty("karaf.name")), Pending.ROLLUP_INSTALLATION);
                        } else {
                            this.backupService.backupDataFiles(patchResult, Pending.ROLLUP_INSTALLATION);
                        }
                        for (Bundle b : coreBundles.values()) {
                            if (b.getSymbolicName() == null || !Utils.stripSymbolicName((String)b.getSymbolicName()).equals("org.apache.felix.fileinstall")) continue;
                            b.stop(1);
                            break;
                        }
                        this.patchManagement.commitInstallation(transaction);
                        if (this.patchManagement.isStandaloneChild()) {
                            ((PatchResult)patchResult.getChildPatches().get(System.getProperty("karaf.name"))).setPending(Pending.ROLLUP_INSTALLATION);
                        } else {
                            patchResult.setPending(Pending.ROLLUP_INSTALLATION);
                        }
                        patchResult.store();
                        if (this.isJvmRestartNeeded((Map<String, PatchResult>)results)) {
                            boolean handlesFullRestart = Boolean.getBoolean("karaf.restart.jvm.supported");
                            if (handlesFullRestart) {
                                System.out.println("Rollup patch " + patch.getPatchData().getId() + " installed. Restarting Karaf..");
                                System.setProperty("karaf.restart.jvm", "true");
                            } else {
                                System.out.println("Rollup patch " + patch.getPatchData().getId() + " installed. Shutting down Karaf, please restart...");
                            }
                        } else {
                            System.setProperty("karaf.restart", "true");
                        }
                        File karafData = new File(this.bundleContext.getProperty("karaf.data"));
                        File cleanCache = new File(karafData, "clean_cache");
                        cleanCache.createNewFile();
                        Thread.currentThread().setContextClassLoader(((BundleWiring)this.bundleContext.getBundle(0L).adapt(BundleWiring.class)).getClassLoader());
                        this.bundleContext.getBundle(0L).stop();
                    }
                } else {
                    System.out.println("Simulation only - no files and runtime data will be modified.");
                    this.patchManagement.rollbackInstallation(transaction);
                }
                patch = results;
                return patch;
            }
            if (!simulate) {
                this.patchManagement.commitInstallation(transaction);
            } else {
                this.patchManagement.rollbackInstallation(transaction);
            }
            if (!simulate) {
                Runnable task = new Runnable((Map)results){
                    final /* synthetic */ Map val$results;
                    {
                        this.val$results = map2;
                    }

                    @Override
                    public void run() {
                        try {
                            ServiceImpl.this.applyChanges(bundleUpdateLocations);
                            for (Patch patch : patches) {
                                PatchResult result = (PatchResult)this.val$results.get(patch.getPatchData().getId());
                                patch.setResult(result);
                                result.store();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                            System.err.flush();
                        }
                    }
                };
                if (synchronous) {
                    task.run();
                } else {
                    new Thread(task).start();
                }
            } else {
                System.out.println("Simulation only - no files and runtime data will be modified.");
            }
            Patch patch = results;
            return patch;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.err.flush();
            if (transaction != null && this.patchManagement != null) {
                this.patchManagement.rollbackInstallation(transaction);
            }
            throw new PatchException(e.getMessage(), (Throwable)e);
        }
        finally {
            System.out.flush();
        }
    }

    private void checkFabric() {
        ServiceReference reference = this.bundleContext.getServiceReference("io.fabric8.api.FabricService");
        if (reference != null && this.bundleContext.getService(reference) != null) {
            throw new UnsupportedOperationException("In fabric mode patches can be managed only with 'patch:fabric-install' command");
        }
    }

    private boolean isJvmRestartNeeded(Map<String, PatchResult> results) {
        for (PatchResult result : results.values()) {
            if (!this.isJvmRestartNeeded(result)) continue;
            return true;
        }
        return false;
    }

    private boolean isJvmRestartNeeded(PatchResult result) {
        for (String file : result.getPatchData().getFiles()) {
            if (!file.startsWith("lib/") && !file.equals("etc/jre.properties")) continue;
            return true;
        }
        return false;
    }

    private List<BundleUpdate> bundleUpdatesInPatch(Patch patch, Bundle[] allBundles, Map<Bundle, String> bundleUpdateLocations, BundleVersionHistory history, Map<String, BundleUpdate> updatesForBundleKeys, PatchKind kind, Map<String, Bundle> coreBundles, List<FeatureUpdate> featureUpdatesInThisPatch) throws Exception {
        String key;
        Version updateableVersion;
        Version v;
        LinkedList<BundleUpdate> updatesInThisPatch = new LinkedList<BundleUpdate>();
        LinkedHashMap<String, Bundle> updateNotRequired = new LinkedHashMap<String, Bundle>();
        HashMap<String, String> locationsOfBundleKeys = new HashMap<String, String>();
        for (Bundle b : allBundles) {
            if (b.getSymbolicName() == null) continue;
            v = b.getVersion();
            updateableVersion = new Version(v.getMajor(), v.getMinor(), 0);
            key = String.format("%s|%s", Utils.stripSymbolicName((String)b.getSymbolicName()), updateableVersion.toString());
            if (!coreBundles.containsKey(Utils.stripSymbolicName((String)b.getSymbolicName()))) {
                updateNotRequired.put(key, b);
            } else {
                updateNotRequired.put(Utils.stripSymbolicName((String)b.getSymbolicName()), b);
            }
            String location = b.getLocation();
            if (location != null && location.startsWith("mvn:") && location.contains("//")) {
                location = location.replace("//", "/jar/");
            }
            locationsOfBundleKeys.put(location, key);
        }
        HashSet bundleKeysFromFeatures = new HashSet();
        if (featureUpdatesInThisPatch != null) {
            for (FeatureUpdate featureUpdate : featureUpdatesInThisPatch) {
                if (featureUpdate.getName() == null) continue;
                String fName = featureUpdate.getName();
                String fVersion = featureUpdate.getPreviousVersion();
                Feature f = this.featuresService.getFeature(fName, fVersion);
                for (BundleInfo bundleInfo : f.getBundles()) {
                    if (!locationsOfBundleKeys.containsKey(bundleInfo.getLocation())) continue;
                    bundleKeysFromFeatures.add(locationsOfBundleKeys.get(bundleInfo.getLocation()));
                }
                for (Conditional cond : f.getConditional()) {
                    for (BundleInfo bundleInfo : cond.getBundles()) {
                        if (!locationsOfBundleKeys.containsKey(bundleInfo.getLocation())) continue;
                        bundleKeysFromFeatures.add(locationsOfBundleKeys.get(bundleInfo.getLocation()));
                    }
                }
            }
        }
        for (String newLocation : patch.getPatchData().getBundles()) {
            BundleUpdate oldUpdate;
            Artifact artifact;
            String[] symbolicNameVersion = this.helper.getBundleIdentity(newLocation);
            if (symbolicNameVersion == null || symbolicNameVersion[0] == null) continue;
            String sn = Utils.stripSymbolicName((String)symbolicNameVersion[0]);
            String vr = symbolicNameVersion[1];
            Version newVersion = VersionTable.getVersion(vr);
            Version updateableVersion2 = new Version(newVersion.getMajor(), newVersion.getMinor(), 0);
            String key2 = null;
            key2 = !coreBundles.containsKey(sn) ? String.format("%s|%s", sn, updateableVersion2.toString()) : sn;
            VersionRange range = this.getUpdateableRange(patch, newLocation, newVersion);
            if (coreBundles.containsKey(sn)) {
                range = range == null ? new VersionRange(false, Version.emptyVersion, newVersion, true) : new VersionRange(false, Version.emptyVersion, range.getCeiling(), true);
            } else if (range != null) {
                key2 = String.format("%s|%s", sn, range.getFloor().toString());
            }
            Bundle bundle = (Bundle)updateNotRequired.get(key2);
            if (bundle == null && coreBundles.containsKey(sn)) {
                bundle = (Bundle)updateNotRequired.get(sn);
            }
            if (bundle == null || range == null) {
                if (kind != PatchKind.NON_ROLLUP || range != null) continue;
                System.err.printf("Skipping bundle %s - unable to process bundle without a version range configuration%n", newLocation);
                continue;
            }
            Version oldVersion = bundle.getVersion();
            if (!range.contains(oldVersion)) continue;
            String oldLocation = history.getLocation(bundle);
            if ("org.ops4j.pax.url.mvn".equals(sn) && (artifact = Utils.mvnurlToArtifact((String)newLocation, (boolean)true)) != null) {
                URL location = new File(this.repository, String.format("org/ops4j/pax/url/pax-url-aether/%1$s/pax-url-aether-%1$s.jar", artifact.getVersion())).toURI().toURL();
                newLocation = location.toString();
            }
            int startLevel = ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).getStartLevel();
            int state = bundle.getState();
            BundleUpdate update = new BundleUpdate(sn, newVersion.toString(), newLocation, oldVersion.toString(), oldLocation, startLevel, state);
            if (bundleKeysFromFeatures.contains(key2) || coreBundles.containsKey(sn)) {
                update.setIndependent(false);
            }
            updatesInThisPatch.add(update);
            updateNotRequired.remove(key2);
            if (coreBundles.containsKey(sn)) {
                updateNotRequired.remove(sn);
            }
            if ((oldUpdate = updatesForBundleKeys.get(key2)) != null) {
                Version upv = null;
                if (oldUpdate.getNewVersion() != null) {
                    upv = VersionTable.getVersion(oldUpdate.getNewVersion());
                }
                if (upv != null && upv.compareTo(newVersion) >= 0) continue;
                updatesForBundleKeys.put(key2, update);
                bundleUpdateLocations.put(bundle, newLocation);
                continue;
            }
            updatesForBundleKeys.put(key2, update);
            bundleUpdateLocations.put(bundle, newLocation);
        }
        if (kind == PatchKind.ROLLUP) {
            for (Bundle b : updateNotRequired.values()) {
                if (b.getSymbolicName() == null) continue;
                String symbolicName = Utils.stripSymbolicName((String)b.getSymbolicName());
                v = b.getVersion();
                updateableVersion = new Version(v.getMajor(), v.getMinor(), 0);
                key = String.format("%s|%s", symbolicName, updateableVersion.toString());
                int startLevel = ((BundleStartLevel)b.adapt(BundleStartLevel.class)).getStartLevel();
                int state = b.getState();
                BundleUpdate update = new BundleUpdate(symbolicName, null, null, v.toString(), history.getLocation(b), startLevel, state);
                if (bundleKeysFromFeatures.contains(key) || coreBundles.containsKey(symbolicName)) {
                    update.setIndependent(false);
                }
                updatesInThisPatch.add(update);
                updatesForBundleKeys.put(key, update);
            }
        }
        return updatesInThisPatch;
    }

    private List<FeatureUpdate> featureUpdatesInPatch(Patch patch, Map<String, FeatureUpdate> updatesForFeatureKeys, PatchKind kind) throws Exception {
        HashSet<Object> addedRepositoryNames = new HashSet();
        HashMap<String, Repository> after = null;
        try {
            String key;
            Version lowestUpdateableVersion;
            Version v;
            LinkedList<FeatureUpdate> updatesInThisPatch = new LinkedList<FeatureUpdate>();
            HashMap<String, Repository> before = new HashMap<String, Repository>(this.getAvailableFeatureRepositories());
            for (String url : patch.getPatchData().getFeatureFiles()) {
                this.featuresService.addRepository(new URI(url));
            }
            after = this.getAvailableFeatureRepositories();
            HashMap<String, String> featuresInOldRepositories = new HashMap<String, String>();
            MultiMap<String, String> singleFeaturesInOldRepositories = new MultiMap<String, String>();
            HashMap<String, Version> actualOldFeatureVersions = new HashMap<String, Version>();
            for (Repository existingRepository : before.values()) {
                for (Feature feature : existingRepository.getFeatures()) {
                    Version linkedList = Utils.getOsgiVersion((String)feature.getVersion());
                    Version lowestUpdateableVersion2 = new Version(linkedList.getMajor(), linkedList.getMinor(), 0);
                    String key2 = String.format("%s|%s", feature.getName(), lowestUpdateableVersion2.toString());
                    featuresInOldRepositories.put(key2, existingRepository.getURI().toString());
                    singleFeaturesInOldRepositories.put(feature.getName(), existingRepository.getURI().toString());
                    actualOldFeatureVersions.put(key2, linkedList);
                }
            }
            addedRepositoryNames = new HashSet<String>(after.keySet());
            addedRepositoryNames.removeAll(before.keySet());
            HashMap<String, String> featuresInNewRepositories = new HashMap<String, String>();
            MultiMap<String, String> singleFeaturesInNewRepositories = new MultiMap<String, String>();
            HashMap<String, String> actualNewFeatureVersions = new HashMap<String, String>();
            MultiMap<String, String> singleActualNewFeatureVersions = new MultiMap<String, String>();
            HashSet<String> oldRepositoryNames = new HashSet<String>();
            for (String string : addedRepositoryNames) {
                Repository added = after.get(string);
                for (Feature feature : added.getFeatures()) {
                    v = Utils.getOsgiVersion((String)feature.getVersion());
                    lowestUpdateableVersion = new Version(v.getMajor(), v.getMinor(), 0);
                    key = String.format("%s|%s", feature.getName(), lowestUpdateableVersion.toString());
                    featuresInNewRepositories.put(key, string);
                    singleFeaturesInNewRepositories.put(feature.getName(), string);
                    actualNewFeatureVersions.put(key, v.toString());
                    singleActualNewFeatureVersions.put(feature.getName(), v.toString());
                    String oldRepositoryWithUpdateableFeature = (String)featuresInOldRepositories.get(key);
                    if (oldRepositoryWithUpdateableFeature == null && singleFeaturesInOldRepositories.get(feature.getName()) != null && singleFeaturesInOldRepositories.get(feature.getName()).size() == 1) {
                        oldRepositoryWithUpdateableFeature = (String)singleFeaturesInOldRepositories.get(feature.getName()).get(0);
                    }
                    if (oldRepositoryWithUpdateableFeature == null) continue;
                    oldRepositoryNames.add(oldRepositoryWithUpdateableFeature);
                }
            }
            for (String string : oldRepositoryNames) {
                Repository repository = (Repository)before.get(string);
                for (Feature feature : repository.getFeatures()) {
                    if (!this.featuresService.isInstalled(feature)) continue;
                    v = Utils.getOsgiVersion((String)feature.getVersion());
                    lowestUpdateableVersion = new Version(v.getMajor(), v.getMinor(), 0);
                    key = String.format("%s|%s", feature.getName(), lowestUpdateableVersion.toString());
                    String newRepositoryName = (String)featuresInNewRepositories.get(key);
                    String newVersion = (String)actualNewFeatureVersions.get(key);
                    if (newRepositoryName == null && singleFeaturesInOldRepositories.get(feature.getName()) != null && singleFeaturesInOldRepositories.get(feature.getName()).size() == 1 && singleFeaturesInNewRepositories.get(feature.getName()) != null && singleFeaturesInNewRepositories.get(feature.getName()).size() == 1) {
                        newRepositoryName = (String)singleFeaturesInNewRepositories.get(feature.getName()).get(0);
                    }
                    if (newVersion == null && singleActualNewFeatureVersions.get(feature.getName()) != null && singleActualNewFeatureVersions.get(feature.getName()).size() == 1) {
                        newVersion = (String)singleActualNewFeatureVersions.get(feature.getName()).get(0);
                    }
                    FeatureUpdate featureUpdate = null;
                    featureUpdate = newVersion != null && newRepositoryName != null ? new FeatureUpdate(feature.getName(), after.get(string).getURI().toString(), feature.getVersion(), after.get(newRepositoryName).getURI().toString(), newVersion) : new FeatureUpdate(feature.getName(), after.get(string).getURI().toString(), feature.getVersion(), null, null);
                    updatesInThisPatch.add(featureUpdate);
                    FeatureUpdate oldUpdate = updatesForFeatureKeys.get(key);
                    if (oldUpdate != null) {
                        Version upv = null;
                        Version newV = null;
                        if (oldUpdate.getNewVersion() != null) {
                            upv = VersionTable.getVersion(oldUpdate.getNewVersion());
                        }
                        if (newVersion != null) {
                            newV = VersionTable.getVersion(newVersion);
                        }
                        if (upv == null && newV == null || upv != null && (newV == null || upv.compareTo(newV) >= 0)) continue;
                        updatesForFeatureKeys.put(key, featureUpdate);
                        continue;
                    }
                    updatesForFeatureKeys.put(key, featureUpdate);
                }
            }
            HashSet unchangedRepositoryNames = new HashSet(before.keySet());
            unchangedRepositoryNames.removeAll(oldRepositoryNames);
            for (String unchangedRepositoryName : unchangedRepositoryNames) {
                Repository repository = (Repository)before.get(unchangedRepositoryName);
                boolean hasInstalledFeatures = false;
                for (Feature feature : repository.getFeatures()) {
                    if (!this.featuresService.isInstalled(feature)) continue;
                    FeatureUpdate featureUpdate = new FeatureUpdate(feature.getName(), after.get(unchangedRepositoryName).getURI().toString(), feature.getVersion(), null, null);
                    hasInstalledFeatures = true;
                    updatesInThisPatch.add(featureUpdate);
                    updatesForFeatureKeys.put(String.format("%s|%s", feature.getName(), feature.getVersion()), featureUpdate);
                }
                if (hasInstalledFeatures) continue;
                FeatureUpdate featureUpdate = new FeatureUpdate(null, after.get(unchangedRepositoryName).getURI().toString(), null, null, null);
                updatesInThisPatch.add(featureUpdate);
                updatesForFeatureKeys.put(String.format("REPOSITORY_TO_ADD:%s", after.get(unchangedRepositoryName).getURI().toString()), featureUpdate);
            }
            LinkedList<FeatureUpdate> linkedList = updatesInThisPatch;
            return linkedList;
        }
        catch (Exception e) {
            throw new PatchException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (after != null) {
                for (String string : addedRepositoryNames) {
                    if (after.get(string) == null) continue;
                    this.featuresService.removeRepository(after.get(string).getURI(), false);
                }
            }
        }
    }

    private void installMigratorBundle(Patch patch) throws IOException {
        Artifact artifact;
        if (patch.getPatchData().getMigratorBundle() != null && (artifact = Utils.mvnurlToArtifact((String)patch.getPatchData().getMigratorBundle(), (boolean)true)) != null) {
            File src = new File(this.repository, artifact.getPath());
            File target = new File(Utils.getDeployDir((File)this.karafHome), artifact.getArtifactId() + ".jar");
            FileUtils.copyFile(src, target);
        }
    }

    private HashMap<String, Repository> getAvailableFeatureRepositories() {
        HashMap<String, Repository> before = new HashMap<String, Repository>();
        if (this.featuresService != null) {
            for (Repository repository : this.featuresService.listRepositories()) {
                before.put(repository.getURI().toString(), repository);
            }
        }
        return before;
    }

    public void rollback(final Patch patch, boolean simulate, boolean force) throws PatchException {
        Version v;
        PatchResult result;
        PatchResult patchResult = result = !this.patchManagement.isStandaloneChild() ? patch.getResult() : (PatchResult)patch.getResult().getChildPatches().get(System.getProperty("karaf.name"));
        if (result == null) {
            throw new PatchException("Patch " + patch.getPatchData().getId() + " is not installed");
        }
        if (patch.getPatchData().isRollupPatch()) {
            Presentation.displayFeatureUpdates(result.getFeatureUpdates(), false);
            Presentation.displayBundleUpdates(result.getBundleUpdates(), false);
            try {
                if (!simulate) {
                    this.backupService.backupDataFiles(result, Pending.ROLLUP_ROLLBACK);
                    for (Bundle b : this.bundleContext.getBundles()) {
                        if (b.getSymbolicName() == null || !Utils.stripSymbolicName((String)b.getSymbolicName()).equals("org.apache.felix.fileinstall")) continue;
                        b.stop(1);
                        break;
                    }
                    this.patchManagement.rollback(patch.getPatchData());
                    result.setPending(Pending.ROLLUP_ROLLBACK);
                    if (this.patchManagement.isStandaloneChild()) {
                        result.getParent().store();
                    } else {
                        result.store();
                    }
                    if (this.isJvmRestartNeeded(result)) {
                        boolean handlesFullRestart = Boolean.getBoolean("karaf.restart.jvm.supported");
                        if (handlesFullRestart) {
                            System.out.println("Rollup patch " + patch.getPatchData().getId() + " rolled back. Restarting Karaf..");
                            System.setProperty("karaf.restart.jvm", "true");
                        } else {
                            System.out.println("Rollup patch " + patch.getPatchData().getId() + " rolled back. Shutting down Karaf, please restart...");
                        }
                    } else {
                        System.setProperty("karaf.restart", "true");
                    }
                    File karafData = new File(this.bundleContext.getProperty("karaf.data"));
                    File cleanCache = new File(karafData, "clean_cache");
                    cleanCache.createNewFile();
                    this.bundleContext.getBundle(0L).stop();
                    return;
                }
                System.out.println("Simulation only - no files and runtime data will be modified.");
                return;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                System.err.flush();
                throw new PatchException(e.getMessage(), (Throwable)e);
            }
        }
        Bundle[] allBundles = this.bundleContext.getBundles();
        ArrayList<BundleUpdate> badUpdates = new ArrayList<BundleUpdate>();
        for (BundleUpdate update : result.getBundleUpdates()) {
            boolean found = false;
            v = Version.parseVersion(update.getNewVersion() == null ? update.getPreviousVersion() : update.getNewVersion());
            for (Bundle bundle : allBundles) {
                if (bundle.getSymbolicName() == null || update.getSymbolicName() == null || !Utils.stripSymbolicName((String)bundle.getSymbolicName()).equals(Utils.stripSymbolicName((String)update.getSymbolicName())) || !bundle.getVersion().equals(v)) continue;
                found = true;
                break;
            }
            if (found) continue;
            badUpdates.add(update);
        }
        if (!badUpdates.isEmpty() && !force) {
            StringBuilder sb = new StringBuilder();
            sb.append("Unable to rollback patch ").append(patch.getPatchData().getId()).append(" because of the following missing bundles:\n");
            for (BundleUpdate up : badUpdates) {
                String version = up.getNewVersion() == null ? up.getPreviousVersion() : up.getNewVersion();
                sb.append(" - ").append(up.getSymbolicName()).append("/").append(version).append("\n");
            }
            throw new PatchException(sb.toString());
        }
        if (!simulate) {
            final HashMap<Bundle, String> toUpdate = new HashMap<Bundle, String>();
            for (BundleUpdate update : result.getBundleUpdates()) {
                v = Version.parseVersion(update.getNewVersion() == null ? update.getPreviousVersion() : update.getNewVersion());
                for (Bundle bundle : allBundles) {
                    if (bundle.getSymbolicName() == null || update.getSymbolicName() == null || !Utils.stripSymbolicName((String)bundle.getSymbolicName()).equals(Utils.stripSymbolicName((String)update.getSymbolicName())) || !bundle.getVersion().equals(v)) continue;
                    toUpdate.put(bundle, update.getPreviousLocation());
                }
            }
            final boolean isStandaloneChild = this.patchManagement.isStandaloneChild();
            this.patchManagement.rollback(patch.getPatchData());
            Executors.newSingleThreadExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ServiceImpl.this.applyChanges(toUpdate);
                    }
                    catch (Exception e) {
                        throw new PatchException("Unable to rollback patch " + patch.getPatchData().getId() + ": " + e.getMessage(), (Throwable)e);
                    }
                    patch.setResult(null);
                    File file = new File(ServiceImpl.this.patchDir, result.getPatchData().getId() + ".patch.result");
                    if (isStandaloneChild) {
                        file = new File(ServiceImpl.this.patchDir, result.getPatchData().getId() + "." + System.getProperty("karaf.name") + ".patch.result");
                    }
                    file.delete();
                }
            });
        }
    }

    private VersionRange getUpdateableRange(Patch patch, String url, Version newVersion) {
        VersionRange range = null;
        if (patch.getPatchData().getVersionRange(url) == null) {
            Version lower = new Version(newVersion.getMajor(), newVersion.getMinor(), 0);
            if (newVersion.compareTo(lower) > 0) {
                range = new VersionRange(false, lower, newVersion, true);
            }
        } else {
            range = new VersionRange(patch.getPatchData().getVersionRange(url));
        }
        return range;
    }

    private File getPatchStorage(Patch patch) {
        return new File(this.patchDir, patch.getPatchData().getId());
    }

    private void applyChanges(Map<Bundle, String> toUpdate) throws BundleException, IOException {
        ArrayList<Bundle> toStop = new ArrayList<Bundle>();
        HashMap<Bundle, String> lessToUpdate = new HashMap<Bundle, String>();
        for (Bundle b : toUpdate.keySet()) {
            if (b.getState() == 1) continue;
            toStop.add(b);
            lessToUpdate.put(b, toUpdate.get(b));
        }
        while (!toStop.isEmpty()) {
            List<Bundle> bs = this.getBundlesToDestroy(toStop);
            for (Bundle bundle : bs) {
                String hostHeader = (String)bundle.getHeaders().get("Fragment-Host");
                if (!(hostHeader != null || bundle.getState() != 32 && bundle.getState() != 8 || "org.ops4j.pax.url.mvn".equals(bundle.getSymbolicName()))) {
                    bundle.stop();
                }
                toStop.remove(bundle);
            }
        }
        try {
            this.getClass().getClassLoader().loadClass(Parser.class.getName());
            this.getClass().getClassLoader().loadClass(Clause.class.getName());
            this.getClass().getClassLoader().loadClass(Attribute.class.getName());
            this.getClass().getClassLoader().loadClass(Directive.class.getName());
            this.getClass().getClassLoader().loadClass(RefreshListener.class.getName());
        }
        catch (Exception bs) {
            // empty catch block
        }
        HashSet<Bundle> toRefresh = new HashSet<Bundle>();
        HashSet<Bundle> toStart = new HashSet<Bundle>();
        for (Map.Entry e : lessToUpdate.entrySet()) {
            Bundle bundle = (Bundle)e.getKey();
            if ("org.ops4j.pax.url.mvn".equals(bundle.getSymbolicName())) continue;
            System.out.println("updating: " + bundle.getSymbolicName());
            try {
                BundleUtils.update(bundle, new URL((String)e.getValue()));
            }
            catch (BundleException ex) {
                System.err.println("Failed to update: " + bundle.getSymbolicName() + ", due to: " + e);
            }
            toStart.add(bundle);
            toRefresh.add(bundle);
        }
        this.findBundlesWithOptionalPackagesToRefresh(toRefresh);
        this.findBundlesWithFragmentsToRefresh(toRefresh);
        if (!toRefresh.isEmpty()) {
            CountDownLatch l = new CountDownLatch(1);
            RefreshListener listener = new RefreshListener(l);
            FrameworkWiring wiring = (FrameworkWiring)this.bundleContext.getBundle(0L).adapt(FrameworkWiring.class);
            wiring.refreshBundles(toRefresh, new FrameworkListener[]{listener});
            try {
                l.await();
            }
            catch (InterruptedException e) {
                throw new PatchException("Bundle refresh interrupted", (Throwable)e);
            }
        }
        for (Bundle bundle : toStart) {
            String hostHeader = (String)bundle.getHeaders().get("Fragment-Host");
            if (hostHeader != null) continue;
            try {
                bundle.start();
            }
            catch (BundleException e) {
                System.err.println("Failed to start: " + bundle.getSymbolicName() + ", due to: " + (Object)((Object)e));
            }
        }
    }

    private List<Bundle> getBundlesToDestroy(List<Bundle> bundles) {
        ArrayList<Bundle> bundlesToDestroy = new ArrayList<Bundle>();
        for (Bundle bundle : bundles) {
            ServiceReference[] references = bundle.getRegisteredServices();
            int usage = 0;
            if (references != null) {
                for (ServiceReference reference : references) {
                    usage += ServiceImpl.getServiceUsage(reference, bundles);
                }
            }
            if (usage != 0) continue;
            bundlesToDestroy.add(bundle);
        }
        if (!bundlesToDestroy.isEmpty()) {
            Collections.sort(bundlesToDestroy, new Comparator<Bundle>(){

                @Override
                public int compare(Bundle b1, Bundle b2) {
                    return (int)(b2.getLastModified() - b1.getLastModified());
                }
            });
        } else {
            ServiceReference ref = null;
            for (Bundle bundle : bundles) {
                ServiceReference[] references;
                for (ServiceReference reference : references = bundle.getRegisteredServices()) {
                    if (ServiceImpl.getServiceUsage(reference, bundles) == 0 || ref != null && reference.compareTo((Object)ref) >= 0) continue;
                    ref = reference;
                }
            }
            if (ref != null) {
                bundlesToDestroy.add(ref.getBundle());
            }
        }
        return bundlesToDestroy;
    }

    private static int getServiceUsage(ServiceReference ref, List<Bundle> bundles) {
        Bundle[] usingBundles = ref.getUsingBundles();
        int nb = 0;
        if (usingBundles != null) {
            for (Bundle bundle : usingBundles) {
                if (!bundles.contains(bundle)) continue;
                ++nb;
            }
        }
        return nb;
    }

    protected void findBundlesWithFragmentsToRefresh(Set<Bundle> toRefresh) {
        for (Bundle b : toRefresh) {
            Clause[] clauses;
            String hostHeader;
            if (b.getState() == 1 || (hostHeader = (String)b.getHeaders().get("Fragment-Host")) == null || (clauses = Parser.parseHeader(hostHeader)) == null || clauses.length <= 0) continue;
            Clause path = clauses[0];
            for (Bundle hostBundle : this.bundleContext.getBundles()) {
                if (!hostBundle.getSymbolicName().equals(path.getName())) continue;
                String ver = path.getAttribute("bundle-version");
                if (ver != null) {
                    VersionRange v = VersionRange.parseVersionRange(ver);
                    if (!v.contains(hostBundle.getVersion())) continue;
                    toRefresh.add(hostBundle);
                    continue;
                }
                toRefresh.add(hostBundle);
            }
        }
    }

    protected void findBundlesWithOptionalPackagesToRefresh(Set<Bundle> toRefresh) {
        List importsList;
        HashSet<Bundle> bundles = new HashSet<Bundle>(Arrays.asList(this.bundleContext.getBundles()));
        bundles.removeAll(toRefresh);
        if (bundles.isEmpty()) {
            return;
        }
        HashMap<Bundle, List> imports = new HashMap<Bundle, List>();
        Iterator it = bundles.iterator();
        while (it.hasNext()) {
            Bundle b = (Bundle)it.next();
            String importsStr = (String)b.getHeaders().get("Import-Package");
            importsList = this.getOptionalImports(importsStr);
            if (importsList.isEmpty()) {
                it.remove();
                continue;
            }
            imports.put(b, importsList);
        }
        if (bundles.isEmpty()) {
            return;
        }
        ArrayList<Clause> exports = new ArrayList<Clause>();
        for (Bundle b : toRefresh) {
            String exportsStr;
            if (b.getState() == 1 || (exportsStr = (String)b.getHeaders().get("Export-Package")) == null) continue;
            Clause[] exportsList = Parser.parseHeader(exportsStr);
            exports.addAll(Arrays.asList(exportsList));
        }
        Iterator it2 = bundles.iterator();
        while (it2.hasNext()) {
            Bundle b;
            b = (Bundle)it2.next();
            importsList = (List)imports.get(b);
            Iterator itpi = importsList.iterator();
            while (itpi.hasNext()) {
                Clause pi = (Clause)itpi.next();
                boolean matching = false;
                for (Clause pe : exports) {
                    Version exported;
                    if (!pi.getName().equals(pe.getName())) continue;
                    String evStr = pe.getAttribute("version");
                    String ivStr = pi.getAttribute("version");
                    VersionRange imported = ivStr != null ? VersionRange.parseVersionRange(ivStr) : VersionRange.ANY_VERSION;
                    if (!imported.contains(exported = evStr != null ? Version.parseVersion(evStr) : Version.emptyVersion)) continue;
                    matching = true;
                    break;
                }
                if (matching) continue;
                itpi.remove();
            }
            if (!importsList.isEmpty()) continue;
            it2.remove();
        }
        toRefresh.addAll(bundles);
    }

    protected List<Clause> getOptionalImports(String importsStr) {
        Clause[] imports = Parser.parseHeader(importsStr);
        LinkedList<Clause> result = new LinkedList<Clause>();
        for (Clause anImport : imports) {
            String resolution = anImport.getDirective("resolution");
            if (!"optional".equals(resolution)) continue;
            result.add(anImport);
        }
        return result;
    }

    protected BundleVersionHistory createBundleVersionHistory() {
        return new BundleVersionHistory(this.load(true));
    }

    private PatchKind checkConsistency(Collection<Patch> patches) throws PatchException {
        boolean hasP = false;
        boolean hasR = false;
        for (Patch patch : patches) {
            if (patch.getPatchData().isRollupPatch()) {
                if (hasR) {
                    throw new PatchException("Can't install more than one rollup patch at once");
                }
                hasR = true;
                continue;
            }
            hasP = true;
        }
        if (hasR && hasP) {
            throw new PatchException("Can't install both rollup and non-rollup patches in single run");
        }
        return hasR ? PatchKind.ROLLUP : PatchKind.NON_ROLLUP;
    }

    protected void checkPrerequisites(Collection<Patch> patches) throws PatchException {
        for (Patch patch : patches) {
            this.checkPrerequisites(patch);
        }
    }

    protected void checkPrerequisites(Patch patch) throws PatchException {
        for (String requirement : patch.getPatchData().getRequirements()) {
            Patch required = this.getPatch(requirement);
            if (required == null) {
                throw new PatchException(String.format("Required patch '%s' is missing", requirement));
            }
            if (required.isInstalled()) continue;
            throw new PatchException(String.format("Required patch '%s' is not installed", requirement));
        }
    }

    private void checkStandaloneChild(Collection<Patch> patches) {
        if (this.patchManagement.isStandaloneChild()) {
            for (Patch patch : patches) {
                if (patch.getResult() == null) {
                    throw new PatchException(String.format("Patch '%s' should be installed in parent container first", patch.getPatchData().getId()));
                }
                List bases = patch.getResult().getKarafBases();
                boolean isInstalledInRoot = false;
                for (String base : bases) {
                    String[] coords = base.split("\\s*\\|\\s*");
                    if (coords.length != 2 || !coords[1].trim().equals(System.getProperty("karaf.home"))) continue;
                    isInstalledInRoot = true;
                }
                if (isInstalledInRoot) continue;
                throw new PatchException(String.format("Patch '%s' should be installed in parent container first", patch.getPatchData().getId()));
            }
        }
    }

    protected void bindPatchManagement(PatchManagement patchManagement) {
        this.patchManagement = patchManagement;
    }

    protected void unbindPatchManagement(PatchManagement patchManagement) {
        if (this.patchManagement == patchManagement) {
            this.patchManagement = null;
        }
    }

    protected void bindFeaturesService(FeaturesService featuresService) {
        this.featuresService = featuresService;
    }

    protected void unbindFeaturesService(FeaturesService featuresService) {
        if (this.featuresService == featuresService) {
            this.featuresService = null;
        }
    }

    protected void bindBackupService(BackupService backupService) {
        this.backupService = backupService;
    }

    protected void unbindBackupService(BackupService backupService) {
        if (this.backupService == backupService) {
            this.backupService = null;
        }
    }

    private static class RefreshListener
    implements FrameworkListener {
        private final CountDownLatch l;

        public RefreshListener(CountDownLatch l) {
            this.l = l;
        }

        public void frameworkEvent(FrameworkEvent event) {
            this.l.countDown();
        }
    }

    protected static final class BundleVersionHistory {
        private Map<String, Map<String, String>> bundleVersions = new HashMap<String, Map<String, String>>();

        public BundleVersionHistory(Map<String, Patch> patches) {
            for (Map.Entry<String, Patch> patch : patches.entrySet()) {
                PatchResult result = patch.getValue().getResult();
                if (result == null) continue;
                for (BundleUpdate update : result.getBundleUpdates()) {
                    if (update.getNewVersion() == null || update.getSymbolicName() == null) continue;
                    String symbolicName = Utils.stripSymbolicName((String)update.getSymbolicName());
                    Map<String, String> versions = this.bundleVersions.get(symbolicName);
                    if (versions == null) {
                        versions = new HashMap<String, String>();
                        this.bundleVersions.put(symbolicName, versions);
                    }
                    versions.put(update.getNewVersion(), update.getNewLocation());
                }
            }
        }

        protected String getLocation(Bundle bundle) {
            String symbolicName = bundle.getSymbolicName() == null ? null : Utils.stripSymbolicName((String)bundle.getSymbolicName());
            Map<String, String> versions = this.bundleVersions.get(symbolicName);
            String location = null;
            if (versions != null) {
                location = versions.get(bundle.getVersion().toString());
            }
            if (location == null) {
                location = bundle.getLocation();
            }
            return location;
        }
    }

    static class MultiMap<K, V> {
        HashMap<K, ArrayList<V>> delegate = new HashMap();

        MultiMap() {
        }

        public List<V> get(Object key) {
            return this.delegate.get(key);
        }

        public void put(K key, V value) {
            ArrayList<Object> list = this.delegate.get(key);
            if (list == null) {
                list = new ArrayList();
                this.delegate.put(key, list);
            }
            list.add(value);
        }
    }
}

