/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.util.bundles;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class BundleUtils {
    public static void update(Bundle bundle) throws IOException, BundleException {
        BundleUtils.update(bundle, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(Bundle bundle, URL location) throws IOException, BundleException {
        if (location == null) {
            String loc = (String)bundle.getHeaders().get("Bundle-UpdateLocation");
            if (loc == null || loc.equals(bundle.getLocation())) {
                bundle.update();
                return;
            }
            location = new URL(loc);
        }
        try (InputStream is = location.openStream();){
            File file = BundleUtils.fixBundleWithUpdateLocation(is, location.toString());
            try (FileInputStream fis = new FileInputStream(file);){
                bundle.update((InputStream)fis);
            }
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File fixBundleWithUpdateLocation(InputStream is, String uri) throws IOException {
        File file = File.createTempFile("update-", ".jar");
        try (ZipInputStream zis = new ZipInputStream(is);){
            zos.setMethod(0);
            try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(file));){
                ZipEntry entry;
                byte[] buf = new byte[8192];
                zos.setLevel(0);
                while ((entry = zis.getNextEntry()) != null) {
                    int n;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    while (-1 != (n = zis.read(buf))) {
                        baos.write(buf, 0, n);
                    }
                    if (entry.getName().equals("META-INF/MANIFEST.MF")) {
                        Manifest man = new Manifest(new ByteArrayInputStream(baos.toByteArray()));
                        if (man.getMainAttributes().getValue("Bundle-UpdateLocation") == null) {
                            man.getMainAttributes().putValue("Bundle-UpdateLocation", uri);
                        }
                        baos.reset();
                        man.write(baos);
                    }
                    byte[] data = baos.toByteArray();
                    CRC32 crc = new CRC32();
                    crc.update(data);
                    entry = new ZipEntry(entry.getName());
                    entry.setSize(data.length);
                    entry.setCrc(crc.getValue());
                    zos.putNextEntry(entry);
                    zos.write(data);
                    zis.closeEntry();
                    zos.closeEntry();
                }
            }
        }
        return file;
    }
}

