/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.management.conflicts;

import io.fabric8.patch.management.conflicts.Resolver;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public class SetEnvResolver
implements Resolver {
    private static final Pattern MEMORY_SETTINGS = Pattern.compile("^\\s*([A-Z_]+\\s*=\\s*[0-9]+[kKmMgG]).*$");

    @Override
    public String resolve(File patchChange, File base, File userChange) {
        HashMap<String, NumLitValue> patchSettings = new HashMap<String, NumLitValue>();
        HashMap<String, NumLitValue> userSettings = new HashMap<String, NumLitValue>();
        try {
            List<String> patchLines = FileUtils.readLines(patchChange);
            List<String> userLines = FileUtils.readLines(userChange);
            this.collectSettings(patchSettings, patchLines);
            this.collectSettings(userSettings, userLines);
            StringBuffer sb = new StringBuffer();
            for (String pl : patchLines) {
                Matcher matcher = this.getMemorySettingsPattern().matcher(pl);
                if (matcher.matches()) {
                    String[] kv = matcher.group(1).split("\\s*=\\s*");
                    String key = kv[0].trim();
                    long pv = this.toBytes(kv[1].toUpperCase().trim());
                    NumLitValue uv = (NumLitValue)userSettings.get(key);
                    if (uv.value > pv) {
                        sb.append(pl.substring(0, matcher.start(1)));
                        sb.append(key).append("=").append(uv.literal);
                        sb.append(pl.substring(matcher.end(1)));
                        sb.append(this.getEOL());
                        continue;
                    }
                    sb.append(pl).append(this.getEOL());
                    continue;
                }
                sb.append(pl).append(this.getEOL());
            }
            return sb.toString();
        }
        catch (IOException e) {
            System.out.printf("Problem resolving conflict: %s%n", e.getMessage());
            return null;
        }
    }

    public String toString() {
        return "bin/setenv resolver";
    }

    protected Pattern getMemorySettingsPattern() {
        return MEMORY_SETTINGS;
    }

    protected String getEOL() {
        return "\n";
    }

    private void collectSettings(Map<String, NumLitValue> patchSettings, List<String> patchLines) {
        for (String pl : patchLines) {
            Matcher matcher = this.getMemorySettingsPattern().matcher(pl);
            if (!matcher.matches()) continue;
            String[] kv = matcher.group(1).split("\\s*=\\s*");
            Long v = this.toBytes(kv[1].toUpperCase().trim());
            patchSettings.put(kv[0].trim(), new NumLitValue(v, kv[1].toUpperCase().trim()));
        }
    }

    protected Long toBytes(String value) {
        long multiplier = 1L;
        char c = value.charAt(value.length() - 1);
        switch (c) {
            case 'K': {
                multiplier = 1024L;
                break;
            }
            case 'M': {
                multiplier = 0x100000L;
                break;
            }
            case 'G': {
                multiplier = 0x40000000L;
            }
        }
        return Long.parseLong(value.substring(0, value.length() - 1)) * multiplier;
    }

    private static class NumLitValue {
        public long value;
        public String literal;

        public NumLitValue(long value, String literal) {
            this.value = value;
            this.literal = literal;
        }
    }
}

