/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.management;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public class PatchData {
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String ROLLUP = "rollup";
    private static final String BUNDLES = "bundle";
    private static final String REQUIREMENTS = "requirement";
    private static final String FILES = "file";
    private static final String SOURCE = "source";
    private static final String TARGET = "target";
    private static final String COUNT = "count";
    private static final String RANGE = "range";
    private static final String MIGRATOR_BUNDLE = "migrator-bundle";
    private static final String FEATURE_DESCRIPTOR = "featureDescriptor";
    private boolean generated;
    private boolean rollupPatch = false;
    private final String id;
    private String description;
    private String migratorBundle;
    private File patchDirectory;
    private File patchLocation;
    private List<String> bundles = new LinkedList<String>();
    private List<String> featureFiles = new LinkedList<String>();
    private List<String> otherArtifacts = new LinkedList<String>();
    private List<String> files = new LinkedList<String>();
    private Map<String, String> versionRanges;
    private List<String> requirements;
    private Map<String, Long> fileSizes = new HashMap<String, Long>();
    private Map<String, Long> artifactSizes = new HashMap<String, Long>();

    public PatchData(String id) {
        this.id = id;
        this.description = id;
    }

    public PatchData(String id, String description, List<String> bundles, List<String> featureFiles, Map<String, String> versionRanges, List<String> requirements, String migratorBundle) {
        this.id = id;
        this.description = description;
        this.bundles = bundles;
        this.featureFiles = featureFiles;
        this.versionRanges = versionRanges;
        this.requirements = requirements;
        this.migratorBundle = migratorBundle;
    }

    public static PatchData load(InputStream inputStream) throws IOException {
        Properties props = new Properties();
        props.load(inputStream);
        IOUtils.closeQuietly(inputStream);
        return PatchData.load(props);
    }

    public static PatchData load(Properties props) throws IOException {
        String key;
        int i;
        String id = props.getProperty(ID);
        String desc = props.getProperty(DESCRIPTION);
        String installerBundle = props.getProperty(MIGRATOR_BUNDLE);
        boolean rollupPatch = "true".equals(props.getProperty(ROLLUP));
        ArrayList<String> bundles = new ArrayList<String>();
        ArrayList<String> featureDescriptors = new ArrayList<String>();
        HashMap<String, String> ranges = new HashMap<String, String>();
        int count = Integer.parseInt(props.getProperty("bundle.count", "0"));
        for (i = 0; i < count; ++i) {
            key = "bundle." + Integer.toString(i);
            String bundle = props.getProperty(key);
            bundles.add(bundle);
            if (!props.containsKey(key + "." + RANGE)) continue;
            ranges.put(bundle, props.getProperty(key + "." + RANGE));
        }
        count = Integer.parseInt(props.getProperty("featureDescriptor.count", "0"));
        for (i = 0; i < count; ++i) {
            key = "featureDescriptor." + Integer.toString(i);
            featureDescriptors.add(props.getProperty(key));
        }
        ArrayList<String> requirements = new ArrayList<String>();
        int requirementCount = Integer.parseInt(props.getProperty("requirement.count", "0"));
        for (int i2 = 0; i2 < requirementCount; ++i2) {
            String key2 = "requirement." + Integer.toString(i2);
            String requirement = props.getProperty(key2);
            requirements.add(requirement);
        }
        PatchData result = new PatchData(id, desc, bundles, featureDescriptors, ranges, requirements, installerBundle);
        result.setRollupPatch(rollupPatch);
        count = Integer.parseInt(props.getProperty("file.count", "0"));
        for (int i3 = 0; i3 < count; ++i3) {
            result.files.add(props.getProperty("file." + Integer.toString(i3)));
        }
        return result;
    }

    public void storeTo(OutputStream out) {
        PrintWriter pw = new PrintWriter(out);
        pw.write("# generated file, do not modify\n");
        pw.write("id = " + this.getId() + "\n");
        pw.write("rollup = " + Boolean.toString(this.rollupPatch) + "\n");
        int n = 0;
        if (this.bundles.size() > 0) {
            for (String bundle : this.bundles) {
                pw.write(String.format("bundle.%d = %s\n", n++, bundle));
            }
            pw.write(String.format("bundle.count = %d\n", n));
        }
        n = 0;
        if (this.featureFiles.size() > 0) {
            for (String ff : this.featureFiles) {
                pw.write(String.format("%s.%d = %s\n", FEATURE_DESCRIPTOR, n++, ff));
            }
            pw.write(String.format("%s.%s = %d\n", FEATURE_DESCRIPTOR, COUNT, n));
        }
        n = 0;
        if (this.otherArtifacts.size() > 0) {
            for (String artifact : this.otherArtifacts) {
                pw.write(String.format("artifact.%d = %s\n", n++, artifact));
            }
            pw.write(String.format("artifact.count = %d\n", n));
        }
        n = 0;
        if (this.files.size() > 0) {
            for (String file : this.files) {
                pw.write(String.format("file.%d = %s\n", n++, file));
            }
            pw.write(String.format("file.count = %d\n", n));
        }
        if (this.migratorBundle != null) {
            pw.write(String.format("%s = %s\n", MIGRATOR_BUNDLE, this.migratorBundle));
        }
        pw.close();
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersionRange(String bundle) {
        return this.versionRanges.get(bundle);
    }

    public List<String> getBundles() {
        return this.bundles;
    }

    public List<String> getFeatureFiles() {
        return this.featureFiles;
    }

    public List<String> getOtherArtifacts() {
        return this.otherArtifacts;
    }

    public List<String> getRequirements() {
        return this.requirements;
    }

    public List<String> getFiles() {
        return this.files;
    }

    public String getMigratorBundle() {
        return this.migratorBundle;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public void setGenerated(boolean generated) {
        this.generated = generated;
    }

    public boolean isRollupPatch() {
        return this.rollupPatch;
    }

    public void setRollupPatch(boolean rollupPatch) {
        this.rollupPatch = rollupPatch;
    }

    public File getPatchDirectory() {
        return this.patchDirectory;
    }

    public void setPatchDirectory(File patchDirectory) {
        this.patchDirectory = patchDirectory;
    }

    public File getPatchLocation() {
        return this.patchLocation;
    }

    public void setPatchLocation(File patchLocation) {
        this.patchLocation = patchLocation;
    }
}

