/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.management;

public class Artifact {
    private String groupId;
    private String artifactId;
    private String version;
    private String type;
    private String classifier;

    public Artifact(String groupId, String artifactId, String version, String type, String classifier) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.type = type;
        this.classifier = classifier;
    }

    public static boolean isSameButVersion(Artifact a1, Artifact a2) {
        return a1.getGroupId().equals(a2.getGroupId()) && a1.getArtifactId().equals(a2.getArtifactId()) && a1.hasClassifier() == a2.hasClassifier() && (!a1.hasClassifier() || a1.getClassifier().equals(a2.getClassifier())) && a1.getType().equals(a2.getType());
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getType() {
        return this.type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public boolean hasClassifier() {
        return this.classifier != null;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getPath() {
        return this.groupId.replace('.', '/') + '/' + this.artifactId + '/' + this.version + '/' + this.artifactId + (this.classifier != null ? "-" + this.classifier : "") + '-' + this.version + '.' + this.type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.groupId).append(":").append(this.artifactId).append(":").append(this.version);
        if (!"jar".equals(this.type) || this.classifier != null) {
            sb.append(":").append(this.type);
            if (this.classifier != null) {
                sb.append(":").append(this.classifier);
            }
        }
        return sb.toString();
    }

    public String toURI() {
        StringBuilder sb = new StringBuilder();
        sb.append("mvn:").append(this.groupId).append("/").append(this.artifactId).append("/").append(this.version);
        if (!"jar".equals(this.type) || this.classifier != null) {
            sb.append("/").append(this.type);
            if (this.classifier != null) {
                sb.append("/").append(this.classifier);
            }
        }
        return sb.toString();
    }

    public Artifact copy() {
        return new Artifact(this.groupId, this.artifactId, this.version, this.type, this.classifier);
    }
}

