/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.management.io;

import io.fabric8.patch.management.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class EOLFixingFileOutputStream
extends FileOutputStream {
    private boolean needsChecking = false;
    private boolean probablyNeedsFixing = false;
    private String EOL = "\n";
    private int EOLLength = 1;
    private long additionalBytes = 0L;
    private boolean fixCRLF;
    private boolean lineConversionMode = false;
    private ByteArrayOutputStream conversionBuffer = null;
    private volatile boolean closed = false;
    private static final Set<String> IMPORTANT_DIRECTORIES = new HashSet<String>(Arrays.asList("bin", "etc", "fabric", "licenses", "metatype"));
    private static final Set<String> IMPORTANT_EXTENSIONS = new HashSet<String>(Arrays.asList("md", "properties", "xml", "json", "txt", "cfg", "config"));

    public EOLFixingFileOutputStream(File targetDirectory, File file) throws IOException {
        super(file);
        String path = Utils.relative(targetDirectory, file);
        String[] tab = path.split(Pattern.quote(File.separator));
        if (tab.length >= 2) {
            String firstDirectory = tab[0];
            String ext = FilenameUtils.getExtension(file.getName());
            if ("etc".equals(firstDirectory) && "cfg".equals(ext)) {
                this.lineConversionMode = true;
                this.conversionBuffer = new ByteArrayOutputStream();
            } else {
                if (IMPORTANT_DIRECTORIES.contains(firstDirectory.toLowerCase())) {
                    if (ext.indexOf(35) > 0) {
                        ext = ext.substring(ext.indexOf(35));
                    }
                    if (!"fabric".equals(firstDirectory.toLowerCase()) || IMPORTANT_EXTENSIONS.contains(ext)) {
                        this.needsChecking = true;
                    }
                }
                if (path.endsWith(".bat")) {
                    this.EOL = "\r\n";
                    this.EOLLength = 2;
                }
            }
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.lineConversionMode) {
            this.conversionBuffer.write(b, off, len);
        } else {
            super.write(b, off, len);
            if (!this.needsChecking) {
                return;
            }
            this.probablyNeedsFixing = this.EOLLength == 2 && len >= 2 && b[off + len - 2] != 13 && b[off + len - 1] != 10 ? true : this.EOLLength == 1 && len >= 1 && b[off + len - 1] != 10;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.lineConversionMode) {
            byte[] bytes = this.conversionBuffer.toByteArray();
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] != 13) {
                    buffer.write(bytes[i]);
                    continue;
                }
                --this.additionalBytes;
            }
            if (bytes.length > 0 && bytes[bytes.length - 1] != 10) {
                ++this.additionalBytes;
                buffer.write(10);
            }
            super.write(buffer.toByteArray());
        } else if (this.needsChecking && this.probablyNeedsFixing) {
            if (this.EOL.length() == 2) {
                super.write(new byte[]{13, 10}, 0, 2);
                this.additionalBytes = 2L;
            } else {
                super.write(new byte[]{10}, 0, 1);
                this.additionalBytes = 1L;
            }
        }
        this.closed = true;
        super.close();
    }

    public long additionalBytesWritten() {
        return this.additionalBytes;
    }

    public void setFixCRLF(boolean fixCRLF) {
        this.fixCRLF = fixCRLF;
    }
}

