/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import org.apache.camel.util.ObjectHelper;

public final class StringHelper {
    private StringHelper() {
    }

    public static String sanitize(String s) {
        return s.replace(':', '-').replace('_', '-').replace('.', '-').replace('/', '-').replace('\\', '-');
    }

    public static int countChar(String s, char ch) {
        if (ObjectHelper.isEmpty(s)) {
            return 0;
        }
        int matches = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (ch != c) continue;
            ++matches;
        }
        return matches;
    }

    public static String removeQuotes(String s) {
        if (ObjectHelper.isEmpty(s)) {
            return s;
        }
        s = s.replaceAll("'", "");
        s = s.replaceAll("\"", "");
        return s;
    }

    public static String removeLeadingAndEndingQuotes(String s) {
        if (ObjectHelper.isEmpty(s)) {
            return s;
        }
        String copy = s.trim();
        if (copy.startsWith("'") && copy.endsWith("'")) {
            return copy.substring(1, copy.length() - 1);
        }
        if (copy.startsWith("\"") && copy.endsWith("\"")) {
            return copy.substring(1, copy.length() - 1);
        }
        return s;
    }

    public static boolean isQuoted(String s) {
        if (ObjectHelper.isEmpty(s)) {
            return false;
        }
        if (s.startsWith("'") && s.endsWith("'")) {
            return true;
        }
        return s.startsWith("\"") && s.endsWith("\"");
    }

    public static String xmlEncode(String text) {
        if (text == null) {
            return "";
        }
        return text.replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static boolean hasUpperCase(String text) {
        if (text == null) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (!Character.isUpperCase(ch)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasStartToken(String expression, String language) {
        if (expression == null) {
            return false;
        }
        if (expression.indexOf("${") >= 0) {
            return true;
        }
        return language != null && expression.indexOf("$" + language + "{") >= 0;
    }

    public static String replaceAll(String input, String from, String to) {
        if (ObjectHelper.isEmpty(input)) {
            return input;
        }
        if (from == null) {
            throw new IllegalArgumentException("from cannot be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("to cannot be null");
        }
        if (!input.contains(from)) {
            return input;
        }
        int len = from.length();
        int max = input.length();
        StringBuilder sb = new StringBuilder(max);
        int i = 0;
        while (i < max) {
            String token;
            if (i + len <= max && from.equals(token = input.substring(i, i + len))) {
                sb.append(to);
                i += len;
                continue;
            }
            sb.append(input.charAt(i));
            ++i;
        }
        return sb.toString();
    }
}

