/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.watcher.file;

import io.fabric8.watcher.Processor;
import io.fabric8.watcher.matchers.Matchers;
import io.fabric8.watcher.support.WatcherSupport;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWatcher
extends WatcherSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileWatcher.class);
    private Path root;
    private boolean watch = true;
    private WatchService watcher;
    private PathMatcher dirMatcher;
    private PathMatcher fileMatcher;
    private ExecutorService executor;
    private final AtomicInteger processing = new AtomicInteger();
    private final Object keysMonitor = new Object();
    private final Map<WatchKey, Path> keys = new ConcurrentHashMap<WatchKey, Path>();
    private volatile long lastModified;
    private final Map<Path, Boolean> processedMap = new ConcurrentHashMap<Path, Boolean>();

    public void init() throws IOException {
        if (this.root == null) {
            Iterable<Path> rootDirectories = this.getFileSystem().getRootDirectories();
            for (Path rootDirectory : rootDirectories) {
                if (rootDirectory == null) continue;
                this.root = rootDirectory;
                break;
            }
        }
        if (!Files.exists(this.root, new LinkOption[0])) {
            FileWatcher.fail(LOGGER, "Root path does not exist: " + this.root);
        } else if (!Files.isDirectory(this.root, new LinkOption[0])) {
            FileWatcher.fail(LOGGER, "Root path is not a directory: " + this.root);
        }
        if (this.executor == null) {
            this.executor = Executors.newFixedThreadPool(4);
        }
        if (this.watcher == null) {
            this.watcher = this.watch ? this.getFileSystem().newWatchService() : null;
        }
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    FileWatcher.this.rescan();
                }
                catch (IOException e) {
                    LOGGER.warn("Caught: " + e, (Throwable)e);
                }
                LOGGER.debug("Completed rescan file watcher");
            }
        });
        if (this.watch) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        FileWatcher.this.processEvents();
                    }
                    catch (Throwable e) {
                        LOGGER.warn("Caught: " + e, e);
                    }
                    LOGGER.debug("Completed processing file watcher events");
                }
            });
        }
    }

    public void destroy() {
        this.executor.shutdownNow();
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setRootPath(String rootPath) {
        Path path = new File(rootPath).getAbsoluteFile().toPath();
        this.setRoot(path);
    }

    public void setRootDirectory(File directory) {
        this.setRoot(directory.toPath());
    }

    public void setDirMatchPattern(String pattern) {
        this.setDirMatcher(Matchers.parse(pattern, this.getFileSystem()));
    }

    public void setFileMatchPattern(String pattern) {
        this.setFileMatcher(Matchers.parse(pattern, this.getFileSystem()));
    }

    public Path getRoot() {
        return this.root;
    }

    public void setRoot(Path root) {
        this.root = root;
    }

    public boolean isWatch() {
        return this.watch;
    }

    public void setWatch(boolean watch) {
        this.watch = watch;
    }

    public WatchService getWatcher() {
        return this.watcher;
    }

    public void setWatcher(WatchService watcher) {
        this.watcher = watcher;
    }

    public PathMatcher getDirMatcher() {
        return this.dirMatcher;
    }

    public void setDirMatcher(PathMatcher dirMatcher) {
        this.dirMatcher = dirMatcher;
    }

    public PathMatcher getFileMatcher() {
        return this.fileMatcher;
    }

    public void setFileMatcher(PathMatcher fileMatcher) {
        this.fileMatcher = fileMatcher;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescan() throws IOException {
        try {
            AtomicInteger atomicInteger = this.processing;
            synchronized (atomicInteger) {
                while (this.processing.get() > 0) {
                    this.processing.wait();
                }
            }
            for (WatchKey key : this.keys.keySet()) {
                key.cancel();
            }
            this.keys.clear();
            Files.walkFileTree(this.root, new FilteringFileVisitor());
            AtomicInteger i$ = this.processing;
            synchronized (i$) {
                while (this.processing.get() > 0) {
                    this.processing.wait();
                }
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvents() {
        while (true) {
            Path dir;
            WatchKey key;
            try {
                key = this.watcher.take();
            }
            catch (InterruptedException e) {
                return;
            }
            Object object = this.keysMonitor;
            synchronized (object) {
                dir = this.keys.get(key);
            }
            if (dir == null) {
                LOGGER.warn("Could not find key for " + key);
                continue;
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                WatchEvent<?> ev = event;
                Path name = (Path)ev.context();
                Path child = dir.resolve(name);
                LOGGER.debug("Processing event {} on path {}", kind, (Object)child);
                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                try {
                    if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                        if (Files.isDirectory(child, LinkOption.NOFOLLOW_LINKS)) {
                            Files.walkFileTree(child, new FilteringFileVisitor());
                            continue;
                        }
                        if (!Files.isRegularFile(child, LinkOption.NOFOLLOW_LINKS)) continue;
                        this.scan(child);
                        continue;
                    }
                    if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                        if (!Files.isRegularFile(child, LinkOption.NOFOLLOW_LINKS)) continue;
                        this.scan(child);
                        continue;
                    }
                    if (kind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                    this.unscan(child);
                }
                catch (IOException x) {
                    x.printStackTrace();
                }
            }
            boolean valid = key.reset();
            if (valid) continue;
            LOGGER.debug("Removing key " + key + " and dir " + dir + " from keys");
            this.keys.remove(key);
            if (this.keys.isEmpty()) break;
        }
    }

    private void scan(Path file) throws IOException {
        if (this.isMatchesFile(file)) {
            this.fireListeners(file, StandardWatchEventKinds.ENTRY_MODIFY);
            this.process(file);
            this.processedMap.put(file, Boolean.TRUE);
        }
    }

    protected boolean isMatchesFile(Path file) {
        boolean matches = true;
        if (this.fileMatcher != null) {
            Path rel = this.root.relativize(file);
            matches = this.fileMatcher.matches(rel);
        }
        return matches;
    }

    private void unscan(Path file) throws IOException {
        if (this.isMatchesFile(file)) {
            Processor processor = this.getProcessor();
            if (processor != null) {
                processor.onRemove(file);
            }
            this.lastModified = System.currentTimeMillis();
        } else {
            ArrayList<Path> files = new ArrayList<Path>(this.processedMap.keySet());
            for (Path path : files) {
                if (Files.exists(path, new LinkOption[0])) continue;
                LOGGER.debug("File has been deleted: " + path);
                this.processedMap.remove(path);
                if (!this.isMatchesFile(path)) continue;
                Processor processor = this.getProcessor();
                if (processor != null) {
                    processor.onRemove(path);
                }
                this.fireListeners(path, StandardWatchEventKinds.ENTRY_DELETE);
                this.lastModified = System.currentTimeMillis();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(final Path path) throws IOException {
        final Processor processor = this.getProcessor();
        if (processor != null) {
            this.processing.incrementAndGet();
            try {
                this.executor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            processor.process(path);
                            FileWatcher.this.lastModified = System.currentTimeMillis();
                        }
                        finally {
                            FileWatcher.this.processing.decrementAndGet();
                            AtomicInteger atomicInteger = FileWatcher.this.processing;
                            synchronized (atomicInteger) {
                                FileWatcher.this.processing.notifyAll();
                            }
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                this.processing.decrementAndGet();
                AtomicInteger atomicInteger = this.processing;
                synchronized (atomicInteger) {
                    this.processing.notifyAll();
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void watch(Path path) throws IOException {
        if (this.watcher != null) {
            Object object = this.keysMonitor;
            synchronized (object) {
                WatchKey key = path.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
                this.keys.put(key, path);
            }
        } else {
            LOGGER.warn("No watcher yet for path " + path);
        }
    }

    protected FileSystem getFileSystem() {
        return FileSystems.getDefault();
    }

    public static void fail(Logger logger, String message) {
        logger.warn(message);
        throw new IllegalArgumentException(message);
    }

    public class FilteringFileVisitor
    implements FileVisitor<Path> {
        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path rel;
            if (Thread.interrupted()) {
                throw new InterruptedIOException();
            }
            if (FileWatcher.this.dirMatcher != null && !"".equals((rel = FileWatcher.this.root.relativize(dir)).toString()) && !FileWatcher.this.dirMatcher.matches(rel)) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            FileWatcher.this.watch(dir);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (Thread.interrupted()) {
                throw new InterruptedIOException();
            }
            FileWatcher.this.scan(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }
    }
}

