/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.aether;

import io.hawt.util.Strings;
import java.io.File;
import java.util.List;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyNode;

public class AetherResult {
    private final DependencyNode rootNode;
    private final List<File> files;
    private final String classPath;

    public AetherResult(DependencyNode rootNode, List<File> files, String classPath) {
        this.rootNode = rootNode;
        this.files = files;
        this.classPath = classPath;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public List<File> getFiles() {
        return this.files;
    }

    public DependencyNode getRootNode() {
        return this.rootNode;
    }

    public String treeString() {
        StringBuilder builder = new StringBuilder();
        this.displayTree(this.rootNode, "", builder);
        return builder.toString();
    }

    protected void displayTree(DependencyNode node, String indent, StringBuilder sb) {
        sb.append(indent + node.getDependency()).append("\n");
        String childIndent = indent + "  ";
        List children = node.getChildren();
        for (DependencyNode child : children) {
            this.displayTree(child, childIndent, sb);
        }
    }

    public String jsonString() {
        StringBuilder builder = new StringBuilder();
        this.toJson(this.rootNode, "", builder, true);
        return builder.toString();
    }

    protected void toJson(DependencyNode node, String indent, StringBuilder sb, boolean last) {
        List children;
        String scope;
        String extension;
        sb.append(indent + "{\n");
        String childIndent = indent + "  ";
        Dependency dependency = node.getDependency();
        Artifact artifact = dependency.getArtifact();
        this.appendJsonProperty(sb, childIndent, "groupId", artifact.getGroupId(), false);
        this.appendJsonProperty(sb, childIndent, "artifactId", artifact.getArtifactId(), false);
        String classifier = artifact.getClassifier();
        if (Strings.isNotBlank((String)classifier)) {
            this.appendJsonProperty(sb, childIndent, "classifier", classifier, false);
        }
        if (Strings.isNotBlank((String)(extension = artifact.getExtension())) && !extension.equals("jar")) {
            this.appendJsonProperty(sb, childIndent, "extension", extension, false);
        }
        if (Strings.isNotBlank((String)(scope = dependency.getScope()))) {
            this.appendJsonProperty(sb, childIndent, "scope", scope, false);
        }
        if (!(children = node.getChildren()).isEmpty()) {
            sb.append(childIndent);
            sb.append("\"children\": [\n");
            String grandChildIndent = childIndent + "  ";
            int idx = 0;
            int lastIdx = children.size();
            for (DependencyNode child : children) {
                this.toJson(child, grandChildIndent, sb, ++idx >= lastIdx);
            }
            sb.append(childIndent);
            sb.append("],\n");
        }
        this.appendJsonProperty(sb, childIndent, "version", artifact.getVersion(), true);
        sb.append(indent);
        sb.append("}");
        if (!last) {
            sb.append(",");
        }
        sb.append("\n");
    }

    protected void appendJsonProperty(StringBuilder sb, String childIndent, String name, String value, boolean last) {
        sb.append(childIndent);
        sb.append("\"");
        sb.append(name);
        sb.append("\": \"");
        sb.append(value);
        sb.append("\"");
        if (!last) {
            sb.append(",");
        }
        sb.append("\n");
    }
}

