/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.aether;

import io.hawt.aether.AetherFacade;
import io.hawt.aether.AetherFacadeMXBean;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenMavenURL {
    private static final transient Logger LOG = LoggerFactory.getLogger(OpenMavenURL.class);
    private static AetherFacade hack;
    private final String mavenCoords;

    public OpenMavenURL(String mavenCoords) {
        this.mavenCoords = mavenCoords;
    }

    public String toString() {
        return "mvn:" + this.mavenCoords;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenMavenURL that = (OpenMavenURL)o;
        return this.mavenCoords.equals(that.mavenCoords);
    }

    public int hashCode() {
        return this.mavenCoords.hashCode();
    }

    public String getMavenCoords() {
        return this.mavenCoords;
    }

    public InputStream getInputStream() throws IOException {
        File file;
        AetherFacadeMXBean mbean = this.findAetherMBean();
        String fileName = null;
        try {
            fileName = mbean.resolveUrlToFileName(this.mavenCoords);
        }
        catch (Exception e) {
            throw new IOException("Failed to resolve mvn:" + this.mavenCoords + ". " + e, e);
        }
        if (fileName != null && (file = new File(fileName)).isFile() && file.exists()) {
            return new FileInputStream(file);
        }
        return null;
    }

    protected AetherFacadeMXBean findAetherMBean() {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        if (mBeanServer != null) {
            String mbeanName = "hawtio:type=AetherFacade";
            try {
                AetherFacadeMXBean aether;
                ObjectName objectName = new ObjectName(mbeanName);
                ObjectInstance objectInstance = mBeanServer.getObjectInstance(objectName);
                if (objectInstance != null && (aether = JMX.newMBeanProxy(mBeanServer, objectName, AetherFacadeMXBean.class)) != null) {
                    return aether;
                }
            }
            catch (Exception e) {
                LOG.warn("Could not find MBean " + mbeanName + " so using a default implementation of AetherFacadeMXBean");
            }
        } else {
            LOG.warn("No MBeanServer so using a default implementation of AetherFacadeMXBean");
        }
        if (hack == null) {
            hack = new AetherFacade();
        }
        return hack;
    }
}

