/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.app;

import io.hawt.embedded.Main;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

public class App {
    private static final String WAR_FILENAME = "hawtio.war";
    private static final int KB = 1024;

    public static void main(String[] args) {
        Main main = new Main();
        try {
            block11: {
                String virtualMachineClass = "com.sun.tools.attach.VirtualMachine";
                try {
                    Class<?> aClass = App.loadClass(virtualMachineClass, App.class.getClassLoader(), Thread.currentThread().getContextClassLoader());
                }
                catch (Exception e) {
                    HashSet<String> paths = new HashSet<String>();
                    String javaHome = System.getProperty("java.home", ".");
                    App.addPath(paths, javaHome);
                    javaHome = System.getenv("JAVA_HOME");
                    if (javaHome != null && javaHome.length() > 0) {
                        App.addPath(paths, javaHome);
                    }
                    boolean found = false;
                    for (String path : paths) {
                        File file = new File(path, "lib/tools.jar");
                        if (!file.exists()) continue;
                        found = true;
                        String url = file.toURI().toURL().toString();
                        main.setExtraClassPath(url);
                        break;
                    }
                    if (found) break block11;
                    System.out.println("Failed to load class " + virtualMachineClass + " and find tools.jar in directories " + paths + ". " + e);
                }
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL resource = classLoader.getResource(WAR_FILENAME);
            if (resource == null) {
                System.err.println("Could not find the hawtio.war on classpath!");
                System.exit(1);
            }
            File warFile = File.createTempFile("hawtio-", ".war");
            App.writeStreamTo(resource.openStream(), new FileOutputStream(warFile), 65536);
            String warPath = warFile.getCanonicalPath();
            main.setWar(warPath);
        }
        catch (Exception e) {
            System.out.println("Failed to create hawtio: " + e.getMessage());
            e.printStackTrace();
            return;
        }
        if (!main.parseArguments(args) || main.isHelp()) {
            main.showOptions();
        } else {
            try {
                main.run();
            }
            catch (Exception e) {
                System.out.println("Failed running hawtio: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    protected static void addPath(Set<String> paths, String path) {
        paths.add(path);
        String jreSuffix = File.separator + "jre";
        if (path.endsWith(jreSuffix)) {
            path = path.substring(0, path.length() - jreSuffix.length());
            paths.add(path);
        }
    }

    private static Class<?> loadClass(String name, ClassLoader ... classLoaders) throws ClassNotFoundException {
        for (ClassLoader classLoader : classLoaders) {
            try {
                return classLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
            }
        }
        return Class.forName(name);
    }

    public static int writeStreamTo(InputStream input, OutputStream output, int bufferSize) throws IOException {
        int available = Math.min(input.available(), 262144);
        byte[] buffer = new byte[Math.max(bufferSize, available)];
        int answer = 0;
        int count = input.read(buffer);
        while (count >= 0) {
            output.write(buffer, 0, count);
            answer += count;
            count = input.read(buffer);
        }
        return answer;
    }
}

