/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.embedded;

import io.hawt.embedded.Options;
import java.io.File;
import java.io.FilenameFilter;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Slf4jLog;
import org.eclipse.jetty.webapp.WebAppContext;

public class Main {
    private Options options = new Options();
    private boolean welcome = true;

    public Main() {
        this.options.init();
    }

    public static void main(String[] args) {
        Main main = new Main();
        if (!main.parseArguments(args) || main.isHelp()) {
            main.showOptions();
            return;
        }
        Main.doRun(main);
    }

    public boolean parseArguments(String[] args) {
        return this.options.parseArguments(args);
    }

    public void showOptions() {
        this.options.showOptions();
    }

    public static void doRun(Main main) {
        try {
            main.run();
        }
        catch (Exception e) {
            System.out.println("Error: " + e);
            e.printStackTrace();
        }
    }

    public void run() throws Exception {
        this.run(this.options.isJointServerThread());
    }

    public void run(boolean join) throws Exception {
        System.setProperty("org.eclipse.jetty.util.log.class", Slf4jLog.class.getName());
        Slf4jLog log = new Slf4jLog("jetty");
        Log.setLog(log);
        WebAppContext webapp = new WebAppContext();
        webapp.setContextPath(this.options.getContextPath());
        String war = this.findWar(this.options.getWarLocation());
        if (war == null) {
            war = this.options.getWar();
        }
        if (war == null) {
            throw new IllegalArgumentException("No war or warLocation options set!");
        }
        webapp.setWar(war);
        webapp.setParentLoaderPriority(true);
        webapp.setLogUrlOnStart(true);
        webapp.setExtraClasspath(this.options.getExtraClassPath());
        Server server = new Server(this.options.getPort());
        server.setHandler(webapp);
        if (this.welcome) {
            System.out.println("Embedded hawtio: You can use --help to show usage");
            System.out.println(this.options.usedOptionsSummary());
        }
        System.out.println("About to start war " + war);
        server.start();
        if (this.welcome) {
            System.out.println();
            System.out.println("hawtio: Don't cha wish your console was hawt like me!");
            System.out.println("=====================================================");
            System.out.println();
            System.out.println("http://localhost:" + this.options.getPort() + this.options.getContextPath());
            System.out.println();
        }
        if (join) {
            if (this.welcome) {
                System.out.println("Joining the Jetty server thread");
            }
            server.join();
        }
    }

    protected String findWar(String ... paths) {
        if (paths != null) {
            for (String path : paths) {
                File[] wars;
                String name;
                File file;
                if (path == null || !(file = new File(path)).exists()) continue;
                if (file.isFile() && this.isWarFileName(name = file.getName())) {
                    return file.getPath();
                }
                if (!file.isDirectory() || (wars = file.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return Main.this.isWarFileName(name);
                    }
                })) == null || wars.length <= 0) continue;
                return wars[0].getPath();
            }
        }
        return null;
    }

    protected boolean isWarFileName(String name) {
        return name.toLowerCase().endsWith(".war");
    }

    public String getWarLocation() {
        return this.options.getWarLocation();
    }

    public void setWarLocation(String warLocation) {
        this.options.setWarLocation(warLocation);
    }

    public String getWar() {
        return this.options.getWar();
    }

    public void setWar(String war) {
        this.options.setWar(war);
    }

    public String getContextPath() {
        return this.options.getContextPath();
    }

    public void setContextPath(String contextPath) {
        this.options.setContextPath(contextPath);
    }

    public Integer getPort() {
        return this.options.getPort();
    }

    public void setPort(Integer port) {
        this.options.setPort(port);
    }

    public String getExtraClassPath() {
        return this.options.getExtraClassPath();
    }

    public void setExtraClassPath(String extraClassPath) {
        this.options.setExtraClassPath(extraClassPath);
    }

    public boolean isJoinServerThread() {
        return this.options.isJointServerThread();
    }

    public void setJoinServerThread(boolean joinServerThread) {
        this.options.setJointServerThread(joinServerThread);
    }

    public boolean isHelp() {
        return this.options.isHelp();
    }

    public void showWelcome(boolean welcome) {
        this.welcome = welcome;
    }
}

