/// <reference path="../../../../../hawtio-web/src/main/d.ts/jquery-datatable.d.ts" />
/// <reference path="../../../../../hawtio-web/src/main/d.ts/jquery-datatable-extra.d.ts" />
/// <reference path="../../../../../hawtio-web/src/main/d.ts/jquery.d.ts" />
/// <reference path="../../../../../hawtio-web/src/main/d.ts/jquery.dynatree-1.2.d.ts" />
/// <reference path="../../../../../hawtio-web/src/main/d.ts/jquery.gridster.d.ts" />
/// <reference path="../../../../../hawtio-web/src/main/d.ts/jquery.jsPlumb.d.ts" />
/// <reference path="../../../../../hawtio-web/src/main/d.ts/logger.d.ts" />
/// <reference path="../../../../../hawtio-web/src/main/d.ts/sugar-1.3.d.ts" />
/// <reference path="../../../../../hawtio-web/src/main/d.ts/hawtio-plugin-loader.d.ts" />
/// <reference path="../../../../../hawtio-web/src/main/d.ts/chrome.d.ts" />
/// <reference path="../../../../../hawtio-web/src/main/d.ts/toastr.d.ts" />
/// <reference path="../../../../../hawtio-web/src/main/d.ts/angular.d.ts" />
/// <reference path="../../../../../hawtio-web/src/main/d.ts/angular-resource.d.ts" />
/// <reference path="../../../../../hawtio-web/src/main/d.ts/angular-route.d.ts" />
/// <reference path="../../../../../hawtio-web/src/main/d.ts/bootstrap-2.1.d.ts" />
/// <reference path="../../../../../hawtio-web/src/main/d.ts/camel.d.ts" />
/// <reference path="../../../../../hawtio-web/src/main/d.ts/codemirror-additional.d.ts" />
/// <reference path="../../../../../hawtio-web/src/main/d.ts/codemirror.d.ts" />
/// <reference path="../../../../../hawtio-web/src/main/d.ts/dagre.d.ts" />
/// <reference path="../../../../../hawtio-web/src/main/d.ts/dmr.d.ts" />
/// <reference path="../../../../../hawtio-web/src/main/d.ts/google.d.ts" />
/// <reference path="../../../../../hawtio-web/src/main/d.ts/jolokia-1.0.d.ts" />
/// <reference path="../../../../../hawtio-web/src/main/d.ts/marked.d.ts" />
/// <reference path="../../../../../hawtio-web/src/main/d.ts/schemas.d.ts" />
/// <reference path="../../../../../hawtio-web/src/main/d.ts/zeroclipboard.d.ts" />
/// <reference path="../../../../../hawtio-web/src/main/d.ts/metricsWatcher.d.ts" />
/// <reference path="../../../../../hawtio-web/src/main/d.ts/URI.d.ts" />
/// <reference path="../../../../../hawtio-web/src/main/d.ts/underscore.d.ts" />
declare module StringHelpers {
    function isDate(str: any): boolean;
    function obfusicate(str: String): String;
    function toString(obj: any): string;
}
declare module Core {
    interface UserCredentials {
        username: String;
        password: String;
    }
    interface UserDetails extends UserCredentials {
        loginDetails?: Object;
        remoteJolokiaUserDetails?: UserCredentials;
    }
    interface ConnectToServerOptions {
        scheme: String;
        host?: String;
        port?: Number;
        path?: String;
        useProxy: boolean;
        jolokiaUrl?: String;
        userName: String;
        password: String;
        view: String;
        name: String;
    }
    interface ConnectOptions extends ConnectToServerOptions {
    }
    interface ConnectionMap {
        [name: string]: ConnectOptions;
    }
    function createConnectToServerOptions(options?: any): ConnectToServerOptions;
    function createConnectOptions(options?: any): ConnectOptions;
}
declare module UrlHelpers {
    function noHash(url: string): string;
    function extractPath(url: string): string;
    function contextActive(url: string, thingICareAbout: string): boolean;
    function join(...paths: string[]): string;
    var parseQueryString: {
        (): any;
        (text: string): any;
    };
    function maybeProxy(jolokiaUrl: string, url: string): string;
    function escapeColons(url: string): string;
}
declare module Core {
    var injector: ng.auto.IInjectorService;
    var connectionSettingsKey: string;
    function _resetUrlPrefix(): void;
    function url(path: string): string;
    function windowLocation(): Location;
    function _resetJolokiaUrls(): String[];
    function trimLeading(text: string, prefix: string): string;
    function trimTrailing(text: string, postfix: string): string;
    function loadConnectionMap(): ConnectionMap;
    function saveConnectionMap(map: ConnectionMap): void;
    function getConnectOptions(name: string, localStorage?: WindowLocalStorage): ConnectOptions;
    var ConnectionName: string;
    function getConnectionNameParameter(search: any): string;
    function createServerConnectionUrl(options: ConnectOptions): String;
    function getJolokiaUrl(): String;
    function adjustHeight(): void;
    function isChromeApp(): boolean;
    function addCSS(path: any): void;
    function getLocalStorage(): WindowLocalStorage;
    function asArray(value: any): any[];
    function parseBooleanValue(value: any, defaultValue?: boolean): boolean;
    function toString(value: any): string;
    function booleanToString(value: boolean): string;
    function parseIntValue(value: any, description?: string): any;
    function numberToString(value: number): string;
    function parseFloatValue(value: any, description?: string): any;
    function pathGet(object: any, paths: any): any;
    function pathSet(object: any, paths: any, newValue: any): any;
    function $applyNowOrLater($scope: ng.IScope): void;
    function $applyLater($scope: any, timeout?: number): void;
    function $apply($scope: ng.IScope): void;
    function $digest($scope: ng.IScope): void;
    function getOrCreateElements(domElement: any, arrayOfElementNames: string[]): any;
    function unescapeHtml(str: any): any;
    function escapeHtml(str: any): any;
    function isBlank(str: string): boolean;
    function notification(type: string, message: string, options?: any): void;
    function clearNotifications(): void;
    function trimQuotes(text: string): string;
    function humanizeValue(value: any): string;
}
declare module ControllerHelpers {
    function createClassSelector(config: any): (selection: any, model: any) => string;
    function createValueClassSelector(config: any): (model: any) => string;
    function bindModelToSearchParam($scope: any, $location: any, modelName: string, paramName: string, initialValue?: any, to?: (value: any) => any, from?: (value: any) => any): void;
    function reloadWhenParametersChange($route: any, $scope: any, $location: any, parameters?: string[]): void;
}
declare module Core {
    interface Tasks {
        addTask: (name: string, task: () => void) => void;
        execute: () => void;
        reset: () => void;
        onComplete: (cb: () => void) => void;
    }
    interface ParameterizedTasks extends Tasks {
        addTask: (name: string, task: (...params: any[]) => void) => void;
        execute: (...params: any[]) => void;
    }
    interface TaskMap {
        [name: string]: () => void;
    }
    interface ParameterizedTaskMap {
        [name: string]: (...params: any[]) => void;
    }
    class TasksImpl implements Tasks {
        tasks: TaskMap;
        tasksExecuted: boolean;
        _onComplete: () => void;
        addTask(name: string, task: () => void): void;
        private executeTask(name, task);
        onComplete(cb: () => void): void;
        execute(): void;
        reset(): void;
    }
    class ParameterizedTasksImpl extends TasksImpl implements ParameterizedTasks {
        tasks: ParameterizedTaskMap;
        constructor();
        addTask(name: string, task: (...params: any[]) => void): void;
        execute(...params: any[]): void;
    }
    var postLoginTasks: Tasks;
    var preLogoutTasks: Tasks;
}
declare module Core {
    interface JMXOperationArgument {
        name: string;
        desc: string;
        type: string;
    }
    interface JMXOperation {
        args: JMXOperationArgument[];
        desc: string;
        ret: string;
        canInvoke?: boolean;
    }
    interface JMXOperations {
        [methodName: string]: JMXOperation;
    }
    interface JMXAttribute {
        desc: string;
        rw: boolean;
        type: string;
        canInvoke?: boolean;
    }
    interface JMXAttributes {
        [attributeName: string]: JMXAttribute;
    }
    interface JMXMBean {
        op: JMXOperations;
        attr: JMXAttributes;
        desc: string;
        canInvoke?: boolean;
    }
    interface JMXDomain {
        [mbeanName: string]: JMXMBean;
    }
    interface JMXDomains {
        [domainName: string]: JMXDomain;
    }
    function operationToString(name: string, args: JMXOperationArgument[]): string;
}
declare module Core {
    interface NodeSelection {
        title: string;
        key?: string;
        typeName?: string;
        objectName?: string;
        domain?: string;
        entries?: any;
        folderNames?: string[];
        children?: NodeSelection[];
        parent?: NodeSelection;
        isFolder?: () => boolean;
        version?: string;
        get(key: string): NodeSelection;
        ancestorHasType(typeName: string): boolean;
        ancestorHasEntry(key: string, value: any): boolean;
        findDescendant(filter: any): NodeSelection;
        findAncestor(filter: any): NodeSelection;
    }
    class Folder implements NodeSelection {
        title: string;
        constructor(title: string);
        key: string;
        typeName: string;
        children: NodeSelection[];
        folderNames: string[];
        domain: string;
        objectName: string;
        map: {};
        entries: {};
        addClass: string;
        parent: Folder;
        isLazy: boolean;
        icon: string;
        tooltip: string;
        entity: any;
        version: string;
        mbean: JMXMBean;
        expand: boolean;
        get(key: string): NodeSelection;
        isFolder(): boolean;
        navigate(...paths: string[]): NodeSelection;
        hasEntry(key: string, value: any): boolean;
        parentHasEntry(key: string, value: any): boolean;
        ancestorHasEntry(key: string, value: any): boolean;
        ancestorHasType(typeName: string): boolean;
        getOrElse(key: string, defaultValue?: NodeSelection): Folder;
        sortChildren(recursive: boolean): void;
        moveChild(child: Folder): void;
        insertBefore(child: Folder, referenceFolder: Folder): void;
        insertAfter(child: Folder, referenceFolder: Folder): void;
        detach(): void;
        findDescendant(filter: any): any;
        findAncestor(filter: any): any;
    }
}
interface NodeSelection extends Core.NodeSelection {
}
declare class Folder extends Core.Folder {
}
declare module Jmx {
    var log: Logging.Logger;
    function findLazyLoadingFunction(workspace: any, folder: any): any;
    function registerLazyLoadHandler(domain: string, lazyLoaderFactory: (folder: Core.Folder) => any): void;
    function unregisterLazyLoadHandler(domain: string, lazyLoaderFactory: (folder: Core.Folder) => any): void;
    function addAttributeToolBar(pluginName: string, jmxDomain: string, fn: (NodeSelection: any) => string): void;
    function getAttributeToolBar(node: NodeSelection, defaultValue?: string): any;
    function updateTreeSelectionFromURL($location: any, treeElement: any, activateIfNoneSelected?: boolean): void;
    function updateTreeSelectionFromURLAndAutoSelect($location: any, treeElement: any, autoSelect: any, activateIfNoneSelected?: boolean): void;
    function getUniqueTypeNames(children: any): string[];
    function enableTree($scope: any, $location: ng.ILocationService, workspace: Core.Workspace, treeElement: any, children: any, redraw?: boolean, onActivateFn?: any): void;
}
declare module Core {
    interface NavMenuItem {
        id: string;
        content: string;
        title?: string;
        isValid?: (workspace: Workspace, perspectiveId?: string) => any;
        isActive?: (worksace: Workspace) => boolean;
        href: () => any;
    }
    class Workspace {
        jolokia: any;
        jolokiaStatus: any;
        jmxTreeLazyLoadRegistry: any;
        $location: any;
        $compile: ng.ICompileService;
        $templateCache: ng.ITemplateCacheService;
        localStorage: WindowLocalStorage;
        $rootScope: any;
        userDetails: any;
        operationCounter: number;
        selection: NodeSelection;
        tree: Folder;
        mbeanTypesToDomain: {};
        mbeanServicesToDomain: {};
        attributeColumnDefs: {};
        treePostProcessors: any[];
        topLevelTabs: NavMenuItem[];
        subLevelTabs: any[];
        keyToNodeMap: {};
        pluginRegisterHandle: any;
        pluginUpdateCounter: any;
        treeWatchRegisterHandle: any;
        treeWatcherCounter: any;
        treeElement: any;
        mapData: {};
        constructor(jolokia: any, jolokiaStatus: any, jmxTreeLazyLoadRegistry: any, $location: any, $compile: ng.ICompileService, $templateCache: ng.ITemplateCacheService, localStorage: WindowLocalStorage, $rootScope: any, userDetails: any);
        createChildWorkspace(location: any): Workspace;
        getLocalStorage(key: string): any;
        setLocalStorage(key: string, value: any): void;
        loadTree(): void;
        addTreePostProcessor(processor: (tree: any) => void, priority?: number, name?: string): void;
        removeTreePostProcessors(name: string): void;
        maybeMonitorPlugins(): void;
        maybeUpdatePlugins(response: any): void;
        maybeReloadTree(response: any): void;
        folderGetOrElse(folder: any, value: any): any;
        populateTree(response: any): void;
        private enableLazyLoading(folder);
        hash(): string;
        getActiveTab(): Object;
        private getStrippedPathName();
        linkContains(...words: String[]): boolean;
        isLinkActive(href: string): boolean;
        isLinkPrefixActive(href: string): boolean;
        isTopTabActive(path: string): boolean;
        getSelectedMBeanName(): string;
        validSelection(uri: string): any;
        removeAndSelectParentNode(): void;
        selectParentNode(): void;
        selectionViewConfigKey(): string;
        selectionConfigKey(prefix?: string): string;
        moveIfViewInvalid(): boolean;
        updateSelectionNode(node: any): void;
        redrawTree(): void;
        expandSelection(flag: any): void;
        private matchesProperties(entries, properties);
        hasInvokeRightsForName(objectName: string, ...methods: string[]): any;
        hasInvokeRights(selection: NodeSelection, ...methods: string[]): boolean;
        treeContainsDomainAndProperties(domainName: any, properties?: any): boolean;
        private matches(folder, properties, propertiesCount);
        hasDomainAndProperties(domainName: any, properties?: any, propertiesCount?: any): boolean;
        findMBeanWithProperties(domainName: any, properties?: any, propertiesCount?: any): any;
        findChildMBeanWithProperties(folder: any, properties?: any, propertiesCount?: any): any;
        selectionHasDomainAndLastFolderName(objectName: string, lastName: string): boolean;
        selectionHasDomain(domainName: string): boolean;
        selectionHasDomainAndType(objectName: string, typeName: string): boolean;
        hasMBeans(): boolean;
        hasFabricMBean(): boolean;
        isFabricFolder(): boolean;
        isCamelContext(): boolean;
        isCamelFolder(): boolean;
        isEndpointsFolder(): boolean;
        isEndpoint(): boolean;
        isRoutesFolder(): boolean;
        isRoute(): boolean;
        isOsgiFolder(): boolean;
        isKarafFolder(): boolean;
        isOsgiCompendiumFolder(): boolean;
    }
}
declare class Workspace extends Core.Workspace {
}
declare module UI {
    var colors: string[];
}
declare module Core {
    var log: Logging.Logger;
    var lazyLoaders: {};
}
declare var numberTypeNames: {
    'byte': boolean;
    'short': boolean;
    'int': boolean;
    'long': boolean;
    'float': boolean;
    'double': boolean;
    'java.lang.byte': boolean;
    'java.lang.short': boolean;
    'java.lang.integer': boolean;
    'java.lang.long': boolean;
    'java.lang.float': boolean;
    'java.lang.double': boolean;
};
declare function lineCount(value: any): number;
declare function safeNull(value: any): string;
declare function safeNullAsString(value: any, type: string): string;
declare function toSearchArgumentArray(value: any): string[];
declare function folderMatchesPatterns(node: any, patterns: any): any;
declare function scopeStoreJolokiaHandle($scope: any, jolokia: any, jolokiaHandle: any): void;
declare function closeHandle($scope: any, jolokia: any): void;
declare function onSuccess(fn: any, options?: {}): {};
declare function supportsLocalStorage(): boolean;
declare function isNumberTypeName(typeName: any): boolean;
declare function encodeMBeanPath(mbean: any): any;
declare function escapeMBeanPath(mbean: any): any;
declare function encodeMBean(mbean: any): any;
declare function escapeDots(text: string): string;
declare function escapeTreeCssStyles(text: string): string;
declare function showLogPanel(): void;
declare function logLevelClass(level: string): string;
declare module Core {
    function toPath(hashUrl: string): string;
    function parseMBean(mbean: any): any;
    function executePostLoginTasks(): void;
    function executePreLogoutTasks(onComplete: () => void): void;
    function logout(jolokiaUrl: any, userDetails: any, localStorage: Storage, $scope: any, successCB?: () => void, errorCB?: () => void): void;
    function createHref($location: any, href: any, removeParams?: any): any;
    function hashToString(hash: any): string;
    function stringToHash(hashAsString: string): {};
    function registerForChanges(jolokia: any, $scope: any, arguments: any, callback: (response: any) => void, options?: any): () => void;
    interface IResponseHistory {
        [name: string]: any;
    }
    function getOrInitObjectFromLocalStorage(key: string): any;
    function getResponseHistory(): any;
    var MAX_RESPONSE_CACHE_SIZE: number;
    function register(jolokia: Jolokia.IJolokia, scope: any, arguments: any, callback: any): () => void;
    function unregister(jolokia: Jolokia.IJolokia, scope: any): void;
    function defaultJolokiaErrorHandler(response: any, options?: {}): void;
    function logJolokiaStackTrace(response: any): void;
    function xmlNodeToString(xmlNode: any): any;
    function isTextNode(node: any): boolean;
    function fileExtension(name: string, defaultValue?: string): string;
    function getUUID(): string;
    function parseVersionNumbers(text: string): number[];
    function versionToSortableString(version: string, maxDigitsBetweenDots?: number): string;
    function time(message: string, fn: any): any;
    function compareVersionNumberArrays(v1: number[], v2: number[]): number;
    function valueToHtml(value: any): any;
    function tryParseJson(text: string): any;
    function maybePlural(count: Number, word: string): string;
    function objectNameProperties(objectName: string): {};
    function setPageTitle($document: any, title: PageTitle): void;
    function setPageTitleWithTab($document: any, title: PageTitle, tab: string): void;
    function getMBeanTypeFolder(workspace: Workspace, domain: string, typeName: string): Folder;
    function getMBeanTypeObjectName(workspace: Workspace, domain: string, typeName: string): string;
    function toSafeDomID(text: string): string;
    function forEachLeafFolder(folders: any, fn: any): void;
    function extractHashURL(url: string): string;
    function authHeaderValue(userDetails: UserDetails): string;
    function getBasicAuthHeader(username: string, password: string): string;
    function parseUrl(url: string): any;
    function getDocHeight(): number;
    function useProxyIfExternal(connectUrl: any): any;
    function getRecentConnections(localStorage: any): any;
    function addRecentConnection(localStorage: any, name: any): void;
    function removeRecentConnection(localStorage: any, name: any): void;
    function clearConnections(): void;
    function saveConnection(options: ConnectOptions): void;
    function connectToServer(localStorage: any, options: ConnectToServerOptions): void;
    function extractTargetUrl($location: any, scheme: any, port: any): string;
    function isProxyUrl($location: ng.ILocationService): boolean;
    function doNothing(value: any): any;
    var bindModelToSearchParam: typeof ControllerHelpers.bindModelToSearchParam;
    var reloadWhenParametersChange: typeof ControllerHelpers.reloadWhenParametersChange;
    function createJolokia(url: string, username: string, password: string): Jolokia.IJolokia;
    function throttled(fn: any, millis: number): () => any;
    function parseJsonText(text: string, message?: string): any;
    function humanizeValueHtml(value: any): string;
    function getQueryParameterValue(url: any, parameterName: any): string;
    function createRemoteWorkspace(remoteJolokia: any, $location: any, localStorage: any, $rootScope?: any, $compile?: any, $templateCache?: any, userDetails?: any): Workspace;
    function humanizeMilliseconds(value: number): String;
    function storeConnectionRegex(regexs: any, name: any, json: any): void;
    function getRegexs(): any;
    function removeRegex(name: any): void;
    function writeRegexs(regexs: any): void;
    function maskPassword(value: any): any;
    function matchFilterIgnoreCase(text: any, filter: any): any;
}
declare module IDE {
    function getIdeMBean(workspace: Workspace): string;
    function isOpenInIdeaSupported(workspace: Workspace, localStorage: any): boolean;
    function isOpenInTextMateSupported(workspace: Workspace, localStorage: any): boolean;
    function findClassAbsoluteFileName(mbean: string, jolokia: any, localStorage: any, fileName: any, className: any, onResult: any): any;
    function ideaOpenAndNavigate(mbean: string, jolokia: any, absoluteFileName: any, line: any, column: any, fn?: any): any;
}
declare module IDE {
    class OpenInIdeDirective {
        localStorage: any;
        workspace: any;
        jolokia: any;
        restrict: string;
        replace: boolean;
        transclude: boolean;
        scope: {
            fileName: string;
            className: string;
            line: string;
            column: string;
        };
        link: (scope: any, element: any, attrs: any) => any;
        constructor(localStorage: any, workspace: any, jolokia: any);
        doLink($scope: any, $element: any, $attrs: any): void;
    }
}
declare module IDE {
    var _module: ng.IModule;
}
declare module Core {
    class PageTitle {
        private titleElements;
        addTitleElement(element: () => string): void;
        getTitle(): string;
        getTitleWithSeparator(separator: string): string;
        getTitleExcluding(excludes: string[], separator: string): string;
        getTitleArrayExcluding(excludes: string[]): string[];
    }
}
declare module Core {
    var pluginName: string;
    var templatePath: string;
    var jolokiaUrl: String;
    var _module: ng.IModule;
}
declare module Core {
}
declare module Core {
    function parsePreferencesJson(value: any, key: any): any;
    function configuredPluginsForPerspectiveId(perspectiveId: any, workspace: any, jolokia: any, localStorage: any): any[];
    function safeTabsToPlugins(tabs: any): any[];
    function filterTopLevelTabs(perspective: any, workspace: any, configuredPlugins: any): any[];
    function initPreferenceScope($scope: any, localStorage: any, defaults: any): void;
    function isValidFunction(workspace: any, validFn: any, perspectiveId: any): any;
    function getDefaultPlugin(perspectiveId: any, workspace: any, jolokia: any, localStorage: any): any;
}
declare module Insight {
    var managerMBean: string;
    var allContainers: {
        id: string;
    };
    function hasInsight(workspace: any): any;
    function hasKibana(workspace: any): any;
    function hasEsHead(workspace: any): any;
    function getInsightMetricsCollectorMBean(workspace: any): any;
    function getChildren(node: any, type: any, field: any, hasHost: any): any[];
    function createCharts($scope: any, chartsDef: any, element: any, jolokia: any): void;
}
declare module Fabric {
    interface JolokiaCallbacks {
        success: (response: any) => void;
        error: (response: any) => void;
    }
    interface HostScalingRequirements {
        hostPatterns: String[];
        hostTags: String[];
    }
    interface ChildScalingRequirements {
        rootcontainerPatterns: String[];
    }
    interface SshScalingRequirements extends HostScalingRequirements {
    }
    interface DockerScalingRequirements extends HostScalingRequirements {
    }
    interface OpenShiftScalingRequirements {
    }
    interface ProfileRequirement {
        profile: String;
        minimumInstances: number;
        maximumInstances: number;
        dependentProfiles: string[];
        maximumInstancesPerHost?: number;
        childScalingRequirements?: ChildScalingRequirements;
        sshScalingRequirements?: SshScalingRequirements;
        dockerScalingRequirements?: DockerScalingRequirements;
        openShiftScalingRequirements?: OpenShiftScalingRequirements;
    }
    interface HostConfiguration {
        hostName: String;
        port: Number;
        username: String;
        password: String;
        maximumContainerCount: Number;
        tags: String[];
    }
    interface SshHostConfiguration extends HostConfiguration {
        path: String;
        passPhrase: String;
        privateKeyFile: String;
        preferredAddress: String;
    }
    interface SshConfiguration {
        hosts: SshHostConfiguration[];
        defaultPath: String;
        defaultPort: Number;
        defaultUsername: String;
        defaultPassword: String;
        fallbackRepositories: String[];
        defaultPassPhrase: String;
        defaultPrivateKeyFile: String;
    }
    function createSshHostConfiguration(): SshHostConfiguration;
    function createSshConfiguration(): SshConfiguration;
    interface DockerHostConfiguration extends HostConfiguration {
        path: String;
        passPhrase: String;
        privateKeyFile: String;
        preferredAddress: String;
    }
    function createDockerHostConfiguration(): DockerHostConfiguration;
    interface DockerConfiguration {
        hosts: DockerHostConfiguration[];
    }
    function createDockerConfiguration(): DockerConfiguration;
    interface FabricRequirements {
        profileRequirements?: ProfileRequirement[];
        sshConfiguration?: SshConfiguration;
        dockerConfiguration?: DockerConfiguration;
        version?: string;
    }
    interface Version {
        name?: string;
        id?: string;
        _default?: boolean;
    }
    interface Profile {
        id?: string;
        name?: string;
        tags?: string[];
        versionId?: string;
        summary?: string;
        iconURL?: string;
        abstract?: boolean;
        hidden?: boolean;
        overlay?: boolean;
        containerCount?: number;
        attributes?: any;
        associatedContainers?: any;
        fileConfigurations?: any;
        bundles?: string[];
        configurationFileNames?: string[];
        configurations?: any;
        containerConfiguration?: any;
        endorsedLibraries?: any;
        extensionLibraries?: any;
        fabs?: string[];
        features?: string[];
        libraries?: string[];
        locked?: boolean;
        optionals?: any;
        overrides?: any;
        parents?: string[];
        profileHash?: any;
        repositories?: string[];
        summaryMarkdown?: string;
        version?: any;
        parentIds?: string[];
        childIds?: string[];
        containers?: Container[];
    }
    interface Container {
        alive?: boolean;
        aliveAndOK?: boolean;
        children?: string[];
        debugPort?: number;
        ensembleServer?: boolean;
        geoLocation?: string;
        httpUrl?: string;
        id?: string;
        ip?: string;
        jmxDomains?: string[];
        jmxUrl?: string;
        jolokiaUrl?: string;
        localHostname?: string;
        localIp?: string;
        location?: string;
        managed?: boolean;
        manualIp?: string;
        maximumPort?: number;
        metadata?: any;
        minimumPort?: number;
        overlayProfile?: Profile;
        parent?: string;
        processId?: string;
        profiles?: Profile[];
        provisionChecksums?: string;
        provisionException?: any;
        provisionList?: string[];
        provisionResult?: string;
        provisionStatus?: string;
        provisionStatusMap?: any;
        provisioningComplete?: boolean;
        provisioningPending?: boolean;
        publicHostname?: string;
        publicIp?: string;
        resolver?: string;
        root?: boolean;
        sshUrl?: string;
        type?: string;
        version?: string;
        parentId?: string;
        versionId?: string;
        profileIds?: string[];
        childrenIds?: string[];
    }
}
declare module Fabric {
    var log: Logging.Logger;
    var jmxDomain: string;
    var managerMBean: string;
    var profileManagementMBean: string;
    var clusterManagerMBean: string;
    var clusterBootstrapManagerMBean: string;
    var openShiftFabricMBean: string;
    var mqManagerMBean: string;
    var healthMBean: string;
    var schemaLookupDomain: string;
    var schemaLookupType: string;
    var schemaLookupMBean: string;
    var useDirectoriesInGit: boolean;
    var fabricTopLevel: string;
    var profileSuffix: string;
    var jolokiaWebAppGroupId: string;
    var currentContainerId: string;
    var currentContainer: {};
    var DEFAULT_REST_API: string;
}
declare module Fabric {
    function doAction(action: any, jolokia: any, arguments: any, success: any, error?: typeof Core.defaultJolokiaErrorHandler): void;
    function applyPatches(jolokia: any, files: any, targetVersion: any, newVersionName: any, proxyUser: any, proxyPass: any, success: any, error?: typeof Core.defaultJolokiaErrorHandler): void;
    function setContainerProperty(jolokia: any, containerId: any, property: any, value: any, success: any, error?: typeof Core.defaultJolokiaErrorHandler): void;
    function deleteConfigFile(jolokia: any, version: any, profile: any, file: any, success: any, error?: typeof Core.defaultJolokiaErrorHandler): void;
    function deleteConfigFiles(jolokia: any, version: any, profiles: any, files: any, success: any, error?: typeof Core.defaultJolokiaErrorHandler): void;
    function newConfigFile(jolokia: any, version: any, profile: any, pid: any, success: any, error?: typeof Core.defaultJolokiaErrorHandler): void;
    function saveConfigFile(jolokia: any, version: any, profile: any, pid: any, data: any, success: any, error?: typeof Core.defaultJolokiaErrorHandler): void;
    function addProfilesToContainer(jolokia: any, container: any, profiles: any, success: any, error?: typeof Core.defaultJolokiaErrorHandler): void;
    function removeProfilesFromContainer(jolokia: any, container: any, profiles: any, success: any, error?: typeof Core.defaultJolokiaErrorHandler): void;
    function applyProfiles(jolokia: any, version: any, profiles: any, containers: any, success: any, error?: typeof Core.defaultJolokiaErrorHandler): void;
    function migrateContainers(jolokia: any, version: any, containers: any, success: any, error?: typeof Core.defaultJolokiaErrorHandler): void;
    function changeProfileParents(jolokia: any, version: any, id: any, parents: any, success: any, error?: typeof Core.defaultJolokiaErrorHandler): void;
    function createProfile(jolokia: any, version: any, id: any, parents: any, success: any, error?: typeof Core.defaultJolokiaErrorHandler): void;
    function copyProfile(jolokia: any, version: any, sourceName: any, targetName: any, force: any, success: any, error?: typeof Core.defaultJolokiaErrorHandler): void;
    function createVersionWithParentAndId(jolokia: any, base: any, id: any, success: any, error?: typeof Core.defaultJolokiaErrorHandler): void;
    function createVersionWithId(jolokia: any, id: any, success: any, error?: typeof Core.defaultJolokiaErrorHandler): void;
    function createVersion(jolokia: any, success: any, error?: typeof Core.defaultJolokiaErrorHandler): void;
    function deleteVersion(jolokia: any, id: any, success: any, error?: typeof Core.defaultJolokiaErrorHandler): void;
    function getVersionIds(jolokia: any): any;
    function getContainerIdsForProfile(jolokia: any, version: any, profileId: any): any;
    function getContainerIdsForProfiles(jolokia: any, version: string, profileIds: string[], checkParents: boolean): any;
    function getContainerIds(jolokia: any): any;
    function getProfile(jolokia: any, version: any, id: any, mandatory: any): any;
    function deleteProfile(jolokia: any, version: any, id: any, success: any, error?: typeof Core.defaultJolokiaErrorHandler): void;
    function profileWebAppURL(jolokia: any, webAppId: any, profileId: any, versionId: any, success: any, error?: typeof Core.defaultJolokiaErrorHandler): void;
    function restApiUrl(jolokia: any, success: any, error?: typeof Core.defaultJolokiaErrorHandler): void;
    function stopContainer(jolokia: any, id: any, success: any, error?: typeof Core.defaultJolokiaErrorHandler): void;
    function destroyContainer(jolokia: any, id: any, success: any, error?: typeof Core.defaultJolokiaErrorHandler): void;
    function startContainer(jolokia: any, id: any, success: any, error?: typeof Core.defaultJolokiaErrorHandler): void;
    function containerWebAppURL(jolokia: any, webAppId: any, containerId: any, success: any, error?: typeof Core.defaultJolokiaErrorHandler): void;
    function getDefaultVersionIdAsync(jolokia: any, callback: (defaultVersion: string) => void): void;
}
declare module Fabric {
    interface CreateLocationDialogOptions {
        selectedContainers: () => Container[];
        callbacks: () => JolokiaCallbacks;
    }
    function getCreateLocationDialog($dialog: any, resolve: CreateLocationDialogOptions): any;
    function getVersionCreateDialog($dialog: any): any;
    function getVersionDeleteDialog($dialog: any): any;
    function getChangeDefaultVersionDialog($dialog: any): any;
    function getVersionPatchDialog($dialog: any): any;
    function addWikiBranchMenuExtensions(wikiBranchMenu: any, $dialog: any, workspace: any): void;
}
declare module CodeEditor {
    interface CodeMirrorOptions {
        theme: string;
        tabSize: number;
        lineNumbers: boolean;
        indentWithTabs: boolean;
        lineWrapping: boolean;
        autoClosetags: boolean;
    }
    var GlobalCodeMirrorOptions: {
        theme: string;
        tabSize: number;
        lineNumbers: boolean;
        indentWithTabs: boolean;
        lineWrapping: boolean;
        autoCloseTags: boolean;
    };
    function detectTextFormat(value: any): string;
    function autoFormatEditor(editor: CodeMirrorEditor): void;
    function createEditorSettings(options?: any): any;
}
declare module UI {
    var log: Logging.Logger;
    var scrollBarWidth: number;
    function findParentWith($scope: any, attribute: any): any;
    function getIfSet(attribute: any, $attr: any, def: any): any;
    function observe($scope: any, $attrs: any, key: any, defValue: any, callbackFunc?: any): void;
    function getScrollbarWidth(): number;
}
declare module UI {
    var pluginName: string;
    var templatePath: string;
    var _module: ng.IModule;
}
declare module UI {
    interface MenuItem {
        heading?: string;
        title?: string;
        icon?: string;
        valid?: () => boolean;
        action?: any;
        items?: MenuItem[];
        objectName?: string;
        methodName?: string;
        argumentTypes?: string;
    }
    function hawtioDropDown($templateCache: any): {
        restrict: string;
        replace: boolean;
        templateUrl: string;
        scope: {
            config: string;
        };
        controller: {}[];
        link: ($scope: any, $element: any, $attrs: any) => void;
    };
}
declare module ContainerHelpers {
    var NO_LOCATION: string;
    function extractLocations(containers: Fabric.Container[]): string[];
    interface WithSelectedContainers {
        selectedContainers: Fabric.Container[];
    }
    function getCreateLocationDialog($scope: WithSelectedContainers, $dialog: any): any;
    interface WithCreateLocationDialog extends WithSelectedContainers {
        selectedContainers: Fabric.Container[];
        createLocationDialog: any;
    }
    function buildLocationMenu($scope: WithCreateLocationDialog, jolokia: any, locations: string[]): UI.MenuItem;
    function isCurrentContainer(container: any): boolean;
    function canConnect(container: any): boolean;
    function statusTitle(container: any): string;
    function statusIcon(row: Fabric.Container): string;
    function gotoContainer($location: any, container: Fabric.Container): void;
    function doDeleteContainer($scope: any, jolokia: any, name: any, onDelete?: () => any): void;
    function doStartContainer($scope: any, jolokia: any, name: any): void;
    function doStopContainer($scope: any, jolokia: any, name: any): void;
    function stopContainers($scope: any, jolokia: any, c: Fabric.Container[]): void;
    function startContainers($scope: any, jolokia: any, c: Fabric.Container[]): void;
    function anyStartable(containers: Fabric.Container[]): boolean;
    function anyStoppable(containers: Fabric.Container[]): boolean;
    function allAlive(containers: Fabric.Container[], state?: boolean): boolean;
    function decorate($scope: any, $location: any, jolokia: any): void;
}
declare module Fabric {
    function getResolvers(id: any): any;
    function customizeSchema(id: any, schema: any): any;
}
declare module Git {
    function createGitRepository(workspace: Workspace, jolokia: any, localStorage: any): GitRepository;
    var jmxDomain: string;
    var mbeanType: string;
    function hasGit(workspace: Workspace): boolean;
    function getGitMBean(workspace: Workspace): string;
    function getGitMBeanFolder(workspace: Workspace): Folder;
    function isGitMBeanFabric(workspace: Workspace): boolean;
}
declare module UI {
    class Dialog {
        show: boolean;
        options: {
            backdropFade: boolean;
            dialogFade: boolean;
        };
        open(): void;
        close(): void;
        removeBackdropFadeDiv(): void;
    }
    interface MultiItemConfirmActionOptions {
        collection: any[];
        index: string;
        onClose: (result: boolean) => void;
        action: string;
        okText?: string;
        cancelText?: string;
        title?: string;
        custom?: string;
        okClass?: string;
        cancelClass?: string;
        customClass?: string;
    }
    function multiItemConfirmActionDialog(options: MultiItemConfirmActionOptions): any;
}
declare module Git {
    interface GitRepository {
        getRepositoryLabel(fn: any, error: any): any;
        exists(branch: string, path: string, fn: any): Boolean;
        read(branch: string, path: string, fn: any): any;
        completePath(branch: string, completionText: string, directoriesOnly: boolean, fn: any): any;
        write(branch: string, path: string, commitMessage: string, contents: string, fn: any): any;
        writeBase64(branch: string, path: string, commitMessage: string, contents: string, fn: any): any;
        createDirectory(branch: string, path: string, commitMessage: string, fn: any): any;
        revertTo(branch: string, objectId: string, blobPath: string, commitMessage: string, fn: any): any;
        rename(branch: string, oldPath: string, newPath: string, commitMessage: string, fn: any): any;
        remove(branch: string, path: string, commitMessage: string, fn: any): any;
        history(branch: string, objectId: string, path: string, limit: number, fn: any): any;
        getContent(objectId: string, blobPath: string, fn: any): any;
        branches(fn: any): any;
        readJsonChildContent(path: string, nameWildcard: string, search: string, fn: any): any;
        diff(objectId: string, baseObjectId: string, path: string, fn: any): any;
        commitTree(commitId: string, fn: any): any;
        commitInfo(commitId: string, fn: any): any;
        getUserName(): string;
        getUserEmail(): string;
    }
    class JolokiaGit implements GitRepository {
        mbean: string;
        jolokia: any;
        localStorage: any;
        userDetails: any;
        branch: string;
        constructor(mbean: string, jolokia: any, localStorage: any, userDetails: any, branch?: string);
        getRepositoryLabel(fn: any, error: any): any;
        exists(branch: string, path: string, fn: any): Boolean;
        read(branch: string, path: string, fn: any): any;
        write(branch: string, path: string, commitMessage: string, contents: string, fn: any): any;
        writeBase64(branch: string, path: string, commitMessage: string, contents: string, fn: any): any;
        createDirectory(branch: string, path: string, commitMessage: string, fn: any): any;
        revertTo(branch: string, objectId: string, blobPath: string, commitMessage: string, fn: any): any;
        rename(branch: string, oldPath: string, newPath: string, commitMessage: string, fn: any): any;
        remove(branch: string, path: string, commitMessage: string, fn: any): any;
        completePath(branch: string, completionText: string, directoriesOnly: boolean, fn: any): any;
        history(branch: string, objectId: string, path: string, limit: number, fn: any): any;
        commitTree(commitId: string, fn: any): any;
        commitInfo(commitId: string, fn: any): any;
        diff(objectId: string, baseObjectId: string, path: string, fn: any): any;
        getContent(objectId: string, blobPath: string, fn: any): any;
        readJsonChildContent(path: string, nameWildcard: string, search: string, fn: any): any;
        branches(fn: any): any;
        getUserName(): string;
        getUserEmail(): string;
    }
}
declare module Wiki {
    var log: Logging.Logger;
    var camelNamespaces: string[];
    var springNamespaces: string[];
    var droolsNamespaces: string[];
    var dozerNamespaces: string[];
    var activemqNamespaces: string[];
    var excludeAdjustmentPrefixes: string[];
    enum ViewMode {
        List = 0,
        Icon = 1,
    }
    var customWikiViewPages: string[];
    var hideExtensions: string[];
    interface GenerateOptions {
        workspace: Core.Workspace;
        form: any;
        name: string;
        branch: string;
        parentId: string;
        success: (fileContents?: string) => void;
        error: (error: any) => void;
    }
    var documentTemplates: {}[];
    function isWikiEnabled(workspace: Workspace, jolokia: any, localStorage: any): boolean;
    function goToLink(link: any, $timeout: any, $location: any): void;
    function customViewLinks($scope: any): any[];
    function createWizardTree(workspace: Workspace, $scope: any): Folder;
    function addCreateWizardFolders(workspace: Workspace, $scope: any, parent: Folder, templates: any[]): void;
    function startLink(branch: string): string;
    function isIndexPage(path: string): boolean;
    function viewLink(branch: string, pageId: string, $location: any, fileName?: string): string;
    function branchLink(branch: string, pageId: string, $location: any, fileName?: string): string;
    function editLink(branch: string, pageId: string, $location: any): string;
    function createLink(branch: string, pageId: string, $location: any, $scope: any): string;
    function encodePath(pageId: string): string;
    function decodePath(pageId: string): string;
    function fileFormat(name: string, fileExtensionTypeRegistry?: any): any;
    function fileName(path: string): string;
    function fileParent(path: string): string;
    function hideFileNameExtensions(name: any): any;
    function gitRestURL(branch: string, path: string): string;
    function gitRelativeURL(branch: string, path: string): string;
    function fileIconHtml(row: any): string;
    function iconClass(row: any): string;
    function initScope($scope: any, $routeParams: any, $location: any): void;
    function loadBranches(jolokia: any, wikiRepository: any, $scope: any, isFmc?: boolean): void;
    function pageId($routeParams: any, $location: any): any;
    function pageIdFromURI(url: string): string;
    function fileExtension(name: any): string;
    function onComplete(status: any): void;
    function parseJson(text: string): any;
    function adjustHref($scope: any, $location: any, href: any, fileExtension: any): string;
}
declare module Fabric {
    interface Icon {
        title: string;
        type: string;
        src: string;
    }
    class IconRegistry {
        private icons;
        addIcons(icon: Icon, domain: string, ...domains: string[]): void;
        private addIcon(icon, domain);
        getIcons(things: string[]): any[];
        getIcon(thing: string): any;
    }
    var javaIcon: Icon;
    var serviceIconRegistry: IconRegistry;
    var containerIconRegistry: IconRegistry;
}
declare module Core {
}
declare module Fabric {
    var OpenShiftCredentials: Core.UserDetails;
    function fabricCreated(workspace: any): any;
    function canBootstrapFabric(workspace: any): any;
    function hasClusterBootstrapManager(workspace: any): any;
    function hasClusterServiceManager(workspace: any): any;
    function hasZooKeeper(workspace: any): any;
    function hasOpenShiftFabric(workspace: any): any;
    function hasMQManager(workspace: any): any;
    function hasSchemaMBean(workspace: any): any;
    function hasGitMBean(workspace: any): any;
    function isFMCContainer(workspace: any): any;
    function hasFabric(workspace: any): boolean;
    function initScope($scope: any, $location: any, jolokia: any, workspace: any): void;
    function viewVersion(versionId: any, $location: any, $scope: any): void;
    function doCreateVersion($scope: any, jolokia: any, $location: any, newVersionName: any, newVersionDescription?: string, parentId?: string): void;
    function sortVersions(versions: any, order: boolean): any;
    function pagePathToProfileId(pageId: any): string;
    function profilePath(profileId: any): string;
    function profileLink(workspace: any, jolokia: any, localStorage: any, versionId: any, profileId: any): any;
    function containerCountBadgeStyle(min: any, max: any, count: any): string;
    function gotoProfile(workspace: any, jolokia: any, localStorage: any, $location: any, versionId: any, profile: any): void;
    function gotoContainer(containerId: string): void;
    function setSelect(selection: any, group: any): any;
    var urlResolvers: string[];
    function completeUri($q: any, $scope: any, workspace: any, jolokia: any, something: any): void;
    function getActiveVersion($location: any): any;
    interface IScopeWithApiURL extends ng.IScope {
        restApiUrl: string;
    }
    function loadRestApi(jolokia: any, workspace: Workspace, $scope: IScopeWithApiURL, callback?: (response: any) => void): void;
    function toIconURL($scope: any, iconURL: any): any;
    function getVersionsInUse(jolokia: any, callback: (used: string[]) => void): void;
    function profileJolokia(jolokia: any, profileId: any, versionId: any, onJolokia: any): any;
    function containerJolokia(jolokia: any, containerId: any, onJolokia: any): void;
    function getServiceList(container: any): any[];
    function getTypeIcon(container: Container): any;
    function usingProfile(group: Profile[], targetId: string, action: (profile: Profile) => void): void;
    function getDefaultVersionId(jolokia: any): any;
    function getDefaultVersion(jolokia: any): any;
    function setDefaultVersion(jolokia: any, newVersion: any, callback: () => void): void;
    function defaultContainerValues(workspace: Workspace, $scope: any, values: any): any;
    function toCollection(values: any): any;
    function containerLinks(workspace: any, values: any): string;
    function profileLinks(workspace: any, versionId: any, values: any): string;
    function defaultProfileValues(workspace: any, versionId: any, values: any): any;
    function getZooKeeperFacadeMBean(workspace: Core.Workspace): any;
    var statusTitle: typeof ContainerHelpers.statusTitle;
    var statusIcon: typeof ContainerHelpers.statusIcon;
    function createJolokia(url: string): Jolokia.IJolokia;
    function registeredProviders(jolokia: any): {};
    function getSchema(id: any, className: any, jolokia: any, cb: any): void;
    function getDtoSchema(id: any, className: any, jolokia: any, cb: any): void;
    function getCurrentContainer(jolokia: any, fields: any): any;
    function getContainerFields(jolokia: any, name: any, fields: any): any;
    function getRootContainers(jolokia: any): any[];
    function getContainersFields(jolokia: any, fields: any, fn?: any): any;
    function getOpenShiftDomains(workspace: any, jolokia: any, serverUrl: any, login: any, password: any, fn?: any, onError?: any): any;
    function getOpenShiftGearProfiles(workspace: any, jolokia: any, serverUrl: any, login: any, password: any, fn?: any): any;
    function filterProfiles(jolokia: any, versionId: any, profileIds: any): any[];
    function getProfileData(jolokia: any, versionId: any, profileId: any, fields: any): any;
    function getConfigFile(jolokia: any, versionId: any, profileId: any, fileName: any, fn?: any): any;
    function brokerConfigLink(workspace: any, jolokia: any, localStorage: any, brokerVersion: any, brokerProfile: any, brokerId: any): any;
    function connectToBroker($scope: any, container: any, postfix?: any): void;
    function sanitizeJson(json: Object): Object;
}
declare module Site {
    var sitePluginEnabled: boolean;
    function isSiteNavBarValid(): boolean;
}
declare module Perspective {
    var containerPerspectiveEnabled: boolean;
    var metadata: {
        fabric: {
            icon: {
                title: string;
                type: string;
                src: string;
            };
            label: string;
            isValid: (workspace: any) => any;
            lastPage: string;
            topLevelTabs: {
                includes: {}[];
            };
        };
        container: {
            icon: {
                title: string;
                type: string;
                src: string;
            };
            label: string;
            lastPage: string;
            isValid: (workspace: any) => any;
            topLevelTabs: {
                excludes: {}[];
            };
        };
        limited: {
            label: string;
            lastPage: string;
            isValid: (workspace: any) => boolean;
            topLevelTabs: {
                includes: {
                    href: string;
                }[];
            };
        };
        website: {
            label: string;
            isValid: (workspace: any) => boolean;
            lastPage: string;
            topLevelTabs: {
                includes: {
                    content: string;
                    title: string;
                    href: () => string;
                    isValid: () => boolean;
                }[];
            };
        };
    };
}
declare module Perspective {
    var log: Logging.Logger;
    var perspectiveSearchId: string;
    var defaultPerspective: string;
    var defaultPageLocation: string;
    function currentPerspectiveId($location: ng.ILocationService, workspace: Core.Workspace, jolokia: any, localStorage: Storage): any;
    function getPerspectives($location: any, workspace: any, jolokia: any, localStorage: any): any[];
    function getPerspectiveById(id: any): any;
    function topLevelTabsForPerspectiveId(workspace: any, perspective: any): any[];
    function filterOnlyValidTopLevelTabs(workspace: any, topLevelTabs: any): any;
    function filterOnlyActiveTopLevelTabs(workspace: any, topLevelTabs: any): any;
    function getTopLevelTabsForPerspective($location: any, workspace: Workspace, jolokia: any, localStorage: any): any[];
    function choosePerspective($location: any, workspace: Workspace, jolokia: any, localStorage: any): any;
    function defaultPage($location: any, workspace: Workspace, jolokia: any, localStorage: any): string;
    function shouldShowWelcomePage(localStorage: any): boolean;
}
declare module Core {
    var ConsoleController: ng.IModule;
    var AppController: ng.IModule;
}
declare module Core {
}
declare module Core {
}
declare module Core {
    class HelpRegistry {
        $rootScope: any;
        private discoverableDocTypes;
        private topicNameMappings;
        private subTopicNameMappings;
        private pluginNameMappings;
        private ignoredPlugins;
        private topics;
        constructor($rootScope: any);
        addUserDoc(topic: any, path: any, isValid?: () => boolean): void;
        addDevDoc(topic: any, path: any, isValid?: () => boolean): void;
        addSubTopic(topic: any, subtopic: any, path: any, isValid?: () => boolean): void;
        getOrCreateTopic(topic: any, isValid?: () => boolean): any;
        mapTopicName(name: any): any;
        mapSubTopicName(name: any): any;
        getTopics(): {};
        disableAutodiscover(name: any): void;
        discoverHelpFiles(plugins: any): void;
    }
}
declare module Core {
    class PreferencesRegistry {
        private tabs;
        constructor();
        addTab(name: string, template: string, isValid?: () => boolean): void;
        getTab(name: string): any;
        getTabs(): any;
    }
}
declare module Themes {
    var defaultLoginBg: string;
    var definitions: {
        '3270': {
            label: string;
            file: string;
            loginBg: string;
        };
        'Default': {
            label: string;
            file: string;
            loginBg: string;
        };
        'Dark': {
            label: string;
            file: string;
            loginBg: string;
        };
    };
    var brandings: {
        'hawtio': {
            label: string;
            setFunc: (branding: any) => any;
        };
        'Example': {
            label: string;
            setFunc: (branding: any) => any;
        };
    };
    var currentTheme: string;
    var currentBranding: string;
    function getAvailableThemes(): string[];
    function getAvailableBrandings(): string[];
    function setBranding(name: any, branding: any): void;
    function setTheme(name: any, branding: any): void;
    var pluginName: string;
    var log: Logging.Logger;
    var _module: ng.IModule;
}
declare module Core {
    var DEFAULT_MAX_DEPTH: number;
    var DEFAULT_MAX_COLLECTION_SIZE: number;
}
declare module Core {
    var fileUploadMBean: string;
    class FileUpload {
        restrict: string;
        replace: boolean;
        templateUrl: string;
        scope: {
            files: string;
            target: string;
            showFiles: string;
        };
        controller: {}[];
        link: ($scope: any, $element: any, $attrs: any) => void;
    }
}
declare module Core {
    function d3ForceGraph(scope: any, nodes: any, links: any, canvasElement: any): void;
    function createGraphStates(nodes: any, links: any, transitions: any): any;
    function dagreLayoutGraph(nodes: any, links: any, width: any, height: any, svgElement: any, allowDrag?: boolean, onClick?: any): any;
    function dagreUpdateGraphData(data: any): void;
}
declare module Core {
    class GridStyle {
        $window: any;
        restrict: string;
        link: (scope: any, element: any, attrs: any) => any;
        constructor($window: any);
        private doLink(scope, element, attrs);
    }
}
declare module Core {
}
declare module Core {
}
declare module Core {
    interface DummyJolokia extends Jolokia.IJolokia {
        running: boolean;
    }
}
declare module Core {
}
declare module Core {
    interface NavBarViewCustomLink {
        title: string;
        icon: string;
        href: string;
        action: () => void;
    }
    interface NavBarViewCustomLinks {
        list: NavBarViewCustomLink[];
        dropDownLabel: string;
    }
    var NavBarController: ng.IModule;
}
declare module Core {
    var PluginPreferences: ng.IModule;
}
declare module Core {
}
declare module Core {
}
declare module Core {
    var ViewController: ng.IModule;
}
declare module Core {
}
declare module DataTable {
    class TableWidget {
        scope: any;
        $templateCache: any;
        $compile: any;
        dataTableColumns: TableColumnConfig[];
        config: TableWidgetConfig;
        private ignoreColumnHash;
        private flattenColumnHash;
        private detailTemplate;
        private openMessages;
        private addedExpandNodes;
        tableElement: any;
        sortColumns: any[][];
        dataTableConfig: {
            bPaginate: boolean;
            sDom: string;
            bDestroy: boolean;
            bAutoWidth: boolean;
        };
        dataTable: any;
        constructor(scope: any, $templateCache: any, $compile: any, dataTableColumns: TableColumnConfig[], config?: TableWidgetConfig);
        addData(newData: any): void;
        populateTable(data: any): void;
        populateDetailDiv(row: any, div: any): void;
    }
    interface TableColumnConfig {
        mData?: string;
        mDataProp?: string;
        sClass?: string;
        sDefaultContent?: string;
        sWidth?: string;
        mRender?: (...args: any[]) => any;
    }
    interface TableWidgetConfig {
        ignoreColumns?: string[];
        flattenColumns?: string[];
        disableAddColumns?: Boolean;
        rowDetailTemplateId?: string;
        selectHandler?: (any: any) => any;
        multiSelect?: Boolean;
    }
}
declare module DataTable {
    var pluginName: string;
    var log: Logging.Logger;
    var _module: ng.IModule;
}
declare module FilterHelpers {
    var log: Logging.Logger;
    function search(object: any, filter: string, maxDepth?: number, and?: boolean): boolean;
    function searchObject(object: any, filter: string, maxDepth?: number, depth?: number): boolean;
}
declare module DataTable {
    class SimpleDataTable {
        $compile: any;
        restrict: string;
        scope: {
            config: string;
            target: string;
            showFiles: string;
        };
        link: (scope: any, element: any, attrs: any) => any;
        constructor($compile: any);
        private doLink($scope, $element, $attrs);
    }
}
declare module Forms {
    var log: Logging.Logger;
    function defaultValues(entity: any, schema: any): void;
    function resolveTypeNameAlias(type: any, schema: any): any;
    function isJsonType(name: any, schema: any, typeName: any): boolean;
    function safeIdentifier(id: string): string;
    function lookupDefinition(name: any, schema: any): any;
    function findArrayItemsSchema(property: any, schema: any): any;
    function isObjectType(definition: any): boolean;
    function isKind(definition: any, kind: string): boolean;
    function isArrayOrNestedObject(property: any, schema: any): boolean;
    function configure(config: any, scopeConfig: any, attrs: any): any;
    function getControlGroup(config: any, arg: any, id: any): ng.IAugmentedJQuery;
    function getLabel(config: any, arg: any, label: any, required?: boolean): ng.IAugmentedJQuery;
    function getControlDiv(config: any): ng.IAugmentedJQuery;
    function getHelpSpan(config: any, arg: any, id: any, property?: any): ng.IAugmentedJQuery;
}
declare module Forms {
    function createWidget(propTypeName: any, property: any, schema: any, config: any, id: any, ignorePrefixInLabel: any, configScopeName: any, wrapInGroup?: boolean, disableHumanizeLabel?: boolean): JQuery;
    function createStandardWidgetMarkup(propTypeName: any, property: any, schema: any, config: any, options: any, id: any): string;
    function mapType(type: String): String;
    function normalize(type: any, property: any, schema: any): string;
}
declare module Forms {
    class InputBaseConfig {
        name: string;
        type: string;
        description: string;
        _default: string;
        scope: any;
        mode: string;
        schemaName: string;
        controlgroupclass: string;
        controlclass: string;
        labelclass: string;
        showtypes: string;
        formtemplate: any;
        entity: string;
        model: any;
        getEntity(): string;
        getMode(): string;
        isReadOnly(): boolean;
    }
    class InputBase {
        workspace: any;
        $compile: any;
        restrict: string;
        scope: boolean;
        replace: boolean;
        transclude: boolean;
        private attributeName;
        link: (scope: any, element: any, attrs: any) => any;
        constructor(workspace: any, $compile: any);
        doLink(scope: any, element: any, attrs: any): void;
        getControlGroup(config1: any, config2: any, id: any): any;
        getInput(config: any, arg: any, id: any, modelName: any): JQuery;
    }
    class TextInput extends InputBase {
        workspace: any;
        $compile: any;
        type: string;
        constructor(workspace: any, $compile: any);
        getInput(config: any, arg: any, id: any, modelName: any): JQuery;
    }
    class HiddenText extends TextInput {
        workspace: any;
        $compile: any;
        type: string;
        constructor(workspace: any, $compile: any);
        getControlGroup(config1: any, config2: any, id: any): any;
        getInput(config: any, arg: any, id: any, modelName: any): JQuery;
    }
    class PasswordInput extends TextInput {
        workspace: any;
        $compile: any;
        type: string;
        constructor(workspace: any, $compile: any);
    }
    class CustomInput extends InputBase {
        workspace: any;
        $compile: any;
        constructor(workspace: any, $compile: any);
        getInput(config: any, arg: any, id: any, modelName: any): JQuery;
    }
    class SelectInput extends InputBase {
        workspace: any;
        $compile: any;
        constructor(workspace: any, $compile: any);
        getInput(config: any, arg: any, id: any, modelName: any): JQuery;
    }
    class NumberInput extends InputBase {
        workspace: any;
        $compile: any;
        constructor(workspace: any, $compile: any);
        getInput(config: any, arg: any, id: any, modelName: any): JQuery;
    }
    class StringArrayInput extends InputBase {
        workspace: any;
        $compile: any;
        constructor(workspace: any, $compile: any);
        getInput(config: any, arg: any, id: any, modelName: any): ng.IAugmentedJQuery;
    }
    class ArrayInput extends InputBase {
        workspace: any;
        $compile: any;
        constructor(workspace: any, $compile: any);
        doLink(scope: any, element: any, attrs: any): void;
    }
    class BooleanInput extends InputBase {
        workspace: any;
        $compile: any;
        constructor(workspace: any, $compile: any);
        getInput(config: any, arg: any, id: any, modelName: any): JQuery;
    }
}
declare module Forms {
    class SimpleFormConfig {
        name: string;
        method: string;
        entity: string;
        schemaName: string;
        mode: string;
        data: any;
        json: any;
        scope: any;
        scopeName: string;
        properties: any[];
        action: string;
        formclass: string;
        controlgroupclass: string;
        controlclass: string;
        labelclass: string;
        showtypes: string;
        showhelp: string;
        showempty: string;
        onsubmit: string;
        getMode(): string;
        getEntity(): string;
        isReadOnly(): boolean;
    }
    class SimpleForm {
        private workspace;
        $compile: any;
        restrict: string;
        scope: boolean;
        replace: boolean;
        transclude: boolean;
        private attributeName;
        link: (scope: any, element: any, attrs: any) => any;
        constructor(workspace: any, $compile: any);
        isReadOnly(): boolean;
        private doLink(scope, element, attrs);
        private createForm(config);
        private getLegend(config);
    }
}
declare module Forms {
    class InputTableConfig {
        name: string;
        method: string;
        entity: string;
        tableConfig: string;
        mode: string;
        data: any;
        json: any;
        properties: any[];
        action: string;
        tableclass: string;
        controlgroupclass: string;
        controlclass: string;
        labelclass: string;
        showtypes: string;
        removeicon: string;
        editicon: string;
        addicon: string;
        removetext: string;
        edittext: string;
        addtext: string;
        onadd: string;
        onedit: string;
        onremove: string;
        primaryKeyProperty: any;
        getTableConfig(): string;
    }
    class InputTable {
        private workspace;
        $compile: any;
        restrict: string;
        scope: boolean;
        replace: boolean;
        transclude: boolean;
        private attributeName;
        link: (scope: any, element: any, attrs: any) => any;
        constructor(workspace: any, $compile: any);
        private doLink(scope, element, attrs);
        private getAddButton(config);
        private getEditButton(config);
        private getRemoveButton(config);
        private createTable(config, tableConfig);
        private getLegend(config);
        private getControlGroup(config, arg, id);
        private getControlDiv(config);
        private getHelpSpan(config, arg, id);
    }
}
declare module Forms {
    class SubmitForm {
        restrict: string;
        scope: boolean;
        link: (scope: any, element: any, attrs: any) => any;
        constructor();
        private doLink(scope, element, attrs);
    }
}
declare module Forms {
    class ResetForm {
        restrict: string;
        scope: boolean;
        link: (scope: any, element: any, attrs: any) => any;
        constructor();
        private doLink(scope, element, attrs);
    }
}
declare module Forms {
    var pluginName: string;
    var templateUrl: string;
    var _module: ng.IModule;
}
declare module Forms {
    interface AttributeMap {
        [key: string]: string;
    }
    interface FormElement {
        type: string;
        tooltip?: string;
        label?: string;
        hidden?: boolean;
        'input-attributes'?: AttributeMap;
        'control-group-attributes'?: AttributeMap;
        formTemplate?: string;
    }
    function createFormElement(): FormElement;
    interface FormProperties {
        [name: string]: FormElement;
    }
    interface FormTabs {
        [name: string]: string[];
    }
    function createFormTabs(): FormTabs;
    interface FormConfiguration {
        id?: string;
        type?: string;
        disableHumanizeLabel?: boolean;
        ignorePrefixInLabel?: boolean;
        properties: FormProperties;
        tabs?: FormTabs;
    }
    function createFormConfiguration(): FormConfiguration;
    interface FormGridElement extends FormElement {
        key?: string;
        headerTemplate: string;
        template: string;
    }
    interface FormGridProperties {
        [name: string]: FormGridElement;
    }
    interface FormGridRowConfiguration extends FormConfiguration {
        properties: FormGridProperties;
        columnOrder: string[];
    }
    interface FormGridConfiguration {
        heading?: boolean;
        rowName?: string;
        rowSchema: FormGridRowConfiguration;
        rows: any[];
        onAdd: () => any;
        noDataTemplate: string;
    }
    function createFormGridConfiguration(): FormGridConfiguration;
}
declare module Forms {
}
declare module Forms {
}
declare module Forms {
    var FormTestController: ng.IModule;
}
declare module Jmx {
    function createDashboardLink(widgetType: any, widget: any): string;
    function getWidgetType(widget: any): Object;
    var jmxWidgetTypes: {
        type: string;
        icon: string;
        route: string;
        size_x: number;
        size_y: number;
        title: string;
    }[];
    var jmxWidgets: {}[];
}
declare module Jmx {
    var currentProcessId: string;
    var _module: ng.IModule;
}
declare module Jmx {
    var AreaChartController: ng.IModule;
}
declare module Jmx {
}
declare module Jmx {
    var propertiesColumnDefs: {
        field: string;
        displayName: string;
        width: string;
        cellTemplate: string;
    }[];
    var foldersColumnDefs: {
        displayName: string;
        cellTemplate: string;
    }[];
    var AttributesController: ng.IModule;
}
declare module Jmx {
}
declare module Jmx {
}
declare module Jmx {
    var DonutChartController: ng.IModule;
}
declare module Tree {
    var pluginName: string;
    var log: Logging.Logger;
    function expandAll(el: any): void;
    function contractAll(el: any): void;
    function sanitize(tree: any): void;
    var _module: ng.IModule;
}
declare module Jmx {
}
declare module Jmx {
}
declare module Perspective {
    var _module: ng.IModule;
}
declare module Perspective {
    function DefaultPageController($scope: any, $location: any, localStorage: any, workspace: Workspace, jolokia: any): void;
}
declare module RBAC {
    var log: Logging.Logger;
    function flattenMBeanTree(mbeans: any, tree: any): void;
    function stripClasses(css: string): string;
    function addClass(css: string, _class: string): string;
}
declare module RBAC {
    interface RBACTasks extends Core.Tasks {
        initialize: (mbean: string) => void;
        getACLMBean: () => ng.IPromise<string>;
    }
    class RBACTasksImpl extends Core.TasksImpl implements RBACTasks {
        private deferred;
        private ACLMBean;
        constructor(deferred: ng.IDeferred<string>);
        initialize(mbean: string): void;
        getACLMBean(): ng.IPromise<string>;
    }
    var rbacTasks: RBACTasks;
}
declare module RBAC {
    var pluginName: string;
    var _module: ng.IModule;
}
declare module RBAC {
    var hawtioShow: ng.IModule;
}
declare module Themes {
}
declare module UI {
    class AutoColumns {
        restrict: string;
        link: ($scope: any, $element: any, $attr: any) => void;
    }
}
declare module UI {
    var AutoDropDown: {
        restrict: string;
        link: ($scope: any, $element: any, $attrs: any) => void;
    };
}
declare module UI {
    function hawtioBreadcrumbs(): {
        restrict: string;
        replace: boolean;
        templateUrl: string;
        require: string;
        scope: {
            config: string;
        };
        controller: {}[];
    };
}
declare module UI {
    var selected: string;
    var unselected: string;
    class ColorPicker {
        restrict: string;
        replace: boolean;
        scope: {
            property: string;
        };
        templateUrl: string;
        compile: (tElement: any, tAttrs: any, transclude: any) => {
            post: (scope: any, iElement: any, iAttrs: any, controller: any) => void;
        };
        controller: {}[];
    }
}
declare module UI {
    interface ConfirmDialogConfig {
        show: string;
        title: string;
        okButtonText: string;
        showOkButton: string;
        cancelButtonText: string;
        onCancel: string;
        onOk: string;
        onClose: string;
    }
    class ConfirmDialog {
        restrict: string;
        replace: boolean;
        transclude: boolean;
        templateUrl: string;
        scope: ConfirmDialogConfig;
        controller: {}[];
        constructor();
    }
}
declare module UI {
}
declare module UI {
    var hawtioDrag: ng.IModule;
    var hawtioDrop: ng.IModule;
}
declare module UI {
    class EditableProperty {
        private $parse;
        restrict: string;
        scope: boolean;
        templateUrl: string;
        require: string;
        link: any;
        constructor($parse: any);
    }
}
declare module UI {
    function Editor($parse: any): {
        restrict: string;
        replace: boolean;
        templateUrl: string;
        scope: {
            text: string;
            mode: string;
            outputEditor: string;
            name: string;
        };
        controller: {}[];
        link: ($scope: any, $element: any, $attrs: any) => void;
    };
}
declare module UI {
    class Expandable {
        log: Logging.Logger;
        restrict: string;
        replace: boolean;
        open(model: any, expandable: any, scope: any): void;
        close(model: any, expandable: any, scope: any): void;
        forceClose(model: any, expandable: any, scope: any): void;
        forceOpen(model: any, expandable: any, scope: any): void;
        link: any;
        constructor();
    }
}
declare module UI {
}
declare module UI {
    var hawtioFilter: ng.IModule;
}
declare module UI {
    class GridsterDirective {
        restrict: string;
        replace: boolean;
        controller: {}[];
        link: ($scope: any, $element: any, $attrs: any) => void;
    }
}
declare module UI {
    function groupBy(): (list: any, group: any) => any;
}
declare module UI {
    var IconTestController: ng.IModule;
    function hawtioIcon(): {
        restrict: string;
        replace: boolean;
        templateUrl: string;
        scope: {
            icon: string;
        };
        link: ($scope: any, $element: any, $attrs: any) => void;
    };
}
declare module UI {
}
declare module UI {
    function hawtioList($templateCache: any, $compile: any): {
        restrict: string;
        replace: boolean;
        templateUrl: string;
        scope: {
            'config': string;
        };
        link: ($scope: any, $element: any, $attr: any) => void;
    };
}
declare module UI {
}
declare module UI {
    function hawtioPane(): {
        restrict: string;
        replace: boolean;
        transclude: boolean;
        templateUrl: string;
        scope: {
            position: string;
            width: string;
            header: string;
        };
        controller: {}[];
        link: ($scope: any, $element: any, $attr: any) => void;
    };
}
declare module UI {
    class MessagePanel {
        restrict: string;
        link: ($scope: any, $element: any, $attrs: any) => void;
    }
    class InfoPanel {
        restrict: string;
        link: ($scope: any, $element: any, $attrs: any) => void;
    }
}
declare module UI {
    class DivRow {
        restrict: string;
        link: ($scope: any, $element: any, $attrs: any) => void;
    }
}
declare module UI {
    class SlideOut {
        restrict: string;
        replace: boolean;
        transclude: boolean;
        templateUrl: string;
        scope: {
            show: string;
            direction: string;
            top: string;
            height: string;
            title: string;
        };
        controller: {}[];
        link: ($scope: any, $element: any, $attrs: any) => void;
    }
}
declare module UI {
    class TablePager {
        restrict: string;
        scope: boolean;
        templateUrl: string;
        link: (scope: any, element: any, attrs: any) => any;
        $scope: any;
        element: any;
        attrs: any;
        tableName: string;
        setRowIndexName: string;
        rowIndexName: string;
        constructor();
        private doLink(scope, element, attrs);
        tableData(): any;
        goToIndex(idx: number): void;
    }
}
declare module SelectionHelpers {
    function selectNone(group: any[]): void;
    function selectAll(group: any[], filter?: (any: any) => boolean): void;
    function toggleSelection(item: any): void;
    function selectOne(group: any[], item: any): void;
    function sync(selections: any[], group: any[], index: string): any[];
    function select(group: any[], item: any, $event: any): void;
    function isSelected(item: any, yes?: string, no?: string): any;
    function clearGroup(group: any): void;
    function toggleSelectionFromGroup(group: any[], item: any, search?: (item: any) => boolean): void;
    function isInGroup(group: any[], item: any, yes?: string, no?: string, search?: (item: any) => boolean): any;
    function filterByGroup(group: any, item: any, yes?: string, no?: string, search?: (item: any) => boolean): any;
    function syncGroupSelection(group: any, collection: any, attribute?: string): void;
    function decorate($scope: any): void;
}
declare module UI {
    var hawtioTagFilter: ng.IModule;
}
declare module UI {
    var hawtioTagList: ng.IModule;
}
declare module UI {
    function TemplatePopover($templateCache: any, $compile: any, $document: any): {
        restrict: string;
        link: ($scope: any, $element: any, $attr: any) => void;
    };
}
declare module UI {
}
declare module UI {
    function HawtioTocDisplay(marked: any, $location: any, $anchorScroll: any, $compile: any): {
        restrict: string;
        scope: {
            getContents: string;
        };
        controller: {}[];
        link: ($scope: any, $element: any, $attrs: any) => void;
    };
}
declare module UI {
    class ViewportHeight {
        restrict: string;
        link: ($scope: any, $element: any, $attrs: any) => void;
    }
    class HorizontalViewport {
        restrict: string;
        link: ($scope: any, $element: any, $attrs: any) => void;
    }
}
declare module UI {
    function ZeroClipboardDirective($parse: any): {
        restrict: string;
        link: ($scope: any, $element: any, $attr: any) => void;
    };
}
