/*
 * Decompiled with CFR 0.152.
 */
package io.hawt;

import io.hawt.jmx.About;
import io.hawt.jmx.JmxTreeWatcher;
import io.hawt.jmx.PluginRegistry;
import io.hawt.jmx.QuartzFacade;
import io.hawt.jmx.UploadManager;
import io.hawt.system.ConfigManager;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class HawtioContextListener
implements ServletContextListener {
    private About about = new About();
    private QuartzFacade quartz = new QuartzFacade();
    private JmxTreeWatcher treeWatcher = new JmxTreeWatcher();
    private PluginRegistry registry = new PluginRegistry();
    private UploadManager uploadManager = new UploadManager();
    private ConfigManager configManager = new ConfigManager();

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            this.about.init();
            this.quartz.init();
            this.configManager.init();
            this.treeWatcher.init();
            this.registry.init();
            this.uploadManager.init(this.configManager);
        }
        catch (Exception e) {
            throw this.createServletException(e);
        }
        servletContextEvent.getServletContext().setAttribute("ConfigManager", (Object)this.configManager);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        try {
            this.about.destroy();
            this.quartz.destroy();
            this.treeWatcher.destroy();
            this.registry.destroy();
            this.uploadManager.destroy();
            this.configManager.destroy();
        }
        catch (Exception e) {
            throw this.createServletException(e);
        }
    }

    protected RuntimeException createServletException(Exception e) {
        return new RuntimeException(e);
    }
}

