/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.jmx;

import io.hawt.jmx.FileDTO;
import io.hawt.jmx.UploadManagerMBean;
import io.hawt.system.ConfigManager;
import io.hawt.util.Strings;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.FileCleanerCleanup;
import org.apache.commons.io.FileCleaningTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadManager
implements UploadManagerMBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(UploadManager.class);
    public static String UPLOAD_DIRECTORY = "";
    private ObjectName objectName;
    private MBeanServer mBeanServer;

    public static DiskFileItemFactory newDiskFileItemFactory(ServletContext context, File repository) {
        FileCleaningTracker fileCleaningTracker = FileCleanerCleanup.getFileCleaningTracker((ServletContext)context);
        DiskFileItemFactory factory = new DiskFileItemFactory(10240, repository);
        factory.setFileCleaningTracker(fileCleaningTracker);
        return factory;
    }

    public void init(ConfigManager config) throws Exception {
        UPLOAD_DIRECTORY = config.get("uploadDirectory", System.getProperty("java.io.tmpdir") + File.separator + "uploads");
        LOG.info("Using file upload directory: {}", (Object)UPLOAD_DIRECTORY);
        if (this.objectName == null) {
            this.objectName = this.getObjectName();
        }
        if (this.mBeanServer == null) {
            this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        if (this.mBeanServer != null) {
            try {
                this.mBeanServer.registerMBean(this, this.objectName);
            }
            catch (InstanceAlreadyExistsException iaee) {
                this.mBeanServer.unregisterMBean(this.objectName);
                this.mBeanServer.registerMBean(this, this.objectName);
            }
        }
    }

    public void destroy() throws Exception {
        if (this.mBeanServer != null && this.objectName != null) {
            this.mBeanServer.unregisterMBean(this.objectName);
        }
    }

    protected ObjectName getObjectName() throws Exception {
        return new ObjectName("hawtio:type=UploadManager");
    }

    public String getUploadDirectory() {
        return UPLOAD_DIRECTORY;
    }

    public void setUploadDirectory(String directory) {
        UPLOAD_DIRECTORY = directory;
    }

    public List<FileDTO> list(String parent) {
        File dir = new File(this.getTargetDirectory(parent));
        if (!dir.exists()) {
            return null;
        }
        ArrayList<FileDTO> rc = new ArrayList<FileDTO>();
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) continue;
            rc.add(new FileDTO(file));
        }
        return rc;
    }

    private String getTargetDirectory(String parent) {
        if (Strings.isNotBlank((String)(parent = Strings.sanitizeDirectory((String)parent)))) {
            return UPLOAD_DIRECTORY + File.separator + parent;
        }
        return UPLOAD_DIRECTORY;
    }

    public boolean delete(String parent, String filename) {
        filename = Strings.sanitize((String)filename);
        File targetFile = new File(this.getTargetDirectory(parent), filename);
        LOG.info("Deleting {}", (Object)targetFile);
        return targetFile.delete();
    }
}

