/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web;

import io.hawt.system.Authenticator;
import io.hawt.system.ConfigManager;
import io.hawt.system.Helpers;
import io.hawt.system.PrivilegedCallback;
import io.hawt.web.AuthenticationConfiguration;
import io.hawt.web.AuthenticationContainerDiscovery;
import io.hawt.web.AuthenticationFilter;
import io.hawt.web.tomcat.TomcatAuthenticationContainerDiscovery;
import java.io.IOException;
import java.security.PrivilegedActionException;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class AuthenticationFilter
implements Filter {
    private static final transient Logger LOG = LoggerFactory.getLogger(AuthenticationFilter.class);
    public static final String HAWTIO_AUTHENTICATION_ENABLED = "hawtio.authenticationEnabled";
    public static final String HAWTIO_REALM = "hawtio.realm";
    public static final String HAWTIO_ROLE = "hawtio.role";
    public static final String HAWTIO_ROLE_PRINCIPAL_CLASSES = "hawtio.rolePrincipalClasses";
    private final AuthenticationConfiguration configuration = new AuthenticationConfiguration();
    private final AuthenticationContainerDiscovery[] discoveries = new AuthenticationContainerDiscovery[]{new TomcatAuthenticationContainerDiscovery()};

    public void init(FilterConfig filterConfig) throws ServletException {
        ConfigManager config = (ConfigManager)filterConfig.getServletContext().getAttribute("ConfigManager");
        if (config != null) {
            this.configuration.setRealm(config.get("realm", "karaf"));
            this.configuration.setRole(config.get("role", "admin"));
            this.configuration.setRolePrincipalClasses(config.get("rolePrincipalClasses", ""));
            this.configuration.setEnabled(Boolean.parseBoolean(config.get("authenticationEnabled", "true")));
        }
        if (System.getProperty("hawtio.authenticationEnabled") != null) {
            this.configuration.setEnabled(Boolean.getBoolean("hawtio.authenticationEnabled"));
        }
        if (System.getProperty("hawtio.realm") != null) {
            this.configuration.setRealm(System.getProperty("hawtio.realm"));
        }
        if (System.getProperty("hawtio.role") != null) {
            this.configuration.setRole(System.getProperty("hawtio.role"));
        }
        if (System.getProperty("hawtio.rolePrincipalClasses") != null) {
            this.configuration.setRolePrincipalClasses(System.getProperty("hawtio.rolePrincipalClasses"));
        }
        if (this.configuration.isEnabled()) {
            for (AuthenticationContainerDiscovery discovery : this.discoveries) {
                if (!discovery.canAuthenticate(this.configuration)) continue;
                LOG.info("Discovered container {} to use with hawtio authentication filter", (Object)discovery.getContainerName());
                break;
            }
        }
        if (this.configuration.isEnabled()) {
            LOG.info("Starting hawtio authentication filter, JAAS realm: \"{}\" authorized role: \"{}\" role principal classes: \"{}\"", new Object[]{this.configuration.getRealm(), this.configuration.getRole(), this.configuration.getRolePrincipalClasses()});
        } else {
            LOG.info("Starting hawtio authentication filter, JAAS authentication disabled");
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean doAuthenticate;
        Subject subject;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String path = httpRequest.getServletPath();
        LOG.debug("Handling request for path {}", (Object)path);
        if (this.configuration.getRealm() == null || this.configuration.getRealm().equals("") || !this.configuration.isEnabled()) {
            LOG.debug("No authentication needed for path {}", (Object)path);
            chain.doFilter(request, response);
            return;
        }
        HttpSession session = httpRequest.getSession(false);
        if (session != null && (subject = (Subject)session.getAttribute("subject")) != null) {
            LOG.debug("Session subject {}", (Object)subject);
            AuthenticationFilter.executeAs((ServletRequest)request, (ServletResponse)response, (FilterChain)chain, (Subject)subject);
            return;
        }
        boolean bl = doAuthenticate = path.startsWith("/auth") || path.startsWith("/jolokia") || path.startsWith("/upload");
        if (doAuthenticate) {
            LOG.debug("Doing authentication and authorization for path {}", (Object)path);
            switch (3.$SwitchMap$io$hawt$system$AuthenticateResult[Authenticator.authenticate((String)this.configuration.getRealm(), (String)this.configuration.getRole(), (String)this.configuration.getRolePrincipalClasses(), (Configuration)this.configuration.getConfiguration(), (HttpServletRequest)httpRequest, (PrivilegedCallback)new /* Unavailable Anonymous Inner Class!! */).ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    Helpers.doForbidden((HttpServletResponse)((HttpServletResponse)response));
                    break;
                }
                case 3: {
                    Helpers.doForbidden((HttpServletResponse)((HttpServletResponse)response));
                }
            }
        } else {
            LOG.debug("No authentication needed for path {}", (Object)path);
            chain.doFilter(request, response);
        }
    }

    private static void executeAs(ServletRequest request, ServletResponse response, FilterChain chain, Subject subject) {
        try {
            Subject.doAs(subject, new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (PrivilegedActionException e) {
            LOG.info("Failed to invoke action " + ((HttpServletRequest)request).getPathInfo() + " due to:", (Throwable)e);
        }
    }

    public void destroy() {
        LOG.info("Destroying hawtio authentication filter");
    }

    static /* synthetic */ void access$000(ServletRequest x0, ServletResponse x1, FilterChain x2, Subject x3) {
        AuthenticationFilter.executeAs((ServletRequest)x0, (ServletResponse)x1, (FilterChain)x2, (Subject)x3);
    }
}

