/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web;

import io.hawt.system.AuthInfo;
import io.hawt.system.Authenticator;
import io.hawt.system.ExtractAuthInfoCallback;
import io.hawt.util.Strings;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyDetails {
    private static final transient Logger LOG = LoggerFactory.getLogger(ProxyDetails.class);
    private String stringProxyURL;
    private String hostAndPort;
    private String path = "";
    private String userName;
    private String password;
    private String host;
    private int port = 80;
    public static final String USER_PARAM = "_user";
    public static final String PWD_PARAM = "_pwd";
    private static Set<String> ignoreHeaderNames = new HashSet<String>(Arrays.asList("_user", "_pwd", "_url", "url"));

    public ProxyDetails(HttpServletRequest httpServletRequest) {
        this(httpServletRequest.getPathInfo());
        String authHeader = httpServletRequest.getHeader("Authorization");
        if (authHeader != null && !authHeader.equals("")) {
            AuthInfo info = new AuthInfo();
            Authenticator.extractAuthInfo((String)authHeader, (ExtractAuthInfoCallback)new /* Unavailable Anonymous Inner Class!! */);
            this.userName = info.username;
            this.password = info.password;
        }
        Enumeration iter = httpServletRequest.getParameterNames();
        while (iter.hasMoreElements()) {
            String[] values;
            String name;
            Object next = iter.nextElement();
            if (!(next instanceof String) || ignoreHeaderNames.contains(name = next.toString())) continue;
            for (String value : values = httpServletRequest.getParameterValues(name)) {
                String prefix = "?";
                if (this.stringProxyURL.contains("?")) {
                    prefix = "&";
                }
                this.stringProxyURL = this.stringProxyURL + prefix + name + "=" + value;
            }
        }
    }

    public ProxyDetails(String pathInfo) {
        this.hostAndPort = pathInfo;
        while (this.hostAndPort.startsWith("/")) {
            this.hostAndPort = this.hostAndPort.substring(1);
        }
        int idx = this.hostAndPort.indexOf("@");
        if (idx > 0) {
            this.userName = this.hostAndPort.substring(0, idx);
            this.hostAndPort = this.hostAndPort.substring(idx + 1);
            idx = this.indexOf(this.userName, new String[]{":", "/"});
            if (idx > 0) {
                this.password = this.userName.substring(idx + 1);
                this.userName = this.userName.substring(0, idx);
            }
        }
        this.host = this.hostAndPort;
        idx = this.indexOf(this.hostAndPort, new String[]{":", "/"});
        if (idx > 0) {
            this.host = this.hostAndPort.substring(0, idx);
            String portText = this.hostAndPort.substring(idx + 1);
            if ((idx = portText.indexOf("/")) >= 0) {
                this.path = portText.substring(idx);
                portText = portText.substring(0, idx);
            }
            if (Strings.isNotBlank((String)portText)) {
                this.port = Integer.parseInt(portText);
                this.hostAndPort = this.host + ":" + this.port;
            } else {
                this.hostAndPort = this.host;
            }
        }
        this.stringProxyURL = "http://" + this.hostAndPort + this.path;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Proxying to " + this.stringProxyURL + " as user: " + this.userName);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    protected int indexOf(String text, String ... values) {
        int answer = -1;
        for (String value : values) {
            int idx = text.indexOf(value);
            if (idx < 0 || answer >= 0 && idx >= answer) continue;
            answer = idx;
        }
        return answer;
    }

    public HttpClient createHttpClient(HttpMethod httpMethodProxyRequest) {
        HttpClient client = new HttpClient();
        if (this.userName != null) {
            httpMethodProxyRequest.setDoAuthentication(true);
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(this.userName, this.password);
            client.getState().setCredentials(new AuthScope(this.host, this.port, AuthScope.ANY_REALM), (Credentials)defaultcreds);
        }
        return client;
    }

    public String getStringProxyURL() {
        return this.stringProxyURL;
    }

    public String getProxyHostAndPort() {
        return this.hostAndPort;
    }

    public String getProxyPath() {
        return this.path;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHostAndPort() {
        return this.hostAndPort;
    }

    public String getPath() {
        return this.path;
    }
}

