var SpringBatch;
(function (SpringBatch) {
    function NavBarController($scope, $routeParams, $location, workspace) {
        var subLevelTabs = [
            { uri: 'servers', name: 'Servers List' },
            { uri: 'jobs/executions', name: 'Jobs Execution List' },
            { uri: 'connect', name: 'Connect' }
        ];

        $scope.subLevelTabs = subLevelTabs;

        $scope.isActive = function (tab) {
            return ('/springbatch/' + tab.uri === $location.path());
        };
    }
    SpringBatch.NavBarController = NavBarController;
})(SpringBatch || (SpringBatch = {}));
var SpringBatch;
(function (SpringBatch) {
    function JobOverviewExecListController($scope, $routeParams, $location, workspace, jolokia, $resource, $rootScope, $http) {
        var springBatchServerOrigin = $rootScope.springBatchServer;
        var springBatchServerPath = springBatchServerOrigin + 'jobs/:jobName';
        var proxyUrl = $rootScope.proxyUrl;
        var executionsListPath = '/:jobInstanceId/executions.json';
        var paramsListPath = 'jobs/:jobName/:jobInstanceId';
        var jobName = $routeParams.jobName;
        $scope.jobName = $routeParams.jobName;
        var jobInstances = null;
        var jobList = $resource(proxyUrl + springBatchServerPath);
        $scope.springBatchServer = encodeURIComponent(springBatchServerOrigin);

        $scope.executionPredicate = 'name';
        $scope.executionReverse = false;
        $scope.stepPredicate = 'name';
        $scope.stepReverse = false;

        $scope.fetchAllExecutions = function (jobInstance) {
            if (jobInstance != undefined) {
                var jobList = $resource(proxyUrl + springBatchServerPath + executionsListPath);
                jobList.get({ 'jobName': jobName, jobInstanceId: jobInstance.id }, function (data) {
                    var jobExecutionList = new Array();
                    for (var execution in data.jobInstance.jobExecutions) {
                        data.jobInstance.jobExecutions[execution].id = execution;
                        jobExecutionList.add(data.jobInstance.jobExecutions[execution]);
                    }
                    $scope.jobName = jobName;
                    $scope.jobExecutionList = jobExecutionList;
                });
            }
        };

        $scope.fetchParams = function (jobName, jobInstanceId, executionId) {
            var paramsResource = $resource(proxyUrl + springBatchServerPath + paramsListPath);
            paramsResource.get({ 'jobName': jobName, 'jobInstanceId': jobInstanceId + '.json' }, function (data) {
                var jobParams = new Array();
                if (executionId) {
                    for (var param in data.jobInstance.jobExecutions[executionId].jobParameters) {
                        jobParams.add({ 'name': param, 'value': data.jobInstance.jobExecutions[executionId].jobParameters[param] });
                    }
                } else {
                    for (var execution in data.jobInstance.jobExecutions) {
                        for (var param in data.jobInstance.jobExecutions[execution].jobParameters) {
                            jobParams.add({ 'name': param, 'value': data.jobInstance.jobExecutions[execution].jobParameters[param] });
                        }
                        break;
                    }
                    $scope.jobParams = jobParams;
                }
            });
        };

        $scope.removeParam = function (jobParams, index) {
            jobParams.splice(index, 1);
        };

        $scope.addParam = function (jobParams, index) {
            jobParams.add({ name: '', value: '' });
        };

        $scope.runJob = function (jobName, jobParams) {
            if (jobName && jobParams) {
                var springServerOrigin = springBatchServerOrigin.replace('\\', '');
                var postUrl = proxyUrl + springServerOrigin + 'jobs/' + jobName + '.json';
                $http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded";
                var params = '';
                for (var param in jobParams) {
                    params = params + jobParams[param].name + '=' + jobParams[param].value;
                    if ((param + 1) != jobParams.length) {
                        params = params + ',';
                    }
                }
                params = encodeURIComponent(params);
                $http.post(postUrl, 'jobParameters=' + params).success(function (data) {
                    if (data.jobExecution) {
                        $rootScope.alert.content = 'Job started successfully.';
                        $rootScope.alert.type = 'alert-success';
                        $rootScope.alert.show();
                    } else if (data.errors) {
                        $rootScope.alert.content = '';
                        for (var message in data.errors) {
                            $rootScope.alert.content += data.errors[message] + '\n';
                            $rootScope.alert.type = 'alert-error';
                            $rootScope.alert.show();
                        }
                    }
                }).error(function (data) {
                    $rootScope.alert.content = 'Count not start the job';
                    $rootScope.alert.type = 'alert-error';
                    $rootScope.alert.show();
                });
            }
        };

        jobList.get({ 'jobName': jobName + '.json' }, function (data) {
            for (var job in data.job.jobInstances) {
                data.job.jobInstances[job].id = job;
                jobInstances = data.job.jobInstances;
            }
            if ($routeParams.jobInstanceId == undefined) {
                for (var job in data.job.jobInstances) {
                    $scope.jobInstance = jobInstances[job];
                    break;
                }
            } else {
                if (jobInstances && jobInstances[$routeParams.jobInstanceId]) {
                    $scope.jobInstance = jobInstances[$routeParams.jobInstanceId];
                }
            }
            if ($scope.jobInstance) {
                $scope.fetchAllExecutions($scope.jobInstance);
                $scope.fetchParams(jobName, $scope.jobInstance.id);
            } else {
                $scope.jobParams = new Array();
            }
        });

        $scope.refreshJobInstance = function (jobInstance) {
            var jobList = $resource(proxyUrl + springBatchServerPath);
            jobList.get({ 'jobName': jobName + '.json' }, function (data) {
                for (var job in data.job.jobInstances) {
                    data.job.jobInstances[job].id = job;
                }
                var jobInstanceId = null;
                if (jobInstance && jobInstance.id) {
                    jobInstanceId = jobInstance.id;
                    $scope.jobInstance = data.job.jobInstances[jobInstanceId];
                    $scope.fetchAllExecutions(data.job.jobInstances[jobInstanceId]);
                    $scope.fetchParams(jobName, jobInstanceId);
                } else {
                    for (var job in data.job.jobInstances) {
                        $scope.jobInstance = data.job.jobInstances[job];
                        $scope.fetchAllExecutions(data.job.jobInstances[job]);
                        $scope.fetchParams(jobName, job);
                        break;
                    }
                }
                $scope.stepExecutionList = null;
            });
        };
        $scope.fetchNextJobInstance = function (jobInstance) {
            var tempId = null;
            var jobList = $resource(proxyUrl + springBatchServerPath);
            jobList.get({ 'jobName': jobName + '.json' }, function (data) {
                for (var job in data.job.jobInstances) {
                    data.job.jobInstances[job].id = job;
                    if (jobInstance && jobInstance.id && (parseInt(job) > parseInt(jobInstance.id))) {
                        tempId = job;
                        break;
                    } else if (jobInstance && jobInstance.id) {
                        tempId = jobInstance.id;
                    }
                }
                if (jobInstance) {
                    $scope.jobInstance = data.job.jobInstances[tempId];
                } else {
                    for (var job in data.job.jobInstances) {
                        $scope.jobInstance = data.job.jobInstances[job];
                        break;
                    }
                }
                if ($scope.jobInstance) {
                    $scope.fetchAllExecutions($scope.jobInstance);
                    $scope.fetchParams(jobName, $scope.jobInstance.id);
                }

                $scope.stepExecutionList = null;
            });
        };
        $scope.fetchPrevJobInstance = function (jobInstance) {
            var tempId = null;
            var jobList = $resource(proxyUrl + springBatchServerPath);
            jobList.get({ 'jobName': jobName + '.json' }, function (data) {
                for (var job in data.job.jobInstances) {
                    data.job.jobInstances[job].id = job;
                    if (jobInstance && jobInstance.id && (parseInt(job) < parseInt(jobInstance.id))) {
                        tempId = job;
                    }
                }
                if (jobInstance) {
                    if ((tempId == null) && jobInstance.id) {
                        tempId = jobInstance.id;
                    }
                    $scope.jobInstance = data.job.jobInstances[tempId];
                } else {
                    for (var job in data.job.jobInstances) {
                        $scope.jobInstance = data.job.jobInstances[job];
                        break;
                    }
                }
                if ($scope.jobInstance) {
                    $scope.fetchAllExecutions($scope.jobInstance);
                    $scope.fetchParams(jobName, $scope.jobInstance.id);
                }
                $scope.stepExecutionList = null;
            });
        };

        $scope.fetchStepsForExecution = function (executionId) {
            var jobList = $resource(proxyUrl + springBatchServerOrigin + 'jobs/executions/:executionId');
            jobList.get({ 'executionId': executionId + '.json' }, function (data) {
                var stepList = new Array();
                for (var execution in data.jobExecution.stepExecutions) {
                    data.jobExecution.stepExecutions[execution].name = execution;
                    stepList.add(data.jobExecution.stepExecutions[execution]);
                }
                $scope.executionId = executionId;
                $scope.stepExecutionList = stepList;
            });
        };
    }
    SpringBatch.JobOverviewExecListController = JobOverviewExecListController;
})(SpringBatch || (SpringBatch = {}));
var SpringBatch;
(function (SpringBatch) {
    SpringBatch.templatePath = 'app/springbatch/html/';
    SpringBatch.pluginName = 'SpringBatch';

    angular.module(SpringBatch.pluginName, ['bootstrap', 'ngResource', 'hawtioCore', 'hawtio-ui']).config(function ($routeProvider) {
        $routeProvider.when('/springbatch/servers', { templateUrl: SpringBatch.templatePath + 'serverList.html' }).when('/springbatch/jobs', { templateUrl: SpringBatch.templatePath + 'jobs.html' }).when('/springbatch/jobs/:jobName/executions', { templateUrl: SpringBatch.templatePath + 'overview.html' }).when('/springbatch/jobs/:jobName/executions/:jobInstanceId', { templateUrl: SpringBatch.templatePath + 'overview.html' }).when('/springbatch/jobs/executions', { templateUrl: SpringBatch.templatePath + 'jobsExecutionList.html' }).when('/springbatch/connect', { templateUrl: SpringBatch.templatePath + 'connectSpringBatch.html' }).when('/springbatch/jobs/:jobId/executions/:jobName/:jobExecutionId', { templateUrl: SpringBatch.templatePath + 'jobExecutionContext.html' }).when('/springbatch/jobs/:jobName/:jobId/history/executions', { templateUrl: SpringBatch.templatePath + 'executionHistory.html' }).when('/springbatch/jobs/:jobId/executions/:jobName/:jobExecutionId/steps/:stepExecutionId', { templateUrl: SpringBatch.templatePath + 'stepExecutionContext.html' }).when('/springbatch/jobs/:host/:port/:serverSuffix', { templateUrl: SpringBatch.templatePath + 'jobs.html' }).when('/springbatch/jobs/:host/:port', { templateUrl: SpringBatch.templatePath + 'jobs.html' });
    }).value('ui.config', {
        // The ui-jq directive namespace
        jq: {
            gridster: {
                widget_margins: [10, 10],
                widget_base_dimensions: [140, 140]
            }
        }
    }).run(function ($location, workspace, viewRegistry, $rootScope, $resource) {
        viewRegistry['springbatch'] = 'app/springbatch/html/layoutSpringBatch.html';

        workspace.topLevelTabs.push({
            id: "springbatch",
            content: "SpringBatch",
            title: "View Spring-Batch jobs",
            // TODO: Need a way to figure out if spring batch is in the JVM
            isValid: function (workspace) {
                return false;
            },
            href: function () {
                return "#/springbatch/servers";
            },
            isActive: function (workspace) {
                return workspace.isTopTabActive("springbatch");
            }
        });

        // TODO: server list should not be hardcoded
        var serverListRes = $resource('/hawtio/springBatch');
        serverListRes.get(function (data) {
            $rootScope.springBatchServerList = data.springBatchServerList || [
                'localhost\\:8080/spring-batch-admin-sample/',
                'localhost\\:8181/'
            ];
            //                $rootScope.springBatchServer = $rootScope.springBatchServerList[0];
        });

        $rootScope.proxyUrl = '/hawtio/proxy/';

        $rootScope.alert = {
            enable: false,
            content: '',
            type: '',
            hide: function () {
                this.enable = false;
            },
            show: function () {
                this.enable = true;
            }
        };
    });

    hawtioPluginLoader.addModule(SpringBatch.pluginName);
})(SpringBatch || (SpringBatch = {}));
var SpringBatch;
(function (SpringBatch) {
    function getHost(link) {
        var endIdx;
        if (link.indexOf('\\') >= 0)
            endIdx = link.indexOf('\\');
        else
            endIdx = link.indexOf(':');
        return link.substring(0, endIdx);
    }
    SpringBatch.getHost = getHost;

    function getPort(link) {
        return link.substring(link.indexOf(':') + 1, link.indexOf('/'));
    }
    SpringBatch.getPort = getPort;

    function getServerSuffix(link) {
        if (link.indexOf('/') != link.lastIndexOf('/'))
            return link.substring(link.indexOf('/') + 1, link.lastIndexOf('/'));
        else
            return '';
    }
    SpringBatch.getServerSuffix = getServerSuffix;

    function getServerUrl(host, port, path) {
        var server = '';
        server = host + '\\:' + port;
        if (path) {
            if (path.charAt(0) != '/')
                server = server + '/' + path;
            else
                server = server + path;
        }
        if (server.charAt(server.length - 1) != '/') {
            server = server + '/';
        }
        return server;
    }
    SpringBatch.getServerUrl = getServerUrl;
})(SpringBatch || (SpringBatch = {}));
var SpringBatch;
(function (SpringBatch) {
    function SpringBatchJobExecutionListController($scope, $resource, $rootScope) {
        var springBatchServerOrigin = $rootScope.springBatchServer;
        if (springBatchServerOrigin == undefined) {
            $rootScope.alert.content = 'No Server selected. Please, use Connect or Server List screen to select one.';
            $rootScope.alert.type = 'alert-error';
            $rootScope.alert.show();
            return;
        }
        var springBatchServerPath = springBatchServerOrigin + 'jobs';
        var proxyUrl = $rootScope.proxyUrl;
        var executionsListPath = '/executions.json';

        $scope.predicate = 'name';
        $scope.reverse = false;

        var executionListRes = $resource(proxyUrl + springBatchServerPath + executionsListPath);
        executionListRes.get(function (data) {
            var executionList = new Array();
            for (var execution in data.jobExecutions) {
                data.jobExecutions[execution].id = execution;
                executionList.add(data.jobExecutions[execution]);
            }
            $scope.jobExecutions = executionList;
        });
    }
    SpringBatch.SpringBatchJobExecutionListController = SpringBatchJobExecutionListController;
})(SpringBatch || (SpringBatch = {}));
var SpringBatch;
(function (SpringBatch) {
    function ServerListController($scope, $location, workspace, jolokia, $resource, $rootScope, $http) {
        var serverList = [];
        var serverHref = '';
        for (var server in $rootScope.springBatchServerList) {
            serverHref += '#/springbatch/jobs/';
            serverHref += SpringBatch.getHost($rootScope.springBatchServerList[server]) + '/';
            serverHref += SpringBatch.getPort($rootScope.springBatchServerList[server]);
            if (SpringBatch.getServerSuffix($rootScope.springBatchServerList[server]).length > 0)
                serverHref += '/' + SpringBatch.getServerSuffix($rootScope.springBatchServerList[server]);
            serverList.add({
                href: serverHref,
                hostname: SpringBatch.getHost($rootScope.springBatchServerList[server]),
                port: SpringBatch.getPort($rootScope.springBatchServerList[server])
            });
            serverHref = '';
        }
        $scope.serverList = serverList;
    }
    SpringBatch.ServerListController = ServerListController;
})(SpringBatch || (SpringBatch = {}));
var SpringBatch;
(function (SpringBatch) {
    function ConnectSpringBatchController($scope, $routeParams, $location, workspace, $rootScope, $resource, $http) {
        $scope.host = 'localhost';
        $scope.port = 8080;

        $scope.connectSpringBatch = function () {
            if ($scope.selectedSpringBatchServer) {
                $rootScope.springBatchServer = $scope.selectedSpringBatchServer;
                $rootScope.alert.content = 'Connected successfully.';
                $rootScope.alert.type = 'alert-success';
                $rootScope.alert.show();
            }
        };

        $scope.addSpringBatchServerToGlobalList = function () {
            var server = SpringBatch.getServerUrl($scope.host, $scope.port, $scope.path);
            if ($rootScope.springBatchServerList.indexOf($scope.selectedSpringBatchServer) > 0) {
                $rootScope.alert.content = 'Server already in the list.';
                $rootScope.alert.type = 'alert-error';
                $rootScope.alert.show();
                return;
            }
            $http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded";
            $http.post('/hawtio/springBatch', 'server=' + server).success(function (data) {
                $rootScope.springBatchServerList.add(server);
                $rootScope.springBatchServer = $scope.selectedSpringBatchServer;
                $rootScope.alert.content = 'Server added.';
                $rootScope.alert.type = 'alert-success';
                $rootScope.alert.show();
            }).error(function (data) {
                $rootScope.alert.content = 'Could not add server.';
                $rootScope.alert.type = 'alert-error';
                $rootScope.alert.show();
            });
        };

        $scope.removeServer = function (index) {
            $http.delete('/hawtio/springBatch?server=' + encodeURIComponent($scope.selectedSpringBatchServer)).success(function (data) {
                $scope.springBatchServerList.splice($scope.springBatchServerList.indexOf($scope.selectedSpringBatchServer), 1);
                $rootScope.alert.content = 'Server deleted.';
                $rootScope.alert.type = 'alert-info';
                $rootScope.alert.show();
            }).error(function (data) {
                $rootScope.alert.content = 'Could not delete server.';
                $rootScope.alert.type = 'alert-error';
                $rootScope.alert.show();
            });
        };

        $scope.editServer = function () {
            $scope.host = SpringBatch.getHost($scope.selectedSpringBatchServer);
            $scope.port = parseInt(SpringBatch.getPort($scope.selectedSpringBatchServer));
            $scope.path = SpringBatch.getServerSuffix($scope.selectedSpringBatchServer);
        };

        $scope.updateServer = function () {
            var server = SpringBatch.getServerUrl($scope.host, $scope.port, $scope.path);
            var replaceServer = $scope.selectedSpringBatchServer;
            $http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded";
            $http.post('/hawtio/springBatch', 'server=' + server + '&replaceServer=' + replaceServer).success(function (data) {
                $rootScope.springBatchServerList[$rootScope.springBatchServerList.indexOf($scope.selectedSpringBatchServer)] = server;
                $rootScope.alert.content = 'Server updated.';
                $rootScope.alert.type = 'alert-success';
                $rootScope.alert.show();
            }).error(function (data) {
                $rootScope.alert.content = 'Could not add server.';
                $rootScope.alert.type = 'alert-error';
                $rootScope.alert.show();
            });
        };
    }
    SpringBatch.ConnectSpringBatchController = ConnectSpringBatchController;
})(SpringBatch || (SpringBatch = {}));
var SpringBatch;
(function (SpringBatch) {
    function ExecutionHistoryController($scope, $routeParams, $location, workspace, $resource, $rootScope) {
        var springBatchServerOrigin = $rootScope.springBatchServer;
        var proxyUrl = '/hawtio/proxy/';
        var executionHistoryPath = 'jobs/:jobName/executions.json';
        $scope.predicate = 'id';
        $scope.reverse = false;

        var jobExecutionRes = $resource(proxyUrl + springBatchServerOrigin + executionHistoryPath);
        jobExecutionRes.get({ 'jobName': $routeParams.jobName }, function (data) {
            var executionList = new Array();
            for (var execution in data.jobExecutions) {
                data.jobExecutions[execution].id = execution;
                executionList.add(data.jobExecutions[execution]);
            }
            $scope.executionHistory = executionList;
            $scope.jobName = $routeParams.jobName;
            $scope.jobId = $routeParams.jobId;
        });
    }
    SpringBatch.ExecutionHistoryController = ExecutionHistoryController;
})(SpringBatch || (SpringBatch = {}));
var SpringBatch;
(function (SpringBatch) {
    function jobExecutionContextController($scope, $routeParams, $http, $rootScope) {
        var springBatchServerOrigin = $rootScope.springBatchServer;
        var proxyUrl = '/hawtio';
        var jobExecutionId = $routeParams.jobExecutionId;
        var jobName = $routeParams.jobName;
        var jobId = $routeParams.jobId;
        $scope.springBatchServer = springBatchServerOrigin;
        var jobExecutionContext = $http.get(proxyUrl + "/contextFormatter?jobExecutionId=" + jobExecutionId + "&server=" + springBatchServerOrigin + "&contextType=jobExecution").success(function (data) {
            $scope.htmlView = data;
        });
        $scope.jobId = jobId;
        $scope.jobName = jobName;
    }
    SpringBatch.jobExecutionContextController = jobExecutionContextController;
})(SpringBatch || (SpringBatch = {}));
var SpringBatch;
(function (SpringBatch) {
    function JobListController($scope, $location, workspace, jolokia, $resource, $rootScope, $http, $routeParams) {
        var targetServerHost = $routeParams.host;
        var targetServerPort = $routeParams.port;
        var targetServerSuffix = $routeParams.serverSuffix;

        var targetServer = targetServerHost + '\\:' + targetServerPort + '/';
        if ((targetServerSuffix != undefined) && (targetServerSuffix.length > 0))
            targetServer += (targetServerSuffix + '/');
        $rootScope.springBatchServer = targetServer;

        var springBatchServerPath = $rootScope.springBatchServer + 'jobs.json';
        var proxyUrl = $rootScope.proxyUrl;

        $scope.predicate = 'name';
        $scope.reverse = false;

        $scope.getJobList = function () {
            var jobList = $resource(proxyUrl + springBatchServerPath);
            jobList.get(function (data) {
                if (data.jobs && data.jobs.registrations) {
                    var jobList = new Array();
                    for (var job in data.jobs.registrations) {
                        data.jobs.registrations[job].showLaunchForm = false;
                        data.jobs.registrations[job].launchParams = '';
                        jobList.add(data.jobs.registrations[job]);
                    }
                    $scope.jobList = jobList;
                }
            });
        };

        $scope.getJobList();

        $scope.launchJob = function (jobName) {
            var job;
            for (var idx in $scope.jobList) {
                if ($scope.jobList[idx].name == jobName)
                    job = $scope.jobList[idx];
            }
            var params = job.launchParams;

            if (jobName && params) {
                var springServerOrigin = $rootScope.springBatchServer.replace('\\', '');
                var postUrl = proxyUrl + springServerOrigin + 'jobs/' + jobName + '.json';
                $http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded";
                params = encodeURIComponent(params);
                $http.post(postUrl, 'jobParameters=' + params).success(function (data) {
                    if (data.jobExecution) {
                        $rootScope.alert.content = 'Job started successfully.';
                        $rootScope.alert.type = 'alert-success';
                        $rootScope.alert.show();
                        $scope.getJobList();
                    } else if (data.errors) {
                        $rootScope.alert.content = '';
                        for (var message in data.errors) {
                            $rootScope.alert.content += data.errors[message] + '\n';
                            $rootScope.alert.type = 'alert-error';
                            $rootScope.alert.show();
                        }
                    }
                }).error(function (data) {
                    $rootScope.alert.content = 'Count not start the job';
                    $rootScope.alert.type = 'alert-error';
                    $rootScope.alert.show();
                });
            }
        };
    }
    SpringBatch.JobListController = JobListController;
})(SpringBatch || (SpringBatch = {}));
var SpringBatch;
(function (SpringBatch) {
    function stepExecutionContextController($scope, $routeParams, $http, $rootScope) {
        var springBatchServerOrigin = $rootScope.springBatchServer;
        var proxyUrl = '/hawtio';
        var jobExecutionId = $routeParams.jobExecutionId;
        var stepExecutionId = $routeParams.stepExecutionId;
        var jobName = $routeParams.jobName;

        var jobId = $routeParams.jobId;
        $scope.springBatchServer = springBatchServerOrigin;
        var stepExecutionContext = $http.get(proxyUrl + "/contextFormatter?jobExecutionId=" + jobExecutionId + "&stepExecutionId=" + stepExecutionId + "&server=" + springBatchServerOrigin + "&contextType=stepExecution").success(function (data) {
            $scope.htmlView = data;
        });
        $scope.jobName = jobName;
        $scope.jobId = jobId;
    }
    SpringBatch.stepExecutionContextController = stepExecutionContextController;
})(SpringBatch || (SpringBatch = {}));
var ForceGraph;
(function (ForceGraph) {
    /**
    * GraphBuilder
    *
    * @class GraphBuilder
    */
    var GraphBuilder = (function () {
        function GraphBuilder() {
            this.nodes = {};
            this.links = [];
            this.linkTypes = {};
        }
        /**
        * Adds a node to this graph
        * @method addNode
        * @param {Object} node
        */
        GraphBuilder.prototype.addNode = function (node) {
            if (!this.nodes[node.id]) {
                this.nodes[node.id] = node;
            }
        };

        GraphBuilder.prototype.getNode = function (id) {
            return this.nodes[id];
        };

        GraphBuilder.prototype.hasLinks = function (id) {
            var _this = this;
            var result = false;

            this.links.forEach(function (link) {
                if (link.source.id == id || link.target.id == id) {
                    result = result || (_this.nodes[link.source.id] != null && _this.nodes[link.target.id] != null);
                }
            });
            return result;
        };

        GraphBuilder.prototype.addLink = function (srcId, targetId, linkType) {
            if ((this.nodes[srcId] != null) && (this.nodes[targetId] != null)) {
                this.links.push({
                    source: this.nodes[srcId],
                    target: this.nodes[targetId],
                    type: linkType
                });

                if (!this.linkTypes[linkType]) {
                    this.linkTypes[linkType] = {
                        used: true
                    };
                }
                ;
            }
        };

        GraphBuilder.prototype.nodeIndex = function (id, nodes) {
            var result = -1;
            var index = 0;

            for (index = 0; index < nodes.length; index++) {
                var node = nodes[index];
                if (node.id == id) {
                    result = index;
                    break;
                }
            }

            return result;
        };

        GraphBuilder.prototype.filterNodes = function (filter) {
            var filteredNodes = {};
            var newLinks = [];

            d3.values(this.nodes).forEach(function (node) {
                if (filter(node)) {
                    filteredNodes[node.id] = node;
                }
            });

            this.links.forEach(function (link) {
                if (filteredNodes[link.source.id] && filteredNodes[link.target.id]) {
                    newLinks.push(link);
                }
            });

            this.nodes = filteredNodes;
            this.links = newLinks;
        };

        GraphBuilder.prototype.buildGraph = function () {
            var _this = this;
            var graphNodes = [];
            var linktypes = d3.keys(this.linkTypes);
            var graphLinks = [];

            d3.values(this.nodes).forEach(function (node) {
                if (node.includeInGraph == null || node.includeInGraph) {
                    node.includeInGraph = true;
                    graphNodes.push(node);
                }
            });

            this.links.forEach(function (link) {
                if (_this.nodes[link.source.id] != null && _this.nodes[link.target.id] != null && _this.nodes[link.source.id].includeInGraph && _this.nodes[link.target.id].includeInGraph) {
                    graphLinks.push({
                        source: _this.nodeIndex(link.source.id, graphNodes),
                        target: _this.nodeIndex(link.target.id, graphNodes),
                        type: link.type
                    });
                }
            });

            return {
                nodes: graphNodes,
                links: graphLinks,
                linktypes: linktypes
            };
        };
        return GraphBuilder;
    })();
    ForceGraph.GraphBuilder = GraphBuilder;
})(ForceGraph || (ForceGraph = {}));
var ForceGraph;
(function (ForceGraph) {
    var log = Logger.get("ForceGraph");

    var ForceGraphDirective = (function () {
        function ForceGraphDirective() {
            this.restrict = 'A';
            this.replace = true;
            this.transclude = false;
            this.scope = {
                graph: '=graph',
                nodesize: '@',
                selectedModel: '@',
                linkDistance: '@',
                markerKind: '@',
                charge: '@'
            };
            this.link = function ($scope, $element, $attrs) {
                $scope.trans = [0, 0];
                $scope.scale = 1;

                $scope.$watch('graph', function (oldVal, newVal) {
                    updateGraph();
                });

                $scope.redraw = function () {
                    $scope.trans = d3.event.translate;
                    $scope.scale = d3.event.scale;

                    $scope.viewport.attr("transform", "translate(" + $scope.trans + ")" + " scale(" + $scope.scale + ")");
                };

                // This is a callback for the animation
                $scope.tick = function () {
                    // provide curvy lines as curves are kind of hawt
                    $scope.graphEdges.attr("d", function (d) {
                        var dx = d.target.x - d.source.x, dy = d.target.y - d.source.y, dr = Math.sqrt(dx * dx + dy * dy);
                        return "M" + d.source.x + "," + d.source.y + "A" + dr + "," + dr + " 0 0,1 " + d.target.x + "," + d.target.y;
                    });

                    // apply the translates coming from the layouter
                    $scope.graphNodes.attr("transform", function (d) {
                        return "translate(" + d.x + "," + d.y + ")";
                    });

                    $scope.graphLabels.attr("transform", function (d) {
                        return "translate(" + d.x + "," + d.y + ")";
                    });
                };

                $scope.mover = function (d) {
                    if (d.popup != null) {
                        $("#pop-up").fadeOut(100, function () {
                            // Popup content
                            if (d.popup.title != null) {
                                $("#pop-up-title").html(d.popup.title);
                            } else {
                                $("#pop-up-title").html("");
                            }

                            if (d.popup.content != null) {
                                $("#pop-up-content").html(d.popup.content);
                            } else {
                                $("#pop-up-content").html("");
                            }

                            // Popup position
                            var popLeft = (d.x * $scope.scale) + $scope.trans[0] + 20;
                            var popTop = (d.y * $scope.scale) + $scope.trans[1] + 20;

                            $("#pop-up").css({ "left": popLeft, "top": popTop });
                            $("#pop-up").fadeIn(100);
                        });
                    }
                };

                $scope.mout = function (d) {
                    $("#pop-up").fadeOut(50);
                    //d3.select(this).attr("fill","url(#ten1)");
                };

                var updateGraph = function () {
                    var canvas = $($element);

                    // TODO: determine the canvas size dynamically
                    var h = $($element).parent().height();
                    var w = $($element).parent().width();
                    var i = 0;

                    canvas.children("svg").remove();

                    // First we create the top level SVG object
                    // TODO maybe pass in the width/height
                    $scope.svg = d3.select(canvas[0]).append("svg").attr("width", w).attr("height", h);

                    // The we add the markers for the arrow tips
                    var linkTypes = null;
                    if ($scope.graph) {
                        linkTypes = $scope.graph.linktypes;
                    }
                    if (!linkTypes) {
                        return;
                    }
                    $scope.svg.append("svg:defs").selectAll("marker").data(linkTypes).enter().append("svg:marker").attr("id", String).attr("viewBox", "0 -5 10 10").attr("refX", 15).attr("refY", -1.5).attr("markerWidth", 6).attr("markerHeight", 6).attr("orient", "auto").append("svg:path").attr("d", "M0,-5L10,0L0,5");

                    // The bounding box can't be zoomed or scaled at all
                    $scope.svg.append("svg:g").append("svg:rect").attr("class", "graphbox.frame").attr('width', w).attr('height', h);

                    $scope.viewport = $scope.svg.append("svg:g").call(d3.behavior.zoom().on("zoom", $scope.redraw)).append("svg:g");

                    $scope.viewport.append("svg:rect").attr("width", 1000000).attr("height", 1000000).attr("class", "graphbox").attr("transform", "translate(-50000, -500000)");

                    // Only do this if we have a graph object
                    if ($scope.graph) {
                        var ownerScope = $scope.$parent || $scope;
                        var selectedModel = $scope.selectedModel || "selectedNode";

                        // kick off the d3 forced graph layout
                        $scope.force = d3.layout.force().nodes($scope.graph.nodes).links($scope.graph.links).size([w, h]).on("tick", $scope.tick);

                        if (angular.isDefined($scope.linkDistance)) {
                            $scope.force.linkDistance($scope.linkDistance);
                        }
                        if (angular.isDefined($scope.charge)) {
                            $scope.force.charge($scope.charge);
                        }
                        var markerTypeName = $scope.markerKind || "marker-end";

                        // Add all edges to the viewport
                        $scope.graphEdges = $scope.viewport.append("svg:g").selectAll("path").data($scope.force.links()).enter().append("svg:path").attr("class", function (d) {
                            return "link " + d.type;
                        }).attr(markerTypeName, function (d) {
                            return "url(#" + d.type + ")";
                        });

                        // add all nodes to the viewport
                        $scope.graphNodes = $scope.viewport.append("svg:g").selectAll("circle").data($scope.force.nodes()).enter().append("a").attr("xlink:href", function (d) {
                            return d.navUrl;
                        }).on("mouseover.onLink", function (d, i) {
                            var sel = d3.select(d3.event.target);
                            sel.classed('selected', true);
                            ownerScope[selectedModel] = d;
                            Core.pathSet(ownerScope, selectedModel, d);
                            Core.$apply(ownerScope);
                        }).on("mouseout.onLink", function (d, i) {
                            var sel = d3.select(d3.event.target);
                            sel.classed('selected', false);
                        });

                        function hasImage(d) {
                            return d.image && d.image.url;
                        }

                        // Add the images if they are set
                        $scope.graphNodes.filter(function (d) {
                            return d.image != null;
                        }).append("image").attr("xlink:href", function (d) {
                            return d.image.url;
                        }).attr("x", function (d) {
                            return -(d.image.width / 2);
                        }).attr("y", function (d) {
                            return -(d.image.height / 2);
                        }).attr("width", function (d) {
                            return d.image.width;
                        }).attr("height", function (d) {
                            return d.image.height;
                        });

                        // if we don't have an image add a circle
                        $scope.graphNodes.filter(function (d) {
                            return !hasImage(d);
                        }).append("circle").attr("class", function (d) {
                            return d.type;
                        }).attr("r", function (d) {
                            return d.size || $scope.nodesize;
                        });

                        // Add the labels to the viewport
                        $scope.graphLabels = $scope.viewport.append("svg:g").selectAll("g").data($scope.force.nodes()).enter().append("svg:g");

                        // A copy of the text with a thick white stroke for legibility.
                        $scope.graphLabels.append("svg:text").attr("x", 8).attr("y", ".31em").attr("class", "shadow").text(function (d) {
                            return d.name;
                        });

                        $scope.graphLabels.append("svg:text").attr("x", 8).attr("y", ".31em").text(function (d) {
                            return d.name;
                        });

                        // animate, then stop
                        $scope.force.start();

                        $scope.graphNodes.call($scope.force.drag).on("mouseover", $scope.mover).on("mouseout", $scope.mout);
                    }
                };
            };
        }
        return ForceGraphDirective;
    })();
    ForceGraph.ForceGraphDirective = ForceGraphDirective;
    ;
})(ForceGraph || (ForceGraph = {}));
/**
* Force Graph plugin & directive
*
* @module ForceGraph
*/
var ForceGraph;
(function (ForceGraph) {
    var pluginName = 'forceGraph';

    angular.module(pluginName, ['bootstrap', 'ngResource']).directive('hawtioForceGraph', function () {
        return new ForceGraph.ForceGraphDirective();
    });

    hawtioPluginLoader.addModule(pluginName);
})(ForceGraph || (ForceGraph = {}));
/**
* @module Health
*/
var Health;
(function (Health) {
    Health.log = Logger.get("Health");

    Health.healthDomains = {
        "org.apache.activemq": "ActiveMQ",
        "org.apache.camel": "Camel",
        "io.fabric8": "Fabric8"
    };

    function hasHealthMBeans(workspace) {
        var beans = getHealthMBeans(workspace);
        if (beans) {
            if (angular.isArray(beans))
                return beans.length >= 1;
            return true;
        }
        return false;
    }
    Health.hasHealthMBeans = hasHealthMBeans;

    /**
    * Returns the health MBeans
    * @method getHealthMBeans
    * @for Health
    * @param {Workspace} workspace
    * @return {String}
    */
    function getHealthMBeans(workspace) {
        if (workspace) {
            var healthMap = workspace.mbeanServicesToDomain["Health"] || {};
            var selection = workspace.selection;
            if (selection) {
                var domain = selection.domain;
                if (domain) {
                    var mbean = healthMap[domain];
                    if (mbean) {
                        return mbean;
                    }
                }
            }
            if (healthMap) {
                // lets append all the mbeans together from all the domains
                var answer = [];
                angular.forEach(healthMap, function (value) {
                    if (angular.isArray(value)) {
                        answer = answer.concat(value);
                    } else {
                        answer.push(value);
                    }
                });
                return answer;
            } else
                return null;
        }
    }
    Health.getHealthMBeans = getHealthMBeans;
})(Health || (Health = {}));
/**
* @module Health
*/
var Health;
(function (Health) {
    function HealthController($scope, jolokia, workspace, $templateCache) {
        $scope.levelSorting = {
            'ERROR': 0,
            'WARNING': 1,
            'INFO': 2
        };

        $scope.colorMaps = {
            'ERROR': {
                'Health': '#ff0a47',
                'Remaining': '#e92614'
            },
            'WARNING': {
                'Health': '#33cc00',
                'Remaining': '#f7ee09'
            },
            'INFO': {
                'Health': '#33cc00',
                'Remaining': '#00cc33'
            }
        };

        $scope.results = [];
        $scope.responses = {};
        $scope.mbeans = [];
        $scope.mbeanStatus = {};
        $scope.displays = [];
        $scope.page = '';

        $scope.pageFilter = '';

        $scope.$watch('mbeans', function (newValue, oldValue) {
            Core.unregister(jolokia, $scope);
            if (!newValue) {
                return;
            }
            $scope.mbeanStatus = {};
            newValue.forEach(function (mbean) {
                var unregFunc = Core.register(jolokia, $scope, {
                    type: 'exec', mbean: mbean,
                    operation: "healthList()"
                }, {
                    success: $scope.render,
                    error: function (response) {
                        Health.log.info("Failed to invoke healthList() on mbean: " + mbean + " due to: ", response.error);
                        Health.log.debug("Stack trace: ", response.stacktrace.split("\n"));
                        unregFunc();
                    }
                });

                var error = function (response) {
                    if (!response.error.has("AttributeNotFoundException")) {
                        Health.log.info("Failed to read CurrentStatus on mbean: " + mbean + " due to: ", response.error);
                        Health.log.debug("Stack trace: ", response.stacktrace.split("\n"));
                    }
                };

                //see if the mbean has a CurrentStatus attribute and keep an eye on it if so
                jolokia.request({
                    type: 'read', mbean: mbean, attribute: 'CurrentStatus'
                }, {
                    success: function (response) {
                        $scope.mbeanStatus[response.request['mbean']] = response.value;
                        Core.register(jolokia, $scope, {
                            type: 'read', mbean: mbean, attribute: 'CurrentStatus'
                        }, {
                            success: function (response) {
                                /*
                                log.debug("response for CurrentStatus",
                                response.request['mbean'],
                                ": ",
                                response.value);
                                */
                                if (response.value === $scope.mbeanStatus[response.request['mbean']]) {
                                    return;
                                }
                                $scope.mbeanStatus[response.request['mbean']] = response.value;
                                Core.$apply($scope);
                            },
                            error: error
                        });
                    },
                    error: error
                });
            });
        }, true);

        $scope.getTitleClass = function (display) {
            if (!display) {
                return "warning";
            }
            if (!display.values || display.values.length === 0) {
                return "ok";
            }
            var answer = "ok";
            display.values.forEach(function (value) {
                if (answer !== "warning" && value.level && value.level.toLowerCase() !== 'info') {
                    answer = "warning";
                }
            });

            return answer;
        };

        $scope.getHumanName = function (name) {
            if (name.startsWith("org.apache.activemq")) {
                var answer = name;
                var nameParts = name.split(',');
                nameParts.forEach(function (part) {
                    if (part.startsWith('brokerName')) {
                        var parts = part.split('=');
                        if (parts[1]) {
                            answer = "Broker: " + parts[1];
                        }
                    }
                });
                return answer;
            }
            if (name.startsWith("io.fabric8:service")) {
                return "Fabric8";
            }

            return name;
        };

        $scope.getMBeans = function () {
            var healthMap = Health.getHealthMBeans(workspace);
            Health.log.debug("HealthMap: ", healthMap);
            if (healthMap) {
                if (!angular.isArray(healthMap)) {
                    return [healthMap.objectName];
                }
                var answer = healthMap.map(function (obj) {
                    return obj.objectName;
                });
                Health.log.debug("Health mbeans: ", answer);
                return answer;
            } else {
                Health.log.debug("No health mbeans found...");
                return [];
            }
        };

        $scope.$on('jmxTreeUpdated', function () {
            $scope.mbeans = $scope.getMBeans();
        });

        $scope.$on('$routeChangeSuccess', function () {
            $scope.mbeans = $scope.getMBeans();
        });

        $scope.mbeans = $scope.getMBeans();

        $scope.render = function (response) {
            /*
            log.debug("response for ",
            response.request['mbean'],
            ".",
            response.request['operation'],
            ": ",
            response.value);
            */
            var mbean = response.request['mbean'];
            var values = response.value;

            var responseJson = angular.toJson(values);

            if (mbean in $scope.responses) {
                if ($scope.responses[mbean] === responseJson) {
                    return;
                }
            }

            $scope.responses[mbean] = responseJson;

            var display = $scope.displays.find(function (m) {
                return m.mbean === mbean;
            });

            values = defaultValues(values);

            values = values.sortBy(function (value) {
                if (!value.level) {
                    return 99;
                }
                return $scope.levelSorting[value.level];
            });

            values.forEach(function (value) {
                var healthPercentCurrent = 0;
                var healthPercentRemaining = 1;

                if ('healthPercent' in value) {
                    var healthPercent = value['healthPercent'];
                    healthPercentCurrent = healthPercent.round(3);
                    healthPercentRemaining = 1 - healthPercentCurrent;
                    healthPercentRemaining = healthPercentRemaining.round(3);
                }

                value.data = {
                    total: 1,
                    terms: [
                        {
                            term: 'Health',
                            count: healthPercentCurrent
                        }, {
                            term: 'Remaining',
                            count: healthPercentRemaining
                        }]
                };
                value.colorMap = $scope.colorMaps[value.level];
            });

            if (!display) {
                $scope.displays.push({
                    mbean: mbean,
                    values: values
                });
            } else {
                display.values = values;
            }

            //log.debug("Display: ", $scope.displays);
            if ($scope.page === '') {
                $scope.page = $templateCache.get('pageTemplate');
            }

            Core.$apply($scope);
        };

        $scope.filterValues = function (value) {
            var json = angular.toJson(value);
            return json.has($scope.pageFilter);
        };

        $scope.sanitize = function (value) {
            var answer = {};
            Object.extended(value).keys().forEach(function (key) {
                if ($scope.showKey(key) && value[key]) {
                    answer[key] = value[key];
                }
            });
            return answer;
        };

        $scope.showKey = function (key) {
            if (key === "colorMap" || key === "data") {
                return false;
            }
            return true;
        };

        $scope.getTitle = function (value) {
            if (value['healthId'].endsWith('profileHealth')) {
                return 'Profile: <strong>' + value['profile'] + '</strong>';
            }
            return 'HealthID: <strong>' + value['healthId'] + '</strong>';
        };

        /*
        * Default the values that are missing in the returned JSON
        */
        function defaultValues(values) {
            angular.forEach(values, function (aData) {
                var domain = aData["domain"];
                if (!domain) {
                    var id = aData["healthId"];
                    if (id) {
                        var idx = id.lastIndexOf('.');
                        if (idx > 0) {
                            domain = id.substring(0, idx);
                            var alias = Health.healthDomains[domain];
                            if (alias) {
                                domain = alias;
                            }
                            var kind = aData["kind"];
                            if (!kind) {
                                kind = humanizeValue(id.substring(idx + 1));
                                aData["kind"] = kind;
                            }
                        }
                    }
                    aData["domain"] = domain;
                }
            });
            return values;
        }

        function createOKStatus(object) {
            return {
                healthId: object.domain + ".status",
                level: "INFO",
                message: object.title + " is OK"
            };
        }
    }
    Health.HealthController = HealthController;
})(Health || (Health = {}));
/**
* @module Health
* @main Health
*/
var Health;
(function (Health) {
    var pluginName = 'health';
    angular.module(pluginName, ['bootstrap', 'ngResource', 'hawtioCore', 'hawtio-ui']).config(function ($routeProvider) {
        $routeProvider.when('/health', { templateUrl: 'app/health/html/health.html' });
    }).run(function ($location, workspace, viewRegistry, layoutFull, helpRegistry) {
        viewRegistry['health'] = layoutFull;

        helpRegistry.addUserDoc('health', 'app/health/doc/help.md', function () {
            return Health.hasHealthMBeans(workspace);
        });

        workspace.topLevelTabs.push({
            id: "health",
            content: "Health",
            title: "View the health of the various sub systems",
            isValid: function (workspace) {
                return Health.hasHealthMBeans(workspace);
            },
            href: function () {
                return "#/health";
            },
            isActive: function (workspace) {
                return workspace.isTopTabActive("health");
            }
        });
    });

    hawtioPluginLoader.addModule(pluginName);
})(Health || (Health = {}));
var Infinispan;
(function (Infinispan) {
    function TreeController($scope, $location, workspace) {
        $scope.$on("$routeChangeSuccess", function (event, current, previous) {
            // lets do this asynchronously to avoid Error: $digest already in progress
            setTimeout(updateSelectionFromURL, 50);
        });

        $scope.$watch('workspace.tree', function () {
            if (workspace.moveIfViewInvalid())
                return;

            var children = [];

            // lets pull out each context
            var tree = workspace.tree;
            if (tree) {
                var domainName = Infinispan.jmxDomain;
                var folder = tree.get(domainName);
                if (folder) {
                    var cachesFolder = new Folder("Caches");
                    cachesFolder.domain = domainName;
                    cachesFolder.key = "root-Infinispan-Caches";
                    cachesFolder.typeName = "Caches";
                    children.push(cachesFolder);
                    addAllCacheStatistics(folder, cachesFolder);
                }

                var treeElement = $("#infinispantree");
                Jmx.enableTree($scope, $location, workspace, treeElement, children);

                // lets do this asynchronously to avoid Error: $digest already in progress
                setTimeout(updateSelectionFromURL, 50);
            }
        });

        function addAllCacheStatistics(folder, answer) {
            if (folder) {
                var children = folder.children;
                if (children) {
                    angular.forEach(folder.children, function (value, key) {
                        if (value.objectName && value.title === "Statistics") {
                            var cacheName = value.parent.parent.title || value.title;
                            var name = humanizeValue(cacheName);
                            var cacheFolder = new Folder(name);
                            cacheFolder.addClass = "org-infinispn-cache";
                            cacheFolder.typeName = "Cache";
                            cacheFolder.key = answer.key + "-" + cacheName;
                            cacheFolder.objectName = value.objectName;
                            cacheFolder.domain = value.domain;
                            cacheFolder.entries = value.entries;
                            answer.children.push(cacheFolder);
                        } else {
                            addAllCacheStatistics(value, answer);
                        }
                    });
                }
            }
        }

        function updateSelectionFromURL() {
            Jmx.updateTreeSelectionFromURL($location, $("#infinispantree"), true);
        }
    }
    Infinispan.TreeController = TreeController;
})(Infinispan || (Infinispan = {}));
/**
* @module Infinispan
* @main Infinispan
*/
var Infinispan;
(function (Infinispan) {
    var pluginName = 'infinispan';
    Infinispan.jmxDomain = 'org.infinispan';

    var toolBar = "app/infinispan/html/attributeToolBar.html";

    angular.module(pluginName, ['bootstrap', 'ngResource', 'hawtioCore']).config(function ($routeProvider) {
        $routeProvider.when('/infinispan/query', { templateUrl: 'app/infinispan/html/query.html' });
    }).filter('infinispanCacheName', function () {
        return Infinispan.infinispanCacheName;
    }).run(function (workspace, viewRegistry, helpRegistry) {
        viewRegistry['infinispan'] = 'app/infinispan/html/layoutCacheTree.html';
        helpRegistry.addUserDoc('infinispan', 'app/infinispan/doc/help.md', function () {
            return workspace.treeContainsDomainAndProperties(Infinispan.jmxDomain);
        });

        /*
        Jmx.addAttributeToolBar(pluginName, jmxDomain, (selection: NodeSelection) => {
        // TODO there should be a nicer way to do this!
        var folderNames = selection.folderNames;
        if (folderNames && selection.domain === jmxDomain) {
        return toolBar;
        }
        return null;
        });
        */
        // register default attribute views
        var nameTemplate = '<div class="ngCellText" title="Infinispan cache">{{row.entity | infinispanCacheName}}</div>';

        var attributes = workspace.attributeColumnDefs;
        attributes[Infinispan.jmxDomain + "/Caches/folder"] = [
            {
                field: '_id', displayName: 'Name',
                cellTemplate: nameTemplate, width: "**" },
            { field: 'numberOfEntries', displayName: 'Entries' },
            { field: 'hits', displayName: 'Hits' },
            { field: 'hitRatio', displayName: 'Hit Ratio' },
            { field: 'stores', displayName: 'Stores' },
            { field: 'averageReadTime', displayName: 'Avg Read Time' },
            { field: 'averageWriteTime', displayName: 'Avg Write Time' }
        ];

        workspace.topLevelTabs.push({
            id: "infinispan",
            content: "Infinispan",
            title: "View your distributed data",
            isValid: function (workspace) {
                return workspace.treeContainsDomainAndProperties(Infinispan.jmxDomain);
            },
            href: function () {
                return "#/jmx/attributes?tab=infinispan";
            },
            isActive: function (workspace) {
                return workspace.isTopTabActive("infinispan");
            }
        });

        workspace.subLevelTabs.push({
            content: '<i class="icon-pencil"></i> Query',
            title: "Perform InSQL commands on the cache",
            isValid: function (workspace) {
                return Infinispan.getSelectedCacheName(workspace) && Infinispan.getInterpreterMBean(workspace);
            },
            href: function () {
                return "#/infinispan/query";
            }
        });
    });

    hawtioPluginLoader.addModule(pluginName);
})(Infinispan || (Infinispan = {}));
var Infinispan;
(function (Infinispan) {
    function QueryController($scope, $location, workspace, jolokia) {
        var interpreter = new Infinispan.CLI(workspace, jolokia);
        $scope.logs = [];
        $scope.filteredLogs = [];
        $scope.selectedItems = [];
        $scope.searchText = "";
        $scope.filter = {
            // The default logging level to show, empty string => show all
            logLevelQuery: "",
            // The default value of the exact match logging filter
            logLevelExactMatch: false
        };

        var columnDefs = [
            {
                field: 'key',
                displayName: 'Key'
            },
            {
                field: 'value',
                displayName: 'Value'
            }
        ];

        $scope.gridOptions = {
            selectedItems: $scope.selectedItems,
            data: 'filteredLogs',
            displayFooter: false,
            showFilter: false,
            filterOptions: {
                filterText: "searchText"
            },
            columnDefs: columnDefs,
            rowDetailTemplateId: "logDetailTemplate"
        };

        $scope.$on("$routeChangeSuccess", function (event, current, previous) {
            // lets do this asynchronously to avoid Error: $digest already in progress
            setTimeout(refreshCacheName, 50);
        });

        $scope.$watch('workspace.selection', function () {
            refreshCacheName();
        });

        $scope.doQuery = function () {
            if ($scope.sql) {
                interpreter.execute($scope.sql, handleResults);
            }
        };

        function handleResults(results) {
            $scope.output = null;
            if (!results) {
                console.log("no output...");
            } else {
                var error = results["ERROR"] || "";
                var stackTrace = results["STACKTRACE"] || "";
                if (error || stackTrace) {
                    if (stackTrace) {
                        error += "\n" + stackTrace;
                    }
                    notification("error", error);
                } else {
                    var output = results["OUTPUT"];
                    if (!output) {
                        notification("error", "No results!");
                    } else {
                        $scope.output = output;
                        console.log("==== output: " + output);
                        Core.$apply($scope);
                    }
                }
            }
        }

        function refreshCacheName() {
            var cacheName = Infinispan.getSelectedCacheName(workspace);
            console.log("selected cacheName is: " + cacheName);
            if (cacheName) {
                interpreter.setCacheName(cacheName);
            }
        }
    }
    Infinispan.QueryController = QueryController;
})(Infinispan || (Infinispan = {}));
/**
* @module Infinispan
*/
var Infinispan;
(function (Infinispan) {
    /**
    * Returns the name of the cache from the mbean results
    * @class CLI
    */
    var CLI = (function () {
        function CLI(workspace, jolokia) {
            this.workspace = workspace;
            this.jolokia = jolokia;
            this.cacheName = null;
            this.sessionId = null;
            this.useSessionIds = true;
        }
        CLI.prototype.setCacheName = function (name) {
            if (name) {
                name = trimQuotes(name);
                var postfix = "(local)";
                if (name.endsWith(postfix)) {
                    name = name.substring(0, name.length - postfix.length);
                }
            }
            if (!this.cacheName || this.cacheName !== name) {
                if (this.sessionId) {
                    this.deleteSession(this.sessionId);
                }
                this.cacheName = name;
                this.createSession();
            }
        };

        CLI.prototype.createSession = function () {
            var _this = this;
            if (this.useSessionIds) {
                var mbean = Infinispan.getInterpreterMBean(this.workspace);
                if (mbean) {
                    var cli = this;
                    this.jolokia.execute(mbean, "createSessionId", this.cacheName, onSuccess(function (value) {
                        console.log("Has session ID: " + value);
                        _this.sessionId = value;
                    }));
                } else {
                    this.warnMissingMBean();
                }
            }
        };

        CLI.prototype.execute = function (sql, handler) {
            if (sql) {
                sql = sql.trim();
                if (!sql.endsWith(";")) {
                    sql += ";";
                }
                var sessionId = (this.useSessionIds) ? this.sessionId : null;
                if (!this.useSessionIds) {
                    sql = "cache " + this.cacheName + "; " + sql;
                }
                if (sessionId || !this.useSessionIds) {
                    var mbean = Infinispan.getInterpreterMBean(this.workspace);
                    if (mbean) {
                        this.jolokia.execute(mbean, "execute", sessionId, sql, onSuccess(handler));
                    } else {
                        this.warnMissingMBean();
                    }
                } else {
                    notification("warning", "Cannot evaluate SQL as we don't have a sessionId yet!");
                }
            }
        };

        CLI.prototype.deleteSession = function (sessionId) {
            // there is no delete API so far
        };

        CLI.prototype.warnMissingMBean = function () {
            notification("error", "No Interpreter MBean available");
        };
        return CLI;
    })();
    Infinispan.CLI = CLI;
})(Infinispan || (Infinispan = {}));
/**
* @module Infinispan
*/
var Infinispan;
(function (Infinispan) {
    /**
    * Returns the name of the cache from the mbean results
    * @method infinispanCacheName
    * @for Infinispan
    * @param {any} entity
    * @return {String}
    */
    function infinispanCacheName(entity) {
        // there's no name in the MBean so lets extract it from the JMX ObjectName
        if (entity) {
            var id = entity._id;
            if (id) {
                var prefix = 'name="';
                var idx = id.indexOf(prefix);
                if (idx > 0) {
                    idx += prefix.length;
                    var lastIdx = id.indexOf('"', idx + 1);
                    if (lastIdx > 0) {
                        return id.substring(idx, lastIdx);
                    } else {
                        return id.substring(idx);
                    }
                }
            }
            return id;
        }
        return null;
    }
    Infinispan.infinispanCacheName = infinispanCacheName;

    /**
    * Returns the MBean ObjectName for the interpreter
    * @method getInterpreterMBean
    * @for Infinispan
    * @param {Workspace} workspace
    * @return {String}
    */
    function getInterpreterMBean(workspace) {
        if (workspace) {
            var folder = workspace.findMBeanWithProperties(Infinispan.jmxDomain, { component: "Interpreter", type: "CacheManager" });
            if (folder) {
                return folder.objectName;
            }
        }
        return null;
    }
    Infinispan.getInterpreterMBean = getInterpreterMBean;

    function getSelectedCacheName(workspace) {
        var selection = workspace.selection;
        if (selection && selection.domain === Infinispan.jmxDomain) {
            // lets get the cache name
            return selection.entries["name"];
        }
        return null;
    }
    Infinispan.getSelectedCacheName = getSelectedCacheName;
})(Infinispan || (Infinispan = {}));
/**
* @module Karaf
*/
var Karaf;
(function (Karaf) {
    function FeaturesController($scope, $location, workspace, jolokia) {
        $scope.hasFabric = Fabric.hasFabric(workspace);
        $scope.responseJson = '';
        $scope.filter = '';

        $scope.installedFeatures = [];

        $scope.features = [];
        $scope.repositories = [];
        $scope.selectedRepositoryId = '';
        $scope.selectedRepository = {};

        $scope.newRepositoryURI = '';

        $scope.init = function () {
            var selectedRepositoryId = $location.search()['repositoryId'];
            if (selectedRepositoryId) {
                $scope.selectedRepositoryId = selectedRepositoryId;
            }

            var filter = $location.search()['filter'];
            if (filter) {
                $scope.filter = filter;
            }
        };

        $scope.init();

        $scope.$watch('selectedRepository', function (newValue, oldValue) {
            //log.debug("selectedRepository: ", $scope.selectedRepository);
            if (newValue !== oldValue) {
                if (!newValue) {
                    $scope.selectedRepositoryId = '';
                } else {
                    $scope.selectedRepositoryId = newValue['repository'];
                }
                $location.search('repositoryId', $scope.selectedRepositoryId);
            }
        }, true);

        $scope.$watch('filter', function (newValue, oldValue) {
            if (newValue !== oldValue) {
                $location.search('filter', newValue);
            }
        });

        var featuresMBean = Karaf.getSelectionFeaturesMBean(workspace);

        Karaf.log.debug("Features mbean: ", featuresMBean);

        if (featuresMBean) {
            Core.register(jolokia, $scope, {
                type: 'read', mbean: featuresMBean
            }, onSuccess(render));
        }

        $scope.inSelectedRepository = function (feature) {
            if (!$scope.selectedRepository || !('repository' in $scope.selectedRepository)) {
                return "";
            }
            if (!feature || !('RepositoryName' in feature)) {
                return "";
            }
            if (feature['RepositoryName'] === $scope.selectedRepository['repository']) {
                return "in-selected-repository";
            }
            return "";
        };

        $scope.isValidRepository = function () {
            return Core.isBlank($scope.newRepositoryURI);
        };

        $scope.installRepository = function () {
            var repoURL = $scope.newRepositoryURI;
            notification('info', 'Adding feature repository URL');
            Karaf.installRepository(workspace, jolokia, repoURL, function () {
                notification('success', 'Added feature repository URL');
                $scope.selectedRepository = {};
                $scope.selectedRepositoryId = '';
                $scope.responseJson = null;
                $scope.triggerRefresh();
            }, function (response) {
                Karaf.log.error('Failed to add feature repository URL ', repoURL, ' due to ', response.error);
                Karaf.log.info('stack trace: ', response.stacktrace);
                Core.$apply($scope);
            });
        };

        $scope.uninstallRepository = function () {
            var repoURI = $scope.selectedRepository['uri'];
            notification('info', 'Removing feature repository ' + repoURI);
            Karaf.uninstallRepository(workspace, jolokia, repoURI, function () {
                notification('success', 'Removed feature repository ' + repoURI);
                $scope.responseJson = null;
                $scope.selectedRepositoryId = '';
                $scope.selectedRepository = {};
                $scope.triggerRefresh();
            }, function (response) {
                Karaf.log.error('Failed to remove feature repository ', repoURI, ' due to ', response.error);
                Karaf.log.info('stack trace: ', response.stacktrace);
                Core.$apply($scope);
            });
        };

        $scope.triggerRefresh = function () {
            jolokia.request({
                type: 'read',
                method: 'POST',
                mbean: featuresMBean
            }, onSuccess(render));
        };

        $scope.install = function (feature) {
            if ($scope.hasFabric) {
                return;
            }

            //$('.popover').remove();
            notification('info', 'Installing feature ' + feature.Name);
            Karaf.installFeature(workspace, jolokia, feature.Name, feature.Version, function () {
                notification('success', 'Installed feature ' + feature.Name);
                $scope.installedFeatures.add(feature);
                $scope.responseJson = null;
                $scope.triggerRefresh();
                //Core.$apply($scope);
            }, function (response) {
                Karaf.log.error('Failed to install feature ', feature.Name, ' due to ', response.error);
                Karaf.log.info('stack trace: ', response.stacktrace);
                Core.$apply($scope);
            });
        };

        $scope.uninstall = function (feature) {
            if ($scope.hasFabric) {
                return;
            }

            //$('.popover').remove();
            notification('info', 'Uninstalling feature ' + feature.Name);
            Karaf.uninstallFeature(workspace, jolokia, feature.Name, feature.Version, function () {
                notification('success', 'Uninstalled feature ' + feature.Name);
                $scope.installedFeatures.remove(feature);
                $scope.responseJson = null;
                $scope.triggerRefresh();
                //Core.$apply($scope);
            }, function (response) {
                Karaf.log.error('Failed to uninstall feature ', feature.Name, ' due to ', response.error);
                Karaf.log.info('stack trace: ', response.stacktrace);
                Core.$apply($scope);
            });
        };

        $scope.filteredRows = ['Bundles', 'Configurations', 'Configuration Files', 'Dependencies'];

        $scope.showRow = function (key, value) {
            if ($scope.filteredRows.any(key)) {
                return false;
            }

            if (angular.isArray(value)) {
                if (value.length === 0) {
                    return false;
                }
            }

            if (angular.isString(value)) {
                if (Core.isBlank(value)) {
                    return false;
                }
            }

            if (angular.isObject(value)) {
                if (!value || Object.equal(value, {})) {
                    return false;
                }
            }

            return true;
        };

        $scope.installed = function (installed) {
            var answer = Core.parseBooleanValue(installed);
            return answer;
        };

        $scope.showValue = function (value) {
            if (angular.isArray(value)) {
                var answer = ['<ul class="zebra-list">'];
                value.forEach(function (v) {
                    answer.push('<li>' + v + '</li>');
                });
                answer.push('</ul>');
                return answer.join('\n');
            }
            if (angular.isObject(value)) {
                var answer = ['<table class="table">', '<tbody>'];

                angular.forEach(value, function (value, key) {
                    answer.push('<tr>');
                    answer.push('<td>' + key + '</td>');
                    answer.push('<td>' + value + '</td>');
                    answer.push('</tr>');
                });

                answer.push('</tbody>');
                answer.push('</table>');

                return answer.join('\n');
            }
            return "" + value;
        };

        $scope.getStateStyle = function (feature) {
            if (Core.parseBooleanValue(feature.Installed)) {
                return "badge badge-success";
            }
            return "badge";
        };

        $scope.filterFeature = function (feature) {
            if (Core.isBlank($scope.filter)) {
                return true;
            }
            if (feature.Id.has($scope.filter)) {
                return true;
            }
            return false;
        };

        function render(response) {
            var responseJson = angular.toJson(response.value);
            if ($scope.responseJson !== responseJson) {
                $scope.responseJson = responseJson;

                //log.debug("Got response: ", response.value);
                if (response['value']['Features'] === null) {
                    $scope.featuresError = true;
                } else {
                    $scope.featuresError = false;
                }

                $scope.features = [];
                $scope.repositories = [];

                var features = [];
                var repositories = [];

                Karaf.populateFeaturesAndRepos(response.value, features, repositories);

                var installedFeatures = features.filter(function (f) {
                    return Core.parseBooleanValue(f.Installed);
                });
                var uninstalledFeatures = features.filter(function (f) {
                    return !Core.parseBooleanValue(f.Installed);
                });

                //log.debug("repositories: ", repositories);
                $scope.installedFeatures = installedFeatures.sortBy(function (f) {
                    return f['Name'];
                });
                uninstalledFeatures = uninstalledFeatures.sortBy(function (f) {
                    return f['Name'];
                });

                repositories.sortBy('id').forEach(function (repo) {
                    $scope.repositories.push({
                        repository: repo['id'],
                        uri: repo['uri'],
                        features: uninstalledFeatures.filter(function (f) {
                            return f['RepositoryName'] === repo['id'];
                        })
                    });
                });

                if (!Core.isBlank($scope.newRepositoryURI)) {
                    var selectedRepo = repositories.find(function (r) {
                        return r['uri'] === $scope.newRepositoryURI;
                    });
                    if (selectedRepo) {
                        $scope.selectedRepositoryId = selectedRepo['id'];
                    }
                    $scope.newRepositoryURI = '';
                }

                if (Core.isBlank($scope.selectedRepositoryId)) {
                    $scope.selectedRepository = $scope.repositories.first();
                } else {
                    $scope.selectedRepository = $scope.repositories.find(function (r) {
                        return r.repository === $scope.selectedRepositoryId;
                    });
                }

                Core.$apply($scope);
            }
        }
    }
    Karaf.FeaturesController = FeaturesController;
})(Karaf || (Karaf = {}));
/**
* @module Karaf
*/
var Karaf;
(function (Karaf) {
    function NavBarController($scope, workspace) {
        $scope.hash = workspace.hash();

        $scope.isKarafEnabled = workspace.treeContainsDomainAndProperties("org.apache.karaf");
        $scope.isFeaturesEnabled = Karaf.getSelectionFeaturesMBean(workspace);
        $scope.isScrEnabled = Karaf.getSelectionScrMBean(workspace);

        $scope.$on('$routeChangeSuccess', function () {
            $scope.hash = workspace.hash();
        });

        $scope.isActive = function (nav) {
            return workspace.isLinkActive(nav);
        };

        $scope.isPrefixActive = function (nav) {
            return workspace.isLinkPrefixActive(nav);
        };
    }
    Karaf.NavBarController = NavBarController;
})(Karaf || (Karaf = {}));
/**
* @module Karaf
*/
var Karaf;
(function (Karaf) {
    function ScrComponentsController($scope, $location, workspace, jolokia) {
        $scope.component = empty();

        // caches last jolokia result
        $scope.result = [];

        // rows in components table
        $scope.components = [];

        // selected components
        $scope.selectedComponents = [];

        $scope.scrOptions = {
            //plugins: [searchProvider],
            data: 'components',
            showFilter: false,
            showColumnMenu: false,
            filterOptions: {
                useExternalFilter: false
            },
            sortInfo: { fields: ['Name'], directions: ['asc'] },
            selectedItems: $scope.selectedComponents,
            rowHeight: 32,
            selectWithCheckboxOnly: true,
            columnDefs: [
                {
                    field: 'Name',
                    displayName: 'Name',
                    cellTemplate: '<div class="ngCellText"><a href="#/osgi/scr-component/{{row.entity.Name}}?p=container">{{row.getProperty(col.field)}}</a></div>',
                    width: 400
                },
                {
                    field: 'State',
                    displayName: 'State',
                    cellTemplate: '<div class="ngCellText">{{row.getProperty(col.field)}}</div>',
                    width: 200
                }
            ]
        };

        var scrMBean = Karaf.getSelectionScrMBean(workspace);
        if (scrMBean) {
            render(Karaf.getAllComponents(workspace, jolokia));
        }

        $scope.activate = function () {
            $scope.selectedComponents.forEach(function (component) {
                Karaf.activateComponent(workspace, jolokia, component.Name, function () {
                    console.log("Activated!");
                }, function () {
                    console.log("Failed to activate!");
                });
            });
        };

        $scope.deactivate = function () {
            $scope.selectedComponents.forEach(function (component) {
                Karaf.deactivateComponent(workspace, jolokia, component.Name, function () {
                    console.log("Deactivated!");
                }, function () {
                    console.log("Failed to deactivate!");
                });
            });
        };

        function empty() {
            return [
                {
                    Name: "",
                    Status: false }
            ];
        }

        function render(components) {
            if (!Object.equal($scope.result, components)) {
                $scope.components = components;
                $scope.result = $scope.components;
                Core.$apply($scope);
            }
        }
    }
    Karaf.ScrComponentsController = ScrComponentsController;
})(Karaf || (Karaf = {}));
/**
* @module Karaf
*/
var Karaf;
(function (Karaf) {
    Karaf.log = Logger.get("Karaf");

    function setSelect(selection, group) {
        if (!angular.isDefined(selection)) {
            return group[0];
        }
        var answer = group.findIndex(function (item) {
            return item.id === selection.id;
        });
        if (answer !== -1) {
            return group[answer];
        } else {
            return group[0];
        }
    }
    Karaf.setSelect = setSelect;

    function installRepository(workspace, jolokia, uri, success, error) {
        Karaf.log.info("installing URI: ", uri);
        jolokia.request({
            type: 'exec', mbean: getSelectionFeaturesMBean(workspace),
            operation: 'addRepository(java.lang.String)',
            arguments: [uri]
        }, onSuccess(success, { error: error }));
    }
    Karaf.installRepository = installRepository;

    function uninstallRepository(workspace, jolokia, uri, success, error) {
        Karaf.log.info("uninstalling URI: ", uri);
        jolokia.request({
            type: 'exec', mbean: getSelectionFeaturesMBean(workspace),
            operation: 'removeRepository(java.lang.String)',
            arguments: [uri]
        }, onSuccess(success, { error: error }));
    }
    Karaf.uninstallRepository = uninstallRepository;

    function installFeature(workspace, jolokia, feature, version, success, error) {
        jolokia.request({
            type: 'exec', mbean: getSelectionFeaturesMBean(workspace),
            operation: 'installFeature(java.lang.String, java.lang.String)',
            arguments: [feature, version]
        }, onSuccess(success, { error: error }));
    }
    Karaf.installFeature = installFeature;

    function uninstallFeature(workspace, jolokia, feature, version, success, error) {
        jolokia.request({
            type: 'exec', mbean: getSelectionFeaturesMBean(workspace),
            operation: 'uninstallFeature(java.lang.String, java.lang.String)',
            arguments: [feature, version]
        }, onSuccess(success, { error: error }));
    }
    Karaf.uninstallFeature = uninstallFeature;

    // TODO move to core?
    function toCollection(values) {
        var collection = values;
        if (!angular.isArray(values)) {
            collection = [values];
        }
        return collection;
    }
    Karaf.toCollection = toCollection;

    function featureLinks(workspace, name, version) {
        return "<a href='" + url("#/karaf/feature/" + name + "/" + version + workspace.hash()) + "'>" + version + "</a>";
    }
    Karaf.featureLinks = featureLinks;

    function extractFeature(attributes, name, version) {
        var features = [];
        var repos = [];
        populateFeaturesAndRepos(attributes, features, repos);
        return features.find(function (feature) {
            return feature.Name == name && feature.Version == version;
        });
        /*
        var f = {};
        angular.forEach(attributes["Features"], (feature) => {
        angular.forEach(feature, (entry) => {
        if (entry["Name"] === name && entry["Version"] === version) {
        var deps = [];
        populateDependencies(attributes, entry["Dependencies"], deps);
        f["Name"] = entry["Name"];
        f["Version"] = entry["Version"];
        f["Bundles"] = entry["Bundles"];
        f["Dependencies"] = deps;
        f["Installed"] = entry["Installed"];
        f["Configurations"] = entry["Configurations"];
        f["Configuration Files"] = entry["Configuration Files"];
        f["Files"] = entry["Configuration Files"];
        }
        });
        });
        return f;
        */
    }
    Karaf.extractFeature = extractFeature;

    var platformBundlePatterns = [
        "^org.apache.aries",
        "^org.apache.karaf",
        "^activemq-karaf",
        "^org.apache.commons",
        "^org.apache.felix",
        "^io.fabric8",
        "^org.apache.geronimo.specs",
        "^org.apache.servicemix.bundles",
        "^org.objectweb.asm",
        "^io.hawt",
        "^javax.mail",
        "^org.jvnet",
        "^org.apache.mina.core",
        "^org.apache.sshd.core",
        "^org.apache.neethi",
        "^org.apache.servicemix.specs",
        "^org.apache.xbean",
        "^org.apache.santuario.xmlsec",
        "^biz.aQute.bndlib",
        "^groovy-all",
        "^com.google.guava",
        "jackson-\\w+-asl",
        "^org.ops4j",
        "^org.springframework",
        "^bcprov$",
        "^jline$",
        "^scala-library$",
        "^stax2-api$",
        "^woodstox-core-asl",
        "^org.jboss.amq.mq-fabric",
        "^joda-time$",
        "^org.apache.ws",
        "-commands$",
        "patch.patch",
        "org.fusesource.insight",
        "activeio-core",
        "activemq-osgi",
        "^org.eclipse.jetty",
        "org.codehaus.jettison.jettison"
    ];

    var platformBundleRegex = new RegExp(platformBundlePatterns.join('|'));

    var camelBundlePatterns = ["^org.apache.camel", "activemq-camel$"];
    var camelBundleRegex = new RegExp(camelBundlePatterns.join('|'));

    var cxfBundlePatterns = ["^org.apache.cxf"];
    var cxfBundleRegex = new RegExp(cxfBundlePatterns.join('|'));

    function isPlatformBundle(symbolicName) {
        return platformBundleRegex.test(symbolicName);
    }
    Karaf.isPlatformBundle = isPlatformBundle;

    function isCamelBundle(symbolicName) {
        return camelBundleRegex.test(symbolicName);
    }
    Karaf.isCamelBundle = isCamelBundle;

    function isCxfBundle(symbolicName) {
        return cxfBundleRegex.test(symbolicName);
    }
    Karaf.isCxfBundle = isCxfBundle;

    function populateFeaturesAndRepos(attributes, features, repositories) {
        var fullFeatures = attributes["Features"];
        angular.forEach(attributes["Repositories"], function (repo) {
            repositories.push({
                id: repo["Name"],
                uri: repo["Uri"]
            });

            if (!fullFeatures) {
                return;
            }

            angular.forEach(repo["Features"], function (feature) {
                angular.forEach(feature, function (entry) {
                    var f = Object.extended(fullFeatures[entry['Name']][entry['Version']]).clone();
                    f["Id"] = entry["Name"] + "/" + entry["Version"];
                    f["RepositoryName"] = repo["Name"];
                    f["RepositoryURI"] = repo["Uri"];
                    features.push(f);
                });
            });
        });
    }
    Karaf.populateFeaturesAndRepos = populateFeaturesAndRepos;

    function createScrComponentsView(workspace, jolokia, components) {
        var result = [];
        angular.forEach(components, function (component) {
            result.push({
                Name: component,
                State: getComponentStateDescription(getComponentState(workspace, jolokia, component))
            });
        });
        return result;
    }
    Karaf.createScrComponentsView = createScrComponentsView;

    function getComponentStateDescription(state) {
        switch (state) {
            case 2:
                return "Enabled";
            case 4:
                return "Unsatisfied";
            case 8:
                return "Activating";
            case 16:
                return "Active";
            case 32:
                return "Registered";
            case 64:
                return "Factory";
            case 128:
                return "Deactivating";
            case 256:
                return "Destroying";
            case 1024:
                return "Disabling";
            case 2048:
                return "Disposing";
        }
        return "Unknown";
    }
    Karaf.getComponentStateDescription = getComponentStateDescription;
    ;

    function getAllComponents(workspace, jolokia) {
        var scrMBean = getSelectionScrMBean(workspace);
        var response = jolokia.request({
            type: 'read', mbean: scrMBean,
            arguments: []
        });

        //Check if the MBean provides the Components attribute.
        if (!('Components' in response.value)) {
            response = jolokia.request({
                type: 'exec', mbean: scrMBean, operation: 'listComponents()'
            });
            return createScrComponentsView(workspace, jolokia, response.value);
        }
        return response.value['Components'].values;
    }
    Karaf.getAllComponents = getAllComponents;

    function getComponentByName(workspace, jolokia, componentName) {
        var components = getAllComponents(workspace, jolokia);
        return components.find(function (c) {
            return c.Name == componentName;
        });
    }
    Karaf.getComponentByName = getComponentByName;

    function isComponentActive(workspace, jolokia, component) {
        var response = jolokia.request({
            type: 'exec', mbean: getSelectionScrMBean(workspace),
            operation: 'isComponentActive(java.lang.String)',
            arguments: [component]
        });
        return response.value;
    }
    Karaf.isComponentActive = isComponentActive;

    function getComponentState(workspace, jolokia, component) {
        var response = jolokia.request({
            type: 'exec', mbean: getSelectionScrMBean(workspace),
            operation: 'componentState(java.lang.String)',
            arguments: [component]
        });
        return response.value;
    }
    Karaf.getComponentState = getComponentState;

    function activateComponent(workspace, jolokia, component, success, error) {
        jolokia.request({
            type: 'exec', mbean: getSelectionScrMBean(workspace),
            operation: 'activateComponent(java.lang.String)',
            arguments: [component]
        }, onSuccess(success, { error: error }));
    }
    Karaf.activateComponent = activateComponent;

    function deactivateComponent(workspace, jolokia, component, success, error) {
        jolokia.request({
            type: 'exec', mbean: getSelectionScrMBean(workspace),
            operation: 'deactiveateComponent(java.lang.String)',
            arguments: [component]
        }, onSuccess(success, { error: error }));
    }
    Karaf.deactivateComponent = deactivateComponent;

    function populateDependencies(attributes, dependencies, features) {
        angular.forEach(dependencies, function (feature) {
            angular.forEach(feature, function (entry) {
                var enhancedFeature = extractFeature(attributes, entry["Name"], entry["Version"]);
                enhancedFeature["id"] = entry["Name"] + "/" + entry["Version"];

                //enhancedFeature["repository"] = repo["Name"];
                features.push(enhancedFeature);
            });
        });
    }
    Karaf.populateDependencies = populateDependencies;

    function getSelectionFeaturesMBean(workspace) {
        if (workspace) {
            var featuresStuff = workspace.mbeanTypesToDomain["features"] || {};
            var karaf = featuresStuff["org.apache.karaf"] || {};
            var mbean = karaf.objectName;
            if (mbean) {
                return mbean;
            }

            // lets navigate to the tree item based on paths
            var folder = workspace.tree.navigate("org.apache.karaf", "features");
            if (!folder) {
                // sometimes the features mbean is inside the 'root' folder
                folder = workspace.tree.navigate("org.apache.karaf");
                if (folder) {
                    var children = folder.children;
                    folder = null;
                    angular.forEach(children, function (child) {
                        if (!folder) {
                            folder = child.navigate("features");
                        }
                    });
                }
            }
            if (folder) {
                var children = folder.children;
                if (children) {
                    var node = children[0];
                    if (node) {
                        return node.objectName;
                    }
                }
                return folder.objectName;
            }
        }
        return null;
    }
    Karaf.getSelectionFeaturesMBean = getSelectionFeaturesMBean;

    function getSelectionScrMBean(workspace) {
        if (workspace) {
            var scrStuff = workspace.mbeanTypesToDomain["scr"] || {};
            var karaf = scrStuff["org.apache.karaf"] || {};
            var mbean = karaf.objectName;
            if (mbean) {
                return mbean;
            }

            // lets navigate to the tree item based on paths
            var folder = workspace.tree.navigate("org.apache.karaf", "scr");
            if (!folder) {
                // sometimes the features mbean is inside the 'root' folder
                folder = workspace.tree.navigate("org.apache.karaf");
                if (folder) {
                    var children = folder.children;
                    folder = null;
                    angular.forEach(children, function (child) {
                        if (!folder) {
                            folder = child.navigate("scr");
                        }
                    });
                }
            }
            if (folder) {
                var children = folder.children;
                if (children) {
                    var node = children[0];
                    if (node) {
                        return node.objectName;
                    }
                }
                return folder.objectName;
            }
        }
        return null;
    }
    Karaf.getSelectionScrMBean = getSelectionScrMBean;
})(Karaf || (Karaf = {}));
/**
* @module Karaf
* @main Karaf
*/
var Karaf;
(function (Karaf) {
    var pluginName = 'karaf';
    angular.module(pluginName, ['bootstrap', 'ngResource', 'hawtioCore']).config(function ($routeProvider) {
        $routeProvider.when('/osgi/server', { templateUrl: 'app/karaf/html/server.html' }).when('/osgi/features', { templateUrl: 'app/karaf/html/features.html', reloadOnSearch: false }).when('/osgi/scr-components', { templateUrl: 'app/karaf/html/scr-components.html' }).when('/osgi/scr-component/:name', { templateUrl: 'app/karaf/html/scr-component.html' }).when('/osgi/feature/:name/:version', { templateUrl: 'app/karaf/html/feature.html' });
    }).run(function (workspace, viewRegistry, helpRegistry) {
        helpRegistry.addUserDoc('karaf', 'app/karaf/doc/help.md', function () {
            return workspace.treeContainsDomainAndProperties('org.apache.karaf');
        });
    });

    hawtioPluginLoader.addModule(pluginName);
})(Karaf || (Karaf = {}));
/**
* @module Karaf
*/
var Karaf;
(function (Karaf) {
    function FeatureController($scope, jolokia, workspace, $routeParams) {
        $scope.hasFabric = Fabric.hasFabric(workspace);
        $scope.name = $routeParams.name;
        $scope.version = $routeParams.version;
        $scope.bundlesByLocation = {};
        $scope.props = "properties";

        updateTableContents();

        $scope.install = function () {
            Karaf.installFeature(workspace, jolokia, $scope.name, $scope.version, function () {
                notification('success', 'Installed feature ' + $scope.name);
            }, function (response) {
                notification('error', 'Failed to install feature ' + $scope.name + ' due to ' + response.error);
            });
        };

        $scope.uninstall = function () {
            Karaf.uninstallFeature(workspace, jolokia, $scope.name, $scope.version, function () {
                notification('success', 'Uninstalled feature ' + $scope.name);
            }, function (response) {
                notification('error', 'Failed to uninstall feature ' + $scope.name + ' due to ' + response.error);
            });
        };

        $scope.toProperties = function (elements) {
            var answer = '';
            angular.forEach(elements, function (value, name) {
                answer += value['Key'] + " = " + value['Value'] + "\n";
            });
            return answer.trim();
        };

        function populateTable(response) {
            $scope.row = Karaf.extractFeature(response.value, $scope.name, $scope.version);
            if ($scope.row) {
                addBundleDetails($scope.row);
                var dependencies = [];

                //TODO - if the version isn't set or is 0.0.0 then maybe we show the highest available?
                angular.forEach($scope.row.Dependencies, function (version, name) {
                    angular.forEach(version, function (data, version) {
                        dependencies.push({
                            Name: name,
                            Version: version
                        });
                    });
                });
                $scope.row.Dependencies = dependencies;
            }

            //console.log("row: ", $scope.row);
            Core.$apply($scope);
        }

        function setBundles(response) {
            var bundleMap = {};
            Osgi.defaultBundleValues(workspace, $scope, response.values);
            angular.forEach(response.value, function (bundle) {
                var location = bundle["Location"];
                $scope.bundlesByLocation[location] = bundle;
            });
        }
        ;

        function updateTableContents() {
            var featureMbean = Karaf.getSelectionFeaturesMBean(workspace);
            var bundleMbean = Osgi.getSelectionBundleMBean(workspace);
            var jolokia = workspace.jolokia;

            if (bundleMbean) {
                setBundles(jolokia.request({ type: 'exec', mbean: bundleMbean, operation: 'listBundles()' }));
            }

            if (featureMbean) {
                jolokia.request({ type: 'read', mbean: featureMbean }, onSuccess(populateTable));
            }
        }

        function addBundleDetails(feature) {
            var bundleDetails = [];
            angular.forEach(feature["Bundles"], function (bundleLocation) {
                var bundle = $scope.bundlesByLocation[bundleLocation];
                if (bundle) {
                    bundle["Installed"] = true;
                    bundleDetails.push(bundle);
                } else {
                    bundleDetails.push({
                        "Location": bundleLocation,
                        "Installed": false
                    });
                }
            });
            feature["BundleDetails"] = bundleDetails;
        }
    }
    Karaf.FeatureController = FeatureController;
})(Karaf || (Karaf = {}));
/**
* @module Karaf
*/
var Karaf;
(function (Karaf) {
    function ScrComponentController($scope, $location, workspace, jolokia, $routeParams) {
        $scope.name = $routeParams.name;
        populateTable();

        function populateTable() {
            $scope.row = Karaf.getComponentByName(workspace, jolokia, $scope.name);
            Core.$apply($scope);
        }

        $scope.activate = function () {
            Karaf.activateComponent(workspace, jolokia, $scope.row['Name'], function () {
                console.log("Activated!");
            }, function () {
                console.log("Failed to activate!");
            });
        };

        $scope.deactivate = function () {
            Karaf.deactivateComponent(workspace, jolokia, $scope.row['Name'], function () {
                console.log("Deactivated!");
            }, function () {
                console.log("Failed to deactivate!");
            });
        };
    }
    Karaf.ScrComponentController = ScrComponentController;
})(Karaf || (Karaf = {}));
/**
* @module Karaf
*/
var Karaf;
(function (Karaf) {
    function ServerController($scope, $location, workspace, jolokia) {
        $scope.data = {
            name: "",
            version: "",
            state: "",
            root: "",
            startLevel: "",
            framework: "",
            frameworkVersion: "",
            location: "",
            sshPort: "",
            rmiRegistryPort: "",
            rmiServerPort: "",
            pid: "" };

        $scope.$on('jmxTreeUpdated', reloadFunction);
        $scope.$watch('workspace.tree', reloadFunction);

        function reloadFunction() {
            // if the JMX tree is reloaded its probably because a new MBean has been added or removed
            // so lets reload, asynchronously just in case
            setTimeout(loadData, 50);
        }

        function loadData() {
            console.log("Loading Karaf data...");
            jolokia.search("org.apache.karaf:type=admin,*", onSuccess(render));
        }

        function render(response) {
            // grab the first mbean as there should ideally only be one karaf in the JVM
            if (angular.isArray(response)) {
                var mbean = response[0];
                if (mbean) {
                    jolokia.getAttribute(mbean, "Instances", onSuccess(function (response) {
                        onInstances(response, mbean);
                    }));
                }
            }
        }

        function onInstances(instances, mbean) {
            if (instances) {
                var parsedMBean = Core.parseMBean(mbean);
                var instanceName = 'root';
                if ('attributes' in parsedMBean) {
                    if ('name' in parsedMBean['attributes']) {
                        instanceName = parsedMBean['attributes']['name'];
                    }
                }

                //log.debug("mbean: ", Core.parseMBean(mbean));
                //log.debug("Instances: ", instances);
                // the name is the first child
                var rootInstance = instances[instanceName];
                $scope.data.name = rootInstance.Name;
                $scope.data.state = rootInstance.State;
                $scope.data.root = rootInstance["Is Root"];
                $scope.data.location = rootInstance.Location;
                $scope.data.sshPort = rootInstance["SSH Port"];
                $scope.data.rmiRegistryPort = rootInstance["RMI Registry Port"];
                $scope.data.rmiServerPort = rootInstance["RMI Server Port"];
                $scope.data.pid = rootInstance.Pid;

                // we need to get these data from the system mbean
                $scope.data.version = "?";
                $scope.data.startLevel = "?";
                $scope.data.framework = "?";
                $scope.data.frameworkVersion = "?";

                var systemMbean = "org.apache.karaf:type=system,name=" + rootInstance.Name;

                // get more data, and its okay to do this synchronously
                var response = jolokia.request({
                    type: "read", mbean: systemMbean,
                    attribute: ["StartLevel", "Framework", "Version"] }, onSuccess(null));

                var obj = response.value;
                if (obj) {
                    $scope.data.version = obj.Version;
                    $scope.data.startLevel = obj.StartLevel;
                    $scope.data.framework = obj.Framework;
                }

                // and the osgi framework version is the bundle version
                var response2 = jolokia.search("osgi.core:type=bundleState,*", onSuccess(null));
                if (angular.isArray(response2)) {
                    var mbean = response2[0];
                    if (mbean) {
                        // get more data, and its okay to do this synchronously
                        var response3 = jolokia.request({ type: 'exec', mbean: mbean, operation: 'getVersion(long)', arguments: [0] }, onSuccess(null));
                        var obj3 = response3.value;
                        if (obj3) {
                            $scope.data.frameworkVersion = obj3;
                        }
                    }
                }
            }

            // ensure web page is updated
            Core.$apply($scope);
        }
    }
    Karaf.ServerController = ServerController;
})(Karaf || (Karaf = {}));
var Apollo;
(function (Apollo) {
    function ApolloController($scope, $http, $location, localStorage, workspace) {
        var jolokia = workspace.jolokia;
        $scope.broker = {};
        $scope.online = true;
        $scope.route = function () {
            return $location.path();
        };
        $scope.apollo = {
            version: jolokia.getAttribute('org.apache.apollo:type=broker,name="default"', "Version", onSuccess(null)),
            url: jolokia.getAttribute('org.apache.apollo:type=broker,name="default"', "WebAdminUrl", onSuccess(null))
        };

        var default_error_handler = function (data, status, headers, config) {
            if (status === 401) {
                alert("Action not authorized.");
            } else {
                alert("Error: " + status);
            }
        };

        $scope.ajax = function (type, path, success, error, data, binary_options) {
            if (!error) {
                error = default_error_handler;
            }
            var username = "admin";
            var password = "password";

            var ajax_options = {
                method: type,
                url: $scope.apollo.url + "/api/json" + path,
                headers: {
                    AuthPrompt: 'false',
                    Accept: "application/json",
                    ContentType: "application/json",
                    Authorization: Core.getBasicAuthHeader(username, password)
                },
                cache: false,
                data: null
            };
            if (binary_options) {
                ajax_options.headers["Accept"] = binary_options.Accept || "application/octet-stream";
                ajax_options.headers["ContentType"] || "application/octet-stream";
                ajax_options.data = binary_options.data;
            }

            return $http(ajax_options).success(function (data, status, headers, config) {
                $scope.online = true;
                if (success) {
                    success(data, status, headers, config);
                }
            }).error(function (data, status, headers, config) {
                if (status === 0) {
                    $scope.online = false;
                } else {
                    $scope.online = true;
                    error(data, status, headers, config);
                }
            });
        };

        var reload = function () {
            if ($scope.apollo.url) {
                $scope.ajax("GET", "/broker", function (broker) {
                    $scope.broker = broker;
                    if ($scope.apollo.selected_virtual_host === undefined) {
                        $scope.apollo.selected_virtual_host = broker.virtual_hosts[0];
                    }
                }, function (error) {
                    alert("fail:" + error);
                });
            } else {
                $scope.broker = {};
            }
        };

        var schedule_refresh = function () {
        };
        schedule_refresh = function () {
            setTimeout(function () {
                reload();
                schedule_refresh();
            }, 1000);
        };
        schedule_refresh();

        $scope.$watch('apollo.url', reload);
        $scope.$watch('online', function () {
            // alert("online: "+$scope.online)
        });
    }
    Apollo.ApolloController = ApolloController;
})(Apollo || (Apollo = {}));
var Apollo;
(function (Apollo) {
    function VirtualHostController($scope, $http, $location, localStorage, workspace) {
        $scope.virtual_host = {};
        $scope.init = function (virtual_host_name) {
            $scope.ajax("GET", "/broker/virtual-hosts/" + virtual_host_name, function (host) {
                $scope.virtual_host = host;
            });
        };
    }
    Apollo.VirtualHostController = VirtualHostController;
})(Apollo || (Apollo = {}));
/**
* @module Apollo
* @main Apollo
*/
var Apollo;
(function (Apollo) {
    var pluginName = 'apollo';
    angular.module(pluginName, ['bootstrap', 'ngResource', 'hawtioCore']).config(function ($routeProvider) {
        $routeProvider.when('/apollo', { templateUrl: 'app/apollo/html/layout-apollo.html' });
        //otherwise({templateUrl: 'app/apollo/html/layout-apollo.html'})
    }).run(function ($location, workspace, viewRegistry, helpRegistry) {
        viewRegistry['apollo'] = "app/apollo/html/layout-apollo.html";
        helpRegistry.addUserDoc('apollo', 'app/apollo/doc/help.md', function () {
            return workspace.treeContainsDomainAndProperties("org.apache.apollo");
        });

        workspace.topLevelTabs.push({
            id: "apollo",
            content: "Apollo",
            title: "Manage your Apollo Broker",
            isValid: function (workspace) {
                return workspace.treeContainsDomainAndProperties("org.apache.apollo");
            },
            href: function () {
                return '#/apollo/virtual-hosts';
            },
            isActive: function (workspace) {
                return workspace.isLinkActive("apollo");
            }
        });
    });
    hawtioPluginLoader.addModule(pluginName);
})(Apollo || (Apollo = {}));
/**
* @module Site
*/
var Site;
(function (Site) {
    function PageController($scope, $routeParams, $location, $compile, $http, fileExtensionTypeRegistry) {
        var log = Logger.get("Site");
        var pageId = $routeParams["page"];
        if (!pageId) {
            pageId = "README.md";
            /*
            $location.path("/site/doc/index.md");
            return;
            */
        }

        if (!pageId.startsWith("/") && pageId.indexOf(":/") < 0 && pageId.indexOf("app/site/") < 0) {
            // lets assume the page is relative to app/site/
            pageId = "app/site/" + pageId;
        }
        $scope.pageId = pageId;
        $scope.pageFolder = pageId.substring(0, pageId.lastIndexOf('/') + 1);

        log.info("Loading page '" + $scope.pageId + "'");

        $scope.getContents = function (filename, cb) {
            var fullPath = $scope.pageFolder + filename;
            log.info("Loading the contents of: " + fullPath);
            $http.get(fullPath).success(cb).error(function () {
                return cb(" ");
            });
        };

        $http.get($scope.pageId).success(onResults);

        function onResults(contents, status, headers, config) {
            $scope.contents = contents;
            $scope.html = contents;

            var format = Wiki.fileFormat($scope.pageId, fileExtensionTypeRegistry) || "markdown";
            if ("markdown" === format) {
                // lets convert it to HTML
                $scope.html = contents ? marked(contents) : "";
            } else if (format && format.startsWith("html")) {
                $scope.html = contents;
            } else {
                // TODO?
            }
            $compile($scope.html)($scope);
            Core.$apply($scope);
        }
    }
    Site.PageController = PageController;
})(Site || (Site = {}));
/**
* @module Site
*/
var Site;
(function (Site) {
    Site.sitePluginEnabled = false;

    function isSiteNavBarValid() {
        return Site.sitePluginEnabled;
    }
    Site.isSiteNavBarValid = isSiteNavBarValid;
})(Site || (Site = {}));
/**
* @module Site
* @main Site
*/
var Site;
(function (Site) {
    var pluginName = 'site';

    angular.module(pluginName, ['bootstrap', 'ngResource', 'ngGrid', 'datatable', 'hawtioCore', 'hawtio-ui']).config(function ($routeProvider) {
        $routeProvider.when('/site', { templateUrl: 'app/site/html/index.html' }).when('/site/', { templateUrl: 'app/site/html/index.html' }).when('/site/book/*page', { templateUrl: 'app/site/html/book.html', reloadOnSearch: false }).when('/site/*page', { templateUrl: 'app/site/html/page.html' });
    }).run(function ($location, workspace, viewRegistry, layoutFull, helpRegistry) {
        viewRegistry[pluginName] = layoutFull;

        workspace.topLevelTabs.push({
            id: "site",
            content: "Site",
            title: "View the documentation for Hawtio",
            isValid: function (workspace) {
                return false;
            },
            href: function () {
                return "#/site";
            }
        });
        /*
        helpRegistry.addUserDoc('log', 'app/log/doc/help.md', () => {
        return workspace.treeContainsDomainAndProperties('org.fusesource.insight', {type: 'LogQuery'});
        });
        
        */
    });

    hawtioPluginLoader.addModule(pluginName);
})(Site || (Site = {}));
/**
* @module Site
*/
var Site;
(function (Site) {
    function IndexController($scope, $location) {
        $scope.slideInterval = 5000;
    }
    Site.IndexController = IndexController;
})(Site || (Site = {}));
/// <reference path="../../baseIncludes.ts"/>
var UrlHelpers;
(function (UrlHelpers) {
    /**
    * Returns the URL without the starting '#' if it's there
    * @param url
    * @returns {string}
    */
    function noHash(url) {
        if (url.startsWith('#')) {
            return url.last(url.length - 1);
        } else {
            return url;
        }
    }
    UrlHelpers.noHash = noHash;

    function extractPath(url) {
        if (url.has('?')) {
            return url.split('?')[0];
        } else {
            return url;
        }
    }
    UrlHelpers.extractPath = extractPath;

    /**
    * Returns whether or not the context is in the supplied URL.  If the search string starts/ends with '/' then the entire URL is checked.  If the search string doesn't start with '/' then the search string is compared against the end of the URL.  If the search string starts with '/' but doesn't end with '/' then the start of the URL is checked, excluding any '#'
    * @param url
    * @param thingICareAbout
    * @returns {boolean}
    */
    function contextActive(url, thingICareAbout) {
        var cleanUrl = extractPath(url);
        if (thingICareAbout.endsWith('/') && thingICareAbout.startsWith("/")) {
            return cleanUrl.has(thingICareAbout);
        }
        if (thingICareAbout.startsWith("/")) {
            return noHash(cleanUrl).startsWith(thingICareAbout);
        }
        return cleanUrl.endsWith(thingICareAbout);
    }
    UrlHelpers.contextActive = contextActive;

    /**
    * Add the remainder to the URL string, adding a '/' if necessary
    * @param url
    * @param remainder
    * @returns {string}
    */
    function join(url, remainder) {
        if (!remainder || remainder.length === 0) {
            return url;
        }
        var adjusted = remainder;
        if (remainder.first(1) === '/') {
            adjusted = remainder.from(1);
        }
        if (url.last(1) === '/') {
            return url + adjusted;
        } else {
            return url + '/' + adjusted;
        }
    }
    UrlHelpers.join = join;

    UrlHelpers.parseQueryString = hawtioPluginLoader.parseQueryString;

    /**
    * Apply a proxy to the supplied URL if the jolokiaUrl is using the proxy
    * @param jolokiaUrl
    * @param url
    * @returns {*}
    */
    function maybeProxy(jolokiaUrl, url) {
        if (jolokiaUrl.has('/proxy/')) {
            return join('proxy', url);
        } else {
            return url;
        }
    }
    UrlHelpers.maybeProxy = maybeProxy;
})(UrlHelpers || (UrlHelpers = {}));
/// <reference path="../../baseIncludes.ts"/>
var StringHelpers;
(function (StringHelpers) {
    /**
    * Convert a string into a bunch of '*' of the same length
    * @param str
    * @returns {string}
    */
    function obfusicate(str) {
        if (!angular.isString(str)) {
            // return null so we don't show any old random non-string thing
            return null;
        }
        return str.chars().map(function (c) {
            return '*';
        }).join('');
    }
    StringHelpers.obfusicate = obfusicate;

    /**
    * Simple toString that obscures any field called 'password'
    * @param obj
    * @returns {string}
    */
    function toString(obj) {
        if (!obj) {
            return '{ null }';
        }
        var answer = [];
        angular.forEach(obj, function (value, key) {
            var val = value;
            if (('' + key).toLowerCase() === 'password') {
                val = StringHelpers.obfusicate(value);
            } else if (angular.isObject(val)) {
                val = toString(val);
            }
            answer.push(key + ': ' + val);
        });
        return '{ ' + answer.join(', ') + ' }';
    }
    StringHelpers.toString = toString;
})(StringHelpers || (StringHelpers = {}));
/// <reference path="../../baseIncludes.ts"/>
/// <reference path="../../helpers/js/stringHelpers.ts"/>
var Core;
(function (Core) {
    

    

    

    /**
    * Factory to create an instance of ConnectToServerOptions
    * @returns {ConnectToServerOptions}
    */
    function createConnectToServerOptions(options) {
        var defaults = {
            scheme: 'http',
            host: null,
            port: null,
            path: null,
            useProxy: true,
            jolokiaUrl: null,
            userName: null,
            password: null,
            view: null,
            name: null
        };
        var opts = options || {};
        return angular.extend(defaults, opts);
    }
    Core.createConnectToServerOptions = createConnectToServerOptions;

    function createConnectOptions(options) {
        return createConnectToServerOptions(options);
    }
    Core.createConnectOptions = createConnectOptions;
})(Core || (Core = {}));
/// <reference path="baseIncludes.ts"/>
/// <reference path="core/js/coreInterfaces.ts"/>
/// <reference path="helpers/js/stringHelpers.ts"/>
/// <reference path="helpers/js/urlHelpers.ts"/>
/**
* @module Core
*/
var Core;
(function (Core) {
    /**
    * The instance of this app's Angular injector, set once bootstrap has completed, helper functions can use this to grab angular services so they don't need them as arguments
    * @type {null}
    */
    Core.injector = null;

    var _urlPrefix = null;

    Core.connectionSettingsKey = "jvmConnect";

    /**
    * Private method to support testing.
    *
    * @private
    */
    function _resetUrlPrefix() {
        _urlPrefix = null;
    }
    Core._resetUrlPrefix = _resetUrlPrefix;

    /**
    * Prefixes absolute URLs with current window.location.pathname
    *
    * @param path
    * @returns {string}
    */
    function url(path) {
        if (path) {
            if (path.startsWith && path.startsWith("/")) {
                if (!_urlPrefix) {
                    // lets discover the base url via the base html element
                    _urlPrefix = $('base').attr('href') || "";
                    if (_urlPrefix.endsWith && _urlPrefix.endsWith('/')) {
                        _urlPrefix = _urlPrefix.substring(0, _urlPrefix.length - 1);
                    }
                }
                if (_urlPrefix) {
                    return _urlPrefix + path;
                }
            }
        }
        return path;
    }
    Core.url = url;

    /**
    * Returns location of the global window
    *
    * @returns {string}
    */
    function windowLocation() {
        return window.location;
    }
    Core.windowLocation = windowLocation;

    // use a better implementation of unescapeHTML
    String.prototype.unescapeHTML = function () {
        var txt = document.createElement("textarea");
        txt.innerHTML = this;
        return txt.value;
    };

    // add object.keys if we don't have it, used
    // in a few places
    if (!Object.keys) {
        Object.keys = function (obj) {
            var keys = [], k;
            for (k in obj) {
                if (Object.prototype.hasOwnProperty.call(obj, k)) {
                    keys.push(k);
                }
            }
            return keys;
        };
    }

    /**
    * Private method to support testing.
    *
    * @private
    */
    function _resetJolokiaUrls() {
        // Add any other known possible jolokia URLs here
        jolokiaUrls = [
            Core.url("jolokia"),
            "/jolokia"
        ];
        return jolokiaUrls;
    }
    Core._resetJolokiaUrls = _resetJolokiaUrls;

    var jolokiaUrls = Core._resetJolokiaUrls();

    /**
    * Trims the leading prefix from a string if its present
    * @method trimLeading
    * @for Core
    * @static
    * @param {String} text
    * @param {String} prefix
    * @return {String}
    */
    function trimLeading(text, prefix) {
        if (text && prefix) {
            if (text.startsWith(prefix)) {
                return text.substring(prefix.length);
            }
        }
        return text;
    }
    Core.trimLeading = trimLeading;

    /**
    * Trims the trailing postfix from a string if its present
    * @method trimTrailing
    * @for Core
    * @static
    * @param {String} trim
    * @param {String} postfix
    * @return {String}
    */
    function trimTrailing(text, postfix) {
        if (text && postfix) {
            if (text.endsWith(postfix)) {
                return text.substring(0, text.length - postfix.length);
            }
        }
        return text;
    }
    Core.trimTrailing = trimTrailing;

    /**
    * Loads all of the available connections from local storage
    * @returns {Core.ConnectionMap}
    */
    function loadConnectionMap() {
        var localStorage = Core.getLocalStorage();
        try  {
            var answer = angular.fromJson(localStorage[Core.connectionSettingsKey]);
            if (!answer) {
                return {};
            } else {
                return answer;
            }
        } catch (e) {
            // corrupt config
            delete localStorage[Core.connectionSettingsKey];
            return {};
        }
    }
    Core.loadConnectionMap = loadConnectionMap;

    /**
    * Saves the connection map to local storage
    * @param map
    */
    function saveConnectionMap(map) {
        Logger.get("Core").debug("Saving connection map: ", StringHelpers.toString(map));
        localStorage[Core.connectionSettingsKey] = angular.toJson(map);
    }
    Core.saveConnectionMap = saveConnectionMap;

    /**
    * Returns the connection options for the given connection name from localStorage
    */
    function getConnectOptions(name, localStorage) {
        if (typeof localStorage === "undefined") { localStorage = Core.getLocalStorage(); }
        if (!name) {
            return null;
        }
        return Core.loadConnectionMap()[name];
    }
    Core.getConnectOptions = getConnectOptions;

    Core.ConnectionName = null;

    /**
    * Returns the current connection name using the given search parameters
    */
    function getConnectionNameParameter(search) {
        if (Core.ConnectionName) {
            return Core.ConnectionName;
        }

        // Store the connection name once we've parsed it
        var connectionName = search["con"];
        if (angular.isArray(connectionName)) {
            connectionName = connectionName[0];
        }
        if (connectionName) {
            connectionName = connectionName.unescapeURL();
        }
        Core.ConnectionName = connectionName;
        return connectionName;
    }
    Core.getConnectionNameParameter = getConnectionNameParameter;

    /**
    * Appends the ?con=NameOfConnection to the given  URI
    */
    function appendConnectionNameToUrl(path, search) {
        var connectionName = getConnectionNameParameter(search);
        if (connectionName) {
            var separator = path.indexOf("?") >= 0 ? "&" : "?";
            return path + separator + "con=" + connectionName;
        } else {
            return path;
        }
    }
    Core.appendConnectionNameToUrl = appendConnectionNameToUrl;

    /**
    * Creates the Jolokia URL string for the given connection options
    */
    function createServerConnectionUrl(options) {
        Logger.get("Core").debug("Connect to server, options: ", StringHelpers.toString(options));
        var answer = null;
        if (options.jolokiaUrl) {
            answer = options.jolokiaUrl;
        }
        if (answer === null) {
            answer = options.scheme || 'http';
            answer += '://' + (options.host || 'localhost');
            if (options.port) {
                answer += ':' + options.port;
            }
            if (options.path) {
                answer = UrlHelpers.join(answer, options.path);
            }
        }
        if (options.useProxy) {
            answer = UrlHelpers.join('proxy', answer);
        }
        Logger.get("Core").debug("Using URL: ", answer);
        return answer;
    }
    Core.createServerConnectionUrl = createServerConnectionUrl;

    /**
    * Returns Jolokia URL by checking its availability if not in local mode
    *
    * @returns {*}
    */
    function getJolokiaUrl() {
        var query = hawtioPluginLoader.parseQueryString();
        var localMode = query['localMode'];
        if (localMode) {
            Logger.get("Core").debug("local mode so not using jolokia URL");
            jolokiaUrls = [];
            return null;
        }
        var uri = null;
        var connectionName = Core.getConnectionNameParameter(query);
        if (connectionName) {
            var connectOptions = Core.getConnectOptions(connectionName);
            if (connectOptions) {
                uri = createServerConnectionUrl(connectOptions);
                Logger.get("Core").debug("Using jolokia URI: ", uri, " from local storage");
            } else {
                Logger.get("Core").debug("Connection parameter found but no stored connections under name: ", connectionName);
            }
        }
        if (!uri) {
            var fakeCredentials = {
                username: 'public',
                password: 'biscuit'
            };
            var localStorage = getLocalStorage();
            if ('userDetails' in localStorage) {
                // user checked 'rememberMe'
                fakeCredentials = angular.fromJson(localStorage['userDetails']);
            }
            uri = jolokiaUrls.find(function (url) {
                var jqxhr = $.ajax(url, {
                    async: false,
                    username: fakeCredentials.username,
                    password: fakeCredentials.password
                });
                return jqxhr.status === 200 || jqxhr.status === 401 || jqxhr.status === 403;
            });
            Logger.get("Core").debug("Using jolokia URI: ", uri, " via discovery");
        }
        return uri;
    }
    Core.getJolokiaUrl = getJolokiaUrl;

    /**
    * Ensure our main app container takes up at least the viewport
    * height
    */
    function adjustHeight() {
        var windowHeight = $(window).height();
        var headerHeight = $("#main-nav").height();
        var containerHeight = windowHeight - headerHeight;
        $("#main").css("min-height", "" + containerHeight + "px");
    }
    Core.adjustHeight = adjustHeight;

    

    function isChromeApp() {
        var answer = false;
        try  {
            answer = (chrome && chrome.app && chrome.extension) ? true : false;
        } catch (e) {
            answer = false;
        }

        //log.info("isChromeApp is: " + answer);
        return answer;
    }
    Core.isChromeApp = isChromeApp;

    /**
    * Adds the specified CSS file to the document's head, handy
    * for external plugins that might bring along their own CSS
    *
    * @param path
    */
    function addCSS(path) {
        if ('createStyleSheet' in document) {
            // IE9
            document.createStyleSheet(path);
        } else {
            // Everyone else
            var link = $("<link>");
            $("head").append(link);

            link.attr({
                rel: 'stylesheet',
                type: 'text/css',
                href: path
            });
        }
    }
    Core.addCSS = addCSS;

    var dummyStorage = {};

    /**
    * Wrapper to get the window local storage object
    *
    * @returns {WindowLocalStorage}
    */
    function getLocalStorage() {
        // TODO Create correct implementation of windowLocalStorage
        var storage = window.localStorage || (function () {
            return dummyStorage;
        })();
        return storage;
    }
    Core.getLocalStorage = getLocalStorage;

    /**
    * If the value is not an array then wrap it in one
    *
    * @method asArray
    * @for Core
    * @static
    * @param {any} value
    * @return {Array}
    */
    function asArray(value) {
        return angular.isArray(value) ? value : [value];
    }
    Core.asArray = asArray;

    /**
    * Ensure whatever value is passed in is converted to a boolean
    *
    * In the branding module for now as it's needed before bootstrap
    *
    * @method parseBooleanValue
    * @for Core
    * @param {any} value
    * @return {Boolean}
    */
    function parseBooleanValue(value) {
        if (!angular.isDefined(value) || !value) {
            return false;
        }

        if (value.constructor === Boolean) {
            return value;
        }

        if (angular.isString(value)) {
            switch (value.toLowerCase()) {
                case "true":
                case "1":
                case "yes":
                    return true;
                default:
                    return false;
            }
        }

        if (angular.isNumber(value)) {
            return value !== 0;
        }

        throw new Error("Can't convert value " + value + " to boolean");
    }
    Core.parseBooleanValue = parseBooleanValue;

    function toString(value) {
        if (angular.isNumber(value)) {
            return numberToString(value);
        } else {
            return angular.toJson(value, true);
        }
    }
    Core.toString = toString;

    /**
    * Converts boolean value to string "true" or "false"
    *
    * @param value
    * @returns {string}
    */
    function booleanToString(value) {
        return "" + value;
    }
    Core.booleanToString = booleanToString;

    /**
    * object to integer converter
    *
    * @param value
    * @param description
    * @returns {*}
    */
    function parseIntValue(value, description) {
        if (typeof description === "undefined") { description = "integer"; }
        if (angular.isString(value)) {
            try  {
                return parseInt(value);
            } catch (e) {
                console.log("Failed to parse " + description + " with text '" + value + "'");
            }
        } else if (angular.isNumber(value)) {
            return value;
        }
        return null;
    }
    Core.parseIntValue = parseIntValue;

    /**
    * Formats numbers as Strings.
    *
    * @param value
    * @returns {string}
    */
    function numberToString(value) {
        return "" + value;
    }
    Core.numberToString = numberToString;

    /**
    * object to integer converter
    *
    * @param value
    * @param description
    * @returns {*}
    */
    function parseFloatValue(value, description) {
        if (angular.isString(value)) {
            try  {
                return parseFloat(value);
            } catch (e) {
                console.log("Failed to parse " + description + " with text '" + value + "'");
            }
        } else if (angular.isNumber(value)) {
            return value;
        }
        return null;
    }
    Core.parseFloatValue = parseFloatValue;

    /**
    * Navigates the given set of paths in turn on the source object
    * and returns the last most value of the path or null if it could not be found.
    *
    * @method pathGet
    * @for Core
    * @static
    * @param {Object} object the start object to start navigating from
    * @param {Array} paths an array of path names to navigate or a string of dot separated paths to navigate
    * @return {*} the last step on the path which is updated
    */
    function pathGet(object, paths) {
        var pathArray = (angular.isArray(paths)) ? paths : (paths || "").split(".");
        var value = object;
        angular.forEach(pathArray, function (name) {
            if (value) {
                try  {
                    value = value[name];
                } catch (e) {
                    // ignore errors
                    return null;
                }
            } else {
                return null;
            }
        });
        return value;
    }
    Core.pathGet = pathGet;

    /**
    * Navigates the given set of paths in turn on the source object
    * and updates the last path value to the given newValue
    *
    * @method pathSet
    * @for Core
    * @static
    * @param {Object} object the start object to start navigating from
    * @param {Array} paths an array of path names to navigate or a string of dot separated paths to navigate
    * @param {Object} newValue the value to update
    * @return {*} the last step on the path which is updated
    */
    function pathSet(object, paths, newValue) {
        var pathArray = (angular.isArray(paths)) ? paths : (paths || "").split(".");
        var value = object;
        var lastIndex = pathArray.length - 1;
        angular.forEach(pathArray, function (name, idx) {
            var next = value[name];
            if (idx >= lastIndex || !angular.isObject(next)) {
                next = (idx < lastIndex) ? {} : newValue;
                value[name] = next;
            }
            value = next;
        });
        return value;
    }
    Core.pathSet = pathSet;

    /**
    * Performs a $scope.$apply() if not in a digest right now otherwise it will fire a digest later
    *
    * @method $applyNowOrLater
    * @for Core
    * @static
    * @param {*} $scope
    */
    function $applyNowOrLater($scope) {
        if ($scope.$$phase || $scope.$root.$$phase) {
            setTimeout(function () {
                Core.$apply($scope);
            }, 50);
        } else {
            $scope.$apply();
        }
    }
    Core.$applyNowOrLater = $applyNowOrLater;

    /**
    * Performs a $scope.$apply() after the given timeout period
    *
    * @method $applyLater
    * @for Core
    * @static
    * @param {*} $scope
    * @param {Integer} timeout
    */
    function $applyLater($scope, timeout) {
        if (typeof timeout === "undefined") { timeout = 50; }
        setTimeout(function () {
            Core.$apply($scope);
        }, timeout);
    }
    Core.$applyLater = $applyLater;

    /**
    * Performs a $scope.$apply() if not in a digest or apply phase on the given scope
    *
    * @method $apply
    * @for Core
    * @static
    * @param {*} $scope
    */
    function $apply($scope) {
        var phase = $scope.$$phase || $scope.$root.$$phase;
        if (!phase) {
            $scope.$apply();
        }
    }
    Core.$apply = $apply;

    /**
    * Performs a $scope.$digest() if not in a digest or apply phase on the given scope
    *
    * @method $apply
    * @for Core
    * @static
    * @param {*} $scope
    */
    function $digest($scope) {
        var phase = $scope.$$phase || $scope.$root.$$phase;
        if (!phase) {
            $scope.$digest();
        }
    }
    Core.$digest = $digest;

    /**
    * Look up a list of child element names or lazily create them.
    *
    * Useful for example to get the <tbody> <tr> element from a <table> lazily creating one
    * if not present.
    *
    * Usage: var trElement = getOrCreateElements(tableElement, ["tbody", "tr"])
    * @method getOrCreateElements
    * @for Core
    * @static
    * @param {Object} domElement
    * @param {Array} arrayOfElementNames
    * @return {Object}
    */
    function getOrCreateElements(domElement, arrayOfElementNames) {
        var element = domElement;
        angular.forEach(arrayOfElementNames, function (name) {
            if (element) {
                var children = $(element).children(name);
                if (!children || !children.length) {
                    $("<" + name + "></" + name + ">").appendTo(element);
                    children = $(element).children(name);
                }
                element = children;
            }
        });
        return element;
    }
    Core.getOrCreateElements = getOrCreateElements;

    var _escapeHtmlChars = {
        "#": "&#35;",
        "'": "&#39;",
        "<": "&lt;",
        ">": "&gt;",
        "\"": "&quot;"
    };

    /**
    * static unescapeHtml
    *
    * @param str
    * @returns {any}
    */
    function unescapeHtml(str) {
        angular.forEach(_escapeHtmlChars, function (value, key) {
            var regex = new RegExp(value, "g");
            str = str.replace(regex, key);
        });
        str = str.replace(/&gt;/g, ">");
        return str;
    }
    Core.unescapeHtml = unescapeHtml;

    /**
    * static escapeHtml method
    *
    * @param str
    * @returns {*}
    */
    function escapeHtml(str) {
        if (angular.isString(str)) {
            var newStr = "";
            for (var i = 0; i < str.length; i++) {
                var ch = str.charAt(i);
                var ch = _escapeHtmlChars[ch] || ch;
                newStr += ch;
                /*
                var nextCode = str.charCodeAt(i);
                if (nextCode > 0 && nextCode < 48) {
                newStr += "&#" + nextCode + ";";
                }
                else {
                newStr += ch;
                }
                */
            }
            return newStr;
        } else {
            return str;
        }
    }
    Core.escapeHtml = escapeHtml;

    /**
    * Returns true if the string is either null or empty
    *
    * @method isBlank
    * @for Core
    * @static
    * @param {String} str
    * @return {Boolean}
    */
    function isBlank(str) {
        if (str === undefined || str === null) {
            return true;
        }
        if (angular.isString(str)) {
            return str.isBlank();
        } else {
            // TODO - not undefined but also not a string...
            return false;
        }
    }
    Core.isBlank = isBlank;

    /**
    * Displays an alert message which is typically the result of some asynchronous operation
    *
    * @method notification
    * @static
    * @param type which is usually "success" or "error" and matches css alert-* css styles
    * @param message the text to display
    *
    */
    function notification(type, message, options) {
        if (typeof options === "undefined") { options = null; }
        if (options === null) {
            options = {};
        }

        if (type === 'error' || type === 'warning') {
            if (!angular.isDefined(options.onclick)) {
                options.onclick = window['showLogPanel'];
            }
        }

        toastr[type](message, '', options);
    }
    Core.notification = notification;

    /**
    * Clears all the pending notifications
    * @method clearNotifications
    * @static
    */
    function clearNotifications() {
        toastr.clear();
    }
    Core.clearNotifications = clearNotifications;

    /**
    * removes all quotes/apostrophes from beginning and end of string
    *
    * @param text
    * @returns {string}
    */
    function trimQuotes(text) {
        if (text) {
            while (text.endsWith('"') || text.endsWith("'")) {
                text = text.substring(0, text.length - 1);
            }
            while (text.startsWith('"') || text.startsWith("'")) {
                text = text.substring(1, text.length);
            }
        }
        return text;
    }
    Core.trimQuotes = trimQuotes;

    /**
    * Converts camel-case and dash-separated strings into Human readable forms
    *
    * @param value
    * @returns {*}
    */
    function humanizeValue(value) {
        if (value) {
            var text = value + '';
            try  {
                text = text.underscore();
            } catch (e) {
                // ignore
            }
            try  {
                text = text.humanize();
            } catch (e) {
                // ignore
            }
            return trimQuotes(text);
        }
        return value;
    }
    Core.humanizeValue = humanizeValue;
})(Core || (Core = {}));

var notification = Core.notification;
var clearNotifications = Core.clearNotifications;
var url = Core.url;
var humanizeValue = Core.humanizeValue;
var trimQuotes = Core.trimQuotes;
/// <reference path="../../baseHelpers.ts"/>
var SelectionHelpers;
(function (SelectionHelpers) {
    var log = Logger.get("SelectionHelpers");

    // these functions deal with adding/using a 'selected' item on a group of objects
    function selectNone(group) {
        group.forEach(function (item) {
            item['selected'] = false;
        });
    }
    SelectionHelpers.selectNone = selectNone;

    function selectAll(group, filter) {
        group.forEach(function (item) {
            if (!filter) {
                item['selected'] = true;
            } else {
                if (filter(item)) {
                    item['selected'] = true;
                }
            }
        });
    }
    SelectionHelpers.selectAll = selectAll;

    function toggleSelection(item) {
        item['selected'] = !item['selected'];
    }
    SelectionHelpers.toggleSelection = toggleSelection;

    function selectOne(group, item) {
        selectNone(group);
        toggleSelection(item);
    }
    SelectionHelpers.selectOne = selectOne;

    function sync(selections, group, index) {
        group.forEach(function (item) {
            item['selected'] = selections.any(function (selection) {
                return selection[index] === item[index];
            });
        });
        return group.filter(function (item) {
            return item['selected'];
        });
    }
    SelectionHelpers.sync = sync;

    function select(group, item, $event) {
        var ctrlKey = $event.ctrlKey;
        if (!ctrlKey) {
            if (item['selected']) {
                toggleSelection(item);
            } else {
                selectOne(group, item);
            }
        } else {
            toggleSelection(item);
        }
    }
    SelectionHelpers.select = select;

    function isSelected(item, yes, no) {
        return maybe(item['selected'], yes, no);
    }
    SelectionHelpers.isSelected = isSelected;

    // these functions deal with using a separate selection array
    function clearGroup(group) {
        group.length = 0;
    }
    SelectionHelpers.clearGroup = clearGroup;

    function toggleSelectionFromGroup(group, item, search) {
        var searchMethod = search || item;
        if (group.any(searchMethod)) {
            group.remove(searchMethod);
        } else {
            group.add(item);
        }
    }
    SelectionHelpers.toggleSelectionFromGroup = toggleSelectionFromGroup;

    function stringOrBoolean(str, answer) {
        if (angular.isDefined(str)) {
            return str;
        } else {
            return answer;
        }
    }

    function nope(str) {
        return stringOrBoolean(str, false);
    }

    function yup(str) {
        return stringOrBoolean(str, true);
    }

    function maybe(answer, yes, no) {
        if (answer) {
            return yup(yes);
        } else {
            return nope(no);
        }
    }

    function isInGroup(group, item, yes, no, search) {
        if (!group) {
            return nope(no);
        }
        var searchMethod = search || item;
        return maybe(group.any(searchMethod), yes, no);
    }
    SelectionHelpers.isInGroup = isInGroup;

    function filterByGroup(group, item, yes, no, search) {
        if (group.length === 0) {
            return yup(yes);
        }
        var searchMethod = search || item;
        if (angular.isArray(item)) {
            return maybe(group.intersect(item).length === group.length, yes, no);
        } else {
            return maybe(group.any(searchMethod), yes, no);
        }
    }
    SelectionHelpers.filterByGroup = filterByGroup;

    function syncGroupSelection(group, collection, attribute) {
        var newGroup = [];
        if (attribute) {
            group.forEach(function (groupItem) {
                var first = collection.find(function (collectionItem) {
                    return groupItem[attribute] === collectionItem[attribute];
                });
                if (first) {
                    newGroup.push(first);
                }
            });
        } else {
            group.forEach(function (groupItem) {
                var first = collection.find(function (collectionItem) {
                    return Object.equal(groupItem, collectionItem);
                });
                if (first) {
                    newGroup.push(first);
                }
            });
        }
        clearGroup(group);
        group.add(newGroup);
    }
    SelectionHelpers.syncGroupSelection = syncGroupSelection;

    function decorate($scope) {
        $scope.selectNone = selectNone;
        $scope.selectAll = selectAll;
        $scope.toggleSelection = toggleSelection;
        $scope.selectOne = selectOne;
        $scope.select = select;
        $scope.clearGroup = clearGroup;
        $scope.toggleSelectionFromGroup = toggleSelectionFromGroup;
        $scope.isInGroup = isInGroup;
        $scope.filterByGroup = filterByGroup;
    }
    SelectionHelpers.decorate = decorate;
})(SelectionHelpers || (SelectionHelpers = {}));
/// <reference path="../../baseIncludes.ts"/>
var PluginHelpers;
(function (PluginHelpers) {
    // creates a nice little shortcut function that plugins can use to easily
    // prefix controllers with the plugin name, helps avoid redundancy and typos
    function createControllerFunction(_module, pluginName) {
        return function (name, inlineAnnotatedConstructor) {
            return _module.controller(pluginName + '.' + name, inlineAnnotatedConstructor);
        };
    }
    PluginHelpers.createControllerFunction = createControllerFunction;

    // shorthand function to create a configuration for a route, saves a bit
    // of typing
    function createRoutingFunction(templateUrl) {
        return function (templateName, reloadOnSearch) {
            if (typeof reloadOnSearch === "undefined") { reloadOnSearch = true; }
            return {
                templateUrl: templateUrl + templateName,
                reloadOnSearch: reloadOnSearch
            };
        };
    }
    PluginHelpers.createRoutingFunction = createRoutingFunction;
})(PluginHelpers || (PluginHelpers = {}));
var ControllerHelpers;
(function (ControllerHelpers) {
    var log = Logger.get("ControllerHelpers");

    function createClassSelector(config) {
        return function (selector, model) {
            if (selector === model && selector in config) {
                return config[selector];
            }
            return '';
        };
    }
    ControllerHelpers.createClassSelector = createClassSelector;

    function createValueClassSelector(config) {
        return function (model) {
            if (model in config) {
                return config[model];
            } else {
                return '';
            }
        };
    }
    ControllerHelpers.createValueClassSelector = createValueClassSelector;

    /**
    * Binds a $location.search() property to a model on a scope; so that its initialised correctly on startup
    * and its then watched so as the model changes, the $location.search() is updated to reflect its new value
    * @method bindModelToSearchParam
    * @for Core
    * @static
    * @param {*} $scope
    * @param {ng.ILocationService} $location
    * @param {String} modelName
    * @param {String} paramName
    * @param {Object} initialValue
    */
    function bindModelToSearchParam($scope, $location, modelName, paramName, initialValue, to, from) {
        if (!(modelName in $scope)) {
            $scope[modelName] = initialValue;
        }

        var toConverter = to || Core.doNothing;
        var fromConverter = from || Core.doNothing;

        function currentValue() {
            return fromConverter($location.search()[paramName] || initialValue);
        }

        var value = currentValue();
        Core.pathSet($scope, modelName, value);

        $scope.$watch(modelName, function (newValue, oldValue) {
            if (newValue !== oldValue) {
                if (newValue !== undefined && newValue !== null) {
                    $location.search(paramName, toConverter(newValue));
                } else {
                    $location.search(paramName, '');
                }
            }
        });
    }
    ControllerHelpers.bindModelToSearchParam = bindModelToSearchParam;

    /**
    * For controllers where reloading is disabled via "reloadOnSearch: false" on the registration; lets pick which
    * query parameters need to change to force the reload. We default to the JMX selection parameter 'nid'
    * @method reloadWhenParametersChange
    * @for Core
    * @static
    * @param {Object} $route
    * @param {*} $scope
    * @param {ng.ILocationService} $location
    * @param {Array[String]} parameters
    */
    function reloadWhenParametersChange($route, $scope, $location, parameters) {
        if (typeof parameters === "undefined") { parameters = ["nid"]; }
        var initial = angular.copy($location.search());
        $scope.$on('$routeUpdate', function () {
            // lets check if any of the parameters changed
            var current = $location.search();
            var changed = [];
            angular.forEach(parameters, function (param) {
                if (current[param] !== initial[param]) {
                    changed.push(param);
                }
            });
            if (changed.length) {
                //log.info("Reloading page due to change to parameters: " + changed);
                $route.reload();
            }
        });
    }
    ControllerHelpers.reloadWhenParametersChange = reloadWhenParametersChange;
})(ControllerHelpers || (ControllerHelpers = {}));
/// <reference path="../../baseHelpers.ts"/>
var FilterHelpers;
(function (FilterHelpers) {
    /**
    * Tests if an object contains the text in "filter".  The function
    * only checks the values in an object and ignores keys altogether,
    * can also work with strings/numbers/arrays
    * @param object
    * @param filter
    * @returns {boolean}
    */
    function searchObject(object, filter, maxDepth, depth) {
        if (typeof maxDepth === "undefined") { maxDepth = -1; }
        if (typeof depth === "undefined") { depth = 0; }
        // avoid inifinite recursion...
        if ((maxDepth > 0 && depth >= maxDepth) || depth > 50) {
            return false;
        }
        var f = filter.toLowerCase();
        var answer = false;
        if (angular.isString(object)) {
            answer = object.toLowerCase().has(f);
        } else if (angular.isNumber(object)) {
            answer = ("" + object).toLowerCase().has(f);
        } else if (angular.isArray(object)) {
            answer = object.some(function (item) {
                return searchObject(item, f, maxDepth, depth + 1);
            });
        } else if (angular.isObject(object)) {
            answer = searchObject(Object.extended(object).values(), f, maxDepth, depth);
        }
        return answer;
    }
    FilterHelpers.searchObject = searchObject;
})(FilterHelpers || (FilterHelpers = {}));
/// <reference path="../../baseIncludes.ts"/>
/**
* Module that provides functions related to working with javascript objects
*/
var ObjectHelpers;
(function (ObjectHelpers) {
    /**
    * Convert an array of 'things' to an object, using 'index' as the attribute name for that value
    * @param arr
    * @param index
    * @param decorator
    */
    function toMap(arr, index, decorator) {
        if (!arr || arr.length === 0) {
            return {};
        }
        var answer = {};
        arr.forEach(function (item) {
            if (angular.isObject(item)) {
                answer[item[index]] = item;
                if (angular.isFunction(decorator)) {
                    decorator(item);
                }
            }
        });
        return answer;
    }
    ObjectHelpers.toMap = toMap;
})(ObjectHelpers || (ObjectHelpers = {}));
var Forms;
(function (Forms) {
    Forms.pluginName = 'hawtio-forms';
    var log = Logger.get("Forms");

    angular.module(Forms.pluginName, ['bootstrap', 'ngResource', 'hawtioCore', 'datatable', 'ui.bootstrap', 'ui.bootstrap.dialog', 'hawtio-ui']).config(function ($routeProvider) {
        $routeProvider.when('/forms/test', { templateUrl: 'app/forms/html/test.html' }).when('/forms/testTable', { templateUrl: 'app/forms/html/testTable.html' });
    }).directive('simpleForm', function (workspace, $compile) {
        return new Forms.SimpleForm(workspace, $compile);
    }).directive('hawtioInputTable', function (workspace, $compile) {
        return new Forms.InputTable(workspace, $compile);
    }).directive('hawtioFormText', function (workspace, $compile) {
        return new Forms.TextInput(workspace, $compile);
    }).directive('hawtioFormPassword', function (workspace, $compile) {
        return new Forms.PasswordInput(workspace, $compile);
    }).directive('hawtioFormHidden', function (workspace, $compile) {
        return new Forms.HiddenText(workspace, $compile);
    }).directive('hawtioFormNumber', function (workspace, $compile) {
        return new Forms.NumberInput(workspace, $compile);
    }).directive('hawtioFormSelect', function (workspace, $compile) {
        return new Forms.SelectInput(workspace, $compile);
    }).directive('hawtioFormArray', function (workspace, $compile) {
        return new Forms.ArrayInput(workspace, $compile);
    }).directive('hawtioFormStringArray', function (workspace, $compile) {
        return new Forms.StringArrayInput(workspace, $compile);
    }).directive('hawtioFormCheckbox', function (workspace, $compile) {
        return new Forms.BooleanInput(workspace, $compile);
    }).directive('hawtioFormCustom', function (workspace, $compile) {
        return new Forms.CustomInput(workspace, $compile);
    }).directive('hawtioSubmit', function () {
        return new Forms.SubmitForm();
    }).directive('hawtioReset', function () {
        return new Forms.ResetForm();
    }).run(function (helpRegistry) {
        helpRegistry.addDevDoc("forms", 'app/forms/doc/developer.md');
    });

    hawtioPluginLoader.addModule(Forms.pluginName);
})(Forms || (Forms = {}));
var Forms;
(function (Forms) {
    var ResetForm = (function () {
        function ResetForm() {
            var _this = this;
            this.restrict = 'A';
            this.scope = true;
            // necessary to ensure 'this' is this object <sigh>
            this.link = function (scope, element, attrs) {
                return _this.doLink(scope, element, attrs);
            };
        }
        ResetForm.prototype.doLink = function (scope, element, attrs) {
            var el = $(element);

            var target = 'form[name=' + attrs['hawtioReset'] + ']';

            el.click(function () {
                var forms = $(target);
                for (var i = 0; i < forms.length; i++) {
                    forms[i].reset();
                }
                return false;
            });
        };
        return ResetForm;
    })();
    Forms.ResetForm = ResetForm;
})(Forms || (Forms = {}));
var Forms;
(function (Forms) {
    var SubmitForm = (function () {
        function SubmitForm() {
            var _this = this;
            this.restrict = 'A';
            this.scope = true;
            // necessary to ensure 'this' is this object <sigh>
            this.link = function (scope, element, attrs) {
                return _this.doLink(scope, element, attrs);
            };
        }
        SubmitForm.prototype.doLink = function (scope, element, attrs) {
            var el = $(element);

            var target = 'form[name=' + attrs['hawtioSubmit'] + ']';

            el.click(function () {
                $(target).submit();
                return false;
            });
        };
        return SubmitForm;
    })();
    Forms.SubmitForm = SubmitForm;
})(Forms || (Forms = {}));
var Forms;
(function (Forms) {
    var SimpleFormConfig = (function () {
        function SimpleFormConfig() {
            this.name = 'form';
            this.method = 'post';
            // the name of the attribute in the scope which is the data to be editted
            this.entity = 'entity';
            // the name of the full schema
            this.schemaName = 'schema';
            // set to 'view' or 'create' for different modes
            this.mode = 'edit';
            // the definition of the form
            this.data = {};
            this.json = undefined;
            // the scope
            this.scope = null;
            // the name to look up in the scope for the configuration data
            this.scopeName = null;
            this.properties = [];
            this.action = '';
            this.formclass = 'hawtio-form form-horizontal no-bottom-margin';
            this.controlgroupclass = 'control-group';
            this.controlclass = 'controls';
            this.labelclass = 'control-label';
            this.showtypes = 'false';
            this.onsubmit = 'onSubmit';
        }
        SimpleFormConfig.prototype.getMode = function () {
            return this.mode || "edit";
        };

        SimpleFormConfig.prototype.getEntity = function () {
            return this.entity || "entity";
        };

        SimpleFormConfig.prototype.isReadOnly = function () {
            return this.getMode() === "view";
        };
        return SimpleFormConfig;
    })();
    Forms.SimpleFormConfig = SimpleFormConfig;

    var SimpleForm = (function () {
        function SimpleForm(workspace, $compile) {
            var _this = this;
            this.workspace = workspace;
            this.$compile = $compile;
            this.restrict = 'A';
            this.scope = true;
            this.replace = true;
            this.transclude = true;
            this.attributeName = 'simpleForm';
            // necessary to ensure 'this' is this object <sigh>
            this.link = function (scope, element, attrs) {
                return _this.doLink(scope, element, attrs);
            };
        }
        SimpleForm.prototype.isReadOnly = function () {
            return false;
        };

        SimpleForm.prototype.doLink = function (scope, element, attrs) {
            var config = new SimpleFormConfig;

            var fullSchemaName = attrs["schema"];
            var fullSchema = fullSchemaName ? scope[fullSchemaName] : null;

            var compiledNode = null;
            var childScope = null;
            var tabs = null;
            var fieldset = null;
            var schema = null;
            var configScopeName = attrs[this.attributeName] || attrs["data"];

            var firstControl = null;

            var simple = this;
            scope.$watch(configScopeName, onWidgetDataChange);

            function onWidgetDataChange(scopeData) {
                if (scopeData) {
                    onScopeData(scopeData);
                }
            }

            function onScopeData(scopeData) {
                config = Forms.configure(config, scopeData, attrs);
                config.schemaName = fullSchemaName;
                config.scopeName = configScopeName;
                config.scope = scope;

                var entityName = config.getEntity();

                if (angular.isDefined(config.json)) {
                    config.data = $.parseJSON(config.json);
                } else {
                    config.data = scopeData;
                }

                var form = simple.createForm(config);
                fieldset = form.find('fieldset');
                schema = config.data;
                tabs = {
                    elements: {},
                    locations: {},
                    use: false
                };

                if (schema && angular.isDefined(schema.tabs)) {
                    tabs.use = true;
                    tabs['div'] = $('<div class="tabbable hawtio-form-tabs"></div>');

                    angular.forEach(schema.tabs, function (value, key) {
                        tabs.elements[key] = $('<div class="tab-pane" title="' + key + '"></div>');
                        tabs['div'].append(tabs.elements[key]);
                        value.forEach(function (val) {
                            tabs.locations[val] = key;
                        });
                    });

                    if (!tabs.locations['*']) {
                        tabs.locations['*'] = Object.extended(schema.tabs).keys()[0];
                    }
                }

                if (!tabs.use) {
                    fieldset.append('<div class="spacer"></div>');
                }

                if (schema) {
                    // if we're using tabs lets reorder the properties...
                    if (tabs.use) {
                        var tabKeyToIdPropObject = {};
                        angular.forEach(schema.properties, function (property, id) {
                            var tabkey = findTabOrderValue(id);
                            var array = tabKeyToIdPropObject[tabkey];
                            if (!array) {
                                array = [];
                                tabKeyToIdPropObject[tabkey] = array;
                            }
                            array.push({ id: id, property: property });
                        });

                        // now lets iterate through each tab...
                        angular.forEach(schema.tabs, function (value, key) {
                            value.forEach(function (val) {
                                var array = tabKeyToIdPropObject[val];
                                if (array) {
                                    angular.forEach(array, function (obj) {
                                        var id = obj.id;
                                        var property = obj.property;
                                        if (id && property) {
                                            addProperty(id, property);
                                        }
                                    });
                                }
                            });
                        });
                    } else {
                        angular.forEach(schema.properties, function (property, id) {
                            addProperty(id, property);
                        });
                    }
                }

                if (tabs.use) {
                    var tabDiv = tabs['div'];
                    var tabCount = Object.keys(tabs.elements).length;
                    if (tabCount < 2) {
                        // if we only have 1 tab lets extract the div contents of the tab
                        angular.forEach(tabDiv.children().children(), function (control) {
                            fieldset.append(control);
                        });
                    } else {
                        fieldset.append(tabDiv);
                    }
                }

                var findFunction = function (scope, func) {
                    if (angular.isDefined(scope[func]) && angular.isFunction(scope[func])) {
                        return scope;
                    }
                    if (angular.isDefined(scope.$parent) && scope.$parent !== null) {
                        return findFunction(scope.$parent, func);
                    } else {
                        return null;
                    }
                };

                var onSubmitFunc = config.onsubmit.replace('(', '').replace(')', '');
                var onSubmit = maybeGet(findFunction(scope, onSubmitFunc), onSubmitFunc);

                if (onSubmit === null) {
                    onSubmit = function (json, form) {
                        notification('error', 'No submit handler defined for form ' + form.get(0).name);
                    };
                }

                if (angular.isDefined(onSubmit)) {
                    form.submit(function () {
                        Forms.log.debug("child scope: ", childScope);
                        Forms.log.debug("form name: ", config);
                        if (childScope[config.name].$invalid) {
                            return false;
                        }
                        var entity = scope[entityName];
                        onSubmit(entity, form);
                        return false;
                    });
                }

                fieldset.append('<input type="submit" style="position: absolute; left: -9999px; width: 1px; height: 1px;">');

                // now lets try default an autofocus element onto the first item if we don't find any elements with an auto-focus
                var autoFocus = form.find("*[autofocus]");
                if (!autoFocus || !autoFocus.length) {
                    if (firstControl) {
                        console.log("No autofocus element, so lets add one!");
                        var input = firstControl.find("input").first() || firstControl.find("select").first();
                        if (input) {
                            input.attr("autofocus", "true");
                        }
                    }
                }

                if (compiledNode) {
                    $(compiledNode).remove();
                }
                if (childScope) {
                    childScope.$destroy();
                }
                childScope = scope.$new(false);

                compiledNode = simple.$compile(form)(childScope);

                // now lets expose the form object to the outer scope
                var formsScopeProperty = "forms";
                var forms = scope[formsScopeProperty];
                if (!forms) {
                    forms = {};
                    scope[formsScopeProperty] = forms;
                }
                var formName = config.name;
                if (formName) {
                    var formObject = childScope[formName];
                    if (formObject) {
                        forms[formName] = formObject;
                    }
                    var formScope = formName += "$scope";
                    forms[formScope] = childScope;
                }
                $(element).append(compiledNode);
            }

            function findTabKey(id) {
                var tabkey = tabs.locations[id];
                if (!tabkey) {
                    // lets try find a tab key using regular expressions
                    angular.forEach(tabs.locations, function (value, key) {
                        if (!tabkey && key !== "*" && id.match(key)) {
                            tabkey = value;
                        }
                    });
                }
                if (!tabkey) {
                    tabkey = tabs.locations['*'];
                }
                return tabkey;
            }

            function findTabOrderValue(id) {
                var answer = null;
                angular.forEach(schema.tabs, function (value, key) {
                    value.forEach(function (val) {
                        if (!answer && val !== "*" && id.match(val)) {
                            answer = val;
                        }
                    });
                });
                if (!answer) {
                    answer = '*';
                }
                return answer;
            }

            function addProperty(id, property, ignorePrefixInLabel) {
                if (typeof ignorePrefixInLabel === "undefined") { ignorePrefixInLabel = property.ignorePrefixInLabel; }
                // TODO should also support getting inputs from the template cache, maybe
                // for type="template"
                var propTypeName = property.type;

                // make sure we detect string as string
                if ("java.lang.String" === propTypeName) {
                    propTypeName = "string";
                }
                var propSchema = Forms.lookupDefinition(propTypeName, schema);
                if (!propSchema) {
                    propSchema = Forms.lookupDefinition(propTypeName, fullSchema);
                }

                // lets ignore fields marked as hidden from the generated form
                if (property.hidden) {
                    return;
                }
                var nestedProperties = null;
                if (!propSchema && "object" === propTypeName && property.properties) {
                    // if we've no type name but have nested properties on an object type use those
                    nestedProperties = property.properties;
                } else if (propSchema && Forms.isObjectType(propSchema)) {
                    // otherwise use the nested properties from the related schema type
                    console.log("type name " + propTypeName + " has nested object type " + JSON.stringify(propSchema, null, "  "));
                    nestedProperties = propSchema.properties;
                }
                if (nestedProperties) {
                    angular.forEach(nestedProperties, function (childProp, childId) {
                        var newId = id + "." + childId;
                        addProperty(newId, childProp, property.ignorePrefixInLabel);
                    });
                } else {
                    var input = Forms.createWidget(propTypeName, property, schema, config, id, ignorePrefixInLabel, configScopeName);

                    if (tabs.use) {
                        var tabkey = findTabKey(id);
                        tabs.elements[tabkey].append(input);
                    } else {
                        fieldset.append(input);
                    }
                    if (!firstControl) {
                        firstControl = input;
                    }
                }
            }

            function maybeGet(scope, func) {
                if (scope !== null) {
                    return scope[func];
                }
                return null;
            }
        };

        SimpleForm.prototype.createForm = function (config) {
            var form = $('<form class="' + config.formclass + '" novalidate><fieldset></fieldset></form>');
            form.attr('name', config.name);
            form.attr('action', config.action);
            form.attr('method', config.method);
            form.find('fieldset').append(this.getLegend(config));
            return form;
        };

        SimpleForm.prototype.getLegend = function (config) {
            var description = Core.pathGet(config, "data.description");
            if (description) {
                return '<legend>' + description + '</legend>';
            }
            return '';
        };
        return SimpleForm;
    })();
    Forms.SimpleForm = SimpleForm;
})(Forms || (Forms = {}));
var Forms;
(function (Forms) {
    var InputTableConfig = (function () {
        function InputTableConfig() {
            this.name = 'form';
            this.method = 'post';
            // the name of the attribute in the scope which is the data to be editted
            this.entity = 'entity';
            // the name of the attribute in the scope which is the table configuration
            this.tableConfig = 'tableConfig';
            // set to 'view' or 'create' for different modes
            this.mode = 'edit';
            // the definition of the form
            this.data = {};
            this.json = undefined;
            this.properties = [];
            this.action = '';
            this.tableclass = 'table table-striped inputTable';
            this.controlgroupclass = 'control-group';
            this.controlclass = 'controls pull-right';
            this.labelclass = 'control-label';
            this.showtypes = 'true';
            this.removeicon = 'icon-remove';
            this.editicon = 'icon-edit';
            this.addicon = 'icon-plus';
            this.removetext = 'Remove';
            this.edittext = 'Edit';
            this.addtext = 'Add';
            this.onadd = 'onadd';
            this.onedit = 'onedit';
            this.onremove = 'onRemove';
        }
        // TODO - add toggles to turn off add or edit buttons
        InputTableConfig.prototype.getTableConfig = function () {
            return this.tableConfig || "tableConfig";
        };
        return InputTableConfig;
    })();
    Forms.InputTableConfig = InputTableConfig;

    var InputTable = (function () {
        function InputTable(workspace, $compile) {
            var _this = this;
            this.workspace = workspace;
            this.$compile = $compile;
            this.restrict = 'A';
            this.scope = true;
            this.replace = true;
            this.transclude = true;
            this.attributeName = 'hawtioInputTable';
            // necessary to ensure 'this' is this object <sigh>
            this.link = function (scope, element, attrs) {
                return _this.doLink(scope, element, attrs);
            };
        }
        InputTable.prototype.doLink = function (scope, element, attrs) {
            var _this = this;
            var config = new InputTableConfig;

            var configName = attrs[this.attributeName];
            var tableConfig = Core.pathGet(scope, configName);
            config = Forms.configure(config, tableConfig, attrs);

            var entityName = attrs["entity"] || config.data || "entity";
            var propertyName = attrs["property"] || "arrayData";
            var entityPath = entityName + "." + propertyName;

            // TODO better name?
            var tableName = config["title"] || entityName;

            if (angular.isDefined(config.json)) {
                config.data = $.parseJSON(config.json);
            } else {
                config.data = scope[config.data];
            }

            scope.selectedItems = [];

            var div = $("<div></div>");

            // TODO lets ensure we have some default columns in the column configuration?
            var tableConfig = Core.pathGet(scope, configName);
            if (!tableConfig) {
                console.log("No table configuration for table " + tableName);
            } else {
                tableConfig["selectedItems"] = scope.selectedItems;
            }

            var table = this.createTable(config, configName);

            var group = this.getControlGroup(config, {}, "");
            var controlDiv = this.getControlDiv(config);
            controlDiv.addClass('btn-group');
            group.append(controlDiv);

            function updateData(action) {
                var data = Core.pathGet(scope, entityPath);

                // lets coerce the data to an array if its empty or an object
                if (!data) {
                    data = [];
                }
                if (!angular.isArray(data) && data) {
                    data = [data];
                }
                data = action(data);
                Core.pathSet(scope, entityPath, data);

                // TODO for some reason this doesn't notify the underlying hawtio-datatable that the table has changed
                // so lets force it with a notify...
                scope.$emit("hawtio.datatable." + entityPath, data);
                Core.$apply(scope);
            }

            function removeSelected(data) {
                angular.forEach(scope.selectedItems, function (selected) {
                    var id = selected["_id"];
                    if (angular.isArray(data)) {
                        data = data.remove(function (value) {
                            return Object.equal(value, selected);
                        });
                        delete selected["_id"];
                        data = data.remove(function (value) {
                            return Object.equal(value, selected);
                        });
                    } else {
                        delete selected["_id"];
                        if (id) {
                            delete data[id];
                        } else {
                            // lets iterate for the value
                            var found = false;
                            angular.forEach(data, function (value, key) {
                                if (!found && (Object.equal(value, selected))) {
                                    console.log("Found row to delete! " + key);
                                    delete data[key];
                                    found = true;
                                }
                            });
                            if (!found) {
                                console.log("Could not find " + JSON.stringify(selected) + " in " + JSON.stringify(data));
                            }
                        }
                    }
                });
                return data;
            }

            var add = null;
            var edit = null;
            var remove = null;
            var addDialog = null;
            var editDialog = null;
            var readOnly = attrs["readonly"];
            if (!readOnly) {
                var property = null;
                var dataName = attrs["data"];
                var dataModel = dataName ? Core.pathGet(scope, dataName) : null;
                var schemaName = attrs["schema"] || dataName;
                var schema = schemaName ? Core.pathGet(scope, schemaName) : null;
                if (propertyName && dataModel) {
                    property = Core.pathGet(dataModel, ["properties", propertyName]);
                }

                add = this.getAddButton(config);

                scope.addDialogOptions = {
                    backdropFade: true,
                    dialogFade: true
                };
                scope.showAddDialog = false;

                scope.openAddDialog = function () {
                    // lets lazily create the add dialog
                    scope.addEntity = {};
                    scope.addFormConfig = Forms.findArrayItemsSchema(property, schema);

                    var childDataModelName = "addFormConfig";
                    if (!addDialog) {
                        var title = "Add " + tableName;
                        addDialog = $('<div modal="showAddDialog" close="closeAddDialog()" options="addDialogOptions">\n' + '<div class="modal-header"><h4>' + title + '</h4></div>\n' + '<div class="modal-body"><div simple-form="addFormConfig" entity="addEntity" data="' + childDataModelName + '" schema="' + schemaName + '"></div></div>\n' + '<div class="modal-footer">' + '<button class="btn btn-primary add" type="button" ng-click="addAndCloseDialog()">Add</button>' + '<button class="btn btn-warning cancel" type="button" ng-click="closeAddDialog()">Cancel</button>' + '</div></div>');
                        div.append(addDialog);
                        _this.$compile(addDialog)(scope);
                    }
                    scope.showAddDialog = true;
                    Core.$apply(scope);
                };

                scope.closeAddDialog = function () {
                    scope.showAddDialog = false;
                    scope.addEntity = {};
                };

                scope.addAndCloseDialog = function () {
                    var newData = scope.addEntity;
                    Forms.log.info("About to add the new entity " + JSON.stringify(newData));
                    if (newData) {
                        updateData(function (data) {
                            // TODO deal with non arrays
                            data.push(newData);
                            return data;
                        });
                    }
                    scope.closeAddDialog();
                };

                edit = this.getEditButton(config);

                scope.editDialogOptions = {
                    backdropFade: true,
                    dialogFade: true
                };
                scope.showEditDialog = false;

                scope.openEditDialog = function () {
                    var selected = scope.selectedItems;

                    // lets make a deep copy for the value being edited
                    var editObject = {};
                    if (selected && selected.length) {
                        angular.copy(selected[0], editObject);
                    }
                    scope.editEntity = editObject;
                    scope.editFormConfig = Forms.findArrayItemsSchema(property, schema);

                    // lets lazily create the edit dialog
                    if (!editDialog) {
                        var title = "Edit " + tableName;
                        editDialog = $('<div modal="showEditDialog" close="closeEditDialog()" options="editDialogOptions">\n' + '<div class="modal-header"><h4>' + title + '</h4></div>\n' + '<div class="modal-body"><div simple-form="editFormConfig" entity="editEntity"></div></div>\n' + '<div class="modal-footer">' + '<button class="btn btn-primary save" type="button" ng-click="editAndCloseDialog()">Save</button>' + '<button class="btn btn-warning cancel" type="button" ng-click="closeEditDialog()">Cancel</button>' + '</div></div>');
                        div.append(editDialog);
                        _this.$compile(editDialog)(scope);
                    }
                    scope.showEditDialog = true;
                    Core.$apply(scope);
                };

                scope.closeEditDialog = function () {
                    scope.showEditDialog = false;
                    scope.editEntity = {};
                };

                scope.editAndCloseDialog = function () {
                    var newData = scope.editEntity;
                    console.log("About to edit the new entity " + JSON.stringify(newData));
                    if (newData) {
                        updateData(function (data) {
                            data = removeSelected(data);

                            // TODO deal with non arrays
                            data.push(newData);
                            return data;
                        });
                    }
                    scope.closeEditDialog();
                };

                remove = this.getRemoveButton(config);
            }

            var findFunction = function (scope, func) {
                if (angular.isDefined(scope[func]) && angular.isFunction(scope[func])) {
                    return scope;
                }
                if (angular.isDefined(scope.$parent) && scope.$parent !== null) {
                    return findFunction(scope.$parent, func);
                } else {
                    return null;
                }
            };

            function maybeGet(scope, func) {
                if (scope !== null) {
                    return scope[func];
                }
                return null;
            }

            var onRemoveFunc = config.onremove.replace('(', '').replace(')', '');
            var onEditFunc = config.onedit.replace('(', '').replace(')', '');
            var onAddFunc = config.onadd.replace('(', '').replace(')', '');

            var onRemove = maybeGet(findFunction(scope, onRemoveFunc), onRemoveFunc);
            var onEdit = maybeGet(findFunction(scope, onEditFunc), onEditFunc);
            var onAdd = maybeGet(findFunction(scope, onAddFunc), onAddFunc);

            if (onRemove === null) {
                onRemove = function () {
                    updateData(function (data) {
                        return removeSelected(data);
                    });
                };
            }
            if (onEdit === null) {
                onEdit = function () {
                    scope.openEditDialog();
                };
            }
            if (onAdd === null) {
                onAdd = function (form) {
                    scope.openAddDialog();
                };
            }
            if (add) {
                add.click(function (event) {
                    onAdd();
                    return false;
                });
                controlDiv.append(add);
            }
            if (edit) {
                edit.click(function (event) {
                    onEdit();
                    return false;
                });
                controlDiv.append(edit);
            }
            if (remove) {
                remove.click(function (event) {
                    onRemove();
                    return false;
                });
                controlDiv.append(remove);
            }

            $(div).append(group);
            $(div).append(table);
            $(element).append(div);

            // compile the template
            this.$compile(div)(scope);
        };

        InputTable.prototype.getAddButton = function (config) {
            return $('<button type="button" class="btn add"><i class="' + config.addicon + '"></i> ' + config.addtext + '</button>');
        };

        InputTable.prototype.getEditButton = function (config) {
            return $('<button type="button" class="btn edit" ng-disabled="!selectedItems.length"><i class="' + config.editicon + '"></i> ' + config.edittext + '</button>');
        };

        InputTable.prototype.getRemoveButton = function (config) {
            return $('<button type="remove" class="btn remove" ng-disabled="!selectedItems.length"><i class="' + config.removeicon + '"></i> ' + config.removetext + '</button>');
        };

        InputTable.prototype.createTable = function (config, tableConfig) {
            //var tableType = "hawtio-datatable";
            var tableType = "hawtio-simple-table";
            var table = $('<div class="' + config.tableclass + '" ' + tableType + '="' + tableConfig + '">');

            //table.find('fieldset').append(this.getLegend(config));
            return table;
        };

        InputTable.prototype.getLegend = function (config) {
            var description = Core.pathGet(config, "data.description");
            if (description) {
                return '<legend>' + config.data.description + '</legend>';
            }
            return '';
        };

        InputTable.prototype.getControlGroup = function (config, arg, id) {
            var rc = $('<div class="' + config.controlgroupclass + '"></div>');
            if (angular.isDefined(arg.description)) {
                rc.attr('title', arg.description);
            }
            return rc;
        };

        InputTable.prototype.getControlDiv = function (config) {
            return $('<div class="' + config.controlclass + '"></div>');
        };

        InputTable.prototype.getHelpSpan = function (config, arg, id) {
            var rc = $('<span class="help-block"></span>');
            if (angular.isDefined(arg.type) && config.showtypes !== 'false') {
                rc.append('Type: ' + arg.type);
            }
            return rc;
        };
        return InputTable;
    })();
    Forms.InputTable = InputTable;
})(Forms || (Forms = {}));
/**
* @module Forms
*/
var Forms;
(function (Forms) {
    Forms.log = Logger.get("Forms");

    /**
    * Default any values in the schema on the entity if they are not already present
    * @method defaultValues
    * @param {any} entity
    * @param {any} schema
    */
    function defaultValues(entity, schema) {
        if (entity && schema) {
            angular.forEach(schema.properties, function (property, key) {
                var defaultValue = property.default;
                if (defaultValue && !entity[key]) {
                    console.log("===== defaulting value " + defaultValue + " into entity[" + key + "]");
                    entity[key] = defaultValue;
                }
            });
        }
    }
    Forms.defaultValues = defaultValues;

    /**
    * If the type name refers to an alias in the schemas definitions then perform the lookup and return the real type name
    * @method resolveTypeNAmeAlias
    * @param {String} type
    * @param {any} schema
    *
    */
    function resolveTypeNameAlias(type, schema) {
        if (type && schema) {
            var alias = lookupDefinition(type, schema);
            if (alias) {
                var realType = alias["type"];
                if (realType) {
                    type = realType;
                }
            }
        }
        return type;
    }
    Forms.resolveTypeNameAlias = resolveTypeNameAlias;

    /**
    * Walks the base class hierarchy checking if the given type is an instance of the given type name
    * @method isJsonType
    * @param {String} name
    * @param {any} schema
    * @param {String} typeName
    * @return {Boolean}
    */
    function isJsonType(name, schema, typeName) {
        var definition = lookupDefinition(name, schema);
        while (definition) {
            var extendsTypes = Core.pathGet(definition, ["extends", "type"]);
            if (extendsTypes) {
                if (typeName === extendsTypes) {
                    return true;
                } else {
                    definition = lookupDefinition(extendsTypes, schema);
                }
            } else {
                return false;
            }
        }
        return false;
    }
    Forms.isJsonType = isJsonType;

    /**
    * Removes any dodgy characters for a valid identifier in angularjs such as for '-' characters
    * which are replaced with '_'
    * @method safeIdentifier
    * @param {String} id
    * @return {String}
    */
    function safeIdentifier(id) {
        if (id) {
            return id.replace(/-/g, "_");
        }
        return id;
    }
    Forms.safeIdentifier = safeIdentifier;

    /**
    * Looks up the given type name in the schemas definitions
    * @method lookupDefinition
    * @param {String} name
    * @param {any} schema
    */
    function lookupDefinition(name, schema) {
        if (schema) {
            var defs = schema.definitions;
            if (defs) {
                var answer = defs[name];
                if (answer) {
                    var fullSchema = answer["fullSchema"];
                    if (fullSchema) {
                        return fullSchema;
                    }

                    // we may extend another, if so we need to copy in the base properties
                    var extendsTypes = Core.pathGet(answer, ["extends", "type"]);
                    if (extendsTypes) {
                        fullSchema = angular.copy(answer);
                        fullSchema.properties = fullSchema.properties || {};
                        if (!angular.isArray(extendsTypes)) {
                            extendsTypes = [extendsTypes];
                        }
                        angular.forEach(extendsTypes, function (extendType) {
                            if (angular.isString(extendType)) {
                                var extendDef = lookupDefinition(extendType, schema);
                                var properties = Core.pathGet(extendDef, ["properties"]);
                                if (properties) {
                                    angular.forEach(properties, function (property, key) {
                                        fullSchema.properties[key] = property;
                                    });
                                }
                            }
                        });
                        answer["fullSchema"] = fullSchema;
                        return fullSchema;
                    }
                }
                return answer;
            }
        }
        return null;
    }
    Forms.lookupDefinition = lookupDefinition;

    /**
    * For an array property, find the schema of the items which is either nested inside this property
    * in the 'items' property; or the type name is used to lookup in the schemas definitions
    * @method findArrayItemsSchema
    * @param {String} property
    * @param {any} schema
    */
    function findArrayItemsSchema(property, schema) {
        var items = null;
        if (property && schema) {
            items = property.items;
            if (items) {
                var typeName = items["type"];
                if (typeName) {
                    var definition = lookupDefinition(typeName, schema);
                    if (definition) {
                        return definition;
                    }
                }
            }

            // are we a json schema properties with a link to the schema doc?
            var additionalProperties = property.additionalProperties;
            if (additionalProperties) {
                if (additionalProperties["$ref"] === "#") {
                    return schema;
                }
            }
        }
        return items;
    }
    Forms.findArrayItemsSchema = findArrayItemsSchema;

    /**
    * Returns true if the given schema definition is an object
    * @method isObjectType
    * @param {any} definition
    */
    function isObjectType(definition) {
        var typeName = Core.pathGet(definition, "type");
        return typeName && "object" === typeName;
    }
    Forms.isObjectType = isObjectType;

    /**
    * Returns true if the given property represents a nested object or array of objects
    * @method isArrayOrNestedObject
    * @param {any} property
    * @param {any} schema
    */
    function isArrayOrNestedObject(property, schema) {
        if (property) {
            var propType = resolveTypeNameAlias(property["type"], schema);
            if (propType) {
                if (propType === "object" || propType === "array") {
                    return true;
                }
            }
        }
        return false;
    }
    Forms.isArrayOrNestedObject = isArrayOrNestedObject;

    function configure(config, scopeConfig, attrs) {
        if (angular.isDefined(scopeConfig)) {
            config = angular.extend(config, scopeConfig);
        }
        return angular.extend(config, attrs);
    }
    Forms.configure = configure;

    function getControlGroup(config, arg, id) {
        var rc = $('<div class="' + config.controlgroupclass + '"></div>');
        if (angular.isDefined(arg.description)) {
            rc.attr('title', arg.description);
        }

        Forms.log.debug("getControlGroup, config:", config, " arg: ", arg, " id: ", id);
        if (config['properties'] && config['properties'][id]) {
            var elementConfig = config['properties'][id];
            Forms.log.debug("elementConfig: ", elementConfig);
            if (elementConfig && 'control-attributes' in elementConfig) {
                angular.forEach(elementConfig['control-attributes'], function (value, key) {
                    rc.attr(key, value);
                });
            }
        }

        return rc;
    }
    Forms.getControlGroup = getControlGroup;

    function getLabel(config, arg, label) {
        return $('<label class="' + config.labelclass + '">' + label + ': </label>');
    }
    Forms.getLabel = getLabel;

    function getControlDiv(config) {
        return $('<div class="' + config.controlclass + '"></div>');
    }
    Forms.getControlDiv = getControlDiv;

    function getHelpSpan(config, arg, id) {
        var rc = '';
        if (angular.isDefined(arg.type) && config.showtypes !== 'false') {
            $('<span class="help-block">Type: ' + arg.type + '</span>');
        }
        return rc;
    }
    Forms.getHelpSpan = getHelpSpan;
})(Forms || (Forms = {}));
var Forms;
(function (Forms) {
    function FormTestController($scope, workspace) {
        $scope.editing = false;

        $scope.html = "text/html";
        $scope.javascript = "javascript";

        $scope.basicFormEx1Entity = {
            'key': 'Some key',
            'value': 'Some value'
        };
        $scope.basicFormEx1EntityString = angular.toJson($scope.basicFormEx1Entity, true);

        $scope.basicFormEx1Result = '';

        $scope.toggleEdit = function () {
            $scope.editing = !$scope.editing;
        };

        $scope.view = function () {
            if (!$scope.editing) {
                return "view";
            }
            return "edit";
        };

        $scope.basicFormEx1 = '<div simple-form name="some-form" action="#/forms/test" method="post" data="basicFormEx1SchemaObject" entity="basicFormEx1Entity" onSubmit="callThis()"></div>';

        $scope.toObject = function (str) {
            return angular.fromJson(str.replace("'", "\""));
        };

        $scope.fromObject = function (str) {
            return angular.toJson($scope[str], true);
        };

        //TODO - I totally did this backwards :-/
        $scope.basicFormEx1Schema = '' + '{\n' + '   "properties": {\n' + '     "key": {\n' + '       "description": "Argument key",\n' + '       "type": "java.lang.String"\n' + '     },\n' + '     "value": {\n' + '       "description": "Argument Value",\n' + '       "type": "java.lang.String"\n' + '     },\n' + '     "longArg": {\n' + '       "description": "Long argument",\n' + '       "type": "Long",\n' + '       "minimum": "5",\n' + '       "maximum": "10"\n' + '     },\n' + '     "intArg": {\n' + '       "description": "Int argument",\n' + '       "type": "Integer"\n' + '     },\n' + '     "objectArg": {\n' + '       "description": "some object",\n' + '       "type": "object"\n' + '     },\n' + '     "booleanArg": {\n' + '       "description": "Some boolean value",\n' + '       "type": "java.lang.Boolean"\n' + '     }\n' + '   },\n' + '   "description": "Show some stuff in a form",\n' + '   "type": "java.lang.String",\n' + '   "tabs": {\n' + '     "Tab One": ["key", "value"],\n' + '     "Tab Two": ["*"],\n' + '     "Tab Three": ["booleanArg"]\n' + '   }\n' + '}';

        $scope.basicFormEx1SchemaObject = $scope.toObject($scope.basicFormEx1Schema);

        $scope.updateSchema = function () {
            $scope.basicFormEx1SchemaObject = $scope.toObject($scope.basicFormEx1Schema);
        };

        $scope.updateEntity = function () {
            $scope.basicFormEx1Entity = angular.fromJson($scope.basicFormEx1EntityString);
        };

        $scope.hawtioResetEx = '<a class="btn" href="" hawtio-reset="some-form"><i class="icon-refresh"></i> Clear</a>';

        $scope.hawtioSubmitEx = '      <a class="btn" href="" hawtio-submit="some-form"><i class="icon-save"></i> Save</a>';

        $scope.callThis = function (json, form) {
            $scope.basicFormEx1Result = angular.toJson(json, true);
            notification('success', 'Form "' + form.get(0).name + '" submitted...');
            Core.$apply($scope);
        };

        $scope.config = {
            name: 'form-with-config-object',
            action: "/some/url",
            method: "post",
            data: 'setVMOption',
            showtypes: 'false'
        };

        $scope.cheese = {
            key: "keyABC",
            value: "valueDEF",
            intArg: 999
        };

        $scope.onCancel = function (form) {
            notification('success', 'Cancel clicked on form "' + form.get(0).name + '"');
        };

        $scope.onSubmit = function (json, form) {
            notification('success', 'Form "' + form.get(0).name + '" submitted... (well not really), data:' + JSON.stringify(json));
        };

        $scope.derp = function (json, form) {
            notification('error', 'derp with json ' + JSON.stringify(json));
        };

        $scope.inputTableSchema = {
            properties: {
                'id': {
                    description: 'Object ID',
                    type: 'java.lang.String'
                }
            },
            description: 'Some objects'
        };

        $scope.inputTableData = [
            { id: "object1", name: 'foo' },
            { id: "object2", name: 'bar' }
        ];

        $scope.inputTableConfig = {
            data: 'inputTableData',
            displayFooter: false,
            showFilter: false,
            columnDefs: [
                {
                    field: 'id',
                    displayName: 'ID'
                },
                {
                    field: 'name',
                    displayName: 'Name'
                }
            ]
        };
    }
    Forms.FormTestController = FormTestController;
})(Forms || (Forms = {}));
/**
* @module Forms
*/
var Forms;
(function (Forms) {
    /**
    * Create a DOM widget tree for the given set of form configuration data.
    *
    * This will include either the standard AngularJS widgets or custom widgets
    * @method createWidget
    * @param {String} propTypeName
    * @param {any} property
    * @param {any} schema
    * @param {any} config
    * @param {String} id
    * @param {Boolean ignorePrefixInLabel
    * @param {String} configScoepName
    * @param {Boolean} wrapInGroup
    */
    function createWidget(propTypeName, property, schema, config, id, ignorePrefixInLabel, configScopeName, wrapInGroup) {
        if (typeof wrapInGroup === "undefined") { wrapInGroup = true; }
        var input = null;
        var group = null;

        function copyElementAttributes(element, propertyName) {
            var propertyAttributes = property[propertyName];
            if (propertyAttributes) {
                angular.forEach(propertyAttributes, function (value, key) {
                    if (angular.isString(value)) {
                        element.attr(key, value);
                    }
                });
            }
        }
        function copyAttributes() {
            copyElementAttributes(input, "input-attributes");
            angular.forEach(property, function (value, key) {
                if (angular.isString(value) && key.indexOf("$") < 0 && key !== "type") {
                    var html = Core.escapeHtml(value);
                    input.attr(key, html);
                }
            });
        }

        // lets try to create standard widget markup by default
        // as they work better than the hawtio wrappers when inside forms...
        var options = {
            valueConverter: null
        };
        var safeId = Forms.safeIdentifier(id);

        var inputMarkup = createStandardWidgetMarkup(propTypeName, property, schema, config, options, safeId);

        // Note if for whatever reason we need to go back to the old way of using hawtio directives for standard
        // angularjs directives, just clear inputMarker to null here ;)
        // inputMarkup = null;
        if (inputMarkup) {
            input = $(inputMarkup);

            copyAttributes();

            id = safeId;

            var modelName = config.model || Core.pathGet(property, ["input-attributes", "ng-model"]);
            if (!modelName) {
                modelName = config.getEntity() + "." + id;
            }
            input.attr("ng-model", modelName);

            input.attr('name', id);

            try  {
                if (config.isReadOnly()) {
                    input.attr('readonly', 'true');
                }
            } catch (e) {
                // ignore missing read only function
            }
            var title = property.tooltip || property.label;
            if (title) {
                input.attr('title', title);
            }

            // allow the prefix to be trimmed from the label if enabled
            var defaultLabel = id;
            if (ignorePrefixInLabel || property.ignorePrefixInLabel) {
                var idx = id.lastIndexOf('.');
                if (idx > 0) {
                    defaultLabel = id.substring(idx + 1);
                }
            }

            // figure out which things to not wrap in a group and label etc...
            if (input.attr("type") !== "hidden" && wrapInGroup) {
                group = this.getControlGroup(config, config, id);
                var labelElement = Forms.getLabel(config, config, property.title || property.label || humanizeValue(defaultLabel));
                if (title) {
                    labelElement.attr('title', title);
                }
                group.append(labelElement);
                copyElementAttributes(labelElement, "label-attributes");

                var controlDiv = Forms.getControlDiv(config);
                controlDiv.append(input);
                controlDiv.append(Forms.getHelpSpan(config, config, id));

                group.append(controlDiv);

                // allow control level directives, such as ng-show / ng-hide
                copyElementAttributes(controlDiv, "control-attributes");
                copyElementAttributes(group, "control-group-attributes");

                var scope = config.scope;
                if (scope && modelName) {
                    var onModelChange = function (newValue) {
                        scope.$emit("hawtio.form.modelChange", modelName, newValue);
                    };
                    var fn = onModelChange;

                    // allow custom converters
                    var converterFn = options.valueConverter;
                    if (converterFn) {
                        fn = function () {
                            converterFn(scope, modelName);
                            var newValue = Core.pathGet(scope, modelName);
                            onModelChange(newValue);
                        };
                    }
                    scope.$watch(modelName, fn);
                }
            }
        } else {
            input = $('<div></div>');
            input.attr(Forms.normalize(propTypeName, property, schema), '');

            copyAttributes();

            input.attr('entity', config.getEntity());
            input.attr('mode', config.getMode());

            var fullSchemaName = config.schemaName;
            if (fullSchemaName) {
                input.attr('schema', fullSchemaName);
            }

            if (configScopeName) {
                input.attr('data', configScopeName);
            }

            if (ignorePrefixInLabel || property.ignorePrefixInLabel) {
                input.attr('ignore-prefix-in-label', true);
            }
            input.attr('name', id);
        }

        var label = property.label;
        if (label) {
            input.attr('title', label);
        }

        // TODO check for id in the schema["required"] array too!
        // as required can be specified either via either of these approaches
        /*
        var schema = {
        required: ["foo", "bar"],
        properties: {
        something: {
        required: true,
        type: "string"
        }
        }
        }
        */
        if (property.required) {
            // don't mark checkboxes as required
            if (input[0].localName === "input" && input.attr("type") === "checkbox") {
                // lets not set required on a checkbox, it doesn't make any sense ;)
            } else {
                input.attr('required', 'true');
            }
        }
        return group ? group : input;
    }
    Forms.createWidget = createWidget;

    /**
    * Lets try create the standard angular JS widgets markup
    * @method createStandardWidgetMarkup
    * @param {String} propTypeName
    * @param {any} property
    * @param {any} schema
    * @param {any} config
    * @param {any} options
    * @param {String} id
    */
    function createStandardWidgetMarkup(propTypeName, property, schema, config, options, id) {
        // lets try use standard widgets first...
        var type = Forms.resolveTypeNameAlias(propTypeName, schema);
        if (!type) {
            return '<input type="text"/>';
        }
        var custom = Core.pathGet(property, ["formTemplate"]);
        if (custom) {
            return null;
        }
        var inputElement = Core.pathGet(property, ["input-element"]);
        if (inputElement) {
            return "<" + inputElement + "></" + inputElement + ">";
        }
        var enumValues = Core.pathGet(property, ["enum"]);
        if (enumValues) {
            var required = true;
            var valuesScopeName = null;
            var attributes = "";
            if (enumValues) {
                // calculate from input attributes...
                var scope = config.scope;
                var data = config.data;
                if (data && scope) {
                    // this is a big ugly - would be nice to expose this a bit easier...
                    // maybe nested objects should expose the model easily...
                    var fullSchema = scope[config.schemaName];
                    var model = angular.isString(data) ? scope[data] : data;

                    // now we need to keep walking the model to find the enum values
                    var paths = id.split(".");
                    var property = null;
                    angular.forEach(paths, function (path) {
                        property = Core.pathGet(model, ["properties", path]);
                        var typeName = Core.pathGet(property, ["type"]);
                        var alias = Forms.lookupDefinition(typeName, fullSchema);
                        if (alias) {
                            model = alias;
                        }
                    });
                    var values = Core.pathGet(property, ["enum"]);
                    valuesScopeName = "$values_" + id.replace(/\./g, "_");
                    scope[valuesScopeName] = values;
                }
            }
            if (valuesScopeName) {
                attributes += ' ng-options="value for value in ' + valuesScopeName + '"';
            }
            var defaultOption = required ? "" : '<option value=""></option>';
            return '<select' + attributes + '>' + defaultOption + '</select>';
        }

        if (angular.isArray(type)) {
            // TODO union of tabbed forms such as Marshal / Unmarshal in camel...
            return null;
        }
        if (!angular.isString(type)) {
            return null;
        }
        var defaultValueConverter = null;
        var defaultValue = property.default;
        if (defaultValue) {
            // lets add a default value
            defaultValueConverter = function (scope, modelName) {
                var value = Core.pathGet(scope, modelName);
                if (!value) {
                    Core.pathSet(scope, modelName, property.default);
                }
            };
            options.valueConverter = defaultValueConverter;
        }

        function getModelValueOrDefault(scope, modelName) {
            var value = Core.pathGet(scope, modelName);
            if (!value) {
                var defaultValue = property.default;
                if (defaultValue) {
                    value = defaultValue;
                    Core.pathSet(scope, modelName, value);
                }
            }
            return value;
        }

        switch (type.toLowerCase()) {
            case "int":
            case "integer":
            case "long":
            case "short":
            case "java.lang.integer":
            case "java.lang.long":
            case "float":
            case "double":
            case "java.lang.float":
            case "java.lang.double":
                // lets add a value conversion watcher...
                options.valueConverter = function (scope, modelName) {
                    var value = getModelValueOrDefault(scope, modelName);
                    if (value && angular.isString(value)) {
                        var numberValue = Number(value);
                        Core.pathSet(scope, modelName, numberValue);
                    }
                };
                return '<input type="number"/>';

            case "array":
            case "java.lang.array":
            case "java.lang.iterable":
            case "java.util.list":
            case "java.util.collection":
            case "java.util.iterator":
            case "java.util.set":
            case "object[]":
                // TODO hack for now - objects should not really use the table, thats only really for arrays...
                /*
                case "object":
                case "java.lang.object":
                */
                //return "hawtio-form-array";
                return null;

            case "boolean":
            case "bool":
            case "java.lang.boolean":
                // lets add a value conversion watcher...
                options.valueConverter = function (scope, modelName) {
                    var value = getModelValueOrDefault(scope, modelName);
                    if (value && "true" === value) {
                        //console.log("coercing String to boolean for " + modelName);
                        Core.pathSet(scope, modelName, true);
                    }
                };
                return '<input type="checkbox"/>';

            case "password":
                return '<input type="password"/>';

            case "hidden":
                return '<input type="hidden"/>';
            default:
                // lets check if this name is an alias to a definition in the schema
                return '<input type="text"/>';
        }
    }
    Forms.createStandardWidgetMarkup = createStandardWidgetMarkup;

    function normalize(type, property, schema) {
        type = Forms.resolveTypeNameAlias(type, schema);
        if (!type) {
            return "hawtio-form-text";
        }
        var custom = Core.pathGet(property, ["formTemplate"]);
        if (custom) {
            return "hawtio-form-custom";
        }
        var enumValues = Core.pathGet(property, ["enum"]);
        if (enumValues) {
            // TODO could use different kinds of radio / combo box
            return "hawtio-form-select";
        }

        if (angular.isArray(type)) {
            // TODO union of tabbed forms such as Marshal / Unmarshal in camel...
            return null;
        }
        if (!angular.isString(type)) {
            try  {
                console.log("Unsupported JSON schema type value " + JSON.stringify(type));
            } catch (e) {
                console.log("Unsupported JSON schema type value " + type);
            }
            return null;
        }
        switch (type.toLowerCase()) {
            case "int":
            case "integer":
            case "long":
            case "short":
            case "java.lang.integer":
            case "java.lang.long":
            case "float":
            case "double":
            case "java.lang.float":
            case "java.lang.double":
                return "hawtio-form-number";

            case "array":
            case "java.lang.array":
            case "java.lang.iterable":
            case "java.util.list":
            case "java.util.collection":
            case "java.util.iterator":
            case "java.util.set":
            case "object[]":
                // TODO hack for now - objects should not really use the table, thats only really for arrays...
                /*
                case "object":
                case "java.lang.object":
                */
                var items = property.items;
                if (items) {
                    var typeName = items.type;
                    if (typeName && typeName === "string") {
                        return "hawtio-form-string-array";
                    }
                }
                return "hawtio-form-array";
            case "boolean":
            case "bool":
            case "java.lang.boolean":
                return "hawtio-form-checkbox";
            case "password":
                return "hawtio-form-password";
            case "hidden":
                return "hawtio-form-hidden";
            default:
                // lets check if this name is an alias to a definition in the schema
                return "hawtio-form-text";
        }
    }
    Forms.normalize = normalize;
})(Forms || (Forms = {}));
var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
/**
* @module Forms
*/
var Forms;
(function (Forms) {
    /**
    * @class InputBaseConfig
    */
    var InputBaseConfig = (function () {
        function InputBaseConfig() {
            this.name = 'input';
            this.type = '';
            this.description = '';
            this._default = '';
            this.scope = null;
            // Can also be 'view'
            this.mode = 'edit';
            // the name of the full schema
            this.schemaName = "schema";
            this.controlgroupclass = 'control-group';
            this.controlclass = 'controls';
            this.labelclass = 'control-label';
            this.showtypes = 'false';
            /**
            * Custom template for custom form controls
            * @property
            * @type String
            */
            this.formtemplate = null;
            /**
            * the name of the attribute in the scope which is the data to be edited
            * @property
            * @type String
            */
            this.entity = 'entity';
            /**
            * the model expression to bind to. If omitted this defaults to entity + "." + name
            * @property
            * @type String
            */
            this.model = undefined;
        }
        InputBaseConfig.prototype.getEntity = function () {
            return this.entity || "entity";
        };

        InputBaseConfig.prototype.getMode = function () {
            return this.mode || "edit";
        };

        InputBaseConfig.prototype.isReadOnly = function () {
            return this.getMode() === "view";
        };
        return InputBaseConfig;
    })();
    Forms.InputBaseConfig = InputBaseConfig;

    var InputBase = (function () {
        function InputBase(workspace, $compile) {
            var _this = this;
            this.workspace = workspace;
            this.$compile = $compile;
            this.restrict = 'A';
            this.scope = true;
            this.replace = false;
            this.transclude = false;
            this.attributeName = '';
            // necessary to ensure 'this' is this object <sigh>
            this.link = function (scope, element, attrs) {
                return _this.doLink(scope, element, attrs);
            };
        }
        InputBase.prototype.doLink = function (scope, element, attrs) {
            var config = new InputBaseConfig;
            config = Forms.configure(config, null, attrs);
            config.scope = scope;
            config.schemaName = attrs["schema"] || "schema";

            var id = Forms.safeIdentifier(config.name);
            var group = this.getControlGroup(config, config, id);

            var modelName = config.model;
            if (!angular.isDefined(modelName)) {
                // TODO always use 2 way binding?
                modelName = config.getEntity() + "." + id;
            }

            // allow the prefix to be trimmed from the label
            var defaultLabel = id;
            if ("true" === attrs["ignorePrefixInLabel"]) {
                var idx = id.lastIndexOf('.');
                if (idx > 0) {
                    defaultLabel = id.substring(idx + 1);
                }
            }
            group.append(Forms.getLabel(config, config, attrs["title"] || humanizeValue(defaultLabel)));
            var controlDiv = Forms.getControlDiv(config);
            controlDiv.append(this.getInput(config, config, id, modelName));
            controlDiv.append(Forms.getHelpSpan(config, config, id));
            group.append(controlDiv);
            $(element).append(this.$compile(group)(scope));

            if (scope && modelName) {
                scope.$watch(modelName, onModelChange);
            }
            function onModelChange(newValue) {
                scope.$emit("hawtio.form.modelChange", modelName, newValue);
            }
        };

        InputBase.prototype.getControlGroup = function (config1, config2, id) {
            return Forms.getControlGroup(config1, config2, id);
        };

        InputBase.prototype.getInput = function (config, arg, id, modelName) {
            var rc = $('<span class="form-data"></span>');
            if (modelName) {
                rc.attr('ng-model', modelName);
                rc.append('{{' + modelName + '}}');
            }
            return rc;
        };
        return InputBase;
    })();
    Forms.InputBase = InputBase;

    var TextInput = (function (_super) {
        __extends(TextInput, _super);
        function TextInput(workspace, $compile) {
            _super.call(this, workspace, $compile);
            this.workspace = workspace;
            this.$compile = $compile;
            this.type = "text";
        }
        /*public getControlGroup(config1, config2, id) {
        return super.getControlGroup(config1, config2, id);
        }*/
        TextInput.prototype.getInput = function (config, arg, id, modelName) {
            if (config.isReadOnly()) {
                return _super.prototype.getInput.call(this, config, arg, id, modelName);
            }
            var rc = $('<input type="' + this.type + '">');
            rc.attr('name', id);
            if (modelName) {
                rc.attr('ng-model', modelName);
            }
            if (config.isReadOnly()) {
                rc.attr('readonly', 'true');
            }
            var required = config.$attr["required"];
            if (required && required !== "false") {
                rc.attr('required', 'true');
            }
            return rc;
        };
        return TextInput;
    })(InputBase);
    Forms.TextInput = TextInput;

    var HiddenText = (function (_super) {
        __extends(HiddenText, _super);
        function HiddenText(workspace, $compile) {
            _super.call(this, workspace, $compile);
            this.workspace = workspace;
            this.$compile = $compile;
            this.type = "hidden";
        }
        HiddenText.prototype.getControlGroup = function (config1, config2, id) {
            var group = _super.prototype.getControlGroup.call(this, config1, config2, id);
            group.css({ 'display': 'none' });
            return group;
        };

        HiddenText.prototype.getInput = function (config, arg, id, modelName) {
            var rc = _super.prototype.getInput.call(this, config, arg, id, modelName);
            rc.attr('readonly', 'true');
            return rc;
        };
        return HiddenText;
    })(TextInput);
    Forms.HiddenText = HiddenText;

    var PasswordInput = (function (_super) {
        __extends(PasswordInput, _super);
        function PasswordInput(workspace, $compile) {
            _super.call(this, workspace, $compile);
            this.workspace = workspace;
            this.$compile = $compile;
            this.type = "password";
        }
        return PasswordInput;
    })(TextInput);
    Forms.PasswordInput = PasswordInput;

    var CustomInput = (function (_super) {
        __extends(CustomInput, _super);
        function CustomInput(workspace, $compile) {
            _super.call(this, workspace, $compile);
            this.workspace = workspace;
            this.$compile = $compile;
        }
        CustomInput.prototype.getInput = function (config, arg, id, modelName) {
            var template = arg.formtemplate;
            template = Core.unescapeHtml(template);
            var rc = $(template);
            if (!rc.attr("name")) {
                rc.attr('name', id);
            }
            if (modelName) {
                rc.attr('ng-model', modelName);
            }
            if (config.isReadOnly()) {
                rc.attr('readonly', 'true');
            }
            return rc;
        };
        return CustomInput;
    })(InputBase);
    Forms.CustomInput = CustomInput;

    var SelectInput = (function (_super) {
        __extends(SelectInput, _super);
        function SelectInput(workspace, $compile) {
            _super.call(this, workspace, $compile);
            this.workspace = workspace;
            this.$compile = $compile;
        }
        SelectInput.prototype.getInput = function (config, arg, id, modelName) {
            if (config.isReadOnly()) {
                return _super.prototype.getInput.call(this, config, arg, id, modelName);
            }

            // TODO calculate from input attributes...
            var required = true;

            // TODO we could configure the null option...
            var defaultOption = required ? "" : '<option value=""></option>';
            var rc = $('<select>' + defaultOption + '</select>');
            rc.attr('name', id);

            var scope = config.scope;
            var data = config.data;
            if (data && scope) {
                // this is a big ugly - would be nice to expose this a bit easier...
                // maybe nested objects should expose the model easily...
                var fullSchema = scope[config.schemaName];
                var model = scope[data];

                // now we need to keep walking the model to find the enum values
                var paths = id.split(".");
                var property = null;
                angular.forEach(paths, function (path) {
                    property = Core.pathGet(model, ["properties", path]);
                    var typeName = Core.pathGet(property, ["type"]);
                    var alias = Forms.lookupDefinition(typeName, fullSchema);
                    if (alias) {
                        model = alias;
                    }
                });
                var values = Core.pathGet(property, ["enum"]);
                scope["$selectValues"] = values;
                rc.attr("ng-options", "value for value in $selectValues");
            }
            if (modelName) {
                rc.attr('ng-model', modelName);
            }
            if (config.isReadOnly()) {
                rc.attr('readonly', 'true');
            }
            return rc;
        };
        return SelectInput;
    })(InputBase);
    Forms.SelectInput = SelectInput;

    var NumberInput = (function (_super) {
        __extends(NumberInput, _super);
        function NumberInput(workspace, $compile) {
            _super.call(this, workspace, $compile);
            this.workspace = workspace;
            this.$compile = $compile;
        }
        NumberInput.prototype.getInput = function (config, arg, id, modelName) {
            if (config.isReadOnly()) {
                return _super.prototype.getInput.call(this, config, arg, id, modelName);
            }
            var rc = $('<input type="number">');
            rc.attr('name', id);

            if (angular.isDefined(arg.def)) {
                rc.attr('value', arg.def);
            }

            if (angular.isDefined(arg.minimum)) {
                rc.attr('min', arg.minimum);
            }

            if (angular.isDefined(arg.maximum)) {
                rc.attr('max', arg.maximum);
            }

            if (modelName) {
                rc.attr('ng-model', modelName);
            }
            if (config.isReadOnly()) {
                rc.attr('readonly', 'true');
            }

            // lets coerce any string values to numbers so that they work properly with the UI
            var scope = config.scope;
            if (scope) {
                function onModelChange() {
                    var value = Core.pathGet(scope, modelName);
                    if (value && angular.isString(value)) {
                        var numberValue = Number(value);
                        Core.pathSet(scope, modelName, numberValue);
                    }
                }
                scope.$watch(modelName, onModelChange);
                onModelChange();
            }
            return rc;
        };
        return NumberInput;
    })(InputBase);
    Forms.NumberInput = NumberInput;

    /**
    * Generates a list of strings which can be added / edited / removed
    * @class StringArrayInput
    */
    var StringArrayInput = (function (_super) {
        __extends(StringArrayInput, _super);
        function StringArrayInput(workspace, $compile) {
            _super.call(this, workspace, $compile);
            this.workspace = workspace;
            this.$compile = $compile;
        }
        StringArrayInput.prototype.getInput = function (config, arg, id, modelName) {
            var rowScopeName = "_" + id;
            var ngRepeat = rowScopeName + ' in ' + modelName;

            var readOnlyWidget = '{{' + rowScopeName + '}}';
            if (config.isReadOnly()) {
                return $('<ul><li ng-repeat="' + rowScopeName + ' in ' + modelName + '">' + readOnlyWidget + '</li></ul>');
            } else {
                // TODO there should be an easier way to find the property / schema!
                var scope = config.scope;
                var fallbackSchemaName = (arg.$attr || {})["schema"] || "schema";
                var schema = scope[config.schemaName] || scope[fallbackSchemaName] || {};
                var properties = schema.properties || {};
                var arrayProperty = properties[id] || {};

                // lets refer to the property of the item, rather than the array
                var property = arrayProperty["items"] || {};
                var propTypeName = property.type;
                var ignorePrefixInLabel = true;
                var configScopeName = null;

                // lets create an empty array if its not yet set
                var value = Core.pathGet(scope, modelName);
                if (!value) {
                    Core.pathSet(scope, modelName, []);
                }

                var methodPrefix = "_form_stringArray" + rowScopeName + "_";
                var itemKeys = methodPrefix + "keys";
                var addMethod = methodPrefix + "add";
                var removeMethod = methodPrefix + "remove";

                // we maintain a separate object of all the keys (indices) of the array
                // and use that to lookup the values
                function updateKeys() {
                    var value = Core.pathGet(scope, modelName);
                    scope[itemKeys] = value ? Object.keys(value) : [];
                    scope.$emit("hawtio.form.modelChange", modelName, value);
                }

                updateKeys();

                scope[addMethod] = function () {
                    var value = Core.pathGet(scope, modelName) || [];
                    value.push("");
                    Core.pathSet(scope, modelName, value);
                    updateKeys();
                };
                scope[removeMethod] = function (idx) {
                    var value = Core.pathGet(scope, modelName) || [];
                    if (idx < value.length) {
                        value.splice(idx, 1);
                    }
                    Core.pathSet(scope, modelName, value);
                    updateKeys();
                };

                // the expression for an item value
                var itemId = modelName + "[" + rowScopeName + "]";
                var itemsConfig = {
                    model: itemId
                };
                var widget = Forms.createWidget(propTypeName, property, schema, itemsConfig, itemId, ignorePrefixInLabel, configScopeName, false);
                if (!widget) {
                    widget = $(readOnlyWidget);
                }
                var markup = $('<div style="white-space: nowrap" ng-repeat="' + rowScopeName + ' in ' + itemKeys + '"></div>');
                markup.append(widget);
                markup.append($('<a ng-click="' + removeMethod + '(' + rowScopeName + ')" title="Remove this value"><i class="red icon-remove"></i></a>'));
                markup.after($('<a ng-click="' + addMethod + '()" title="Add a new value"><i class="icon-plus"></i></a>'));
                return markup;
            }
        };
        return StringArrayInput;
    })(InputBase);
    Forms.StringArrayInput = StringArrayInput;

    var ArrayInput = (function (_super) {
        __extends(ArrayInput, _super);
        function ArrayInput(workspace, $compile) {
            _super.call(this, workspace, $compile);
            this.workspace = workspace;
            this.$compile = $compile;
        }
        ArrayInput.prototype.doLink = function (scope, element, attrs) {
            var config = new InputBaseConfig;
            config = Forms.configure(config, null, attrs);

            var id = config.name;
            var dataName = attrs["data"] || "";
            var entityName = attrs["entity"] || config.entity;
            var schemaName = attrs["schema"] || config.schemaName;

            function renderRow(cell, type, data) {
                if (data) {
                    var description = data["description"];
                    if (!description) {
                        angular.forEach(data, function (value, key) {
                            if (value && !description) {
                                description = value;
                            }
                        });
                    }
                    return description;
                }
                return null;
            }

            // Had to fudge some of this
            // create a table UI!
            var tableConfigPaths = ["properties", id, "inputTable"];

            //var scope = config.scope;
            var tableConfig = null;
            Core.pathGet(scope, tableConfigPaths);

            // lets auto-create a default configuration if there is none
            if (!tableConfig) {
                // TODO ideally we should merge this config with whatever folks have hand-defined
                var tableConfigScopeName = tableConfigPaths.join(".");

                //var cellDescription = a["description"] || humanizeValue(id);
                var cellDescription = humanizeValue(id);
                tableConfig = {
                    formConfig: config,
                    title: cellDescription,
                    data: config.entity + "." + id,
                    displayFooter: false,
                    showFilter: false,
                    columnDefs: [
                        {
                            field: '_id',
                            displayName: cellDescription,
                            render: renderRow
                        }
                    ]
                };
                Core.pathSet(scope, tableConfigPaths, tableConfig);
            }
            var table = $('<div hawtio-input-table="' + tableConfigScopeName + '" data="' + dataName + '" property="' + id + '" entity="' + entityName + '" schema="' + schemaName + '"></div>');
            if (config.isReadOnly()) {
                table.attr("readonly", "true");
            }
            $(element).append(this.$compile(table)(scope));
        };
        return ArrayInput;
    })(InputBase);
    Forms.ArrayInput = ArrayInput;

    var BooleanInput = (function (_super) {
        __extends(BooleanInput, _super);
        function BooleanInput(workspace, $compile) {
            _super.call(this, workspace, $compile);
            this.workspace = workspace;
            this.$compile = $compile;
        }
        BooleanInput.prototype.getInput = function (config, arg, id, modelName) {
            var rc = $('<input class="hawtio-checkbox" type="checkbox">');
            rc.attr('name', id);

            if (config.isReadOnly()) {
                rc.attr('disabled', 'true');
            }
            if (modelName) {
                rc.attr('ng-model', modelName);
            }
            if (config.isReadOnly()) {
                rc.attr('readonly', 'true');
            }

            // lets coerce any string values to boolean so that they work properly with the UI
            var scope = config.scope;
            if (scope) {
                function onModelChange() {
                    var value = Core.pathGet(scope, modelName);
                    if (value && "true" === value) {
                        //console.log("coercing String to boolean for " + modelName);
                        Core.pathSet(scope, modelName, true);
                    }
                }
                scope.$watch(modelName, onModelChange);
                onModelChange();
            }
            return rc;
        };
        return BooleanInput;
    })(InputBase);
    Forms.BooleanInput = BooleanInput;
})(Forms || (Forms = {}));
/**
* @module DataTable
*/
var DataTable;
(function (DataTable) {
    var SimpleDataTable = (function () {
        function SimpleDataTable($compile) {
            var _this = this;
            this.$compile = $compile;
            this.restrict = 'A';
            this.scope = {
                config: '=hawtioSimpleTable',
                target: '@',
                showFiles: '@'
            };
            // necessary to ensure 'this' is this object <sigh>
            this.link = function ($scope, $element, $attrs) {
                return _this.doLink($scope, $element, $attrs);
            };
        }
        SimpleDataTable.prototype.doLink = function ($scope, $element, $attrs) {
            var defaultPrimaryKeyFn = function (entity, idx) {
                // default function to use id/_id/name as primary key, and fallback to use index
                return entity["id"] || entity["_id"] || entity["name"] || idx;
            };

            var config = $scope.config;

            var dataName = config.data || "data";

            // need to remember which rows has been selected as the config.data / config.selectedItems
            // so we can re-select them when data is changed/updated, and entity may be new instances
            // so we need a primary key function to generate a 'primary key' of the entity
            var primaryKeyFn = config.primaryKeyFn || defaultPrimaryKeyFn;
            $scope.rows = [];

            var scope = $scope.$parent || $scope;

            var listener = function (otherValue) {
                var value = Core.pathGet(scope, dataName);
                if (value && !angular.isArray(value)) {
                    value = [value];
                    Core.pathSet(scope, dataName, value);
                }

                if (!('sortInfo' in config)) {
                    config['sortInfo'] = {
                        sortBy: config.columnDefs.first()['field'],
                        ascending: true
                    };
                }

                var sortInfo = $scope.config.sortInfo;

                // enrich the rows with information about their index
                var idx = -1;
                $scope.rows = (value || []).sortBy(sortInfo.sortBy, !sortInfo.ascending).map(function (entity) {
                    idx++;
                    return {
                        entity: entity,
                        index: idx,
                        getProperty: function (name) {
                            return entity[name];
                        }
                    };
                });

                Core.pathSet(scope, ['hawtioSimpleTable', dataName, 'rows'], $scope.rows);

                // okay the data was changed/updated so we need to re-select previously selected items
                // and for that we need to evaluate the primary key function so we can match new data with old data.
                var reSelectedItems = [];
                $scope.rows.forEach(function (row, idx) {
                    var rpk = primaryKeyFn(row.entity, row.index);
                    var selected = config.selectedItems.some(function (s) {
                        var spk = primaryKeyFn(s, s.index);
                        return angular.equals(rpk, spk);
                    });
                    if (selected) {
                        // need to enrich entity with index, as we push row.entity to the re-selected items
                        row.entity.index = row.index;
                        reSelectedItems.push(row.entity);
                        DataTable.log.debug("Data changed so keep selecting row at index " + row.index);
                    }
                });
                config.selectedItems = reSelectedItems;
            };

            scope.$watch(dataName, listener);

            // lets add a separate event so we can force updates
            // if we find cases where the delta logic doesn't work
            // (such as for nested hawtioinput-input-table)
            scope.$on("hawtio.datatable." + dataName, listener);

            function getSelectionArray() {
                var selectionArray = config.selectedItems;
                if (!selectionArray) {
                    selectionArray = [];
                    config.selectedItems = selectionArray;
                }
                if (angular.isString(selectionArray)) {
                    var name = selectionArray;
                    selectionArray = Core.pathGet(scope, name);
                    if (!selectionArray) {
                        selectionArray = [];
                        scope[name] = selectionArray;
                    }
                }
                return selectionArray;
            }

            function isMultiSelect() {
                var multiSelect = $scope.config.multiSelect;
                if (angular.isUndefined(multiSelect)) {
                    multiSelect = true;
                }
                return multiSelect;
            }

            $scope.toggleAllSelections = function () {
                var allRowsSelected = $scope.config.allRowsSelected;
                var newFlag = allRowsSelected;
                var selectionArray = getSelectionArray();
                selectionArray.splice(0, selectionArray.length);
                angular.forEach($scope.rows, function (row) {
                    row.selected = newFlag;
                    if (allRowsSelected) {
                        selectionArray.push(row.entity);
                    }
                });
            };

            $scope.toggleRowSelection = function (row) {
                if (row) {
                    var selectionArray = getSelectionArray();
                    if (!isMultiSelect()) {
                        // lets clear all other selections
                        selectionArray.splice(0, selectionArray.length);
                        angular.forEach($scope.rows, function (r) {
                            if (r !== row) {
                                r.selected = false;
                            }
                        });
                    }
                    var entity = row.entity;
                    if (entity) {
                        var idx = selectionArray.indexOf(entity);
                        if (row.selected) {
                            if (idx < 0) {
                                selectionArray.push(entity);
                            }
                        } else {
                            // clear the all selected checkbox
                            $scope.config.allRowsSelected = false;
                            if (idx >= 0) {
                                selectionArray.splice(idx, 1);
                            }
                        }
                    }
                }
            };

            $scope.sortBy = function (field) {
                if ($scope.config.sortInfo.sortBy === field) {
                    $scope.config.sortInfo.ascending = !$scope.config.sortInfo.ascending;
                } else {
                    $scope.config.sortInfo.sortBy = field;
                    $scope.config.sortInfo.ascending = true;
                }
                $scope.$emit("hawtio.datatable." + dataName);
            };

            $scope.getClass = function (field) {
                if ('sortInfo' in $scope.config) {
                    if ($scope.config.sortInfo.sortBy === field) {
                        if ($scope.config.sortInfo.ascending) {
                            return 'asc';
                        } else {
                            return 'desc';
                        }
                    }
                }

                return '';
            };

            $scope.showRow = function (row) {
                var filter = Core.pathGet($scope, ['config', 'filterOptions', 'filterText']);
                if (Core.isBlank(filter)) {
                    return true;
                }
                var rowJson = angular.toJson(row);
                return rowJson.toLowerCase().has(filter.toLowerCase());
            };

            $scope.isSelected = function (row) {
                return config.selectedItems.some(row.entity);
            };

            $scope.onRowSelected = function (row) {
                var idx = config.selectedItems.indexOf(row.entity);
                if (idx >= 0) {
                    DataTable.log.debug("De-selecting row at index " + row.index);
                    config.selectedItems.splice(idx, 1);
                } else {
                    if (!config.multiSelect) {
                        config.selectedItems = [];
                    }
                    DataTable.log.debug("Selecting row at index " + row.index);

                    // need to enrich entity with index, as we push row.entity to the selected items
                    row.entity.index = row.index;
                    config.selectedItems.push(row.entity);
                }
            };

            // lets add the header and row cells
            var rootElement = $element;
            rootElement.empty();

            var showCheckBox = firstValueDefined(config, ["showSelectionCheckbox", "displaySelectionCheckbox"], true);
            var enableRowClickSelection = firstValueDefined(config, ["enableRowClickSelection"], false);

            var onMouseDown;
            if (enableRowClickSelection) {
                onMouseDown = "ng-mousedown='onRowSelected(row)' ";
            } else {
                onMouseDown = "";
            }
            var headHtml = "<thead><tr>";

            // use a function to check if a row is selected so the UI can be kept up to date asap
            var bodyHtml = "<tbody><tr ng-repeat='row in rows track by $index' ng-show='showRow(row)' " + onMouseDown + "ng-class=\"{'selected': isSelected(row)}\" >";
            var idx = 0;
            if (showCheckBox) {
                var toggleAllHtml = isMultiSelect() ? "<input type='checkbox' ng-show='rows.length' ng-model='config.allRowsSelected' ng-change='toggleAllSelections()'>" : "";

                headHtml += "\n<th>" + toggleAllHtml + "</th>";
                bodyHtml += "\n<td><input type='checkbox' ng-model='row.selected' ng-change='toggleRowSelection(row)'></td>";
            }
            angular.forEach(config.columnDefs, function (colDef) {
                var field = colDef.field;
                var cellTemplate = colDef.cellTemplate || '<div class="ngCellText" title="{{row.entity.' + field + '}}">{{row.entity.' + field + '}}</div>';

                headHtml += "\n<th class='clickable no-fade table-header' ng-click=\"sortBy('" + field + "')\" ng-class=\"getClass('" + field + "')\">{{config.columnDefs[" + idx + "].displayName}}<span class='indicator'></span></th>";

                bodyHtml += "\n<td>" + cellTemplate + "</td>";
                idx += 1;
            });
            var html = headHtml + "\n</tr></thead>\n" + bodyHtml + "\n</tr></tbody>";

            var newContent = this.$compile(html)($scope);
            rootElement.html(newContent);
        };
        return SimpleDataTable;
    })();
    DataTable.SimpleDataTable = SimpleDataTable;

    /**
    * Returns the first property value defined in the given object or the default value if none are defined
    *
    * @param object the object to look for properties
    * @param names the array of property names to look for
    * @param defaultValue the value if no property values are defined
    * @return {*} the first defined property value or the defaultValue if none are defined
    */
    function firstValueDefined(object, names, defaultValue) {
        var answer = defaultValue;
        var found = false;
        angular.forEach(names, function (name) {
            var value = object[name];
            if (!found && angular.isDefined(value)) {
                answer = value;
                found = true;
            }
        });
        return answer;
    }
})(DataTable || (DataTable = {}));
/**
* @module DataTable
*/
var DataTable;
(function (DataTable) {
    /**
    * @class TableWidget
    */
    // TODO would make sense to move this to UI
    var TableWidget = (function () {
        function TableWidget(scope, $templateCache, $compile, dataTableColumns, config) {
            if (typeof config === "undefined") { config = {}; }
            var _this = this;
            this.scope = scope;
            this.$templateCache = $templateCache;
            this.$compile = $compile;
            this.dataTableColumns = dataTableColumns;
            this.config = config;
            this.ignoreColumnHash = {};
            this.flattenColumnHash = {};
            this.detailTemplate = null;
            this.openMessages = [];
            this.addedExpandNodes = false;
            this.tableElement = null;
            this.sortColumns = null;
            this.dataTableConfig = {
                bPaginate: false,
                sDom: 'Rlfrtip',
                bDestroy: true,
                bAutoWidth: true
            };
            // the jQuery DataTable widget
            this.dataTable = null;
            // TODO is there an easier way of turning an array into a hash to true so it acts as a hash?
            angular.forEach(config.ignoreColumns, function (name) {
                _this.ignoreColumnHash[name] = true;
            });
            angular.forEach(config.flattenColumns, function (name) {
                _this.flattenColumnHash[name] = true;
            });

            var templateId = config.rowDetailTemplateId;
            if (templateId) {
                this.detailTemplate = this.$templateCache.get(templateId);
            }
        }
        /**
        * Adds new data to the table
        * @method addData
        * @for TableWidget
        * @param {Object} newData
        */
        TableWidget.prototype.addData = function (newData) {
            var dataTable = this.dataTable;
            dataTable.fnAddData(newData);
        };

        /**
        * Populates the table with the given data
        * @method populateTable
        * @for TableWidget
        * @param {Object} data
        */
        TableWidget.prototype.populateTable = function (data) {
            var _this = this;
            var $scope = this.scope;

            if (!data) {
                $scope.messages = [];
            } else {
                $scope.messages = data;

                var formatMessageDetails = function (dataTable, parentRow) {
                    var oData = dataTable.fnGetData(parentRow);
                    var div = $('<div>');
                    div.addClass('innerDetails');
                    _this.populateDetailDiv(oData, div);
                    return div;
                };

                var array = data;
                if (angular.isArray(data)) {
                } else if (angular.isObject(data)) {
                    array = [];
                    angular.forEach(data, function (object) {
                        return array.push(object);
                    });
                }

                var tableElement = this.tableElement;
                if (!tableElement) {
                    tableElement = $('#grid');
                }
                var tableTr = Core.getOrCreateElements(tableElement, ["thead", "tr"]);
                var tableBody = Core.getOrCreateElements(tableElement, ["tbody"]);
                var ths = $(tableTr).find("th");

                // lets add new columns based on the data...
                // TODO wont compile in TypeScript!
                //var columns = this.dataTableColumns.slice();
                var columns = [];
                angular.forEach(this.dataTableColumns, function (value) {
                    return columns.push(value);
                });

                //var columns = this.dataTableColumns.slice();
                var addColumn = function (key, title) {
                    columns.push({
                        "sDefaultContent": "",
                        "mData": null,
                        mDataProp: key
                    });

                    // lets see if we need to add another <th>
                    if (tableTr) {
                        $("<th>" + title + "</th>").appendTo(tableTr);
                    }
                };

                var checkForNewColumn = function (value, key, prefix) {
                    // lets check if we have a column data for it (if its not ignored)
                    //var keyName: string = key.toString();
                    //var config: Object = {mDataProp: key};
                    var found = _this.ignoreColumnHash[key] || columns.any(function (k, v) {
                        return "mDataProp" === k && v === key;
                    });

                    //var found = this.ignoreColumnHash[key] || columns.any(config);
                    if (!found) {
                        // lets check if its a flatten column
                        if (_this.flattenColumnHash[key]) {
                            // TODO so this only works on the first row - sucks! :)
                            if (angular.isObject(value)) {
                                var childPrefix = prefix + key + ".";
                                angular.forEach(value, function (value, key) {
                                    return checkForNewColumn(value, key, childPrefix);
                                });
                            }
                        } else {
                            addColumn(prefix + key, humanizeValue(key));
                        }
                    }
                };

                if (!this.config.disableAddColumns && angular.isArray(array) && array.length > 0) {
                    var first = array[0];
                    if (angular.isObject(first)) {
                        angular.forEach(first, function (value, key) {
                            return checkForNewColumn(value, key, "");
                        });
                    }
                }

                // lets default to column 1 sorting if there's no property on column 1 for expansion
                if (columns.length > 1) {
                    var col0 = columns[0];
                    if (!this.sortColumns && !col0["mDataProp"] && !col0["mData"]) {
                        var sortOrder = [[1, "asc"]];
                        this.sortColumns = sortOrder;
                    }
                }
                if (array.length && !angular.isArray(array[0])) {
                    //this.dataTableConfig["aoData"] = array;
                    this.dataTableConfig["aaData"] = array;
                } else {
                    this.dataTableConfig["aaData"] = array;
                }
                this.dataTableConfig["aoColumns"] = columns;
                if (this.sortColumns) {
                    this.dataTableConfig["aaSorting"] = this.sortColumns;
                }

                if (this.dataTable) {
                    this.dataTable.fnClearTable(false);
                    this.dataTable.fnAddData(array);
                    this.dataTable.fnDraw();
                    // lets try update it...
                } else {
                    this.dataTable = tableElement.dataTable(this.dataTableConfig);
                }

                var widget = this;

                if (this.dataTable) {
                    var keys = new KeyTable({
                        "table": tableElement[0],
                        "datatable": this.dataTable
                    });
                    keys.fnSetPosition(0, 0);

                    if (angular.isArray(data) && data.length) {
                        var selected = data[0];
                        var selectHandler = widget.config.selectHandler;
                        if (selected && selectHandler) {
                            selectHandler(selected);
                        }
                    }
                }

                // lets try focus on the table
                $(tableElement).focus();

                var widget = this;

                // add a handler for the expand/collapse column for all rows (and future rows)
                var expandCollapseNode = function () {
                    var dataTable = widget.dataTable;
                    var parentRow = this.parentNode;
                    var openMessages = widget.openMessages;
                    var i = $.inArray(parentRow, openMessages);

                    var element = $('i', this);
                    if (i === -1) {
                        element.removeClass('icon-plus');
                        element.addClass('icon-minus');
                        var dataDiv = formatMessageDetails(dataTable, parentRow);
                        var detailsRow = $(dataTable.fnOpen(parentRow, dataDiv, 'details'));
                        detailsRow.css("padding", "0");

                        setTimeout(function () {
                            detailsRow.find(".innerDetails").slideDown(400, function () {
                                $(parentRow).addClass('opened');
                                openMessages.push(parentRow);
                            });
                        }, 20);
                    } else {
                        $(parentRow.nextSibling).find(".innerDetails").slideUp(400, function () {
                            $(parentRow).removeClass('opened');
                            element.removeClass('icon-minus');
                            element.addClass('icon-plus');
                            dataTable.fnClose(parentRow);
                            openMessages.splice(i, 1);
                        });
                    }

                    // lets let angular render any new detail templates
                    Core.$apply($scope);
                };

                if (!this.addedExpandNodes) {
                    this.addedExpandNodes = true;

                    $(tableElement).on("click", "td.control", expandCollapseNode);

                    //$(document).on("click", "#grid td.control", expandCollapseNode);
                    keys.event.action(0, null, function (node) {
                        expandCollapseNode.call(node);
                    });
                }

                keys.event.focus(null, null, function (node) {
                    var dataTable = widget.dataTable;
                    var row = node;
                    if (node) {
                        var nodeName = node.nodeName;
                        if (nodeName) {
                            if (nodeName.toLowerCase() === "td") {
                                row = $(node).parents("tr")[0];
                            }
                            var selected = dataTable.fnGetData(row);
                            var selectHandler = widget.config.selectHandler;
                            if (selected && selectHandler) {
                                selectHandler(selected);
                            }
                        }
                    }
                });

                // $(document).on("click", "#grid td", function () {
                $(tableElement).find("td.control").on("click", function (event) {
                    var dataTable = widget.dataTable;
                    if ($(this).hasClass('selected')) {
                        $(this).removeClass('focus selected');
                    } else {
                        if (!widget.config.multiSelect) {
                            dataTable.$('td.selected').removeClass('focus selected');
                        }
                        $(this).addClass('focus selected');

                        var row = $(this).parents("tr")[0];
                        var selected = dataTable.fnGetData(row);
                        var selectHandler = widget.config.selectHandler;
                        if (selected && selectHandler) {
                            selectHandler(selected);
                        }
                    }
                });
            }
            Core.$apply($scope);
        };

        TableWidget.prototype.populateDetailDiv = function (row, div) {
            // lets remove the silly "0" property that gets shoved in there due to the expand/collapse row
            delete row["0"];
            var scope = this.scope.$new();
            scope.row = row;
            scope.templateDiv = div;
            var template = this.detailTemplate;
            if (!template) {
                var templateId = this.config.rowDetailTemplateId;
                if (templateId) {
                    this.detailTemplate = this.$templateCache.get(templateId);
                    template = this.detailTemplate;
                }
            }
            if (template) {
                div.html(template);
                this.$compile(div.contents())(scope);
            }
        };
        return TableWidget;
    })();
    DataTable.TableWidget = TableWidget;
})(DataTable || (DataTable = {}));
/**
* @module DataTable
* @main DataTable
*/
var DataTable;
(function (DataTable) {
    var pluginName = 'datatable';
    DataTable.log = Logger.get("DataTable");

    angular.module(pluginName, ['bootstrap', 'ngResource']).config(function ($routeProvider) {
        $routeProvider.when('/datatable/test', { templateUrl: 'app/datatable/html/test.html' });
    }).directive('hawtioSimpleTable', function ($compile) {
        return new DataTable.SimpleDataTable($compile);
    }).directive('hawtioDatatable', function ($templateCache, $compile, $timeout, $filter) {
        // return the directive link function. (compile function not needed)
        return function (scope, element, attrs) {
            var gridOptions = null;
            var data = null;
            var widget = null;
            var timeoutId = null;
            var initialised = false;
            var childScopes = [];
            var rowDetailTemplate = null;
            var rowDetailTemplateId = null;
            var selectedItems = null;

            // used to update the UI
            function updateGrid() {
                // console.log("updating the grid!!");
                Core.$applyNowOrLater(scope);
            }

            function convertToDataTableColumn(columnDef) {
                var data = {
                    mData: columnDef.field,
                    sDefaultContent: ""
                };
                var name = columnDef.displayName;
                if (name) {
                    data["sTitle"] = name;
                }
                var width = columnDef.width;
                if (angular.isNumber(width)) {
                    data["sWidth"] = "" + width + "px";
                } else if (angular.isString(width) && !width.startsWith("*")) {
                    data["sWidth"] = width;
                }
                var template = columnDef.cellTemplate;
                if (template) {
                    data["fnCreatedCell"] = function (nTd, sData, oData, iRow, iCol) {
                        var childScope = childScopes[iRow];
                        if (!childScope) {
                            childScope = scope.$new(false);
                            childScopes[iRow] = childScope;
                        }
                        var entity = oData;
                        childScope["row"] = {
                            entity: entity,
                            getProperty: function (name) {
                                return entity[name];
                            }
                        };

                        var elem = $(nTd);
                        elem.html(template);
                        var contents = elem.contents();
                        contents.removeClass("ngCellText");
                        $compile(contents)(childScope);
                    };
                } else {
                    var cellFilter = columnDef.cellFilter;
                    var render = columnDef.render;
                    if (cellFilter && !render) {
                        var filter = $filter(cellFilter);
                        if (filter) {
                            render = function (data, type, full) {
                                return filter(data);
                            };
                        }
                    }
                    if (render) {
                        data["mRender"] = render;
                    }
                }
                return data;
            }

            function destroyChildScopes() {
                angular.forEach(childScopes, function (childScope) {
                    childScope.$destroy();
                });
                childScopes = [];
            }

            function selectHandler(selection) {
                if (selection && selectedItems) {
                    selectedItems.splice(0, selectedItems.length);
                    selectedItems.push(selection);
                    Core.$apply(scope);
                }
            }

            function onTableDataChange(value) {
                gridOptions = value;
                if (gridOptions) {
                    selectedItems = gridOptions.selectedItems;
                    rowDetailTemplate = gridOptions.rowDetailTemplate;
                    rowDetailTemplateId = gridOptions.rowDetailTemplateId;

                    // TODO deal with updating the gridOptions on the fly?
                    if (widget === null) {
                        var widgetOptions = {
                            selectHandler: selectHandler,
                            disableAddColumns: true,
                            rowDetailTemplateId: rowDetailTemplateId,
                            ignoreColumns: gridOptions.ignoreColumns,
                            flattenColumns: gridOptions.flattenColumns
                        };

                        // lets find a child table element
                        // or lets add one if there's not one already
                        var rootElement = $(element);
                        var tableElement = rootElement.children("table");
                        if (!tableElement.length) {
                            $("<table class='table table-bordered table-condensed'></table>").appendTo(rootElement);
                            tableElement = rootElement.children("table");
                        }
                        tableElement.removeClass('table-striped');
                        tableElement.addClass('dataTable');
                        var trElement = Core.getOrCreateElements(tableElement, ["thead", "tr"]);

                        destroyChildScopes();

                        // convert the column configurations
                        var columns = [];
                        var columnCounter = 1;
                        var extraLeftColumn = rowDetailTemplate || rowDetailTemplateId;
                        if (extraLeftColumn) {
                            columns.push({
                                "mDataProp": null,
                                "sClass": "control center",
                                "sWidth": "30px",
                                "sDefaultContent": '<i class="icon-plus"></i>'
                            });

                            var th = trElement.children("th");
                            if (th.length < columnCounter++) {
                                $("<th></th>").appendTo(trElement);
                            }
                        }

                        var columnDefs = gridOptions.columnDefs;
                        if (angular.isString(columnDefs)) {
                            // TODO watch this value?
                            columnDefs = scope[columnDefs];
                        }

                        angular.forEach(columnDefs, function (columnDef) {
                            // if there's not another <tr> then lets add one
                            th = trElement.children("th");
                            if (th.length < columnCounter++) {
                                var name = columnDef.displayName || "";
                                $("<th>" + name + "</th>").appendTo(trElement);
                            }
                            columns.push(convertToDataTableColumn(columnDef));
                        });
                        widget = new DataTable.TableWidget(scope, $templateCache, $compile, columns, widgetOptions);
                        widget.tableElement = tableElement;

                        var sortInfo = gridOptions.sortInfo;
                        if (sortInfo && columnDefs) {
                            var sortColumns = [];
                            var field = sortInfo.field;
                            if (field) {
                                var idx = columnDefs.findIndex({ field: field });
                                if (idx >= 0) {
                                    if (extraLeftColumn) {
                                        idx += 1;
                                    }
                                    var asc = sortInfo.direction || "asc";
                                    asc = asc.toLowerCase();
                                    sortColumns.push([idx, asc]);
                                }
                            }
                            if (sortColumns.length) {
                                widget.sortColumns = sortColumns;
                            }
                        }

                        // if all the column definitions have an sWidth then lets turn off
                        // the auto-width calculations
                        if (columns.every(function (col) {
                            return col.sWidth;
                        })) {
                            widget.dataTableConfig.bAutoWidth = false;
                        }

                        /*
                        // lets avoid word wrap
                        widget.dataTableConfig["fnCreatedRow"] = function( nRow, aData, iDataIndex ) {
                        var cells = $(nRow).children("td");
                        cells.css("overflow", "hidden");
                        cells.css("white-space", "nowrap");
                        cells.css("text-overflow", "ellipsis");
                        };
                        */
                        var filterText = null;
                        var filterOptions = gridOptions.filterOptions;
                        if (filterOptions) {
                            filterText = filterOptions.filterText;
                        }
                        if (filterText || (angular.isDefined(gridOptions.showFilter) && !gridOptions.showFilter)) {
                            // disable the text filter box
                            widget.dataTableConfig.sDom = 'Rlrtip';
                        }
                        if (filterText) {
                            scope.$watch(filterText, function (value) {
                                var dataTable = widget.dataTable;
                                if (dataTable) {
                                    dataTable.fnFilter(value);
                                }
                            });
                        }
                        if (angular.isDefined(gridOptions.displayFooter) && !gridOptions.displayFooter && widget.dataTableConfig.sDom) {
                            // remove the footer
                            widget.dataTableConfig.sDom = widget.dataTableConfig.sDom.replace('i', '');
                        }
                        // TODO....
                        // lets make sure there is enough th headers for the columns!
                    }
                    if (!data) {
                        // TODO deal with the data name changing one day?
                        data = gridOptions.data;
                        if (data) {
                            var listener = function (value) {
                                if (initialised || (value && (!angular.isArray(value) || value.length))) {
                                    initialised = true;
                                    destroyChildScopes();
                                    widget.populateTable(value);
                                    updateLater();
                                }
                            };
                            scope.$watch(data, listener);

                            // lets add a separate event so we can force updates
                            // if we find cases where the delta logic doesn't work
                            // (such as for nested hawtioinput-input-table)
                            scope.$on("hawtio.datatable." + data, function (args) {
                                var value = Core.pathGet(scope, data);
                                listener(value);
                            });
                        }
                    }
                }
                updateGrid();
            }

            // watch the expression, and update the UI on change.
            scope.$watch(attrs.hawtioDatatable, onTableDataChange);

            // schedule update in one second
            function updateLater() {
                // save the timeoutId for canceling
                timeoutId = $timeout(function () {
                    updateGrid(); // update DOM
                }, 300);
            }

            // listen on DOM destroy (removal) event, and cancel the next UI update
            // to prevent updating ofter the DOM element was removed.
            element.bind('$destroy', function () {
                destroyChildScopes();
                $timeout.cancel(timeoutId);
            });

            updateLater(); // kick off the UI update process.
        };
    });

    hawtioPluginLoader.addModule(pluginName);
})(DataTable || (DataTable = {}));
/**
* @module Log
* @main Log
*/
var Log;
(function (Log) {
    var pluginName = 'log';
    angular.module(pluginName, ['bootstrap', 'ngResource', 'ngGrid', 'datatable', 'hawtioCore']).config(function ($routeProvider) {
        $routeProvider.when('/logs', { templateUrl: 'app/log/html/logs.html', reloadOnSearch: false });
    }).run(function ($location, workspace, viewRegistry, layoutFull, helpRegistry) {
        viewRegistry['log'] = layoutFull;
        helpRegistry.addUserDoc('log', 'app/log/doc/help.md', function () {
            return Log.treeContainsLogQueryMBean(workspace);
        });

        workspace.topLevelTabs.push({
            id: "logs",
            content: "Logs",
            title: "View and search the logs of this container",
            isValid: function (workspace) {
                return Log.treeContainsLogQueryMBean(workspace);
            },
            href: function () {
                return "#/logs";
            }
        });

        workspace.subLevelTabs.push({
            content: '<i class="icon-list-alt"></i> Log',
            title: "View the logs in this process",
            isValid: function (workspace) {
                return Log.isSelectionLogQueryMBean(workspace);
            },
            href: function () {
                return "#/logs";
            }
        });
    }).filter('logDateFilter', function ($filter) {
        var standardDateFilter = $filter('date');
        return function (log) {
            if (!log) {
                return null;
            }
            if (log.timestampMs) {
                return standardDateFilter(log.timestampMs, 'yyyy-MM-dd HH:mm:ss.sss');
            } else {
                return standardDateFilter(log.timestamp, 'yyyy-MM-dd HH:mm:ss');
            }
        };
    });

    hawtioPluginLoader.addModule(pluginName);
})(Log || (Log = {}));
/**
* @module Log
*/
var Log;
(function (Log) {
    var log = Logger.get("Log");

    function LogController($scope, $routeParams, $location, localStorage, workspace, $window, $document, $templateCache) {
        $scope.sortAsc = true;
        var value = localStorage["logSortAsc"];
        if (angular.isString(value)) {
            $scope.sortAsc = "true" === value;
        }
        $scope.autoScroll = true;
        var value = localStorage["logAutoScroll"];
        if (angular.isString(value)) {
            $scope.autoScroll = "true" === value;
        }

        $scope.logs = [];
        $scope.branding = Branding.enabled;
        $scope.showRowDetails = false;
        $scope.showRaw = {
            expanded: false
        };

        var logQueryMBean = Log.findLogQueryMBean(workspace);

        $scope.init = function () {
            $scope.searchText = $routeParams['s'];

            if (!angular.isDefined($scope.searchText)) {
                $scope.searchText = '';
            }

            $scope.filter = {
                // The default logging level to show, empty string => show all
                logLevelQuery: $routeParams['l'],
                // The default value of the exact match logging filter
                logLevelExactMatch: Core.parseBooleanValue($routeParams['e'])
            };

            if (!angular.isDefined($scope.filter.logLevelQuery)) {
                $scope.filter.logLevelQuery = '';
            }
            if (!angular.isDefined($scope.filter.logLevelExactMatch)) {
                $scope.filter.logLevelExactMatch = false;
            }
        };

        $scope.$on('$routeUpdate', $scope.init);

        $scope.$watch('searchText', function (newValue, oldValue) {
            if (newValue !== oldValue) {
                $location.search('s', newValue);
            }
        });

        $scope.$watch('filter.logLevelQuery', function (newValue, oldValue) {
            if (newValue !== oldValue) {
                $location.search('l', newValue);
            }
        });

        $scope.$watch('filter.logLevelExactMatch', function (newValue, oldValue) {
            if (newValue !== oldValue) {
                $location.search('e', newValue);
            }
        });

        $scope.init();

        $scope.toTime = 0;
        $scope.queryJSON = { type: "EXEC", mbean: logQueryMBean, operation: "logResultsSince", arguments: [$scope.toTime], ignoreErrors: true };

        $scope.logLevels = ["TRACE", "DEBUG", "INFO", "WARN", "ERROR"];
        $scope.logLevelMap = {};
        $scope.skipFields = ['seq'];

        angular.forEach($scope.logLevels, function (name, idx) {
            $scope.logLevelMap[name] = idx;
            $scope.logLevelMap[name.toLowerCase()] = idx;
        });

        $scope.selectedClass = function ($index) {
            if ($index === $scope.selectedRowIndex) {
                return 'selected';
            }
            return '';
        };

        $scope.$watch('selectedRowIndex', function (newValue, oldValue) {
            if (newValue !== oldValue) {
                if (newValue < 0 || newValue > $scope.logs.length) {
                    $scope.selectedRow = null;
                    $scope.showRowDetails = false;
                    return;
                }
                Log.log.debug("New index: ", newValue);
                $scope.selectedRow = $scope.logs[newValue];
                if (!$scope.showRowDetails) {
                    $scope.showRowDetails = true;
                }
            }
        });

        $scope.hasOSGiProps = function (row) {
            if (!row) {
                return false;
            }
            if (!('properties' in row)) {
                return false;
            }
            var props = row.properties;
            var answer = Object.extended(props).keys().any(function (key) {
                return key.startsWith('bundle');
            });
            return answer;
        };

        $scope.selectRow = function ($index) {
            // in case the user clicks a row, closes the slideout and clicks
            // the row again
            if ($scope.selectedRowIndex == $index) {
                $scope.showRowDetails = true;
                return;
            }
            $scope.selectedRowIndex = $index;
        };

        $scope.getSelectedRowJson = function () {
            return angular.toJson($scope.selectedRow, true);
        };

        $scope.logClass = function (log) {
            if (!log) {
                return '';
            }
            return logLevelClass(log['level']);
        };

        $scope.logIcon = function (log) {
            if (!log) {
                return '';
            }
            var style = $scope.logClass(log);
            if (style === "error") {
                return "red icon-warning-sign";
            }
            if (style === "warning") {
                return "orange icon-exclamation-sign";
            }
            if (style === "info") {
                return "icon-info-sign";
            }
            return "icon-cog";
        };

        $scope.logSourceHref = Log.logSourceHref;

        $scope.hasLogSourceHref = function (row) {
            if (!row) {
                return false;
            }
            return Log.hasLogSourceHref(row);
        };

        $scope.dateFormat = 'yyyy-MM-dd HH:mm:ss';

        $scope.formatException = function (line) {
            return Log.formatStackLine(line);
        };

        $scope.getSupport = function () {
            if (!$scope.selectedRow) {
                return;
            }
            var uri = "https://access.redhat.com/knowledge/solutions";
            var text = $scope.selectedRow.message;
            var logger = $scope.selectedRow.logger;
            uri = uri + "?logger=" + logger + "&text=" + text;
            window.location.href = uri;
        };

        $scope.addToDashboardLink = function () {
            var href = "#/logs";
            var routeParams = angular.toJson($routeParams);
            var size = angular.toJson({
                size_x: 8,
                size_y: 1
            });
            var title = "Logs";
            if ($scope.filter.logLevelQuery !== "") {
                title = title + " LogLevel: " + $scope.filter.logLevelQuery;
            }
            if ($scope.filter.logLevelExactMatch) {
                title = title + " Exact Match";
            }
            if ($scope.searchText !== "") {
                title = title + " Filter: " + $scope.searchText;
            }
            return "#/dashboard/add?tab=dashboard" + "&href=" + encodeURIComponent(href) + "&routeParams=" + encodeURIComponent(routeParams) + "&title=" + encodeURIComponent(title) + "&size=" + encodeURIComponent(size);
        };

        $scope.isInDashboardClass = function () {
            if (angular.isDefined($scope.inDashboard && $scope.inDashboard)) {
                return "log-table-dashboard";
            }
            return "";
        };

        $scope.sortIcon = function () {
            if ($scope.sortAsc) {
                return "icon-arrow-down";
            } else {
                return "icon-arrow-up";
            }
        };

        $scope.filterLogMessage = function (log) {
            if ($scope.filter.logLevelQuery !== "") {
                var logLevelExactMatch = $scope.filter.logLevelExactMatch;
                var logLevelQuery = $scope.filter.logLevelQuery;
                var logLevelQueryOrdinal = (logLevelExactMatch) ? 0 : $scope.logLevelMap[logLevelQuery];

                if (logLevelExactMatch) {
                    if (log.level !== logLevelQuery) {
                        return false;
                    }
                } else {
                    var idx = $scope.logLevelMap[log.level];
                    if (!(idx >= logLevelQueryOrdinal || idx < 0)) {
                        return false;
                    }
                }
            }

            if ($scope.searchText.startsWith("l=")) {
                return log.logger.has($scope.searchText.last($scope.searchText.length - 2));
            }
            if ($scope.searchText.startsWith("m=")) {
                return log.message.has($scope.searchText.last($scope.searchText.length - 2));
            }
            return log.logger.has($scope.searchText) || log.message.has($scope.searchText);
        };

        $scope.formatStackTrace = function (exception) {
            if (!exception) {
                return "";
            }
            var answer = '<ul class="unstyled">\n';
            exception.forEach(function (line) {
                answer = answer + '<li>' + $scope.formatException(line) + '</li>';
            });
            answer += '\n</ul>';
            return answer;
        };

        var updateValues = function (response) {
            var scrollToTopOrBottom = false;

            if (!$scope.inDashboard) {
                var window = $($window);

                if ($scope.logs.length === 0) {
                    // initial page load, let's scroll to the bottom
                    scrollToTopOrBottom = true;
                }

                if ($scope.sortAsc) {
                    var pos = window.scrollTop() + window.height();
                    var threshold = Core.getDocHeight() - 100;
                } else {
                    var pos = window.scrollTop() + window.height();
                    var threshold = 100;
                }
                if (pos > threshold) {
                    // page is scrolled near the bottom
                    scrollToTopOrBottom = true;
                }
            }

            var logs = response.events;
            var toTime = response.toTimestamp;
            if (toTime && angular.isNumber(toTime)) {
                if (toTime < 0) {
                    // on JBoss we get odd values and never seem to get any log events!
                    console.log("ignoring dodgy value of toTime: " + toTime);
                } else {
                    $scope.toTime = toTime;
                    $scope.queryJSON.arguments = [toTime];
                }
            }
            if (logs) {
                var maxSize = Log.getLogCacheSize(localStorage);

                //don't really need many logs in a widget...
                if ($scope.inDashboard) {
                    maxSize = 10;
                }
                var counter = 0;
                logs.forEach(function (log) {
                    if (log) {
                        // TODO Why do we compare 'item.seq === log.message' ?
                        if (!$scope.logs.any(function (key, item) {
                            return item.message === log.message && item.seq === log.message && item.timestamp === log.timestamp;
                        })) {
                            counter += 1;

                            // if there is a seq in the reply, then its the timestamp with milli seconds
                            if (log.seq != null) {
                                log['timestampMs'] = log.seq;
                            }
                            if ($scope.sortAsc) {
                                $scope.logs.push(log);
                            } else {
                                $scope.logs.unshift(log);
                            }
                        }
                    }
                });
                if (maxSize > 0) {
                    var size = $scope.logs.length;
                    if (size > maxSize) {
                        // lets trim the log size
                        var count = size - maxSize;
                        var pos = 0;
                        if (!$scope.sortAsc) {
                            pos = size - count;
                        }

                        $scope.logs.splice(pos, count);

                        if ($scope.showRowDetails) {
                            if ($scope.sortAsc) {
                                $scope.selectedRowIndex -= count;
                            } else {
                                $scope.selectedRowIndex += count;
                            }
                        }
                    }
                }
                if (counter) {
                    if ($scope.autoScroll && scrollToTopOrBottom) {
                        setTimeout(function () {
                            var pos = 0;
                            if ($scope.sortAsc) {
                                pos = $document.height() - window.height();
                            }
                            log.debug("Scrolling to position: " + pos);
                            $document.scrollTop(pos);
                        }, 20);
                    }
                    Core.$apply($scope);
                }
            }
        };

        var jolokia = workspace.jolokia;
        jolokia.execute(logQueryMBean, "allLogResults", onSuccess(updateValues));

        // listen for updates adding the since
        var asyncUpdateValues = function (response) {
            var value = response.value;
            if (value) {
                updateValues(value);
            } else {
                notification("error", "Failed to get a response! " + JSON.stringify(response, null, 4));
            }
        };

        var callback = onSuccess(asyncUpdateValues, {
            error: function (response) {
                asyncUpdateValues(response);
            }
        });

        if (logQueryMBean) {
            scopeStoreJolokiaHandle($scope, jolokia, jolokia.register(callback, $scope.queryJSON));
        }
    }
    Log.LogController = LogController;
})(Log || (Log = {}));
/**
* @module Log
*/
var Log;
(function (Log) {
    Log.log = Logger.get("Logs");

    function logSourceHref(row) {
        if (!row) {
            return "";
        }
        var log = row.entity;
        if (log) {
            return logSourceHrefEntity(log);
        } else {
            return logSourceHrefEntity(row);
        }
    }
    Log.logSourceHref = logSourceHref;

    function treeContainsLogQueryMBean(workspace) {
        return workspace.treeContainsDomainAndProperties('io.fabric8.insight', { type: 'LogQuery' }) || workspace.treeContainsDomainAndProperties('org.fusesource.insight', { type: 'LogQuery' });
    }
    Log.treeContainsLogQueryMBean = treeContainsLogQueryMBean;

    function isSelectionLogQueryMBean(workspace) {
        return workspace.hasDomainAndProperties('io.fabric8.insight', { type: 'LogQuery' }) || workspace.hasDomainAndProperties('org.fusesource.insight', { type: 'LogQuery' });
    }
    Log.isSelectionLogQueryMBean = isSelectionLogQueryMBean;

    function findLogQueryMBean(workspace) {
        var node = workspace.findMBeanWithProperties('io.fabric8.insight', { type: 'LogQuery' });
        if (!node) {
            node = workspace.findMBeanWithProperties('org.fusesource.insight', { type: 'LogQuery' });
        }
        return node ? node.objectName : null;
    }
    Log.findLogQueryMBean = findLogQueryMBean;

    function logSourceHrefEntity(log) {
        var fileName = Log.removeQuestion(log.fileName);
        var className = Log.removeQuestion(log.className);
        var properties = log.properties;
        var mavenCoords = "";
        if (properties) {
            mavenCoords = properties["maven.coordinates"];
        }
        if (mavenCoords && fileName) {
            var link = "#/source/view/" + mavenCoords + "/class/" + className + "/" + fileName;
            var line = log.lineNumber;
            if (line) {
                link += "?line=" + line;
            }
            return link;
        } else {
            return "";
        }
    }
    Log.logSourceHrefEntity = logSourceHrefEntity;

    function hasLogSourceHref(log) {
        var properties = log.properties;
        if (!properties) {
            return false;
        }
        var mavenCoords = "";
        if (properties) {
            mavenCoords = properties["maven.coordinates"];
        }
        return angular.isDefined(mavenCoords) && mavenCoords !== "";
    }
    Log.hasLogSourceHref = hasLogSourceHref;

    function removeQuestion(text) {
        return (!text || text === "?") ? null : text;
    }
    Log.removeQuestion = removeQuestion;

    var _stackRegex = /\s*at\s+([\w\.$_]+(\.([\w$_]+))*)\((.*)?:(\d+)\).*\[(.*)\]/;

    function formatStackTrace(exception) {
        if (!exception) {
            return '';
        }

        // turn exception into an array
        if (!angular.isArray(exception) && angular.isString(exception)) {
            exception = exception.split('\n');
        }

        if (!angular.isArray(exception)) {
            return "";
        }

        var answer = '<ul class="unstyled">\n';
        exception.each(function (line) {
            answer += "<li>" + Log.formatStackLine(line) + "</li>\n";
        });
        answer += "</ul>\n";
        return answer;
    }
    Log.formatStackTrace = formatStackTrace;

    function formatStackLine(line) {
        var match = _stackRegex.exec(line);
        if (match && match.length > 6) {
            var classAndMethod = match[1];
            var fileName = match[4];
            var line = match[5];
            var mvnCoords = match[6];

            // we can ignore line if its not present...
            if (classAndMethod && fileName && mvnCoords) {
                var className = classAndMethod;
                var idx = classAndMethod.lastIndexOf('.');
                if (idx > 0) {
                    className = classAndMethod.substring(0, idx);
                }
                var link = "#/source/view/" + mvnCoords + "/class/" + className + "/" + fileName;
                if (angular.isDefined(line)) {
                    link += "?line=" + line;
                }

                /*
                console.log("classAndMethod: " + classAndMethod);
                console.log("fileName: " + fileName);
                console.log("line: " + line);
                console.log("mvnCoords: " + mvnCoords);
                console.log("Matched " + JSON.stringify(match));
                */
                return "<div class='stack-line'>  at <a href='" + link + "'>" + classAndMethod + "</a>(<span class='fileName'>" + fileName + "</span>:<span class='lineNumber'>" + line + "</span>)[<span class='mavenCoords'>" + mvnCoords + "</span>]</div>";
            }
        }
        var bold = true;
        if (line) {
            line = line.trim();
            if (line.startsWith('at')) {
                line = '  ' + line;
                bold = false;
            }
        }
        if (bold) {
            return '<pre class="stack-line bold">' + line + '</pre>';
        } else {
            return '<pre class="stack-line">' + line + '</pre>';
        }
    }
    Log.formatStackLine = formatStackLine;

    function getLogCacheSize(localStorage) {
        var text = localStorage['logCacheSize'];
        if (text) {
            return parseInt(text);
        }
        return 1000;
    }
    Log.getLogCacheSize = getLogCacheSize;
})(Log || (Log = {}));
/**
* @module Git
*/
var Git;
(function (Git) {
    function createGitRepository(workspace, jolokia, localStorage) {
        var mbean = getGitMBean(workspace);
        if (mbean && jolokia) {
            return new Git.JolokiaGit(mbean, jolokia, localStorage, workspace.userDetails);
        }

        // TODO use local storage to make a little wiki thingy?
        return null;
    }
    Git.createGitRepository = createGitRepository;

    Git.jmxDomain = "hawtio";
    Git.mbeanType = "GitFacade";

    function hasGit(workspace) {
        return getGitMBean(workspace) !== null;
    }
    Git.hasGit = hasGit;

    /**
    * Returns the JMX ObjectName of the git mbean
    * @method getGitMBean
    * @for Git
    * @param {Workspace} workspace
    * @return {String}
    */
    function getGitMBean(workspace) {
        return Core.getMBeanTypeObjectName(workspace, Git.jmxDomain, Git.mbeanType);
    }
    Git.getGitMBean = getGitMBean;

    /**
    * Returns the Folder for the git mbean if it can be found
    * @method getGitMBeanFolder
    * @for Git
    * @param {Workspace} workspace
    * @return {Folder}
    */
    function getGitMBeanFolder(workspace) {
        return Core.getMBeanTypeFolder(workspace, Git.jmxDomain, Git.mbeanType);
    }
    Git.getGitMBeanFolder = getGitMBeanFolder;

    /**
    * Returns true if the git mbean is a fabric configuration repository
    * (so we can use it for the fabric plugin)
    * @method isGitMBeanFabric
    * @for Git
    * @param {Workspace} workspace
    * @return {Boolean}
    */
    function isGitMBeanFabric(workspace) {
        var folder = getGitMBeanFolder(workspace);
        return folder && folder.entries["repo"] === "fabric";
    }
    Git.isGitMBeanFabric = isGitMBeanFabric;
})(Git || (Git = {}));
/**
* @module Git
* @main Git
*/
var Git;
(function (Git) {
    

    /**
    * A default implementation which uses jolokia and the
    * GitFacadeMXBean over JMX
    *
    * @class JolokiaGit
    * @uses GitRepository
    *
    */
    var JolokiaGit = (function () {
        function JolokiaGit(mbean, jolokia, localStorage, userDetails, branch) {
            if (typeof branch === "undefined") { branch = "master"; }
            this.mbean = mbean;
            this.jolokia = jolokia;
            this.localStorage = localStorage;
            this.userDetails = userDetails;
            this.branch = branch;
        }
        JolokiaGit.prototype.exists = function (branch, path, fn) {
            return this.jolokia.execute(this.mbean, "exists", branch, path, onSuccess(fn));
        };

        JolokiaGit.prototype.read = function (branch, path, fn) {
            return this.jolokia.execute(this.mbean, "read", branch, path, onSuccess(fn));
        };

        JolokiaGit.prototype.write = function (branch, path, commitMessage, contents, fn) {
            var authorName = this.getUserName();
            var authorEmail = this.getUserEmail();

            return this.jolokia.execute(this.mbean, "write", branch, path, commitMessage, authorName, authorEmail, contents, onSuccess(fn));
        };

        JolokiaGit.prototype.createDirectory = function (branch, path, commitMessage, fn) {
            var authorName = this.getUserName();
            var authorEmail = this.getUserEmail();

            return this.jolokia.execute(this.mbean, "createDirectory", branch, path, commitMessage, authorName, authorEmail, onSuccess(fn));
        };

        JolokiaGit.prototype.revertTo = function (branch, objectId, blobPath, commitMessage, fn) {
            var authorName = this.getUserName();
            var authorEmail = this.getUserEmail();

            return this.jolokia.execute(this.mbean, "revertTo", branch, objectId, blobPath, commitMessage, authorName, authorEmail, onSuccess(fn));
        };

        JolokiaGit.prototype.rename = function (branch, oldPath, newPath, commitMessage, fn) {
            var authorName = this.getUserName();
            var authorEmail = this.getUserEmail();

            return this.jolokia.execute(this.mbean, "rename", branch, oldPath, newPath, commitMessage, authorName, authorEmail, onSuccess(fn));
        };

        JolokiaGit.prototype.remove = function (branch, path, commitMessage, fn) {
            var authorName = this.getUserName();
            var authorEmail = this.getUserEmail();

            return this.jolokia.execute(this.mbean, "remove", branch, path, commitMessage, authorName, authorEmail, onSuccess(fn));
        };

        JolokiaGit.prototype.completePath = function (branch, completionText, directoriesOnly, fn) {
            return this.jolokia.execute(this.mbean, "completePath", branch, completionText, directoriesOnly, onSuccess(fn));
        };

        JolokiaGit.prototype.history = function (branch, objectId, path, limit, fn) {
            return this.jolokia.execute(this.mbean, "history", branch, objectId, path, limit, onSuccess(fn));
        };

        JolokiaGit.prototype.commitTree = function (commitId, fn) {
            return this.jolokia.execute(this.mbean, "getCommitTree", commitId, onSuccess(fn));
        };

        JolokiaGit.prototype.commitInfo = function (commitId, fn) {
            return this.jolokia.execute(this.mbean, "getCommitInfo", commitId, onSuccess(fn));
        };

        JolokiaGit.prototype.diff = function (objectId, baseObjectId, path, fn) {
            return this.jolokia.execute(this.mbean, "diff", objectId, baseObjectId, path, onSuccess(fn));
        };

        JolokiaGit.prototype.getContent = function (objectId, blobPath, fn) {
            return this.jolokia.execute(this.mbean, "getContent", objectId, blobPath, onSuccess(fn));
        };

        JolokiaGit.prototype.readJsonChildContent = function (path, nameWildcard, search, fn) {
            return this.jolokia.execute(this.mbean, "readJsonChildContent", this.branch, path, nameWildcard, search, onSuccess(fn));
        };

        JolokiaGit.prototype.branches = function (fn) {
            return this.jolokia.execute(this.mbean, "branches", onSuccess(fn));
        };

        // TODO move...
        JolokiaGit.prototype.getUserName = function () {
            return this.localStorage["gitUserName"] || this.userDetails.username || "anonymous";
        };

        JolokiaGit.prototype.getUserEmail = function () {
            return this.localStorage["gitUserEmail"] || "anonymous@gmail.com";
        };
        return JolokiaGit;
    })();
    Git.JolokiaGit = JolokiaGit;
})(Git || (Git = {}));
/**
* The Red Hat hawtio theme
*
* @module Branding
* @main Branding
*/
var Branding;
(function (Branding) {
    Branding.enabled = null;
    Branding.profile = null;
    Branding.log = Logger.get("Branding");

    // just in case we'll check for all of these...
    Branding.mqProfiles = ["mq-amq", "mq-default", "mq", "a-mq", "a-mq-openshift", "mq-replicated"];

    $.ajaxSetup({ async: true });
    $.get('/hawtio/branding', function (response) {
        Branding.log.debug("Got response: ", response);

        Branding.enabled = Core.parseBooleanValue(response.enable);

        // Branding.enabled = false;
        // Branding.enabled = true;
        if (Branding.enabled) {
            Branding.profile = response.profile;

            // pull in branding stylesheet
            Core.addCSS('css/site-branding.css');
        }
    });

    Branding.pluginName = 'hawtio-branding';

    Branding.propertiesToCheck = ['karaf.version'];
    Branding.wantedStrings = ['redhat', 'fuse'];

    function enableBranding(branding) {
        Branding.log.info("enabled branding");
        branding.appName = 'Management Console';
        branding.appLogo = 'img/branding/RHJB_Fuse_UXlogotype_0513LL_white.svg';
        branding.loginBg = 'img/branding/login-screen-background.jpg';
        branding.fullscreenLogin = true;
        branding.profile = Branding.profile;
        branding.isAMQ = false;

        if (branding.profile) {
            Branding.mqProfiles.forEach(function (profile) {
                if (!branding.isAMQ && branding.profile.has(profile)) {
                    branding.isAMQ = true;
                    branding.appLogo = 'img/branding/RH_JBoss_AMQ_logotype_interface_LL_white.svg';
                }
            });
        }

        Branding.log.debug("Branding: ", branding);
    }
    Branding.enableBranding = enableBranding;

    angular.module(Branding.pluginName, ['hawtioCore']).run(function (helpRegistry, branding, $rootScope) {
        helpRegistry.addDevDoc("branding", 'app/branding/doc/developer.md');

        // if our variable hasn't been initialized let's wait a few
        // milliseconds until it has been...
        if (Branding.enabled !== null) {
            Branding.log.debug("Branding.enabled set: ", Branding.enabled);
            if (Branding.enabled) {
                enableBranding(branding);
            }
        } else {
            setTimeout(function () {
                Branding.log.debug("Branding.enabled not yet set: ", Branding.enabled);
                if (Branding.enabled) {
                    enableBranding(branding);
                    Core.$apply($rootScope);
                }
            }, 500);
        }
    });

    hawtioPluginLoader.addModule(Branding.pluginName);
})(Branding || (Branding = {}));
/**
* @module UI
*/
var UI;
(function (UI) {
    var GridsterDirective = (function () {
        function GridsterDirective() {
            this.restrict = 'A';
            this.replace = true;
            this.controller = function ($scope, $element, $attrs) {
            };
            this.link = function ($scope, $element, $attrs) {
                var widgetMargins = [6, 6];
                var widgetBaseDimensions = [150, 150];
                var gridSize = [150, 150];
                var extraRows = 10;
                var extraCols = 6;

                /*
                if (angular.isDefined($attrs['dimensions'])) {
                var dimension = $attrs['dimensions'].toNumber();
                widgetBaseDimensions = [dimension, dimension];
                }
                
                
                if (angular.isDefined($attrs['margins'])) {
                var margins = $attrs['margins'].toNumber();
                widgetMargins = [margins, margins];
                }
                
                if (angular.isDefined($attrs['gridSize'])) {
                var size = $attrs['gridSize'].toNumber();
                gridSize = [size, size];
                }
                */
                if (angular.isDefined($attrs['extraRows'])) {
                    extraRows = $attrs['extraRows'].toNumber();
                }

                if (angular.isDefined($attrs['extraCols'])) {
                    extraCols = $attrs['extraCols'].toNumber();
                }

                var grid = $('<ul style="margin: 0"></ul>');

                var styleStr = '<style type="text/css">';

                var styleStr = styleStr + '</style>';

                $element.append($(styleStr));
                $element.append(grid);

                $scope.gridster = grid.gridster({
                    widget_margins: widgetMargins,
                    grid_size: gridSize,
                    extra_rows: extraRows,
                    extra_cols: extraCols
                }).data('gridster');
            };
        }
        return GridsterDirective;
    })();
    UI.GridsterDirective = GridsterDirective;
})(UI || (UI = {}));
/**
* @module UI
*/
var UI;
(function (UI) {
    

    /**
    * Directive that opens a simple standard confirmation dialog.  See ConfigDialogConfig
    * for configuration properties
    *
    * @class ConfirmDialog
    */
    var ConfirmDialog = (function () {
        function ConfirmDialog() {
            this.restrict = 'A';
            this.replace = true;
            this.transclude = true;
            this.templateUrl = UI.templatePath + 'confirmDialog.html';
            /**
            * @property scope
            * @type ConfirmDialogConfig
            */
            this.scope = {
                show: '=hawtioConfirmDialog',
                title: '@',
                okButtonText: '@',
                showOkButton: '@',
                cancelButtonText: '@',
                onCancel: '&?',
                onOk: '&?',
                onClose: '&?'
            };
            this.controller = function ($scope, $element, $attrs, $transclude, $compile) {
                $scope.clone = null;

                $transclude(function (clone) {
                    $scope.clone = $(clone).filter('.dialog-body');
                });

                $scope.$watch('show', function () {
                    if ($scope.show) {
                        setTimeout(function () {
                            $scope.body = $('.modal-body');
                            $scope.body.html($compile($scope.clone.html())($scope.$parent));
                            Core.$apply($scope);
                        }, 50);
                    }
                });

                $attrs.$observe('okButtonText', function (value) {
                    if (!angular.isDefined(value)) {
                        $scope.okButtonText = "OK";
                    }
                });
                $attrs.$observe('cancelButtonText', function (value) {
                    if (!angular.isDefined(value)) {
                        $scope.cancelButtonText = "Cancel";
                    }
                });
                $attrs.$observe('title', function (value) {
                    if (!angular.isDefined(value)) {
                        $scope.title = "Are you sure?";
                    }
                });

                function checkClosed() {
                    setTimeout(function () {
                        // lets make sure we don't have a modal-backdrop hanging around!
                        var backdrop = $("div.modal-backdrop");
                        if (backdrop && backdrop.length) {
                            Logger.get("ConfirmDialog").debug("Removing the backdrop div! " + backdrop);
                            backdrop.remove();
                        }
                    }, 200);
                }

                $scope.cancel = function () {
                    $scope.show = false;
                    $scope.$parent.$eval($scope.onCancel);
                    checkClosed();
                };

                $scope.submit = function () {
                    $scope.show = false;
                    $scope.$parent.$eval($scope.onOk);
                    checkClosed();
                };

                $scope.close = function () {
                    $scope.$parent.$eval($scope.onClose);
                    checkClosed();
                };
            };
        }
        return ConfirmDialog;
    })();
    UI.ConfirmDialog = ConfirmDialog;
})(UI || (UI = {}));
/**
* @module UI
*/
var UI;
(function (UI) {
    var MessagePanel = (function () {
        function MessagePanel() {
            this.restrict = 'A';
            this.link = function ($scope, $element, $attrs) {
                var height = "100%";
                if ('hawtioMessagePanel' in $attrs) {
                    var wantedHeight = $attrs['hawtioMessagePanel'];
                    if (wantedHeight && !wantedHeight.isBlank()) {
                        height = wantedHeight;
                    }
                }

                var speed = "1s";
                if ('speed' in $attrs) {
                    var wantedSpeed = $attrs['speed'];
                    if (speed && !speed.isBlank()) {
                        speed = wantedSpeed;
                    }
                }

                $element.css({
                    position: 'absolute',
                    bottom: 0,
                    height: 0,
                    'min-height': 0,
                    transition: 'all ' + speed + ' ease-in-out'
                });

                $element.parent().mouseover(function () {
                    $element.css({
                        height: height,
                        'min-height': 'auto'
                    });
                });

                $element.parent().mouseout(function () {
                    $element.css({
                        height: 0,
                        'min-height': 0
                    });
                });
            };
        }
        return MessagePanel;
    })();
    UI.MessagePanel = MessagePanel;

    var InfoPanel = (function () {
        function InfoPanel() {
            this.restrict = 'A';
            this.link = function ($scope, $element, $attrs) {
                var validDirections = {
                    'left': {
                        side: 'right',
                        out: 'width'
                    },
                    'right': {
                        side: 'left',
                        out: 'width'
                    },
                    'up': {
                        side: 'bottom',
                        out: 'height'
                    },
                    'down': {
                        side: 'top',
                        out: 'height'
                    }
                };

                var direction = "right";
                if ('hawtioInfoPanel' in $attrs) {
                    var wantedDirection = $attrs['hawtioInfoPanel'];
                    if (wantedDirection && !wantedDirection.isBlank()) {
                        if (Object.extended(validDirections).keys().any(wantedDirection)) {
                            direction = wantedDirection;
                        }
                    }
                }

                var speed = "1s";
                if ('speed' in $attrs) {
                    var wantedSpeed = $attrs['speed'];
                    if (speed && !speed.isBlank()) {
                        speed = wantedSpeed;
                    }
                }

                var toggle = "open";
                if ('toggle' in $attrs) {
                    var wantedToggle = $attrs['toggle'];
                    if (toggle && !toggle.isBlank()) {
                        toggle = wantedToggle;
                    }
                }

                var initialCss = {
                    position: 'absolute',
                    transition: 'all ' + speed + ' ease-in-out'
                };

                var openCss = {};
                openCss[validDirections[direction]['out']] = '100%';
                var closedCss = {};
                closedCss[validDirections[direction]['out']] = 0;

                initialCss[validDirections[direction]['side']] = 0;
                initialCss[validDirections[direction]['out']] = 0;

                $element.css(initialCss);

                $scope.$watch(toggle, function (newValue, oldValue) {
                    if (Core.parseBooleanValue(newValue)) {
                        $element.css(openCss);
                    } else {
                        $element.css(closedCss);
                    }
                });

                $element.click(function () {
                    $scope[toggle] = false;
                    Core.$apply($scope);
                });
            };
        }
        return InfoPanel;
    })();
    UI.InfoPanel = InfoPanel;
})(UI || (UI = {}));
/**
* @module UI
*/
var UI;
(function (UI) {
    var SlideOut = (function () {
        function SlideOut() {
            this.restrict = 'A';
            this.replace = true;
            this.transclude = true;
            this.templateUrl = UI.templatePath + 'slideout.html';
            this.scope = {
                show: '=hawtioSlideout',
                direction: '@',
                top: '@',
                height: '@',
                title: '@'
            };
            this.controller = function ($scope, $element, $attrs, $transclude, $compile) {
                $scope.clone = null;

                $transclude(function (clone) {
                    $scope.clone = $(clone).filter('.dialog-body');
                });

                UI.observe($scope, $attrs, 'direction', 'right');
                UI.observe($scope, $attrs, 'top', '10%', function (value) {
                    $element.css('top', value);
                });
                UI.observe($scope, $attrs, 'height', '80%', function (value) {
                    $element.css('height', value);
                });
                UI.observe($scope, $attrs, 'title', '');

                $scope.$watch('show', function () {
                    if ($scope.show) {
                        $scope.body = $element.find('.slideout-body');
                        $scope.body.html($compile($scope.clone.html())($scope.$parent));
                    }
                });

                $scope.hidePanel = function ($event) {
                    UI.log.debug("Event: ", $event);
                    $scope.show = false;
                };
            };
            this.link = function ($scope, $element, $attrs) {
                $scope.$watch('show', function () {
                    if ($scope.show) {
                        $element.addClass('out');
                        $element.focus();
                    } else {
                        $element.removeClass('out');
                    }
                });
            };
        }
        return SlideOut;
    })();
    UI.SlideOut = SlideOut;
})(UI || (UI = {}));
/**
* @module UI
*/
var UI;
(function (UI) {
    function Editor($parse) {
        return {
            restrict: 'A',
            replace: true,
            templateUrl: UI.templatePath + "editor.html",
            scope: {
                text: '=hawtioEditor',
                mode: '=',
                outputEditor: '@',
                name: '@'
            },
            controller: function ($scope, $element, $attrs) {
                $scope.codeMirror = null;
                $scope.doc = null;
                $scope.options = [];

                UI.observe($scope, $attrs, 'name', 'editor');

                $scope.applyOptions = function () {
                    if ($scope.codeMirror) {
                        $scope.options.each(function (option) {
                            $scope.codeMirror.setOption(option.key, option['value']);
                        });
                        $scope.options = [];
                    }
                };

                $scope.$watch('doc', function () {
                    if ($scope.doc) {
                        $scope.codeMirror.on('change', function (changeObj) {
                            $scope.text = $scope.doc.getValue();
                            $scope.dirty = !$scope.doc.isClean();
                            Core.$apply($scope);
                        });
                    }
                });

                $scope.$watch('codeMirror', function () {
                    if ($scope.codeMirror) {
                        $scope.doc = $scope.codeMirror.getDoc();
                    }
                });

                $scope.$watch('text', function (oldValue, newValue) {
                    if ($scope.codeMirror && $scope.doc) {
                        if (!$scope.codeMirror.hasFocus()) {
                            $scope.doc.setValue($scope.text || "");
                        }
                    }
                });
            },
            link: function ($scope, $element, $attrs) {
                if ('dirty' in $attrs) {
                    $scope.dirtyTarget = $attrs['dirty'];
                    $scope.$watch("$parent['" + $scope.dirtyTarget + "']", function (newValue, oldValue) {
                        if (newValue !== oldValue) {
                            $scope.dirty = newValue;
                        }
                    });
                }

                var config = Object.extended($attrs).clone();

                delete config['$$element'];
                delete config['$attr'];
                delete config['class'];
                delete config['hawtioEditor'];
                delete config['mode'];
                delete config['dirty'];
                delete config['outputEditor'];

                if ('onChange' in $attrs) {
                    var onChange = $attrs['onChange'];
                    delete config['onChange'];
                    $scope.options.push({
                        onChange: function (codeMirror) {
                            var func = $parse(onChange);
                            if (func) {
                                func($scope.$parent, { codeMirror: codeMirror });
                            }
                        }
                    });
                }

                angular.forEach(config, function (value, key) {
                    $scope.options.push({
                        key: key,
                        'value': value
                    });
                });

                $scope.$watch('mode', function () {
                    if ($scope.mode) {
                        if (!$scope.codeMirror) {
                            $scope.options.push({
                                key: 'mode',
                                'value': $scope.mode
                            });
                        } else {
                            $scope.codeMirror.setOption('mode', $scope.mode);
                        }
                    }
                });

                $scope.$watch('dirty', function (newValue, oldValue) {
                    if ($scope.dirty && !$scope.doc.isClean()) {
                        $scope.doc.markClean();
                    }
                    if (newValue !== oldValue && 'dirtyTarget' in $scope) {
                        $scope.$parent[$scope.dirtyTarget] = $scope.dirty;
                    }
                });

                $scope.$watch('text', function () {
                    if (!$scope.codeMirror) {
                        var options = {
                            value: $scope.text
                        };

                        options = CodeEditor.createEditorSettings(options);
                        $scope.codeMirror = CodeMirror.fromTextArea($element.find('textarea').get(0), options);
                        var outputEditor = $scope.outputEditor;
                        if (outputEditor) {
                            var outputScope = $scope.$parent || $scope;
                            Core.pathSet(outputScope, outputEditor, $scope.codeMirror);
                        }
                        $scope.applyOptions();
                    }
                });
            }
        };
    }
    UI.Editor = Editor;
})(UI || (UI = {}));
/**
* @module UI
*/
var UI;
(function (UI) {
    /**
    * TODO turn this into a normal directive function
    *
    * @property AutoDropDown
    * @type IAutoDropDown
    */
    UI.AutoDropDown = {
        restrict: 'A',
        link: function ($scope, $element, $attrs) {
            function locateElements(event) {
                var el = $element.get(0);
                if (event && event.relatedNode !== el && event.type) {
                    if (event && event.type !== 'resize') {
                        return;
                    }
                }

                var overflowEl = $($element.find('.overflow'));
                var overflowMenu = $(overflowEl.find('ul.dropdown-menu'));

                /*
                Logger.info("element inner width: ", $element.innerWidth());
                Logger.info("element position: ", $element.position());
                Logger.info("element offset: ", $element.offset());
                Logger.info("overflowEl offset: ", overflowEl.offset());
                Logger.info("overflowEl position: ", overflowEl.position());
                */
                var margin = 0;
                var availableWidth = 0;

                try  {
                    margin = overflowEl.outerWidth() - overflowEl.innerWidth();
                    availableWidth = overflowEl.position().left - $element.position().left - 50;
                } catch (e) {
                    UI.log.debug("caught " + e);
                }

                $element.children('li:not(.overflow):not(.pull-right):not(:hidden)').each(function () {
                    var self = $(this);
                    availableWidth = availableWidth - self.outerWidth(true);
                    if (availableWidth < 0) {
                        self.detach();
                        self.prependTo(overflowMenu);
                    }
                });

                if (overflowMenu.children().length > 0) {
                    overflowEl.css({ visibility: "visible" });
                }

                if (availableWidth > 130) {
                    var noSpace = false;

                    overflowMenu.children('li:not(.overflow):not(.pull-right)').filter(function () {
                        return $(this).css('display') !== 'none';
                    }).each(function () {
                        if (noSpace) {
                            return;
                        }
                        var self = $(this);

                        if (availableWidth > self.outerWidth()) {
                            availableWidth = availableWidth - self.outerWidth();
                            self.detach();
                            self.insertBefore(overflowEl);
                        } else {
                            noSpace = true;
                        }
                    });
                }

                if (overflowMenu.children().length === 0) {
                    overflowEl.css({ visibility: "hidden" });
                }
            }

            $(window).resize(locateElements);
            $element.get(0).addEventListener("DOMNodeInserted", locateElements);
            $scope.$watch(setTimeout(locateElements, 500));
        }
    };
})(UI || (UI = {}));
/**
* @module UI
*/
var UI;
(function (UI) {
    var TablePager = (function () {
        function TablePager() {
            var _this = this;
            this.restrict = 'A';
            this.scope = true;
            this.templateUrl = UI.templatePath + 'tablePager.html';
            this.$scope = null;
            this.element = null;
            this.attrs = null;
            this.tableName = null;
            this.setRowIndexName = null;
            this.rowIndexName = null;
            // necessary to ensure 'this' is this object <sigh>
            this.link = function (scope, element, attrs) {
                return _this.doLink(scope, element, attrs);
            };
        }
        TablePager.prototype.doLink = function (scope, element, attrs) {
            var _this = this;
            this.$scope = scope;
            this.element = element;
            this.attrs = attrs;
            this.tableName = attrs["hawtioPager"] || attrs["array"] || "data";
            this.setRowIndexName = attrs["onIndexChange"] || "onIndexChange";
            this.rowIndexName = attrs["rowIndex"] || "rowIndex";

            scope.first = function () {
                _this.goToIndex(0);
            };

            scope.last = function () {
                _this.goToIndex(scope.tableLength() - 1);
            };

            scope.previous = function () {
                _this.goToIndex(scope.rowIndex() - 1);
            };

            scope.next = function () {
                _this.goToIndex(scope.rowIndex() + 1);
            };

            scope.isEmptyOrFirst = function () {
                var idx = scope.rowIndex();
                var length = scope.tableLength();
                return length <= 0 || idx <= 0;
            };

            scope.isEmptyOrLast = function () {
                var idx = scope.rowIndex();
                var length = scope.tableLength();
                return length < 1 || idx + 1 >= length;
            };

            scope.rowIndex = function () {
                return Core.pathGet(scope.$parent, _this.rowIndexName.split('.'));
            };

            scope.tableLength = function () {
                var data = _this.tableData();
                return data ? data.length : 0;
            };
        };

        TablePager.prototype.tableData = function () {
            return Core.pathGet(this.$scope.$parent, this.tableName.split('.')) || [];
        };

        TablePager.prototype.goToIndex = function (idx) {
            var name = this.setRowIndexName;
            var fn = this.$scope[name];
            if (angular.isFunction(fn)) {
                fn(idx);
            } else {
                console.log("No function defined in scope for " + name + " but was " + fn);
                this.$scope[this.rowIndexName] = idx;
            }
        };
        return TablePager;
    })();
    UI.TablePager = TablePager;
})(UI || (UI = {}));
/**
* Module that contains a bunch of re-usable directives to assemble into pages in hawtio
*
* @module UI
* @main UI
*/
var UI;
(function (UI) {
    UI.pluginName = 'hawtio-ui';

    UI.templatePath = 'app/ui/html/';

    angular.module(UI.pluginName, ['bootstrap', 'ngResource', 'ui', 'ui.bootstrap']).config(function ($routeProvider) {
        $routeProvider.when('/ui/developerPage', { templateUrl: UI.templatePath + 'developerPage.html', reloadOnSearch: false });
    }).factory('UI', function () {
        return UI;
    }).factory('marked', function () {
        marked.setOptions({
            gfm: true,
            tables: true,
            breaks: false,
            pedantic: true,
            sanitize: false,
            smartLists: true,
            langPrefix: 'language-'
        });
        return marked;
    }).directive('hawtioConfirmDialog', function () {
        return new UI.ConfirmDialog();
    }).directive('hawtioSlideout', function () {
        return new UI.SlideOut();
    }).directive('hawtioPager', function () {
        return new UI.TablePager();
    }).directive('hawtioEditor', function ($parse) {
        return UI.Editor($parse);
    }).directive('hawtioColorPicker', function () {
        return new UI.ColorPicker();
    }).directive('expandable', function () {
        return new UI.Expandable();
    }).directive('gridster', function () {
        return new UI.GridsterDirective();
    }).directive('editableProperty', function ($parse) {
        return new UI.EditableProperty($parse);
    }).directive('hawtioViewport', function () {
        return new UI.ViewportHeight();
    }).directive('hawtioHorizontalViewport', function () {
        return new UI.HorizontalViewport();
    }).directive('hawtioRow', function () {
        return new UI.DivRow();
    }).directive('hawtioJsplumb', function () {
        return new UI.JSPlumb();
    }).directive('zeroClipboard', function ($parse) {
        return UI.ZeroClipboardDirective($parse);
    }).directive('hawtioAutoDropdown', function () {
        return UI.AutoDropDown;
    }).directive('hawtioMessagePanel', function () {
        return new UI.MessagePanel();
    }).directive('hawtioInfoPanel', function () {
        return new UI.InfoPanel();
    }).directive('hawtioAutoColumns', function () {
        return new UI.AutoColumns();
    }).directive('hawtioTemplatePopover', function ($templateCache, $compile, $document) {
        return UI.TemplatePopover($templateCache, $compile, $document);
    }).directive('hawtioTocDisplay', function (marked, $location, $anchorScroll, $compile) {
        return UI.HawtioTocDisplay(marked, $location, $anchorScroll, $compile);
    }).directive('hawtioDropDown', function ($templateCache) {
        return UI.hawtioDropDown($templateCache);
    }).directive('hawtioBreadcrumbs', function () {
        return UI.hawtioBreadcrumbs();
    }).directive('compile', [
        '$compile', function ($compile) {
            return function (scope, element, attrs) {
                scope.$watch(function (scope) {
                    // watch the 'compile' expression for changes
                    return scope.$eval(attrs.compile);
                }, function (value) {
                    // when the 'compile' expression changes
                    // assign it into the current DOM
                    element.html(value);

                    // compile the new DOM and link it to the current
                    // scope.
                    // NOTE: we only compile .childNodes so that
                    // we don't get into infinite loop compiling ourselves
                    $compile(element.contents())(scope);
                });
            };
        }]);

    hawtioPluginLoader.addModule(UI.pluginName);
})(UI || (UI = {}));
/**
* @module UI
*/
var UI;
(function (UI) {
    var ViewportHeight = (function () {
        function ViewportHeight() {
            this.restrict = 'A';
            this.link = function ($scope, $element, $attrs) {
                var lastHeight = 0;

                var resizeFunc = function () {
                    var neighbor = angular.element($attrs['hawtioViewport']);
                    var container = angular.element($attrs['containingDiv']);

                    var start = neighbor.position().top + neighbor.height();

                    var myHeight = container.height() - start;
                    if (angular.isDefined($attrs['heightAdjust'])) {
                        var heightAdjust = $attrs['heightAdjust'].toNumber();
                    }
                    myHeight = myHeight + heightAdjust;

                    $element.css({
                        height: myHeight,
                        'min-height': myHeight
                    });

                    if (lastHeight !== myHeight) {
                        lastHeight = myHeight;
                        $element.trigger('resize');
                    }
                };

                resizeFunc();
                $scope.$watch(resizeFunc);

                $().resize(function () {
                    resizeFunc();
                    Core.$apply($scope);
                    return false;
                });
            };
        }
        return ViewportHeight;
    })();
    UI.ViewportHeight = ViewportHeight;

    var HorizontalViewport = (function () {
        function HorizontalViewport() {
            this.restrict = 'A';
            this.link = function ($scope, $element, $attrs) {
                var adjustParent = angular.isDefined($attrs['adjustParent']) && Core.parseBooleanValue($attrs['adjustParent']);

                $element.get(0).addEventListener("DOMNodeInserted", function () {
                    var canvas = $element.children();
                    $element.height(canvas.outerHeight(true));
                    if (adjustParent) {
                        $element.parent().height($element.outerHeight(true) + UI.getScrollbarWidth());
                    }
                });
            };
        }
        return HorizontalViewport;
    })();
    UI.HorizontalViewport = HorizontalViewport;
})(UI || (UI = {}));
/**
* @module UI
*/
var UI;
(function (UI) {
    function HawtioTocDisplay(marked, $location, $anchorScroll, $compile) {
        var log = Logger.get("UI");

        return {
            restrict: 'A',
            scope: {
                getContents: '&'
            },
            controller: function ($scope, $element, $attrs) {
                $scope.remaining = -1;
                $scope.render = false;
                $scope.chapters = [];

                $scope.addChapter = function (item) {
                    console.log("Adding: ", item);
                    $scope.chapters.push(item);
                    if (!angular.isDefined(item['text'])) {
                        $scope.fetchItemContent(item);
                    }
                };

                $scope.getTarget = function (id) {
                    if (!id) {
                        return '';
                    }
                    return id.replace(".", "_");
                };

                $scope.getFilename = function (href, ext) {
                    var filename = href.split('/').last();
                    if (ext && !filename.endsWith(ext)) {
                        filename = filename + '.' + ext;
                    }
                    return filename;
                };

                $scope.$watch('remaining', function (newValue, oldValue) {
                    if (newValue !== oldValue) {
                        var renderIfPageLoadFails = false;
                        if (newValue === 0 || renderIfPageLoadFails) {
                            $scope.render = true;
                        }
                    }
                });

                $scope.fetchItemContent = function (item) {
                    var me = $scope;
                    $scope.$eval(function (parent) {
                        parent.getContents({
                            filename: item['filename'],
                            cb: function (data) {
                                if (data) {
                                    if (item['filename'].endsWith(".md")) {
                                        item['text'] = marked(data);
                                    } else {
                                        item['text'] = data;
                                    }
                                    $scope.remaining--;
                                    Core.$apply(me);
                                }
                            }
                        });
                    });
                };
            },
            link: function ($scope, $element, $attrs) {
                var offsetTop = 0;
                var logbar = $('.logbar');
                var contentDiv = $("#toc-content");
                if (logbar.length) {
                    offsetTop = logbar.height() + logbar.offset().top;
                } else if (contentDiv.length) {
                    var offsetContentDiv = contentDiv.offset();
                    if (offsetContentDiv) {
                        offsetTop = offsetContentDiv.top;
                    }
                }
                if (!offsetTop) {
                    // set to a decent guestimate
                    offsetTop = 90;
                }
                var previousHtml = null;
                var html = $element;
                if (!contentDiv || !contentDiv.length) {
                    contentDiv = $element;
                }
                var ownerScope = $scope.$parent || $scope;
                var scrollDuration = 1000;

                var linkFilter = $attrs["linkFilter"];
                var htmlName = $attrs["html"];
                if (htmlName) {
                    ownerScope.$watch(htmlName, function () {
                        var htmlText = ownerScope[htmlName];
                        if (htmlText && htmlText !== previousHtml) {
                            previousHtml = htmlText;
                            var markup = $compile(htmlText)(ownerScope);
                            $element.children().remove();
                            $element.append(markup);
                            loadChapters();
                        }
                    });
                } else {
                    loadChapters();
                }

                // make the link active for the first panel on the view
                $(window).scroll(setFirstChapterActive);

                function setFirstChapterActive() {
                    // lets find the first panel which is visible...
                    var cutoff = $(window).scrollTop();
                    $element.find("li a").removeClass("active");
                    $('.panel-body').each(function () {
                        var offset = $(this).offset();
                        if (offset && offset.top >= cutoff) {
                            // lets make the related TOC link active
                            var id = $(this).attr("id");
                            if (id) {
                                var link = html.find("a[chapter-id='" + id + "']");
                                link.addClass("active");

                                // stop iterating and just make first one active
                                return false;
                            }
                        }
                    });
                }

                function findLinks() {
                    var answer = html.find('a');
                    if (linkFilter) {
                        answer = answer.filter(linkFilter);
                    }
                    return answer;
                }

                function loadChapters() {
                    if (!html.get(0).id) {
                        html.get(0).id = 'toc';
                    }
                    $scope.tocId = '#' + html.get(0).id;
                    $scope.remaining = findLinks().length;
                    findLinks().each(function (index, a) {
                        log.debug("Found: ", a);
                        var filename = $scope.getFilename(a.href, a.getAttribute('file-extension'));
                        var item = {
                            filename: filename,
                            title: a.textContent,
                            link: a
                        };
                        $scope.addChapter(item);
                    });

                    // TODO this doesn't seem to have any effect ;)
                    setTimeout(function () {
                        setFirstChapterActive();
                    }, 100);
                }

                $scope.$watch('render', function (newValue, oldValue) {
                    if (newValue !== oldValue) {
                        if (newValue) {
                            if (!contentDiv.next('.hawtio-toc').length) {
                                var div = $('<div class="hawtio-toc"></div>');
                                div.appendTo(contentDiv);

                                var selectedChapter = $location.search()["chapter"];

                                // lets load the chapter panels
                                $scope.chapters.forEach(function (chapter, index) {
                                    log.debug("index:", index);
                                    var panel = $('<div></div>');
                                    var panelHeader = null;

                                    var chapterId = $scope.getTarget(chapter['filename']);
                                    var link = chapter["link"];
                                    if (link) {
                                        link.setAttribute("chapter-id", chapterId);
                                    }
                                    if (index > 0) {
                                        panelHeader = $('<div class="panel-title"><a class="toc-back" href="">Back to Top</a></div>');
                                    }
                                    var panelBody = $('<div class="panel-body" id="' + chapterId + '">' + chapter['text'] + '</div>');
                                    if (panelHeader) {
                                        panel.append(panelHeader).append($compile(panelBody)($scope));
                                    } else {
                                        panel.append($compile(panelBody)($scope));
                                    }
                                    panel.hide().appendTo(div).fadeIn(1000);

                                    if (chapterId === selectedChapter) {
                                        // lets scroll on startup to allow for bookmarking
                                        scrollToChapter(chapterId);
                                    }
                                });

                                var pageTop = contentDiv.offset().top - offsetTop;

                                div.find('a.toc-back').each(function (index, a) {
                                    $(a).click(function (e) {
                                        e.preventDefault();
                                        $('body,html').animate({
                                            scrollTop: pageTop
                                        }, 2000);
                                    });
                                });

                                // handle clicking links in the TOC
                                findLinks().each(function (index, a) {
                                    var href = a.href;
                                    var filename = $scope.getFilename(href, a.getAttribute('file-extension'));
                                    $(a).click(function (e) {
                                        log.debug("Clicked: ", e);
                                        e.preventDefault();
                                        var chapterId = $scope.getTarget(filename);
                                        $location.search("chapter", chapterId);
                                        Core.$apply(ownerScope);
                                        scrollToChapter(chapterId);
                                        return true;
                                    });
                                });
                            }
                        }
                    }
                });

                // watch for back / forward / url changes
                ownerScope.$on("$locationChangeSuccess", function (event, current, previous) {
                    // lets do this asynchronously to avoid Error: $digest already in progress
                    setTimeout(function () {
                        // lets check if the chapter selection has changed
                        var currentChapter = $location.search()["chapter"];
                        scrollToChapter(currentChapter);
                    }, 50);
                });

                /**
                * Lets scroll to the given chapter ID
                *
                * @param chapterId
                */
                function scrollToChapter(chapterId) {
                    log.debug("selected chapter changed: " + chapterId);
                    if (chapterId) {
                        var target = '#' + chapterId;
                        var top = 0;
                        var targetElements = $(target);
                        if (targetElements.length) {
                            var offset = targetElements.offset();
                            if (offset) {
                                top = offset.top - offsetTop;
                            }
                            $('body,html').animate({
                                scrollTop: top
                            }, scrollDuration);
                        }
                    }
                }
            }
        };
    }
    UI.HawtioTocDisplay = HawtioTocDisplay;
})(UI || (UI = {}));
/**
* @module UI
*/
var UI;
(function (UI) {
    UI.log = Logger.get("UI");

    UI.scrollBarWidth = null;

    function getIfSet(attribute, $attr, def) {
        if (attribute in $attr) {
            var wantedAnswer = $attr[attribute];
            if (wantedAnswer && !wantedAnswer.isBlank()) {
                return wantedAnswer;
            }
        }
        return def;
    }
    UI.getIfSet = getIfSet;

    /*
    * Helper function to ensure a directive attribute has some default value
    */
    function observe($scope, $attrs, key, defValue, callbackFunc) {
        if (typeof callbackFunc === "undefined") { callbackFunc = null; }
        $attrs.$observe(key, function (value) {
            if (!angular.isDefined(value)) {
                $scope[key] = defValue;
            } else {
                $scope[key] = value;
            }
            if (angular.isDefined(callbackFunc) && callbackFunc) {
                callbackFunc($scope[key]);
            }
        });
    }
    UI.observe = observe;

    function getScrollbarWidth() {
        if (!angular.isDefined(UI.scrollBarWidth)) {
            var div = document.createElement('div');
            div.innerHTML = '<div style="width:50px;height:50px;position:absolute;left:-50px;top:-50px;overflow:auto;"><div style="width:1px;height:100px;"></div></div>';
            div = div.firstChild;
            document.body.appendChild(div);
            UI.scrollBarWidth = div.offsetWidth - div.clientWidth;
            document.body.removeChild(div);
        }
        return UI.scrollBarWidth;
    }
    UI.getScrollbarWidth = getScrollbarWidth;
})(UI || (UI = {}));
/**
* @module UI
*/
var UI;
(function (UI) {
    UI.selected = "selected";
    UI.unselected = "unselected";

    /**
    * Pre defined colors used in the color picker
    * @property colors
    * @for UI
    * @type Array
    */
    UI.colors = [
        "#5484ED", "#A4BDFC", "#46D6DB", "#7AE7BF",
        "#51B749", "#FBD75B", "#FFB878", "#FF887C", "#DC2127",
        "#DBADFF", "#E1E1E1"];

    /**
    Directive that allows the user to pick a color from a pre-defined pallete of colors.
    
    Use it like:
    
    ```html
    <div hawtio-color-picker="myModel"></div>
    ```
    
    'myModel' will be bound to the color the user clicks on
    
    @class ColorPicker
    */
    var ColorPicker = (function () {
        function ColorPicker() {
            this.restrict = 'A';
            this.replace = true;
            this.scope = {
                property: '=hawtioColorPicker'
            };
            this.templateUrl = UI.templatePath + "colorPicker.html";
            this.compile = function (tElement, tAttrs, transclude) {
                return {
                    post: function postLink(scope, iElement, iAttrs, controller) {
                        scope.colorList = [];

                        angular.forEach(UI.colors, function (color) {
                            var select = UI.unselected;

                            if (scope.property === color) {
                                select = UI.selected;
                            }

                            scope.colorList.push({
                                color: color,
                                select: select
                            });
                        });
                    }
                };
            };
            this.controller = function ($scope, $element, $timeout) {
                $scope.popout = false;

                $scope.$watch('popout', function () {
                    $element.find('.color-picker-popout').toggleClass('popout-open', $scope.popout);
                });

                $scope.selectColor = function (color) {
                    for (var i = 0; i < $scope.colorList.length; i++) {
                        $scope.colorList[i].select = UI.unselected;
                        if ($scope.colorList[i] === color) {
                            $scope.property = color.color;
                            $scope.colorList[i].select = UI.selected;
                        }
                    }
                };
            };
        }
        return ColorPicker;
    })();
    UI.ColorPicker = ColorPicker;
})(UI || (UI = {}));
/**
* @module UI
*/
var UI;
(function (UI) {
    // expand the element to accomodate a group of elements to prevent them from wrapping
    var DivRow = (function () {
        function DivRow() {
            this.restrict = 'A';
            this.link = function ($scope, $element, $attrs) {
                $element.get(0).addEventListener("DOMNodeInserted", function () {
                    var targets = $element.children();
                    var width = 0;
                    angular.forEach(targets, function (target) {
                        var el = angular.element(target);
                        switch (el.css('display')) {
                            case 'none':
                                break;
                            default:
                                width = width + el.outerWidth(true) + 5;
                        }
                    });
                    $element.width(width);
                });
            };
        }
        return DivRow;
    })();
    UI.DivRow = DivRow;
})(UI || (UI = {}));
/**
* @module UI
*/
var UI;
(function (UI) {
    function DeveloperPageController($scope, $http) {
        $scope.getContents = function (filename, cb) {
            var fullUrl = "app/ui/html/test/" + filename;
            $http({ method: 'GET', url: fullUrl }).success(function (data, status, headers, config) {
                cb(data);
            }).error(function (data, status, headers, config) {
                cb("Failed to fetch " + filename + ": " + data);
            });
        };
    }
    UI.DeveloperPageController = DeveloperPageController;
})(UI || (UI = {}));
/**
* @module UI
*/
var UI;
(function (UI) {
    var Expandable = (function () {
        function Expandable() {
            var _this = this;
            this.log = Logger.get("Expandable");
            this.restrict = 'C';
            this.replace = false;
            this.link = null;
            this.link = function (scope, element, attrs) {
                var self = _this;
                var expandable = element;
                var modelName = null;
                var model = null;

                if (angular.isDefined(attrs['model'])) {
                    modelName = attrs['model'];
                    model = scope[modelName];

                    if (!angular.isDefined(scope[modelName]['expanded'])) {
                        model['expanded'] = expandable.hasClass('opened');
                    } else {
                        if (model['expanded']) {
                            self.forceOpen(model, expandable, scope);
                        } else {
                            self.forceClose(model, expandable, scope);
                        }
                    }

                    if (modelName) {
                        scope.$watch(modelName + '.expanded', function (newValue, oldValue) {
                            if (asBoolean(newValue) !== asBoolean(oldValue)) {
                                if (newValue) {
                                    self.open(model, expandable, scope);
                                } else {
                                    self.close(model, expandable, scope);
                                }
                            }
                        });
                    }
                }

                var title = expandable.find('.title');
                var button = expandable.find('.cancel');

                button.bind('click', function () {
                    model = scope[modelName];
                    self.forceClose(model, expandable, scope);
                    return false;
                });

                title.bind('click', function () {
                    model = scope[modelName];
                    if (isOpen(expandable)) {
                        self.close(model, expandable, scope);
                    } else {
                        self.open(model, expandable, scope);
                    }
                    return false;
                });
            };
        }
        Expandable.prototype.open = function (model, expandable, scope) {
            expandable.find('.expandable-body').slideDown(400, function () {
                if (!expandable.hasClass('opened')) {
                    expandable.addClass('opened');
                }
                expandable.removeClass('closed');
                if (model) {
                    model['expanded'] = true;
                }
                Core.$apply(scope);
            });
        };

        Expandable.prototype.close = function (model, expandable, scope) {
            expandable.find('.expandable-body').slideUp(400, function () {
                expandable.removeClass('opened');
                if (!expandable.hasClass('closed')) {
                    expandable.addClass('closed');
                }
                if (model) {
                    model['expanded'] = false;
                }
                Core.$apply(scope);
            });
        };

        Expandable.prototype.forceClose = function (model, expandable, scope) {
            expandable.find('.expandable-body').slideUp(0, function () {
                if (!expandable.hasClass('closed')) {
                    expandable.addClass('closed');
                }
                expandable.removeClass('opened');
                if (model) {
                    model['expanded'] = false;
                }
                Core.$apply(scope);
            });
        };

        Expandable.prototype.forceOpen = function (model, expandable, scope) {
            expandable.find('.expandable-body').slideDown(0, function () {
                if (!expandable.hasClass('opened')) {
                    expandable.addClass('opened');
                }
                expandable.removeClass('closed');
                if (model) {
                    model['expanded'] = true;
                }
                Core.$apply(scope);
            });
        };
        return Expandable;
    })();
    UI.Expandable = Expandable;

    function isOpen(expandable) {
        return expandable.hasClass('opened') || !expandable.hasClass("closed");
    }

    function asBoolean(value) {
        return value ? true : false;
    }
})(UI || (UI = {}));
/**
* @module UI
*/
var UI;
(function (UI) {
    /**
    * Simple helper class for creating <a href="http://angular-ui.github.io/bootstrap/#/modal">angular ui bootstrap modal dialogs</a>
    * @class Dialog
    */
    var Dialog = (function () {
        function Dialog() {
            this.show = false;
            this.options = {
                backdropFade: true,
                dialogFade: true
            };
        }
        /**
        * Opens the dialog
        * @method open
        */
        Dialog.prototype.open = function () {
            this.show = true;
        };

        /**
        * Closes the dialog
        * @method close
        */
        Dialog.prototype.close = function () {
            this.show = false;

            // lets make sure and remove any backgroup fades
            this.removeBackdropFadeDiv();
            setTimeout(this.removeBackdropFadeDiv, 100);
        };

        Dialog.prototype.removeBackdropFadeDiv = function () {
            $("div.modal-backdrop").remove();
        };
        return Dialog;
    })();
    UI.Dialog = Dialog;
})(UI || (UI = {}));
/**
* @module UI
*/
var UI;
(function (UI) {
    function UITestController2($scope, $templateCache) {
        $scope.fileUploadExMode = 'text/html';

        $scope.menuItems = [];
        $scope.divs = [];

        for (var i = 0; i < 20; i++) {
            $scope.menuItems.push("Some Item " + i);
        }

        for (var i = 0; i < 20; i++) {
            $scope.divs.push(i + 1);
        }

        $scope.things = [
            {
                'name': 'stuff1',
                'foo1': 'bar1',
                'foo2': 'bar2'
            },
            {
                'name': 'stuff2',
                'foo3': 'bar3',
                'foo4': 'bar4'
            }
        ];

        $scope.someVal = 1;

        $scope.dropDownConfig = {
            icon: 'icon-cogs',
            title: 'My Awesome Menu',
            items: [
                {
                    title: 'Some Item',
                    action: 'someVal=2'
                }, {
                    title: 'Some other stuff',
                    icon: 'icon-twitter',
                    action: 'someVal=3'
                }, {
                    title: "I've got children",
                    icon: 'icon-file-text',
                    items: [
                        {
                            title: 'Hi!',
                            action: 'someVal=4'
                        }, {
                            title: 'Yo!',
                            items: [
                                {
                                    title: 'More!',
                                    action: 'someVal=5'
                                }, {
                                    title: 'Child',
                                    action: 'someVal=6'
                                }, {
                                    title: 'Menus!',
                                    action: 'someVal=7'
                                }]
                        }]
                }, {
                    title: "Call a function!",
                    action: function () {
                        notification("info", "Function called!");
                    }
                }]
        };
        $scope.dropDownConfigTxt = angular.toJson($scope.dropDownConfig, true);

        $scope.$watch('dropDownConfigTxt', function (newValue, oldValue) {
            if (newValue !== oldValue) {
                $scope.dropDownConfig = angular.fromJson($scope.dropDownConfigTxt);
            }
        });

        $scope.breadcrumbSelection = 1;

        $scope.breadcrumbConfig = {
            path: '/root/first child',
            icon: 'icon-cogs',
            title: 'root',
            items: [
                {
                    title: 'first child',
                    icon: 'icon-folder-close-alt',
                    items: [{
                            title: "first child's first child",
                            icon: 'icon-file-text'
                        }]
                }, {
                    title: 'second child',
                    icon: 'icon-file'
                }, {
                    title: "third child",
                    icon: 'icon-folder-close-alt',
                    items: [
                        {
                            title: "third child's first child",
                            icon: 'icon-file-text'
                        }, {
                            title: "third child's second child",
                            icon: 'icon-file-text'
                        }, {
                            title: "third child's third child",
                            icon: 'icon-folder-close-alt',
                            items: [
                                {
                                    title: 'More!',
                                    icon: 'icon-file-text'
                                }, {
                                    title: 'Child',
                                    icon: 'icon-file-text'
                                }, {
                                    title: 'Menus!',
                                    icon: 'icon-file-text'
                                }]
                        }]
                }]
        };

        $scope.breadcrumbConfigTxt = angular.toJson($scope.breadcrumbConfig, true);

        $scope.$watch('breadcrumbConfigTxt', function (newValue, oldValue) {
            if (newValue !== oldValue) {
                $scope.breadcrumbconfig = angular.toJson($scope.breadcrumbConfigTxt);
            }
        });

        $scope.breadcrumbEx = $templateCache.get("breadcrumbTemplate");

        $scope.dropDownEx = $templateCache.get("dropDownTemplate");

        $scope.autoDropDown = $templateCache.get("autoDropDownTemplate");
        $scope.zeroClipboard = $templateCache.get("zeroClipboardTemplate");

        $scope.popoverEx = $templateCache.get("myTemplate");
        $scope.popoverUsageEx = $templateCache.get("popoverExTemplate");

        $scope.autoColumnEx = $templateCache.get("autoColumnTemplate");
    }
    UI.UITestController2 = UITestController2;

    function UITestController1($scope, $templateCache) {
        $scope.jsplumbEx = $templateCache.get("jsplumbTemplate");

        $scope.nodes = ["node1", "node2"];
        $scope.otherNodes = ["node4", "node5", "node6"];

        $scope.anchors = ["Top", "Right", "Bottom", "Left"];

        $scope.createEndpoint = function (nodeId) {
            var node = $scope.jsPlumbNodesById[nodeId];
            if (node) {
                var anchors = $scope.anchors.subtract(node.anchors);
                console.log("anchors: ", anchors);
                if (anchors && anchors.length > 0) {
                    var anchor = anchors.first();
                    node.anchors.push(anchor);
                    node.endpoints.push($scope.jsPlumb.addEndpoint(node.el, {
                        anchor: anchor,
                        isSource: true,
                        isTarget: true,
                        maxConnections: -1
                    }));
                }
            }
        };

        $scope.expandableEx = '' + '<div class="expandable closed">\n' + '   <div title="The title" class="title">\n' + '     <i class="expandable-indicator"></i> Expandable title\n' + '   </div>\n' + '   <div class="expandable-body well">\n' + '     This is the expandable content...  Note that adding the "well" class isn\'t necessary but makes for a nice inset look\n' + '   </div>\n' + '</div>';

        $scope.editablePropertyEx1 = '<editable-property ng-model="editablePropertyModelEx1" property="property"></editable-property>';

        $scope.editablePropertyModelEx1 = {
            property: "This is editable (hover to edit)"
        };

        $scope.showDeleteOne = new UI.Dialog();
        $scope.showDeleteTwo = new UI.Dialog();

        $scope.fileUploadEx1 = '<div hawtio-file-upload="files" target="test1"></div>';
        $scope.fileUploadEx2 = '<div hawtio-file-upload="files" target="test2" show-files="false"></div>';
        $scope.fileUploadExMode = 'text/html';

        $scope.colorPickerEx = 'My Color ({{myColor}}): <div hawtio-color-picker="myColor"></div>';

        $scope.confirmationEx1 = '' + '<button class="btn" ng-click="showDeleteOne.open()">Delete stuff</button>\n' + '\n' + '<div hawtio-confirm-dialog="showDeleteOne.show"\n' + 'title="Delete stuff?"\n' + 'ok-button-text="Yes, Delete the Stuff"\n' + 'cancel-button-text="No, Keep the Stuff"\n' + 'on-cancel="onCancelled(\'One\')"\n' + 'on-ok="onOk(\'One\')">\n' + '  <div class="dialog-body">\n' + '    <p>\n' + '        Are you sure you want to delete all the stuff?\n' + '    </p>\n' + '  </div>\n' + '</div>\n';

        $scope.confirmationEx2 = '' + '<button class="btn" ng-click="showDeleteTwo.open()">Delete other stuff</button>\n' + '\n' + '<!-- Use more defaults -->\n' + '<div hawtio-confirm-dialog="showDeleteTwo.show\n"' + '  on-cancel="onCancelled(\'Two\')"\n' + '  on-ok="onOk(\'Two\')">\n' + '  <div class="dialog-body">\n' + '    <p>\n' + '      Are you sure you want to delete all the other stuff?\n' + '    </p>\n' + '  </div>\n' + '</div>';

        $scope.sliderEx1 = '' + '<button class="btn" ng-click="showSlideoutRight = !showSlideoutRight">Show slideout right</button>\n' + '<div hawtio-slideout="showSlideoutRight" title="Hey look a slider!">\n' + '   <div class="dialog-body">\n' + '     <div>\n' + '       Here is some content or whatever {{transcludedValue}}\n' + '     </div>\n' + '   </div>\n' + '</div>';

        $scope.sliderEx2 = '' + '<button class="btn" ng-click="showSlideoutLeft = !showSlideoutLeft">Show slideout left</button>\n' + '<div hawtio-slideout="showSlideoutLeft" direction="left" title="Hey, another slider!">\n' + '   <div class="dialog-body">\n' + '     <div hawtio-editor="someText" mode="javascript"></div>\n' + '   </div>\n' + '</div>\n';

        $scope.editorEx1 = '' + 'Instance 1\n' + '<div class="row-fluid">\n' + '   <div hawtio-editor="someText" mode="mode" dirty="dirty"></div>\n' + '   <div>Text : {{someText}}</div>\n' + '</div>\n' + '\n' + 'Instance 2 (readonly)\n' + '<div class="row-fluid">\n' + '   <div hawtio-editor="someText" read-only="true" mode="mode" dirty="dirty"></div>\n' + '   <div>Text : {{someText}}</div>\n' + '</div>';

        $scope.transcludedValue = "and this is transcluded";

        $scope.onCancelled = function (number) {
            notification('info', 'cancelled ' + number);
        };

        $scope.onOk = function (number) {
            notification('info', number + ' ok!');
        };

        $scope.showSlideoutRight = false;
        $scope.showSlideoutLeft = false;

        $scope.dirty = false;
        $scope.mode = 'javascript';

        $scope.someText = "var someValue = 0;\n" + "var someFunc = function() {\n" + "  return \"Hello World!\";\n" + "}\n";

        $scope.myColor = "#FF887C";
        $scope.showColorDialog = false;

        $scope.files = [];

        $scope.$watch('files', function (newValue, oldValue) {
            if (newValue !== oldValue) {
                console.log("Files: ", $scope.files);
            }
        }, true);
    }
    UI.UITestController1 = UITestController1;
})(UI || (UI = {}));
/**
* @module UI
*/
var UI;
(function (UI) {
    function hawtioBreadcrumbs() {
        return {
            restrict: 'E',
            replace: true,
            templateUrl: UI.templatePath + 'breadcrumbs.html',
            require: 'hawtioDropDown',
            scope: {
                config: '='
            },
            controller: function ($scope, $element, $attrs) {
                $scope.action = "itemClicked(config, $event)";

                $scope.levels = {};

                $scope.itemClicked = function (config, $event) {
                    //log.debug("Item clicked: ", config);
                    if (config.level && angular.isNumber(config.level)) {
                        $scope.levels[config.level] = config;

                        var keys = Object.extended($scope.levels).keys().sortBy("");
                        var toRemove = keys.from(config.level + 1);

                        toRemove.forEach(function (i) {
                            if (i in $scope.levels) {
                                $scope.levels[i] = {};
                                delete $scope.levels[i];
                            }
                        });

                        // reset any previously deleted action
                        angular.forEach($scope.levels, function (value, key) {
                            if (value.items && value.items.length > 0) {
                                value.items.forEach(function (i) {
                                    //log.debug("Resetting action: ", i);
                                    i['action'] = $scope.action;
                                });
                            }
                        });
                        if (config.items) {
                            config.open = true;
                            config.items.forEach(function (i) {
                                i['action'] = $scope.action;
                            });
                            delete config.action;
                        } else {
                            //ooh we picked a thing!
                            var keys = Object.extended($scope.levels).keys().sortBy("");
                            var path = [];
                            keys.forEach(function (key) {
                                path.push($scope.levels[key]['title']);
                            });
                            var pathString = '/' + path.join("/");
                            $scope.config.path = pathString;
                        }

                        // for some reason levels > 1 get two click events :-S
                        if (config.level > 1) {
                            $event.preventDefault();
                            $event.stopPropagation();
                        }
                    }
                };

                function addAction(config, level) {
                    config.level = level;
                    if (level > 0) {
                        config.breadcrumbAction = config.action;
                        config.action = $scope.action;
                    }
                    if (config.items) {
                        config.items.forEach(function (item) {
                            addAction(item, level + 1);
                        });
                    }
                }

                function setLevels(config, pathParts, level) {
                    if (pathParts.length === 0) {
                        return;
                    }
                    var part = pathParts.removeAt(0)[0];

                    //log.debug("config: ", config, " checking part: ", part, " pathParts: ", pathParts);
                    if (config && config.items) {
                        var matched = false;
                        config.items.forEach(function (item) {
                            //log.debug("checking item: ", item, " against part: ", part);
                            if (!matched && item['title'] === part) {
                                //log.debug("Found match");
                                matched = true;
                                $scope.levels[level] = item;
                                setLevels(item, pathParts, level + 1);
                            }
                        });
                    }
                }

                // watch to see if the parent scope changes the path
                $scope.$watch('config.path', function (newValue, oldValue) {
                    if (!Core.isBlank(newValue)) {
                        var pathParts = newValue.split('/').exclude(function (p) {
                            return Core.isBlank(p);
                        });

                        //log.debug("path: ", newValue);
                        //log.debug("pathParts: ", pathParts);
                        var matches = true;
                        pathParts.forEach(function (part, index) {
                            //log.debug("Checking part: ", part, " index: ", index)
                            if (!matches) {
                                return;
                            }
                            if (!$scope.levels[index] || Core.isBlank($scope.levels[index]['title']) || $scope.levels[index]['title'] !== part) {
                                matches = false;
                            }
                        });

                        //log.debug("matches: ", matches);
                        if (matches) {
                            return;
                        }

                        // adjust $scope.levels to match the path
                        $scope.levels = [];
                        $scope.levels['0'] = $scope.config;
                        setLevels($scope.config, pathParts.from(0), 1);
                    }
                });

                $scope.$watch('config', function (newValue, oldValue) {
                    addAction($scope.config, 0);
                    $scope.levels['0'] = $scope.config;
                });
            }
        };
    }
    UI.hawtioBreadcrumbs = hawtioBreadcrumbs;
})(UI || (UI = {}));
/**
* @module UI
*/
var UI;
(function (UI) {
    function ZeroClipboardDirective($parse) {
        return {
            restrict: 'A',
            link: function ($scope, $element, $attr) {
                var clip = new window.ZeroClipboard($element.get(0), {
                    moviePath: "img/ZeroClipboard.swf"
                });

                clip.on('complete', function (client, args) {
                    if (args.text && angular.isString(args.text)) {
                        notification('info', "Copied text to clipboard: " + args.text.truncate(20));
                    }
                    Core.$apply($scope);
                });

                if ('useCallback' in $attr) {
                    var func = $parse($attr['useCallback']);
                    if (func) {
                        func($scope, { clip: clip });
                    }
                }
            }
        };
    }
    UI.ZeroClipboardDirective = ZeroClipboardDirective;
})(UI || (UI = {}));
/**
* @module UI
*/
var UI;
(function (UI) {
    var EditableProperty = (function () {
        function EditableProperty($parse) {
            this.$parse = $parse;
            this.restrict = 'E';
            this.scope = true;
            this.templateUrl = UI.templatePath + 'editableProperty.html';
            this.require = 'ngModel';
            this.link = null;
            this.link = function (scope, element, attrs, ngModel) {
                scope.editing = false;
                $(element.find(".icon-pencil")[0]).hide();

                scope.getPropertyName = function () {
                    var propertyName = $parse(attrs['property'])(scope);
                    if (!propertyName && propertyName !== 0) {
                        propertyName = attrs['property'];
                    }
                    return propertyName;
                };

                scope.propertyName = scope.getPropertyName();

                ngModel.$render = function () {
                    if (!ngModel.$viewValue) {
                        return;
                    }
                    scope.text = ngModel.$viewValue[scope.propertyName];
                };

                scope.getInputStyle = function () {
                    if (!scope.text) {
                        return {};
                    }
                    return {
                        width: (scope.text + "").length / 1.5 + 'em'
                    };
                };

                scope.showEdit = function () {
                    $(element.find(".icon-pencil")[0]).show();
                };

                scope.hideEdit = function () {
                    $(element.find(".icon-pencil")[0]).hide();
                };

                scope.$watch('editing', function (newValue, oldValue) {
                    if (newValue !== oldValue) {
                        if (newValue) {
                            $(element.find('input[type=text]')).focus();
                        }
                    }
                });

                scope.doEdit = function () {
                    scope.editing = true;
                };

                scope.stopEdit = function () {
                    $(element.find(":input[type=text]")[0]).val(ngModel.$viewValue[scope.propertyName]);
                    scope.editing = false;
                };

                scope.saveEdit = function () {
                    var value = $(element.find(":input[type=text]")[0]).val();
                    var obj = ngModel.$viewValue;

                    obj[scope.propertyName] = value;

                    ngModel.$setViewValue(obj);
                    ngModel.$render();
                    scope.editing = false;
                    scope.$parent.$eval(attrs['onSave']);
                };
            };
        }
        return EditableProperty;
    })();
    UI.EditableProperty = EditableProperty;
})(UI || (UI = {}));
/**
* @module UI
*/
var UI;
(function (UI) {
    var JSPlumb = (function () {
        function JSPlumb() {
            this.restrict = 'A';
            this.link = function ($scope, $element, $attrs) {
                // Whether or not each node in the graph can be dragged around
                var enableDragging = true;
                if (angular.isDefined($attrs['draggable'])) {
                    enableDragging = Core.parseBooleanValue($attrs['draggable']);
                }

                var useLayout = true;
                if (angular.isDefined($attrs['layout'])) {
                    useLayout = Core.parseBooleanValue($attrs['layout']);
                }

                var timeout = 100;
                if (angular.isDefined($attrs['timeout'])) {
                    timeout = Core.parseIntValue($attrs['timeout'], "timeout");
                }

                var endpointStyle = ["Dot", { radius: 10, cssClass: 'jsplumb-circle', hoverClass: 'jsplumb-circle-hover' }];
                var labelStyles = ["Label"];
                var arrowStyles = [
                    "Arrow", {
                        location: 1,
                        id: "arrow",
                        length: 8,
                        width: 8,
                        foldback: 0.8
                    }];

                var connectorStyle = ["Flowchart", { cornerRadius: 4, gap: 8 }];

                if (angular.isDefined($scope.connectorStyle)) {
                    connectorStyle = $scope.connectorStyle;
                }

                // Given an element, create a node data structure
                var createNode = function (nodeEl) {
                    var el = $(nodeEl);
                    var id = el.attr('id');
                    var anchors = el.attr('anchors');
                    if (anchors.has("{{") || anchors.has("}}")) {
                        // we don't want to add this yet...
                        return null;
                    }
                    if (anchors) {
                        anchors = anchors.split(',').map(function (anchor) {
                            return anchor.trim();
                        });
                    } else {
                        anchors = ["Top"];
                    }

                    var node = {
                        id: id,
                        label: 'node ' + id,
                        el: el,
                        width: el.outerWidth(),
                        height: el.outerHeight(),
                        edges: [],
                        connections: [],
                        endpoints: [],
                        anchors: anchors
                    };

                    return node;
                };

                var createEndpoint = function (jsPlumb, node) {
                    var endpoint = jsPlumb.addEndpoint(node.el, {
                        isSource: true,
                        isTarget: true,
                        anchor: node.anchors,
                        connector: connectorStyle,
                        maxConnections: -1
                    });
                    node.endpoints.push(endpoint);

                    //$scope.jsPlumbEndpoints[node.id] = endpoint
                    if (enableDragging) {
                        jsPlumb.draggable(node.el, {
                            containment: $element
                        });
                    }
                };

                var nodes = [];
                var transitions = [];
                var nodesById = {};

                var gatherElements = function () {
                    var nodeEls = $element.find('.jsplumb-node');

                    angular.forEach(nodeEls, function (nodeEl) {
                        if (!nodesById[nodeEl.id]) {
                            var node = createNode(nodeEl);
                            if (node) {
                                nodes.push(node);
                                nodesById[node.id] = node;
                            }
                        }
                    });

                    angular.forEach(nodes, function (sourceNode) {
                        var targets = sourceNode.el.attr('connect-to');
                        if (targets) {
                            targets = targets.split(',');
                            angular.forEach(targets, function (target) {
                                var targetNode = nodesById[target.trim()];
                                if (targetNode) {
                                    var edge = {
                                        source: sourceNode,
                                        target: targetNode
                                    };
                                    transitions.push(edge);
                                    sourceNode.edges.push(edge);
                                    targetNode.edges.push(edge);
                                }
                            });
                        }
                    });
                };

                /*
                $element.bind('DOMNodeInserted', (event) => {
                if ($scope.jsPlumb) {
                if (angular.isString(event.target.className)
                && !event.target.className.has("_jsPlumb_endpoint_anchor_")
                && event.target.className.has("jsplumb-node")) {
                // TODO - handle added nodes here, like from ng-repeat for example
                //console.log("DOMNodeInserted: ", event);
                gatherElements();
                var newNodes = nodes.filter((node) => { return node.endpoints.isEmpty(); });
                if (newNodes && newNodes.length) {
                angular.forEach(newNodes, (node) => {
                //console.log("Adding node: ", node.id);
                createEndpoint($scope.jsPlumb, node);
                });
                $scope.jsPlumb.repaintEverything();
                Core.$applyLater($scope);
                }
                }
                }
                });
                */
                // Kick off the initial layout of elements in the container
                setTimeout(function () {
                    $scope.jsPlumb = jsPlumb.getInstance({
                        Container: $element
                    });

                    $scope.jsPlumb.importDefaults({
                        Anchor: "AutoDefault",
                        Connector: "Flowchart",
                        ConnectorStyle: connectorStyle,
                        DragOptions: { cursor: "pointer", zIndex: 2000 },
                        Endpoint: endpointStyle,
                        PaintStyle: { strokeStyle: "#42a62c", lineWidth: 4 },
                        HoverPaintStyle: { strokeStyle: "#42a62c", lineWidth: 4 },
                        ConnectionOverlays: [
                            arrowStyles,
                            labelStyles
                        ]
                    });

                    gatherElements();

                    $scope.jsPlumbNodes = nodes;
                    $scope.jsPlumbNodesById = nodesById;
                    $scope.jsPlumbTransitions = transitions;

                    //$scope.jsPlumbEndpoints = {};
                    //$scope.jsPlumbConnections = [];
                    // First we'll lay out the graph and then later apply jsplumb to all
                    // of the nodes and connections
                    if (useLayout) {
                        $scope.layout = dagre.layout().nodeSep(50).edgeSep(10).rankSep(50).nodes(nodes).edges(transitions).debugLevel(1).run();
                    }

                    angular.forEach($scope.jsPlumbNodes, function (node) {
                        if (useLayout) {
                            node.el.css({ top: node.dagre.y, left: node.dagre.x });
                        }
                        createEndpoint($scope.jsPlumb, node);
                    });

                    angular.forEach($scope.jsPlumbTransitions, function (edge) {
                        var connection = $scope.jsPlumb.connect({
                            source: edge.source.el,
                            target: edge.target.el
                        }, {
                            connector: connectorStyle,
                            maxConnections: -1
                        });
                        edge.source.connections.push(connection);
                        edge.target.connections.push(connection);
                        //$scope.jsPlumbConnections.push(connection);
                    });

                    $scope.jsPlumb.recalculateOffsets($element);
                    $scope.jsPlumb.repaintEverything();

                    if (angular.isDefined($scope.jsPlumbCallback) && angular.isFunction($scope.jsPlumbCallback)) {
                        $scope.jsPlumbCallback($scope.jsPlumb, $scope.jsPlumbNodes, $scope.jsPlumbNodesById, $scope.jsPlumbTransitions);
                    }

                    Core.$apply($scope);
                }, timeout);
            };
        }
        return JSPlumb;
    })();
    UI.JSPlumb = JSPlumb;
})(UI || (UI = {}));
/**
* @module UI
*/
var UI;
(function (UI) {
    function TemplatePopover($templateCache, $compile, $document) {
        return {
            restrict: 'A',
            link: function ($scope, $element, $attr) {
                var title = UI.getIfSet('title', $attr, undefined);
                var trigger = UI.getIfSet('trigger', $attr, 'hover');
                var html = true;
                var contentTemplate = UI.getIfSet('content', $attr, 'popoverTemplate');
                var placement = UI.getIfSet('placement', $attr, 'auto');
                var delay = UI.getIfSet('delay', $attr, '100');
                var container = UI.getIfSet('container', $attr, 'body');
                var selector = UI.getIfSet('selector', $attr, 'false');

                if (container === 'false') {
                    container = false;
                }

                if (selector === 'false') {
                    selector = false;
                }

                var template = $templateCache.get(contentTemplate);

                if (!template) {
                    return;
                }

                $element.on('$destroy', function () {
                    $element.popover('destroy');
                });

                $element.popover({
                    title: title,
                    trigger: trigger,
                    html: html,
                    content: function () {
                        return $compile(template)($scope);
                    },
                    delay: delay,
                    container: container,
                    selector: selector,
                    placement: function (tip, element) {
                        if (placement !== 'auto') {
                            return placement;
                        }

                        var el = $element;
                        var offset = el.offset();

                        /* not sure on auto bottom/top
                        
                        var elVerticalCenter = offset['top'] + (el.outerHeight() / 2);
                        if (elVerticalCenter < 300) {
                        return 'bottom';
                        }
                        
                        var height = window.innerHeight;
                        if (elVerticalCenter > window.innerHeight - 300) {
                        return 'top';
                        }
                        */
                        var width = $document.innerWidth();
                        var elHorizontalCenter = offset['left'] + (el.outerWidth() / 2);
                        var midpoint = width / 2;
                        if (elHorizontalCenter < midpoint) {
                            return 'right';
                        } else {
                            return 'left';
                        }
                    }
                });
            }
        };
    }
    UI.TemplatePopover = TemplatePopover;
})(UI || (UI = {}));
/**
* Module that contains several helper functions related to hawtio's code editor
*
* @module CodeEditor
* @main CodeEditor
*/
var CodeEditor;
(function (CodeEditor) {
    

    /**
    * @property GlobalCodeMirrorOptions
    * @for CodeEditor
    * @type CodeMirrorOptions
    */
    CodeEditor.GlobalCodeMirrorOptions = {
        theme: "default",
        tabSize: 4,
        lineNumbers: true,
        indentWithTabs: true,
        lineWrapping: true,
        autoCloseTags: true
    };

    /**
    * Controller used on the preferences page to configure the editor
    *
    * @method PreferencesController
    * @for CodeEditor
    * @static
    * @param $scope
    * @param localStorage
    * @param $templateCache
    */
    function PreferencesController($scope, localStorage, $templateCache) {
        $scope.exampleText = $templateCache.get("exampleText");
        $scope.codeMirrorEx = $templateCache.get("codeMirrorExTemplate");
        $scope.javascript = "javascript";

        $scope.preferences = CodeEditor.GlobalCodeMirrorOptions;

        // If any of the preferences change, make sure to save them automatically
        $scope.$watch("preferences", function (newValue, oldValue) {
            if (newValue !== oldValue) {
                // such a cheap and easy way to update the example view :-)
                $scope.codeMirrorEx += " ";
                localStorage['CodeMirrorOptions'] = angular.toJson(angular.extend(CodeEditor.GlobalCodeMirrorOptions, $scope.preferences));
            }
        }, true);
    }
    CodeEditor.PreferencesController = PreferencesController;

    /**
    * Tries to figure out what kind of text we're going to render in the editor, either
    * text, javascript or XML.
    *
    * @method detectTextFormat
    * @for CodeEditor
    * @static
    * @param value
    * @returns {string}
    */
    function detectTextFormat(value) {
        var answer = "text";
        if (value) {
            answer = "javascript";
            var trimmed = value.toString().trimLeft().trimRight();
            if (trimmed && trimmed.first() === '<' && trimmed.last() === '>') {
                answer = "xml";
            }
        }
        return answer;
    }
    CodeEditor.detectTextFormat = detectTextFormat;

    /**
    * Auto formats the CodeMirror editor content to pretty print
    *
    * @method autoFormatEditor
    * @for CodeEditor
    * @static
    * @param {CodeMirrorEditor} editor
    * @return {void}
    */
    function autoFormatEditor(editor) {
        if (editor) {
            var totalLines = editor.lineCount();

            //var totalChars = editor.getValue().length;
            var start = { line: 0, ch: 0 };
            var end = { line: totalLines - 1, ch: editor.getLine(totalLines - 1).length };
            editor.autoFormatRange(start, end);
            editor.setSelection(start, start);
        }
    }
    CodeEditor.autoFormatEditor = autoFormatEditor;

    /**
    * Used to configures the default editor settings (per Editor Instance)
    *
    * @method createEditorSettings
    * @for CodeEditor
    * @static
    * @param {Object} options
    * @return {Object}
    */
    function createEditorSettings(options) {
        if (typeof options === "undefined") { options = {}; }
        options.extraKeys = options.extraKeys || {};

        // Handle Mode
        (function (mode) {
            mode = mode || { name: "text" };

            if (typeof mode !== "object") {
                mode = { name: mode };
            }

            var modeName = mode.name;
            if (modeName === "javascript") {
                angular.extend(mode, {
                    "json": true
                });
            }
        })(options.mode);

        // Handle Code folding folding
        (function (options) {
            var javascriptFolding = CodeMirror.newFoldFunction(CodeMirror.braceRangeFinder);
            var xmlFolding = CodeMirror.newFoldFunction(CodeMirror.tagRangeFinder);

            // Mode logic inside foldFunction to allow for dynamic changing of the mode.
            // So don't have to listen to the options model and deal with re-attaching events etc...
            var foldFunction = function (codeMirror, line) {
                var mode = codeMirror.getOption("mode");
                var modeName = mode["name"];
                if (!mode || !modeName)
                    return;
                if (modeName === 'javascript') {
                    javascriptFolding(codeMirror, line);
                } else if (modeName === "xml" || modeName.startsWith("html")) {
                    xmlFolding(codeMirror, line);
                }
                ;
            };

            options.onGutterClick = foldFunction;
            options.extraKeys = angular.extend(options.extraKeys, {
                "Ctrl-Q": function (codeMirror) {
                    foldFunction(codeMirror, codeMirror.getCursor().line);
                }
            });
        })(options);

        var readOnly = options.readOnly;
        if (!readOnly) {
            /*
            options.extraKeys = angular.extend(options.extraKeys, {
            "'>'": function (codeMirror) {
            codeMirror.closeTag(codeMirror, '>');
            },
            "'/'": function (codeMirror) {
            codeMirror.closeTag(codeMirror, '/');
            }
            });
            */
            options.matchBrackets = true;
        }

        // Merge the global config in to this instance of CodeMirror
        angular.extend(options, CodeEditor.GlobalCodeMirrorOptions);

        return options;
    }
    CodeEditor.createEditorSettings = createEditorSettings;
})(CodeEditor || (CodeEditor = {}));
/**
* @module UI
*/
var UI;
(function (UI) {
    /**
    * Directive class that organizes child elements into columns automatically
    *
    * @class AutoColumns
    */
    var AutoColumns = (function () {
        function AutoColumns() {
            this.restrict = 'A';
            this.link = function ($scope, $element, $attr) {
                var selector = UI.getIfSet('hawtioAutoColumns', $attr, 'div');
                var minMargin = UI.getIfSet('minMargin', $attr, '3').toNumber();

                var go = function () {
                    var containerWidth = $element.innerWidth();
                    var childWidth = 0;

                    var children = $element.children(selector);

                    if (children.length === 0) {
                        UI.log.debug("No children, skipping calculating column margins");
                        return;
                    }

                    // find the biggest child, though really they should all be the same size...
                    children.each(function (child) {
                        var self = $(this);
                        if (!self.is(':visible')) {
                            return;
                        }
                        if (self.outerWidth() > childWidth) {
                            childWidth = self.outerWidth();
                        }
                    });

                    if (childWidth === 0) {
                        return;
                    }

                    childWidth = childWidth + (minMargin * 2);

                    var columns = Math.floor(containerWidth / childWidth);
                    if (children.length < columns) {
                        columns = children.length;
                    }
                    var margin = (containerWidth - (columns * childWidth)) / columns / 2;

                    //log.debug("child width: ", childWidth);
                    //log.debug("Inner width: ", containerWidth);
                    //log.debug("columns: ", columns);
                    //log.debug("margin: ", margin);
                    children.each(function (child) {
                        $(this).css({
                            'margin-left': margin,
                            'margin-right': margin
                        });
                    });
                };

                setTimeout(go, 300);
                $scope.$watch(go);
                $(window).resize(go);
            };
        }
        return AutoColumns;
    })();
    UI.AutoColumns = AutoColumns;
})(UI || (UI = {}));
/**
* @module UI
*/
var UI;
(function (UI) {
    function hawtioDropDown($templateCache) {
        return {
            restrict: 'A',
            replace: true,
            templateUrl: UI.templatePath + 'dropDown.html',
            scope: {
                config: '=hawtioDropDown'
            },
            controller: function ($scope, $element, $attrs) {
                if (!$scope.config) {
                    $scope.config = {};
                }

                if (!('open' in $scope.config)) {
                    $scope.config['open'] = false;
                }

                $scope.action = function (config, $event) {
                    //log.debug("doAction on : ", config, "event: ", $event);
                    if ('items' in config && !('action' in config)) {
                        config.open = !config.open;
                        $event.preventDefault();
                        $event.stopPropagation();
                    } else if ('action' in config) {
                        //log.debug("executing action: ", config.action);
                        var action = config['action'];
                        if (angular.isFunction(action)) {
                            action.apply();
                        } else if (angular.isString(action)) {
                            $scope.$parent.$eval(action, {
                                config: config,
                                '$event': $event
                            });
                        }
                    }
                };

                $scope.$watch('config.items', function (newValue, oldValue) {
                    if (newValue !== oldValue) {
                        // just add some space to force a redraw
                        $scope.menuStyle = $scope.menuStyle + " ";
                    }
                }, true);

                $scope.submenu = function (config) {
                    if (config && config.submenu) {
                        return "sub-menu";
                    }
                    return "";
                };

                $scope.icon = function (config) {
                    if (config && !Core.isBlank(config.icon)) {
                        return config.icon;
                    } else {
                        return 'icon-spacer';
                    }
                };

                $scope.open = function (config) {
                    if (config && !config.open) {
                        return '';
                    }
                    return 'open';
                };
            },
            link: function ($scope, $element, $attrs) {
                $scope.menuStyle = $templateCache.get("withsubmenus.html");

                if ('processSubmenus' in $attrs) {
                    if (!Core.parseBooleanValue($attrs['processSubmenus'])) {
                        $scope.menuStyle = $templateCache.get("withoutsubmenus.html");
                    }
                }
            }
        };
    }
    UI.hawtioDropDown = hawtioDropDown;
})(UI || (UI = {}));
/**
* @module Tree
* @main Tree
*/
var Tree;
(function (Tree) {
    Tree.pluginName = 'tree';
    Tree.log = Logger.get("Tree");

    /**
    * @function sanitize
    * @param tree
    *
    * Use to HTML escape all entries in a tree before passing it
    * over to the dynatree plugin to avoid cross site scripting
    * issues.
    *
    */
    function sanitize(tree) {
        if (!tree) {
            return;
        }
        if (angular.isArray(tree)) {
            tree.forEach(function (folder) {
                Tree.sanitize(folder);
            });
        }
        var title = tree['title'];
        if (title) {
            tree['title'] = title.unescapeHTML(true).escapeHTML();
        }
        if (tree.children) {
            Tree.sanitize(tree.children);
        }
    }
    Tree.sanitize = sanitize;

    angular.module(Tree.pluginName, ['bootstrap', 'ngResource', 'hawtioCore']).directive('hawtioTree', function (workspace, $timeout, $location) {
        // return the directive link function. (compile function not needed)
        return function (scope, element, attrs) {
            var tree = null;
            var data = null;
            var widget = null;
            var timeoutId = null;
            var onSelectFn = lookupFunction("onselect");
            var onDragStartFn = lookupFunction("ondragstart");
            var onDragEnterFn = lookupFunction("ondragenter");
            var onDropFn = lookupFunction("ondrop");

            function lookupFunction(attrName) {
                var answer = null;
                var fnName = attrs[attrName];
                if (fnName) {
                    answer = Core.pathGet(scope, fnName);
                    if (!angular.isFunction(answer)) {
                        answer = null;
                    }
                }
                return answer;
            }

            // watch the expression, and update the UI on change.
            var data = attrs.hawtioTree;
            var queryParam = data;

            scope.$watch(data, onWidgetDataChange);

            // lets add a separate event so we can force updates
            // if we find cases where the delta logic doesn't work
            scope.$on("hawtio.tree." + data, function (args) {
                var value = Core.pathGet(scope, data);
                onWidgetDataChange(value);
            });

            // listen on DOM destroy (removal) event, and cancel the next UI update
            // to prevent updating ofter the DOM element was removed.
            element.bind('$destroy', function () {
                $timeout.cancel(timeoutId);
            });

            updateLater(); // kick off the UI update process.

            // used to update the UI
            function updateWidget() {
                // console.log("updating the grid!!");
                Core.$applyNowOrLater(scope);
            }

            function onWidgetDataChange(value) {
                tree = value;
                if (tree) {
                    Tree.sanitize(tree);
                }
                if (tree && !widget) {
                    // lets find a child table element
                    // or lets add one if there's not one already
                    var treeElement = $(element);
                    var children = Core.asArray(tree);
                    var hideRoot = attrs["hideroot"];
                    if ("true" === hideRoot) {
                        children = tree['children'];
                    }
                    var config = {
                        clickFolderMode: 3,
                        /*
                        * The event handler called when a different node in the tree is selected
                        */
                        onActivate: function (node) {
                            var data = node.data;
                            if (onSelectFn) {
                                onSelectFn(data, node);
                            } else {
                                workspace.updateSelectionNode(data);
                            }
                            Core.$apply(scope);
                        },
                        /*
                        onLazyRead: function(treeNode) {
                        var folder = treeNode.data;
                        var plugin = null;
                        if (folder) {
                        plugin = Jmx.findLazyLoadingFunction(workspace, folder);
                        }
                        if (plugin) {
                        console.log("Lazy loading folder " + folder.title);
                        var oldChildren = folder.childen;
                        plugin(workspace, folder, () => {
                        treeNode.setLazyNodeStatus(DTNodeStatus_Ok);
                        var newChildren = folder.children;
                        if (newChildren !== oldChildren) {
                        treeNode.removeChildren();
                        angular.forEach(newChildren, newChild => {
                        treeNode.addChild(newChild);
                        });
                        }
                        });
                        } else {
                        treeNode.setLazyNodeStatus(DTNodeStatus_Ok);
                        }
                        },
                        */
                        onClick: function (node, event) {
                            if (event["metaKey"]) {
                                event.preventDefault();
                                var url = $location.absUrl();
                                if (node && node.data) {
                                    var key = node.data["key"];
                                    if (key) {
                                        var hash = $location.search();
                                        hash[queryParam] = key;

                                        // TODO this could maybe be a generic helper function?
                                        // lets trim after the ?
                                        var idx = url.indexOf('?');
                                        if (idx <= 0) {
                                            url += "?";
                                        } else {
                                            url = url.substring(0, idx + 1);
                                        }
                                        url += $.param(hash);
                                    }
                                }
                                window.open(url, '_blank');
                                window.focus();
                                return false;
                            }
                            return true;
                        },
                        persist: false,
                        debugLevel: 0,
                        children: children,
                        dnd: {
                            onDragStart: onDragStartFn ? onDragStartFn : function (node) {
                                /* This function MUST be defined to enable dragging for the tree.
                                *  Return false to cancel dragging of node.
                                */
                                console.log("onDragStart!");
                                return true;
                            },
                            onDragEnter: onDragEnterFn ? onDragEnterFn : function (node, sourceNode) {
                                console.log("onDragEnter!");
                                return true;
                            },
                            onDrop: onDropFn ? onDropFn : function (node, sourceNode, hitMode) {
                                console.log("onDrop!");

                                /* This function MUST be defined to enable dropping of items on
                                *  the tree.
                                */
                                sourceNode.move(node, hitMode);
                                return true;
                            }
                        }
                    };
                    if (!onDropFn && !onDragEnterFn && !onDragStartFn) {
                        delete config["dnd"];
                    }
                    widget = treeElement.dynatree(config);

                    var activatedNode = false;
                    var activateNodeName = attrs["activatenodes"];
                    if (activateNodeName) {
                        var values = scope[activateNodeName];
                        var tree = treeElement.dynatree("getTree");
                        if (values && tree) {
                            angular.forEach(Core.asArray(values), function (value) {
                                //tree.selectKey(value, true);
                                tree.activateKey(value);
                                activatedNode = true;
                            });
                        }
                    }
                    var root = treeElement.dynatree("getRoot");
                    if (root) {
                        var onRootName = attrs["onroot"];
                        if (onRootName) {
                            var fn = scope[onRootName];
                            if (fn) {
                                fn(root);
                            }
                        }

                        // select and activate first child if we have not activated any others
                        if (!activatedNode) {
                            var children = root['getChildren']();
                            if (children && children.length) {
                                var child = children[0];
                                child.expand(true);
                                child.activate(true);
                            }
                        }
                    }
                }
                updateWidget();
            }

            // schedule update in one second
            function updateLater() {
                // save the timeoutId for canceling
                timeoutId = $timeout(function () {
                    updateWidget(); // update DOM
                }, 300);
            }
        };
    }).run(function (helpRegistry) {
        helpRegistry.addDevDoc(Tree.pluginName, 'app/tree/doc/developer.md');
    });

    hawtioPluginLoader.addModule(Tree.pluginName);
})(Tree || (Tree = {}));
/**
* @module Source
*/
var Source;
(function (Source) {
    function JavaDocController($scope, $location, $routeParams, workspace, fileExtensionTypeRegistry, jolokia) {
        $scope.pageId = Wiki.pageId($routeParams, $location);
        var mavenCoords = $routeParams["mavenCoords"];
        var fileName = $scope.pageId;

        $scope.loadingMessage = "Loading javadoc code for file <b>" + fileName + "</b> from artifacts <b>" + mavenCoords + "</b>";

        $scope.breadcrumbs = [];

        // TODO load breadcrumbs
        // $scope.breadcrumbs.push({href: "#" + loc, name: name});
        $scope.$watch('workspace.tree', function () {
            if (!$scope.git && Git.getGitMBean(workspace)) {
                // lets do this asynchronously to avoid Error: $digest already in progress
                //console.log("Reloading the view as we now seem to have a git mbean!");
                setTimeout(updateView, 50);
            }
        });

        $scope.$on("$routeChangeSuccess", function (event, current, previous) {
            // lets do this asynchronously to avoid Error: $digest already in progress
            setTimeout(updateView, 50);
        });

        function viewContents(response) {
            $scope.source = response;
            $scope.loadingMessage = null;
            if (!response) {
                var time = new Date().getTime();
                if (!$scope.lastErrorTime || time - $scope.lastErrorTime > 3000) {
                    $scope.lastErrorTime = time;
                    notification("error", "Could not download the source code for the maven artifacts: " + mavenCoords);
                }
            }
            Core.$apply($scope);
        }

        function updateView() {
            var mbean = Source.getInsightMBean(workspace);
            if (mbean) {
                jolokia.execute(mbean, "getJavaDoc", mavenCoords, fileName, onSuccess(viewContents));
            }
        }
    }
    Source.JavaDocController = JavaDocController;
})(Source || (Source = {}));
/**
* @module Source
*/
var Source;
(function (Source) {
    function SourceController($scope, $location, $routeParams, workspace, fileExtensionTypeRegistry, jolokia) {
        $scope.pageId = Wiki.pageId($routeParams, $location);
        $scope.format = Wiki.fileFormat($scope.pageId, fileExtensionTypeRegistry);
        var lineNumber = $location.search()["line"] || 1;
        var mavenCoords = $routeParams["mavenCoords"];
        var className = $routeParams["className"] || "";
        var fileName = $scope.pageId || "/";
        var classNamePath = className.replace(/\./g, '/');

        $scope.loadingMessage = "Loading source code for class <b>" + className + "</b> from artifacts <b>" + mavenCoords + "</b>";

        //console.log("Source format is " + $scope.format + " line " + lineNumber + " className " + className + " file " + fileName);
        $scope.breadcrumbs = [];

        var idx = fileName.lastIndexOf('/');
        var path = "/";
        var name = fileName;
        if (idx > 0) {
            path = fileName.substring(0, idx);
            name = fileName.substring(idx + 1);
        } else if (className && className.indexOf('.') > 0) {
            path = classNamePath;
            idx = path.lastIndexOf('/');
            if (idx > 0) {
                name = path.substring(idx + 1);
                path = path.substring(0, idx);
            }
        }
        $scope.breadcrumbs = Source.createBreadcrumbLinks(mavenCoords, path);
        $scope.breadcrumbs.push({ href: $location.url(), name: name, active: true });

        $scope.javaDocLink = function () {
            var path = classNamePath;
            if (!path && fileName && fileName.endsWith(".java")) {
                path = fileName.substring(0, fileName.length - 5);
            }
            if (path) {
                return "javadoc/" + mavenCoords + "/" + path + ".html";
            }
            return null;
        };

        function updateLineSelection() {
            var codeMirror = $scope.codeMirror;
            if (codeMirror && lineNumber) {
                var line = lineNumber - 1;
                var lineText = codeMirror.getLine(line);
                var endChar = (lineText) ? lineText.length : 1000;
                var start = { line: line, ch: 0 };
                var end = { line: line, ch: endChar };
                codeMirror.scrollIntoView(start);
                codeMirror.setCursor(start);
                codeMirror.setSelection(start, end);
                codeMirror.refresh();
                codeMirror.focus();
            }
        }

        $scope.$watch('workspace.tree', function (oldValue, newValue) {
            if (!$scope.git && Git.getGitMBean(workspace)) {
                // lets do this asynchronously to avoid Error: $digest already in progress
                //console.log("Reloading the view as we now seem to have a git mbean!");
                setTimeout(maybeUpdateView, 50);
            }
        });

        $scope.$on("$routeChangeSuccess", function (event, current, previous) {
            // lets do this asynchronously to avoid Error: $digest already in progress
            setTimeout(maybeUpdateView, 50);
        });

        function viewContents(response) {
            if (response) {
                Source.log.debug("Downloaded file for the maven artifact: " + mavenCoords);
                $scope.source = response;
                $scope.loadingMessage = null;
            } else {
                // we could not download the source code
                $scope.source = null;
                $scope.loadingMessage = "Cannot download file, please see logging console for details.";
                Source.log.error("Failed to download the source code for the Maven artifact: ", mavenCoords);
            }
            Core.$apply($scope);

            // lets update the line selection asynchronously to check we've properly loaded by now
            setTimeout(updateLineSelection, 100);
        }

        function updateView() {
            var mbean = Source.getInsightMBean(workspace);
            if (mbean) {
                jolokia.execute(mbean, "getSource", mavenCoords, className, fileName, {
                    success: viewContents,
                    error: function (response) {
                        Source.log.error("Failed to download the source code for the Maven artifact: ", mavenCoords);
                        Source.log.info("Stack trace: ", response.stacktrace);
                        $scope.loadingMessage = "Cannot not download file, please see logging console for details.";
                        Core.$apply($scope);
                    }
                });
            }
        }

        var maybeUpdateView = Core.throttled(updateView, 1000);
        setTimeout(maybeUpdateView, 50);
    }
    Source.SourceController = SourceController;
})(Source || (Source = {}));
/**
* @module Source
*/
var Source;
(function (Source) {
    Source.log = Logger.get("Source");

    /**
    * @method getInsightMBean
    * @for Source
    * @param {Core.Workspace} workspace
    * @returns {*}
    */
    function getInsightMBean(workspace) {
        var mavenStuff = workspace.mbeanTypesToDomain["LogQuery"] || {};
        var insight = mavenStuff["org.fusesource.insight"] || mavenStuff["io.fabric8.insight"] || {};
        var mbean = insight.objectName;
        return mbean;
    }
    Source.getInsightMBean = getInsightMBean;

    /**
    * @method createBreadcrumbLinks
    * @for Source
    * @param {String} mavenCoords
    * @param {pathName} pathName
    * @returns {Array}
    */
    function createBreadcrumbLinks(mavenCoords, pathName) {
        var linkPrefix = "#/source/index/" + mavenCoords;
        var answer = [{ href: linkPrefix, name: "root" }];
        if (pathName) {
            var pathNames = pathName.split("/");
            var fullPath = "";
            angular.forEach(pathNames, function (path) {
                fullPath += "/" + path;
                var href = linkPrefix + fullPath;
                if (!path.isBlank()) {
                    answer.push({ href: href, name: path || "/", fileName: "/" + fullPath });
                }
            });
        }
        return answer;
    }
    Source.createBreadcrumbLinks = createBreadcrumbLinks;
})(Source || (Source = {}));
/**
* @module Source
* @main Source
*/
var Source;
(function (Source) {
    var pluginName = 'source';
    angular.module(pluginName, ['bootstrap', 'ngResource', 'hawtioCore', 'wiki']).config(function ($routeProvider) {
        $routeProvider.when('/source/index/:mavenCoords', { templateUrl: 'app/source/html/index.html' }).when('/source/index/:mavenCoords/*page', { templateUrl: 'app/source/html/index.html' }).when('/source/view/:mavenCoords/class/:className/*page', { templateUrl: 'app/source/html/source.html' }).when('/source/view/:mavenCoords/*page', { templateUrl: 'app/source/html/source.html' }).when('/source/javadoc/:mavenCoords/*page', { templateUrl: 'app/source/html/javadoc.html' });
    }).run(function ($location, workspace, viewRegistry, jolokia, localStorage, layoutFull, helpRegistry) {
        viewRegistry['source'] = layoutFull;
        helpRegistry.addUserDoc('source', 'app/source/doc/help.md');
    });

    hawtioPluginLoader.addModule(pluginName);
})(Source || (Source = {}));
/**
* @module Source
*/
var Source;
(function (Source) {
    function IndexController($scope, $location, $routeParams, workspace, jolokia) {
        $scope.pageId = Wiki.pageId($routeParams, $location);
        $scope.mavenCoords = $routeParams["mavenCoords"];
        var fileName = $scope.pageId;
        if (fileName === '/') {
            fileName = undefined;
        }

        $scope.loadingMessage = "Loading source code from artifacts <b>" + $scope.mavenCoords + "</b>";

        createBreadcrumbs();

        $scope.setFileName = function (breadcrumb) {
            fileName = Core.trimLeading(breadcrumb.fileName, "/");
            fileName = Core.trimLeading(fileName, "/");
            console.log("selected fileName '" + fileName + "'");
            createBreadcrumbs();
            filterFileNames();
        };

        $scope.$watch('workspace.tree', function (newValue, oldValue) {
            if (!$scope.git && Git.getGitMBean(workspace)) {
                // lets do this asynchronously to avoid Error: $digest already in progress
                //console.log("Reloading the view as we now seem to have a git mbean!");
                setTimeout(maybeUpdateView, 50);
            }
        });

        $scope.$on("$routeChangeSuccess", function (event, current, previous) {
            // lets do this asynchronously to avoid Error: $digest already in progress
            setTimeout(maybeUpdateView, 50);
        });

        function filterFileNames() {
            if (fileName) {
                $scope.sourceFiles = $scope.allSourceFiles.filter(function (n) {
                    return n && n.startsWith(fileName);
                }).map(function (n) {
                    return n.substring(fileName.length + 1);
                }).filter(function (n) {
                    return n;
                });
            } else {
                $scope.sourceFiles = $scope.allSourceFiles;
            }
        }

        $scope.sourceLinks = function (aFile) {
            var name = aFile;
            var paths = null;
            var idx = aFile.lastIndexOf('/');
            if (idx > 0) {
                name = aFile.substring(idx + 1);
                paths = aFile.substring(0, idx);
            }
            var answer = "";
            var fullName = fileName || "";
            if (paths) {
                angular.forEach(paths.split("/"), function (path) {
                    if (fullName) {
                        fullName += "/";
                    }
                    fullName += path;
                    answer += "<a href='#/source/index/" + $scope.mavenCoords + "/" + fullName + "'>" + path + "</a>/";
                });
            }
            answer += "<a href='#/source/view/" + $scope.mavenCoords + "/" + fullName + "/" + name + "'>" + name + "</a>";
            return answer;
        };

        function createBreadcrumbs() {
            $scope.breadcrumbs = Source.createBreadcrumbLinks($scope.mavenCoords, fileName);
            angular.forEach($scope.breadcrumbs, function (breadcrumb) {
                breadcrumb.active = false;
            });
            $scope.breadcrumbs.last().active = true;
        }

        function viewContents(response) {
            if (response) {
                $scope.allSourceFiles = response.split("\n").map(function (n) {
                    return n.trim();
                }).filter(function (n) {
                    return n;
                });
            } else {
                $scope.allSourceFiles = [];
            }
            filterFileNames();
            $scope.loadingMessage = null;
            Core.$apply($scope);
        }

        function updateView() {
            if (!$scope.mavenCoords) {
                return;
            }
            var mbean = Source.getInsightMBean(workspace);
            Source.log.debug("In update view, mbean: ", mbean);
            if (mbean) {
                jolokia.execute(mbean, "getSource", $scope.mavenCoords, null, "/", {
                    success: viewContents,
                    error: function (response) {
                        Source.log.error("Failed to download the source code for the maven artifact: ", $scope.mavenCoords);
                        Source.log.info("Stack trace: ", response.stacktrace);
                        $scope.loadingMessage = "Could not download index, please see console for details";
                        Core.$apply($scope);
                    }
                });
            }
        }

        var maybeUpdateView = Core.throttled(updateView, 1000);
        setTimeout(maybeUpdateView, 50);
    }
    Source.IndexController = IndexController;
})(Source || (Source = {}));
/**
* @module JVM
*/
var JVM;
(function (JVM) {
    function NavController($scope, $location, workspace) {
        JVM.configureScope($scope, $location, workspace);
    }
    JVM.NavController = NavController;
})(JVM || (JVM = {}));
/**
* @module JVM
*/
var JVM;
(function (JVM) {
    function JVMsController($scope, $window, $location, workspace, jolokia, mbeanName) {
        JVM.configureScope($scope, $location, workspace);
        $scope.data = [];
        $scope.deploying = false;
        $scope.status = '';

        $scope.fetch = function () {
            notification('info', 'Discovering local JVM processes, please wait...');
            jolokia.request({
                type: 'exec', mbean: mbeanName,
                operation: 'listLocalJVMs()',
                arguments: []
            }, {
                success: render,
                error: function (response) {
                    $scope.data = [];
                    $scope.status = 'Could not discover local JVM processes: ' + response.error;
                    Core.$apply($scope);
                }
            });
        };

        $scope.stopAgent = function (pid) {
            notification('info', "Attempting to detach agent from PID " + pid);
            jolokia.request({
                type: 'exec', mbean: mbeanName,
                operation: 'stopAgent(java.lang.String)',
                arguments: [pid]
            }, onSuccess(function () {
                notification('success', "Detached agent from PID " + pid);
                $scope.fetch();
            }));
        };

        $scope.startAgent = function (pid) {
            notification('info', "Attempting to attach agent to PID " + pid);
            jolokia.request({
                type: 'exec', mbean: mbeanName,
                operation: 'startAgent(java.lang.String)',
                arguments: [pid]
            }, onSuccess(function () {
                notification('success', "Attached agent to PID " + pid);
                $scope.fetch();
            }));
        };

        $scope.connectTo = function (url) {
            $window.open("?url=" + encodeURIComponent(url));
        };

        function render(response) {
            $scope.data = response.value;
            if ($scope.data.length === 0) {
                $scope.status = 'Could not discover local JVM processes';
            }
            Core.$apply($scope);
        }

        $scope.fetch();
    }
    JVM.JVMsController = JVMsController;
})(JVM || (JVM = {}));
var Core;
(function (Core) {
    var log = Logger.get("Core");

    var TasksImpl = (function () {
        function TasksImpl() {
            this.tasks = {};
            this.tasksExecuted = false;
            this._onComplete = null;
        }
        TasksImpl.prototype.addTask = function (name, task) {
            this.tasks[name] = task;
            if (this.tasksExecuted) {
                this.executeTask(name, task);
            }
        };

        TasksImpl.prototype.executeTask = function (name, task) {
            if (angular.isFunction(task)) {
                log.debug("Executing task : ", name);
                try  {
                    task();
                } catch (error) {
                    log.debug("Failed to execute task: ", name, " error: ", error);
                }
            }
        };

        TasksImpl.prototype.onComplete = function (cb) {
            this._onComplete = cb;
        };

        TasksImpl.prototype.execute = function () {
            var _this = this;
            if (this.tasksExecuted) {
                return;
            }
            angular.forEach(this.tasks, function (task, name) {
                _this.executeTask(name, task);
            });
            this.tasksExecuted = true;
            if (angular.isFunction(this._onComplete)) {
                this._onComplete();
            }
        };

        TasksImpl.prototype.reset = function () {
            this.tasksExecuted = false;
        };
        return TasksImpl;
    })();
    Core.TasksImpl = TasksImpl;

    var ParameterizedTasksImpl = (function (_super) {
        __extends(ParameterizedTasksImpl, _super);
        function ParameterizedTasksImpl() {
            var _this = this;
            _super.call(this);
            this.tasks = {};
            this.onComplete(function () {
                _this.reset();
            });
        }
        ParameterizedTasksImpl.prototype.addTask = function (name, task) {
            this.tasks[name] = task;
        };

        ParameterizedTasksImpl.prototype.execute = function () {
            var params = [];
            for (var _i = 0; _i < (arguments.length - 0); _i++) {
                params[_i] = arguments[_i + 0];
            }
            var _this = this;
            if (this.tasksExecuted) {
                return;
            }
            var theArgs = params;
            var keys = Object.keys(this.tasks);
            keys.forEach(function (name) {
                var task = _this.tasks[name];
                if (angular.isFunction(task)) {
                    log.debug("Executing task: ", name, " with parameters: ", theArgs);
                    try  {
                        task.apply(task, theArgs);
                    } catch (e) {
                        log.debug("Failed to execute task: ", name, " error: ", e);
                    }
                }
            });
            this.tasksExecuted = true;
            if (angular.isFunction(this._onComplete)) {
                this._onComplete();
            }
        };
        return ParameterizedTasksImpl;
    })(TasksImpl);
    Core.ParameterizedTasksImpl = ParameterizedTasksImpl;

    Core.postLoginTasks = new Core.TasksImpl();
    Core.preLogoutTasks = new Core.TasksImpl();
})(Core || (Core = {}));
/**
* IDE integration
*
* @module IDE
*/
var IDE;
(function (IDE) {
    var pluginName = 'ide';

    angular.module(pluginName, ['bootstrap', 'hawtioCore']).directive('hawtioOpenIde', function (localStorage, workspace, jolokia) {
        return new IDE.OpenInIdeDirective(localStorage, workspace, jolokia);
    }).run(function (helpRegistry) {
        helpRegistry.addDevDoc('IDE', 'app/ide/doc/developer.md');
    });

    hawtioPluginLoader.addModule(pluginName);
})(IDE || (IDE = {}));
var Core;
(function (Core) {
    var PageTitle = (function () {
        function PageTitle() {
            this.titleElements = [];
        }
        PageTitle.prototype.addTitleElement = function (element) {
            this.titleElements.push(element);
        };

        PageTitle.prototype.getTitle = function () {
            return this.getTitleExcluding([], ' ');
        };

        PageTitle.prototype.getTitleWithSeparator = function (separator) {
            return this.getTitleExcluding([], separator);
        };

        PageTitle.prototype.getTitleExcluding = function (excludes, separator) {
            return this.getTitleArrayExcluding(excludes).join(separator);
        };

        PageTitle.prototype.getTitleArrayExcluding = function (excludes) {
            return this.titleElements.map(function (element) {
                var answer = '';
                if (element) {
                    answer = element();
                    if (answer === null) {
                        return '';
                    }
                }
                return answer;
            }).exclude(excludes).exclude('');
        };
        return PageTitle;
    })();
    Core.PageTitle = PageTitle;
})(Core || (Core = {}));
/**
* The main entry point for hawtio
*
* @module Core
* @main Core
*/
/// <reference path="./coreHelpers.ts"/>
/// <reference path="../../ide/js/idePlugin.ts"/>
/// <reference path="../../helpers/js/urlHelpers.ts"/>
/// <reference path="./pageTitle.ts"/>
var Core;
(function (Core) {
    /**
    * Name of plugin registered to hawtio's plugin loader and Angularjs module name
    *
    * @property pluginName
    * @for Core
    * @type String
    */
    Core.pluginName = 'hawtioCore';

    /**
    * Path to template files for this plugin
    *
    * @property pluginName
    * @for Core
    * @type String
    */
    Core.templatePath = 'app/core/html/';

    /**
    * URL we've detected to find jolokia at we figure this out
    * at script loading time
    */
    // TODO - maybe we can make discovering this async before we call hawtioPluginLoader.loadPlugins() to avoid the blocking HTTP requests it makes currently
    Core.jolokiaUrl = Core.getJolokiaUrl();
    Logger.get("Core").debug("jolokiaUrl " + Core.jolokiaUrl);

    /**
    * The main hawtio core App module
    */
    Core._module = angular.module(Core.pluginName, ['bootstrap', 'ngResource', 'ui', 'ui.bootstrap.dialog', 'hawtio-ui']);

    // configure the module
    Core._module.config([
        "$locationProvider", "$routeProvider", "$dialogProvider", function ($locationProvider, $routeProvider, $dialogProvider) {
            $dialogProvider.options({
                backdropFade: true,
                dialogFade: true
            });

            $routeProvider.when('/help', {
                redirectTo: '/help/index'
            }).when('/login', { templateUrl: Core.templatePath + 'login.html' }).when('/preferences', { templateUrl: Core.templatePath + 'preferences.html' }).when('/welcome', { templateUrl: Core.templatePath + 'welcome.html' }).when('/about', { templateUrl: Core.templatePath + 'about.html' }).when('/help/:topic/', { templateUrl: Core.templatePath + 'help.html' }).when('/help/:topic/:subtopic', { templateUrl: Core.templatePath + 'help.html' });
        }]);

    Core._module.constant('layoutTree', Core.templatePath + 'layoutTree.html');
    Core._module.constant('layoutFull', Core.templatePath + 'layoutFull.html');

    Core._module.filter("valueToHtml", function () {
        return Core.valueToHtml;
    });
    Core._module.filter('humanize', function () {
        return Core.humanizeValue;
    });
    Core._module.filter('humanizeMs', function () {
        return Core.humanizeMilliseconds;
    });
    Core._module.filter('maskPassword', function () {
        return Core.maskPassword;
    });

    Core._module.run([
        "$rootScope",
        "$routeParams",
        "jolokia",
        "workspace",
        "localStorage",
        "viewRegistry",
        "layoutFull",
        "helpRegistry",
        "pageTitle",
        "branding",
        "toastr",
        "userDetails",
        "postLoginTasks",
        "preLogoutTasks",
        "$location",
        "ConnectOptions",
        "locationChangeStartTasks",
        function ($rootScope, $routeParams, jolokia, workspace, localStorage, viewRegistry, layoutFull, helpRegistry, pageTitle, branding, toastr, userDetails, postLoginTasks, preLogoutTasks, $location, ConnectOptions, locationChangeStartTasks) {
            postLoginTasks.addTask("ResetPreLogoutTasks", function () {
                preLogoutTasks.reset();
            });

            preLogoutTasks.addTask("ResetPostLoginTasks", function () {
                postLoginTasks.reset();
            });

            /*
            * Count the number of lines in the given text
            */
            $rootScope.lineCount = lineCount;

            /*
            * Easy access to route params
            */
            $rootScope.params = $routeParams;

            /*
            * Wrapper for angular.isArray, isObject, etc checks for use in the view
            *
            * @param type {string} the name of the check (casing sensitive)
            * @param value {string} value to check
            */
            $rootScope.is = function (type, value) {
                return angular['is' + type](value);
            };

            /*
            * Wrapper for $.isEmptyObject()
            *
            * @param value  {mixed} Value to be tested
            * @return booleanean
            */
            $rootScope.empty = function (value) {
                return $.isEmptyObject(value);
            };

            /*
            * Initialize jolokia polling and add handler to change poll
            * frequency
            */
            $rootScope.$on('UpdateRate', function (event, rate) {
                jolokia.stop();
                if (rate > 0) {
                    jolokia.start(rate);
                }
                Logger.get("Core").debug("Set update rate to: ", rate);
            });

            $rootScope.$emit('UpdateRate', localStorage['updateRate']);
            $rootScope.$on('$locationChangeStart', function ($event, newUrl, oldUrl) {
                locationChangeStartTasks.execute($event, newUrl, oldUrl);
            });

            // ensure that if the connection parameter is present, that we keep it
            locationChangeStartTasks.addTask('ConParam', function ($event, newUrl, oldUrl) {
                // we can't execute until the app is initialized...
                if (!Core.injector) {
                    return;
                }
                var $location = Core.injector.get('$location');
                var ConnectOptions = Core.injector.get('ConnectOptions');

                //log.debug("ConParam task firing, newUrl: ", newUrl, " oldUrl: ", oldUrl, " ConnectOptions: ", ConnectOptions);
                if (!ConnectOptions.name || !newUrl) {
                    return;
                }
                var newQuery = UrlHelpers.parseQueryString(newUrl);
                if (!newQuery.con) {
                    Core.log.debug("Lost connection parameter (", ConnectOptions.name, ") from query params: ", newQuery, " resetting");
                    $location.search({ 'con': ConnectOptions.name });
                }
            });

            /*
            * Debugging Tools
            *
            * Allows you to execute debug functions from the view
            */
            // TODO Doesn't support vargs like it should
            $rootScope.log = function (variable) {
                console.log(variable);
            };
            $rootScope.alert = function (text) {
                alert(text);
            };

            viewRegistry['fullscreen'] = layoutFull;
            viewRegistry['notree'] = layoutFull;
            viewRegistry['help'] = layoutFull;
            viewRegistry['welcome'] = layoutFull;
            viewRegistry['preferences'] = layoutFull;
            viewRegistry['about'] = layoutFull;
            viewRegistry['login'] = layoutFull;
            viewRegistry['ui'] = layoutFull;

            helpRegistry.addUserDoc('index', 'app/core/doc/overview.md');
            helpRegistry.addUserDoc('preferences', 'app/core/doc/preferences.md');
            helpRegistry.addSubTopic('index', 'faq', 'app/core/doc/FAQ.md');
            helpRegistry.addSubTopic('index', 'changes', 'app/core/doc/CHANGES.md');
            helpRegistry.addSubTopic('index', 'developer', 'app/core/doc/developer.md');
            helpRegistry.addDevDoc('Core', 'app/core/doc/coreDeveloper.md');
            helpRegistry.addDevDoc('UI', '#/ui/developerPage');
            helpRegistry.addDevDoc('datatable', 'app/datatable/doc/developer.md');
            helpRegistry.addDevDoc('Force Graph', 'app/forcegraph/doc/developer.md');

            toastr.options = {
                'closeButton': true,
                'showMethod': 'slideDown',
                'hideMethod': 'slideUp'
            };

            var throttledError = {
                level: null,
                message: null,
                action: Core.throttled(function () {
                    if (throttledError.level === "WARN") {
                        Core.notification('warning', throttledError.message);
                    }
                    if (throttledError.level === "ERROR") {
                        Core.notification('error', throttledError.message);
                    }
                }, 500)
            };

            window['logInterceptors'].push(function (level, message) {
                throttledError.level = level;
                throttledError.message = message;
                throttledError.action();
            });

            setTimeout(function () {
                $("#main-body").fadeIn(2000).after(function () {
                    Logger.get("Core").info(branding.appName + " started");
                    Core.$apply($rootScope);
                    $(window).trigger('resize');
                });
            }, 500);
        }]); // end _module.run
})(Core || (Core = {}));

// bootstrap plugin loader
hawtioPluginLoader.addUrl("plugin");

// add our module and any dependant third party modules
hawtioPluginLoader.addModule(Core.pluginName);

// register some tasks to run before bootstrap
// enable CORS support
hawtioPluginLoader.registerPreBootstrapTask(function (nextTask) {
    $.support.cors = true;
    nextTask();
});

// add bootstrap style tooltips
hawtioPluginLoader.registerPreBootstrapTask(function (nextTask) {
    $("a[title]").tooltip({
        selector: '',
        delay: { show: 1000, hide: 100 }
    });
    nextTask();
});

// Keep the page main container at least the height of the
// viewport
hawtioPluginLoader.registerPreBootstrapTask(function (nextTask) {
    Core.adjustHeight();
    $(window).resize(Core.adjustHeight);
    nextTask();
});

// for chrome packaged apps lets enable chrome-extension pages
hawtioPluginLoader.registerPreBootstrapTask(function (nextTask) {
    if (Core._module && Core.isChromeApp()) {
        Core._module.config([
            '$compileProvider',
            function ($compileProvider) {
                //$compileProvider.aHrefSanitizationWhitelist(/^\s*(https?|ftp|mailto|chrome-extension):/);
                $compileProvider.urlSanitizationWhitelist(/^\s*(https?|ftp|mailto|chrome-extension):/);
                // Angular before v1.2 uses $compileProvider.urlSanitizationWhitelist(...)
            }
        ]);
    }
    nextTask();
});
/**
* @module Jmx
*/
var Jmx;
(function (Jmx) {
    Jmx.log = Logger.get("JMX");

    var attributesToolBars = {};

    Jmx.lazyLoaders = {};

    function findLazyLoadingFunction(workspace, folder) {
        var factories = workspace.jmxTreeLazyLoadRegistry[folder.domain];
        var lazyFunction = null;
        if (factories && factories.length) {
            angular.forEach(factories, function (customLoader) {
                if (!lazyFunction) {
                    lazyFunction = customLoader(folder);
                }
            });
        }
        return lazyFunction;
    }
    Jmx.findLazyLoadingFunction = findLazyLoadingFunction;

    function registerLazyLoadHandler(domain, lazyLoaderFactory) {
        if (!Jmx.lazyLoaders) {
            Jmx.lazyLoaders = {};
        }
        var array = Jmx.lazyLoaders[domain];
        if (!array) {
            array = [];
            Jmx.lazyLoaders[domain] = array;
        }
        array.push(lazyLoaderFactory);
    }
    Jmx.registerLazyLoadHandler = registerLazyLoadHandler;

    function unregisterLazyLoadHandler(domain, lazyLoaderFactory) {
        if (Jmx.lazyLoaders) {
            var array = Jmx.lazyLoaders[domain];
            if (array) {
                array.remove(lazyLoaderFactory);
            }
        }
    }
    Jmx.unregisterLazyLoadHandler = unregisterLazyLoadHandler;

    /**
    * Registers a toolbar template for the given plugin name, jmxDomain.
    * @method addAttributeToolBar
    * @for Jmx
    * @param {String} pluginName used so that we can later on remove this function when the plugin is removed
    * @param {String} jmxDomain the JMX domain to avoid having to evaluate too many functions on each selection
    * @param {Function} fn the function used to decide which attributes tool bar should be used for the given select
    */
    function addAttributeToolBar(pluginName, jmxDomain, fn) {
        var array = attributesToolBars[jmxDomain];
        if (!array) {
            array = [];
            attributesToolBars[jmxDomain] = array;
        }
        array.push(fn);
    }
    Jmx.addAttributeToolBar = addAttributeToolBar;

    /**
    * Try find a custom toolbar HTML template for the given selection or returns the default value
    * @method getAttributeToolbar
    * @for Jmx
    * @param {Core.NodeSelection} node
    * @param {String} defaultValue
    */
    function getAttributeToolBar(node, defaultValue) {
        if (typeof defaultValue === "undefined") { defaultValue = "app/jmx/html/attributeToolBar.html"; }
        var answer = null;
        var jmxDomain = (node) ? node.domain : null;
        if (jmxDomain) {
            var array = attributesToolBars[jmxDomain];
            if (array) {
                for (var idx in array) {
                    var fn = array[idx];
                    answer = fn(node);
                    if (answer)
                        break;
                }
            }
        }
        return (answer) ? answer : defaultValue;
    }
    Jmx.getAttributeToolBar = getAttributeToolBar;

    function updateTreeSelectionFromURL($location, treeElement, activateIfNoneSelected) {
        if (typeof activateIfNoneSelected === "undefined") { activateIfNoneSelected = false; }
        updateTreeSelectionFromURLAndAutoSelect($location, treeElement, null, activateIfNoneSelected);
    }
    Jmx.updateTreeSelectionFromURL = updateTreeSelectionFromURL;

    function updateTreeSelectionFromURLAndAutoSelect($location, treeElement, autoSelect, activateIfNoneSelected) {
        if (typeof activateIfNoneSelected === "undefined") { activateIfNoneSelected = false; }
        var dtree = treeElement.dynatree("getTree");
        if (dtree) {
            var node = null;
            var key = $location.search()['nid'];
            if (key) {
                try  {
                    node = dtree.activateKey(key);
                } catch (e) {
                    // tree not visible we suspect!
                }
            }
            if (node) {
                node.expand(true);
            } else {
                if (!treeElement.dynatree("getActiveNode")) {
                    // lets expand the first node
                    var root = treeElement.dynatree("getRoot");
                    var children = root ? root.getChildren() : null;
                    if (children && children.length) {
                        var first = children[0];
                        first.expand(true);

                        // invoke any auto select function, and use its result as new first, if any returned
                        if (autoSelect) {
                            var result = autoSelect(first);
                            if (result) {
                                first = result;
                            }
                        }
                        if (activateIfNoneSelected) {
                            first.expand();
                            first.activate();
                        }
                    } else {
                        /*
                        causes NPE :)
                        
                        var first = children[0];
                        first.expand(true);
                        if (activateIfNoneSelected) {
                        first.activate();
                        }
                        */
                    }
                }
            }
        }
    }
    Jmx.updateTreeSelectionFromURLAndAutoSelect = updateTreeSelectionFromURLAndAutoSelect;

    function getUniqueTypeNames(children) {
        var typeNameMap = {};
        angular.forEach(children, function (mbean) {
            var typeName = mbean.typeName;
            if (typeName) {
                typeNameMap[typeName] = mbean;
            }
        });

        // only query if all the typenames are the same
        var typeNames = Object.keys(typeNameMap);
        return typeNames;
    }
    Jmx.getUniqueTypeNames = getUniqueTypeNames;

    function enableTree($scope, $location, workspace, treeElement, children, redraw, onActivateFn) {
        if (typeof redraw === "undefined") { redraw = false; }
        if (typeof onActivateFn === "undefined") { onActivateFn = null; }
        //$scope.workspace = workspace;
        if (treeElement.length) {
            if (!onActivateFn) {
                onActivateFn = function (node) {
                    var data = node.data;

                    //$scope.select(data);
                    workspace.updateSelectionNode(data);
                    Core.$apply($scope);
                };
            }
            workspace.treeElement = treeElement;
            treeElement.dynatree({
                /*
                * The event handler called when a different node in the tree is selected
                */
                onActivate: onActivateFn,
                onLazyRead: function (treeNode) {
                    var folder = treeNode.data;
                    var plugin = null;
                    if (folder) {
                        plugin = Jmx.findLazyLoadingFunction(workspace, folder);
                    }
                    if (plugin) {
                        console.log("Lazy loading folder " + folder.title);
                        var oldChildren = folder.childen;
                        plugin(workspace, folder, function () {
                            treeNode.setLazyNodeStatus(DTNodeStatus_Ok);
                            var newChildren = folder.children;
                            if (newChildren !== oldChildren) {
                                treeNode.removeChildren();
                                angular.forEach(newChildren, function (newChild) {
                                    treeNode.addChild(newChild);
                                });
                            }
                        });
                    } else {
                        treeNode.setLazyNodeStatus(DTNodeStatus_Ok);
                    }
                },
                onClick: function (node, event) {
                    if (event["metaKey"]) {
                        event.preventDefault();
                        var url = $location.absUrl();
                        if (node && node.data) {
                            var key = node.data["key"];
                            if (key) {
                                var hash = $location.search();
                                hash["nid"] = key;

                                // TODO this could maybe be a generic helper function?
                                // lets trim after the ?
                                var idx = url.indexOf('?');
                                if (idx <= 0) {
                                    url += "?";
                                } else {
                                    url = url.substring(0, idx + 1);
                                }
                                url += $.param(hash);
                            }
                        }
                        window.open(url, '_blank');
                        window.focus();
                        return false;
                    }
                    return true;
                },
                persist: false,
                debugLevel: 0,
                //children: $scope.workspace.tree.children
                children: children
            });

            if (redraw) {
                workspace.redrawTree();
            }
        }
    }
    Jmx.enableTree = enableTree;
})(Jmx || (Jmx = {}));
/**
* @module Core
*/
/// <reference path="./corePlugin.ts"/>
/// <reference path="../../jmx/js/jmxHelpers.ts"/>
var Core;
(function (Core) {
    

    /**
    * @class Workspace
    */
    var Workspace = (function () {
        function Workspace(jolokia, jolokiaStatus, jmxTreeLazyLoadRegistry, $location, $compile, $templateCache, localStorage, $rootScope, userDetails) {
            this.jolokia = jolokia;
            this.jolokiaStatus = jolokiaStatus;
            this.jmxTreeLazyLoadRegistry = jmxTreeLazyLoadRegistry;
            this.$location = $location;
            this.$compile = $compile;
            this.$templateCache = $templateCache;
            this.localStorage = localStorage;
            this.$rootScope = $rootScope;
            this.userDetails = userDetails;
            this.operationCounter = 0;
            this.tree = new Core.Folder('MBeans');
            this.treeResponse = {};
            this.mbeanTypesToDomain = {};
            this.mbeanServicesToDomain = {};
            this.attributeColumnDefs = {};
            this.treePostProcessors = [];
            this.topLevelTabs = [];
            this.subLevelTabs = [];
            this.keyToNodeMap = {};
            this.pluginRegisterHandle = null;
            this.pluginUpdateCounter = null;
            this.treeWatchRegisterHandle = null;
            this.treeWatcherCounter = null;
            this.treeElement = null;
            // mapData allows to store arbitrary data on the workspace
            this.mapData = {};
            // set defaults
            if (!('autoRefresh' in localStorage)) {
                localStorage['autoRefresh'] = true;
            }
            if (!('updateRate' in localStorage)) {
                localStorage['updateRate'] = 5000;
            }
        }
        /**
        * Creates a shallow copy child workspace with its own selection and location
        * @method createChildWorkspace
        * @param {ng.ILocationService} location
        * @return {Workspace}
        */
        Workspace.prototype.createChildWorkspace = function (location) {
            var child = new Workspace(this.jolokia, this.jolokiaStatus, this.jmxTreeLazyLoadRegistry, this.$location, this.$compile, this.$templateCache, this.localStorage, this.$rootScope, this.userDetails);

            // lets copy across all the properties just in case
            angular.forEach(this, function (value, key) {
                return child[key] = value;
            });
            child.$location = location;
            return child;
        };

        Workspace.prototype.getLocalStorage = function (key) {
            return this.localStorage[key];
        };

        Workspace.prototype.setLocalStorage = function (key, value) {
            this.localStorage[key] = value;
        };

        Workspace.prototype.loadTree = function () {
            // Make an initial blocking call to ensure the JMX tree is populated while the
            // app is initializing...
            //var flags = {error: initialLoadError, ajaxError: initialLoadError, maxDepth: 2};
            var flags = { ignoreErrors: true, maxDepth: 2 };
            var data = this.jolokia.list(null, onSuccess(null, flags));

            if (data) {
                this.jolokiaStatus.xhr = null;
            }
            this.populateTree({
                value: data
            });
            // we now only reload the tree if the TreeWatcher mbean is present...
            // Core.register(this.jolokia, this, {type: 'list', maxDepth: 2}, onSuccess(angular.bind(this, this.populateTree), {maxDepth: 2}));
        };

        /**
        * Adds a post processor of the tree to swizzle the tree metadata after loading
        * such as correcting any typeName values or CSS styles by hand
        * @method addTreePostProcessor
        * @param {Function} processor
        */
        Workspace.prototype.addTreePostProcessor = function (processor) {
            this.treePostProcessors.push(processor);

            var tree = this.tree;
            if (tree) {
                // the tree is loaded already so lets process it now :)
                processor(tree);
            }
        };

        Workspace.prototype.maybeMonitorPlugins = function () {
            if (this.treeContainsDomainAndProperties("hawtio", { type: "Registry" })) {
                if (this.pluginRegisterHandle === null) {
                    this.pluginRegisterHandle = this.jolokia.register(angular.bind(this, this.maybeUpdatePlugins), {
                        type: "read",
                        mbean: "hawtio:type=Registry",
                        attribute: "UpdateCounter"
                    });
                }
            } else {
                if (this.pluginRegisterHandle !== null) {
                    this.jolokia.unregister(this.pluginRegisterHandle);
                    this.pluginRegisterHandle = null;
                    this.pluginUpdateCounter = null;
                }
            }

            // lets also listen to see if we have a JMX tree watcher
            if (this.treeContainsDomainAndProperties("hawtio", { type: "TreeWatcher" })) {
                if (this.treeWatchRegisterHandle === null) {
                    this.treeWatchRegisterHandle = this.jolokia.register(angular.bind(this, this.maybeReloadTree), {
                        type: "read",
                        mbean: "hawtio:type=TreeWatcher",
                        attribute: "Counter"
                    });
                } else {
                    // lets keep using the existing register handle
                    /* we don't need to unregister lets keep using it
                    if (this.treeWatchRegisterHandle !== null) {
                    this.jolokia.unregister(this.treeWatchRegisterHandle);
                    this.treeWatchRegisterHandle = null;
                    this.treeWatcherCounter = null;
                    }
                    */
                }
            }
        };

        Workspace.prototype.maybeUpdatePlugins = function (response) {
            if (this.pluginUpdateCounter === null) {
                this.pluginUpdateCounter = response.value;
                return;
            }
            if (this.pluginUpdateCounter !== response.value) {
                if (Core.parseBooleanValue(localStorage['autoRefresh'])) {
                    window.location.reload();
                }
            }
        };

        Workspace.prototype.maybeReloadTree = function (response) {
            var counter = response.value;
            if (this.treeWatcherCounter === null) {
                this.treeWatcherCounter = counter;
                return;
            }
            if (this.treeWatcherCounter !== counter) {
                this.treeWatcherCounter = counter;
                var workspace = this;
                function wrapInValue(response) {
                    var wrapper = {
                        value: response
                    };
                    workspace.populateTree(wrapper);
                }
                this.jolokia.list(null, onSuccess(wrapInValue, { ignoreErrors: true, maxDepth: 2 }));
            }
        };

        Workspace.prototype.folderGetOrElse = function (folder, value) {
            if (folder) {
                try  {
                    return folder.getOrElse(value);
                } catch (e) {
                    Core.log.warn("Failed to find value " + value + " on folder " + folder);
                }
            }
            return null;
        };

        Workspace.prototype.populateTree = function (response) {
            if (!Object.equal(this.treeResponse, response.value)) {
                this.treeResponse = response.value;
                Core.log.debug("JMX tree has been loaded!");

                var rootId = 'root';
                var separator = '-';
                this.mbeanTypesToDomain = {};
                this.mbeanServicesToDomain = {};
                this.keyToNodeMap = {};
                var tree = new Core.Folder('MBeans');
                tree.key = rootId;
                var domains = response.value;
                for (var domain in domains) {
                    var domainClass = escapeDots(domain);
                    var mbeans = domains[domain];
                    for (var path in mbeans) {
                        var entries = {};
                        var folder = this.folderGetOrElse(tree, domain);

                        //if (!folder) continue;
                        folder.domain = domain;
                        if (!folder.key) {
                            folder.key = rootId + separator + domain;
                        }
                        var folderNames = [domain];
                        folder.folderNames = folderNames;
                        folderNames = folderNames.clone();
                        var items = path.split(',');
                        var paths = [];
                        var typeName = null;
                        var serviceName = null;
                        items.forEach(function (item) {
                            var kv = item.split('=');
                            var key = kv[0];
                            var value = kv[1] || key;
                            entries[key] = value;
                            var moveToFront = false;
                            var lowerKey = key.toLowerCase();
                            if (lowerKey === "type") {
                                typeName = value;

                                // if the type name value already exists in the root node
                                // of the domain then lets move this property around too
                                if (folder.map[value]) {
                                    moveToFront = true;
                                }
                            }
                            if (lowerKey === "service") {
                                serviceName = value;
                            }
                            if (moveToFront) {
                                paths.splice(0, 0, value);
                            } else {
                                paths.push(value);
                            }
                        });

                        var configureFolder = function (folder, name) {
                            folder.domain = domain;
                            if (!folder.key) {
                                folder.key = rootId + separator + folderNames.join(separator);
                            }
                            this.keyToNodeMap[folder.key] = folder;
                            folder.folderNames = folderNames.clone();

                            //var classes = escapeDots(folder.key);
                            var classes = "";
                            var entries = folder.entries;
                            var entryKeys = Object.keys(entries).filter(function (n) {
                                return n.toLowerCase().indexOf("type") >= 0;
                            });
                            if (entryKeys.length) {
                                angular.forEach(entryKeys, function (entryKey) {
                                    var entryValue = entries[entryKey];
                                    if (!folder.ancestorHasEntry(entryKey, entryValue)) {
                                        classes += " " + domainClass + separator + entryValue;
                                    }
                                });
                            } else {
                                var kindName = folderNames.last();

                                /*if (folder.parent && folder.parent.title === typeName) {
                                kindName = typeName;
                                } else */
                                if (kindName === name) {
                                    kindName += "-folder";
                                }
                                if (kindName) {
                                    classes += " " + domainClass + separator + kindName;
                                }
                            }
                            folder.addClass = escapeTreeCssStyles(classes);
                            return folder;
                        };

                        var lastPath = paths.pop();
                        var ws = this;
                        paths.forEach(function (value) {
                            folder = ws.folderGetOrElse(folder, value);
                            if (folder) {
                                folderNames.push(value);
                                angular.bind(ws, configureFolder, folder, value)();
                            }
                        });
                        var key = rootId + separator + folderNames.join(separator) + separator + lastPath;
                        var objectName = domain + ":" + path;

                        if (folder) {
                            folder = this.folderGetOrElse(folder, lastPath);
                            if (folder) {
                                // lets add the various data into the folder
                                folder.entries = entries;
                                folder.key = key;
                                angular.bind(this, configureFolder, folder, lastPath)();
                                folder.title = Core.trimQuotes(lastPath);
                                folder.objectName = objectName;
                                folder.typeName = typeName;

                                var addFolderByDomain = function (owner, typeName) {
                                    var map = owner[typeName];
                                    if (!map) {
                                        map = {};
                                        owner[typeName] = map;
                                    }
                                    var value = map[domain];
                                    if (!value) {
                                        map[domain] = folder;
                                    } else {
                                        var array = null;
                                        if (angular.isArray(value)) {
                                            array = value;
                                        } else {
                                            array = [value];
                                            map[domain] = array;
                                        }
                                        array.push(folder);
                                    }
                                };

                                if (serviceName) {
                                    angular.bind(this, addFolderByDomain, this.mbeanServicesToDomain, serviceName)();
                                }
                                if (typeName) {
                                    angular.bind(this, addFolderByDomain, this.mbeanTypesToDomain, typeName)();
                                }
                            }
                        } else {
                            Core.log.info("No folder found for lastPath: " + lastPath);
                        }
                    }
                }

                tree.sortChildren(true);

                // now lets mark the nodes with no children as lazy loading...
                this.enableLazyLoading(tree);
                this.tree = tree;

                var processors = this.treePostProcessors;
                angular.forEach(processors, function (processor) {
                    return processor(tree);
                });

                this.maybeMonitorPlugins();

                var rootScope = this.$rootScope;
                if (rootScope) {
                    rootScope.$broadcast('jmxTreeUpdated');
                }
            }
        };

        Workspace.prototype.enableLazyLoading = function (folder) {
            var _this = this;
            var children = folder.children;
            if (children && children.length) {
                angular.forEach(children, function (child) {
                    _this.enableLazyLoading(child);
                });
            } else {
                // we have no children so enable lazy loading if we have a custom loader registered
                var lazyFunction = Jmx.findLazyLoadingFunction(this, folder);
                if (lazyFunction) {
                    folder.isLazy = true;
                }
            }
        };

        /**
        * Returns the hash query argument to append to URL links
        * @method hash
        * @return {String}
        */
        Workspace.prototype.hash = function () {
            var hash = this.$location.search();
            var params = Core.hashToString(hash);
            if (params) {
                return "?" + params;
            }
            return "";
        };

        /**
        * Returns the currently active tab
        * @method getActiveTab
        * @return {Boolean}
        */
        Workspace.prototype.getActiveTab = function () {
            var workspace = this;
            return this.topLevelTabs.find(function (tab) {
                if (!angular.isDefined(tab.isActive)) {
                    return workspace.isLinkActive(tab.href());
                } else {
                    return tab.isActive(workspace);
                }
            });
        };

        Workspace.prototype.getStrippedPathName = function () {
            var pathName = Core.trimLeading((this.$location.path() || '/'), "#");
            pathName = Core.trimLeading(pathName, "/");
            return pathName;
        };

        Workspace.prototype.linkContains = function () {
            var words = [];
            for (var _i = 0; _i < (arguments.length - 0); _i++) {
                words[_i] = arguments[_i + 0];
            }
            var pathName = this.getStrippedPathName();
            return words.all(function (word) {
                return pathName.has(word);
            });
        };

        /**
        * Returns true if the given link is active. The link can omit the leading # or / if necessary.
        * The query parameters of the URL are ignored in the comparison.
        * @method isLinkActive
        * @param {String} href
        * @return {Boolean} true if the given link is active
        */
        Workspace.prototype.isLinkActive = function (href) {
            // lets trim the leading slash
            var pathName = this.getStrippedPathName();

            var link = Core.trimLeading(href, "#");
            link = Core.trimLeading(link, "/");

            // strip any query arguments
            var idx = link.indexOf('?');
            if (idx >= 0) {
                link = link.substring(0, idx);
            }
            if (!pathName.length) {
                return link === pathName;
            } else {
                return pathName.startsWith(link);
            }
        };

        /**
        * Returns true if the given link is active. The link can omit the leading # or / if necessary.
        * The query parameters of the URL are ignored in the comparison.
        * @method isLinkActive
        * @param {String} href
        * @return {Boolean} true if the given link is active
        */
        Workspace.prototype.isLinkPrefixActive = function (href) {
            // lets trim the leading slash
            var pathName = this.getStrippedPathName();

            var link = Core.trimLeading(href, "#");
            link = Core.trimLeading(link, "/");

            // strip any query arguments
            var idx = link.indexOf('?');
            if (idx >= 0) {
                link = link.substring(0, idx);
            }
            return pathName.startsWith(link);
        };

        /**
        * Returns true if the tab query parameter is active or the URL starts with the given path
        * @method isTopTabActive
        * @param {String} path
        * @return {Boolean}
        */
        Workspace.prototype.isTopTabActive = function (path) {
            var tab = this.$location.search()['tab'];
            if (angular.isString(tab)) {
                return tab.startsWith(path);
            }
            return this.isLinkActive(path);
        };

        /**
        * Returns the selected mbean name if there is one
        * @method getSelectedMBeanName
        * @return {String}
        */
        Workspace.prototype.getSelectedMBeanName = function () {
            var selection = this.selection;
            if (selection) {
                return selection.objectName;
            }
            return null;
        };

        /**
        * Returns true if the path is valid for the current selection
        * @method validSelection
        * @param {String} uri
        * @return {Boolean}
        */
        Workspace.prototype.validSelection = function (uri) {
            var workspace = this;
            var filter = function (t) {
                var fn = t.href;
                if (fn) {
                    var href = fn();
                    if (href) {
                        if (href.startsWith("#/")) {
                            href = href.substring(2);
                        }
                        return href === uri;
                    }
                }
                return false;
            };
            var tab = this.subLevelTabs.find(filter);
            if (!tab) {
                tab = this.topLevelTabs.find(filter);
            }
            if (tab) {
                //console.log("Found tab " + JSON.stringify(tab));
                var validFn = tab['isValid'];
                return !angular.isDefined(validFn) || validFn(workspace);
            } else {
                Core.log.info("Could not find tab for " + uri);
                return false;
            }
            /*
            var value = this.uriValidations[uri];
            if (value) {
            if (angular.isFunction(value)) {
            return value();
            }
            }
            return true;
            */
        };

        /**
        * In cases where we have just deleted something we typically want to change
        * the selection to the parent node
        * @method removeAndSelectParentNode
        */
        Workspace.prototype.removeAndSelectParentNode = function () {
            var selection = this.selection;
            if (selection) {
                var parent = selection.parent;
                if (parent) {
                    // lets remove the selection from the parent so we don't do any more JMX attribute queries on the children
                    // or include it in table views etc
                    // would be nice to eagerly remove the tree node too?
                    var idx = parent.children.indexOf(selection);
                    if (idx < 0) {
                        idx = parent.children.findIndex(function (n) {
                            return n.key === selection.key;
                        });
                    }
                    if (idx >= 0) {
                        parent.children.splice(idx, 1);
                    }
                    this.updateSelectionNode(parent);
                }
            }
        };

        Workspace.prototype.selectParentNode = function () {
            var selection = this.selection;
            if (selection) {
                var parent = selection.parent;
                if (parent) {
                    this.updateSelectionNode(parent);
                }
            }
        };

        /**
        * Returns the view configuration key for the kind of selection
        * for example based on the domain and the node type
        * @method selectionViewConfigKey
        * @return {String}
        */
        Workspace.prototype.selectionViewConfigKey = function () {
            return this.selectionConfigKey("view/");
        };

        /**
        * Returns a configuration key for a node which is usually of the form
        * domain/typeName or for folders with no type, domain/name/folder
        * @method selectionConfigKey
        * @param {String} prefix
        * @return {String}
        */
        Workspace.prototype.selectionConfigKey = function (prefix) {
            if (typeof prefix === "undefined") { prefix = ""; }
            var key = null;
            var selection = this.selection;
            if (selection) {
                // lets make a unique string for the kind of select
                key = prefix + selection.domain;
                var typeName = selection.typeName;
                if (!typeName) {
                    typeName = selection.title;
                }
                key += "/" + typeName;
                if (selection.isFolder()) {
                    key += "/folder";
                }
            }
            return key;
        };

        Workspace.prototype.moveIfViewInvalid = function () {
            var workspace = this;
            var uri = Core.trimLeading(this.$location.path(), "/");
            if (this.selection) {
                var key = this.selectionViewConfigKey();
                if (this.validSelection(uri)) {
                    // lets remember the previous selection
                    this.setLocalStorage(key, uri);
                    return false;
                } else {
                    Core.log.info("the uri '" + uri + "' is not valid for this selection");

                    // lets look up the previous preferred value for this type
                    var defaultPath = this.getLocalStorage(key);
                    if (!defaultPath || !this.validSelection(defaultPath)) {
                        // lets find the first path we can find which is valid
                        defaultPath = null;
                        angular.forEach(this.subLevelTabs, function (tab) {
                            var fn = tab.isValid;
                            if (!defaultPath && tab.href && angular.isDefined(fn) && fn(workspace)) {
                                defaultPath = tab.href();
                            }
                        });
                    }
                    if (!defaultPath) {
                        defaultPath = "#/jmx/help";
                    }
                    Core.log.info("moving the URL to be " + defaultPath);
                    if (defaultPath.startsWith("#")) {
                        defaultPath = defaultPath.substring(1);
                    }
                    this.$location.path(defaultPath);
                    return true;
                }
            } else {
                return false;
            }
        };

        Workspace.prototype.updateSelectionNode = function (node) {
            var originalSelection = this.selection;
            this.selection = node;
            var key = null;
            if (node) {
                key = node['key'];
            }
            var $location = this.$location;
            var q = $location.search();
            if (key) {
                q['nid'] = key;
            }
            $location.search(q);

            // if we have updated the selection (rather than just loaded a page)
            // lets use the previous preferred view - otherwise we may be loading
            // a page from a bookmark so lets not change the view :)
            if (originalSelection) {
                key = this.selectionViewConfigKey();
                if (key) {
                    var defaultPath = this.getLocalStorage(key);
                    if (defaultPath) {
                        this.$location.path(defaultPath);
                    }
                }
            }
        };

        /**
        * Redraws the tree widget
        * @method redrawTree
        */
        Workspace.prototype.redrawTree = function () {
            var treeElement = this.treeElement;
            if (treeElement && angular.isDefined(treeElement.dynatree) && angular.isFunction(treeElement.dynatree)) {
                treeElement.dynatree("getTree").reload();
            }
        };

        /**
        * Expand / collapse the current active node
        * @method expandSelection
        * @param {Boolean} flag
        */
        Workspace.prototype.expandSelection = function (flag) {
            var treeElement = this.treeElement;
            if (treeElement) {
                var node = treeElement.dynatree("getActiveNode");
                if (node) {
                    node.expand(flag);
                }
            }
        };

        Workspace.prototype.matchesProperties = function (entries, properties) {
            if (!entries)
                return false;
            for (var key in properties) {
                var value = properties[key];
                if (!value || entries[key] !== value) {
                    return false;
                }
            }
            return true;
        };

        Workspace.prototype.treeContainsDomainAndProperties = function (domainName, properties) {
            if (typeof properties === "undefined") { properties = null; }
            var _this = this;
            var workspace = this;
            var tree = workspace.tree;
            if (tree) {
                var folder = tree.get(domainName);
                if (folder) {
                    if (properties) {
                        var children = folder.children || [];
                        var checkProperties = function (node) {
                            if (!_this.matchesProperties(node.entries, properties)) {
                                if (node.domain === domainName && node.children && node.children.length > 0) {
                                    return node.children.some(checkProperties);
                                } else {
                                    return false;
                                }
                            } else {
                                return true;
                            }
                        };
                        return children.some(checkProperties);
                    }
                    return true;
                } else {
                    // console.log("no hasMBean for " + objectName + " in tree " + tree);
                }
            } else {
                // console.log("workspace has no tree! returning false for hasMBean " + objectName);
            }
            return false;
        };

        Workspace.prototype.matches = function (folder, properties, propertiesCount) {
            if (folder) {
                var entries = folder.entries;
                if (properties) {
                    if (!entries)
                        return false;
                    for (var key in properties) {
                        var value = properties[key];
                        if (!value || entries[key] !== value) {
                            return false;
                        }
                    }
                }
                if (propertiesCount) {
                    return entries && Object.keys(entries).length === propertiesCount;
                }
                return true;
            }
            return false;
        };

        // only display stuff if we have an mbean with the given properties
        Workspace.prototype.hasDomainAndProperties = function (domainName, properties, propertiesCount) {
            if (typeof properties === "undefined") { properties = null; }
            if (typeof propertiesCount === "undefined") { propertiesCount = null; }
            var node = this.selection;
            if (node) {
                return this.matches(node, properties, propertiesCount) && node.domain === domainName;
            }
            return false;
        };

        // only display stuff if we have an mbean with the given properties
        Workspace.prototype.findMBeanWithProperties = function (domainName, properties, propertiesCount) {
            if (typeof properties === "undefined") { properties = null; }
            if (typeof propertiesCount === "undefined") { propertiesCount = null; }
            var tree = this.tree;
            if (tree) {
                return this.findChildMBeanWithProperties(tree.get(domainName), properties, propertiesCount);
            }
            return null;
        };

        Workspace.prototype.findChildMBeanWithProperties = function (folder, properties, propertiesCount) {
            if (typeof properties === "undefined") { properties = null; }
            if (typeof propertiesCount === "undefined") { propertiesCount = null; }
            var _this = this;
            var workspace = this;
            if (folder) {
                var children = folder.children;
                if (children) {
                    var answer = children.find(function (node) {
                        return _this.matches(node, properties, propertiesCount);
                    });
                    if (answer) {
                        return answer;
                    }
                    return children.map(function (node) {
                        return workspace.findChildMBeanWithProperties(node, properties, propertiesCount);
                    }).find(function (node) {
                        return node;
                    });
                }
            }
            return null;
        };

        Workspace.prototype.selectionHasDomainAndLastFolderName = function (objectName, lastName) {
            var lastNameLower = (lastName || "").toLowerCase();
            function isName(name) {
                return (name || "").toLowerCase() === lastNameLower;
            }
            var node = this.selection;
            if (node) {
                if (objectName === node.domain) {
                    var folders = node.folderNames;
                    if (folders) {
                        var last = folders.last();
                        return (isName(last) || isName(node.title)) && node.isFolder() && !node.objectName;
                    }
                }
            }
            return false;
        };

        Workspace.prototype.selectionHasDomain = function (domainName) {
            var node = this.selection;
            if (node) {
                return domainName === node.domain;
            }
            return false;
        };

        Workspace.prototype.selectionHasDomainAndType = function (objectName, typeName) {
            var node = this.selection;
            if (node) {
                return objectName === node.domain && typeName === node.typeName;
            }
            return false;
        };

        /**
        * Returns true if this workspace has any mbeans at all
        */
        Workspace.prototype.hasMBeans = function () {
            var answer = false;
            var tree = this.tree;
            if (tree) {
                var children = tree.children;
                if (angular.isArray(children) && children.length > 0) {
                    answer = true;
                }
            }
            return answer;
        };
        Workspace.prototype.hasFabricMBean = function () {
            return this.hasDomainAndProperties('io.fabric8', { type: 'Fabric' });
        };
        Workspace.prototype.isFabricFolder = function () {
            return this.hasDomainAndProperties('io.fabric8');
        };

        Workspace.prototype.isCamelContext = function () {
            return this.hasDomainAndProperties('org.apache.camel', { type: 'context' });
        };
        Workspace.prototype.isCamelFolder = function () {
            return this.hasDomainAndProperties('org.apache.camel');
        };
        Workspace.prototype.isEndpointsFolder = function () {
            return this.selectionHasDomainAndLastFolderName('org.apache.camel', 'endpoints');
        };
        Workspace.prototype.isEndpoint = function () {
            return this.hasDomainAndProperties('org.apache.camel', { type: 'endpoints' });
        };
        Workspace.prototype.isRoutesFolder = function () {
            return this.selectionHasDomainAndLastFolderName('org.apache.camel', 'routes');
        };
        Workspace.prototype.isRoute = function () {
            return this.hasDomainAndProperties('org.apache.camel', { type: 'routes' });
        };

        Workspace.prototype.isOsgiFolder = function () {
            return this.hasDomainAndProperties('osgi.core');
        };
        Workspace.prototype.isKarafFolder = function () {
            return this.hasDomainAndProperties('org.apache.karaf');
        };
        Workspace.prototype.isOsgiCompendiumFolder = function () {
            return this.hasDomainAndProperties('osgi.compendium');
        };
        return Workspace;
    })();
    Core.Workspace = Workspace;
})(Core || (Core = {}));

// TODO refactor other code to use Core.Workspace
var Workspace = (function (_super) {
    __extends(Workspace, _super);
    function Workspace() {
        _super.apply(this, arguments);
    }
    return Workspace;
})(Core.Workspace);
;
;
/**
* @module Core
*/
var Core;
(function (Core) {
    

    /**
    * @class Folder
    * @uses NodeSelection
    */
    var Folder = (function () {
        function Folder(title) {
            this.title = title;
            this.key = null;
            this.typeName = null;
            this.children = [];
            this.folderNames = [];
            this.domain = null;
            this.objectName = null;
            this.map = {};
            this.entries = {};
            this.addClass = null;
            this.parent = null;
            this.isLazy = false;
            this.icon = null;
            this.tooltip = null;
            this.entity = null;
            this.addClass = escapeTreeCssStyles(title);
        }
        Folder.prototype.get = function (key) {
            return this.map[key];
        };

        Folder.prototype.isFolder = function () {
            return this.children.length > 0;
        };

        /**
        * Navigates the given paths and returns the value there or null if no value could be found
        * @method navigate
        * @for Folder
        * @param {Array} paths
        * @return {NodeSelection}
        */
        Folder.prototype.navigate = function () {
            var paths = [];
            for (var _i = 0; _i < (arguments.length - 0); _i++) {
                paths[_i] = arguments[_i + 0];
            }
            var node = this;
            paths.forEach(function (path) {
                if (node) {
                    node = node.get(path);
                }
            });
            return node;
        };

        Folder.prototype.hasEntry = function (key, value) {
            var entries = this.entries;
            if (entries) {
                var actual = entries[key];
                return actual && value === actual;
            }
            return false;
        };

        Folder.prototype.parentHasEntry = function (key, value) {
            if (this.parent) {
                return this.parent.hasEntry(key, value);
            }
            return false;
        };

        Folder.prototype.ancestorHasEntry = function (key, value) {
            var parent = this.parent;
            while (parent) {
                if (parent.hasEntry(key, value))
                    return true;
                parent = parent.parent;
            }
            return false;
        };

        Folder.prototype.ancestorHasType = function (typeName) {
            var parent = this.parent;
            while (parent) {
                if (typeName === parent.typeName)
                    return true;
                parent = parent.parent;
            }
            return false;
        };

        Folder.prototype.getOrElse = function (key, defaultValue) {
            if (typeof defaultValue === "undefined") { defaultValue = new Folder(key); }
            var answer = this.map[key];
            if (!answer) {
                answer = defaultValue;
                this.map[key] = answer;
                this.children.push(answer);
                answer.parent = this;
                this.children = this.children.sortBy("title");
            }
            return answer;
        };

        Folder.prototype.sortChildren = function (recursive) {
            var children = this.children;
            if (children) {
                this.children = children.sortBy("title");
                if (recursive) {
                    angular.forEach(children, function (child) {
                        return child.sortChildren(recursive);
                    });
                }
            }
        };

        Folder.prototype.moveChild = function (child) {
            if (child && child.parent !== this) {
                child.detach();
                child.parent = this;
                this.children.push(child);
            }
        };

        /**
        * Removes this node from my parent if I have one
        * @method detach
        * @for Folder
        \   */
        Folder.prototype.detach = function () {
            var oldParent = this.parent;
            if (oldParent) {
                var oldParentChildren = oldParent.children;
                if (oldParentChildren) {
                    var idx = oldParentChildren.indexOf(this);
                    if (idx < 0) {
                        oldParent.children = oldParent.children.remove({ key: this.key });
                    } else {
                        oldParentChildren.splice(idx, 1);
                    }
                }
                this.parent = null;
            }
        };

        /**
        * Searches this folder and all its descendants for the first folder to match the filter
        * @method findDescendant
        * @for Folder
        * @param {Function} filter
        * @return {Folder}
        */
        Folder.prototype.findDescendant = function (filter) {
            if (filter(this)) {
                return this;
            }
            var answer = null;
            angular.forEach(this.children, function (child) {
                if (!answer) {
                    answer = child.findDescendant(filter);
                }
            });
            return answer;
        };
        return Folder;
    })();
    Core.Folder = Folder;
})(Core || (Core = {}));

;
var Folder = (function (_super) {
    __extends(Folder, _super);
    function Folder() {
        _super.apply(this, arguments);
    }
    return Folder;
})(Core.Folder);
;
/// <reference path="../../baseHelpers.ts"/>
/// <reference path="../../helpers/js/controllerHelpers.ts"/>
/// <reference path="coreInterfaces.ts"/>
/// <reference path="./tasks.ts"/>
/// <reference path="./workspace.ts"/>
/// <reference path="./folder.ts"/>
var Core;
(function (Core) {
    Core.log = Logger.get("Core");
})(Core || (Core = {}));

var numberTypeNames = {
    'byte': true,
    'short': true,
    'int': true,
    'long': true,
    'float': true,
    'double': true,
    'java.lang.byte': true,
    'java.lang.short': true,
    'java.lang.integer': true,
    'java.lang.long': true,
    'java.lang.float': true,
    'java.lang.double': true
};

/**
* Returns the number of lines in the given text
*
* @method lineCount
* @static
* @param {String} value
* @return {Number}
*
*/
function lineCount(value) {
    var rows = 0;
    if (value) {
        rows = 1;
        value.toString().each(/\n/, function () {
            return rows++;
        });
    }
    return rows;
}

function safeNull(value) {
    if (typeof value === 'boolean') {
        return value;
    } else if (typeof value === 'number') {
        // return numbers as-is
        return value;
    }
    if (value) {
        return value;
    } else {
        return "";
    }
}

function safeNullAsString(value, type) {
    if (typeof value === 'boolean') {
        return "" + value;
    } else if (typeof value === 'number') {
        // return numbers as-is
        return "" + value;
    } else if (typeof value === 'string') {
        // its a string
        return "" + value;
    } else if (type === 'javax.management.openmbean.CompositeData' || type === '[Ljavax.management.openmbean.CompositeData;') {
        // composite data or composite data array, we just display as json
        // use json representation
        var data = angular.toJson(value, true);
        return data;
    } else if (type === 'javax.management.openmbean.TabularData') {
        // tabular data is a key/value structure so loop each field and convert to array we can
        // turn into a String
        var arr = [];
        for (var key in value) {
            var val = value[key];
            var line = "" + key + "=" + val;
            arr.push(line);
        }

        // sort array so the values is listed nicely
        arr = arr.sortBy(function (row) {
            return row.toString();
        });
        return arr.join("\n");
    } else if (angular.isArray(value)) {
        // join array with new line, and do not sort as the order in the array may matter
        return value.join("\n");
    } else if (value) {
        // force as string
        return "" + value;
    } else {
        return "";
    }
}

/**
* Converts the given value to an array of query arguments.
*
* If the value is null an empty array is returned.
* If the value is a non empty string then the string is split by commas
*
* @method toSearchArgumentArray
* @static
* @param {*} value
* @return {String[]}
*
*/
function toSearchArgumentArray(value) {
    if (value) {
        if (angular.isArray(value))
            return value;
        if (angular.isString(value))
            return value.split(',');
    }
    return [];
}

function folderMatchesPatterns(node, patterns) {
    if (node) {
        var folderNames = node.folderNames;
        if (folderNames) {
            return patterns.any(function (ignorePaths) {
                for (var i = 0; i < ignorePaths.length; i++) {
                    var folderName = folderNames[i];
                    var ignorePath = ignorePaths[i];
                    if (!folderName)
                        return false;
                    var idx = ignorePath.indexOf(folderName);
                    if (idx < 0) {
                        return false;
                    }
                }
                return true;
            });
        }
    }
    return false;
}

function scopeStoreJolokiaHandle($scope, jolokia, jolokiaHandle) {
    // TODO do we even need to store the jolokiaHandle in the scope?
    if (jolokiaHandle) {
        $scope.$on('$destroy', function () {
            closeHandle($scope, jolokia);
        });
        $scope.jolokiaHandle = jolokiaHandle;
    }
}

function closeHandle($scope, jolokia) {
    var jolokiaHandle = $scope.jolokiaHandle;
    if (jolokiaHandle) {
        //console.log('Closing the handle ' + jolokiaHandle);
        jolokia.unregister(jolokiaHandle);
        $scope.jolokiaHandle = null;
    }
}

/**
* Pass in null for the success function to switch to sync mode
*
* @method onSuccess
* @static
* @param {Function} Success callback function
* @param {Object} Options object to pass on to Jolokia request
* @return {Object} initialized options object
*/
function onSuccess(fn, options) {
    if (typeof options === "undefined") { options = {}; }
    options['mimeType'] = 'application/json';
    if (angular.isDefined(fn)) {
        options['success'] = fn;
    }
    if (!options['method']) {
        options['method'] = "POST";
    }
    options['canonicalNaming'] = false;
    options['canonicalProperties'] = false;
    if (!options['error']) {
        options['error'] = function (response) {
            Core.defaultJolokiaErrorHandler(response, options);
        };
    }
    return options;
}

function supportsLocalStorage() {
    try  {
        return 'localStorage' in window && window['localStorage'] !== null;
    } catch (e) {
        return false;
    }
}

function isNumberTypeName(typeName) {
    if (typeName) {
        var text = typeName.toString().toLowerCase();
        var flag = numberTypeNames[text];
        return flag;
    }
    return false;
}

function encodeMBeanPath(mbean) {
    return mbean.replace(/\//g, '!/').replace(':', '/').escapeURL();
}

function escapeMBeanPath(mbean) {
    return mbean.replace(/\//g, '!/').replace(':', '/');
}

function encodeMBean(mbean) {
    return mbean.replace(/\//g, '!/').escapeURL();
}

function escapeDots(text) {
    return text.replace(/\./g, '-');
}

/**
* Escapes all dots and 'span' text in the css style names to avoid clashing with bootstrap stuff
*
* @method escapeTreeCssStyles
* @static
* @param {String} text
* @return {String}
*/
function escapeTreeCssStyles(text) {
    return escapeDots(text).replace(/span/g, 'sp-an');
}

function showLogPanel() {
    var log = $("#log-panel");
    var body = $('body');
    localStorage['showLog'] = 'true';
    log.css({ 'bottom': '50%' });
    body.css({
        'overflow-y': 'hidden'
    });
}

/**
* Returns the CSS class for a log level based on if its info, warn, error etc.
*
* @method logLevelClass
* @static
* @param {String} level
* @return {String}
*/
function logLevelClass(level) {
    if (level) {
        var first = level[0];
        if (first === 'w' || first === "W") {
            return "warning";
        } else if (first === 'e' || first === "E") {
            return "error";
        } else if (first === 'i' || first === "I") {
            return "info";
        } else if (first === 'd' || first === "D") {
            // we have no debug css style
            return "";
        }
    }
    return "";
}

/**
* @module Core
*/
var Core;
(function (Core) {
    function parseMBean(mbean) {
        var answer = {};
        var parts = mbean.split(":");
        if (parts.length > 1) {
            answer['domain'] = parts.first();
            parts = parts.exclude(parts.first());
            parts = parts.join(":");
            answer['attributes'] = {};
            var nameValues = parts.split(",");
            nameValues.forEach(function (str) {
                var nameValue = str.split('=');
                var name = nameValue.first().trim();
                nameValue = nameValue.exclude(nameValue.first());
                answer['attributes'][name] = nameValue.join('=').trim();
            });
        }
        return answer;
    }
    Core.parseMBean = parseMBean;

    function executePostLoginTasks() {
        Core.log.debug("Executing post login tasks");
        Core.postLoginTasks.execute();
    }
    Core.executePostLoginTasks = executePostLoginTasks;

    function executePreLogoutTasks(onComplete) {
        Core.log.debug("Executing pre logout tasks");
        Core.preLogoutTasks.onComplete(onComplete);
        Core.preLogoutTasks.execute();
    }
    Core.executePreLogoutTasks = executePreLogoutTasks;

    /**
    * log out the current user
    * @for Core
    * @static
    * @method logout
    * @param {String} jolokiaUrl
    * @param {*} userDetails
    * @param {Object} localStorage
    * @param {Object} $scope
    * @param {Function} successCB
    * @param {Function} errorCB
    *
    */
    function logout(jolokiaUrl, userDetails, localStorage, $scope, successCB, errorCB) {
        if (typeof successCB === "undefined") { successCB = null; }
        if (typeof errorCB === "undefined") { errorCB = null; }
        if (jolokiaUrl) {
            var url = "auth/logout/";

            $.ajax(url, {
                type: "POST",
                success: function () {
                    userDetails.username = null;
                    userDetails.password = null;
                    userDetails.loginDetails = null;
                    userDetails.rememberMe = false;
                    delete localStorage['userDetails'];
                    if (successCB && angular.isFunction(successCB)) {
                        successCB();
                    }
                    Core.$apply($scope);
                },
                error: function (xhr, textStatus, error) {
                    userDetails.username = null;
                    userDetails.password = null;
                    userDetails.loginDetails = null;
                    userDetails.rememberMe = false;
                    delete localStorage['userDetails'];

                    switch (xhr.status) {
                        case 401:
                            Core.log.error('Failed to log out, ', error);
                            break;
                        case 403:
                            Core.log.error('Failed to log out, ', error);
                            break;
                        case 0:
                            break;
                        default:
                            Core.log.error('Failed to log out, ', error);
                            break;
                    }
                    if (errorCB && angular.isFunction(errorCB)) {
                        errorCB();
                    }
                    Core.$apply($scope);
                }
            });
        }
    }
    Core.logout = logout;

    /**
    * Creates a link by appending the current $location.search() hash to the given href link,
    * removing any required parameters from the link
    * @method createHref
    * @for Core
    * @static
    * @param {ng.ILocationService} $location
    * @param {String} href the link to have any $location.search() hash parameters appended
    * @param {Array} removeParams any parameters to be removed from the $location.search()
    * @return {Object} the link with any $location.search() parameters added
    */
    function createHref($location, href, removeParams) {
        if (typeof removeParams === "undefined") { removeParams = null; }
        var hashMap = angular.copy($location.search());

        // lets remove any top level nav bar related hash searches
        if (removeParams) {
            angular.forEach(removeParams, function (param) {
                return delete hashMap[param];
            });
        }
        var hash = Core.hashToString(hashMap);
        if (hash) {
            var prefix = (href.indexOf("?") >= 0) ? "&" : "?";
            href += prefix + hash;
        }
        return href;
    }
    Core.createHref = createHref;

    /**
    * Turns the given search hash into a URI style query string
    * @method hashToString
    * @for Core
    * @static
    * @param {Object} hash
    * @return {String}
    */
    function hashToString(hash) {
        var keyValuePairs = [];
        angular.forEach(hash, function (value, key) {
            keyValuePairs.push(key + "=" + value);
        });
        var params = keyValuePairs.join("&");
        return encodeURI(params);
    }
    Core.hashToString = hashToString;

    /**
    * Parses the given string of x=y&bar=foo into a hash
    * @method stringToHash
    * @for Core
    * @static
    * @param {String} hashAsString
    * @return {Object}
    */
    function stringToHash(hashAsString) {
        var entries = {};
        if (hashAsString) {
            var text = decodeURI(hashAsString);
            var items = text.split('&');
            angular.forEach(items, function (item) {
                var kv = item.split('=');
                var key = kv[0];
                var value = kv[1] || key;
                entries[key] = value;
            });
        }
        return entries;
    }
    Core.stringToHash = stringToHash;

    /**
    * Register a JMX operation to poll for changes
    * @method register
    * @for Core
    * @static
    * @return {Function} a zero argument function for unregistering  this registration
    * @param {*} jolokia
    * @param {*} scope
    * @param {Object} arguments
    * @param {Function} callback
    */
    function register(jolokia, scope, arguments, callback) {
        if (scope && !Core.isBlank(scope.name)) {
            Core.log.debug("Calling register from scope: ", scope.name);
        } else {
            Core.log.debug("Calling register from anonymous scope");
        }
        if (!angular.isDefined(scope.$jhandle) || !angular.isArray(scope.$jhandle)) {
            scope.$jhandle = [];
        }
        if (angular.isDefined(scope.$on)) {
            scope.$on('$destroy', function (event) {
                unregister(jolokia, scope);
            });
        }

        var handle = null;

        if (angular.isArray(arguments)) {
            if (arguments.length >= 1) {
                // TODO can't get this to compile in typescript :)
                //var args = [callback].concat(arguments);
                var args = [callback];
                angular.forEach(arguments, function (value) {
                    return args.push(value);
                });

                //var args = [callback];
                //args.push(arguments);
                var registerFn = jolokia.register;
                handle = registerFn.apply(jolokia, args);
                scope.$jhandle.push(handle);
                jolokia.request(arguments, callback);
            }
        } else {
            handle = jolokia.register(callback, arguments);
            scope.$jhandle.push(handle);
            jolokia.request(arguments, callback);
        }
        return function () {
            if (handle !== null) {
                scope.$jhandle.remove(handle);
                jolokia.unregister(handle);
            }
        };
    }
    Core.register = register;

    /**
    * Register a JMX operation to poll for changes using a jolokia search using the given mbean pattern
    * @method registerSearch
    * @for Core
    * @static
    * @paran {*} jolokia
    * @param {*} scope
    * @param {String} mbeanPattern
    * @param {Function} callback
    */
    function registerSearch(jolokia, scope, mbeanPattern, callback) {
        if (!angular.isDefined(scope.$jhandle) || !angular.isArray(scope.$jhandle)) {
            scope.$jhandle = [];
        }
        if (angular.isDefined(scope.$on)) {
            scope.$on('$destroy', function (event) {
                unregister(jolokia, scope);
            });
        }
        if (angular.isArray(arguments)) {
            if (arguments.length >= 1) {
                // TODO can't get this to compile in typescript :)
                //var args = [callback].concat(arguments);
                var args = [callback];
                angular.forEach(arguments, function (value) {
                    return args.push(value);
                });

                //var args = [callback];
                //args.push(arguments);
                var registerFn = jolokia.register;
                var handle = registerFn.apply(jolokia, args);
                scope.$jhandle.push(handle);
                jolokia.search(mbeanPattern, callback);
            }
        } else {
            var handle = jolokia.register(callback, arguments);
            scope.$jhandle.push(handle);
            jolokia.search(mbeanPattern, callback);
        }
    }
    Core.registerSearch = registerSearch;

    function unregister(jolokia, scope) {
        if (angular.isDefined(scope.$jhandle)) {
            scope.$jhandle.forEach(function (handle) {
                jolokia.unregister(handle);
            });
            delete scope.$jhandle;
        }
    }
    Core.unregister = unregister;

    /**
    * The default error handler which logs errors either using debug or log level logging based on the silent setting
    * @param response the response from a jolokia request
    */
    function defaultJolokiaErrorHandler(response, options) {
        if (typeof options === "undefined") { options = {}; }
        //alert("Jolokia request failed: " + response.error);
        var stacktrace = response.stacktrace;
        if (stacktrace) {
            var silent = options['silent'];
            if (!silent) {
                var operation = Core.pathGet(response, ['request', 'operation']) || "unknown";
                if (stacktrace.indexOf("javax.management.InstanceNotFoundException") >= 0 || stacktrace.indexOf("javax.management.AttributeNotFoundException") >= 0 || stacktrace.indexOf("java.lang.IllegalArgumentException: No operation") >= 0) {
                    // ignore these errors as they can happen on timing issues
                    // such as its been removed
                    // or if we run against older containers
                    Core.log.debug("Operation ", operation, " failed due to: ", response['error']);
                    Core.log.debug("Stack trace: ", Logger.formatStackTraceString(response['stacktrace']));
                } else {
                    Core.log.warn("Operation ", operation, " failed due to: ", response['error']);
                    Core.log.info("Stack trace: ", Logger.formatStackTraceString(response['stacktrace']));
                }
            } else {
                Core.log.debug("Operation ", operation, " failed due to: ", response['error']);
                Core.log.debug("Stack trace: ", Logger.formatStackTraceString(response['stacktrace']));
            }
        }
    }
    Core.defaultJolokiaErrorHandler = defaultJolokiaErrorHandler;

    /**
    * Logs any failed operation and stack traces
    */
    function logJolokiaStackTrace(response) {
        var stacktrace = response.stacktrace;
        if (stacktrace) {
            var operation = Core.pathGet(response, ['request', 'operation']) || "unknown";
            Core.log.info("Operation ", operation, " failed due to: ", response['error']);
            Core.log.info("Stack trace: ", Logger.formatStackTraceString(response['stacktrace']));
        }
    }
    Core.logJolokiaStackTrace = logJolokiaStackTrace;

    /**
    * Converts the given XML node to a string representation of the XML
    * @method xmlNodeToString
    * @for Core
    * @static
    * @param {Object} xmlNode
    * @return {Object}
    */
    function xmlNodeToString(xmlNode) {
        try  {
            // Gecko- and Webkit-based browsers (Firefox, Chrome), Opera.
            return (new XMLSerializer()).serializeToString(xmlNode);
        } catch (e) {
            try  {
                // Internet Explorer.
                return xmlNode.xml;
            } catch (e) {
                //Other browsers without XML Serializer
                console.log('WARNING: XMLSerializer not supported');
            }
        }
        return false;
    }
    Core.xmlNodeToString = xmlNodeToString;

    /**
    * Returns true if the given DOM node is a text node
    * @method isTextNode
    * @for Core
    * @static
    * @param {Object} node
    * @return {Boolean}
    */
    function isTextNode(node) {
        return node && node.nodeType === 3;
    }
    Core.isTextNode = isTextNode;

    /**
    * Returns the lowercase file extension of the given file name or returns the empty
    * string if the file does not have an extension
    * @method fileExtension
    * @for Core
    * @static
    * @param {String} name
    * @param {String} defaultValue
    * @return {String}
    */
    function fileExtension(name, defaultValue) {
        if (typeof defaultValue === "undefined") { defaultValue = ""; }
        var extension = defaultValue;
        if (name) {
            var idx = name.lastIndexOf(".");
            if (idx > 0) {
                extension = name.substring(idx + 1, name.length).toLowerCase();
            }
        }
        return extension;
    }
    Core.fileExtension = fileExtension;

    function getUUID() {
        var d = new Date();
        var ms = (d.getTime() * 1000) + d.getUTCMilliseconds();
        var random = Math.floor((1 + Math.random()) * 0x10000);
        return ms.toString(16) + random.toString(16);
    }
    Core.getUUID = getUUID;

    var _versionRegex = /[^\d]*(\d+)\.(\d+)(\.(\d+))?.*/;

    /**
    * Parses some text of the form "xxxx2.3.4xxxx"
    * to extract the version numbers as an array of numbers then returns an array of 2 or 3 numbers.
    *
    * Characters before the first digit are ignored as are characters after the last digit.
    * @method parseVersionNumbers
    * @for Core
    * @static
    * @param {String} text a maven like string containing a dash then numbers separated by dots
    * @return {Array}
    */
    function parseVersionNumbers(text) {
        if (text) {
            var m = text.match(_versionRegex);
            if (m && m.length > 4) {
                var m1 = m[1];
                var m2 = m[2];
                var m4 = m[4];
                if (angular.isDefined(m4)) {
                    return [parseInt(m1), parseInt(m2), parseInt(m4)];
                } else if (angular.isDefined(m2)) {
                    return [parseInt(m1), parseInt(m2)];
                } else if (angular.isDefined(m1)) {
                    return [parseInt(m1)];
                }
            }
        }
        return null;
    }
    Core.parseVersionNumbers = parseVersionNumbers;

    /**
    * Converts a version string with numbers and dots of the form "123.456.790" into a string
    * which is sortable as a string, by left padding each string between the dots to at least 4 characters
    * so things just sort as a string.
    *
    * @param text
    * @return {string} the sortable version string
    */
    function versionToSortableString(version, maxDigitsBetweenDots) {
        if (typeof maxDigitsBetweenDots === "undefined") { maxDigitsBetweenDots = 4; }
        return (version || "").split(".").map(function (x) {
            var length = x.length;
            return (length >= maxDigitsBetweenDots) ? x : x.padLeft(' ', maxDigitsBetweenDots - length);
        }).join(".");
    }
    Core.versionToSortableString = versionToSortableString;

    function time(message, fn) {
        var start = new Date().getTime();
        var answer = fn();
        var elapsed = new Date().getTime() - start;
        console.log(message + " " + elapsed);
        return answer;
    }
    Core.time = time;

    /**
    * Compares the 2 version arrays and returns -1 if v1 is less than v2 or 0 if they are equal or 1 if v1 is greater than v2
    * @method compareVersionNumberArrays
    * @for Core
    * @static
    * @param {Array} v1 an array of version numbers with the most significant version first (major, minor, patch).
    * @param {Array} v2
    * @return {Number}
    */
    function compareVersionNumberArrays(v1, v2) {
        if (v1 && !v2) {
            return 1;
        }
        if (!v1 && v2) {
            return -1;
        }
        if (v1 === v2) {
            return 0;
        }
        for (var i = 0; i < v1.length; i++) {
            var n1 = v1[i];
            if (i >= v2.length) {
                return 1;
            }
            var n2 = v2[i];
            if (!angular.isDefined(n1)) {
                return -1;
            }
            if (!angular.isDefined(n2)) {
                return 1;
            }
            if (n1 > n2) {
                return 1;
            } else if (n1 < n2) {
                return -1;
            }
        }
        return 0;
    }
    Core.compareVersionNumberArrays = compareVersionNumberArrays;

    /**
    * Helper function which converts objects into tables of key/value properties and
    * lists into a <ul> for each value.
    * @method valueToHtml
    * @for Core
    * @static
    * @param {any} value
    * @return {String}
    */
    function valueToHtml(value) {
        if (angular.isArray(value)) {
            var size = value.length;
            if (!size) {
                return "";
            } else if (size === 1) {
                return valueToHtml(value[0]);
            } else {
                var buffer = "<ul>";
                angular.forEach(value, function (childValue) {
                    buffer += "<li>" + valueToHtml(childValue) + "</li>";
                });
                return buffer + "</ul>";
            }
        } else if (angular.isObject(value)) {
            var buffer = "<table>";
            angular.forEach(value, function (childValue, key) {
                buffer += "<tr><td>" + key + "</td><td>" + valueToHtml(childValue) + "</td></tr>";
            });
            return buffer + "</table>";
        } else if (angular.isString(value)) {
            var uriPrefixes = ["http://", "https://", "file://", "mailto:"];
            var answer = value;
            angular.forEach(uriPrefixes, function (prefix) {
                if (answer.startsWith(prefix)) {
                    answer = "<a href='" + value + "'>" + value + "</a>";
                }
            });
            return answer;
        }
        return value;
    }
    Core.valueToHtml = valueToHtml;

    /**
    * If the string starts and ends with [] {} then try parse as JSON and return the parsed content or return null
    * if it does not appear to be JSON
    * @method tryParseJson
    * @for Core
    * @static
    * @param {String} text
    * @return {Object}
    */
    function tryParseJson(text) {
        text = text.trim();
        if ((text.startsWith("[") && text.endsWith("]")) || (text.startsWith("{") && text.endsWith("}"))) {
            try  {
                return JSON.parse(text);
            } catch (e) {
                // ignore
            }
        }
        return null;
    }
    Core.tryParseJson = tryParseJson;

    /**
    * Given values (n, "person") will return either "1 person" or "2 people" depending on if a plural
    * is required using the String.pluralize() function from sugarjs
    * @method maybePlural
    * @for Core
    * @static
    * @param {Number} count
    * @param {String} word
    * @return {String}
    */
    function maybePlural(count, word) {
        var pluralWord = (count === 1) ? word : word.pluralize();
        return "" + count + " " + pluralWord;
    }
    Core.maybePlural = maybePlural;

    /**
    * given a JMX ObjectName of the form <code>domain:key=value,another=something</code> then return the object
    * <code>{key: "value", another: "something"}</code>
    * @method objectNameProperties
    * @for Core
    * @static
    * @param {String} name
    * @return {Object}
    */
    function objectNameProperties(objectName) {
        var entries = {};
        if (objectName) {
            var idx = objectName.indexOf(":");
            if (idx > 0) {
                var path = objectName.substring(idx + 1);
                var items = path.split(',');
                angular.forEach(items, function (item) {
                    var kv = item.split('=');
                    var key = kv[0];
                    var value = kv[1] || key;
                    entries[key] = value;
                });
            }
        }
        return entries;
    }
    Core.objectNameProperties = objectNameProperties;

    function setPageTitle($document, title) {
        $document.attr('title', title.getTitleWithSeparator(' '));
    }
    Core.setPageTitle = setPageTitle;

    function setPageTitleWithTab($document, title, tab) {
        $document.attr('title', title.getTitleWithSeparator(' ') + " " + tab);
    }
    Core.setPageTitleWithTab = setPageTitleWithTab;

    /**
    * Returns the Folder object for the given domain name and type name or null if it can not be found
    * @method getMBeanTypeFolder
    * @for Core
    * @static
    * @param {Workspace} workspace
    * @param {String} domain
    * @param {String} typeName}
    * @return {Folder}
    */
    function getMBeanTypeFolder(workspace, domain, typeName) {
        if (workspace) {
            var mbeanTypesToDomain = workspace.mbeanTypesToDomain || {};
            var types = mbeanTypesToDomain[typeName] || {};
            var answer = types[domain];
            if (angular.isArray(answer) && answer.length) {
                return answer[0];
            }
            return answer;
        }
        return null;
    }
    Core.getMBeanTypeFolder = getMBeanTypeFolder;

    /**
    * Returns the JMX objectName for the given jmx domain and type name
    * @method getMBeanTypeObjectName
    * @for Core
    * @static
    * @param {Workspace} workspace
    * @param {String} domain
    * @param {String} typeName
    * @return {String}
    */
    function getMBeanTypeObjectName(workspace, domain, typeName) {
        var folder = Core.getMBeanTypeFolder(workspace, domain, typeName);
        return Core.pathGet(folder, ["objectName"]);
    }
    Core.getMBeanTypeObjectName = getMBeanTypeObjectName;

    /**
    * Removes dodgy characters from a value such as '/' or '.' so that it can be used as a DOM ID value
    * and used in jQuery / CSS selectors
    * @method toSafeDomID
    * @for Core
    * @static
    * @param {String} text
    * @return {String}
    */
    function toSafeDomID(text) {
        return text ? text.replace(/(\/|\.)/g, "_") : text;
    }
    Core.toSafeDomID = toSafeDomID;

    /**
    * Invokes the given function on each leaf node in the array of folders
    * @method forEachLeafFolder
    * @for Core
    * @static
    * @param {Array[Folder]} folders
    * @param {Function} fn
    */
    function forEachLeafFolder(folders, fn) {
        angular.forEach(folders, function (folder) {
            var children = folder["children"];
            if (angular.isArray(children) && children.length > 0) {
                forEachLeafFolder(children, fn);
            } else {
                fn(folder);
            }
        });
    }
    Core.forEachLeafFolder = forEachLeafFolder;

    function extractHashURL(url) {
        var parts = url.split('#');
        if (parts.length === 0) {
            return url;
        }
        var answer = parts[1];
        if (parts.length > 1) {
            var remaining = parts.last(parts.length - 2);
            remaining.forEach(function (part) {
                answer = answer + "#" + part;
            });
        }
        return answer;
    }
    Core.extractHashURL = extractHashURL;

    function authHeaderValue(userDetails) {
        return getBasicAuthHeader(userDetails.username, userDetails.password);
    }
    Core.authHeaderValue = authHeaderValue;

    function getBasicAuthHeader(username, password) {
        var authInfo = username + ":" + password;
        authInfo = authInfo.encodeBase64();
        return "Basic " + authInfo;
    }
    Core.getBasicAuthHeader = getBasicAuthHeader;

    var httpRegex = new RegExp('^(https?):\/\/(([^:/?#]*)(?::([0-9]+))?)');

    /**
    * Breaks a URL up into a nice object
    * @method parseUrl
    * @for Core
    * @static
    * @param url
    * @returns object
    */
    function parseUrl(url) {
        if (Core.isBlank(url)) {
            return null;
        }

        var matches = url.match(httpRegex);

        if (matches === null) {
            return null;
        }

        //log.debug("matches: ", matches);
        var scheme = matches[1];
        var host = matches[3];
        var port = matches[4];

        var parts = null;
        if (!Core.isBlank(port)) {
            parts = url.split(port);
        } else {
            parts = url.split(host);
        }

        var path = parts[1];
        if (path && path.startsWith('/')) {
            path = path.slice(1, path.length);
        }

        //log.debug("parts: ", parts);
        return {
            scheme: scheme,
            host: host,
            port: port,
            path: path
        };
    }
    Core.parseUrl = parseUrl;

    function getDocHeight() {
        var D = document;
        return Math.max(Math.max(D.body.scrollHeight, D.documentElement.scrollHeight), Math.max(D.body.offsetHeight, D.documentElement.offsetHeight), Math.max(D.body.clientHeight, D.documentElement.clientHeight));
    }
    Core.getDocHeight = getDocHeight;

    /**
    * If a URL is external to the current web application, then
    * replace the URL with the proxy servlet URL
    * @method useProxyIfExternal
    * @for Core
    * @static
    * @param {String} connectUrl
    * @return {String}
    */
    function useProxyIfExternal(connectUrl) {
        if (Core.isChromeApp()) {
            return connectUrl;
        }
        var host = window.location.host;
        if (!connectUrl.startsWith("http://" + host + "/") && !connectUrl.startsWith("https://" + host + "/")) {
            // lets remove the http stuff
            var idx = connectUrl.indexOf("://");
            if (idx > 0) {
                connectUrl = connectUrl.substring(idx + 3);
            }

            // lets replace the : with a /
            connectUrl = connectUrl.replace(":", "/");
            connectUrl = Core.trimLeading(connectUrl, "/");
            connectUrl = Core.trimTrailing(connectUrl, "/");
            connectUrl = Core.url("/proxy/" + connectUrl);
        }
        return connectUrl;
    }
    Core.useProxyIfExternal = useProxyIfExternal;

    function getRecentConnections(localStorage) {
        if (Core.isBlank(localStorage['recentConnections'])) {
            Core.clearConnections();
        }
        return angular.fromJson(localStorage['recentConnections']);
    }
    Core.getRecentConnections = getRecentConnections;

    function addRecentConnection(localStorage, name) {
        var recent = getRecentConnections(localStorage);
        recent = recent.add(name).unique().first(5);
        localStorage['recentConnections'] = angular.toJson(recent);
    }
    Core.addRecentConnection = addRecentConnection;

    function removeRecentConnection(localStorage, name) {
        var recent = getRecentConnections(localStorage);
        recent = recent.exclude(function (n) {
            return n === name;
        });
        localStorage['recentConnections'] = angular.toJson(recent);
    }
    Core.removeRecentConnection = removeRecentConnection;

    function clearConnections() {
        localStorage['recentConnections'] = '[]';
    }
    Core.clearConnections = clearConnections;

    function saveConnection(options) {
        var connectionMap = Core.loadConnectionMap();

        // use a copy so we can leave the original one alone
        var clone = Object.clone(options);
        delete clone.userName;
        delete clone.password;
        connectionMap[options.name] = clone;
        Core.saveConnectionMap(connectionMap);
    }
    Core.saveConnection = saveConnection;

    function connectToServer(localStorage, options) {
        Core.log.debug("Connecting with options: ", StringHelpers.toString(options));
        addRecentConnection(localStorage, options.name);
        if (!('userName' in options)) {
            var userDetails = Core.injector.get('userDetails');
            options.userName = userDetails.username;
            options.password = userDetails.password;
        }
        saveConnection(options);
        var $window = Core.injector.get('$window');
        var url = (options.view || '#/welcome') + '?con=' + options.name;
        url = url.replace(/\?/g, "&");
        url = url.replace(/&/, "?");
        var newWindow = $window.open(url);
        newWindow['userDetails'] = {
            username: options.userName,
            password: options.password,
            loginDetails: {}
        };
    }
    Core.connectToServer = connectToServer;

    /**
    * Extracts the url of the target, eg usually http://localhost:port, but if we use fabric to proxy to another host,
    * then we return the url that we proxied too (eg the real target)
    *
    * @param {ng.ILocationService} $location
    * @param {String} scheme to force use a specific scheme, otherwise the scheme from location is used
    * @param {Number} port to force use a specific port number, otherwise the port from location is used
    */
    function extractTargetUrl($location, scheme, port) {
        if (angular.isUndefined(scheme)) {
            scheme = $location.scheme();
        }

        var host = $location.host();

        //  $location.search()['url']; does not work for some strange reason
        // var qUrl = $location.search()['url'];
        // if its a proxy request using hawtio-proxy servlet, then the url parameter
        // has the actual host/port
        var qUrl = $location.absUrl();
        var idx = qUrl.indexOf("url=");
        if (idx > 0) {
            qUrl = qUrl.substr(idx + 4);
            var value = decodeURIComponent(qUrl);
            if (value) {
                idx = value.indexOf("/proxy/");

                // after proxy we have host and optional port (if port is not 80)
                if (idx > 0) {
                    value = value.substr(idx + 7);

                    // if the path has http:// or some other scheme in it lets trim that off
                    idx = value.indexOf("://");
                    if (idx > 0) {
                        value = value.substr(idx + 3);
                    }
                    var data = value.split("/");
                    if (data.length >= 1) {
                        host = data[0];
                    }
                    if (angular.isUndefined(port) && data.length >= 2) {
                        var qPort = Core.parseIntValue(data[1], "port number");
                        if (qPort) {
                            port = qPort;
                        }
                    }
                }
            }
        }

        if (angular.isUndefined(port)) {
            port = $location.port();
        }

        var url = scheme + "://" + host;
        if (port != 80) {
            url += ":" + port;
        }
        return url;
    }
    Core.extractTargetUrl = extractTargetUrl;

    /**
    * handy do nothing converter for the below function
    **/
    function doNothing(value) {
        return value;
    }
    Core.doNothing = doNothing;

    // moved these into their own helper file
    Core.bindModelToSearchParam = ControllerHelpers.bindModelToSearchParam;
    Core.reloadWhenParametersChange = ControllerHelpers.reloadWhenParametersChange;

    /**
    * Creates a jolokia object for connecting to the container with the given remote jolokia URL,
    * username and password
    * @method createJolokia
    * @for Core
    * @static
    * @param {String} url
    * @param {String} username
    * @param {String} password
    * @return {Object}
    */
    function createJolokia(url, username, password) {
        var jolokiaParams = {
            url: url,
            username: username,
            password: password,
            canonicalNaming: false, ignoreErrors: true, mimeType: 'application/json'
        };
        return new Jolokia(jolokiaParams);
    }
    Core.createJolokia = createJolokia;

    /**
    * Returns a new function which ensures that the delegate function is only invoked at most once
    * within the given number of millseconds
    * @method throttled
    * @for Core
    * @static
    * @param {Function} fn the function to be invoked at most once within the given number of millis
    * @param {Number} millis the time window during which this function should only be called at most once
    * @return {Object}
    */
    function throttled(fn, millis) {
        var nextInvokeTime = 0;
        var lastAnswer = null;
        return function () {
            var now = Date.now();
            if (nextInvokeTime < now) {
                nextInvokeTime = now + millis;
                lastAnswer = fn();
            } else {
                //log.debug("Not invoking function as we did call " + (now - (nextInvokeTime - millis)) + " ms ago");
            }
            return lastAnswer;
        };
    }
    Core.throttled = throttled;

    /**
    * Attempts to parse the given JSON text and returns the JSON object structure or null.
    *Bad JSON is logged at info level.
    *
    * @param text a JSON formatted string
    * @param message description of the thing being parsed logged if its invalid
    */
    function parseJsonText(text, message) {
        if (typeof message === "undefined") { message = "JSON"; }
        var answer = null;
        try  {
            answer = angular.fromJson(text);
        } catch (e) {
            Core.log.info("Failed to parse " + message + " from: " + text + ". " + e);
        }
        return answer;
    }
    Core.parseJsonText = parseJsonText;

    /**
    * Returns the humanized markup of the given value
    */
    function humanizeValueHtml(value) {
        var formattedValue = "";
        if (value === true) {
            formattedValue = '<i class="icon-check"></i>';
        } else if (value === false) {
            formattedValue = '<i class="icon-check-empty"></i>';
        } else {
            formattedValue = Core.humanizeValue(value);
        }
        return formattedValue;
    }
    Core.humanizeValueHtml = humanizeValueHtml;

    /**
    * Gets a query value from the given url
    *
    * @param url  url
    * @param parameterName the uri parameter value to get
    * @returns {*}
    */
    function getQueryParameterValue(url, parameterName) {
        var parts;

        var query = (url || '').split('?');
        if (query && query.length > 0) {
            parts = query[1];
        } else {
            parts = '';
        }

        var vars = parts.split('&');
        for (var i = 0; i < vars.length; i++) {
            var pair = vars[i].split('=');
            if (decodeURIComponent(pair[0]) == parameterName) {
                return decodeURIComponent(pair[1]);
            }
        }

        // not found
        return null;
    }
    Core.getQueryParameterValue = getQueryParameterValue;

    /**
    * Creates a remote workspace given a remote jolokia for querying the JMX MBeans inside the jolokia
    * @param remoteJolokia
    * @param $location
    * @param localStorage
    * @return {Core.Workspace|Workspace}
    */
    function createRemoteWorkspace(remoteJolokia, $location, localStorage, $rootScope, $compile, $templateCache, userDetails) {
        if (typeof $rootScope === "undefined") { $rootScope = null; }
        if (typeof $compile === "undefined") { $compile = null; }
        if (typeof $templateCache === "undefined") { $templateCache = null; }
        if (typeof userDetails === "undefined") { userDetails = null; }
        // lets create a child workspace object for the remote container
        var jolokiaStatus = {
            xhr: null
        };

        // disable reload notifications
        var jmxTreeLazyLoadRegistry = Jmx.lazyLoaders;
        var profileWorkspace = new Core.Workspace(remoteJolokia, jolokiaStatus, jmxTreeLazyLoadRegistry, $location, $compile, $templateCache, localStorage, $rootScope, userDetails);

        Core.log.info("Loading the profile using jolokia: " + remoteJolokia);
        profileWorkspace.loadTree();
        return profileWorkspace;
    }
    Core.createRemoteWorkspace = createRemoteWorkspace;

    /**
    * Takes a value in ms and returns a human readable
    * duration
    * @param value
    */
    function humanizeMilliseconds(value) {
        if (!angular.isNumber(value)) {
            return "XXX";
        }

        var seconds = value / 1000;
        var years = Math.floor(seconds / 31536000);
        if (years) {
            return maybePlural(years, "year");
        }
        var days = Math.floor((seconds %= 31536000) / 86400);
        if (days) {
            return maybePlural(days, "day");
        }
        var hours = Math.floor((seconds %= 86400) / 3600);
        if (hours) {
            return maybePlural(hours, 'hour');
        }
        var minutes = Math.floor((seconds %= 3600) / 60);
        if (minutes) {
            return maybePlural(minutes, 'minute');
        }
        seconds = Math.floor(seconds % 60);
        if (seconds) {
            return maybePlural(seconds, 'second');
        }
        return value + " ms";
    }
    Core.humanizeMilliseconds = humanizeMilliseconds;

    function storeConnectionRegex(regexs, name, json) {
        if (!regexs.any(function (r) {
            r['name'] === name;
        })) {
            var regex = '';

            if (json['useProxy']) {
                regex = '/hawtio/proxy/';
            } else {
                regex = '//';
            }
            regex += json['host'] + ':' + json['port'] + '/' + json['path'];
            regexs.push({
                name: name,
                regex: regex.escapeURL(true),
                color: UI.colors.sample()
            });
            writeRegexs(regexs);
        }
    }
    Core.storeConnectionRegex = storeConnectionRegex;

    function getRegexs() {
        var regexs = [];
        try  {
            regexs = angular.fromJson(localStorage['regexs']);
        } catch (e) {
            // corrupted config
            delete localStorage['regexs'];
        }
        return regexs;
    }
    Core.getRegexs = getRegexs;

    function removeRegex(name) {
        var regexs = Core.getRegexs();
        var hasFunc = function (r) {
            return r['name'] === name;
        };
        if (regexs.any(hasFunc)) {
            regexs = regexs.exclude(hasFunc);
            Core.writeRegexs(regexs);
        }
    }
    Core.removeRegex = removeRegex;

    function writeRegexs(regexs) {
        localStorage['regexs'] = angular.toJson(regexs);
    }
    Core.writeRegexs = writeRegexs;

    function maskPassword(value) {
        if (value) {
            var text = '' + value;

            // we use the same patterns as in Apache Camel in its
            // org.apache.camel.util.URISupport.sanitizeUri
            var userInfoPattern = "(.*://.*:)(.*)(@)";
            value = value.replace(new RegExp(userInfoPattern, 'i'), "$1xxxxxx$3");
        }

        return value;
    }
    Core.maskPassword = maskPassword;

    /**
    * Match the given filter against the text, ignoring any case.
    * <p/>
    * This operation will regard as a match if either filter or text is null/undefined.
    * As its used for filtering out, unmatched.
    * <p/>
    *
    * @param text   the text
    * @param filter the filter
    * @return true if matched, false if not.
    */
    function matchFilterIgnoreCase(text, filter) {
        if (angular.isUndefined(text) || angular.isUndefined(filter)) {
            return true;
        }

        text = text.toString().trim().toLowerCase();
        filter = filter.toString().trim().toLowerCase();

        if (text.length === 0 || filter.length === 0) {
            return true;
        }

        return text.indexOf(filter) > -1;
    }
    Core.matchFilterIgnoreCase = matchFilterIgnoreCase;
})(Core || (Core = {}));
/**
* @module JVM
*/
/// <reference path="../../baseIncludes.ts"/>
/// <reference path="../../core/js/coreHelpers.ts"/>
var JVM;
(function (JVM) {
    JVM.log = Logger.get("JVM");

    JVM.connectControllerKey = "jvmConnectSettings";
    JVM.connectionSettingsKey = Core.connectionSettingsKey;

    JVM.logoPath = 'img/icons/jvm/';

    JVM.logoRegistry = {
        'jetty': JVM.logoPath + 'jetty-logo-80x22.png',
        'tomcat': JVM.logoPath + 'tomcat-logo.gif',
        'generic': JVM.logoPath + 'java-logo.svg'
    };

    /**
    * Adds common properties and functions to the scope
    * @method configureScope
    * @for Jvm
    * @param {*} $scope
    * @param {ng.ILocationService} $location
    * @param {Core.Workspace} workspace
    */
    function configureScope($scope, $location, workspace) {
        $scope.isActive = function (href) {
            var tidy = Core.trimLeading(href, "#");
            var loc = $location.path();
            return loc === tidy;
        };

        $scope.isValid = function (link) {
            return link && link.isValid(workspace);
        };

        $scope.hasLocalMBean = function () {
            return JVM.hasLocalMBean(workspace);
        };

        $scope.breadcrumbs = [
            {
                content: '<i class=" icon-signin"></i> Remote',
                title: "Connect to a remote JVM running Jolokia",
                isValid: function (workspace) {
                    return true;
                },
                href: "#/jvm/connect"
            },
            {
                content: '<i class="icon-list-ul"></i> Local',
                title: "View a diagram of the route",
                isValid: function (workspace) {
                    return hasLocalMBean(workspace);
                },
                href: "#/jvm/local"
            },
            {
                content: '<i class="icon-signin"></i> Discovery',
                title: "Discover",
                isValid: function (workspace) {
                    return hasDiscoveryMBean(workspace);
                },
                href: "#/jvm/discover"
            }
        ];
    }
    JVM.configureScope = configureScope;

    function hasLocalMBean(workspace) {
        return workspace.treeContainsDomainAndProperties('hawtio', { type: 'JVMList' });
    }
    JVM.hasLocalMBean = hasLocalMBean;

    function hasDiscoveryMBean(workspace) {
        return workspace.treeContainsDomainAndProperties('jolokia', { type: 'Discovery' });
    }
    JVM.hasDiscoveryMBean = hasDiscoveryMBean;
})(JVM || (JVM = {}));
/**
* @module JVM
* @main JVM
*/
/// <reference path="jvmHelpers.ts"/>
var JVM;
(function (JVM) {
    JVM.rootPath = 'app/jvm';
    JVM.templatePath = JVM.rootPath + '/html/';
    JVM.pluginName = 'jvm';

    JVM._module = angular.module(JVM.pluginName, ['bootstrap', 'ngResource', 'datatable', 'hawtioCore', 'hawtio-forms', 'ui']);

    JVM._module.config([
        "$routeProvider", function ($routeProvider) {
            $routeProvider.when('/jvm/discover', { templateUrl: JVM.templatePath + 'discover.html' }).when('/jvm/connect', { templateUrl: JVM.templatePath + 'connect.html' }).when('/jvm/local', { templateUrl: JVM.templatePath + 'local.html' });
        }]);

    JVM._module.constant('mbeanName', 'hawtio:type=JVMList');

    JVM._module.run([
        "$location", "workspace", "viewRegistry", "layoutFull", "helpRegistry", function ($location, workspace, viewRegistry, layoutFull, helpRegistry) {
            viewRegistry[JVM.pluginName] = JVM.templatePath + 'layoutConnect.html';
            helpRegistry.addUserDoc('jvm', 'app/jvm/doc/help.md');

            workspace.topLevelTabs.push({
                id: "connect",
                content: "Connect",
                title: "Connect to other JVMs",
                isValid: function (workspace) {
                    return true;
                },
                href: function () {
                    return '#/jvm/connect';
                },
                isActive: function (workspace) {
                    return workspace.isLinkActive("jvm");
                }
            });
        }]);

    hawtioPluginLoader.addModule(JVM.pluginName);
})(JVM || (JVM = {}));
/**
* @module JVM
*/
/// <reference path="../../core/js/coreInterfaces.ts"/>
/// <reference path="jvmPlugin.ts"/>
var JVM;
(function (JVM) {
    function DiscoveryController($scope, localStorage, jolokia) {
        $scope.discovering = true;

        $scope.$watch('agents', function (newValue, oldValue) {
            if (newValue !== oldValue) {
                $scope.selectedAgent = $scope.agents.find(function (a) {
                    return a['selected'];
                });
            }
        }, true);

        $scope.closePopover = function ($event) {
            $($event.currentTarget).parents('.popover').prev().popover('hide');
        };

        function doConnect(agent) {
            if (!agent.url) {
                Core.notification('warning', 'No URL available to connect to agent');
                return;
            }
            var options = Core.createConnectOptions();

            var urlObject = Core.parseUrl(agent.url);
            angular.extend(options, urlObject);
            options.userName = agent.username;
            options.password = agent.password;

            Core.connectToServer(localStorage, options);
        }
        ;

        $scope.connectWithCredentials = function ($event, agent) {
            $scope.closePopover($event);
            doConnect(agent);
        };

        $scope.gotoServer = function ($event, agent) {
            if (agent.secured) {
                $($event.currentTarget).popover('show');
            } else {
                doConnect(agent);
            }
        };

        $scope.getElementId = function (agent) {
            return agent.agent_id.dasherize().replace(/\./g, "-");
        };

        $scope.getLogo = function (agent) {
            if (agent.server_product) {
                return JVM.logoRegistry[agent.server_product];
            }
            return JVM.logoRegistry['generic'];
        };

        $scope.filterMatches = function (agent) {
            if (Core.isBlank($scope.filter)) {
                return true;
            } else {
                return angular.toJson(agent).toLowerCase().has($scope.filter.toLowerCase());
            }
        };

        $scope.getAgentIdClass = function (agent) {
            if ($scope.hasName(agent)) {
                return "";
            }
            return "strong";
        };

        $scope.hasName = function (agent) {
            if (agent.server_vendor && agent.server_product && agent.server_version) {
                return true;
            }
            return false;
        };

        function render(response) {
            if (!response.value) {
                return;
            }
            var responseJson = angular.toJson(response.value.sortBy(function (agent) {
                return agent['agent_id'];
            }), true);
            if ($scope.responseJson !== responseJson) {
                if ($scope.discovering) {
                    $scope.discovering = false;
                }
                $scope.responseJson = responseJson;
                JVM.log.debug("agents: ", $scope.agents);
                $scope.agents = response.value;
                Core.$apply($scope);
            }
        }

        var updateRate = localStorage['updateRate'];
        if (updateRate > 0) {
            Core.register(jolokia, $scope, {
                type: 'exec', mbean: 'jolokia:type=Discovery',
                operation: 'lookupAgentsWithTimeout',
                arguments: [updateRate]
            }, onSuccess(render));
        } else {
            Core.register(jolokia, $scope, {
                type: 'exec', mbean: 'jolokia:type=Discovery',
                operation: 'lookupAgents',
                arguments: []
            }, onSuccess(render));
        }
    }
    JVM.DiscoveryController = DiscoveryController;
})(JVM || (JVM = {}));
/**
* @module JVM
*/
/// <reference path="jvmPlugin.ts"/>
/// <reference path="../../core/js/coreInterfaces.ts"/>
/// <reference path="../../core/js/coreHelpers.ts"/>
var JVM;
(function (JVM) {
    JVM.ConnectController = JVM._module.controller("JVM.ConnectController", [
        "$scope", "$location", "localStorage", "workspace", function ($scope, $location, localStorage, workspace) {
            function newConfig() {
                return Core.createConnectOptions({
                    scheme: 'http',
                    host: 'localhost',
                    path: 'jolokia',
                    port: 8181,
                    userName: '',
                    password: '',
                    useProxy: !$scope.disableProxy
                });
            }
            ;

            $scope.forms = {};

            var hasMBeans = workspace && workspace.tree && workspace.tree.children && workspace.tree.children.length;

            $scope.disableProxy = !hasMBeans || Core.isChromeApp();

            $scope.lastConnection = '';

            // load settings like current tab, last used connection
            if (JVM.connectControllerKey in localStorage) {
                try  {
                    $scope.lastConnection = angular.fromJson(localStorage[JVM.connectControllerKey]);
                } catch (e) {
                    // corrupt config
                    $scope.lastConnection = '';
                    delete localStorage[JVM.connectControllerKey];
                }
            }

            // load connection settings
            $scope.connectionConfigs = Core.loadConnectionMap();
            if (!Core.isBlank($scope.lastConnection)) {
                $scope.currentConfig = $scope.connectionConfigs[$scope.lastConnection];
            } else {
                $scope.currentConfig = newConfig();
            }

            /*
            log.debug("Controller settings: ", $scope.settings);
            log.debug("Current config: ", $scope.currentConfig);
            log.debug("All connection settings: ", $scope.connectionConfigs);
            */
            $scope.formConfig = {
                properties: {
                    name: {
                        type: 'java.lang.String',
                        tooltip: "Name for this connection",
                        required: true,
                        'input-attributes': {
                            'placeholder': 'Unnamed...'
                        }
                    },
                    scheme: {
                        type: 'java.lang.String',
                        tooltip: "HTTP or HTTPS",
                        enum: ["http", "https"],
                        required: true
                    },
                    host: {
                        type: 'java.lang.String',
                        tooltip: "Target host to connect to",
                        required: true
                    },
                    port: {
                        type: 'java.lang.Integer',
                        tooltip: "The HTTP port used to connect to the server",
                        'input-attributes': {
                            'min': '0'
                        },
                        required: true
                    },
                    path: {
                        type: 'java.lang.String',
                        tooltip: "The URL path used to connect to Jolokia on the remote server"
                    },
                    userName: {
                        type: 'java.lang.String',
                        tooltip: "The user name to be used when connecting to Jolokia"
                    },
                    password: {
                        type: 'password',
                        tooltip: "The password to be used when connecting to Jolokia"
                    },
                    useProxy: {
                        type: 'java.lang.Boolean',
                        tooltip: "Whether or not we should use a proxy. See more information in the panel to the left.",
                        'control-attributes': {
                            "ng-hide": "disableProxy"
                        }
                    }
                }
            };

            $scope.newConnection = function () {
                $scope.lastConnection = '';
            };

            $scope.deleteConnection = function () {
                delete $scope.connectionConfigs[$scope.lastConnection];
                Core.saveConnectionMap($scope.connectionConfigs);
                var keys = Object.extended($scope.connectionConfigs).keys();
                if (keys.length === 0) {
                    $scope.lastConnection = '';
                } else {
                    $scope.lastConnection = keys[0];
                }
            };

            $scope.$watch('lastConnection', function (newValue, oldValue) {
                JVM.log.debug("lastConnection: ", newValue);
                if (newValue !== oldValue) {
                    if (Core.isBlank(newValue)) {
                        $scope.currentConfig = newConfig();
                    } else {
                        $scope.currentConfig = $scope.connectionConfigs[newValue];
                    }
                    localStorage[JVM.connectControllerKey] = angular.toJson(newValue);
                }
            }, true);

            $scope.save = function () {
                $scope.gotoServer($scope.currentConfig, null, true);
            };

            $scope.gotoServer = function (connectOptions, form, saveOnly) {
                if (!connectOptions) {
                    connectOptions = Core.getConnectOptions($scope.lastConnection);
                }
                var name = connectOptions.name;
                $scope.connectionConfigs[name] = connectOptions;
                $scope.lastConnection = name;
                if (saveOnly === true) {
                    Core.saveConnectionMap($scope.connectionConfigs);
                    $scope.connectionConfigs = Core.loadConnectionMap();
                    angular.extend($scope.currentConfig, $scope.connectionConfigs[$scope.lastConnection]);
                    Core.$apply($scope);
                    return;
                }
                Core.connectToServer(localStorage, connectOptions);
                $scope.connectionConfigs = Core.loadConnectionMap();
                angular.extend($scope.currentConfig, $scope.connectionConfigs[$scope.lastConnection]);
                Core.$apply($scope);
            };
        }]);
})(JVM || (JVM = {}));
/**
* @module Jclouds
*/
var Jclouds;
(function (Jclouds) {
    function ProviderListController($scope, $location, workspace, jolokia) {
        $scope.result = {};
        $scope.providers = [];
        $scope.type = "";
        $scope.types = ["", "blobstore", "compute", "loadbalancer"];

        var key = $location.search()['type'];
        if (key) {
            $scope.type = key;
        }

        // selected providers
        $scope.selectedProviders = [];

        /*
        var SearchProvider = function (scope, location) {
        var self = this;
        self.scope = scope;
        self.location = location;
        
        self.callback = function (newValue, oldValue) {
        if (newValue === oldValue) {
        return;
        }
        self.scope.providers = providersOfType(self.scope.providers, self.scope.type);
        self.scope.type = setSelect(self.scope.type, self.scope.types);
        
        var q = location.search();
        q['type'] = self.scope.type;
        location.search(q);
        self.evalFilter();
        };
        
        self.scope.$watch('type', self.callback);
        
        self.init = function (childScope, grid) {
        self.grid = grid;
        self.childScope = childScope;
        grid.searchProvider = self;
        };
        
        self.evalFilter = function () {
        var byType = self.grid.sortedData;
        if (self.scope.type !== "") {
        byType = self.grid.sortedData.findAll(function (item) {
        return item["type"] === self.scope.type
        });
        }
        self.grid.filteredData = byType;
        self.grid.rowFactory.filteredDataChanged();
        };
        }
        
        var searchProvider = new SearchProvider($scope, $location);
        */
        $scope.providerTable = {
            //plugins: [searchProvider],
            data: 'providers',
            showFilter: false,
            showColumnMenu: false,
            filterOptions: {
                useExternalFilter: true
            },
            selectedItems: $scope.selectedProviders,
            rowHeight: 32,
            selectWithCheckboxOnly: true,
            columnDefs: [
                {
                    field: 'id',
                    displayName: 'Id',
                    cellTemplate: '<div class="ngCellText"><a href="#/jclouds/provider/{{row.getProperty(col.field)}}{{hash}}">{{row.getProperty(col.field)}}</a></div>',
                    width: 200,
                    resizable: false
                },
                {
                    field: 'name',
                    displayName: 'Name',
                    cellTemplate: '<div class="ngCellText">{{row.getProperty(col.field)}}</div>',
                    width: 350
                },
                {
                    field: 'type',
                    displayName: 'Type',
                    cellTemplate: '<div class="ngCellText">{{row.getProperty(col.field)}}</div>',
                    width: 100
                }
            ]
        };

        Core.register(jolokia, $scope, {
            type: 'read', mbean: Jclouds.getSelectionJcloudsMBean(workspace)
        }, onSuccess(render));

        function render(response) {
            if (!Object.equal($scope.result, response.value)) {
                $scope.result = response.value;
                $scope.providers = $scope.result["Providers"];
                Jclouds.populateTypeForProviders($scope.providers);
                Core.$apply($scope);
            }
        }
    }
    Jclouds.ProviderListController = ProviderListController;
})(Jclouds || (Jclouds = {}));
/**
* @module Jclouds
*/
var Jclouds;
(function (Jclouds) {
    function ApiListController($scope, $location, workspace, jolokia) {
        $scope.result = {};
        $scope.apis = [];
        $scope.type = "";
        $scope.types = ["", "blobstore", "compute", "loadbalancer"];

        var key = $location.search()['type'];
        if (key) {
            $scope.type = key;
        }

        // selected apis
        $scope.selectedApis = [];

        /*
        var SearchProvider = function (scope, location) {
        var self = this;
        self.scope = scope;
        self.location = location;
        
        self.callback = function (newValue, oldValue) {
        if (newValue === oldValue) {
        return;
        }
        self.scope.apis = apisOfType(self.scope.apis, self.scope.type);
        self.scope.type = setSelect(self.scope.type, self.scope.types);
        
        var q = location.search();
        q['type'] = self.scope.type;
        location.search(q);
        self.evalFilter();
        };
        
        self.scope.$watch('type', self.callback);
        
        self.init = function (childScope, grid) {
        self.grid = grid;
        self.childScope = childScope;
        grid.searchProvider = self;
        };
        
        self.evalFilter = function () {
        var byType = self.grid.sortedData;
        if (self.scope.type !== "") {
        byType = self.grid.sortedData.findAll(function (item) {
        return item["type"] === self.scope.type
        });
        }
        self.grid.filteredData = byType;
        self.grid.rowFactory.filteredDataChanged();
        };
        }
        
        var searchProvider = new SearchProvider($scope, $location);
        */
        $scope.apiTable = {
            //plugins: [searchProvider],
            data: 'apis',
            showFilter: false,
            showColumnMenu: false,
            filterOptions: {
                useExternalFilter: true
            },
            selectedItems: $scope.selectedApis,
            rowHeight: 32,
            selectWithCheckboxOnly: true,
            columnDefs: [
                {
                    field: 'id',
                    displayName: 'Id',
                    cellTemplate: '<div class="ngCellText"><a href="#/jclouds/api/{{row.getProperty(col.field)}}{{hash}}">{{row.getProperty(col.field)}}</a></div>',
                    width: 200,
                    resizable: false
                },
                {
                    field: 'name',
                    displayName: 'Name',
                    cellTemplate: '<div class="ngCellText">{{row.getProperty(col.field)}}</div>',
                    width: 350
                },
                {
                    field: 'type',
                    displayName: 'Type',
                    cellTemplate: '<div class="ngCellText">{{row.getProperty(col.field)}}</div>',
                    width: 100
                }
            ]
        };

        Core.register(jolokia, $scope, {
            type: 'read', mbean: Jclouds.getSelectionJcloudsMBean(workspace)
        }, onSuccess(render));

        function render(response) {
            if (!Object.equal($scope.result, response.value)) {
                $scope.result = response.value;
                $scope.apis = $scope.result["Apis"];
                Jclouds.populateTypeForApis($scope.apis);
                Core.$apply($scope);
            }
        }
    }
    Jclouds.ApiListController = ApiListController;
})(Jclouds || (Jclouds = {}));
/**
* @module Jclouds
*/
var Jclouds;
(function (Jclouds) {
    /**
    * Controller to show the details of a Jclouds provider
    *
    * @method ProviderController
    * @for Jclouds
    * @param {*} $scope
    * @param {ng.IFilterService} $filter
    * @param {Workspace} workspace
    * @param {ng.IRouteParamsService} $routeParams
    */
    function ProviderController($scope, $filter, workspace, $routeParams) {
        $scope.providerId = $routeParams.providerId;

        updateTableContents();

        function setProvider(provider) {
            Jclouds.populateTypeForProvider(provider);
            $scope.row = provider;
            Core.$apply($scope);
        }
        ;

        function updateTableContents() {
            var jcloudsCoreMbean = Jclouds.getSelectionJcloudsMBean(workspace);
            var jolokia = workspace.jolokia;

            if (jcloudsCoreMbean) {
                setProvider(jolokia.request({ type: 'exec', mbean: Jclouds.getSelectionJcloudsMBean(workspace), operation: 'findProviderById(java.lang.String)', arguments: [$scope.providerId] }).value);
            }
        }
    }
    Jclouds.ProviderController = ProviderController;
})(Jclouds || (Jclouds = {}));
/**
* @module Jclouds
*/
var Jclouds;
(function (Jclouds) {
    function BlobstoreLocationListController($scope, $location, workspace, jolokia, $routeParams) {
        $scope.blobstoreId = $routeParams.blobstoreId;

        $scope.result = {};
        $scope.locations = [];

        // selected locations
        $scope.selectedLocations = [];

        $scope.locationTable = {
            plugins: [],
            data: 'locations',
            showFilter: false,
            showColumnMenu: false,
            filterOptions: {
                useExternalFilter: true
            },
            selectedItems: $scope.selectedLocations,
            rowHeight: 32,
            selectWithCheckboxOnly: true,
            columnDefs: [
                {
                    field: 'id',
                    displayName: 'Id',
                    cellTemplate: '<div class="ngCellText"><a href="#/jclouds/blobstore/location/{{blobstoreId}}/{{row.getProperty(col.field)}}{{hash}}">{{row.getProperty(col.field)}}</a></div>',
                    width: 200,
                    resizable: false
                },
                {
                    field: 'description',
                    displayName: 'Description',
                    cellTemplate: '<div class="ngCellText">{{row.getProperty(col.field)}}</div>',
                    width: 200,
                    resizable: false
                }
            ]
        };

        Core.register(jolokia, $scope, {
            type: 'exec', mbean: Jclouds.getSelectionJcloudsBlobstoreMBean(workspace, $scope.blobstoreId), operation: 'listAssignableLocations()'
        }, onSuccess(render));

        function render(response) {
            if (!Object.equal($scope.result, response.value)) {
                $scope.result = response.value;
                $scope.locations = $scope.result;
                Core.$apply($scope);
            }
        }
    }
    Jclouds.BlobstoreLocationListController = BlobstoreLocationListController;
})(Jclouds || (Jclouds = {}));
/**
* @module Jclouds
*/
var Jclouds;
(function (Jclouds) {
    function BlobstoreListController($scope, $location, workspace, jolokia) {
        $scope.result = {};
        $scope.blobstoreServiceIds = [];
        $scope.blobstoreServices = [];

        $scope.blobstoreTable = {
            plugins: [],
            data: 'blobstoreServices',
            showFilter: false,
            showColumnMenu: false,
            filterOptions: {
                useExternalFilter: true
            },
            selectedItems: $scope.selectedBlobstoreServices,
            rowHeight: 32,
            selectWithCheckboxOnly: true,
            columnDefs: [
                {
                    field: 'name',
                    displayName: 'Service Name',
                    cellTemplate: '<div class="ngCellText"><a href="#/jclouds/blobstore/service/{{row.getProperty(col.field)}}{{hash}}">{{row.getProperty(col.field)}}</a></div>',
                    width: 200,
                    resizable: false
                },
                {
                    field: 'providerId',
                    displayName: 'Proivder',
                    cellTemplate: '<div class="ngCellText">{{row.getProperty(col.field)}}</div>',
                    width: 200,
                    resizable: false
                },
                {
                    field: 'identity',
                    displayName: 'Identity',
                    cellTemplate: '<div class="ngCellText">{{row.getProperty(col.field)}}</div>',
                    width: 200,
                    resizable: false
                }
            ]
        };

        render(Jclouds.listJcloudsMBeanNameOfType(workspace, "blobstore"));

        function render(response) {
            if (!Object.equal($scope.result, response)) {
                $scope.result = response;
                $scope.blobstoreServiceIds = $scope.result;
                var blobstoreServices = [];
                angular.forEach($scope.blobstoreServiceIds, function (id) {
                    blobstoreServices.push(Jclouds.findContextByName(workspace, id));
                });
                $scope.blobstoreServices = blobstoreServices;
                Core.$apply($scope);
            }
        }
    }
    Jclouds.BlobstoreListController = BlobstoreListController;
})(Jclouds || (Jclouds = {}));
/**
* @module Jclouds
*/
var Jclouds;
(function (Jclouds) {
    function BlobstoreNavigationController($scope, $routeParams, workspace) {
        $scope.blobstoreId = $routeParams.blobstoreId;

        $scope.isActive = function (nav) {
            if (angular.isString(nav))
                return workspace.isLinkActive(nav);
            var fn = nav.isActive;
            if (fn) {
                return fn(workspace);
            }
            return workspace.isLinkActive(nav.href());
        };
    }
    Jclouds.BlobstoreNavigationController = BlobstoreNavigationController;
})(Jclouds || (Jclouds = {}));
/**
* @module Jclouds
*/
var Jclouds;
(function (Jclouds) {
    function BlobstoreLocationController($scope, $filter, workspace, $routeParams) {
        $scope.blobstoreId = $routeParams.blobstoreId;
        $scope.locationId = $routeParams.locationId;

        updateTableContents();

        function setLocationProfiles(locationProfiles) {
            $scope.row = findLocationById(locationProfiles, $scope.locationId);
            Core.$apply($scope);
        }
        ;

        function updateTableContents() {
            var jolokia = workspace.jolokia;
            var blobstoreMbean = Jclouds.getSelectionJcloudsBlobstoreMBean(workspace, $scope.blobstoreId);

            if (blobstoreMbean) {
                setLocationProfiles(jolokia.request({ type: 'exec', mbean: blobstoreMbean, operation: 'listAssignableLocations()' }).value);
            }
        }

        function findLocationById(locationProfiles, id) {
            return locationProfiles.find(function (location) {
                return location.id === id;
            });
        }
    }
    Jclouds.BlobstoreLocationController = BlobstoreLocationController;
})(Jclouds || (Jclouds = {}));
/**
* @module Jclouds
*/
var Jclouds;
(function (Jclouds) {
    function BlobstoreContainerListController($scope, $location, workspace, jolokia, $routeParams) {
        $scope.blobstoreId = $routeParams.blobstoreId;

        $scope.result = {};
        $scope.containers = [];

        // selected containers
        $scope.selectedContainers = [];

        $scope.containerTable = {
            plugins: [],
            data: 'containers',
            showFilter: false,
            showColumnMenu: false,
            filterOptions: {
                useExternalFilter: true
            },
            selectedItems: $scope.selectedContainers,
            rowHeight: 32,
            selectWithCheckboxOnly: true,
            columnDefs: [
                {
                    field: 'name',
                    displayName: 'Name',
                    cellTemplate: '<div class="ngCellText"><a href="#/jclouds/blobstore/container/{{blobstoreId}}/{{row.getProperty(col.field)}}{{hash}}">{{row.getProperty(col.field)}}</a></div>',
                    width: 200,
                    resizable: false
                },
                {
                    field: 'creationDate',
                    displayName: 'Created',
                    cellTemplate: '<div class="ngCellText">{{row.getProperty(col.field)}}</div>',
                    width: 200,
                    resizable: false
                }
            ]
        };

        Core.register(jolokia, $scope, {
            type: 'exec', mbean: Jclouds.getSelectionJcloudsBlobstoreMBean(workspace, $scope.blobstoreId), operation: 'list()'
        }, onSuccess(render));

        function render(response) {
            if (!Object.equal($scope.result, response.value)) {
                $scope.result = response.value;
                $scope.containers = $scope.result;
                Core.$apply($scope);
            }
        }
    }
    Jclouds.BlobstoreContainerListController = BlobstoreContainerListController;
})(Jclouds || (Jclouds = {}));
/**
* @module Jclouds
*/
var Jclouds;
(function (Jclouds) {
    function BlobstoreContainerController($scope, $filter, workspace, $routeParams) {
        $scope.blobstoreId = $routeParams.blobstoreId;
        $scope.containerId = $routeParams.containerId;
        $scope.directory = $routeParams.directory;
        $scope.contents = [];
        $scope.breadcrumbs = loadBreadcrumbs($scope.blobstoreId, $scope.containerId, $scope.directory);

        $scope.contentTable = {
            data: 'contents',
            displayFooter: false,
            columnDefs: [
                {
                    field: 'name',
                    displayName: 'Content',
                    cellTemplate: '<div class="ngCellText"><a href="#/jclouds/blobstore/container/{{blobstoreId}}/{{containerId}}/{{row.entity.fullpath}}{{hash}}">{{row.getProperty(col.field)}}</a></div>',
                    cellFilter: ""
                },
                {
                    field: 'createdDate',
                    displayName: 'Created',
                    cellFilter: "date:'EEE, MMM d, y : hh:mm:ss a'"
                },
                {
                    field: 'lastModifiedDate',
                    displayName: 'Modified',
                    cellFilter: "date:'EEE, MMM d, y : hh:mm:ss a'"
                }
            ]
        };

        updateTableContents();

        function setContainers(containers) {
            $scope.contents = populatePathAndName(filterContainers(containers, $scope.directory), $scope.directory);
            Core.$apply($scope);
        }
        ;

        function updateTableContents() {
            var jolokia = workspace.jolokia;
            var blobstoreMbean = Jclouds.getSelectionJcloudsBlobstoreMBean(workspace, $scope.blobstoreId);

            if (blobstoreMbean) {
                if ($scope.directory) {
                    setContainers(jolokia.request({ type: 'exec', mbean: blobstoreMbean, operation: 'list(java.lang.String, java.lang.String)', arguments: [$scope.containerId, $scope.directory] }).value);
                } else {
                    setContainers(jolokia.request({ type: 'exec', mbean: blobstoreMbean, operation: 'list(java.lang.String)', arguments: [$scope.containerId] }).value);
                }
            }
        }

        function filterContainers(containers, directory) {
            return containers.filter(function (container) {
                return container.name !== directory;
            });
        }

        function populatePathAndName(containers, directory) {
            var updatedContainers = [];
            angular.forEach(containers, function (container) {
                var updateContainer = container;
                updateContainer.fullpath = container.name;
                if (updateContainer.name.startsWith(directory)) {
                    updateContainer.name = updateContainer.name.substring(directory.length + 1);
                }
                updatedContainers.push(updateContainer);
            });
            return updatedContainers;
        }

        $scope.isBlob = function (container) {
            return container.type === 'BLOB';
        };

        function loadBreadcrumbs(blobstore, container, directory) {
            var href = "#/jclouds/blobstore/container/" + blobstore + "/" + container;
            var breadcrumbs = [
                { href: href, name: "/" + container }
            ];

            var array = directory ? directory.split("/") : [];
            angular.forEach(array, function (name) {
                if (!name.startsWith("/") && !href.endsWith("/")) {
                    href += "/";
                }
                href += name;
                breadcrumbs.push({ href: href, name: name });
            });
            return breadcrumbs;
        }
    }
    Jclouds.BlobstoreContainerController = BlobstoreContainerController;
})(Jclouds || (Jclouds = {}));
/**
* @module Jclouds
* @main Jclouds
*/
var Jclouds;
(function (Jclouds) {
    var pluginName = 'jclouds';

    angular.module(pluginName, ['bootstrap', 'ngResource', 'ngGrid', 'hawtioCore']).config(function ($routeProvider) {
        $routeProvider.when('/jclouds/api', { templateUrl: 'app/jclouds/html/api-list.html' }).when('/jclouds/api/:apiId', { templateUrl: 'app/jclouds/html/api.html' }).when('/jclouds/provider', { templateUrl: 'app/jclouds/html/provider-list.html' }).when('/jclouds/provider/:providerId', { templateUrl: 'app/jclouds/html/provider.html' }).when('/jclouds/compute/service', { templateUrl: 'app/jclouds/html/compute/compute-service-list.html' }).when('/jclouds/compute/service/:computeId', { templateUrl: 'app/jclouds/html/compute/compute-service.html' }).when('/jclouds/compute/node/:computeId', { templateUrl: 'app/jclouds/html/compute/node-list.html' }).when('/jclouds/compute/node/:computeId/*nodeId', { templateUrl: 'app/jclouds/html/compute/node.html' }).when('/jclouds/compute/image/:computeId', { templateUrl: 'app/jclouds/html/compute/image-list.html' }).when('/jclouds/compute/image/:computeId/*imageId', { templateUrl: 'app/jclouds/html/compute/image.html' }).when('/jclouds/compute/hardware/:computeId', { templateUrl: 'app/jclouds/html/compute/hardware-list.html' }).when('/jclouds/compute/hardware/:computeId/*hardwareId', { templateUrl: 'app/jclouds/html/compute/hardware.html' }).when('/jclouds/compute/location/:computeId', { templateUrl: 'app/jclouds/html/compute/location-list.html' }).when('/jclouds/compute/location/:computeId/*locationId', { templateUrl: 'app/jclouds/html/compute/location.html' }).when('/jclouds/blobstore/service', { templateUrl: 'app/jclouds/html/blobstore/blobstore-service-list.html' }).when('/jclouds/blobstore/service/:blobstoreId', { templateUrl: 'app/jclouds/html/blobstore/blobstore-service.html' }).when('/jclouds/blobstore/location/:blobstoreId', { templateUrl: 'app/jclouds/html/blobstore/location-list.html' }).when('/jclouds/blobstore/location/:blobstoreId/*locationId', { templateUrl: 'app/jclouds/html/blobstore/location.html' }).when('/jclouds/blobstore/container/:blobstoreId', { templateUrl: 'app/jclouds/html/blobstore/container-list.html' }).when('/jclouds/blobstore/container/:blobstoreId/:containerId', { templateUrl: 'app/jclouds/html/blobstore/container.html' }).when('/jclouds/blobstore/container/:blobstoreId/:containerId/*directory', { templateUrl: 'app/jclouds/html/blobstore/container.html' });
    }).run(function (workspace, viewRegistry, helpRegistry) {
        viewRegistry['jclouds'] = "app/jclouds/html/layoutJclouds.html";
        helpRegistry.addUserDoc('jclouds', 'app/' + 'jclouds' + '/doc/help.md', function () {
            return workspace.treeContainsDomainAndProperties("org.jclouds");
        });

        workspace.topLevelTabs.push({
            id: "jclouds",
            content: "jclouds",
            title: "Visualise and manage the Jclouds Compute/BlobStore providers and apis",
            isValid: function (workspace) {
                return workspace.treeContainsDomainAndProperties("org.jclouds");
            },
            href: function () {
                return "#/jclouds/api";
            },
            isActive: function (workspace) {
                return workspace.isLinkActive("jclouds");
            }
        });
    });

    hawtioPluginLoader.addModule(pluginName);
})(Jclouds || (Jclouds = {}));
/**
* @module Jclouds
*/
var Jclouds;
(function (Jclouds) {
    function ComputeLocationListController($scope, $location, workspace, jolokia, $routeParams) {
        $scope.computeId = $routeParams.computeId;

        $scope.result = {};
        $scope.locations = [];

        // selected locations
        $scope.selectedLocations = [];

        $scope.locationTable = {
            plugins: [],
            data: 'locations',
            showFilter: false,
            showColumnMenu: false,
            filterOptions: {
                useExternalFilter: true
            },
            selectedItems: $scope.selectedLocations,
            rowHeight: 32,
            selectWithCheckboxOnly: true,
            columnDefs: [
                {
                    field: 'id',
                    displayName: 'Id',
                    cellTemplate: '<div class="ngCellText"><a href="#/jclouds/compute/location/{{computeId}}/{{row.getProperty(col.field)}}{{hash}}">{{row.getProperty(col.field)}}</a></div>',
                    width: 200,
                    resizable: false
                },
                {
                    field: 'description',
                    displayName: 'Description',
                    cellTemplate: '<div class="ngCellText">{{row.getProperty(col.field)}}</div>',
                    width: 200,
                    resizable: false
                }
            ]
        };

        Core.register(jolokia, $scope, {
            type: 'exec', mbean: Jclouds.getSelectionJcloudsComputeMBean(workspace, $scope.computeId), operation: 'listAssignableLocations()'
        }, onSuccess(render));

        function render(response) {
            if (!Object.equal($scope.result, response.value)) {
                $scope.result = response.value;
                $scope.locations = $scope.result;
                Core.$apply($scope);
            }
        }
    }
    Jclouds.ComputeLocationListController = ComputeLocationListController;
})(Jclouds || (Jclouds = {}));
/**
* @module Jclouds
*/
var Jclouds;
(function (Jclouds) {
    function HardwareListController($scope, $location, workspace, jolokia, $routeParams) {
        $scope.computeId = $routeParams.computeId;

        $scope.result = {};
        $scope.hardwares = [];

        // selected hardwares
        $scope.selectedHardwares = [];

        $scope.hardwareTable = {
            plugins: [],
            data: 'hardwares',
            showFilter: false,
            showColumnMenu: false,
            filterOptions: {
                useExternalFilter: true
            },
            selectedItems: $scope.selectedHardwares,
            rowHeight: 32,
            selectWithCheckboxOnly: true,
            columnDefs: [
                {
                    field: 'id',
                    displayName: 'Id',
                    cellTemplate: '<div class="ngCellText"><a href="#/jclouds/compute/hardware/{{computeId}}/{{row.getProperty(col.field)}}{{hash}}">{{row.getProperty(col.field)}}</a></div>',
                    width: 200,
                    resizable: false
                },
                {
                    field: 'name',
                    displayName: 'Name',
                    cellTemplate: '<div class="ngCellText">{{row.getProperty(col.field)}}</div>',
                    width: 200,
                    resizable: false
                },
                {
                    field: 'ram',
                    displayName: 'Ram',
                    cellTemplate: '<div class="ngCellText">{{row.getProperty(col.field)}}</div>',
                    width: 200,
                    resizable: false
                },
                {
                    field: 'hypervisor',
                    displayName: 'Hypervisor',
                    cellTemplate: '<div class="ngCellText">{{row.getProperty(col.field)}}</div>',
                    width: 200,
                    resizable: false
                }
            ]
        };

        Core.register(jolokia, $scope, {
            type: 'exec', mbean: Jclouds.getSelectionJcloudsComputeMBean(workspace, $scope.computeId), operation: 'listHardwareProfiles()'
        }, onSuccess(render));

        function render(response) {
            if (!Object.equal($scope.result, response.value)) {
                $scope.result = response.value;
                $scope.hardwares = $scope.result;
                Core.$apply($scope);
            }
        }

        $scope.is64BitIcon = function (is64bit) {
            if (is64bit) {
                return 'icon-thumbs-up';
            } else {
                return 'icon-thumbs-down';
            }
        };
    }
    Jclouds.HardwareListController = HardwareListController;
})(Jclouds || (Jclouds = {}));
/**
* @module Jclouds
*/
var Jclouds;
(function (Jclouds) {
    function ImageController($scope, $filter, workspace, $routeParams) {
        $scope.computeId = $routeParams.computeId;
        $scope.imageId = $routeParams.imageId;

        updateTableContents();

        function setImage(api) {
            $scope.row = api;
            Core.$apply($scope);
        }
        ;

        function updateTableContents() {
            var jolokia = workspace.jolokia;
            var computeMbean = Jclouds.getSelectionJcloudsComputeMBean(workspace, $scope.computeId);

            if (computeMbean) {
                setImage(jolokia.request({ type: 'exec', mbean: computeMbean, operation: 'getImage(java.lang.String)', arguments: [$scope.imageId] }).value);
            }
        }
    }
    Jclouds.ImageController = ImageController;
})(Jclouds || (Jclouds = {}));
/**
* @module Jclouds
*/
var Jclouds;
(function (Jclouds) {
    function HardwareController($scope, $filter, workspace, $routeParams) {
        $scope.computeId = $routeParams.computeId;
        $scope.hardwareId = $routeParams.hardwareId;

        updateTableContents();

        $scope.processorsTable = {
            plugins: [],
            data: 'processors',
            showFilter: false,
            displayFooter: false,
            displaySelectionCheckbox: false,
            showColumnMenu: false,
            rowHeight: 32,
            columnDefs: [
                {
                    field: 'cores',
                    displayName: 'Cores',
                    cellTemplate: '<div class="ngCellText">{{row.getProperty(col.field)}}</div>',
                    width: 50,
                    resizable: false
                },
                {
                    field: 'speed',
                    displayName: 'Speed',
                    cellTemplate: '<div class="ngCellText">{{row.getProperty(col.field)}}</div>',
                    width: 100,
                    resizable: false
                }
            ]
        };

        $scope.volumesTable = {
            plugins: [],
            data: 'volumes',
            showFilter: false,
            displayFooter: false,
            displaySelectionCheckbox: false,
            showColumnMenu: false,
            rowHeight: 32,
            columnDefs: [
                {
                    field: 'id',
                    displayName: 'Id',
                    cellTemplate: '<div class="ngCellText">{{row.getProperty(col.field)}}</div>',
                    width: 100,
                    resizable: false
                },
                {
                    field: 'type',
                    displayName: 'Type',
                    cellTemplate: '<div class="ngCellText">{{row.getProperty(col.field)}}</div>',
                    width: 100,
                    resizable: false
                },
                {
                    field: 'device',
                    displayName: 'Device',
                    cellTemplate: '<div class="ngCellText">{{row.getProperty(col.field)}}</div>',
                    width: 100,
                    resizable: false
                },
                {
                    field: 'size',
                    displayName: 'Size',
                    cellTemplate: '<div class="ngCellText">{{row.getProperty(col.field)}}</div>',
                    width: 100,
                    resizable: false
                },
                {
                    field: 'bootDevice',
                    displayName: 'Boot Device',
                    cellTemplate: '<div class="ngCellText">{{row.getProperty(col.field)}}</div>',
                    width: 100,
                    resizable: false
                },
                {
                    field: 'durable',
                    displayName: 'Durable',
                    cellTemplate: '<div class="ngCellText">{{row.getProperty(col.field)}}</div>',
                    width: 100,
                    resizable: false
                }
            ]
        };

        function setHardwareProfiles(hardwareProfiles) {
            $scope.row = findHardwareById(hardwareProfiles, $scope.hardwareId);
            $scope.processors = $scope.row["processors"];
            $scope.volumes = $scope.row["volumes"];
            Core.$apply($scope);
        }
        ;

        function updateTableContents() {
            var jolokia = workspace.jolokia;
            var computeMbean = Jclouds.getSelectionJcloudsComputeMBean(workspace, $scope.computeId);

            if (computeMbean) {
                setHardwareProfiles(jolokia.request({ type: 'exec', mbean: computeMbean, operation: 'listHardwareProfiles()' }).value);
            }
        }

        function findHardwareById(hardwareProfiles, id) {
            return hardwareProfiles.find(function (hardware) {
                return hardware.id === id;
            });
        }
    }
    Jclouds.HardwareController = HardwareController;
})(Jclouds || (Jclouds = {}));
/**
* @module Jclouds
*/
var Jclouds;
(function (Jclouds) {
    function ComputeNavigationController($scope, $routeParams, workspace) {
        $scope.computeId = $routeParams.computeId;

        $scope.isActive = function (nav) {
            if (angular.isString(nav))
                return workspace.isLinkActive(nav);
            var fn = nav.isActive;
            if (fn) {
                return fn(workspace);
            }
            return workspace.isLinkActive(nav.href());
        };
    }
    Jclouds.ComputeNavigationController = ComputeNavigationController;
})(Jclouds || (Jclouds = {}));
/**
* @module Jclouds
*/
var Jclouds;
(function (Jclouds) {
    function ImageListController($scope, $location, workspace, jolokia, $routeParams) {
        $scope.computeId = $routeParams.computeId;

        $scope.result = {};
        $scope.images = [];

        $scope.operatingSystemFamily = "";
        $scope.operatingSystemFamilies = [];
        var os = $location.search()['os'];
        if (os) {
            $scope.operatingSystemFamily = os;
        }

        // selected images
        $scope.selectedImages = [];

        /*
        var SearchProvider = function (scope, location) {
        var self = this;
        self.scope = scope;
        self.location = location;
        
        self.callback = function (newValue, oldValue) {
        if (newValue === oldValue) {
        return;
        }
        self.scope.images = filterImages(self.scope.images, self.scope.operatingSystemFamily);
        self.scope.operatingSystemFamily = setSelect(self.scope.operatingSystemFamily, self.scope.operatingSystemFamilies);
        
        var q = location.search();
        q['os'] = self.scope.operatingSystemFamily;
        location.search(q);
        self.evalFilter();
        };
        
        self.scope.$watch('operatingSystemFamily', self.callback);
        self.scope.$watch('location', self.callback);
        
        self.init = function (childScope, grid) {
        self.grid = grid;
        self.childScope = childScope;
        grid.searchProvider = self;
        };
        
        self.evalFilter = function () {
        var byOperatingSystemFamily = self.grid.sortedData;
        if (self.scope.operatingSystemFamily !== "") {
        byOperatingSystemFamily = self.grid.sortedData.findAll(function (item) {
        return item["operatingSystem"]["family"] === self.scope.operatingSystemFamily
        });
        }
        
        self.grid.filteredData = byOperatingSystemFamily;
        self.grid.rowFactory.filteredDataChanged();
        };
        }
        
        var searchProvider = new SearchProvider($scope, $location);
        */
        $scope.imageTable = {
            //plugins: [searchProvider],
            data: 'images',
            showFilter: false,
            showColumnMenu: false,
            filterOptions: {
                useExternalFilter: true
            },
            selectedItems: $scope.selectedImages,
            rowHeight: 32,
            selectWithCheckboxOnly: true,
            columnDefs: [
                {
                    field: 'id',
                    displayName: 'Id',
                    cellTemplate: '<div class="ngCellText"><a href="#/jclouds/compute/image/{{computeId}}/{{row.getProperty(col.field)}}{{hash}}">{{row.getProperty(col.field)}}</a></div>',
                    width: 200,
                    resizable: false
                },
                {
                    field: 'name',
                    displayName: 'Name',
                    cellTemplate: '<div class="ngCellText">{{row.getProperty(col.field)}}</div>',
                    width: 200,
                    resizable: false
                },
                {
                    field: 'operatingSystem.family',
                    displayName: 'Operating System',
                    cellTemplate: '<div class="ngCellText">{{row.getProperty(col.field)}}</div>',
                    width: 200
                },
                {
                    field: 'operatingSystem.is64Bit',
                    displayName: '64 bit',
                    cellTemplate: '<div class="ngCellText pagination-centered"><i class="icon1point5x {{is64BitIcon(row.getProperty(col.field))}}"></i></div>',
                    width: 200
                },
                {
                    field: 'status',
                    displayName: 'Status',
                    cellTemplate: '<div class="ngCellText">{{row.getProperty(col.field)}}</div>',
                    width: 300
                }
            ]
        };

        Core.register(jolokia, $scope, {
            type: 'exec', mbean: Jclouds.getSelectionJcloudsComputeMBean(workspace, $scope.computeId), operation: 'listImages()'
        }, onSuccess(render));

        function render(response) {
            if (!Object.equal($scope.result, response.value)) {
                $scope.result = response.value;
                $scope.images = $scope.result;
                $scope.operatingSystemFamilies = extractOperatingSystemFamilies($scope.images);
                Core.$apply($scope);
            }
        }

        function extractOperatingSystemFamilies(images) {
            var operatingSystemFamilies = [];
            operatingSystemFamilies.push("");
            angular.forEach(images, function (image) {
                var operatingSystemFamily = image["operatingSystem"]["family"];

                operatingSystemFamilies.push(operatingSystemFamily);
            });
            return operatingSystemFamilies.unique();
        }

        $scope.is64BitIcon = function (is64bit) {
            if (is64bit) {
                return 'icon-thumbs-up';
            } else {
                return 'icon-thumbs-down';
            }
        };
    }
    Jclouds.ImageListController = ImageListController;
})(Jclouds || (Jclouds = {}));
/**
* @module Jclouds
*/
var Jclouds;
(function (Jclouds) {
    function NodeController($scope, $filter, workspace, $routeParams) {
        $scope.computeId = $routeParams.computeId;
        $scope.nodeId = $routeParams.nodeId;

        updateTableContents();

        function setNode(api) {
            $scope.row = api;
            Core.$apply($scope);
        }
        ;

        function updateTableContents() {
            var computeMbean = Jclouds.getSelectionJcloudsComputeMBean(workspace, $scope.computeId);
            var jolokia = workspace.jolokia;

            if (computeMbean) {
                setNode(jolokia.request({ type: 'exec', mbean: computeMbean, operation: 'getNode(java.lang.String)', arguments: [$scope.nodeId] }).value);
            }
        }

        $scope.resume = function () {
            Jclouds.resumeNode(workspace, workspace.jolokia, $scope.computeId, $scope.nodeId, function () {
                console.log("Resumed!");
            }, function () {
                console.log("Failed to resume!");
            });
        };

        $scope.suspend = function () {
            Jclouds.suspendNode(workspace, workspace.jolokia, $scope.computeId, $scope.nodeId, function () {
                console.log("Suspended!");
            }, function () {
                console.log("Failed to suspend!");
            });
        };

        $scope.reboot = function () {
            Jclouds.rebootNode(workspace, workspace.jolokia, $scope.computeId, $scope.nodeId, function () {
                console.log("Rebooted!");
            }, function () {
                console.log("Failed to reboot!");
            });
        };

        $scope.destroy = function () {
            Jclouds.destroyNode(workspace, workspace.jolokia, $scope.computeId, $scope.nodeId, function () {
                console.log("Destroyed!");
            }, function () {
                console.log("Failed to destroy!");
            });
        };
    }
    Jclouds.NodeController = NodeController;
})(Jclouds || (Jclouds = {}));
/**
* @module Jclouds
*/
var Jclouds;
(function (Jclouds) {
    function ComputeLocationController($scope, $filter, workspace, $routeParams) {
        $scope.computeId = $routeParams.computeId;
        $scope.locationId = $routeParams.locationId;

        updateTableContents();

        function setLocationProfiles(locationProfiles) {
            $scope.row = findLocationById(locationProfiles, $scope.locationId);
            Core.$apply($scope);
        }
        ;

        function updateTableContents() {
            var jolokia = workspace.jolokia;
            var computeMbean = Jclouds.getSelectionJcloudsComputeMBean(workspace, $scope.computeId);

            if (computeMbean) {
                setLocationProfiles(jolokia.request({ type: 'exec', mbean: computeMbean, operation: 'listAssignableLocations()' }).value);
            }
        }

        function findLocationById(locationProfiles, id) {
            return locationProfiles.find(function (location) {
                return location.id === id;
            });
        }
    }
    Jclouds.ComputeLocationController = ComputeLocationController;
})(Jclouds || (Jclouds = {}));
/**
* @module Jclouds
*/
var Jclouds;
(function (Jclouds) {
    function ComputeListController($scope, $location, workspace, jolokia) {
        $scope.result = {};
        $scope.computeServiceIds = [];
        $scope.computeServices = [];

        $scope.computeTable = {
            plugins: [],
            data: 'computeServices',
            showFilter: false,
            showColumnMenu: false,
            filterOptions: {
                useExternalFilter: true
            },
            selectedItems: $scope.selectedComputeServices,
            rowHeight: 32,
            selectWithCheckboxOnly: true,
            columnDefs: [
                {
                    field: 'name',
                    displayName: 'Service Name',
                    cellTemplate: '<div class="ngCellText"><a href="#/jclouds/compute/service/{{row.getProperty(col.field)}}{{hash}}">{{row.getProperty(col.field)}}</a></div>',
                    width: 200,
                    resizable: false
                },
                {
                    field: 'providerId',
                    displayName: 'Proivder',
                    cellTemplate: '<div class="ngCellText">{{row.getProperty(col.field)}}</div>',
                    width: 200,
                    resizable: false
                },
                {
                    field: 'identity',
                    displayName: 'Identity',
                    cellTemplate: '<div class="ngCellText">{{row.getProperty(col.field)}}</div>',
                    width: 200,
                    resizable: false
                }
            ]
        };

        render(Jclouds.listJcloudsMBeanNameOfType(workspace, "compute"));

        function render(response) {
            if (!Object.equal($scope.result, response)) {
                $scope.result = response;
                $scope.computeServiceIds = $scope.result;
                var computeServices = [];
                angular.forEach($scope.computeServiceIds, function (id) {
                    computeServices.push(Jclouds.findContextByName(workspace, id));
                });
                $scope.computeServices = computeServices;
                Core.$apply($scope);
            }
        }
    }
    Jclouds.ComputeListController = ComputeListController;
})(Jclouds || (Jclouds = {}));
/**
* @module Jclouds
*/
var Jclouds;
(function (Jclouds) {
    function NodeListController($scope, $location, workspace, jolokia, $routeParams) {
        $scope.computeId = $routeParams.computeId;

        $scope.result = {};
        $scope.nodes = [];

        $scope.group = "";
        $scope.groups = [];

        $scope.location = "";
        $scope.locations = [];

        var grp = $location.search()['group'];
        if (grp) {
            $scope.group = grp;
        }

        var loc = $location.search()['location'];
        if (loc) {
            $scope.location = loc;
        }

        // selected nodes
        $scope.selectedNodes = [];

        /*
        var SearchProvider = function (scope, location) {
        var self = this;
        self.scope = scope;
        self.location = location;
        
        self.callback = function (newValue, oldValue) {
        if (newValue === oldValue) {
        return;
        }
        self.scope.nodes = filterNodes(self.scope.nodes, self.scope.group, self.scope.location);
        self.scope.group = setSelect(self.scope.group, self.scope.groups);
        self.scope.location = setSelect(self.scope.location, self.scope.locations);
        
        var q = location.search();
        q['group'] = self.scope.group;
        q['location'] = self.scope.location;
        location.search(q);
        self.evalFilter();
        };
        
        self.scope.$watch('group', self.callback);
        self.scope.$watch('location', self.callback);
        
        self.init = function (childScope, grid) {
        self.grid = grid;
        self.childScope = childScope;
        grid.searchProvider = self;
        };
        
        self.evalFilter = function () {
        var byGroup = self.grid.sortedData;
        if (self.scope.group !== "") {
        byGroup = self.grid.sortedData.findAll(function (item) {
        return item["group"] === self.scope.group
        });
        }
        
        var byLocation = byGroup;
        if (self.scope.location !== "") {
        byLocation = self.grid.sortedData.findAll(function (item) {
        return item["locationId"] === self.scope.location
        });
        }
        
        self.grid.filteredData = byLocation;
        self.grid.rowFactory.filteredDataChanged();
        };
        }
        
        var searchProvider = new SearchProvider($scope, $location);
        */
        $scope.nodeTable = {
            //plugins: [searchProvider],
            data: 'nodes',
            showFilter: false,
            showColumnMenu: false,
            filterOptions: {
                useExternalFilter: true
            },
            selectedItems: $scope.selectedNodes,
            rowHeight: 32,
            selectWithCheckboxOnly: true,
            columnDefs: [
                {
                    field: 'id',
                    displayName: 'Id',
                    cellTemplate: '<div class="ngCellText"><a href="#/jclouds/compute/node/{{computeId}}/{{row.getProperty(col.field)}}{{hash}}">{{row.getProperty(col.field)}}</a></div>',
                    width: 200,
                    resizable: false
                },
                {
                    field: 'group',
                    displayName: 'Group',
                    cellTemplate: '<div class="ngCellText"><a href="#/jclouds/compute/node/{{row.getProperty(col.field)}}{{hash}}">{{row.getProperty(col.field)}}</a></div>',
                    width: 200,
                    resizable: false
                },
                {
                    field: 'operatingSystem.family',
                    displayName: 'Operating System',
                    cellTemplate: '<div class="ngCellText">{{row.getProperty(col.field)}}</div>',
                    width: 200
                },
                {
                    field: 'locationId',
                    displayName: 'Location',
                    cellTemplate: '<div class="ngCellText">{{row.getProperty(col.field)}}</div>',
                    width: 200
                },
                {
                    field: 'hostname',
                    displayName: 'Host Name',
                    cellTemplate: '<div class="ngCellText">{{row.getProperty(col.field)}}</div>',
                    width: 300
                }
            ]
        };

        Core.register(jolokia, $scope, {
            type: 'exec', mbean: Jclouds.getSelectionJcloudsComputeMBean(workspace, $scope.computeId), operation: 'listNodes()'
        }, onSuccess(render));

        function render(response) {
            if (!Object.equal($scope.result, response.value)) {
                $scope.result = response.value;
                $scope.nodes = $scope.result;
                $scope.locations = extractLocations($scope.nodes);
                $scope.groups = extractGroups($scope.nodes);
                Core.$apply($scope);
            }
        }

        function extractGroups(nodes) {
            var groups = [];
            groups.push("");
            angular.forEach(nodes, function (node) {
                var group = node["group"];
                groups.push(group);
            });
            return groups.unique();
        }

        function extractLocations(nodes) {
            var locations = [];
            locations.push("");
            angular.forEach(nodes, function (node) {
                var location = node["locationId"];
                locations.push(location);
            });
            return locations.unique();
        }

        $scope.resume = function () {
            $scope.selectedNodes.forEach(function (node) {
                Jclouds.resumeNode(workspace, jolokia, $scope.computeId, node.id, function () {
                    console.log("Resumed!");
                }, function () {
                    console.log("Failed to resume!");
                });
            });
        };

        $scope.suspend = function () {
            $scope.selectedNodes.forEach(function (node) {
                Jclouds.suspendNode(workspace, jolokia, $scope.computeId, node.id, function () {
                    console.log("Suspended!");
                }, function () {
                    console.log("Failed to suspend!");
                });
            });
        };

        $scope.reboot = function () {
            $scope.selectedNodes.forEach(function (node) {
                Jclouds.rebootNode(workspace, jolokia, $scope.computeId, node.id, function () {
                    console.log("Rebooted!");
                }, function () {
                    console.log("Failed to reboot!");
                });
            });
        };

        $scope.destroy = function () {
            $scope.selectedNodes.forEach(function (node) {
                Jclouds.destroyNode(workspace, jolokia, $scope.computeId, node.id, function () {
                    console.log("Destroyed!");
                }, function () {
                    console.log("Failed to destroy!");
                });
            });
        };
    }
    Jclouds.NodeListController = NodeListController;
})(Jclouds || (Jclouds = {}));
/**
* @module Jclouds
*/
var Jclouds;
(function (Jclouds) {
    Array.prototype.unique = function () {
        var a = [], l = this.length;
        for (var i = 0; i < l; i++) {
            for (var j = i + 1; j < l; j++)
                if (this[i] === this[j])
                    j = ++i;
            a.push(this[i]);
        }
        return a;
    };

    function setSelect(selection, group) {
        if (!angular.isDefined(selection)) {
            return group[0];
        }
        var answer = group.findIndex(function (item) {
            return item === selection;
        });
        if (answer !== -1) {
            return group[answer];
        } else {
            return group[0];
        }
    }
    Jclouds.setSelect = setSelect;

    /**
    * Returns context by name.
    * @method fundContextByName
    * @for Jclouds
    * @param {Workspace} workspace
    * @param {String} name
    * @return {any}
    */
    function findContextByName(workspace, name) {
        var jcloudsMBean = getSelectionJcloudsMBean(workspace);
        var response = workspace.jolokia.request({ type: 'read', mbean: jcloudsMBean });
        return response.value["Contexts"].find(function (context) {
            return context.name === name;
        });
    }
    Jclouds.findContextByName = findContextByName;

    /**
    * Add the type attribute to an array of apis
    * @method populateTypeForApis
    * @for Jclouds
    * @param {Array} apis
    */
    function populateTypeForApis(apis) {
        angular.forEach(apis, function (api) {
            populateTypeForApi(api);
        });
    }
    Jclouds.populateTypeForApis = populateTypeForApis;

    /**
    * Add the type attribute to a singe api.
    * @method populateTypeForApi
    * @for Jclouds
    * @param {any} api
    */
    function populateTypeForApi(api) {
        var views = api["views"];
        var found = false;
        angular.forEach(views, function (view) {
            if (!found) {
                if (view.has("blob")) {
                    api["type"] = "blobstore";
                    found = true;
                } else if (view.has("compute")) {
                    api["type"] = "compute";
                    found = true;
                }
            }
        });
    }
    Jclouds.populateTypeForApi = populateTypeForApi;

    /**
    * Filters Images based on Operating System.
    * @method filterImages
    * @for Jclouds
    * @param {Array} images
    * @param {any} operatingSystemFamily
    */
    function filterImages(images, operatingSystemFamily) {
        if (operatingSystemFamily === "") {
            return images;
        } else {
            return images.findAll(function (image) {
                return image["operatingSystem"]["family"] === operatingSystemFamily;
            });
        }
    }
    Jclouds.filterImages = filterImages;

    /**
    * Filters Nodes based on type.
    * @method filterNodes
    * @for Jclouds
    * @param {Array} nodes
    * @param {String} group
    * @param {String} location}
    * @return {any}
    */
    function filterNodes(nodes, group, location) {
        var filteredNodes = [];
        if (group === "") {
            filteredNodes = nodes;
        } else {
            filteredNodes = nodes.findAll(function (node) {
                return node.group === group;
            });
        }

        if (location === "") {
            return filteredNodes;
        } else {
            return filteredNodes.findAll(function (node) {
                return node.locationId === location;
            });
        }
    }
    Jclouds.filterNodes = filterNodes;

    function resumeNode(workspace, jolokia, compute, id, success, error) {
        jolokia.request({
            type: 'exec', mbean: getSelectionJcloudsComputeMBean(workspace, compute),
            operation: 'resumeNode(java.lang.String)',
            arguments: [id]
        }, onSuccess(success, { error: error }));
    }
    Jclouds.resumeNode = resumeNode;

    function suspendNode(workspace, jolokia, compute, id, success, error) {
        jolokia.request({
            type: 'exec', mbean: getSelectionJcloudsComputeMBean(workspace, compute),
            operation: 'suspendNode(java.lang.String)',
            arguments: [id]
        }, onSuccess(success, { error: error }));
    }
    Jclouds.suspendNode = suspendNode;

    function rebootNode(workspace, jolokia, compute, id, success, error) {
        jolokia.request({
            type: 'exec', mbean: getSelectionJcloudsComputeMBean(workspace, compute),
            operation: 'rebootNode(java.lang.String)',
            arguments: [id]
        }, onSuccess(success, { error: error }));
    }
    Jclouds.rebootNode = rebootNode;

    function destroyNode(workspace, jolokia, compute, id, success, error) {
        jolokia.request({
            type: 'exec', mbean: getSelectionJcloudsComputeMBean(workspace, compute),
            operation: 'destroyNode(java.lang.String)',
            arguments: [id]
        }, onSuccess(success, { error: error }));
    }
    Jclouds.destroyNode = destroyNode;

    /**
    * Filters Apis based on type.
    * @method apisOfType
    * @for Jclouds
    * @param {Array} apis
    * @param {String} type
    * @return {Array}
    */
    function apisOfType(apis, type) {
        if (type === "") {
            return apis;
        }

        return apis.findAll(function (api) {
            return api.type === type;
        });
    }
    Jclouds.apisOfType = apisOfType;

    /**
    * Add the type attribute to an array of providers.
    * @method populateTypeForProviders
    * @for Jclouds
    * @param {Array} providers
    */
    function populateTypeForProviders(providers) {
        angular.forEach(providers, function (provider) {
            populateTypeForProvider(provider);
        });
    }
    Jclouds.populateTypeForProviders = populateTypeForProviders;

    /**
    * Add the type attribute to a singe provider.
    * @method populateTypeForProvider
    * @for Jclouds
    * @param {any} provider
    */
    function populateTypeForProvider(provider) {
        var views = provider["api"]["views"];
        var found = false;
        angular.forEach(views, function (view) {
            if (!found) {
                if (view.has("blob")) {
                    provider["type"] = "blobstore";
                    found = true;
                } else if (view.has("compute")) {
                    provider["type"] = "compute";
                    found = true;
                }
            }
        });
    }
    Jclouds.populateTypeForProvider = populateTypeForProvider;

    /**
    * Filters Providers based on type.
    * @method providersOfType
    * @for Jclouds
    * @param {Array} providers
    * @param {String} type
    * @return {Array}
    */
    function providersOfType(providers, type) {
        if (type === "") {
            return providers;
        }

        return providers.findAll(function (provider) {
            return provider.type === type;
        });
    }
    Jclouds.providersOfType = providersOfType;

    /**
    * Walks the tree looking in the first child all the way down until we find an objectName
    * @method findFirstObjectName
    * @for Jclouds
    * @param {any} node
    * @return {any}
    */
    function findFirstObjectName(node) {
        if (node) {
            var answer = node.objectName;
            if (answer) {
                return answer;
            } else {
                var children = node.children;
                if (children && children.length) {
                    return findFirstObjectName(children[0]);
                }
            }
        }
        return null;
    }
    Jclouds.findFirstObjectName = findFirstObjectName;

    /**
    * Walks the tree looking for all available names.
    * @method childsOfType
    * @for Jclouds
    * @param {any} node
    * @return {Array}
    */
    function childsOfType(node) {
        var types = [];
        angular.forEach(node.children, function (child) {
            types.push(child.title);
        });

        return types;
    }
    Jclouds.childsOfType = childsOfType;

    /**
    * Jclouds MBeans are all listed under org.jclouds <type> <name>.
    * This method lists all <names> for the specified <type>.
    * @method listJcloudsMBeanNameOfType
    * @for Jclouds
    * @param {Workspace} workspace
    * @param {String} type
    * @return {any}
    */
    function listJcloudsMBeanNameOfType(workspace, type) {
        if (workspace) {
            // lets navigate to the tree item based on paths
            var folder = workspace.tree.navigate("org.jclouds", type);
            return childsOfType(folder);
        }
        return null;
    }
    Jclouds.listJcloudsMBeanNameOfType = listJcloudsMBeanNameOfType;

    /**
    * Returns the Jclouds Core Management MBean
    * @method getSelectionJcloudsMBean
    * @for Jclouds
    * @param {Workspace} workspace
    * @return {String}
    */
    function getSelectionJcloudsMBean(workspace) {
        if (workspace) {
            // lets navigate to the tree item based on paths
            var folder = workspace.tree.navigate("org.jclouds", "management", "core");
            return findFirstObjectName(folder);
        }
        return null;
    }
    Jclouds.getSelectionJcloudsMBean = getSelectionJcloudsMBean;

    /**
    * Returns the Jclouds Compute Management MBean for the specified name.
    * @method getSelectionJcloudsComputeMBean
    * @for Jclouds
    * @param {Workspace} workspace
    * @param {String} name
    * @return {String}
    */
    function getSelectionJcloudsComputeMBean(workspace, name) {
        if (workspace) {
            // lets navigate to the tree item based on paths
            var folder = workspace.tree.navigate("org.jclouds", "compute", name);
            return findFirstObjectName(folder);
        }
        return null;
    }
    Jclouds.getSelectionJcloudsComputeMBean = getSelectionJcloudsComputeMBean;

    /**
    * Returns the Jclouds Compute Management MBean for the specified name.
    * @method getSelectionJcloudsBlobstoreMBean
    * @for Jclouds
    * @param {Workspace} workspace
    * @param {String} name
    * @return {String}
    */
    function getSelectionJcloudsBlobstoreMBean(workspace, name) {
        if (workspace) {
            // lets navigate to the tree item based on paths
            var folder = workspace.tree.navigate("org.jclouds", "blobstore", name);
            return findFirstObjectName(folder);
        }
        return null;
    }
    Jclouds.getSelectionJcloudsBlobstoreMBean = getSelectionJcloudsBlobstoreMBean;
})(Jclouds || (Jclouds = {}));
/**
* @module Jclouds
*/
var Jclouds;
(function (Jclouds) {
    function ApiController($scope, $filter, workspace, $routeParams) {
        $scope.apiId = $routeParams.apiId;

        updateTableContents();

        function setApi(api) {
            Jclouds.populateTypeForApi(api);
            $scope.row = api;
            Core.$apply($scope);
        }
        ;

        function updateTableContents() {
            var jcloudsCoreMbean = Jclouds.getSelectionJcloudsMBean(workspace);
            var jolokia = workspace.jolokia;

            if (jcloudsCoreMbean) {
                setApi(jolokia.request({ type: 'exec', mbean: Jclouds.getSelectionJcloudsMBean(workspace), operation: 'findApiById(java.lang.String)', arguments: [$scope.apiId] }).value);
            }
        }
    }
    Jclouds.ApiController = ApiController;
})(Jclouds || (Jclouds = {}));
/**
* API plugin for browsing WSDL and WADL
*
* @module API
* @main API
*/
var API;
(function (API) {
    var pluginName = 'api';
    angular.module(pluginName, ['bootstrap', 'hawtioCore', 'hawtio-ui']).config(function ($routeProvider) {
        $routeProvider.when('/api/wsdl', { templateUrl: 'app/api/html/wsdl.html' }).when('/api/wadl', { templateUrl: 'app/api/html/wadl.html' });
    }).run(function ($location, workspace, viewRegistry, layoutFull, helpRegistry) {
        viewRegistry['api'] = layoutFull;
        /*
        helpRegistry.addUserDoc('log', 'app/wsdl/doc/help.md', () => {
        return workspace.treeContainsDomainAndProperties('org.fusesource.insight', {type: 'LogQuery'});
        });
        */
    });

    hawtioPluginLoader.addModule(pluginName);
})(API || (API = {}));
/**
* @module API
*/
var API;
(function (API) {
    function WsdlViewController($scope, $location, jolokia) {
        var log = Logger.get("API");

        API.initScope($scope, $location, jolokia);
        var wsdlNamespace = "http://schemas.xmlsoap.org/wsdl/";

        $scope.url = $location.search()["wsdl"];
        API.loadXml($scope.url, onWsdl);

        $scope.$watch("services", enrichApiDocsWithSchema);
        $scope.$watch("jsonSchema", enrichApiDocsWithSchema);

        function enrichApiDocsWithSchema() {
            var services = $scope.services;
            var jsonSchema = $scope.jsonSchema;
            if (services && jsonSchema) {
                log.info("We have services and jsonSchema!");
                enrichServices(jsonSchema, services);
            }
        }

        function enrichServices(jsonSchema, services) {
            angular.forEach(services, function (service) {
                angular.forEach(service.operations, function (method) {
                    angular.forEach(API.concatArrays([method.inputs, method.outputs]), function (object) {
                        enrichRepresentation(jsonSchema, object);
                    });
                });
            });
        }

        function enrichRepresentation(jsonSchema, representation) {
            var defs = jsonSchema ? jsonSchema["definitions"] : null;
            if (defs && representation) {
                var name = representation["name"];
                if (name) {
                    var foundDef = defs[name];
                    if (foundDef) {
                        // unwrap arrays
                        if (angular.isArray(foundDef) && foundDef.length > 0) {
                            foundDef = foundDef[0];
                        }
                        log.info("Found def " + angular.toJson(foundDef) + " for name " + name);
                        representation["schema"] = foundDef;
                    }
                }
            }
        }

        function onWsdl(response) {
            $scope.services = [];
            var root = response.documentElement;
            var targetNamespace = root ? root.getAttribute("targetNamespace") : null;
            var name = root ? root.getAttribute("name") : null;
            var portTypes = response.getElementsByTagNameNS(wsdlNamespace, "portType");
            var services = response.getElementsByTagNameNS(wsdlNamespace, "service");
            var bindings = response.getElementsByTagNameNS(wsdlNamespace, "binding");

            angular.forEach(portTypes, function (portType) {
                var service = {
                    name: name,
                    targetNamespace: targetNamespace,
                    portName: portType.getAttribute("name") || "Unknown",
                    operations: []
                };
                $scope.services.push(service);
                var operations = portType.getElementsByTagNameNS(wsdlNamespace, "operation");
                angular.forEach(operations, function (operation) {
                    var input = operation.getElementsByTagNameNS(wsdlNamespace, "input");
                    var output = operation.getElementsByTagNameNS(wsdlNamespace, "output");

                    function createMessageData(data) {
                        var answer = [];
                        angular.forEach(data, function (item) {
                            var name = item.getAttribute("name");
                            if (name) {
                                answer.push({
                                    name: name
                                });
                            }
                        });
                        return answer;
                    }

                    var opData = {
                        name: operation.getAttribute("name") || "Unknown",
                        inputs: createMessageData(input),
                        outputs: createMessageData(output)
                    };
                    service.operations.push(opData);
                });
            });
            Core.$apply($scope);
        }
    }
    API.WsdlViewController = WsdlViewController;
})(API || (API = {}));
/**
* @module API
*/
var API;
(function (API) {
    API.log = Logger.get("API");

    API.wadlNamespace = "http://schemas.xmlsoap.org/wsdl/";

    /**
    * Loads the XML for the given url if its defined or ignore if not valid
    * @method loadXml
    * @for API
    * @static
    * @param {String} url
    * @param {Function} onXml
    *
    */
    function loadXml(url, onXml) {
        if (url) {
            API.log.info("Loading XML: " + url);

            var ajaxParams = {
                type: "GET",
                url: url,
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', null);
                },
                dataType: "xml",
                contextType: "text/xml",
                success: onXml,
                error: function (jqXHR, textStatus, errorThrow) {
                    API.log.error("Failed to query XML for: " + url + " status:" + textStatus + " error: " + errorThrow);
                }
            };
            $.ajax(ajaxParams);
        }
    }
    API.loadXml = loadXml;

    var wadlXmlToJavaConfig = {};

    function parseJson(json) {
        var answer = null;
        try  {
            //console.log("got JSON: " + responseJson);
            answer = JSON.parse(json);
        } catch (e) {
            API.log.info("Failed to parse JSON " + e);
            API.log.info("JSON: " + json);
        }
        return answer;
    }
    API.parseJson = parseJson;

    function initScope($scope, $location, jolokia) {
        var search = $location.search();
        $scope.container = search["container"];
        $scope.objectName = search["objectName"];

        $scope.showHide = function (resource) {
            if (resource) {
                resource.hide = resource.hide ? false : true;
            }
        };

        $scope.showOperations = function (resource) {
            showHideOperations(resource, false);
        };

        $scope.expandOperations = function (resource) {
            showHideOperations(resource, true);
        };

        function showHideOperations(resource, flag) {
            if (resource) {
                resource.hide = false;
                angular.forEach(resource.resource, function (childResource) {
                    showHideOperations(childResource, flag);
                });
                angular.forEach(resource.method || resource.operations, function (method) {
                    method.expanded = flag;
                });
            }
        }

        $scope.autoFormat = function (codeMirror) {
            if (!codeMirror) {
                // lets try find the codeMirror in a child scope as a hack :)
                codeMirror = findChildScopeValue($scope, "codeMirror");
            }
            if (codeMirror) {
                setTimeout(function () {
                    CodeEditor.autoFormatEditor(codeMirror);
                }, 50);
            }
        };

        /**
        * Note using this method is usually a dirty hack ;)
        */
        function findChildScopeValue(scope, name) {
            var answer = scope[name];
            var childScope = scope.$$childHead;
            while (childScope && !answer) {
                answer = findChildScopeValue(childScope, name);
                childScope = childScope.$$nextSibling;
            }
            return answer;
        }

        if ($scope.container && $scope.objectName) {
            Fabric.containerJolokia(jolokia, $scope.container, function (remoteJolokia) {
                $scope.remoteJolokia = remoteJolokia;
                if (remoteJolokia) {
                    API.loadJsonSchema(remoteJolokia, $scope.objectName, function (jsonSchema) {
                        //log.info("Got JSON Schema: " + JSON.stringify(jsonSchema, null, "  "));
                        $scope.jsonSchema = jsonSchema;
                        Core.$apply($scope);
                    });
                } else {
                    API.log.info("No Remote Jolokia!");
                }
            });
        } else {
            API.log.info("No container or objectName");
        }
        API.log.info("container: " + $scope.container + " objectName: " + $scope.objectName + " url: " + $scope.url);
    }
    API.initScope = initScope;

    /**
    * Loads the JSON schema from a given CXF endpoint mbean
    * @method loadJsonSchema
    * @for API
    * @static
    * @paran {*} jolokia
    * @param {String} mbean
    * @param {Function} onJsonSchemaFn
    */
    function loadJsonSchema(jolokia, mbean, onJsonSchemaFn) {
        function onResults(response) {
            var schema = {};
            if (response) {
                var json = response;
                if (json) {
                    schema = parseJson(json);
                }
            }
            onJsonSchemaFn(schema);
        }
        if (mbean) {
            return jolokia.execute(mbean, "getJSONSchema", onSuccess(onResults));
        } else {
            var schema = {};
            onJsonSchemaFn(schema);
            return schema;
        }
    }
    API.loadJsonSchema = loadJsonSchema;

    /**
    * When a WADL XML document is loaded, lets convert it to JSON and return it
    * @method onWadlXmlLoaded
    * @for API
    * @static
    * @param {any} response
    * @return {any}
    */
    function onWadlXmlLoaded(response) {
        var root = response.documentElement;
        var output = {};
        return API.convertWadlToJson(root, output);
    }
    API.onWadlXmlLoaded = onWadlXmlLoaded;

    /**
    * Converts the given XML element from WADL to JSON
    * @method convertWadlToJson
    * @for API
    * @static
    * @param {any} element
    * @param {any} obj
    * @return {any}
    */
    function convertWadlToJson(element, obj) {
        if (typeof obj === "undefined") { obj = {}; }
        return API.convertXmlToJson(element, obj, wadlXmlToJavaConfig);
    }
    API.convertWadlToJson = convertWadlToJson;

    function convertWadlJsonToSwagger(object) {
        // now lets convert to swagger style json
        var apis = [];
        var basePath = null;
        var resourcePath = null;

        var resources = Core.pathGet(object, ["resources", 0]);
        if (resources) {
            basePath = resources.base;
            angular.forEach(resources.resource, function (resource) {
                var path = resource.path;
                var operations = [];
                angular.forEach(resource.method, function (method) {
                    var name = method.name;
                    var responseMessages = [];

                    /*
                    {
                    "code": 404,
                    "message": "There are no businesses"
                    }
                    */
                    var parameters = [];

                    /*
                    {
                    "name": "query",
                    "description": "a text query to search across facilities",
                    "required": false,
                    "allowMultiple": false,
                    "dataType": "string",
                    "paramType": "query"
                    }
                    
                    */
                    operations.push({
                        "method": method.name,
                        "summary": method.summary,
                        "notes": method.notes,
                        "nickname": method.nickname,
                        "type": method.type,
                        "parameters": parameters,
                        "produces": [
                            "application/json"
                        ],
                        "responseMessages": responseMessages
                    });
                });

                apis.push({
                    path: path,
                    operations: operations
                });
            });
        }
        return {
            "apiVersion": "1.0",
            "swaggerVersion": "1.2",
            "basePath": basePath,
            "resourcePath": resourcePath,
            "produces": [
                "application/json"
            ],
            apis: apis
        };
    }
    API.convertWadlJsonToSwagger = convertWadlJsonToSwagger;

    function nodeName(owner, node) {
        return node ? node.localName : null;
    }

    /**
    * Converts the given child elements or attributes into properties on the object
    * to convert the XML into JSON using the given config to customise which properties should
    * be considered singular
    * @method convertXmlToJson
    * @for API
    * @static
    * @param {any} element
    * @param {any} obj
    * @param {any} config
    * @return {any}
    */
    function convertXmlToJson(element, obj, config) {
        var elementProperyFn = config.elementToPropertyName || nodeName;
        var attributeProperyFn = config.attributeToPropertyName || nodeName;

        angular.forEach(element.childNodes, function (child) {
            if (child.nodeType === 1) {
                var propertyName = elementProperyFn(element, child);
                if (propertyName) {
                    // TODO should we assume everything is a list and then flatten later?
                    var array = obj[propertyName] || [];
                    if (!angular.isArray(array)) {
                        array = [array];
                    }
                    var value = {};
                    convertXmlToJson(child, value, config);
                    array.push(value);
                    obj[propertyName] = array;
                }
            }
        });
        angular.forEach(element.attributes, function (attr) {
            var propertyName = attributeProperyFn(element, attr);
            if (propertyName) {
                var value = attr.nodeValue;
                obj[propertyName] = value;
            }
        });
        return obj;
    }
    API.convertXmlToJson = convertXmlToJson;

    /**
    * Concatenate all the non-null arrays into a single array
    * @param arrays an array of arrays
    * @return the single flatten arrays with any null/undefined values ignored
    */
    function concatArrays(arrays) {
        var answer = [];
        angular.forEach(arrays, function (array) {
            if (array) {
                if (angular.isArray(array)) {
                    answer = answer.concat(array);
                } else {
                    answer.push(array);
                }
            }
        });
        return answer;
    }
    API.concatArrays = concatArrays;
})(API || (API = {}));
/**
* @module API
*/
var API;
(function (API) {
    function WadlViewController($scope, $location, $http, jolokia) {
        API.initScope($scope, $location, jolokia);

        $scope.url = $location.search()["wadl"];
        API.loadXml($scope.url, onWsdl);

        $scope.$watch("apidocs", enrichApiDocsWithSchema);
        $scope.$watch("jsonSchema", enrichApiDocsWithSchema);

        $scope.tryInvoke = function (resource, method) {
            if (resource) {
                var path = resource.fullPath || resource.path;
                if (path) {
                    // lets substitue the parameters
                    angular.forEach(resource.param, function (param) {
                        var name = param.name;
                        if (name) {
                            var value = param.value;
                            if (angular.isUndefined(value) || value === null) {
                                value = "";
                            }
                            value = value.toString();
                            API.log.debug("replacing " + name + " with '" + value + "'");
                            path = path.replace(new RegExp("{" + name + "}", "g"), value);
                        }
                    });
                    API.log.info("Lets invoke resource: " + path);
                    var url = Core.useProxyIfExternal(path);
                    var methodName = method.name || "GET";
                    method.invoke = {
                        url: url,
                        running: true
                    };
                    var requestData = {
                        method: methodName,
                        url: url,
                        headers: {}
                    };
                    if (methodName === "POST" || methodName === "PUT") {
                        // lets see if we can find a payload
                        angular.forEach(method.request, function (request) {
                            if (!requestData["data"]) {
                                requestData["data"] = request.value;
                            }
                            if (!requestData.headers["Content-Type"]) {
                                requestData.headers["Content-Type"] = request.contentType;
                            }
                        });
                    }
                    API.log.info("About to make request: " + angular.toJson(requestData));
                    $http(requestData).success(function (data, status, headers, config) {
                        API.log.info("Worked!" + data);
                        method.invoke = {
                            url: url,
                            realUrl: path,
                            success: true,
                            data: data,
                            dataMode: textFormat(headers),
                            status: status,
                            headers: headers(),
                            config: config
                        };
                        Core.$apply($scope);
                    }).error(function (data, status, headers, config) {
                        // called asynchronously if an error occurs
                        // or server returns response with an error status.
                        API.log.info("Failed: " + status);
                        method.invoke = {
                            url: url,
                            realUrl: path,
                            data: data,
                            dataMode: textFormat(headers),
                            status: status,
                            headers: headers(),
                            config: config
                        };
                        Core.$apply($scope);
                    });
                }
            }
        };

        function textFormat(headers) {
            return contentTypeTextFormat(headers("content-type"));
        }

        function contentTypeTextFormat(contentType) {
            if (contentType) {
                if (contentType.endsWith("xml")) {
                    return "xml";
                }
                if (contentType.endsWith("html")) {
                    return "html";
                }
                if (contentType.endsWith("json")) {
                    return "json";
                }
            }
            return null;
        }

        function enrichApiDocsWithSchema() {
            var apidocs = $scope.apidocs;
            var jsonSchema = $scope.jsonSchema;
            if (apidocs && jsonSchema) {
                enrichResources(jsonSchema, apidocs.resources);
            }
        }

        function enrichResources(jsonSchema, resources, parentUri) {
            if (typeof parentUri === "undefined") { parentUri = null; }
            angular.forEach(resources, function (resource) {
                var base = resource.base;
                if (base) {
                    if (parentUri) {
                        base = parentUri + base;
                    }
                } else {
                    base = parentUri;
                }
                var path = resource.path;
                if (base && path) {
                    if (!base.endsWith("/") && !path.startsWith("/")) {
                        base += "/";
                    }
                    base += path;
                    resource["fullPath"] = base;
                }
                var childResources = resource.resource;
                if (childResources) {
                    enrichResources(jsonSchema, childResources, base);
                }
                angular.forEach(API.concatArrays([resource.method, resource.operation]), function (method) {
                    // lets remove any empty requests
                    var request = method.request;
                    if (request) {
                        var count = request.count(function (n) {
                            return n["representation"];
                        });
                        if (!count) {
                            delete method.request;
                        }
                    }
                    angular.forEach(API.concatArrays([method.request, method.response]), function (object) {
                        var element = object["element"];
                        var representations = object["representation"];
                        if (representations) {
                            var mediaTypes = representations.map(function (r) {
                                return r["mediaType"];
                            });
                            object["mediaTypes"] = mediaTypes;
                            if (mediaTypes && mediaTypes.length) {
                                object["contentType"] = mediaTypes[0];
                            }
                        }
                        angular.forEach(representations, function (representation) {
                            if (!element) {
                                element = representation["element"];
                            }
                            enrichRepresentation(jsonSchema, representation);
                        });
                        if (element) {
                            object["element"] = element;
                        }
                    });
                });
            });
        }

        function enrichRepresentation(jsonSchema, representation) {
            var defs = jsonSchema ? jsonSchema["definitions"] : null;
            if (defs && representation) {
                var contentType = representation["mediaType"];
                if (contentType) {
                    representation["dataMode"] = contentTypeTextFormat(contentType);
                }

                // TODO find a class name in the representation?
                var element = representation["element"];
                if (element) {
                    var idx = element.indexOf(':');
                    if (idx >= 0) {
                        element = element.substring(idx + 1);
                    }

                    // lets see if we can find a definition which ends with this element
                    var elementPostfix = "." + element;
                    var foundDef = null;
                    angular.forEach(defs, function (value, key) {
                        if (!foundDef && (key === element || key.endsWith(elementPostfix))) {
                            foundDef = value;
                            representation["schema"] = foundDef;
                            representation["typeName"] = element;
                            representation["javaClass"] = key;
                        }
                    });
                }
            }
        }

        function onWsdl(response) {
            $scope.apidocs = API.onWadlXmlLoaded(response);

            //log.info("API docs: " + JSON.stringify($scope.apidocs, null, "  "));
            Core.$apply($scope);
        }
    }
    API.WadlViewController = WadlViewController;
})(API || (API = {}));
var Camin;
(function (Camin) {
    var Sequence = (function () {
        function Sequence() {
            this.endpoints = [];
            this.execs = [];
            this.calls = [];
        }
        Sequence.prototype.endpoint = function (url, routeId, contextId, host) {
            for (var i = 0; i < this.endpoints.length; i++) {
                if (this.endpoints[i].url === url && this.endpoints[i].routeId === routeId && this.endpoints[i].contextId === contextId && this.endpoints[i].host === host) {
                    return this.endpoints[i];
                }
            }
            var endpoint = new Endpoint(url, routeId, contextId, host);
            this.endpoints.push(endpoint);
            return endpoint;
        };

        Sequence.prototype.exec = function (exchangeId, endpoint, start, stop) {
            var exec = new Execution(exchangeId, endpoint, start, stop);
            this.execs.push(exec);
            return exec;
        };

        Sequence.prototype.call = function (callId, execA, execB, start, stop) {
            var call = new Call(callId, execA, execB, start, stop);
            this.calls.push(call);
            return call;
        };

        Sequence.prototype.start = function () {
            var start;
            for (var i = 0; i < this.execs.length; i++) {
                start = start ? Math.min(start, this.execs[i].start) : this.execs[i].start;
            }
            for (var i = 0; i < this.calls.length; i++) {
                start = start ? Math.min(start, this.calls[i].start) : this.calls[i].start;
            }
            return start;
        };

        Sequence.prototype.stop = function () {
            var stop;
            for (var i = 0; i < this.execs.length; i++) {
                stop = stop ? Math.max(stop, this.execs[i].stop) : this.execs[i].stop;
            }
            for (var i = 0; i < this.calls.length; i++) {
                stop = stop ? Math.max(stop, this.calls[i].stop) : this.calls[i].stop;
            }
            return stop;
        };
        return Sequence;
    })();
    Camin.Sequence = Sequence;

    var Endpoint = (function () {
        function Endpoint(url, routeId, contextId, host) {
            this.url = url;
            this.routeId = routeId;
            this.contextId = contextId;
            this.host = host;
        }
        return Endpoint;
    })();
    Camin.Endpoint = Endpoint;

    var Execution = (function () {
        function Execution(exchangeId, endpoint, start, stop) {
            this.exchangeId = exchangeId;
            this.endpoint = endpoint;
            this.start = start;
            this.stop = stop;
        }
        return Execution;
    })();
    Camin.Execution = Execution;

    var Call = (function () {
        function Call(callId, execA, execB, start, stop) {
            this.callId = callId;
            this.execA = execA;
            this.execB = execB;
            this.start = start;
            this.stop = stop;
        }
        return Call;
    })();
    Camin.Call = Call;
})(Camin || (Camin = {}));
var Camin;
(function (Camin) {
    var Gantt = (function () {
        function Gantt() {
            this.resources = [];
            this.tasks = [];
            this.links = [];
        }
        Gantt.prototype.resource = function (data) {
            var resource = new Resource(data, this.resources.length);
            this.resources.push(resource);
            return resource;
        };

        Gantt.prototype.task = function (resource, start, stop, data) {
            var task = resource.task(start, stop, data);
            this.tasks.push(task);
            return task;
        };

        Gantt.prototype.link = function (start, taskA, stop, taskB, data) {
            var link = new Link(start, taskA, stop, taskB, data);
            this.links.push(link);
            return link;
        };

        Gantt.prototype.layout = function () {
            for (var i = 0; i < this.resources.length; i++) {
                this.resources[i].layout();
                this.start = this.start ? Math.min(this.start, this.resources[i].start) : this.resources[i].start;
                this.stop = this.stop ? Math.max(this.stop, this.resources[i].stop) : this.resources[i].stop;
            }
            for (var i = 0; i < this.links.length; i++) {
                this.start = this.start ? Math.min(this.start, this.links[i].start) : this.links[i].start;
                this.stop = this.stop ? Math.max(this.stop, this.links[i].stop) : this.links[i].stop;
            }
        };

        Gantt.prototype.taskByData = function (data) {
            for (var i = 0; i < this.tasks.length; i++) {
                if (this.tasks[i].data === data) {
                    return this.tasks[i];
                }
            }
            return undefined;
        };
        return Gantt;
    })();
    Camin.Gantt = Gantt;

    var Resource = (function () {
        function Resource(data, index) {
            this.tasks = [];
            this.index = index;
            this.data = data;
        }
        Resource.prototype.task = function (start, stop, data) {
            var task = new Task(start, stop, data, this);
            this.tasks.push(task);
            return task;
        };

        Resource.prototype.layout = function () {
            this.tasks.sort(function (ta, tb) {
                return ta.start - tb.start;
            });
            var bands = [];
            for (var i = 0; i < this.tasks.length; i++) {
                this.start = this.start ? Math.min(this.start, this.tasks[i].start) : this.tasks[i].start;
                this.stop = this.stop ? Math.max(this.stop, this.tasks[i].stop) : this.tasks[i].stop;
                for (var j = 0; j < bands.length; j++) {
                    if (bands[j] < this.tasks[i].start) {
                        bands[j] = this.tasks[i].stop;
                        this.tasks[i].index = j;
                        break;
                    }
                }
                if (!this.tasks[i].index) {
                    var index = bands.length;
                    this.tasks[i].index = index;
                    bands[index] = this.tasks[i].stop;
                }
            }
            for (var i = 0; i < this.tasks.length; i++) {
                this.tasks[i].max = bands.length;
            }
        };
        return Resource;
    })();
    Camin.Resource = Resource;

    var Task = (function () {
        function Task(start, stop, data, resource) {
            this.start = start;
            this.stop = stop;
            this.data = data;
            this.resource = resource;
        }
        return Task;
    })();
    Camin.Task = Task;

    var Link = (function () {
        function Link(start, taskA, stop, taskB, data) {
            this.start = start;
            this.stop = stop;
            this.taskA = taskA;
            this.taskB = taskB;
            this.data = data;
        }
        return Link;
    })();
    Camin.Link = Link;
})(Camin || (Camin = {}));
/**
* Camel Insight Plugin
*
* @module Camin
* @main Camin
*/
var Camin;
(function (Camin) {
    var pluginName = 'camin';
    angular.module(pluginName, ['bootstrap', 'ngResource', 'ngGrid', 'hawtioCore']).config(function ($routeProvider) {
        $routeProvider.when('/camin', { templateUrl: 'app/camin/html/camin.html' }).when('/camin/:exchangeId', { templateUrl: 'app/camin/html/camin.html' });
    }).run(function (workspace, viewRegistry, helpRegistry) {
        viewRegistry["camin"] = "app/camin/html/layoutCamin.html";
        helpRegistry.addUserDoc('camin', 'app/camin/doc/help.md', function () {
            return Fabric.hasFabric(workspace);
        });

        workspace.topLevelTabs.push({
            id: "camin",
            content: "Camel",
            title: "Insight into Camel",
            isValid: function (workspace) {
                return Fabric.hasFabric(workspace);
            },
            href: function () {
                return "#/camin";
            },
            isActive: function (workspace) {
                return workspace.isLinkActive("camin");
            }
        });
    });

    hawtioPluginLoader.addModule(pluginName);
})(Camin || (Camin = {}));
var Camin;
(function (Camin) {
    function Controller($scope, jolokia, localStorage, $routeParams) {
        $scope.query = "";
        $scope.result = "";
        $scope.breadcrumbs = [];

        $scope.onQueryChange = function () {
            $scope.result = "Querying exchanges related to " + $scope.query;
            $scope.breadcrumbs = [$scope.query];
            request();
        };

        var request = function () {
            var queryStr = "exchange.id:\"" + $scope.breadcrumbs.join("\" or exchange.id:\"") + "\" or " + "exchange.in.headers.ExtendedBreadcrumb:\"" + $scope.breadcrumbs.join("\" or exchange.in.headers.ExtendedBreadcrumb:\"") + "\" or " + "exchange.out.headers.ExtendedBreadcrumb:\"" + $scope.breadcrumbs.join("\" or exchange.out.headers.ExtendedBreadcrumb:\"") + "\"";
            var query = {
                "query": { "query_string": { "query": queryStr } },
                "fields": ["exchange.id", "exchange.in.headers.ExtendedBreadcrumb", "exchange.out.headers.ExtendedBreadcrumb"],
                "from": 0,
                "size": 1000
            };
            var jreq = {
                type: 'exec',
                mbean: 'org.elasticsearch:service=restjmx',
                operation: 'exec',
                arguments: ['POST', '/_all/camel/_search', angular.toJson(query)] };
            jolokia.request(jreq, {
                method: 'POST',
                error: function (response) {
                    $scope.result = $scope.result + "<br/>" + "Error: " + angular.toJson(response);
                },
                success: function (response) {
                    var data = jQuery.parseJSON(response.value);
                    var oldsize = $scope.breadcrumbs.length;
                    for (var i = 0; i < data['hits']['hits'].length; i++) {
                        var fields = data['hits']['hits'][i].fields;
                        var concat = function (breadcrumbs) {
                            if (breadcrumbs) {
                                if (typeof breadcrumbs === 'string') {
                                    breadcrumbs = [breadcrumbs];
                                }
                                for (var j = 0; j < breadcrumbs.length; j++) {
                                    var id = breadcrumbs[j];
                                    if ($scope.breadcrumbs.indexOf(id) < 0) {
                                        $scope.breadcrumbs.push(id);
                                    }
                                }
                            }
                        };
                        concat(fields["exchange.in.headers.ExtendedBreadcrumb"]);
                        concat(fields["exchange.out.headers.ExtendedBreadcrumb"]);
                    }
                    $scope.result = $scope.result + "<br/>" + "Found " + data.hits.total + " ids";
                    if (oldsize != $scope.breadcrumbs.length) {
                        request();
                    } else {
                        var ids = [];
                        for (var i = 0; i < data['hits']['hits'].length; i++) {
                            var id = data['hits']['hits'][i].fields["exchange.id"];
                            if (ids.indexOf(id) < 0) {
                                ids.push(id);
                            }
                        }
                        var queryStr = "exchange.id:\"" + ids.join("\" or exchange.id:\"") + "\"";
                        $scope.result = $scope.result + "<br/>" + query;
                        var query = {
                            "query": { "query_string": { "query": queryStr } },
                            "from": 0,
                            "size": 1000,
                            "sort": ["timestamp"]
                        };
                        var jreq = {
                            type: 'exec',
                            mbean: 'org.elasticsearch:service=restjmx',
                            operation: 'exec',
                            arguments: ['POST', '/_all/camel/_search', angular.toJson(query)] };
                        jolokia.request(jreq, {
                            method: 'POST',
                            error: function (response) {
                                $scope.result = $scope.result + "<br/>" + "Error: " + angular.toJson(response);
                            },
                            success: function (response) {
                                var data = jQuery.parseJSON(response.value);
                                $scope.result = $scope.result + "<br/>" + "Found " + data['hits']['total'] + " exchanges";
                                var events = [];
                                for (var i = 0; i < data['hits']['hits'].length; i++) {
                                    var e = data['hits']['hits'][i]._source;
                                    events.push(e);
                                }
                                draw(events);
                            }
                        });
                    }
                } });
        };

        var isoDate = function (date) {
            var timestamp, struct, minutesOffset = 0;
            var numericKeys = [1, 4, 5, 6, 7, 10, 11];

            // ES5 §15.9.4.2 states that the string should attempt to be parsed as a Date Time String Format string
            // before falling back to any implementation-specific date parsing, so that’s what we do, even if native
            // implementations could be faster
            //              1 YYYY                2 MM       3 DD           4 HH    5 mm       6 ss        7 msec        8 Z 9 ±    10 tzHH    11 tzmm
            if ((struct = /^(\d{4}|[+\-]\d{6})(?:-(\d{2})(?:-(\d{2}))?)?(?:T(\d{2}):(\d{2})(?::(\d{2})(?:\.(\d{3}))?)?(?:(Z)|([+\-])(\d{2})(?::(\d{2}))?)?)?$/.exec(date))) {
                for (var i = 0, k; (k = numericKeys[i]); ++i) {
                    struct[k] = +struct[k] || 0;
                }

                // allow undefined days and months
                struct[2] = (+struct[2] || 1) - 1;
                struct[3] = +struct[3] || 1;

                if (struct[8] !== 'Z' && struct[9] !== undefined) {
                    minutesOffset = struct[10] * 60 + struct[11];

                    if (struct[9] === '+') {
                        minutesOffset = 0 - minutesOffset;
                    }
                }

                timestamp = Date.UTC(struct[1], struct[2], struct[3], struct[4], struct[5] + minutesOffset, struct[6], struct[7]);
            } else {
                timestamp = Date.parse(date);
            }

            return timestamp;
        };

        var buildSequence = function (events) {
            var sequence = new Camin.Sequence();
            var exchangeToExec = {};

            // Sort events
            events = events.sort(function (a, b) {
                return isoDate(a.timestamp) - isoDate(b.timestamp);
            });

            for (var i = 0; i < events.length; i++) {
                if (events[i].event === 'Created') {
                    var evtCreated = events[i];
                    var evtCompleted = null;
                    for (var j = 0; j < events.length; j++) {
                        if (events[j].event === 'Completed' && evtCreated.exchange.id === events[j].exchange.id) {
                            evtCompleted = events[j];
                            break;
                        }
                    }
                    if (evtCompleted === null) {
                        console.log('Could not find matching Completed exchange for ' + evtCreated.exchange.id);
                        continue;
                    }

                    // We use the completed event here because the created event may miss the routeId information
                    var endpoint = sequence.endpoint(evtCompleted.exchange.fromEndpoint, evtCompleted.exchange.routeId, evtCompleted.exchange.contextId, evtCompleted.host);
                    var exec = sequence.exec(evtCreated.exchange.id, endpoint, isoDate(evtCreated.timestamp), isoDate(evtCompleted.timestamp));
                    exchangeToExec[evtCreated.exchange.id] = exec;
                }
            }

            // Extract calls
            var calls = {};
            for (var i = 0; i < events.length; i++) {
                if (events[i].event === 'Sending' && events[i].exchange.in && events[i].exchange.in.headers) {
                    var callId = events[i].exchange.in.headers.AuditCallId;
                    if (callId && calls[callId] === undefined) {
                        var evtSending = events[i];
                        var evtSent = null;
                        var evtCreated = null;
                        for (var j = 0; j < events.length; j++) {
                            if (events[j].event === 'Sent' && evtSending.exchange.id === events[j].exchange.id && events[j].exchange.in.headers.AuditCallId === callId) {
                                evtSent = events[j];
                                break;
                            }
                        }
                        for (var j = 0; j < events.length; j++) {
                            if (events[j].event === 'Created' && evtSending.exchange.id !== events[j].exchange.id && events[j].exchange.in.headers.AuditCallId === callId) {
                                evtCreated = events[j];
                                break;
                            }
                        }
                        var execA = exchangeToExec[evtSending.exchange.id];
                        var execB = evtCreated ? exchangeToExec[evtCreated.exchange.id] : null;
                        if (evtSent !== null && evtCreated !== null && execA !== null && execB != null) {
                            var call = sequence.call(callId, execA, execB, isoDate(evtSending.timestamp), isoDate(evtSent.timestamp));
                            calls[callId] = call;
                        } else {
                            console.log("Could not find Execution for exchange " + evtSending.exchange.id);
                        }
                    }
                }
            }
            return sequence;
        };

        var buildDiagram = function (sequence) {
            var diagram = new Camin.Diagram();
            var actors = {};
            var signals = [];
            var base = sequence.start();
            for (var i = 0; i < sequence.endpoints.length; i++) {
                var actor = diagram.actor("ep" + i);
                var ep = sequence.endpoints[i];
                var key = ep.url + "|" + ep.routeId + "|" + ep.contextId + "|" + ep.host;
                actors[key] = actor;
            }
            for (var i = 0; i < sequence.calls.length; i++) {
                var call = sequence.calls[i];
                if (call.execB) {
                    var epA = call.execA.endpoint;
                    var keyA = epA.url + "|" + epA.routeId + "|" + epA.contextId + "|" + epA.host;
                    var epB = call.execB.endpoint;
                    var keyB = epB.url + "|" + epB.routeId + "|" + epB.contextId + "|" + epB.host;
                    var actorA = actors[keyA];
                    var actorB = actors[keyB];
                    var start1 = call.start - base;
                    var stop1 = call.execB.start - base;
                    var start2 = call.execB.stop - base;
                    var stop2 = call.stop - base;
                    signals.push({
                        actorA: actorA,
                        actorB: actorB,
                        message: start1 + "ms - " + stop1 + "ms",
                        timestamp: start1 });
                    signals.push({
                        actorA: actorB,
                        actorB: actorA,
                        message: start2 + "ms - " + stop2 + "ms",
                        timestamp: start2 });
                }
            }
            signals = signals.sort(function (a, b) {
                return a.timestamp - b.timestamp;
            });
            for (var i = 0; i < signals.length; i++) {
                diagram.signal(signals[i].actorA, signals[i].actorB, signals[i].message);
            }
            return diagram;
        };

        var buildGantt = function (sequence) {
            var gantt = new Camin.Gantt();
            for (var i = 0; i < sequence.endpoints.length; i++) {
                var endpoint = sequence.endpoints[i];
                var resource = gantt.resource(endpoint);
                for (var j = 0; j < sequence.execs.length; j++) {
                    var exec = sequence.execs[j];
                    if (exec.endpoint === endpoint) {
                        gantt.task(resource, exec.start, exec.stop, exec);
                    }
                }
            }
            for (var i = 0; i < sequence.calls.length; i++) {
                var call = sequence.calls[i];
                if (call.execB) {
                    var taskA = gantt.taskByData(call.execA);
                    var taskB = gantt.taskByData(call.execB);
                    gantt.link(call.start, taskA, call.stop, taskB, call);
                }
            }
            gantt.layout();
            return gantt;
        };

        var eventTypeValue = { "Created": 0, "Sending": 1, "Sent": 2, "Completed": 3 };

        var draw = function (events) {
            $scope.definition = "";

            events = events.sort(function (a, b) {
                return isoDate(a.timestamp) - isoDate(b.timestamp);
            });
            console.log(events);

            var sequence = buildSequence(events);
            console.log(sequence);

            var gantt = buildGantt(sequence);
            console.log(gantt);
            $('#gantt').html('');
            drawGantt('#gantt', gantt);

            var diagram = buildDiagram(sequence);
            console.log(diagram);
            $('#diagram').html('');
            drawDiagram('#diagram', diagram);
        };

        var drawDiagram = function (container, diagram) {
            var arrow_size = 10;
            var margin = 10;
            var actor_width = 100;
            var actor_margin = 30;
            var actor_height = 40;
            var signal_height = 30;
            var actor_font = 20;
            var signal_font = 14;
            var width = diagram.actors.length * (actor_width + actor_margin * 2);
            var height = (diagram.signals.length + 1) * signal_height + actor_height * 2 + margin * 2;

            var svg = d3.select(container).append('svg').attr('width', width + 2 * margin).attr('height', height + 2 * margin);
            var g = svg.append('g').attr('text-anchor', 'middle');
            for (var i = 0; i < diagram.actors.length; i++) {
                var actor = diagram.actors[i];
                var gu = g.append('g').attr('transform', 'translate(' + (i * (actor_width + actor_margin * 2) + actor_margin) + ',' + actor_height + ')');
                gu.append('rect').attr('width', actor_width).attr('height', actor_height).attr('stroke', '#000').attr('stroke-width', '2').attr('fill', '#FFFFFF');
                gu.append('text').attr('x', actor_width / 2).attr('y', actor_height / 2).attr('stroke-width', '0').attr('dominant-baseline', 'middle').attr('font-size', actor_font).text(actor.name);

                g.append('line').attr('x1', i * (actor_width + actor_margin * 2) + actor_width / 2 + actor_margin).attr('y1', actor_height * 2).attr('x2', i * (actor_width + actor_margin * 2) + actor_width / 2 + actor_margin).attr('y2', height - actor_height).attr('stroke', '#000').attr('stroke-width', '2');

                var gu = g.append('g').attr('transform', 'translate(' + (i * (actor_width + actor_margin * 2) + actor_margin) + ',' + (height - actor_height) + ')');
                gu.append('rect').attr('width', actor_width).attr('height', actor_height).attr('stroke', '#000').attr('stroke-width', '2').attr('fill', 'white');
                gu.append('text').attr('x', actor_width / 2).attr('y', actor_height / 2).attr('stroke-width', '0').attr('dominant-baseline', 'middle').attr('font-size', actor_font).text(actor.name);
            }
            for (var i = 0; i < diagram.signals.length; i++) {
                var x;
                var y;
                var length;
                var direction;
                var text;

                x = diagram.signals[i].actorA.index * (actor_width + actor_margin * 2) + actor_width / 2 + actor_margin;
                y = (i + 1) * signal_height + actor_height * 2;
                length = Math.abs(diagram.signals[i].actorA.index - diagram.signals[i].actorB.index) * (actor_width + actor_margin * 2);
                direction = diagram.signals[i].actorB.index > diagram.signals[i].actorA.index ? +1 : -1;
                text = diagram.signals[i].message;

                var gu = g.append('g').attr('transform', 'translate(' + x + ',' + y + ')').attr('stroke-width', '2');
                gu.append('rect').attr('x', Math.min(3, length * direction + 3)).attr('y', '-16').attr('width', Math.abs((length - 6) * direction)).attr('height', '19').attr('stroke', 'white').attr('stroke-width', '0').attr('fill', 'white');
                gu.append('line').attr('x1', 0).attr('y1', 0).attr('x2', length * direction).attr('y2', 0).attr('stroke', '#000').attr('stroke-width', '2');
                gu.append('line').attr('x1', length * direction - arrow_size * direction).attr('y1', -arrow_size).attr('x2', length * direction).attr('y2', 0).attr('stroke', '#000').attr('stroke-width', '2');
                gu.append('line').attr('x1', length * direction).attr('y1', 0).attr('x2', length * direction - arrow_size * direction).attr('y2', arrow_size).attr('stroke', '#000').attr('stroke-width', '2');
                gu.append('text').attr('x', length * direction / 2).attr('y', -8).attr('stroke-width', '0').attr('dominant-baseline', 'middle').attr('font-size', signal_font).text(text);
            }
        };

        var drawGantt = function (container, gantt) {
            var lineHeight = 35;
            var lineMargin = 3;
            var arrowWidth = 4;

            var width = 800;
            var height = lineHeight * gantt.resources.length;
            var margin = {
                top: 20,
                right: 40,
                bottom: 20,
                left: 250
            };

            var begin = gantt.start;
            var end = gantt.stop;

            var x = d3.scale.linear().domain([begin - (end - begin) * 0.1, end + (end - begin) * 0.1]).range([0, width]);
            var yt = function (t) {
                return t.resource.index * lineHeight + lineMargin + t.index * (lineHeight - 2 * lineMargin) / (t.max + 1);
            };
            var ht = function (t) {
                return 2 * (lineHeight - 2 * lineMargin) / (t.max + 1);
            };

            var svg = d3.select(container).append('svg').attr('width', width + margin.left + margin.right).attr('height', height + margin.top + margin.bottom);

            var text = svg.append('g').attr('width', width).attr('height', height).attr('transform', 'translate(0,' + margin.top + ')').selectAll('text').data(gantt.resources).enter();
            text.append('text').attr('x', 0).attr('y', function (r) {
                return r.index * lineHeight + lineHeight / 2;
            }).attr('dy', '-0.2em').attr('text-anchor', 'start').text(function (r) {
                var endpoint = r.data;
                var text = endpoint.url;
                if (text.indexOf("Endpoint[") == 0) {
                    text = text.substring(9, text.length - 1);
                }
                return text;
            });
            text.append('text').attr('x', 0).attr('y', function (r) {
                return r.index * lineHeight + lineHeight / 2;
            }).attr('dy', '0.8em').attr('text-anchor', 'start').text(function (r) {
                var endpoint = r.data;
                return endpoint.host + "/" + endpoint.contextId + "/" + endpoint.routeId;
            });

            var g = svg.append('g').attr('width', width).attr('height', height).attr('transform', 'translate(' + margin.left + ',' + margin.top + ')');

            g.append('g').attr('width', width).attr('height', height).selectAll('rect').data(gantt.tasks).enter().append('rect').attr('rx', lineMargin * 2).attr('ry', lineMargin * 2).attr('x', function (t) {
                return x(t.start);
            }).attr('y', yt).attr('height', ht).attr('width', function (t) {
                return x(t.stop) - x(t.start);
            }).attr('stroke', '#000000').attr('stroke-width', '2').attr('fill', function (t) {
                return d3.hsl(Math.random() * 360, 0.8, 0.8).toString();
            });

            var lines = g.append('g').attr('width', width).attr('height', height).attr('stroke', '#404040').attr('stroke-width', '2').selectAll('line').data(gantt.links).enter();
            lines.append('line').attr('x1', function (l) {
                return x(l.start);
            }).attr('y1', function (l) {
                return yt(l.taskA) + ht(l.taskA);
            }).attr('x2', function (l) {
                return x(l.start);
            }).attr('y2', function (l) {
                return yt(l.taskB) + ht(l.taskB) / 2;
            });
            lines.append('line').attr('x1', function (l) {
                return x(l.start);
            }).attr('y1', function (l) {
                return yt(l.taskB) + ht(l.taskB) / 2;
            }).attr('x2', function (l) {
                return x(l.taskB.start);
            }).attr('y2', function (l) {
                return yt(l.taskB) + ht(l.taskB) / 2;
            });
            lines.append('line').attr('x1', function (l) {
                return x(l.taskB.start);
            }).attr('y1', function (l) {
                return yt(l.taskB) + ht(l.taskB) / 2;
            }).attr('x2', function (l) {
                return x(l.taskB.start) - arrowWidth;
            }).attr('y2', function (l) {
                return yt(l.taskB) + ht(l.taskB) / 2 - arrowWidth;
            });
            lines.append('line').attr('x1', function (l) {
                return x(l.taskB.start);
            }).attr('y1', function (l) {
                return yt(l.taskB) + ht(l.taskB) / 2;
            }).attr('x2', function (l) {
                return x(l.taskB.start) - arrowWidth;
            }).attr('y2', function (l) {
                return yt(l.taskB) + ht(l.taskB) / 2 + arrowWidth;
            });
            lines.append('line').attr('x1', function (l) {
                return x(l.taskB.stop);
            }).attr('y1', function (l) {
                return yt(l.taskB) + ht(l.taskB) / 2;
            }).attr('x2', function (l) {
                return x(l.stop);
            }).attr('y2', function (l) {
                return yt(l.taskB) + ht(l.taskB) / 2;
            });
            lines.append('line').attr('x1', function (l) {
                return x(l.stop);
            }).attr('y1', function (l) {
                return yt(l.taskB) + ht(l.taskB) / 2;
            }).attr('x2', function (l) {
                return x(l.stop);
            }).attr('y2', function (l) {
                return yt(l.taskA) + ht(l.taskA);
            });
            lines.append('line').attr('x1', function (l) {
                return x(l.stop);
            }).attr('y1', function (l) {
                return yt(l.taskA) + ht(l.taskA);
            }).attr('x2', function (l) {
                return x(l.stop) - arrowWidth;
            }).attr('y2', function (l) {
                return yt(l.taskA) + ht(l.taskA) + arrowWidth;
            });
            lines.append('line').attr('x1', function (l) {
                return x(l.stop);
            }).attr('y1', function (l) {
                return yt(l.taskA) + ht(l.taskA);
            }).attr('x2', function (l) {
                return x(l.stop) + arrowWidth;
            }).attr('y2', function (l) {
                return yt(l.taskA) + ht(l.taskA) + arrowWidth;
            });
        };

        if ($routeParams["exchangeId"]) {
            $scope.query = $routeParams["exchangeId"];
            $scope.onQueryChange();
        }
    }
    Camin.Controller = Controller;
})(Camin || (Camin = {}));
var Camin;
(function (Camin) {
    var Diagram = (function () {
        function Diagram() {
            this.actors = [];
            this.signals = [];
        }
        Diagram.prototype.actor = function (name) {
            for (var i = 0; i < this.actors.length; i++) {
                if (this.actors[i].name === name) {
                    return this.actors[i];
                }
            }
            var actor = new Actor(name, this.actors.length);
            this.actors.push(actor);
            return actor;
        };

        Diagram.prototype.signal = function (actorA, actorB, message) {
            var signal = new Signal(actorA, actorB, message);
            this.signals.push(signal);
            return signal;
        };
        return Diagram;
    })();
    Camin.Diagram = Diagram;

    var Actor = (function () {
        function Actor(name, index) {
            this.name = name;
            this.index = index;
        }
        return Actor;
    })();
    Camin.Actor = Actor;

    var Signal = (function () {
        function Signal(actorA, actorB, message) {
            this.actorA = actorA;
            this.actorB = actorB;
            this.message = message;
        }
        Signal.prototype.isSelf = function () {
            return this.actorA.index === this.actorB.index;
        };
        return Signal;
    })();
    Camin.Signal = Signal;
})(Camin || (Camin = {}));
/**
* @module Jetty
*/
var Jetty;
(function (Jetty) {
    function iconClass(state) {
        if (state) {
            switch (state.toString().toLowerCase()) {
                case 'started':
                    return "green icon-play-circle";
                case 'true':
                    return "green icon-play-circle";
            }
        }
        return "orange icon-off";
    }
    Jetty.iconClass = iconClass;

    /**
    * Returns true if the state of the item begins with the given state - or one of the given states
    * @method isState
    * @for Jetty
    * @param {any} item the item which has a State
    * @param {any} state a value or an array of states
    * @return {Boolean}
    */
    function isState(item, state) {
        var value = (item.state || "").toLowerCase();
        if (angular.isArray(state)) {
            return state.any(function (stateText) {
                return value.startsWith(stateText);
            });
        } else {
            return value.startsWith(state);
        }
    }
    Jetty.isState = isState;
})(Jetty || (Jetty = {}));
/**
* @module Jetty
*/
var Jetty;
(function (Jetty) {
    function JettyController($scope, $location, workspace, jolokia) {
        var stateTemplate = '<div class="ngCellText pagination-centered" title="{{row.getProperty(col.field)}}"><i class="{{row.getProperty(col.field) | jettyIconClass}}"></i></div>';

        $scope.uninstallDialog = new UI.Dialog();

        $scope.webapps = [];
        $scope.selected = [];

        var columnDefs = [
            {
                field: 'state',
                displayName: 'State',
                cellTemplate: stateTemplate,
                width: 56,
                minWidth: 56,
                maxWidth: 56,
                resizable: false
            },
            {
                field: 'displayName',
                displayName: 'Name',
                cellFilter: null,
                width: "*",
                resizable: true
            },
            {
                field: 'contextPath',
                displayName: 'Context-Path',
                cellFilter: null,
                width: "*",
                resizable: true
            }
        ];

        $scope.gridOptions = {
            data: 'webapps',
            displayFooter: true,
            selectedItems: $scope.selected,
            columnDefs: columnDefs,
            filterOptions: {
                filterText: ''
            },
            title: "Web applications"
        };

        // function to control the web applications
        $scope.controlWebApps = function (op) {
            // grab id of mbean names to control
            var mbeanNames = $scope.selected.map(function (b) {
                return b.mbean;
            });
            if (!angular.isArray(mbeanNames)) {
                mbeanNames = [mbeanNames];
            }

            // execute operation on each mbean
            var lastIndex = (mbeanNames.length || 1) - 1;
            angular.forEach(mbeanNames, function (mbean, idx) {
                var onResponse = (idx >= lastIndex) ? $scope.onLastResponse : $scope.onResponse;
                jolokia.request({
                    type: 'exec',
                    mbean: mbean,
                    operation: op,
                    arguments: null
                }, onSuccess(onResponse, { error: onResponse }));
            });
        };

        $scope.stop = function () {
            $scope.controlWebApps('stop');
        };

        $scope.start = function () {
            $scope.controlWebApps('start');
        };

        $scope.uninstall = function () {
            $scope.controlWebApps('destroy');
            $scope.uninstallDialog.close();
        };

        $scope.anySelectionHasState = function (state) {
            var selected = $scope.selected || [];
            return selected.length && selected.any(function (s) {
                return Jetty.isState(s, state);
            });
        };

        $scope.everySelectionHasState = function (state) {
            var selected = $scope.selected || [];
            return selected.length && selected.every(function (s) {
                return Jetty.isState(s, state);
            });
        };

        // function to trigger reloading page
        $scope.onLastResponse = function (response) {
            $scope.onResponse(response);

            // we only want to force updating the data on the last response
            loadData();
        };

        $scope.onResponse = function (response) {
            //console.log("got response: " + response);
        };

        $scope.$on('jmxTreeUpdated', reloadFunction);
        $scope.$watch('workspace.tree', reloadFunction);

        // grab server information once
        $scope.jettyServerVersion = "";
        $scope.jettyServerStartupTime = "";

        var servers = jolokia.search("org.eclipse.jetty.server:type=server,*");
        if (servers && servers.length === 1) {
            $scope.jettyServerVersion = jolokia.getAttribute(servers[0], "version");
            $scope.jettyServerStartupTime = jolokia.getAttribute(servers[0], "startupTime");
        } else {
            console.log("Cannot find jetty server or there was more than one server. response is: " + servers);
        }

        function reloadFunction() {
            // if the JMX tree is reloaded its probably because a new MBean has been added or removed
            // so lets reload, asynchronously just in case
            setTimeout(loadData, 50);
        }

        function loadData() {
            console.log("Loading Jetty webapp data...");

            // support embedded jetty which may use morbay mbean names
            jolokia.search("org.mortbay.jetty.plugin:type=jettywebappcontext,*", onSuccess(render));
            jolokia.search("org.eclipse.jetty.webapp:type=webappcontext,*", onSuccess(render));
            jolokia.search("org.eclipse.jetty.servlet:type=servletcontexthandler,*", onSuccess(render));
        }

        function render(response) {
            $scope.webapps = [];
            $scope.mbeanIndex = {};
            $scope.selected.length = 0;

            function onAttributes(response) {
                var obj = response.value;
                if (obj) {
                    obj.mbean = response.request.mbean;
                    if (!obj.state) {
                        // lets leave the state as it is if it is defined
                        obj.state = obj['running'] === undefined || obj['running'] ? "started" : "stopped";
                    }
                    var mbean = obj.mbean;
                    if (mbean) {
                        var idx = $scope.mbeanIndex[mbean];
                        if (angular.isDefined(idx)) {
                            $scope.webapps[mbean] = obj;
                        } else {
                            $scope.mbeanIndex[mbean] = $scope.webapps.length;
                            $scope.webapps.push(obj);
                        }
                        Core.$apply($scope);
                    }
                }
            }

            angular.forEach(response, function (value, key) {
                var mbean = value;
                jolokia.request({ type: "read", mbean: mbean, attribute: [] }, onSuccess(onAttributes));
            });
            Core.$apply($scope);
        }
    }
    Jetty.JettyController = JettyController;
})(Jetty || (Jetty = {}));
/**
* @module Jetty
*/
var Jetty;
(function (Jetty) {
    function ThreadPoolsController($scope, $location, workspace, jolokia) {
        var stateTemplate = '<div class="ngCellText pagination-centered" title="{{row.getProperty(col.field)}}"><i class="{{row.getProperty(col.field) | jettyIconClass}}"></i></div>';

        $scope.threadpools = [];

        var columnDefs = [
            {
                field: 'running',
                displayName: 'State',
                cellTemplate: stateTemplate,
                width: 56,
                minWidth: 56,
                maxWidth: 56,
                resizable: false
            },
            {
                field: 'threads',
                displayName: 'Threads',
                cellFilter: null,
                width: "*",
                resizable: true
            },
            {
                field: 'minThreads',
                displayName: 'Min Threads',
                cellFilter: null,
                width: "*",
                resizable: true
            },
            {
                field: 'maxThreads',
                displayName: 'Max Threads',
                cellFilter: null,
                width: "*",
                resizable: true
            },
            {
                field: 'idleThreads',
                displayName: 'Idle Threads',
                cellFilter: null,
                width: "*",
                resizable: true
            },
            {
                field: 'idleTimeout',
                displayName: 'Idle Timeout (ms)',
                cellFilter: null,
                width: "*",
                resizable: true
            },
            {
                field: 'name',
                displayName: 'Name',
                cellFilter: null,
                width: "*",
                resizable: true
            }
        ];

        $scope.gridOptions = {
            data: 'threadpools',
            displayFooter: true,
            canSelectRows: false,
            columnDefs: columnDefs,
            title: "Thread Pools"
        };

        function render78(response) {
            $scope.threadpools = [];

            function onAttributes(response) {
                var obj = response.value;
                if (obj) {
                    // jetty78 vs jetty9 is a bit different
                    obj.running = obj['running'] !== undefined ? obj['running'] : obj['state'] == "STARTED";
                    obj.idleTimeout = obj['idleTimeout'] !== undefined ? obj['idleTimeout'] : obj['maxIdleTimeMs'];
                    $scope.threadpools.push(obj);
                }
            }

            // create structure for each response
            angular.forEach(response, function (value, key) {
                var mbean = value;
                jolokia.request({ type: "read", mbean: mbean, attribute: [] }, onSuccess(onAttributes));
            });
            Core.$apply($scope);
        }
        ;

        $scope.$on('jmxTreeUpdated', reloadFunction);
        $scope.$watch('workspace.tree', reloadFunction);

        function reloadFunction() {
            // if the JMX tree is reloaded its probably because a new MBean has been added or removed
            // so lets reload, asynchronously just in case
            setTimeout(loadData, 50);
        }

        function loadData() {
            console.log("Loading Jetty thread pool data...");
            var tree = workspace.tree;

            jolokia.search("org.eclipse.jetty.util.thread:type=queuedthreadpool,*", onSuccess(render78));
        }
    }
    Jetty.ThreadPoolsController = ThreadPoolsController;
})(Jetty || (Jetty = {}));
/**
* @module Jetty
* @main Jetty
*/
var Jetty;
(function (Jetty) {
    var pluginName = 'jetty';
    angular.module(pluginName, ['bootstrap', 'ngResource', 'ui.bootstrap.dialog', 'hawtioCore']).config(function ($routeProvider) {
        $routeProvider.when('/jetty/server', { templateUrl: 'app/jetty/html/server.html' }).when('/jetty/applications', { templateUrl: 'app/jetty/html/applications.html' }).when('/jetty/connectors', { templateUrl: 'app/jetty/html/connectors.html' }).when('/jetty/threadpools', { templateUrl: 'app/jetty/html/threadpools.html' });
    }).filter('jettyIconClass', function () {
        return Jetty.iconClass;
    }).run(function ($location, workspace, viewRegistry, helpRegistry) {
        viewRegistry['jetty'] = "app/jetty/html/layoutJettyTabs.html";
        helpRegistry.addUserDoc('jetty', 'app/jetty/doc/help.md', function () {
            return workspace.treeContainsDomainAndProperties("org.eclipse.jetty.server");
        });

        workspace.topLevelTabs.push({
            id: "jetty",
            content: "Jetty",
            title: "Manage your Jetty container",
            isValid: function (workspace) {
                return workspace.treeContainsDomainAndProperties("org.eclipse.jetty.server");
            },
            href: function () {
                return "#/jetty/applications";
            },
            isActive: function (workspace) {
                return workspace.isTopTabActive("jetty");
            }
        });
    });

    hawtioPluginLoader.addModule(pluginName);
})(Jetty || (Jetty = {}));
/**
* @module Jetty
*/
var Jetty;
(function (Jetty) {
    function ConnectorsController($scope, $location, workspace, jolokia) {
        var stateTemplate = '<div class="ngCellText pagination-centered" title="{{row.getProperty(col.field)}}"><i class="{{row.getProperty(col.field) | jettyIconClass}}"></i></div>';

        $scope.connectors = [];
        $scope.selected = [];

        var columnDefs = [
            {
                field: 'running',
                displayName: 'State',
                cellTemplate: stateTemplate,
                width: 56,
                minWidth: 56,
                maxWidth: 56,
                resizable: false
            },
            {
                field: 'port',
                displayName: 'Port',
                cellFilter: null,
                width: "*",
                resizable: true
            },
            {
                field: 'protocols',
                displayName: 'Protocols',
                cellFilter: null,
                width: "*",
                resizable: true
            },
            {
                field: 'default',
                displayName: 'Default',
                cellFilter: null,
                width: "*",
                resizable: true
            }
        ];

        $scope.gridOptions = {
            data: 'connectors',
            displayFooter: true,
            selectedItems: $scope.selected,
            columnDefs: columnDefs,
            filterOptions: {
                filterText: ''
            },
            title: "Connectors"
        };

        // function to control the connectors
        $scope.controlConnectors = function (op) {
            // grab id of mbean names to control
            var mbeanNames = $scope.selected.map(function (b) {
                return b.mbean;
            });
            if (!angular.isArray(mbeanNames)) {
                mbeanNames = [mbeanNames];
            }

            // execute operation on each mbean
            var lastIndex = (mbeanNames.length || 1) - 1;
            angular.forEach(mbeanNames, function (mbean, idx) {
                var onResponse = (idx >= lastIndex) ? $scope.onLastResponse : $scope.onResponse;
                jolokia.request({
                    type: 'exec',
                    mbean: mbean,
                    operation: op,
                    arguments: null
                }, onSuccess(onResponse, { error: onResponse }));
            });
        };

        $scope.stop = function () {
            $scope.controlConnectors('stop');
        };

        $scope.start = function () {
            $scope.controlConnectors('start');
        };

        $scope.anySelectionIsRunning = function () {
            var selected = $scope.selected || [];
            return selected.length && selected.any(function (s) {
                return s.running;
            });
        };

        $scope.everySelectionIsRunning = function (state) {
            var selected = $scope.selected || [];
            return selected.length && selected.every(function (s) {
                return s.running;
            });
        };

        function render78(response) {
            $scope.connectors = [];
            $scope.selected.length = 0;

            function onAttributes(response) {
                var obj = response.value;
                if (obj) {
                    // split each into 2 rows as we want http and https on each row
                    obj.mbean = response.request.mbean;
                    obj.protocols = "[http]";
                    obj.default = "http";
                    obj.port = obj.port;
                    obj.running = obj['running'] !== undefined ? obj['running'] : true;
                    $scope.connectors.push(obj);
                    if (obj.confidentialPort) {
                        // create a clone of obj for https
                        var copyObj = {
                            protocols: "[https]",
                            default: "https",
                            port: obj.confidentialPort,
                            running: obj.running,
                            mbean: obj.mbean
                        };
                        $scope.connectors.push(copyObj);
                    }
                    Core.$apply($scope);
                }
            }

            // create structure for each response
            angular.forEach(response, function (value, key) {
                var mbean = value;
                jolokia.request({ type: "read", mbean: mbean, attribute: [] }, onSuccess(onAttributes));
            });
            Core.$apply($scope);
        }
        ;

        function render9(response) {
            $scope.connectors = [];
            $scope.selected.length = 0;

            function onAttributes(response) {
                var obj = response.value;
                if (obj) {
                    obj.mbean = response.request.mbean;
                    obj.protocols = obj['protocols'];
                    obj.default = obj['defaultProtocol'];
                    obj.port = obj.port;
                    obj.running = obj['state'] == "STARTED";
                    $scope.connectors.push(obj);
                    Core.$apply($scope);
                }
            }

            // create structure for each response
            angular.forEach(response, function (value, key) {
                var mbean = value;
                jolokia.request({ type: "read", mbean: mbean, attribute: [] }, onSuccess(onAttributes));
            });
            Core.$apply($scope);
        }
        ;

        // function to trigger reloading page
        $scope.onLastResponse = function (response) {
            $scope.onResponse(response);

            // we only want to force updating the data on the last response
            loadData();
        };

        $scope.onResponse = function (response) {
            //console.log("got response: " + response);
        };

        $scope.$on('jmxTreeUpdated', reloadFunction);
        $scope.$watch('workspace.tree', reloadFunction);

        function reloadFunction() {
            // if the JMX tree is reloaded its probably because a new MBean has been added or removed
            // so lets reload, asynchronously just in case
            setTimeout(loadData, 50);
        }

        function loadData() {
            console.log("Loading Jetty connector data...");
            var tree = workspace.tree;

            jolokia.search("org.eclipse.jetty.server.nio:type=selectchannelconnector,*", onSuccess(render78));
            jolokia.search("org.eclipse.jetty.server:type=serverconnector,*", onSuccess(render9));
        }
    }
    Jetty.ConnectorsController = ConnectorsController;
})(Jetty || (Jetty = {}));
/**
* @module Maven
*/
var Maven;
(function (Maven) {
    function PomXmlController($scope) {
        $scope.mavenPomXml = "\n" + "  <dependency>\n" + "    <groupId>" + orBlank($scope.row.groupId) + "</groupId>\n" + "    <artifactId>" + orBlank($scope.row.artifactId) + "</artifactId>\n" + "    <version>" + orBlank($scope.row.version) + "</version>\n" + "  </dependency>\n";

        function orBlank(text) {
            return text || "";
        }
    }
    Maven.PomXmlController = PomXmlController;
})(Maven || (Maven = {}));
/**
* @module Maven
*/
var Maven;
(function (Maven) {
    function ViewController($scope, $location, workspace, jolokia) {
        $scope.$watch('workspace.tree', function () {
            // if the JMX tree is reloaded its probably because a new MBean has been added or removed
            // so lets reload, asynchronously just in case
            setTimeout(loadData, 50);
        });

        $scope.$on("$routeChangeSuccess", function (event, current, previous) {
            setTimeout(loadData, 50);
        });

        function loadData() {
        }
    }
    Maven.ViewController = ViewController;
})(Maven || (Maven = {}));
/**
* @module Maven
*/
var Maven;
(function (Maven) {
    function DependenciesController($scope, $routeParams, $location, workspace, jolokia) {
        $scope.artifacts = [];
        $scope.group = $routeParams["group"] || "";
        $scope.artifact = $routeParams["artifact"] || "";
        $scope.version = $routeParams["version"] || "";
        $scope.classifier = $routeParams["classifier"] || "";
        $scope.packaging = $routeParams["packaging"] || "";

        $scope.dependencyTree = null;

        Maven.addMavenFunctions($scope, workspace);

        $scope.$on("$routeChangeSuccess", function (event, current, previous) {
            // lets do this asynchronously to avoid Error: $digest already in progress
            setTimeout(updateTableContents, 50);
        });

        $scope.$watch('workspace.selection', function () {
            updateTableContents();
        });

        $scope.onSelectNode = function (node) {
            $scope.selected = node;
        };

        $scope.onRootNode = function (rootNode) {
            // process the rootNode
        };

        $scope.validSelection = function () {
            return $scope.selected && $scope.selected !== $scope.rootDependency;
        };

        $scope.viewDetails = function () {
            var dependency = Core.pathGet($scope.selected, ["dependency"]);
            var link = $scope.detailLink(dependency);
            if (link) {
                var path = Core.trimLeading(link, "#");
                console.log("going to view " + path);
                $location.path(path);
            }
        };

        function updateTableContents() {
            var mbean = Maven.getAetherMBean(workspace);
            if (mbean) {
                jolokia.execute(mbean, "resolveJson(java.lang.String,java.lang.String,java.lang.String,java.lang.String,java.lang.String)", $scope.group, $scope.artifact, $scope.version, $scope.packaging, $scope.classifier, onSuccess(render));
            } else {
                console.log("No AetherMBean!");
            }
        }

        function render(response) {
            if (response) {
                var json = JSON.parse(response);
                if (json) {
                    //console.log("Found json: " + JSON.stringify(json, null, "  "));
                    $scope.dependencyTree = new Folder("Dependencies");
                    $scope.dependencyActivations = [];
                    addChildren($scope.dependencyTree, json);
                    $scope.dependencyActivations.reverse();
                    $scope.rootDependency = $scope.dependencyTree.children[0];
                }
            }
            Core.$apply($scope);
        }

        function addChildren(folder, dependency) {
            var name = Maven.getName(dependency);
            var node = new Folder(name);
            node.key = name.replace(/\//g, '_');
            node["dependency"] = dependency;
            $scope.dependencyActivations.push(node.key);

            /*
            var imageUrl = Camel.getRouteNodeIcon(value);
            node.icon = imageUrl;
            //node.tooltip = tooltip;
            */
            folder.children.push(node);

            var children = dependency["children"];
            angular.forEach(children, function (child) {
                addChildren(node, child);
            });
        }
    }
    Maven.DependenciesController = DependenciesController;
})(Maven || (Maven = {}));
/**
* @module Maven
*/
var Maven;
(function (Maven) {
    function ArtifactController($scope, $routeParams, workspace, jolokia) {
        $scope.row = {
            groupId: $routeParams["group"] || "",
            artifactId: $routeParams["artifact"] || "",
            version: $routeParams["version"] || "",
            classifier: $routeParams["classifier"] || "",
            packaging: $routeParams["packaging"] || ""
        };
        var row = $scope.row;

        $scope.id = Maven.getName(row);

        Maven.addMavenFunctions($scope, workspace);

        $scope.$on("$routeChangeSuccess", function (event, current, previous) {
            // lets do this asynchronously to avoid Error: $digest already in progress
            setTimeout(updateTableContents, 50);
        });

        $scope.$watch('workspace.selection', function () {
            updateTableContents();
        });

        function updateTableContents() {
            var mbean = Maven.getMavenIndexerMBean(workspace);

            // lets query the name and description of the GAV
            if (mbean) {
                jolokia.execute(mbean, "search", row.groupId, row.artifactId, row.version, row.packaging, row.classifier, "", onSuccess(render));
            } else {
                console.log("No MavenIndexerMBean!");
            }
        }

        function render(response) {
            if (response && response.length) {
                var first = response[0];
                row.name = first.name;
                row.description = first.description;
            }
            Core.$apply($scope);
        }
    }
    Maven.ArtifactController = ArtifactController;
})(Maven || (Maven = {}));
/**
* @module Maven
* @main Maven
*/
var Maven;
(function (Maven) {
    var pluginName = 'maven';
    angular.module(pluginName, ['bootstrap', 'ngResource', 'datatable', 'tree', 'hawtioCore', 'hawtio-ui']).config(function ($routeProvider) {
        $routeProvider.when('/maven/search', { templateUrl: 'app/maven/html/search.html' }).when('/maven/advancedSearch', { templateUrl: 'app/maven/html/advancedSearch.html' }).when('/maven/artifact/:group/:artifact/:version/:classifier/:packaging', { templateUrl: 'app/maven/html/artifact.html' }).when('/maven/artifact/:group/:artifact/:version/:classifier', { templateUrl: 'app/maven/html/artifact.html' }).when('/maven/artifact/:group/:artifact/:version', { templateUrl: 'app/maven/html/artifact.html' }).when('/maven/dependencies/:group/:artifact/:version/:classifier/:packaging', { templateUrl: 'app/maven/html/dependencies.html' }).when('/maven/dependencies/:group/:artifact/:version/:classifier', { templateUrl: 'app/maven/html/dependencies.html' }).when('/maven/dependencies/:group/:artifact/:version', { templateUrl: 'app/maven/html/dependencies.html' }).when('/maven/versions/:group/:artifact/:classifier/:packaging', { templateUrl: 'app/maven/html/versions.html' }).when('/maven/view/:group/:artifact/:version/:classifier/:packaging', { templateUrl: 'app/maven/html/view.html' }).when('/maven/test', { templateUrl: 'app/maven/html/test.html' });
    }).run(function ($location, workspace, viewRegistry, helpRegistry) {
        viewRegistry['maven'] = "app/maven/html/layoutMaven.html";

        workspace.topLevelTabs.push({
            id: "maven",
            content: "Maven",
            title: "Search maven repositories for artifacts",
            isValid: function (workspace) {
                return Maven.getMavenIndexerMBean(workspace);
            },
            href: function () {
                return "#/maven/search";
            },
            isActive: function (workspace) {
                return workspace.isLinkActive("/maven");
            }
        });

        helpRegistry.addUserDoc('maven', 'app/maven/doc/help.md', function () {
            return Maven.getMavenIndexerMBean(workspace) !== null;
        });
        helpRegistry.addDevDoc("maven", 'app/maven/doc/developer.md');
    });

    hawtioPluginLoader.addModule(pluginName);
})(Maven || (Maven = {}));
/**
* @module Maven
*/
var Maven;
(function (Maven) {
    Maven.log = Logger.get("Maven");

    /**
    * Returns the maven indexer mbean (from the hawtio-maven-indexer library)
    * @method getMavenIndexerMBean
    * @for Maven
    * @param {Core.Workspace} workspace
    * @return {String}
    */
    function getMavenIndexerMBean(workspace) {
        if (workspace) {
            var mavenStuff = workspace.mbeanTypesToDomain["Indexer"] || {};
            var object = mavenStuff["hawtio"] || {};
            return object.objectName;
        } else
            return null;
    }
    Maven.getMavenIndexerMBean = getMavenIndexerMBean;

    function getAetherMBean(workspace) {
        if (workspace) {
            var mavenStuff = workspace.mbeanTypesToDomain["AetherFacade"] || {};
            var object = mavenStuff["hawtio"] || {};
            return object.objectName;
        } else
            return null;
    }
    Maven.getAetherMBean = getAetherMBean;

    function mavenLink(url) {
        var path = null;
        if (url) {
            if (url.startsWith("mvn:")) {
                path = url.substring(4);
            } else {
                var idx = url.indexOf(":mvn:");
                if (idx > 0) {
                    path = url.substring(idx + 5);
                }
            }
        }
        return path ? "#/maven/artifact/" + path : null;
    }
    Maven.mavenLink = mavenLink;

    function getName(row) {
        var id = (row.group || row.groupId) + "/" + (row.artifact || row.artifactId);
        if (row.version) {
            id += "/" + row.version;
        }
        if (row.classifier) {
            id += "/" + row.classifier;
        }
        if (row.packaging) {
            id += "/" + row.packaging;
        }
        return id;
    }
    Maven.getName = getName;

    function completeMavenUri($q, $scope, workspace, jolokia, query) {
        var mbean = getMavenIndexerMBean(workspace);
        if (!angular.isDefined(mbean)) {
            return $q.when([]);
        }

        var parts = query.split('/');
        if (parts.length === 1) {
            // still searching the groupId
            return Maven.completeGroupId(mbean, $q, $scope, workspace, jolokia, query, null, null);
        }
        if (parts.length === 2) {
            // have the groupId, guess we're looking for the artifactId
            return Maven.completeArtifactId(mbean, $q, $scope, workspace, jolokia, parts[0], parts[1], null, null);
        }
        if (parts.length === 3) {
            // guess we're searching for the version
            return Maven.completeVersion(mbean, $q, $scope, workspace, jolokia, parts[0], parts[1], parts[2], null, null);
        }

        return $q.when([]);
    }
    Maven.completeMavenUri = completeMavenUri;

    function completeVersion(mbean, $q, $scope, workspace, jolokia, groupId, artifactId, partial, packaging, classifier) {
        /*
        if (partial.length < 5) {
        return $q.when([]);
        }
        */
        var deferred = $q.defer();

        jolokia.request({
            type: 'exec',
            mbean: mbean,
            operation: 'versionComplete(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)',
            arguments: [groupId, artifactId, partial, packaging, classifier]
        }, {
            method: 'POST',
            success: function (response) {
                $scope.$apply(function () {
                    deferred.resolve(response.value.sortBy().first(15));
                });
            },
            error: function (response) {
                $scope.$apply(function () {
                    console.log("got back an error: ", response);
                    deferred.reject();
                });
            }
        });

        return deferred.promise;
    }
    Maven.completeVersion = completeVersion;

    function completeArtifactId(mbean, $q, $scope, workspace, jolokia, groupId, partial, packaging, classifier) {
        var deferred = $q.defer();

        jolokia.request({
            type: 'exec',
            mbean: mbean,
            operation: 'artifactIdComplete(java.lang.String, java.lang.String, java.lang.String, java.lang.String)',
            arguments: [groupId, partial, packaging, classifier]
        }, {
            method: 'POST',
            success: function (response) {
                $scope.$apply(function () {
                    deferred.resolve(response.value.sortBy().first(15));
                });
            },
            error: function (response) {
                $scope.$apply(function () {
                    console.log("got back an error: ", response);
                    deferred.reject();
                });
            }
        });

        return deferred.promise;
    }
    Maven.completeArtifactId = completeArtifactId;

    function completeGroupId(mbean, $q, $scope, workspace, jolokia, partial, packaging, classifier) {
        // let's go easy on the indexer
        if (partial.length < 5) {
            return $q.when([]);
        }

        var deferred = $q.defer();

        jolokia.request({
            type: 'exec',
            mbean: mbean,
            operation: 'groupIdComplete(java.lang.String, java.lang.String, java.lang.String)',
            arguments: [partial, packaging, classifier]
        }, {
            method: 'POST',
            success: function (response) {
                $scope.$apply(function () {
                    deferred.resolve(response.value.sortBy().first(15));
                });
            },
            error: function (response) {
                console.log("got back an error: ", response);
                $scope.$apply(function () {
                    deferred.reject();
                });
            }
        });

        return deferred.promise;
    }
    Maven.completeGroupId = completeGroupId;

    function addMavenFunctions($scope, workspace) {
        $scope.detailLink = function (row) {
            var group = row.groupId;
            var artifact = row.artifactId;
            var version = row.version || "";
            var classifier = row.classifier || "";
            var packaging = row.packaging || "";
            if (group && artifact) {
                return "#/maven/artifact/" + group + "/" + artifact + "/" + version + "/" + classifier + "/" + packaging;
            }
            return "";
        };

        $scope.javadocLink = function (row) {
            var group = row.groupId;
            var artifact = row.artifactId;
            var version = row.version;
            if (group && artifact && version) {
                return "javadoc/" + group + ":" + artifact + ":" + version + "/";
            }
            return "";
        };

        $scope.versionsLink = function (row) {
            var group = row.groupId;
            var artifact = row.artifactId;
            var classifier = row.classifier || "";
            var packaging = row.packaging || "";
            if (group && artifact) {
                return "#/maven/versions/" + group + "/" + artifact + "/" + classifier + "/" + packaging;
            }
            return "";
        };

        $scope.dependenciesLink = function (row) {
            var group = row.groupId;
            var artifact = row.artifactId;
            var classifier = row.classifier || "";
            var packaging = row.packaging || "";
            var version = row.version;
            if (group && artifact) {
                return "#/maven/dependencies/" + group + "/" + artifact + "/" + version + "/" + classifier + "/" + packaging;
            }
            return "";
        };

        $scope.hasDependencyMBean = function () {
            var mbean = Maven.getAetherMBean(workspace);
            return angular.isDefined(mbean);
        };

        $scope.sourceLink = function (row) {
            var group = row.groupId;
            var artifact = row.artifactId;
            var version = row.version;
            if (group && artifact && version) {
                return "#/source/index/" + group + ":" + artifact + ":" + version + "/";
            }
            return "";
        };
    }
    Maven.addMavenFunctions = addMavenFunctions;
})(Maven || (Maven = {}));
/**
* @module Maven
*/
var Maven;
(function (Maven) {
    function VersionsController($scope, $routeParams, workspace, jolokia) {
        $scope.artifacts = [];
        $scope.group = $routeParams["group"] || "";
        $scope.artifact = $routeParams["artifact"] || "";
        $scope.version = "";
        $scope.classifier = $routeParams["classifier"] || "";
        $scope.packaging = $routeParams["packaging"] || "";

        var id = $scope.group + "/" + $scope.artifact;
        if ($scope.classifier) {
            id += "/" + $scope.classifier;
        }
        if ($scope.packaging) {
            id += "/" + $scope.packaging;
        }
        var columnTitle = id + " versions";

        var columnDefs = [
            {
                field: 'versionNumber',
                displayName: columnTitle,
                cellTemplate: '<div class="ngCellText"><a href="#/maven/artifact/{{row.entity.groupId}}/{{row.entity.artifactId}}/{{row.entity.version}}">{{row.entity.version}}</a></div>'
            }
        ];

        $scope.gridOptions = {
            data: 'artifacts',
            displayFooter: true,
            selectedItems: $scope.selected,
            selectWithCheckboxOnly: true,
            columnDefs: columnDefs,
            rowDetailTemplateId: "artifactDetailTemplate",
            sortInfo: { field: 'versionNumber', direction: 'DESC' },
            filterOptions: {
                filterText: 'search'
            }
        };

        Maven.addMavenFunctions($scope, workspace);

        $scope.$on("$routeChangeSuccess", function (event, current, previous) {
            // lets do this asynchronously to avoid Error: $digest already in progress
            setTimeout(updateTableContents, 50);
        });

        $scope.$watch('workspace.selection', function () {
            updateTableContents();
        });

        function updateTableContents() {
            var mbean = Maven.getMavenIndexerMBean(workspace);
            if (mbean) {
                jolokia.execute(mbean, "versionComplete", $scope.group, $scope.artifact, $scope.version, $scope.packaging, $scope.classifier, onSuccess(render));
            } else {
                console.log("No MavenIndexerMBean!");
            }
        }

        function render(response) {
            $scope.artifacts = [];
            angular.forEach(response, function (version) {
                var versionNumberArray = Core.parseVersionNumbers(version);
                var versionNumber = 0;
                for (var i = 0; i <= 4; i++) {
                    var num = (i >= versionNumberArray.length) ? 0 : versionNumberArray[i];
                    versionNumber *= 1000;
                    versionNumber += num;
                }

                $scope.artifacts.push({
                    groupId: $scope.group,
                    artifactId: $scope.artifact,
                    packaging: $scope.packaging,
                    classifier: $scope.classifier,
                    version: version,
                    versionNumber: versionNumber
                });
            });
            Core.$apply($scope);
        }
    }
    Maven.VersionsController = VersionsController;
})(Maven || (Maven = {}));
/**
* @module Maven
*/
var Maven;
(function (Maven) {
    function TestController($scope, workspace, jolokia, $q, $templateCache) {
        $scope.html = "text/html";

        $scope.someUri = '';
        $scope.uriParts = [];
        $scope.mavenCompletion = $templateCache.get("mavenCompletionTemplate");

        $scope.$watch('someUri', function (newValue, oldValue) {
            if (newValue !== oldValue) {
                $scope.uriParts = newValue.split("/");
            }
        });

        $scope.$watch('uriParts', function (newValue, oldValue) {
            if (newValue !== oldValue) {
                if (newValue.length === 1 && newValue.length < oldValue.length) {
                    if (oldValue.last() !== '' && newValue.first().has(oldValue.last())) {
                        var merged = oldValue.first(oldValue.length - 1).include(newValue.first());
                        $scope.someUri = merged.join('/');
                    }
                }
            }
        }, true);

        $scope.doCompletionMaven = function (something) {
            return Maven.completeMavenUri($q, $scope, workspace, jolokia, something);
        };
    }
    Maven.TestController = TestController;
})(Maven || (Maven = {}));
/**
* @module Maven
*/
var Maven;
(function (Maven) {
    function SearchController($scope, $location, workspace, jolokia) {
        var log = Logger.get("Maven");

        $scope.artifacts = [];
        $scope.selected = [];
        $scope.done = false;
        $scope.inProgress = false;
        $scope.form = {
            searchText: ""
        };
        $scope.search = "";
        $scope.searchForm = 'app/maven/html/searchForm.html';

        Maven.addMavenFunctions($scope, workspace);

        var columnDefs = [
            {
                field: 'groupId',
                displayName: 'Group'
            },
            {
                field: 'artifactId',
                displayName: 'Artifact',
                cellTemplate: '<div class="ngCellText" title="Name: {{row.entity.name}}">{{row.entity.artifactId}}</div>'
            },
            {
                field: 'version',
                displayName: 'Version',
                cellTemplate: '<div class="ngCellText" title="Name: {{row.entity.name}}"><a ng-href="{{detailLink(row.entity)}}">{{row.entity.version}}</a</div>'
            }
        ];

        $scope.gridOptions = {
            data: 'artifacts',
            displayFooter: true,
            selectedItems: $scope.selected,
            selectWithCheckboxOnly: true,
            columnDefs: columnDefs,
            rowDetailTemplateId: "artifactDetailTemplate",
            filterOptions: {
                filterText: 'search'
            }
        };

        $scope.hasAdvancedSearch = function (form) {
            return form.searchGroup || form.searchArtifact || form.searchVersion || form.searchPackaging || form.searchClassifier || form.searchClassName;
        };

        $scope.doSearch = function () {
            $scope.done = false;
            $scope.inProgress = true;
            $scope.artifacts = [];

            // ensure ui is updated with search in progress...
            setTimeout(function () {
                Core.$apply($scope);
            }, 50);

            var mbean = Maven.getMavenIndexerMBean(workspace);
            var form = $scope.form;
            if (mbean) {
                var searchText = form.searchText;
                var kind = form.artifactType;
                if (kind) {
                    if (kind === "className") {
                        log.debug("Search for: " + form.searchText + " className");
                        jolokia.execute(mbean, "searchClasses", searchText, onSuccess(render));
                    } else {
                        var paths = kind.split('/');
                        var packaging = paths[0];
                        var classifier = paths[1];
                        log.debug("Search for: " + form.searchText + " packaging " + packaging + " classifier " + classifier);
                        jolokia.execute(mbean, "searchTextAndPackaging", searchText, packaging, classifier, onSuccess(render));
                    }
                } else if (searchText) {
                    log.debug("Search text is: " + form.searchText);
                    jolokia.execute(mbean, "searchText", form.searchText, onSuccess(render));
                } else if ($scope.hasAdvancedSearch(form)) {
                    log.debug("Searching for " + form.searchGroup + "/" + form.searchArtifact + "/" + form.searchVersion + "/" + form.searchPackaging + "/" + form.searchClassifier + "/" + form.searchClassName);

                    jolokia.execute(mbean, "search", form.searchGroup || "", form.searchArtifact || "", form.searchVersion || "", form.searchPackaging || "", form.searchClassifier || "", form.searchClassName || "", onSuccess(render));
                }
            } else {
                notification("error", "Cannot find the Maven Indexer MBean!");
            }
        };

        // cap ui table at one thousand
        var RESPONSE_LIMIT = 1000;
        var SERVER_RESPONSE_LIMIT = (10 * RESPONSE_LIMIT) + 1;

        function render(response) {
            log.debug("Search done, preparing result.");
            $scope.done = true;
            $scope.inProgress = false;

            // let's limit the reponse to avoid blowing up
            // the browser until we start using a widget
            // that supports pagination
            if (response.length > RESPONSE_LIMIT) {
                var serverLimit = response.length === SERVER_RESPONSE_LIMIT;
                if (serverLimit) {
                    $scope.tooManyResponses = "This search returned more than " + (SERVER_RESPONSE_LIMIT - 1) + " artifacts, showing the first " + RESPONSE_LIMIT + ", please refine your search";
                } else {
                    $scope.tooManyResponses = "This search returned " + response.length + " artifacts, showing the first " + RESPONSE_LIMIT + ", please refine your search";
                }
            } else {
                $scope.tooManyResponses = "";
            }
            $scope.artifacts = response.first(RESPONSE_LIMIT);

            Core.$apply($scope);
        }
    }
    Maven.SearchController = SearchController;
})(Maven || (Maven = {}));
/**
* @module ElasticSearch
* @main ElasticSearch
*/
var ES;
(function (ES) {
    var pluginName = 'elasticsearch';
    var base_url = 'app/elasticsearch/html';

    /* Application level module which depends on filters, controllers, and services */
    angular.module(pluginName, ['bootstrap', 'ngResource', 'elasticjs.service', 'dangle']).config([
        '$routeProvider', function ($routeProvider) {
            $routeProvider.when('/elasticsearch', { templateUrl: base_url + '/es.html' });
        }]).run(function ($location, workspace, viewRegistry, helpRegistry) {
        // Use Full Layout of Hawtio
        viewRegistry[pluginName] = 'app/elasticsearch/html/es.html';

        helpRegistry.addUserDoc(pluginName, 'app/elasticsearch/doc/help.md', function () {
            // TODO not sure how this plugin actually shows up in the toolbar
            return false;
        });
        /*
        // Set up top-level link to our plugin
        workspace.topLevelTabs.push({
        content: "ElasticSearch",
        title: "ElasticSearch",
        isValid: (workspace) => true,
        href: () => '#/elasticsearch',
        isActive: (workspace:Workspace) => workspace.isLinkActive("elasticsearch")
        });
        */
    });

    hawtioPluginLoader.addModule(pluginName);
})(ES || (ES = {}));
var ES;
(function (ES) {
    // Function to test if a property is empty, not null
    function isEmptyObject(value) {
        return $.isEmptyObject(value);
    }
    ES.isEmptyObject = isEmptyObject;

    // Search Angular Controller used by ES
    function SearchCtrl($scope, $location, $log, ejsResource) {
        // Retrieve by default parameters from config.js
        //var defaultEsServer = $scope.defaultEsServer = "http://localhost:9200";
        var esServer = $scope.esServer = ES.config["elasticsearch"];
        var query = $scope.queryTerm = ES.config["query"];
        var facetField = $scope.facetField = "tags";
        var facetType = $scope.facetType = "terms";
        var index = $scope.indice = ES.config["indice"];
        var type = $scope.docType = ES.config["doctype"];
        var ejs;
        var request;
        $scope.log = $log;

        /* Define search function that will be called when a user
        submits a Query String search
        Query syntax : *
        Query syntax : field: 'value'
        Query syntax : field: 'value' AND field: 'value'
        Query syntax : field: 'value' OR field: 'value'
        where value corresponds to text to search ortext + * symbol
        */
        $scope.search = function () {
            if (isEmptyObject(ejs)) {
                console.log("Init EJS server");
                ejs = initElasticsearchServer(esServer);
            }

            // Initialize ES Server to send request
            setupEsRequest();

            // Setup Query String
            request = request.query(ejs.QueryStringQuery(query));

            // Run query
            var results = request.doSearch();

            console.log("Do Elastic Search");

            results.then(function (results) {
                //$location.path("/elasticjs");
                // Reset field after search
                $scope.queryTerm = "";

                if (typeof results.error != 'undefined') {
                    // Message should be displayed in the web page as a modal window
                    console.error("ES error : " + results.error);

                    // Solution proposed by kibana3
                    // $scope.panel.error = $scope.parse_error(results.error);
                    return;
                }

                console.log(results.hits.total + " : results retrieved");
                $scope.results = results;
            });
        };

        $scope.facetTermsSearch = function () {
            if (isEmptyObject(ejs)) {
                console.log("Init EJS server");
                ejs = initElasticsearchServer(esServer);
            }

            // Initialize ES Server to send request
            setupEsRequest();

            if (!isEmptyObject($scope.facetField)) {
                facetField = $scope.facetField;
            }

            if (!isEmptyObject($scope.facetType)) {
                facetType = $scope.facetType;
            }

            // Setup QueryString and Facets
            request = request.query(ejs.QueryStringQuery(query)).facet(ejs.TermsFacet("termFacet").field(facetField).size(50));

            // Run query
            var results = request.doSearch();

            console.log("Do Elastic Search");

            results.then(function (results) {
                //$location.path("/elasticjs");
                // Reset field after search
                $scope.queryTerm = "";

                if (typeof results.error != 'undefined') {
                    // Message should be displayed in the web page as a modal window
                    console.error("ES error : " + results.error);

                    // Solution proposed by kibana3
                    // $scope.panel.error = $scope.parse_error(results.error);
                    return;
                }

                console.log(results.hits.total + " : results retrieved");
                $scope.results = results;
            });
        };

        $scope.facetDateHistogramSearch = function () {
            if (isEmptyObject(ejs)) {
                console.log("Init EJS server");
                ejs = initElasticsearchServer(esServer);
            }

            // Initialize ES Server to send request
            setupEsRequest();

            if (!isEmptyObject($scope.facetField)) {
                facetField = $scope.facetField;
            }

            if (!isEmptyObject($scope.facetType)) {
                facetType = $scope.facetType;
            }

            // Setup QueryString and Facets
            request = request.query(ejs.QueryStringQuery(query)).facet(ejs.DateHistogramFacet("dateHistoFacet").field(facetField).interval("minute"));

            // Run query
            var results = request.doSearch();

            console.log("Do Elastic Search");

            results.then(function (results) {
                //$location.path("/elasticjs");
                // Reset field after search
                $scope.queryTerm = "";

                if (typeof results.error != 'undefined') {
                    // Message should be displayed in the web page as a modal window
                    console.error("ES error : " + results.error);

                    // Solution proposed by kibana3
                    // $scope.panel.error = $scope.parse_error(results.error);
                    return;
                }

                console.log(results.hits.total + " : results retrieved");
                $scope.results = results;
            });
        };

        // index the sample documents using data
        // coming from json file
        $scope.indexSampleDocs = function () {
            var host = "http://" + location.host;

            if (isEmptyObject(ejs)) {
                console.log("EJS object is not defined - create it - setupEsRequest");
                ejs = initElasticsearchServer(esServer);
            }

            // Load json records from JSON file
            // & create elastcsearch document
            var docs = [];
            $.getJSON(host + "/hawtio/app/elasticsearch/js/data.json", function (result) {
                $.each(result, function (i, field) {
                    console.log("Field : " + field);
                    docs[i] = ejs.Document(index, type, i).source(field);
                    docs[i].refresh(true).doIndex();
                });
            });
            // Using sugarjs & ECMA5 forEach
            /*
            var doSearch = ( $scope.search ).after(docs.length);
            docs.forEach(function (doc) {
            console.log("Do Index called");
            doc.refresh(true).doIndex(doSearch);
            });
            */
        };

        function setupEsRequest() {
            console.log("ES Server = " + $scope.esServer);
            console.log("Indice = " + $scope.indice);
            console.log("Type = " + $scope.docType);
            console.log("Query = " + $scope.queryTerm);

            if (!isEmptyObject($scope.indice)) {
                index = $scope.indice;
            }

            if (!isEmptyObject($scope.esServer)) {
                esServer = $scope.esServer;
            }

            if (!isEmptyObject($scope.docType)) {
                type = $scope.docType;
            }

            if (!isEmptyObject($scope.queryTerm)) {
                query = $scope.queryTerm;
            }

            var ejs = ejsResource($scope.esServer);

            // Define Request to call ES
            request = ejs.Request().indices(index).types(type);

            console.log("Request to call ElasticSearch defined");
        }

        function initElasticsearchServer(esServer) {
            return ejsResource(esServer);
        }

        $scope.parse_error = function (data) {
            var _error = data.match("nested: (.*?);");
            return _error == null ? data : _error[1];
        };
    }
    ES.SearchCtrl = SearchCtrl;
})(ES || (ES = {}));
var ES;
(function (ES) {
    ES.config = {
        elasticsearch: "http://" + window.location.hostname + ":9200",
        indice: "twitter",
        doctype: "tweet",
        query: "*"
    };
})(ES || (ES = {}));
/**
* @module IDE
*/
var IDE;
(function (IDE) {
    /**
    * Returns the mbean name of the IDE Facade mbean if its available
    */
    function getIdeMBean(workspace) {
        return Core.getMBeanTypeObjectName(workspace, "hawtio", "IdeFacade");
    }
    IDE.getIdeMBean = getIdeMBean;

    /**
    * Returns true if open in IDEA is enabled
    */
    function isOpenInIdeaSupported(workspace, localStorage) {
        var value = localStorage["openInIDEA"];
        return value !== "false";
    }
    IDE.isOpenInIdeaSupported = isOpenInIdeaSupported;

    /**
    * Returns true if open in TextMate is enabled
    */
    function isOpenInTextMateSupported(workspace, localStorage) {
        var value = localStorage["openInTextMate"];
        return value !== "false";
    }
    IDE.isOpenInTextMateSupported = isOpenInTextMateSupported;

    /**
    * Attempts to find the absolute file name for the given file and class name
    */
    function findClassAbsoluteFileName(mbean, jolokia, localStorage, fileName, className, onResult) {
        var sourceRoots = [];

        // TODO load from localStorage
        var answer = null;
        if (mbean) {
            answer = jolokia.execute(mbean, "findClassAbsoluteFileName", fileName, className, sourceRoots, onSuccess(onResult));
        } else {
            onResult(answer);
        }
        return answer;
    }
    IDE.findClassAbsoluteFileName = findClassAbsoluteFileName;

    function asNumber(value, defaultValue) {
        if (typeof defaultValue === "undefined") { defaultValue = 0; }
        if (angular.isNumber(value)) {
            return value;
        } else if (angular.isString(value)) {
            return parseInt(value);
        } else {
            return defaultValue;
        }
    }

    function max(v1, v2) {
        return (v1 >= v2) ? v1 : v2;
    }

    /**
    * Opens the file in IDEA
    */
    function ideaOpenAndNavigate(mbean, jolokia, absoluteFileName, line, column, fn) {
        if (typeof fn === "undefined") { fn = null; }
        var answer = null;
        if (mbean) {
            line = max(asNumber(line) - 1, 0);
            column = max(asNumber(column) - 1, 0);
            answer = jolokia.execute(mbean, "ideaOpenAndNavigate", absoluteFileName, line, column, onSuccess(fn));
        }
        return answer;
    }
    IDE.ideaOpenAndNavigate = ideaOpenAndNavigate;
})(IDE || (IDE = {}));
var IDE;
(function (IDE) {
    var log = Logger.get("IDE");

    var OpenInIdeDirective = (function () {
        function OpenInIdeDirective(localStorage, workspace, jolokia) {
            var _this = this;
            this.localStorage = localStorage;
            this.workspace = workspace;
            this.jolokia = jolokia;
            this.restrict = 'E';
            this.replace = true;
            this.transclude = false;
            this.scope = {
                fileName: '@',
                className: '@',
                line: '@',
                column: '@'
            };
            // necessary to ensure 'this' is this object <sigh>
            this.link = function (scope, element, attrs) {
                return _this.doLink(scope, element, attrs);
            };
        }
        OpenInIdeDirective.prototype.doLink = function ($scope, $element, $attrs) {
            var workspace = this.workspace;
            var jolokia = this.jolokia;

            var mbean = IDE.getIdeMBean(workspace);
            var fileName = $scope.fileName;
            if (mbean && fileName) {
                var className = $scope.className;
                var line = $scope.line;
                var col = $scope.col;
                if (!angular.isDefined(line) || line === null)
                    line = 0;
                if (!angular.isDefined(col) || col === null)
                    col = 0;

                if (IDE.isOpenInIdeaSupported(workspace, localStorage)) {
                    var ideaButton = $('<button class="btn btn-mini"><img src="app/ide/img/intellijidea.png" width="16" height="16"></button>');

                    function onResult(absoluteName) {
                        if (!absoluteName) {
                            log.info("Could not find file in source code: " + fileName + " class: " + className);
                            ideaButton.attr("title", "Could not find source file: " + fileName);
                        } else {
                            ideaButton.attr("title", "Opening in IDEA: " + absoluteName);
                            IDE.ideaOpenAndNavigate(mbean, jolokia, absoluteName, line, col);
                        }
                    }

                    ideaButton.on("click", function () {
                        log.info("Finding local file name: " + fileName + " className: " + className);
                        IDE.findClassAbsoluteFileName(mbean, jolokia, localStorage, fileName, className, onResult);
                    });
                    $element.append(ideaButton);
                }
            }
        };
        return OpenInIdeDirective;
    })();
    IDE.OpenInIdeDirective = OpenInIdeDirective;
})(IDE || (IDE = {}));
var Fabric;
(function (Fabric) {
    Fabric.startMaps = function () {
    };

    function MapController($scope, $templateCache, jolokia) {
        $scope.myMarkers = [];
        $scope.containers = {};
        $scope.template = "";
        $scope.first = true;
        $scope.myMap = null;

        $scope.start = function () {
            // must have initial map options
            $scope.mapOptions = {
                center: new google.maps.LatLng(35.784, -78.670),
                zoom: 15,
                mapTypeId: google.maps.MapTypeId.ROADMAP
            };

            Core.register(jolokia, $scope, {
                type: 'exec', mbean: Fabric.managerMBean,
                operation: 'containers()',
                arguments: []
            }, onSuccess(render));
        };

        Fabric.startMaps = $scope.start;

        $('body').append('<script type="text/javascript" src="//maps.google.com/maps/api/js?sensor=false&async=2&callback=Fabric.startMaps"></script>');

        // TODO: adding markers on map to place containers is not (yet) supported
        /*
        $scope.addMarker = function ($event) {
        $scope.myMarkers.push(new google.maps.Marker({
        map: $scope.myMap,
        position: $event.latLng
        }));
        };
        
        $scope.setZoomMessage = function (zoom) {
        //$scope.zoomMessage = 'You just zoomed to ' + zoom + '!';
        console.log(zoom, 'zoomed')
        };
        
        $scope.openMarkerInfo = function (marker) {
        $scope.currentMarker = marker;
        $scope.currentMarkerLat = marker.getPosition().lat();
        $scope.currentMarkerLng = marker.getPosition().lng();
        $scope.myInfoWindow.open($scope.myMap, marker);
        };
        
        $scope.setMarkerPosition = function (marker, lat, lng) {
        marker.setPosition(new google.maps.LatLng(lat, lng));
        };
        */
        function render(response) {
            if (response && response.value) {
                response.value.forEach(function (container) {
                    var addMarker = false;
                    var id = container.id;
                    var containerData = $scope.containers[id];
                    if (!containerData) {
                        containerData = {
                            name: id
                        };

                        $scope.containers[id] = containerData;
                        addMarker = true;
                    }
                    containerData.alive = container.alive;
                    containerData.version = container.versionId;
                    containerData.profileIds = container.profileIds;

                    var geoLocation = container["geoLocation"];
                    if (geoLocation) {
                        var values = geoLocation.split(",");
                        if (values.length >= 2) {
                            var lattitude = Core.parseFloatValue(values[0], "lattitude");
                            var longitude = Core.parseFloatValue(values[1], "longitude");
                            if (lattitude && longitude) {
                                // only add marker if we got the map initialized
                                if ($scope.myMap) {
                                    var marker = containerData.marker;
                                    if (addMarker || !marker) {
                                        Fabric.log.info("Adding marker as we have map " + $scope.myMap);
                                        marker = new google.maps.Marker({
                                            position: new google.maps.LatLng(lattitude, longitude),
                                            map: $scope.myMap,
                                            title: container.id,
                                            tooltip: "(lattitude: " + lattitude + ", longitude: " + longitude + ")"
                                        });
                                        containerData.marker = marker;
                                        $scope.myMarkers.push(marker);
                                    }
                                } else {
                                    // lets update the marker in case the container moved ;)
                                    if (containerData.marker) {
                                        containerData.marker.position = new google.maps.LatLng(lattitude, longitude);
                                    }
                                }

                                // lets update the container data
                                containerData.lattitude = lattitude;
                                containerData.longitude = longitude;
                            }
                        }
                    }
                });

                // if there is only 1 container then jump to it asap
                if ($scope.myMarkers.length > 0 && $scope.first) {
                    // lets jump to this as the centre
                    if ($scope.myMap) {
                        var marker = $scope.myMarkers[0];
                        Fabric.log.info("Auto selecting first container on map: " + marker.title);
                        $scope.myMap.panTo(marker.getPosition());
                        $scope.first = false;
                    }
                }

                // only assign template to scope so we only draw map when we are ready
                $scope.template = $templateCache.get("pageTemplate");

                Core.$apply($scope);
            }
        }
    }
    Fabric.MapController = MapController;
})(Fabric || (Fabric = {}));
var Fabric;
(function (Fabric) {
    var ProfileSelector = (function () {
        function ProfileSelector() {
            this.restrict = 'A';
            this.replace = true;
            this.templateUrl = Fabric.templatePath + "profileSelector.html";
            this.scope = {
                selectedProfiles: '=fabricProfileSelector',
                versionId: '=',
                filterWatch: '@',
                selectedWatch: '@',
                clearOnVersionChange: '@',
                noLinks: '@',
                showHeader: '@',
                useCircles: '@',
                expanded: '@',
                excludedProfiles: '=',
                includedProfiles: '='
            };
            this.controller = function ($scope, $element, $attrs, workspace, jolokia, localStorage, $location) {
                $scope.profiles = [];
                $scope.responseJson = '';
                $scope.filterText = '';
                $scope.clearOnVersionChange = false;
                $scope.noLinks = false;
                $scope.selectedAll = false;
                $scope.indeterminate = false;
                $scope.showFilter = true;
                $scope.useCircles = false;
                $scope.expanded = false;
                $scope.tree = [];

                $scope.showProfile = function (profile) {
                    return $scope.filterText.isBlank() || profile.id.has($scope.filterText);
                };

                $scope.showBranch = function (branch) {
                    return $scope.filterText.isBlank() || branch.profiles.some(function (profile) {
                        return profile.id.has($scope.filterText);
                    });
                };

                $scope.goto = function (profile) {
                    Fabric.gotoProfile(workspace, jolokia, localStorage, $location, $scope.versionId, profile);
                };

                $scope.render = function (response) {
                    var responseJson = angular.toJson(response.value);
                    if ($scope.responseJson !== responseJson) {
                        $scope.responseJson = responseJson;
                        var selected = $scope.selectedProfiles;
                        $scope.profiles = response.value.sortBy(function (profile) {
                            return profile.id;
                        });
                        angular.forEach(selected, function (profile) {
                            var p = $scope.profiles.find(function (p) {
                                return p.id === profile.id;
                            });
                            if (p && profile) {
                                p.selected = profile.selected;
                            }
                        });

                        $scope.profiles = $scope.profiles.exclude(function (p) {
                            return p.hidden;
                        });

                        if ($scope.excludedProfiles) {
                            $scope.profiles = $scope.excluded();
                        }

                        if ($scope.includedProfiles) {
                            $scope.profiles = $scope.included();
                        }

                        var paths = [];

                        $scope.profiles.each(function (profile) {
                            var path = profile.id.split('-');
                            profile.name = path.last();
                            profile.path = path.exclude(profile.name).join(' / ');
                            paths.push(profile.path);
                        });

                        paths = paths.unique().sortBy('length').sortBy(function (n) {
                            return n;
                        });
                        var tree = [];
                        paths.forEach(function (path) {
                            var branch = {
                                expanded: $scope.expanded,
                                path: path,
                                profiles: $scope.profiles.filter(function (profile) {
                                    return profile.path === path;
                                })
                            };
                            tree.push(branch);
                        });
                        $scope.tree = tree;

                        Core.$apply($scope);
                    }
                };

                $scope.excluded = function () {
                    return $scope.profiles.exclude(function (p) {
                        return $scope.excludedProfiles.some(function (e) {
                            return e === p.id;
                        });
                    });
                };

                $scope.included = function () {
                    return $scope.profiles.exclude(function (p) {
                        return $scope.includedProfiles.none(function (e) {
                            return e === p.id;
                        });
                    });
                };

                $scope.isOpen = function (branch) {
                    if ($scope.filterText !== '') {
                        return "opened";
                    }
                    if (branch.expanded) {
                        return "opened";
                    }
                    return "closed";
                };

                $scope.isOpenIcon = function (branch) {
                    if (branch.expanded) {
                        return "icon-folder-open";
                    }
                    return "icon-folder-closed";
                };

                $scope.$watch('includedProfiles', function (newValue, oldValue) {
                    if (newValue !== oldValue) {
                        $scope.init();
                    }
                }, true);

                $scope.$watch('excludedProfiles', function (newValue, oldValue) {
                    if (newValue !== oldValue) {
                        $scope.init();
                    }
                }, true);

                $scope.selected = function () {
                    return $scope.profiles.filter(function (profile) {
                        return profile['selected'];
                    });
                };

                $scope.selectAll = function () {
                    $scope.profiles.each(function (profile) {
                        profile.selected = true;
                    });
                };

                $scope.selectNone = function () {
                    $scope.profiles.each(function (profile) {
                        delete profile.selected;
                    });
                };

                $scope.$parent.profileSelectAll = $scope.selectAll;
                $scope.$parent.profileSelectNone = $scope.selectNone;

                $scope.getSelectedClass = function (profile) {
                    if (profile.selected) {
                        return "selected";
                    }
                    return "";
                };

                $scope.$watch('selectedAll', function (newValue, oldValue) {
                    if (newValue !== oldValue) {
                        if ($scope.indeterminate) {
                            $scope.selectNone();
                        } else {
                            if (newValue) {
                                $scope.selectAll();
                            } else {
                                $scope.selectNone();
                            }
                        }
                    }
                });

                $scope.$watch('profiles', function (newValue, oldValue) {
                    if (newValue !== oldValue) {
                        $scope.selectedProfiles = $scope.selected();
                    }
                }, true);

                $scope.$on("fabricProfileRefresh", function () {
                    if ($scope.versionId) {
                        jolokia.request({
                            type: 'exec', mbean: Fabric.managerMBean,
                            operation: 'getProfiles(java.lang.String, java.util.List)',
                            arguments: [$scope.versionId, ['id', 'hidden']]
                        }, {
                            method: 'POST',
                            success: function (response) {
                                $scope.render(response);
                            }
                        });
                    }
                });

                $scope.init = function () {
                    Fabric.log.debug("Initializing profile selector, version: ", $scope.versionId);
                    $scope.responseJson = null;
                    Core.unregister(jolokia, $scope);
                    if ($scope.versionId !== '') {
                        if ($scope.clearOnVersionChange) {
                            $scope.selectNone();
                        }
                        if ($scope.versionId) {
                            Core.register(jolokia, $scope, {
                                type: 'exec',
                                mbean: Fabric.managerMBean,
                                operation: 'getProfiles(java.lang.String, java.util.List)',
                                arguments: [$scope.versionId, ['id', 'hidden']]
                            }, onSuccess($scope.render, {
                                error: function (response) {
                                    // TODO somewhere this directive is kinda getting leaked, need to track down
                                    Fabric.log.debug("Error fetching profiles: ", response.error, " unregistering poller");
                                    Core.unregister(jolokia, $scope);
                                }
                            }));
                        }
                    }
                };

                $scope.$watch('versionId', function (newValue, oldValue) {
                    Fabric.log.debug("versionId, newValue: ", newValue, " oldValue: ", oldValue);
                    if ($scope.versionId && $scope.versionId !== '') {
                        Fabric.log.debug("Unregistering old poller");
                        Core.unregister(jolokia, $scope);
                        jolokia.request({
                            type: 'exec',
                            mbean: Fabric.managerMBean,
                            operation: 'versions()',
                            arguments: []
                        }, {
                            method: 'POST',
                            success: function (response) {
                                if (response.value.some(function (version) {
                                    return version.id === newValue;
                                })) {
                                    Fabric.log.debug("registering new poller");
                                    $scope.init();
                                    Core.$apply($scope);
                                }
                            },
                            error: function (response) {
                                Core.$apply($scope);
                            }
                        });
                    }
                });
            };
            this.link = function ($scope, $element, $attrs) {
                var selector = $element.find('#selector');

                if (!angular.isDefined($attrs['showHeader'])) {
                    $scope.showFilter = true;
                } else {
                    $scope.showFilter = $attrs['showHeader'];
                }

                if (angular.isDefined($attrs['filterWatch'])) {
                    $scope.$parent.$watch($attrs['filterWatch'], function (newValue, oldValue) {
                        if (newValue !== oldValue) {
                            $scope.filterText = newValue;
                        }
                    });
                }

                $scope.$watch('indeterminate', function (newValue, oldValue) {
                    if (newValue !== oldValue) {
                        selector.prop('indeterminate', $scope.indeterminate);
                    }
                });

                $scope.$watch('selectedProfiles', function (newValue, oldValue) {
                    if (newValue !== oldValue) {
                        if ($scope.selectedProfiles.length > 0) {
                            if ($scope.selectedProfiles.length !== $scope.profiles.length) {
                                $scope.indeterminate = true;
                                $scope.selectedAll = false;

                                $scope.$parent.profileSomeSelected = true;
                                $scope.$parent.profileNoneSelected = false;
                                $scope.$parent.profileAllSelected = false;
                            } else {
                                $scope.indeterminate = false;
                                $scope.selectedAll = true;

                                $scope.$parent.profileSomeSelected = false;
                                $scope.$parent.profileNoneSelected = false;
                                $scope.$parent.profileAllSelected = true;
                            }
                        } else {
                            $scope.indeterminate = false;
                            $scope.selectedAll = false;

                            $scope.$parent.profileSomeSelected = false;
                            $scope.$parent.profileNoneSelected = true;
                            $scope.$parent.profileAllSelected = false;
                        }
                    }
                }, true);
            };
        }
        return ProfileSelector;
    })();
    Fabric.ProfileSelector = ProfileSelector;
})(Fabric || (Fabric = {}));
var Fabric;
(function (Fabric) {
    function CreateFabricController($scope, jolokia, $location, workspace, branding) {
        $scope.$on('$routeChangeSuccess', function () {
            if (workspace.treeContainsDomainAndProperties(Fabric.jmxDomain, { type: "Fabric" })) {
                $location.url("/fabric/view");
            }
        });

        Fabric.getSchema('createEnsemble', 'io.fabric8.api.CreateEnsembleOptions', jolokia, function (schema) {
            $scope.schema = schema;
            Core.$apply($scope);
        });

        $scope.creating = false;

        $scope.entity = {
            zooKeeperServerPort: 2181,
            globalResolver: 'localhostname',
            resolver: 'localhostname',
            agentEnabled: true,
            autoImportEnabled: true,
            minimumPort: 0,
            maximumPort: 65535,
            profiles: ['fabric', 'hawtio']
        };

        if (branding.profile) {
            $scope.entity.profiles.push(branding.profile);
        }

        // console.log("entity: ", $scope.entity);
        $scope.forms = {};

        $scope.onSubmit = function (json, form) {
            json = Fabric.sanitizeJson(json);

            setTimeout(function () {
                jolokia.execute(Fabric.clusterBootstrapManagerMBean, 'createCluster(java.util.Map)', angular.toJson(json), {
                    method: 'post',
                    success: function (response) {
                        notification('success', "Created fabric!");
                        $location.url("/fabric/containers");
                        Core.$apply($scope);
                    },
                    error: function (response) {
                        notification('error', "Error creating fabric: " + response.error);
                        Core.$apply($scope);
                    }
                });
                notification('info', "Creating fabric, please wait...");
                $location.url("/logs");
                Core.$apply($scope);
            }, 30);
        };
    }
    Fabric.CreateFabricController = CreateFabricController;
})(Fabric || (Fabric = {}));
var Fabric;
(function (Fabric) {
    function NavBarController($scope, $location, jolokia, workspace, localStorage) {
        $scope.activeVersion = "1.0";

        $scope.mapsEnabled = localStorage['fabricEnableMaps'];

        // update the active version whenever query parameters change
        $scope.$on('$routeUpdate', reloadVersion);

        $scope.isActive = function (href) {
            return workspace.isLinkActive(href);
        };

        $scope.clusterLink = function () {
            // TODO move to use /fabric/clusters by default maybe?
            return Core.createHref($location, "#/fabric/clusters/fabric/registry/clusters", ["cv", "cp", "pv"]);
        };

        function reloadVersion() {
            $scope.activeVersion = Fabric.getActiveVersion($location);
        }

        function reloadData() {
            // TODO should probably load the default version here
            reloadVersion();
            $scope.hasFabric = Fabric.hasFabric(workspace);
            $scope.hasMQManager = Fabric.hasMQManager(workspace);
            if ($scope.hasFabric) {
                var containerId = null;
                Fabric.containerWebAppURL(jolokia, "drools-wb-distribution-wars", containerId, onDroolsUrl, onDroolsUrl);
                $scope.canUpload = workspace.treeContainsDomainAndProperties('hawtio', { type: 'UploadManager' });
            }
        }

        reloadData();

        function onDroolsUrl(response) {
            var url = response ? response.value : null;
            console.log("========== onDroolsUrl: " + url);
            $scope.droolsHref = url;
            Core.$apply($scope);
        }
    }
    Fabric.NavBarController = NavBarController;
})(Fabric || (Fabric = {}));
var Fabric;
(function (Fabric) {
    /**
    * Returns the resolvers for the given schema id (child, ssh, jclouds, openshift, docker)
    */
    function getResolvers(id) {
        var answer;
        switch (id) {
            case 'child':
                answer = [];
                break;
            case 'ssh':
                answer = ['localip', 'localhostname', 'publicip', 'publichostname', 'manualip'];
                break;
            case 'jclouds':
                answer = ['localip', 'localhostname', 'publicip', 'publichostname', 'manualip'];
                break;
            case 'openshift':
                answer = [];
                break;
            case 'docker':
                answer = [];
                break;
        }
        return answer;
    }
    Fabric.getResolvers = getResolvers;

    function customizeSchema(id, schema) {
        // console.log("Schema: ", schema);
        Core.pathSet(schema, ["properties", "name", "required"], true);
        Core.pathSet(schema, ['properties', 'name', 'input-attributes', 'ng-pattern'], "/^[a-zA-Z0-9_-]*$/");

        delete schema.properties['metadataMap'];
        delete schema.properties['zookeeperUrl'];
        delete schema.properties['zookeeperPassword'];
        delete schema.properties['globalResolver'];
        delete schema.properties['zooKeeperServerPort'];
        delete schema.properties['zooKeeperServerConnectionPort'];
        delete schema.properties['agentEnabled'];
        delete schema.properties['autoImportEnabled'];
        delete schema.properties['importPath'];
        delete schema.properties['users'];

        [
            'zooKeeperServerInitLimit',
            'zooKeeperServerTickTime',
            'zooKeeperServerSyncLimit',
            'zooKeeperServerDataDir',
            'waitForProvision',
            'ensembleStart',
            'migrationTimeout',
            'dataStoreProperties'].forEach(function (attr) {
            Core.pathSet(schema, ['properties', attr, 'control-attributes', 'ng-show'], 'entity.ensembleServer');
        });

        Core.pathSet(schema, ['properties', 'providerType', 'type'], 'hidden');
        Core.pathSet(schema, ['properties', 'profiles', 'type'], 'hidden');
        Core.pathSet(schema, ['properties', 'version', 'type'], 'hidden');

        Core.pathSet(schema.properties, ['name', 'label'], 'Container Name');
        Core.pathSet(schema.properties, ['name', 'tooltip'], 'Name of the container to create (or prefix of the container name if you create multiple containers)');

        Core.pathSet(schema.properties, ['number', 'label'], 'Number of containers');
        Core.pathSet(schema.properties, ['number', 'tooltip'], 'The number of containers to create; when set higher than 1 a number will be appended to each container name');
        Core.pathSet(schema.properties, ['number', 'input-attributes', 'min'], '1');

        // mark properties as autofill to avoid issues with angular missing autofill events
        Core.pathSet(schema.properties, ['login', 'input-attributes', "autofill"], "true");
        Core.pathSet(schema.properties, ['password', 'input-attributes', "autofill"], "true");

        Core.pathSet(schema.properties, ['jmxUser', 'input-attributes', "autofill"], "true");
        Core.pathSet(schema.properties, ['jmxUser', 'tooltip'], 'The username for connecting to the container using JMX');

        Core.pathSet(schema.properties, ['jmxPassword', 'input-attributes', "autofill"], "true");
        Core.pathSet(schema.properties, ['jmxPassword', 'tooltip'], 'The password for connecting to the container using JMX');

        Core.pathSet(schema.properties, ['resolver', 'input-element'], "select");
        Core.pathSet(schema.properties, ['resolver', 'input-attributes', "ng-options"], "r for r in resolvers");

        switch (id) {
            case 'child':
                delete schema.properties['manualIp'];
                delete schema.properties['preferredAddress'];
                delete schema.properties['resolver'];
                delete schema.properties['ensembleServer'];
                delete schema.properties['proxyUri'];
                delete schema.properties['adminAccess'];
                delete schema.properties['minimumPort'];
                delete schema.properties['maximumPort'];
                schema.properties['jmxPassword']['type'] = 'password';

                /*
                schema.properties['saveJmxCredentials'] = {
                'type': 'boolean'
                };
                Core.pathSet(schema.properties, ['saveJmxCredentials', 'tooltip'], 'Remember credentials when connecting to container (avoid prompting user to enter credentials)');
                */
                Core.pathSet(schema.properties, ['parent', 'label'], 'Parent Container');
                Core.pathSet(schema.properties, ['parent', 'tooltip'], 'The name of the parent container used to create the child container');
                Core.pathSet(schema.properties, ['parent', 'input-element'], "select");
                Core.pathSet(schema.properties, ['parent', 'input-attributes', "ng-options"], "c for c in child.rootContainers");

                bulkSet(schema, ["jmxUser", "jmxPassword", "parent"], 'required', true);
                schema['tabs'] = {
                    'Common': ['name', 'parent', 'jmxUser', 'jmxPassword', 'number'],
                    'Advanced': ['*']
                };
                break;

            case 'ssh':
                delete schema.properties['jmxUser'];
                delete schema.properties['jmxPassword'];
                delete schema.properties['parent'];

                bulkSet(schema, ['host'], 'required', true);
                Core.pathSet(schema.properties, ['password', 'type'], 'password');

                schema['tabs'] = {
                    'Common': ['name', 'host', 'port', 'username', 'password', 'privateKeyFile', 'passPhrase'],
                    'Advanced': ['*']
                };
                break;

            case 'jclouds':
                delete schema.properties['jmxUser'];
                delete schema.properties['jmxPassword'];
                delete schema.properties['parent'];

                schema['tabs'] = {
                    'Common': ['name', 'owner', 'credential', 'providerName', 'imageId', 'hardwareId', 'locationId', 'number', 'instanceType'],
                    'Advanced': ['*']
                };
                break;

            case 'openshift':
                delete schema.properties['jmxUser'];
                delete schema.properties['jmxPassword'];
                delete schema.properties['parent'];
                delete schema.properties['manualIp'];
                delete schema.properties['preferredAddress'];
                delete schema.properties['ensembleServer'];
                delete schema.properties['proxyUri'];
                delete schema.properties['adminAccess'];
                delete schema.properties['path'];
                delete schema.properties['bindAddress'];
                delete schema.properties['hostNameContext'];
                delete schema.properties['resolver'];

                //        schema.properties['serverUrl']['default'] = 'openshift.redhat.com';
                // openshift must select publichostname as the resolver
                Core.pathSet(schema.properties, ['resolver', 'default'], 'publichostname');
                Core.pathSet(schema.properties, ['serverUrl', 'label'], 'OpenShift Broker');
                Core.pathSet(schema.properties, ['serverUrl', 'tooltip'], 'The OpenShift broker host name of the cloud to create the container inside. This is either the URL for your local OpenShift Enterprise installation, or its the public OpenShift online URL: openshift.redhat.com');
                Core.pathSet(schema.properties, ['login', 'label'], 'OpenShift Login');
                Core.pathSet(schema.properties, ['login', 'tooltip'], 'Your personal login to the OpenShift portal');
                Core.pathSet(schema.properties, ['login', 'input-attributes', "autofill"], "true");
                Core.pathSet(schema.properties, ['password', 'label'], 'OpenShift Password');
                Core.pathSet(schema.properties, ['password', 'tooltip'], 'Your personal password on the OpenShift portal');
                Core.pathSet(schema.properties, ['password', 'type'], 'password');

                // openshift only allows lowercase a-z and numbers
                Core.pathSet(schema.properties, ['name', 'input-attributes', 'ng-pattern'], "/^[a-z0-9]*$/");

                // add an extra property to make it easy to login
                /*
                */
                /*
                Core.pathSet(schema.properties, ['tryLogin', 'label'], 'Try');
                */
                /*
                Core.pathSet(schema.properties, ['tryLogin', 'input-element'], "button");
                Core.pathSet(schema.properties, ['tryLogin', 'input-attributes', "class"], "btn");
                Core.pathSet(schema.properties, ['tryLogin', 'input-attributes', "ng-click"], "openShift.login()");
                */
                //Core.pathSet(schema.properties, ['tryLogin', 'input-attributes', "ng-disable"], "!entity.login || !entity.password || !entity.serverUrl");
                /*
                */
                Core.pathSet(schema.properties, ['tryLogin', 'type'], 'string');
                Core.pathSet(schema.properties, ['tryLogin', 'input-attributes', "ng-model"], "openShift.tryLogin");
                Core.pathSet(schema.properties, ['tryLogin', 'label'], 'Authenticate');
                Core.pathSet(schema.properties, ['tryLogin', 'tooltip'], 'Authenticate with the OpenShift Broker using your login and password');
                Core.pathSet(schema.properties, ['tryLogin', 'formTemplate'], '<a ng-click="openShift.login()" ng-disabled="!entity.login || !entity.password || !entity.serverUrl" ' + 'title="Test you entered the correct OpenShift Broker, login and password" class="btn btn-primary">Login to OpenShift</a>' + '<div class="alert" ng-show="openShift.loginFailed" ' + 'title="Are you sure you correctly entered the OpenShift Broker, login and password correctly?">Login failed</div>');

                /*
                Core.pathSet(schema.properties, ['tryLogin', 'formTemplate'], '<button ng-click="openShift.login()" title="Test you entered the correct OpenShift Broker, login and password">Try Login</button>');
                */
                Core.pathSet(schema.properties, ['domain', 'label'], 'OpenShift Domain');
                Core.pathSet(schema.properties, ['domain', 'tooltip'], 'What is your unique domain name used for applications you create on OpenShift. Often this is your own user name or group name');
                Core.pathSet(schema.properties, ['domain', 'input-element'], "select");
                Core.pathSet(schema.properties, ['domain', 'input-attributes', "ng-options"], "c for c in openShift.domains");

                Core.pathSet(schema.properties, ['gearProfile', 'tooltip'], 'Which kind of gear to create');
                Core.pathSet(schema.properties, ['gearProfile', 'input-element'], "select");
                Core.pathSet(schema.properties, ['gearProfile', 'input-attributes', "ng-options"], "c for c in openShift.gearProfiles");

                bulkSet(schema, ['serverUrl', 'login', 'password', 'domain'], 'required', true);
                schema['tabs'] = {
                    'Common': ['name', 'serverUrl', 'login', 'password', 'tryLogin', 'domain', 'gearProfile', 'number'],
                    'Advanced': ['environmentalVariables', 'systemProperties', 'jvmOpts', '*']
                };
                break;

            case 'docker':
                delete schema.properties['jmxUser'];
                delete schema.properties['jmxPassword'];
                delete schema.properties['parent'];
                delete schema.properties['manualIp'];
                delete schema.properties['preferredAddress'];
                delete schema.properties['resolver'];
                delete schema.properties['ensembleServer'];
                delete schema.properties['proxyUri'];
                delete schema.properties['adminAccess'];
                delete schema.properties['path'];
                delete schema.properties['bindAddress'];
                delete schema.properties['hostNameContext'];

                schema['tabs'] = {
                    'Common': ['name', 'number'],
                    'Advanced': ['environmentalVariables', 'systemProperties', 'jvmOpts', '*']
                };
                break;

            default:
        }

        return schema;
    }
    Fabric.customizeSchema = customizeSchema;

    function bulkSet(schema, properties, field, value) {
        properties.each(function (name) {
            Core.pathSet(schema, ['properties', name, field], value);
        });
    }

    function setGlobalResolverEnum(schema) {
        var globalResolverEnum = ['localip', 'localhostname', 'publicip', 'publichostname'];
        Core.pathSet(schema, ['properties', 'globalResolver', 'enum'], globalResolverEnum);
    }
})(Fabric || (Fabric = {}));
var Fabric;
(function (Fabric) {
    function CreateBrokerController($scope, localStorage, $routeParams, $location, jolokia, workspace, $compile, $templateCache) {
        Fabric.initScope($scope, $location, jolokia, workspace);

        $scope.defaultGroup = "default";
        $scope.defaultBrokerName = "brokerName";

        $scope.groups = [];
        $scope.possibleNetworks = [];
        $scope.profiles = [];
        $scope.parentProfiles = [];
        $scope.entity = {
            group: $scope.defaultGroup
        };
        $scope.otherEntity = {
            networkConnectAll: false
        };

        // holds all the form objects from nested child scopes
        $scope.forms = {};

        $scope.onSubmit = function (json, form) {
            $scope.message = ($scope.entity.brokerName || "unknown") + " in group " + ($scope.entity.group || "unknown");
            notification("info", "Creating broker " + $scope.message);
            var tmpJson = JSON.stringify($scope.entity, null, '  ');
            jolokia.execute(Fabric.mqManagerMBean, "saveBrokerConfigurationJSON", tmpJson, onSuccess(onSave));

            // now lets switch to the brokers view
            $location.path("/fabric/mq/brokers");
            Core.$apply($scope);
        };

        $scope.brokerNameExists = function () {
            var name = $scope.entity.brokerName;
            return name && $scope.brokerNames.indexOf(name) >= 0;
        };

        function updatePossibleNetworks() {
            var group = $scope.entity.group;
            $scope.possibleNetworks = [].concat($scope.groups);
            if (group) {
                $scope.possibleNetworks = $scope.possibleNetworks.remove(group);
            }
        }

        $scope.$watch("entity.group", updatePossibleNetworks);
        $scope.$watch("otherEntity.networkConnectAll", function () {
            if ($scope.otherEntity.networkConnectAll) {
                $scope.entity.networks = $scope.possibleNetworks;
            }
        });

        // default parameters from the URL
        angular.forEach(["group", "profile"], function (param) {
            var value = $routeParams[param];
            if (value) {
                $scope.entity[param] = value;
            }
        });
        if (!$scope.entity.kind) {
            $scope.entity.kind = "MasterSlave";
        }

        Fabric.getDtoSchema("brokerConfig", "io.fabric8.api.jmx.MQBrokerConfigDTO", jolokia, function (schema) {
            $scope.schema = schema;
            configureSchema(schema);
            jolokia.execute(Fabric.mqManagerMBean, "loadBrokerStatus()", onSuccess(onBrokerData));
            Core.$apply($scope);
        });

        function configureSchema(schema) {
            delete schema.properties['username'];
            delete schema.properties['password'];

            // avoid the properties field for now as we don't yet have a generated UI for key/value pairs...
            delete schema.properties['properties'];

            var isReplicated = "entity.kind == 'Replicated'";
            var isStandalone = "entity.kind == 'StandAlone'";

            Core.pathSet(schema.properties, ['group', 'required'], true);
            Core.pathSet(schema.properties, ['group', 'tooltip'], 'The peer group name of message brokers. The group is name is used by messaging clients to connect to a broker; so it represents a peer group of brokers used for load balancing.');
            Core.pathSet(schema.properties, ['group', 'input-attributes', 'typeahead'], 'title for title in groups | filter:$viewValue');
            Core.pathSet(schema.properties, ['group', 'input-attributes', 'typeahead-editable'], 'true');

            Core.pathSet(schema.properties, ['brokerName', 'required'], true);
            Core.pathSet(schema.properties, ['brokerName', 'tooltip'], 'The name of the broker.');
            Core.pathSet(schema.properties, ['brokerName', 'input-attributes', 'autofocus'], 'true');

            Core.pathSet(schema.properties, ['parentProfile', 'tooltip'], 'The parent profile used by the profile.');
            Core.pathSet(schema.properties, ['parentProfile', 'input-attributes', 'typeahead'], 'p.id for p in parentProfiles | filter:$viewValue');
            Core.pathSet(schema.properties, ['parentProfile', 'input-attributes', 'typeahead-editable'], 'false');
            Core.pathSet(schema.properties, ['parentProfile', 'input-attributes', "placeholder"], "{{" + isReplicated + " ? 'mq-replicated' : 'mq-base'}}");

            Core.pathSet(schema.properties, ['profile', 'tooltip'], 'The profile to create instances of this broker.');
            Core.pathSet(schema.properties, ['profile', 'input-attributes', 'typeahead'], 'title for title in profiles | filter:$viewValue');
            Core.pathSet(schema.properties, ['profile', 'input-attributes', 'typeahead-editable'], 'true');
            Core.pathSet(schema.properties, ['profile', 'input-attributes', "placeholder"], "mq-broker-{{entity.group || 'default'}}.{{entity.brokerName || 'brokerName'}}");

            Core.pathSet(schema.properties, ['clientProfile', 'tooltip'], 'The profile used by messaging clients to connect to this group of brokers.');
            Core.pathSet(schema.properties, ['clientProfile', 'input-attributes', 'typeahead'], 'title for title in profiles | filter:$viewValue');
            Core.pathSet(schema.properties, ['clientProfile', 'input-attributes', 'typeahead-editable'], 'true');
            Core.pathSet(schema.properties, ['clientProfile', 'input-attributes', "placeholder"], "mq-client-{{entity.group || 'default'}}");

            Core.pathSet(schema.properties, ['clientParentProfile', 'tooltip'], 'The parent profile used by the client profile.');
            Core.pathSet(schema.properties, ['clientParentProfile', 'input-attributes', 'typeahead'], 'p.id for p in parentProfiles | filter:$viewValue');
            Core.pathSet(schema.properties, ['clientParentProfile', 'input-attributes', 'typeahead-editable'], 'false');
            Core.pathSet(schema.properties, ['parentProfile', 'input-attributes', "placeholder"], "default");

            Core.pathSet(schema.properties, ['data', 'input-attributes', "placeholder"], "${karaf.base}/data/{{entity.brokerName || 'brokerName'}}");
            Core.pathSet(schema.properties, ['configUrl', 'input-attributes', "placeholder"], "profile:broker.xml");

            Core.pathSet(schema.properties, ['replicas', 'control-group-attributes', "ng-show"], isReplicated);
            Core.pathSet(schema.properties, ['replicas', 'input-attributes', "placeholder"], "3");
            Core.pathSet(schema.properties, ['minimumInstances', 'control-group-attributes', "ng-hide"], isReplicated);
            Core.pathSet(schema.properties, ['minimumInstances', 'input-attributes', "placeholder"], "{{" + isStandalone + " ? 1 : 2}}");

            Core.pathSet(schema.properties, ['networksPassword', 'type'], 'password');
            Core.pathSet(schema.properties, ['networks', 'items', 'input-attributes', 'typeahead-editable'], 'true');
            Core.pathSet(schema.properties, ['networks', 'input-attributes', "ng-hide"], "otherEntity.networkConnectAll");
            Core.pathSet(schema.properties, ['networks', 'tooltip'], 'The broker groups to create a store and forward network to');

            // add an extra property to make it easy to connect to all / none
            Core.pathSet(schema.properties, ['networkConnectAll', 'type'], 'boolean');
            Core.pathSet(schema.properties, ['networkConnectAll', 'input-attributes', 'ng-model'], "otherEntity.networkConnectAll");
            Core.pathSet(schema.properties, ['networkConnectAll', 'label'], 'Network to all groups');
            Core.pathSet(schema.properties, ['networkConnectAll', 'tooltip'], 'Should this broker create a store and forward network to all the known groups of brokers');

            schema['tabs'] = {
                'Default': ['group', 'brokerName', 'kind', 'profile', 'clientProfile', 'data', 'configUrl', 'replicas', 'minimumInstances', 'networkConnectAll', 'networks'],
                'Advanced': ['parentProfile', 'clientParentProfile', 'networksUserName', 'networksPassword', '*']
            };
        }

        function onBrokerData(brokerStatuses) {
            var networkNames = brokerStatuses.map(function (s) {
                return s.networks;
            }).flatten().unique();
            var groups = brokerStatuses.map(function (s) {
                return s.group;
            }).unique();

            $scope.groups = networkNames.concat(groups).unique().sort();
            $scope.profiles = brokerStatuses.map(function (s) {
                return s.profile;
            }).unique().sort();
            $scope.brokerNames = brokerStatuses.map(function (s) {
                return s.brokerName;
            }).unique().sort();

            updatePossibleNetworks();

            var version = brokerStatuses.map(function (s) {
                return s.version;
            }).find(function (s) {
                return s;
            }) || "1.0";
            if (version) {
                jolokia.execute(Fabric.managerMBean, "getProfiles(java.lang.String,java.util.List)", version, ["id", "abstract"], onSuccess(onProfileData));
            }
            Core.$apply($scope);
        }

        function onProfileData(profileData) {
            if (profileData) {
                $scope.parentProfiles = profileData.filter(function (p) {
                    return !p.abstract;
                }).sortBy("id");
            }
        }

        function onSave(response) {
            notification("success", "Created broker " + $scope.message);
            Core.$apply($scope);
        }
    }
    Fabric.CreateBrokerController = CreateBrokerController;
})(Fabric || (Fabric = {}));
var Fabric;
(function (Fabric) {
    function FeatureEditController($scope, $routeParams, $location, jolokia, xml2json, workspace) {
        Fabric.initScope($scope, $location, jolokia, workspace);

        $scope.getProfileFeaturesOp = "getProfileFeatures(java.lang.String, java.lang.String)";
        $scope.versionId = $routeParams.versionId;
        $scope.profileId = $routeParams.profileId;

        $scope.response = {};

        $scope.features = [];

        $scope.selectedRepoFeatures = [];

        $scope.deletingFeatures = [];
        $scope.addingFeatures = [];

        $scope.selectedRepoSelectedFeatures = [];

        $scope.featureGridOptions = {
            data: 'selectedRepoFeatures',
            selectedItems: $scope.selectedRepoSelectedFeatures,
            displayFooter: false,
            showFilter: false,
            keepLastSelected: true,
            showSelectionCheckbox: true,
            filterOptions: {
                filterText: ''
            },
            columnDefs: [
                {
                    field: 'name',
                    displayName: 'Name'
                },
                {
                    field: 'version',
                    displayName: 'Version'
                }
            ]
        };

        $scope.$watch('features', function (newValue, oldValue) {
            if (newValue !== oldValue) {
                $scope.parentFeatures = $scope.features.filter(function (f) {
                    return f.isParentFeature;
                });
                $scope.profileFeatures = $scope.features.filter(function (f) {
                    return !f.isParentFeature;
                });
                $scope.addingFeatures = $scope.features.filter(function (f) {
                    return f.adding;
                });
                $scope.deletingFeatures = $scope.features.filter(function (f) {
                    return f.deleting;
                });
            }
        }, true);

        $scope.$watch('addingFeatures', function (newValue, oldValue) {
            if (newValue !== oldValue) {
            }
        }, true);

        $scope.dispatch = function (response) {
            var responseJson = angular.toJson(response.value);
            if (responseJson !== $scope.responseJson) {
                if (angular.isDefined($scope.responseJson)) {
                    notification('info', "Profile feature definitions updated");
                }
                $scope.responseJson = responseJson;
                $scope.features = response.value.featureDefinitions;
                var repositories = response.value.repositoryDefinitions;

                $scope.selectedRepoFeatures = [];

                repositories.forEach(function (repo) {
                    var repoJson = xml2json(repo['data']);
                    if ('feature' in repoJson) {
                        var features = repoJson['feature'];
                        if (!angular.isArray(features)) {
                            features = [features];
                        }
                        $scope.selectedRepoFeatures.add(features);
                    }
                });

                $scope.selectedRepoFeatures = $scope.selectedRepoFeatures.sortBy('name');

                Core.$apply($scope);
            }
        };

        $scope.getClass = function (feature) {
            if (feature.adding) {
                return "adding";
            }
            if (feature.deleting) {
                return "deleting";
            }
            return "";
        };

        $scope.removeFeature = function (feature) {
            if (feature.adding) {
                $scope.features.remove(function (f) {
                    return f.id === feature.id;
                });
            } else {
                feature.deleting = !feature.deleting;
            }
        };

        $scope.addSelectedFeatures = function (withVersion) {
            $scope.selectedRepoSelectedFeatures.each(function (feature) {
                var id = feature.name;

                if (withVersion) {
                    id = id + "/" + feature.version;
                }

                $scope.features.push({
                    id: id,
                    adding: true
                });
            });
        };

        $scope.save = function () {
            jolokia.request({
                type: 'exec', mbean: Fabric.managerMBean,
                operation: 'getConfigurationFile(java.lang.String, java.lang.String, java.lang.String)',
                arguments: [$scope.versionId, $scope.profileId, 'io.fabric8.agent.properties']
            }, onSuccess($scope.doSave));
        };

        $scope.doSave = function (response) {
            var configFile = response.value.decodeBase64();
            var lines = configFile.lines();

            if ($scope.deletingFeatures.length > 0) {
                $scope.deletingFeatures.each(function (feature) {
                    lines.remove(function (line) {
                        return line.startsWith("feature." + feature.id);
                    });
                });
            }

            if ($scope.addingFeatures.length > 0) {
                $scope.addingFeatures.each(function (feature) {
                    lines.add("feature." + feature.id + " = " + feature.id);
                });
            }

            configFile = lines.join('\n');

            Fabric.saveConfigFile(jolokia, $scope.versionId, $scope.profileId, 'io.fabric8.agent.properties', configFile.encodeBase64(), function () {
                notification('success', "Updated feature definitions...");
                Core.$apply($scope);
            }, function (response) {
                notification('error', "Failed to save feature definitions due to " + response.error);
                Core.$apply($scope);
            });
        };

        Core.register(jolokia, $scope, [{
                type: 'exec', mbean: Fabric.managerMBean, operation: $scope.getProfileFeaturesOp,
                arguments: [$scope.versionId, $scope.profileId]
            }], onSuccess($scope.dispatch));
    }
    Fabric.FeatureEditController = FeatureEditController;
})(Fabric || (Fabric = {}));
var Fabric;
(function (Fabric) {
    function FabricViewController($scope, $location, jolokia, localStorage, workspace) {
        $scope.hasOpenShiftFabric = Fabric.hasOpenShiftFabric(workspace);

        Fabric.initScope($scope, $location, jolokia, workspace);

        $scope.containerArgs = ["id", "alive", "parentId", "profileIds", "versionId", "provisionResult", "jolokiaUrl", "root"];
        $scope.containersOp = 'containers(java.util.List)';
        $scope.ensembleContainerIdListOp = 'EnsembleContainers';

        $scope.init = function () {
            var activeVersionId = $location.search()['cv'];
            if (activeVersionId) {
                $scope.activeVersionId = activeVersionId;
                $scope.activeVersion = {
                    id: $scope.activeVersionId
                };
            }

            var profiles = $location.search()['sp'];
            $scope.selectedProfileIds = [];
            if (profiles) {
                $scope.selectedProfileIds = profiles.split(',');
            }

            var containers = $location.search()['sc'];
            $scope.selectedContainerIds = [];
            if (containers) {
                $scope.selectedContainerIds = containers.split(',');
            }
        };

        $scope.versions = [];
        $scope.profiles = [];
        $scope.containers = [];
        $scope.activeProfiles = [];

        $scope.activeVersion = {};
        $scope.activeVersionId = '';
        $scope.selectedContainers = [];
        $scope.selectedProfiles = [];
        $scope.selectedActiveProfiles = [];

        $scope.dialogProfiles = [];

        $scope.profileIdFilter = '';
        $scope.activeProfileIdFilter = '';
        $scope.containerIdFilter = '';

        $scope.filterActiveVersion = false;
        $scope.filterActiveProfile = false;

        $scope.deleteVersionDialog = new UI.Dialog();
        $scope.deleteProfileDialog = new UI.Dialog();
        $scope.createProfileDialog = new UI.Dialog();

        $scope.ensembleContainerIds = [];
        $scope.profileSelectedAll = false;

        $scope.targetContainer = {};

        // Tweaks to ensure ng-grid displays on dialogs
        $scope.triggerResize = function () {
            setTimeout(function () {
                $('.dialogGrid').trigger('resize');
            }, 10);
        };

        /*
        $scope.$watch('createProfileDialog', function() {
        if ($scope.createProfileDialog) {
        $scope.triggerResize();
        }
        });
        
        $scope.$watch('createVersionDialog', function() {
        if ($scope.createVersionDialog) {
        $scope.triggerResize();
        }
        });
        */
        // holders for dialog data
        $scope.newProfileName = '';
        $scope.selectedParents = [];
        $scope.selectedParentVersion = [];

        $scope.$on('$routeUpdate', $scope.init);

        // watchers for selection handling
        $scope.$watch('activeVersionId', function (oldValue, newValue) {
            $location.search('cv', $scope.activeVersionId);
        });

        $scope.$watch('activeVersion', function (newValue, oldValue) {
            if (newValue !== oldValue && $scope.activeVersion && $scope.activeVersion.id !== $scope.activeVersionId) {
                $scope.activeVersionId = $scope.activeVersion.id;
            }
        });

        $scope.$watch('containers', function (oldValue, newValue) {
            if (oldValue !== newValue) {
                $scope.selectedContainers = $scope.containers.filter(function (c) {
                    return c.selected;
                });

                if ($scope.selectedContainers.length > 0) {
                    $scope.activeContainerId = '';
                }
            }
        }, true);

        $scope.$watch('activeProfiles', function (oldValue, newValue) {
            if (oldValue !== newValue) {
                $scope.selectedActiveProfiles = $scope.activeProfiles.filter(function (ap) {
                    return ap.selected;
                });
            }
        }, true);

        $scope.$watch('selectedProfiles', function (oldValue, newValue) {
            if (oldValue !== newValue) {
                var ids = $scope.getSelectedProfileIds().join(',');
                $location.search('sp', ids);
            }
        }, true);

        $scope.$watch('selectedContainers', function (oldValue, newValue) {
            if (oldValue !== newValue) {
                var ids = $scope.getSelectedContainerIds().join(',');
                $location.search('sc', ids);
            }
        }, true);

        // initialize the scope after we set all our watches
        $scope.init();

        // create profile dialog action
        $scope.doCreateProfile = function (newProfileName, selectedParents) {
            $scope.newProfileName = newProfileName;
            $scope.createProfileDialog.close();
            var parents = selectedParents.map(function (profile) {
                return profile.id;
            });
            Fabric.createProfile(jolokia, $scope.activeVersionId, $scope.newProfileName, parents, function () {
                notification('success', "Created profile " + $scope.newProfileName);
                $scope.profileIdFilter = $scope.newProfileName;
                $scope.newProfileName = "";
                Core.$apply($scope);
            }, function (response) {
                notification('error', "Failed to create profile " + $scope.newProfileName + " due to " + response.error);
                Core.$apply($scope);
            });
        };

        // delete version dialog action
        $scope.deleteVersion = function () {
            var id = $scope.activeVersionId;

            jolokia.request({
                type: 'read',
                mbean: Fabric.managerMBean,
                attribute: 'DefaultVersion'
            }, onSuccess(function (response) {
                $scope.activeVersionId = response.value;
                Core.$apply($scope);
                setTimeout(function () {
                    Fabric.deleteVersion(jolokia, id, function () {
                        notification('success', "Deleted version " + id);
                        Core.$apply($scope);
                    }, function (response) {
                        notification('error', "Failed to delete version " + id + " due to " + response.error);
                        Core.$apply($scope);
                    });
                }, 100);
            }));
        };

        $scope.deleteSelectedProfiles = function () {
            $scope.selectedProfiles.each(function (profile) {
                var profileId = profile.id;
                Fabric.deleteProfile(jolokia, $scope.activeVersionId, profileId, function () {
                    notification('success', "Deleted profile " + profileId);
                }, function (response) {
                    notification('error', "Failed to delete profile " + profileId + ' due to ' + response.error);
                });
            });
        };

        $scope.patchVersion = function (versionId) {
            $location.url('/fabric/patching').search({ versionId: versionId });
        };

        $scope.migrateVersion = function (targetName, sourceName) {
            notification('info', "Moving " + targetName + " to " + sourceName);

            Fabric.migrateContainers(jolokia, sourceName, [targetName], function () {
                notification('success', "Moved " + targetName + " to version " + sourceName);
            }, function (response) {
                notification('error', "Failed to move " + targetName + " to version " + sourceName + " due to " + response.error);
            });
        };

        $scope.addProfiles = function (targetName, profiles) {
            notification('info', "Adding " + profiles.join(', ') + " to " + targetName);

            Fabric.addProfilesToContainer(jolokia, targetName, profiles, function () {
                notification('success', "Added " + profiles.join(', ') + " to " + targetName);
            }, function (response) {
                notification('error', "Failed to add " + profiles.join(', ') + " to " + targetName + " due to " + response.error);
            });
        };

        $scope.removeActiveProfiles = function () {
            $scope.selectedActiveProfiles.each(function (profile) {
                $scope.removeActiveProfile(profile);
            });
        };

        $scope.removeActiveProfile = function (profile) {
            if ($scope.selectedContainers.length > 0) {
                $scope.selectedContainers.each(function (container) {
                    if (container.profileIds.some(profile.id) && container.versionId === profile.versionId) {
                        $scope.removeProfile(container.id, profile.id);
                    }
                });
            } else {
                $scope.removeProfile($scope.activeContainerId, profile.id);
            }
        };

        $scope.removeProfile = function (containerId, profileId) {
            notification('info', "Removing " + profileId + " from " + containerId);

            Fabric.removeProfilesFromContainer(jolokia, containerId, [profileId], function () {
                notification('success', "Removed " + profileId + " from " + containerId);
            }, function (response) {
                notification('error', "Failed to remove " + profileId + " from " + containerId + " due to " + response.error);
            });
        };

        $scope.getFilteredName = function (item) {
            return item.versionId + " / " + item.id;
        };

        $scope.filterContainer = function (container) {
            if (!$scope.getFilteredName(container).has($scope.containerIdFilter)) {
                return false;
            }

            if ($scope.selectedActiveProfiles.length > 0) {
                if ($scope.selectedActiveProfiles.none(function (ap) {
                    //console.log("Checking ap: ", ap, " container: ", container);
                    return ap.versionId === container.versionId && container.profileIds.some(ap.id);
                })) {
                    return false;
                }
            }

            return true;
        };

        $scope.filterActiveProfile = function (profile) {
            if (!$scope.getFilteredName(profile).has($scope.activeProfileIdFilter)) {
                return false;
            }

            if ($scope.filterActiveVersion && $scope.activeVersionId && $scope.activeVersionId !== '' && profile.versionId !== $scope.activeVersionId) {
                return false;
            }

            if ($scope.selectedContainers.length > 0) {
                if ($scope.selectedContainers.none(function (c) {
                    return c.versionId === profile.versionId && c.profileIds.some(profile.id);
                })) {
                    return false;
                }
            }

            if ($scope.activeContainerId && $scope.activeContainerId !== '') {
                if ($scope.activeContainerVersion && $scope.activeContainerVersion !== '' && $scope.activeContainerVersion !== profile.versionId) {
                    return false;
                }
                if (!profile.containers.some($scope.activeContainerId)) {
                    return false;
                }
            }
            return true;
        };

        $scope.showMigrateButton = function () {
            return $scope.selectedContainers.length > 0 && $scope.activeVersionId && $scope.activeVersionId !== '';
        };

        $scope.applyVersionToContainers = function () {
            $scope.selectedContainers.each(function (c) {
                $scope.migrateVersion(c.id, $scope.activeVersionId);
            });
        };

        $scope.showProfileAddButton = function () {
            return $scope.selectedProfiles.length > 0 && $scope.selectedContainers.length > 0 && $scope.selectedContainers.every(function (c) {
                return c.versionId === $scope.activeVersionId;
            });
        };

        $scope.addProfilesToContainers = function () {
            var profileIds = $scope.selectedProfiles.map(function (p) {
                return p.id;
            });

            $scope.selectedContainers.each(function (c) {
                $scope.addProfiles(c.id, profileIds);
            });
        };

        $scope.versionCanBeDeleted = function () {
            return $scope.containers.none(function (c) {
                return c.versionId === $scope.activeVersionId;
            });
        };

        $scope.profilesCanBeDeleted = function () {
            var possibleMatches = $scope.containers.filter(function (c) {
                return c.versionId === $scope.activeVersionId;
            });

            if (possibleMatches.length === 0) {
                return true;
            }

            possibleMatches = possibleMatches.filter(function (c) {
                return $scope.selectedProfiles.some(function (p) {
                    return c.profileIds.some(p.id);
                });
            });

            if (possibleMatches.length === 0) {
                return true;
            }
            return false;
        };

        $scope.getSelectedProfileIds = function () {
            return $scope.getIds($scope.selectedProfiles);
        };

        $scope.getSelectedContainerIds = function () {
            return $scope.getIds($scope.selectedContainers);
        };

        $scope.getIds = function (arr) {
            return arr.map(function (o) {
                return o.id;
            });
        };

        $scope.containersForVersion = function (id) {
            var count = $scope.containers.findAll(function (container) {
                return container.versionId === id;
            }).length;
            if (count === 0) {
                return '';
            }
            return "(" + count + ")";
        };

        $scope.containersForProfile = function (id) {
            var profile = $scope.currentActiveProfiles().find(function (profile) {
                return profile.versionId === $scope.activeVersionId && profile.id === id;
            });
            if (profile) {
                return "(" + profile.count + ")";
            } else {
                return "";
            }
        };

        $scope.isSelectedVersion = function (id) {
            if ($scope.activeVersionId === id) {
                return 'selected';
            }
            return '';
        };

        $scope.getSelectedClass = function (obj) {
            var answer = [];
            if (obj.selected) {
                answer.push('selected');
            }
            if (angular.isDefined(obj['root']) && obj['root'] === false) {
                answer.push('child-container');
            }
            return answer.join(' ');
        };

        $scope.setActiveVersionId = function (id) {
            $scope.activeVersionId = id;
        };

        $scope.showProfile = function (profile) {
            if (angular.isDefined(profile.versionId)) {
                Fabric.gotoProfile(workspace, jolokia, localStorage, $location, profile.versionId, profile);
            } else {
                Fabric.gotoProfile(workspace, jolokia, localStorage, $location, $scope.activeVersionId, profile);
            }
        };
    }
    Fabric.FabricViewController = FabricViewController;
})(Fabric || (Fabric = {}));
var Fabric;
(function (Fabric) {
    function ClusterController($scope, $location, $routeParams, workspace, jolokia) {
        $scope.path = $routeParams["page"] || "/";
        if (!$scope.path.startsWith("/")) {
            $scope.path = "/" + $scope.path;
        }

        $scope.gridOptions = {
            data: 'children',
            displayFooter: false,
            sortInfo: { fields: ['name'], directions: ['asc'] },
            columnDefs: [
                {
                    field: 'name',
                    displayName: 'Name',
                    cellTemplate: '<div class="ngCellText"><a href="{{childLink(row.entity)}}"><i class="{{row | fileIconClass}}"></i> {{row.getProperty(col.field)}}</a></div>',
                    cellFilter: ""
                }
            ]
        };

        $scope.isTabActive = function (href) {
            var tidy = Core.trimLeading(href, "#");
            var loc = $location.path();
            return loc === tidy;
        };

        $scope.childLink = function (child) {
            var prefix = "#/fabric/clusters/" + Core.trimLeading($scope.path, "/") + "/";
            var postFix = "";
            var path = child.name;
            return Core.createHref($location, prefix + path + postFix);
        };

        $scope.$watch('workspace.tree', function () {
            setTimeout(updateView, 50);
        });

        $scope.$on("$routeChangeSuccess", function (event, current, previous) {
            // lets do this asynchronously to avoid Error: $digest already in progress
            setTimeout(updateView, 50);
        });

        updateView();

        function updateView() {
            loadBreadcrumbs();

            var mbean = Fabric.getZooKeeperFacadeMBean(workspace);
            if (mbean) {
                jolokia.execute(mbean, "read", $scope.path, onSuccess(onContents));
            }
        }

        function onContents(contents) {
            // for now it returns just lists of names
            $scope.children = [];
            $scope.stringData = null;
            $scope.html = null;
            if (contents) {
                angular.forEach(contents.children, function (childName) {
                    $scope.children.push({ name: childName });
                });
                if (!$scope.children.length) {
                    var stringData = contents.stringData;
                    if (stringData) {
                        $scope.stringData = stringData;
                        var json = Core.tryParseJson(stringData);
                        if (json) {
                            $scope.html = Core.valueToHtml(json);
                        } else {
                            // TODO detect properties files
                            $scope.html = stringData;
                        }
                    }
                }
            }
            Core.$apply($scope);
        }

        function loadBreadcrumbs() {
            var href = "#/fabric/clusters";
            $scope.breadcrumbs = [
                { href: href + "/", name: "/" }
            ];
            var path = $scope.path;
            var array = path ? path.split("/") : [];
            angular.forEach(array, function (name) {
                if (name) {
                    if (!name.startsWith("/") && !href.endsWith("/")) {
                        href += "/";
                    }
                    href += name;
                    $scope.breadcrumbs.push({ href: href, name: name });
                }
            });
        }
    }
    Fabric.ClusterController = ClusterController;
})(Fabric || (Fabric = {}));
var Fabric;
(function (Fabric) {
    var ProfileDetails = (function () {
        function ProfileDetails() {
            this.restrict = 'A';
            this.replace = true;
            this.templateUrl = Fabric.templatePath + "profileDetailsDirective.html";
            this.scope = {
                versionId: '=',
                profileId: '='
            };
            this.controller = function ($scope, $element, $attrs, $routeParams, jolokia, $location, workspace, $q) {
                $scope.inDirective = true;

                Fabric.ProfileController($scope, $routeParams, jolokia, $location, workspace, $q);
            };
        }
        return ProfileDetails;
    })();
    Fabric.ProfileDetails = ProfileDetails;
})(Fabric || (Fabric = {}));
var Fabric;
(function (Fabric) {
    function CreateContainerController($scope, $element, $compile, $location, workspace, jolokia, localStorage, userDetails) {
        var log = Logger.get("Fabric");

        $scope.versionsOp = 'versions()';

        $scope.entity = {
            // default options
            number: 1,
            saveJmxCredentials: true
        };

        // the form properties stored in local storage
        // which we then default when creating a new container
        var localStorageProperties = {
            child: {},
            openshift: {
                serverUrl: 'openshift.serverUrl',
                domain: 'openshift.domain',
                gearProfile: 'openshift.gearProfile'
            },
            jclouds: {
                owner: 'jclouds.owner',
                credential: 'jclouds.credential',
                providerName: 'jclouds.providerName',
                imageId: 'jclouds.imageId',
                hardwareId: 'jclouds.hardwareId',
                locationId: 'jclouds.locationId',
                group: 'jclouds.group',
                instanceType: 'jclouds.instanceType'
            }
        };

        $scope.providers = Fabric.registeredProviders(jolokia);

        //console.log("providers: ", $scope.providers);
        $scope.selectedProvider = $scope.providers[Object.extended($scope.providers).keys().first()];
        $scope.resolvers = [];
        $scope.schema = {};

        $scope.response = {};

        $scope.versions = [];
        $scope.profiles = [];

        $scope.selectedVersion = {};

        $scope.selectedProfiles = [];
        $scope.selectedProfileIds = '';
        $scope.selectedVersionId = '';
        $scope.profileIdFilter = '';

        // referenced static data for child
        $scope.child = {
            rootContainers: []
        };

        // referenced static data for openshift
        $scope.openShift = {
            loginDataKey: "openshift.loginData",
            params: null,
            domains: [],
            gearProfiles: [],
            tryLogin: "",
            login: function () {
                var entity = $scope.entity;
                var serverUrl = Core.pathGet(entity, ["serverUrl"]) || "openshift.redhat.com";
                var login = Core.pathGet(entity, ["login"]);
                var password = Core.pathGet(entity, ["password"]);

                log.debug("Invoking login to server " + serverUrl + " user " + login);
                $scope.openShift.loginFailed = false;
                if (serverUrl && login && password) {
                    $scope.openShift.domains = [];
                    Fabric.getOpenShiftDomains(workspace, jolokia, serverUrl, login, password, function (results) {
                        $scope.openShift.domains = results;
                        log.debug("found openshift domains: " + results);

                        // lets default the value if there's only 1
                        if (results.length === 1) {
                            $scope.entity.domain = results[0];
                        }
                        Core.$apply($scope);

                        Fabric.getOpenShiftGearProfiles(workspace, jolokia, serverUrl, login, password, function (results) {
                            $scope.openShift.gearProfiles = results;
                            log.debug("found openshift gears: " + $scope.openShift.gearProfiles);

                            // save these in-memory
                            Fabric.OpenShiftCredentials.username = login;
                            Fabric.OpenShiftCredentials.password = password;

                            // now lets store the current settings so they can be defaulted next time without a login
                            savePropertiesInLocalStorage();
                            var loginData = {
                                domains: $scope.openShift.domains,
                                gearProfiles: $scope.openShift.gearProfiles
                            };
                            localStorage[$scope.openShift.loginDataKey] = angular.toJson(loginData);
                            Core.$apply($scope);
                        });
                    }, function (error) {
                        $scope.openShift.loginFailed = true;
                        Core.$apply($scope);
                    });
                }
            }
        };

        // referenced static data for jclouds
        $scope.jclouds = {};

        // holds all the form objects from nested child scopes
        $scope.forms = {};

        $scope.showAddProfileDialog = false;

        $scope.$watch('selectedProvider', function (newValue, oldValue) {
            if ($scope.selectedProvider) {
                Fabric.getSchema($scope.selectedProvider.id, $scope.selectedProvider.className, jolokia, function (schema) {
                    $scope.schema = schema;
                    $scope.resolvers = Fabric.getResolvers($scope.selectedProvider.id);
                    Core.$apply($scope);
                });
            }
        }, true);

        $scope.$watch('schema', function (newValue, oldValue) {
            if (newValue !== oldValue) {
                $scope.entity['providerType'] = $scope.selectedProvider.id;
                $location.search('tab', $scope.selectedProvider.id);

                var providerId = $scope.entity['providerType'];
                var properties = localStorageProperties[providerId];

                // e.g. key = jmxUser, value = fabric.userName
                //
                //    $scope.entity['jmxUser'] = localStorage['fabric.userName'];
                //    $scope.entity['jmxPassword'] = localStorage['fabric.password'];
                angular.forEach(properties, function (value, key) {
                    var localValue = localStorage[value];
                    if (localValue) {
                        $scope.entity[key] = localValue;
                        log.debug("Defaulted entity " + key + " to " + localValue + " from localStorage");
                    }
                });

                if (providerId === "openshift") {
                    Core.pathSet($scope.entity, ['login'], Fabric.OpenShiftCredentials.username);
                    Core.pathSet($scope.entity, ['password'], Fabric.OpenShiftCredentials.password);
                    var loginDataText = localStorage[$scope.openShift.loginDataKey];
                    if (loginDataText) {
                        log.debug("Loaded openshift login details: " + loginDataText);
                        var loginData = Wiki.parseJson(loginDataText);
                        if (loginData) {
                            angular.forEach(["domains", "gearProfiles"], function (key) {
                                var value = loginData[key];

                                // assume all non-empty arrays for n ow
                                if (value && angular.isArray(value) && value.length) {
                                    $scope.openShift[key] = value;
                                }
                            });
                        }
                    }
                }

                Forms.defaultValues($scope.entity, $scope.schema);

                if ($scope.selectedProvider.id === 'child') {
                    // load the root containers and default the parent if its not set
                    var rootContainers = Fabric.getRootContainers(jolokia);
                    $scope.child.rootContainers = rootContainers;
                    if (rootContainers && rootContainers.length === 1 && !$scope.entity["parent"]) {
                        $scope.entity["parent"] = rootContainers[0];
                    }

                    // Use the current user's credentials
                    Core.pathSet($scope.entity, ['jmxUser'], userDetails.username);
                    Core.pathSet($scope.entity, ['jmxPassword'], userDetails.password);
                } else {
                    if ('parent' in $scope.entity) {
                        delete $scope.entity["parent"];
                    }
                }

                // updates autofilled fields
                window.setTimeout(function () {
                    $('input[ng-model]').trigger('input');
                }, 100);
            }
        }, true);

        $scope.$watch('versions', function (newValue, oldValue) {
            if (newValue !== oldValue) {
                if (!$scope.selectedVersion) {
                    if ($scope.selectedVersionId !== '') {
                        $scope.selectedVersion = $scope.versions.find(function (v) {
                            return v.id === $scope.selectedVersionId;
                        });
                    } else {
                        $scope.selectedVersion = $scope.versions.find(function (v) {
                            return v.defaultVersion;
                        });
                    }
                }
            }
        });

        $scope.$watch('selectedVersion', function (newValue, oldValue) {
            if (oldValue !== newValue) {
                if (newValue && 'id' in newValue) {
                    $scope.selectedVersionId = newValue['id'];
                    $location.search('versionId', $scope.selectedVersionId);
                }
            }
        }, true);

        $scope.deselect = function (profile) {
            profile.selected = false;
            $scope.selectedProfiles.remove(function (p) {
                return p.id === profile.id;
            });
        };

        $scope.$watch('selectedProfiles', function (newValue, oldValue) {
            if (oldValue !== newValue) {
                log.debug("selectedProfiles: ", $scope.selectedProfiles);
                if ($scope.selectedProfiles.length > 0) {
                    $scope.selectedProfileIds = $scope.selectedProfiles.map(function (p) {
                        return p.id;
                    }).join(',');
                } else {
                    $scope.selectedProfileIds = "";
                }
                log.debug("selectedProfileIds: ", $scope.selectedProfileIds);
            }
        }, true);

        $scope.$watch('selectedProfileIds', function (newValue, oldValue) {
            if (Core.isBlank($scope.selectedProfileIds)) {
                $scope.selectedProfiles.length = 0;
                return;
            } else {
                var profileIds = $scope.selectedProfileIds.split(',');
                var selected = [];
                profileIds.each(function (id) {
                    selected.push({
                        id: id,
                        selected: true
                    });
                });
                $scope.selectedProfiles = selected;
            }
            $location.search('profileIds', $scope.selectedProfileIds);
        });

        $scope.massage = function (str) {
            if (str === 'name') {
                return 'containerName';
            }
            return str;
        };

        $scope.rootContainers = function () {
            return Fabric.getRootContainers(jolokia);
        };

        $scope.init = function () {
            var tab = $location.search()['tab'];
            if (tab) {
                $scope.selectedProvider = $scope.providers[tab];
            }

            var parentId = $location.search()['parentId'];
            if (parentId) {
                $scope.entity['parent'] = parentId;
            }

            var versionId = $location.search()['versionId'];
            if (versionId) {
                $scope.selectedVersion = {
                    id: versionId
                };
            }

            var profileIds = $location.search()['profileIds'];
            if (profileIds) {
                $scope.selectedProfileIds = profileIds;
            }

            var count = $location.search()['number'];
            if (count) {
                $scope.entity.number = count;
            }
        };

        $scope.init();

        $scope.$on('$routeUpdate', $scope.init);

        /**
        * Saves the provider specific properties into localStorage; called on a succesful submit
        * or on a Login in the form so we remember the last successful login attempt.
        */
        function savePropertiesInLocalStorage() {
            var providerId = $scope.entity['providerType'];
            var properties = localStorageProperties[providerId];

            angular.forEach(properties, function (value, key) {
                var entityValue = $scope.entity[key];
                if (entityValue) {
                    localStorage[value] = entityValue;
                }
            });
        }

        $scope.onSubmit = function (json, form) {
            var providerId = $scope.entity['providerType'];

            // remove possibly dodgy values if they are blank
            json = Fabric.sanitizeJson(json);

            if (json.number === 1) {
                delete json.number;
            }

            var selectedVersion = $scope.selectedVersion;
            if (selectedVersion) {
                json['version'] = selectedVersion.id;
            }
            if ($scope.selectedProfiles.length > 0) {
                json['profiles'] = $scope.selectedProfiles.map(function (p) {
                    return p.id;
                });
            }

            setTimeout(function () {
                jolokia.execute(Fabric.managerMBean, 'createContainers(java.util.Map)', angular.toJson(json), {
                    method: "post",
                    success: function (response) {
                        log.debug("Response from creating container(s): ", response);
                        var error = false;
                        if ('<not available>' in response) {
                            var message = response['<not available>'];
                            if (message.toLowerCase().has('exception')) {
                                error = true;
                                var cont = "container";
                                if (json.number) {
                                    cont = Core.maybePlural(json.number, "container");
                                }
                                notification('error', "Creating " + cont + " failed: " + message);
                            }
                        }

                        // check for error if a container already exists with that name
                        var text = response[json.name];
                        if (text && text.toLowerCase().has('already exists')) {
                            error = true;
                            notification('error', "Creating container " + json.name + " failed as a container with that name already exists.");
                        }

                        angular.forEach(response.value, function (value, key) {
                            error = true;
                            notification('error', "Creating container " + key + " failed: " + value);
                        });
                        if (!error) {
                            notification('success', "Successfully created containers");
                        }
                        Core.$apply($scope);
                    },
                    error: function (response) {
                        notification('error', "Error creating containers: " + response.error);
                        Core.$apply($scope);
                    }
                });
                Core.$apply($scope);
            }, 10);

            //notification('info', "Requesting that new container(s) be created");
            $location.url('/fabric/containers');
        };
    }
    Fabric.CreateContainerController = CreateContainerController;
})(Fabric || (Fabric = {}));
var Fabric;
(function (Fabric) {
    function AssignProfileController($scope, jolokia, $location, $routeParams, workspace) {
        $scope.profileId = $routeParams['pid'];
        $scope.versionId = $routeParams['vid'];

        Fabric.initScope($scope, $location, jolokia, workspace);

        $scope.containerIdFilter = '';

        var valid = true;

        if (Core.isBlank($scope.profileId)) {
            Fabric.log.warn("No profile ID specified, redirecting to Fabric management view");
            valid = false;
        }

        if (Core.isBlank($scope.versionId)) {
            Fabric.log.warn("No version ID specified, redirecting to Fabric management view");
            valid = false;
        }

        if (!valid) {
            $location.path("/fabric/view");
        }

        $scope.gotoCreate = function () {
            $location.path('/fabric/containers/createContainer').search({
                versionId: $scope.versionId,
                profileIds: $scope.profileId
            });
        };

        $scope.$on('$routeChangeSuccess', function () {
            Fabric.log.debug("RouteParams: ", $routeParams);
            Fabric.log.debug("Scope: ", $scope);
        });

        $scope.$watch('containers', function (newValue, oldValue) {
            if (newValue !== oldValue && newValue) {
                $scope.selected = newValue.filter(function (c) {
                    return c['selected'];
                });
            }
        }, true);

        $scope.assignProfiles = function () {
            var requests = [];
            $scope.selected.forEach(function (c) {
                requests.push({
                    type: 'exec', mbean: Fabric.managerMBean,
                    operation: 'addProfilesToContainer',
                    arguments: [c.id, [$scope.profileId]]
                });
            });
            notification('info', "Applying " + $scope.profileId + " to the selected containers");
            var outstanding = requests.length;
            jolokia.request(requests, onSuccess(function () {
                outstanding = outstanding - 1;
                if (outstanding === 0) {
                    notification('success', "Applied " + $scope.profileId);
                    Core.$apply($scope);
                }
            }));
            setTimeout(function () {
                $location.path("/fabric/activeProfiles");
                Core.$apply($scope);
            }, 30);
        };
    }
    Fabric.AssignProfileController = AssignProfileController;
})(Fabric || (Fabric = {}));
var Fabric;
(function (Fabric) {
    function ProfilesController($scope, $location, workspace, jolokia) {
        Fabric.initScope($scope, $location, jolokia, workspace);

        $scope.defaultVersion = Fabric.getDefaultVersion(jolokia);
        $scope.version = { id: $scope.defaultVersion.id };

        $scope.selected = [];
        $scope.selectedParents = [];
        $scope.selectedParentVersion = [];

        $scope.deleteVersionDialog = false;
        $scope.deleteProfileDialog = false;

        $scope.createProfileDialog = false;
        $scope.createVersionDialog = false;

        $scope.triggerResize = function () {
            setTimeout(function () {
                $('.dialogGrid').trigger('resize');
            }, 10);
        };

        $scope.$watch('createProfileDialog', function () {
            if ($scope.createProfileDialog) {
                $scope.triggerResize();
            }
        });

        $scope.$watch('createVersionDialog', function () {
            if ($scope.createVersionDialog) {
                $scope.triggerResize();
            }
        });

        $scope.newProfileName = '';
        $scope.newVersionName = '';

        var key = $location.search()['pv'];
        if (key) {
            $scope.version = { id: key };
        }

        key = $location.search()['ao'];

        // lets default to activeOnly if no query parameter used
        $scope.activeOnly = !angular.isDefined(key) || key === 'true';

        $scope.versions = [];
        $scope.profiles = [];

        $scope.versionResponse = [];
        $scope.profilesResponse = [];

        $scope.$watch('activeOnly', function (oldValue, newValue) {
            if (oldValue === newValue) {
                return;
            }
            var q = $location.search();
            q['ao'] = "" + $scope.activeOnly;
            $location.search(q);
        });

        $scope.$watch('version', function (oldValue, newValue) {
            var q = $location.search();
            q['pv'] = $scope.version.id;
            $location.search(q);

            if (oldValue === newValue) {
                notification('info', "Please wait, fetching profile data for version " + $scope.version.id);
            }

            Core.unregister(jolokia, $scope);
            var versionId = $scope.version.id;
            if (versionId) {
                Core.register(jolokia, $scope, [
                    { type: 'exec', mbean: Fabric.managerMBean, operation: 'versions()' },
                    { type: 'exec', mbean: Fabric.managerMBean, operation: 'getProfiles(java.lang.String, java.util.List)', arguments: [versionId, ["id", "parentIds", "childIds", "containerCount", "locked", "abstract"]] }], onSuccess(render));
            }
        });

        $scope.selectedHasContainers = function () {
            return $scope.selected.findAll(function (item) {
                return item.containerCount > 0;
            }).length > 0;
        };

        $scope.versionCanBeDeleted = function () {
            if ($scope.version.id === $scope.defaultVersion.id) {
                return true;
            }
            if ($scope.versions.length === 0) {
                return true;
            }
            return $scope.profiles.findAll(function (item) {
                return item.containerCount > 0;
            }).length > 0;
        };

        $scope.createProfileGridOptions = {
            data: 'profiles',
            selectedItems: $scope.selectedParents,
            showSelectionCheckbox: true,
            multiSelect: true,
            selectWithCheckboxOnly: false,
            keepLastSelected: false,
            columnDefs: [{
                    field: 'id',
                    displayName: 'Name'
                }]
        };

        $scope.createVersionGridOptions = {
            data: 'versions',
            selectedItems: $scope.selectedParentVersion,
            showSelectionCheckbox: true,
            multiSelect: false,
            selectWithCheckboxOnly: false,
            keepLastSelected: false,
            columnDefs: [{
                    field: 'id',
                    displayName: 'Name'
                }]
        };

        $scope.gridOptions = {
            data: 'profiles',
            showFilter: false,
            showColumnMenu: false,
            filterOptions: {
                filterText: ''
            },
            selectedItems: $scope.selected,
            showSelectionCheckbox: true,
            multiSelect: true,
            selectWithCheckboxOnly: true,
            keepLastSelected: false,
            checkboxCellTemplate: '<div class="ngSelectionCell"><input tabindex="-1" class="ngSelectionCheckbox" type="checkbox" ng-checked="row.selected" ng-disabled="row.entity.containerCount > 0 || row.entity.childIds.length > 0"/></div>',
            columnDefs: [
                {
                    field: 'id',
                    displayName: 'Name',
                    cellTemplate: '<div class="ngCellText"><a ng-href="#/fabric/profile/{{$parent.version.id}}/{{row.getProperty(col.field)}}{{hash}}">{{row.getProperty(col.field)}}</a></div>',
                    width: 300
                },
                {
                    field: 'attributes',
                    displayName: 'A',
                    headerCellTemplate: '<div ng-click="col.sort()" class="ngHeaderSortColumn {{col.headerClass}}" ng-style="{\'cursor\': col.cursor}" ng-class="{ \'ngSorted\': !noSortVisible }"><div class="ngHeaderText colt{{$index}} pagination-centered" title="Attributes"><i class="icon-cogs"></i></div><div class="ngSortButtonDown" ng-show="col.showSortButtonDown()"></div><div class="ngSortButtonUp" ng-show="col.showSortButtonUp()"></div></div>',
                    cellTemplate: '<div class="ngCellText"><ul class="unstyled inline"><li class="attr-column"><i ng-show="row.entity.locked" title="Locked" class="icon-lock"></i></li><li class="attr-column"><i ng-show="row.entity.abstract" title="Abstract" class="icon-font"></i></li></ul></div>',
                    width: 52
                },
                {
                    field: 'containerCount',
                    displayName: 'C',
                    headerCellTemplate: '<div ng-click="col.sort()" class="ngHeaderSortColumn {{col.headerClass}}" ng-style="{\'cursor\': col.cursor}" ng-class="{ \'ngSorted\': !noSortVisible }"><div class="ngHeaderText colt{{$index}} pagination-centered" title="Containers"><i class="icon-truck"></i></div><div class="ngSortButtonDown" ng-show="col.showSortButtonDown()"></div><div class="ngSortButtonUp" ng-show="col.showSortButtonUp()"></div></div>',
                    cellTemplate: '<div class="ngCellText pagination-centered"><a ng-show="row.getProperty(col.field) > 0" title="{{row.entity.containers.sortBy().join(\'\n\')}}" href="#/fabric/containers?cv={{$parent.version.id}}&cp={{row.entity.id}}{{hash}}">{{row.getProperty(col.field)}}</a></div>',
                    width: 28
                },
                {
                    field: 'parentIds',
                    displayName: 'Parent Profiles',
                    cellTemplate: '<div class="ngCellText"><ul class="unstyled inline"><li ng-repeat="profile in row.entity.parentIds.sortBy()"><a href="#/fabric/profile/{{$parent.version.id}}/{{profile}}">{{profile}}</a></li></ul></div>',
                    width: 400
                },
                {
                    field: 'childIds',
                    displayName: 'Child Profiles',
                    cellTemplate: '<div class="ngCellText"><ul class="unstyled inline"><li ng-repeat="profile in row.entity.childIds.sortBy()"><a href="#/fabric/profile/{{$parent.version.id}}/{{profile}}">{{profile}}</a></li></ul></div>',
                    width: 800
                }
            ]
        };

        $scope.doCreateProfile = function () {
            $scope.createProfileDialog = false;
            var parents = $scope.selectedParents.map(function (profile) {
                return profile.id;
            });
            Fabric.createProfile(jolokia, $scope.version.id, $scope.newProfileName, parents, function () {
                notification('success', "Created profile " + $scope.newProfileName);
                $scope.newProfileName = "";
                Core.$apply($scope);
            }, function (response) {
                notification('error', "Failed to create profile " + $scope.newProfileName + " due to " + response.error);
            });
        };

        $scope.doCreateVersion = function () {
            $scope.createVersionDialog = false;

            var success = function (response) {
                notification('success', "Created version " + response.value.id);
                $scope.newVersionName = '';
                $scope.version = response.value;
                Core.$apply($scope);
            };

            var error = function (response) {
                var msg = "Error creating new version: " + response.error;
                if ($scope.newVersionName !== '') {
                    msg = "Error creating " + $scope.newVersionName + " : " + response.error;
                }
                notification('error', msg);
            };

            if ($scope.selectedParentVersion.length > 0 && $scope.newVersionName !== '') {
                Fabric.createVersionWithParentAndId(jolokia, $scope.selectedParentVersion[0].id, $scope.newVersionName, success, error);
            } else if ($scope.newVersionName !== '') {
                Fabric.createVersionWithId(jolokia, $scope.newVersionName, success, error);
            } else {
                Fabric.createVersion(jolokia, success, error);
            }
        };

        $scope.deleteVersion = function () {
            // avoid getting any not found errors while deleting the version
            Core.unregister(jolokia, $scope);

            Fabric.deleteVersion(jolokia, $scope.version.id, function () {
                notification('success', "Deleted version " + $scope.version.id);
                $scope.version = $scope.defaultVersion;
                Core.$apply($scope);
            }, function (response) {
                notification('error', "Failed to delete version " + $scope.version.id + " due to " + response.error);
                $scope.version = $scope.defaultVersion;
                Core.$apply($scope);
            });
        };

        $scope.deleteSelected = function () {
            $scope.selected.each(function (profile) {
                Fabric.deleteProfile(jolokia, $scope.version.id, profile.id, function () {
                    notification('success', "Deleted profile " + profile.id);
                }, function (response) {
                    notification('error', "Failed to delete profile " + profile.id + ' due to ' + response.error);
                });
            });
        };

        function filterActive(data) {
            var rc = data;
            if ($scope.activeOnly) {
                rc = data.filter(function (item) {
                    return item.containerCount > 0;
                });
            }
            return rc;
        }

        function render(response) {
            clearNotifications();

            if (response.request.operation === 'versions()') {
                if (!Object.equal($scope.versionResponse, response.value)) {
                    $scope.versionResponse = response.value;
                    $scope.versions = response.value.map(function (version) {
                        var v = {
                            id: version.id,
                            'defaultVersion': version.defaultVersion
                        };

                        if (v['defaultVersion']) {
                            $scope.defaultVersion = v;
                        }

                        return v;
                    });
                    $scope.version = Fabric.setSelect($scope.version, $scope.versions);

                    Core.$apply($scope);
                }
            } else {
                if (!Object.equal($scope.profilesResponse, response.value)) {
                    $scope.profilesResponse = response.value;
                    $scope.profiles = [];

                    $scope.profilesResponse.forEach(function (profile) {
                        $scope.profiles.push({
                            id: profile.id,
                            parentIds: profile.parentIds,
                            childIds: profile.childIds,
                            containerCount: profile.containerCount,
                            containers: profile.containers,
                            locked: profile.locked,
                            abstract: profile['abstract']
                        });
                    });

                    $scope.profiles = filterActive($scope.profiles);
                    Core.$apply($scope);
                }
            }
        }
    }
    Fabric.ProfilesController = ProfilesController;
})(Fabric || (Fabric = {}));
var Fabric;
(function (Fabric) {
    var ContainerList = (function () {
        function ContainerList() {
            this.restrict = 'A';
            this.replace = true;
            this.templateUrl = Fabric.templatePath + "containerList.html";
            this.scope = false;
            this.link = function ($scope, $element, $attrs) {
                $scope.showSelect = Core.parseBooleanValue(UI.getIfSet('showSelect', $attrs, 'true'));

                var atVersion = UI.getIfSet('atVersion', $attrs, null);
                var withoutProfile = UI.getIfSet('withoutProfile', $attrs, null);

                if (atVersion !== null) {
                    $scope.atVersion = $scope.$eval(atVersion);
                }

                if (withoutProfile !== null) {
                    $scope.withoutProfile = $scope.$eval(withoutProfile);
                }

                Fabric.log.debug("atVersion: ", $scope.atVersion);
                Fabric.log.debug("withoutProfile: ", $scope.withoutProfile);

                Fabric.log.debug("container list attributes: ", $attrs);
            };
        }
        ContainerList.prototype.controller = function ($scope, $element, $attrs, jolokia, $location, workspace, $templateCache) {
            $scope.containerArgs = ["id", "alive", "parentId", "profileIds", "versionId", "provisionResult", "jolokiaUrl", "root", 'jmxDomains'];
            $scope.profileFields = ["id", "hidden"];
            $scope.containersOp = 'containers(java.util.List, java.util.List)';
            $scope.ensembleContainerIdListOp = 'EnsembleContainers';

            $scope.containers = [];
            $scope.activeProfiles = [];
            $scope.selectedContainers = [];
            $scope.selectedContainerIds = [];
            $scope.showSelect = true;
            $scope.requirements = null;

            Fabric.initScope($scope, $location, jolokia, workspace);

            $scope.currentPage = $templateCache.get("addProfileRequirements");

            // for editing container requirements
            $scope.editRequirements = {
                dialog: new UI.Dialog(),
                excludeProfiles: [],
                selectedProfiles: [],
                excludeDependentProfiles: [],
                selectedDependentProfiles: [],
                addDependentProfileDialog: new UI.Dialog(),
                versionId: null,
                addProfileSelectShow: false,
                dialogOpen: function (profile) {
                    // lets make sure the requirements are pre-populated with values
                    var editRequirementsEntity = {
                        profileRequirements: []
                    };
                    if ($scope.requirements) {
                        angular.copy($scope.requirements, editRequirementsEntity);
                    }
                    var profileRequirements = editRequirementsEntity.profileRequirements;
                    if (profileRequirements) {
                        angular.forEach($scope.activeProfiles, function (profile) {
                            var currentRequirements = profile.requirements;
                            if (!currentRequirements) {
                                currentRequirements = {
                                    profile: profile.id
                                };
                                profile.requirements = currentRequirements;
                                profileRequirements.push(currentRequirements);
                            }
                        });
                    }
                    if (!profile && $scope.activeProfiles.length) {
                        // lets pick the first one - its just to default a version
                        profile = $scope.activeProfiles[0];
                    }
                    if (profile) {
                        $scope.editRequirements.versionId = profile.versionId;
                    }
                    $scope.editRequirements.entity = editRequirementsEntity;
                    $scope.editRequirements.dialog.open();
                },
                // show / hide the new dependent profiles on a profile requirement
                addDependentProfileDialogOpen: function (requirement) {
                    $scope.editRequirements.addDependentProfileDialogProfile = requirement.profile;
                    $scope.editRequirements.selectedDependentProfiles.splice(0, $scope.editRequirements.selectedDependentProfiles.length);
                    $scope.editRequirements.excludeDependentProfiles = [requirement.profile].concat(requirement.dependentProfiles || []);
                    $scope.editRequirements.addDependentProfilesToRequirement = requirement;
                    $scope.editRequirements.addDependentProfileDialogShow = true;
                },
                addDependentProfileDialogHide: function () {
                    $scope.editRequirements.addDependentProfileDialogShow = false;
                },
                addDependentProfileDialogApply: function () {
                    var requirement = $scope.editRequirements.addDependentProfilesToRequirement;
                    angular.forEach($scope.editRequirements.selectedDependentProfiles, function (profile) {
                        var id = profile.id;
                        if (id && requirement) {
                            if (!requirement.dependentProfiles)
                                requirement.dependentProfiles = [];
                            if (!requirement.dependentProfiles.find(id)) {
                                requirement.dependentProfiles.push(id);
                            }
                        }
                    });
                    $scope.editRequirements.addDependentProfileDialogHide();
                },
                // how / hide / add a requirement on new profile
                addProfileRequirementOpen: function () {
                    $scope.editRequirements.selectedProfiles.splice(0, $scope.editRequirements.selectedProfiles.length);
                    $scope.editRequirements.excludeProfiles = $scope.activeProfiles.map(function (p) {
                        return p.id;
                    });
                    $scope.editRequirements.addProfileRequirementShow = true;
                },
                addProfileRequirementHide: function () {
                    $scope.editRequirements.addProfileRequirementShow = false;
                },
                addProfileRequirementApply: function () {
                    var entity = $scope.editRequirements.entity;
                    var profileRequirements = entity.profileRequirements;
                    if (!profileRequirements) {
                        profileRequirements = [];
                        entity.profileRequirements = profileRequirements;
                    }
                    angular.forEach($scope.editRequirements.selectedProfiles, function (profile) {
                        var id = profile.id;
                        if (id) {
                            profileRequirements.push({ profile: id });
                        }
                    });
                    $scope.editRequirements.addProfileRequirementHide();
                }
            };

            $scope.getFilteredName = function (item) {
                return item.versionId + " / " + item.id;
            };

            $scope.filterContainer = function (container) {
                var filterText = $scope.containerIdFilter;
                if (filterText && !$scope.getFilteredName(container).has(filterText)) {
                    var profileIds = container.profileIds;
                    if (profileIds) {
                        return profileIds.any(function (id) {
                            return id.indexOf(filterText) >= 0;
                        });
                    }
                    return false;
                }
                return true;
            };

            $scope.$watch('editRequirements.addDependentProfileDialogShow', function (newValue, oldValue) {
                if (newValue !== oldValue) {
                    if (newValue) {
                        $scope.currentPage = $templateCache.get("addDependentProfile");
                    } else {
                        $scope.currentPage = $templateCache.get("addProfileRequirements");
                    }
                }
            });

            $scope.$watch('editRequirements.addProfileRequirementShow', function (newValue, oldValue) {
                if (newValue !== oldValue) {
                    if (newValue) {
                        $scope.currentPage = $templateCache.get("addProfileRequirement");
                    } else {
                        $scope.currentPage = $templateCache.get("addProfileRequirements");
                    }
                }
            });

            $scope.updateActiveContainers = function () {
                var activeProfiles = $scope.activeProfiles;
                $scope.activeProfiles = $scope.currentActiveProfiles();
                $scope.activeProfiles.each(function (activeProfile) {
                    var ap = activeProfiles.find(function (ap) {
                        return ap.id === activeProfile.id && ap.versionId === activeProfile.versionId;
                    });
                    if (ap) {
                        activeProfile['selected'] = ap.selected;
                        activeProfile['expanded'] = ap.expanded;
                    } else {
                        activeProfile['selected'] = false;
                        activeProfile['expanded'] = false;
                    }
                });
            };

            $scope.updateContainers = function (newContainers) {
                var response = angular.toJson(newContainers);
                if ($scope.containersResponse !== response) {
                    $scope.containersResponse = response;

                    newContainers = newContainers.sortBy('id');

                    var rootContainers = newContainers.exclude(function (c) {
                        return !c.root;
                    });
                    var childContainers = newContainers.exclude(function (c) {
                        return c.root;
                    });

                    if (childContainers.length > 0) {
                        var tmp = [];
                        rootContainers.each(function (c) {
                            tmp.add(c);
                            var children = childContainers.exclude(function (child) {
                                return child.parentId !== c.id;
                            });
                            tmp.add(children);
                        });
                        newContainers = tmp;
                    }

                    if (angular.isDefined($scope.atVersion)) {
                        newContainers = newContainers.filter(function (c) {
                            return c.versionId === $scope.atVersion;
                        });
                    }

                    if (angular.isDefined($scope.withoutProfile)) {
                        newContainers = newContainers.filter(function (c) {
                            return !c.profileIds.any(function (p) {
                                return p === $scope.withoutProfile;
                            });
                        });
                    }

                    newContainers.each(function (container) {
                        container.services = Fabric.getServiceList(container);
                        var c = $scope.containers.find(function (c) {
                            return c.id === container.id;
                        });
                        if (c) {
                            container['selected'] = c.selected;
                        } else {
                            container['selected'] = false;
                        }
                        if ($scope.selectedContainerIds.any(container.id)) {
                            container.selected = true;
                        }
                    });

                    $scope.containers = newContainers;
                    $scope.updateActiveContainers();
                    Core.$apply($scope);
                }
            };

            $scope.currentActiveProfiles = function () {
                var answer = [];

                $scope.containers.each(function (container) {
                    container.profileIds.each(function (profile) {
                        var p = container.profiles.find(function (p) {
                            return p.id === profile;
                        });
                        if (p && p.hidden) {
                            return;
                        }

                        var activeProfile = answer.find(function (o) {
                            return o.versionId === container.versionId && o.id === profile;
                        });

                        if (activeProfile) {
                            activeProfile['containers'] = activeProfile['containers'].include(container.id).unique();

                            activeProfile.count = activeProfile['containers'].length;
                        } else {
                            answer.push({
                                id: profile,
                                count: 1,
                                versionId: container.versionId,
                                containers: [container.id],
                                selected: false,
                                requirements: null,
                                requireStyle: null
                            });
                        }
                    });
                });

                if ($scope.requirements) {
                    angular.forEach($scope.requirements.profileRequirements, function (profileRequirement) {
                        var id = profileRequirement.profile;
                        var min = profileRequirement.minimumInstances;
                        if (id) {
                            var profile = answer.find(function (p) {
                                return p.id;
                            });

                            function requireStyle() {
                                var count = 0;
                                if (profile) {
                                    count = profile['count'];
                                }
                                return Fabric.containerCountBadgeStyle(min, count);
                            }

                            if (profile) {
                                profile["requirements"] = profileRequirement;
                                profile["requireStyle"] = requireStyle();
                            } else {
                                // lets add the profile with no containers
                                answer.push({
                                    id: id,
                                    count: 0,
                                    versionId: $scope.requirements.version || "1.0",
                                    containers: [],
                                    selected: false,
                                    requirements: profileRequirement,
                                    requireStyle: requireStyle()
                                });
                            }
                        }
                    });
                }

                return answer;
            };

            $scope.updateEnsembleContainerIdList = function (ids) {
                var response = angular.toJson(ids);
                if ($scope.ensembleContainerIdsResponse !== response) {
                    $scope.ensembleContainerIdsResponse = response;
                    $scope.ensembleContainerIds = ids;
                    Core.$apply($scope);
                }
            };

            $scope.dispatch = function (response) {
                switch (response.request.operation) {
                    case ($scope.containersOp):
                        $scope.updateContainers(response.value);
                        return;
                }
                switch (response.request.attribute) {
                    case ($scope.ensembleContainerIdListOp):
                        $scope.updateEnsembleContainerIdList(response.value);
                        return;
                }
            };

            $scope.clearSelection = function (group) {
                group.each(function (item) {
                    item.selected = false;
                });
            };

            $scope.setActiveProfile = function (profile) {
                $scope.clearSelection($scope.activeProfiles);
                if (!profile || profile === null) {
                    return;
                }
                profile.selected = true;
            };

            $scope.selectAllContainers = function () {
                $scope.containers.each(function (container) {
                    if ($scope.filterContainer(container)) {
                        container.selected = true;
                    }
                });
            };

            $scope.setActiveContainer = function (container) {
                $scope.clearSelection($scope.containers);
                if (!container || container === null) {
                    return;
                }
                container.selected = true;
            };

            $scope.startSelectedContainers = function () {
                $scope.selectedContainers.each(function (c) {
                    $scope.startContainer(c.id);
                });
            };

            $scope.stopSelectedContainers = function () {
                $scope.selectedContainers.each(function (c) {
                    $scope.stopContainer(c.id);
                });
            };

            $scope.startContainer = function (name) {
                Fabric.doStartContainer($scope, jolokia, name);
            };

            $scope.stopContainer = function (name) {
                Fabric.doStopContainer($scope, jolokia, name);
            };

            $scope.anySelectionAlive = function (state) {
                var selected = $scope.selectedContainers;
                return selected.length > 0 && selected.any(function (s) {
                    return s.alive === state;
                });
            };

            $scope.everySelectionAlive = function (state) {
                var selected = $scope.selectedContainers;
                return selected.length > 0 && selected.every(function (s) {
                    return s.alive === state;
                });
            };

            Core.register(jolokia, $scope, [
                { type: 'exec', mbean: Fabric.managerMBean, operation: $scope.containersOp, arguments: [$scope.containerArgs, $scope.profileFields] },
                { type: 'read', mbean: Fabric.clusterManagerMBean, attribute: $scope.ensembleContainerIdListOp }
            ], onSuccess($scope.dispatch, { silent: true }));
        };
        return ContainerList;
    })();
    Fabric.ContainerList = ContainerList;

    var ActiveProfileList = (function (_super) {
        __extends(ActiveProfileList, _super);
        function ActiveProfileList() {
            _super.apply(this, arguments);
            this.templateUrl = Fabric.templatePath + "activeProfileList.html";
        }
        ActiveProfileList.prototype.controller = function ($scope, $element, $attrs, jolokia, $location, workspace, $templateCache) {
            _super.prototype.controller.call(this, $scope, $element, $attrs, jolokia, $location, workspace, $templateCache);

            $scope.searchFilter = '';

            $scope.isOpen = function (profile) {
                if ($scope.searchFilter !== '') {
                    return "opened";
                }
                return "closed";
            };

            $scope.containersForProfile = function (id) {
                return $scope.containers.filter(function (container) {
                    return container.profileIds.some(id);
                });
            };

            $scope.profileMatchesFilter = function (profile) {
                return profile.id.has($scope.searchFilter) || !profile.containers.filter(function (id) {
                    return id.has($scope.searchFilter);
                }).isEmpty();
            };

            $scope.containerMatchesFilter = function (container) {
                return container.id.has($scope.searchFilter) || !container.profileIds.filter(function (id) {
                    return id.has($scope.searchFilter);
                }).isEmpty();
            };

            $scope.updateRequirements = function (requirements) {
                function onRequirementsSaved(response) {
                    $scope.requirements = requirements;
                    notification("success", "Updated the requirements");
                    $scope.updateActiveContainers();
                    Core.$apply($scope);
                }
                ;

                if (requirements) {
                    $scope.editRequirements.dialog.close();

                    var json = JSON.stringify(requirements);
                    jolokia.execute(Fabric.managerMBean, "requirementsJson", json, onSuccess(onRequirementsSaved));
                }
            };

            function onRequirements(response) {
                var responseJson = angular.toJson(response.value);

                if (responseJson !== $scope.requirementsResponse) {
                    $scope.requirementsResponse = responseJson;
                    $scope.requirements = response.value;
                    $scope.updateActiveContainers();
                    Core.$apply($scope);
                }
            }

            Core.register(jolokia, $scope, { type: 'exec', mbean: Fabric.managerMBean, operation: "requirements()" }, onSuccess(onRequirements));
        };
        return ActiveProfileList;
    })(Fabric.ContainerList);
    Fabric.ActiveProfileList = ActiveProfileList;
})(Fabric || (Fabric = {}));
var Fabric;
(function (Fabric) {
    function ProfileController($scope, $routeParams, jolokia, $location, workspace, $q) {
        Fabric.initScope($scope, $location, jolokia, workspace);

        $scope.loading = true;

        $scope.mavenMBean = Maven.getMavenIndexerMBean(workspace);

        if (!angular.isDefined($scope.versionId)) {
            $scope.versionId = $routeParams.versionId;
        }
        if (!angular.isDefined($scope.profileId)) {
            $scope.profileId = $routeParams.profileId;
        }

        $scope.newFileDialog = false;
        $scope.deleteFileDialog = false;
        $scope.newFileName = '';
        $scope.markedForDeletion = '';

        $scope.newProfileName = '';
        $scope.deleteThingDialog = false;
        $scope.changeParentsDialog = false;
        $scope.removeParentDialog = false;
        $scope.newThingName = '';
        $scope.selectedParents = [];

        $scope.profilePath = Fabric.profilePath;
        $scope.pageId = Fabric.fabricTopLevel + Fabric.profilePath($scope.profileId);

        var versionId = $scope.versionId;
        var profileId = $scope.profileId;
        if (versionId && versionId) {
            Fabric.profileJolokia(jolokia, profileId, versionId, function (profileJolokia) {
                $scope.profileJolokia = profileJolokia;
            });
        }

        if ($scope.inDirective && angular.isDefined($scope.$parent.childActions) && $scope.versionId) {
            var actions = $scope.$parent.childActions;

            if ($scope.profileId) {
                actions.push({
                    doAction: function () {
                        $scope.showChangeParentsDialog();
                    },
                    title: "Edit parent profiles",
                    icon: "icon-edit",
                    name: "Change Parents"
                });
                actions.push({
                    doAction: function () {
                        $scope.copyProfileDialog = true;
                    },
                    title: "Copy Profile",
                    icon: "icon-copy",
                    name: "Copy Profile"
                });
                actions.push({
                    doAction: function () {
                        $scope.goto('/wiki/profile/' + $scope.versionId + '/' + $scope.profileId + '/editFeatures');
                    },
                    title: "Edit the features defined in this profile",
                    icon: "icon-edit",
                    name: "Edit Features"
                });
                actions.push({
                    doAction: function () {
                        $location.url('/fabric/assignProfile').search({
                            vid: $scope.versionId,
                            pid: $scope.profileId
                        });
                    },
                    title: "Assign profile to existing containers",
                    icon: "icon-truck",
                    name: "Assign to Container"
                });
                actions.push({
                    doAction: function () {
                        $location.url('/fabric/containers/createContainer').search({
                            versionId: $scope.versionId,
                            profileIds: $scope.profileId
                        });
                    },
                    title: "Create a new container with this profile",
                    icon: "icon-truck",
                    name: "New Container"
                });
            }
            /*
            var createVersionDialog = $scope.createVersionDialog;
            if (createVersionDialog) {
            actions.push({
            doAction: () => {
            $scope.createVersionDialog.open();
            },
            title: "Create a new version of this configuration so you can edit it and then perform rolling upgrades",
            icon: "icon-plus",
            name: "New Version"
            });
            }
            */
        }

        $scope.$watch('activeTab', function (newValue, oldValue) {
            if (newValue !== oldValue) {
                $scope.newThingName = '';
            }
        });

        $scope.$watch('versionId', function (newValue, oldValue) {
            if (angular.isDefined($scope.versionId) && angular.isDefined($scope.profileId)) {
                $scope.doRegister();
            }
        });

        $scope.$watch('profileId', function (newValue, oldValue) {
            if (angular.isDefined($scope.versionId) && angular.isDefined($scope.profileId)) {
                $scope.doRegister();
            }
        });

        // TODO, should complete URL handlers too
        $scope.doCompletionFabric = function (something) {
            if (something.startsWith("mvn:")) {
                $scope.prefix = "mvn:";
                return Maven.completeMavenUri($q, $scope, workspace, jolokia, something.from(4));
            }
            $scope.prefix = "";
            return $q.when([]);
        };

        $scope.uriParts = [];

        $scope.$watch('newThingName', function (newValue, oldValue) {
            if (newValue !== oldValue) {
                $scope.uriParts = newValue.split("/");
            }
        });

        $scope.$watch('uriParts', function (newValue, oldValue) {
            if (newValue !== oldValue) {
                if (!$scope.prefix || $scope.prefix === '') {
                    return;
                }
                if (newValue && newValue.length > 0 && !newValue.first().startsWith($scope.prefix)) {
                    /*
                    console.log("newValue: ", newValue);
                    console.log("oldValue: ", oldValue);
                    console.log("prefix: ", $scope.prefix);
                    */
                    if (newValue.first() === "" || newValue.first().length < $scope.prefix.length) {
                        return;
                    }
                    if (oldValue.length === 0) {
                        return;
                    }

                    // a completion occurred...
                    if (oldValue.length === 1) {
                        $scope.newThingName = $scope.prefix + newValue.first();
                    } else {
                        var merged = oldValue.first(oldValue.length - 1).include(newValue.first());
                        $scope.newThingName = merged.join('/');
                    }
                }
            }
        }, true);

        $scope.doRegister = function () {
            Core.unregister(jolokia, $scope);
            if ($scope.versionId && $scope.profileId && !$scope.versionId.isBlank() && !$scope.profileId.isBlank()) {
                Core.register(jolokia, $scope, {
                    type: 'exec', mbean: Fabric.managerMBean,
                    operation: 'getProfile(java.lang.String, java.lang.String)',
                    arguments: [$scope.versionId, $scope.profileId]
                }, onSuccess(render));
            }
        };

        $scope.showChangeParentsDialog = function () {
            $scope.selectedParents = $scope.row.parentIds.map(function (parent) {
                return {
                    id: parent,
                    selected: true
                };
            });
            $scope.changeParentsDialog = true;
        };

        $scope.removeParentProfile = function (parent) {
            $scope.markedForDeletion = parent;
            $scope.removeParentDialog = true;
        };

        $scope.doRemoveParentProfile = function () {
            var parents = $scope.row.parentIds.exclude($scope.markedForDeletion);
            Fabric.changeProfileParents(jolokia, $scope.versionId, $scope.profileId, parents, function () {
                notification('success', 'Removed parent profile ' + $scope.markedForDeletion + ' from ' + $scope.profileId);
                Core.$apply($scope);
            }, function (response) {
                notification('error', 'Failed to change parent profiles of ' + $scope.profileId + ' due to ' + response.error);
                Core.$apply($scope);
            });
        };

        $scope.changeAttribute = function (attribute, value) {
            jolokia.request({
                type: 'exec',
                method: 'post',
                mbean: Fabric.managerMBean,
                operation: 'setProfileAttribute',
                arguments: [$scope.versionId, $scope.profileId, attribute, value]
            }, {
                success: function () {
                    // TODO - we're secretly hiding that the ng-click event is firing twice...
                    // notification('success', "Set attribute " + attribute + " to " + value);
                    Core.$apply($scope);
                },
                error: function (response) {
                    console.log("Failed to set attribute " + attribute + " to " + value + " due to " + response.error);

                    // notification('error', "Failed to set attribute " + attribute + " to " + value + " due to " + response.error);
                    Core.$apply($scope);
                }
            });
        };

        $scope.doChangeParents = function () {
            $scope.changeParentsDialog = false;
            var parents = $scope.selectedParents.map(function (parent) {
                return parent.id;
            });
            Fabric.changeProfileParents(jolokia, $scope.versionId, $scope.profileId, parents, function () {
                notification('success', 'Successfully changed parent profiles of ' + $scope.profileId);
                Core.$apply($scope);
            }, function (response) {
                notification('error', 'Failed to change parent profiles of ' + $scope.profileId + ' due to ' + response.error);
                Core.$apply($scope);
            });
        };

        $scope.goto = function (location) {
            $location.url(location);
        };

        $scope.addNewThing = function (title, type, current) {
            if (Core.isBlank($scope.newThingName)) {
                return;
            }
            $scope.thingName = title;
            $scope.currentThing = current;
            $scope.currentThingType = type;
            $scope.doAddThing();
        };

        $scope.deleteThing = function (title, type, current, item) {
            $scope.thingName = title;
            $scope.currentThing = current;
            $scope.currentThingType = type;
            $scope.currentThingItem = item;
            $scope.deleteThingDialog = true;
        };

        $scope.updateThing = function (title, type, current) {
            $scope.thingName = title;
            $scope.currentThing = current;
            $scope.currentThingType = type;
            $scope.callSetProfileThing("Changed", "change", title);
        };

        $scope.mavenLink = function (url) {
            return Maven.mavenLink(url);
        };

        $scope.callSetProfileThing = function (success, error, thing) {
            jolokia.request({
                type: 'exec',
                mbean: Fabric.managerMBean,
                operation: "setProfile" + $scope.currentThingType + "(java.lang.String, java.lang.String, java.util.List)",
                arguments: [$scope.versionId, $scope.profileId, $scope.currentThing]
            }, {
                method: 'POST',
                success: function () {
                    notification('success', success + ' ' + thing);
                    $scope.newThingName = '';
                    Core.$apply($scope);
                },
                error: function (response) {
                    notification('error', 'Failed to ' + error + ' ' + thing + ' due to ' + response.error);
                    Core.$apply($scope);
                }
            });
        };

        $scope.doDeleteThing = function () {
            $scope.currentThing.remove($scope.currentThingItem);
            $scope.callSetProfileThing('Deleted', 'delete', $scope.currentThingItem);
        };

        $scope.doAddThing = function () {
            if (!$scope.currentThing.any($scope.newThingName)) {
                $scope.currentThing.push($scope.newThingName);
                $scope.addThingDialog = false;
                $scope.callSetProfileThing('Added', 'add', $scope.newThingName);
            } else {
                notification('error', 'There is already a ' + $scope.thingName + ' with the name ' + $scope.newThingName);
            }
        };

        $scope.deleteFile = function (file) {
            $scope.markedForDeletion = file;
            $scope.deleteFileDialog = true;
        };

        $scope.doDeleteFile = function () {
            $scope.deleteFileDialog = false;
            Fabric.deleteConfigFile(jolokia, $scope.versionId, $scope.profileId, $scope.markedForDeletion, function () {
                notification('success', 'Deleted file ' + $scope.markedForDeletion);
                $scope.markedForDeletion = '';
                Core.$apply($scope);
            }, function (response) {
                notification('error', 'Failed to delete file ' + $scope.markedForDeletion + ' due to ' + response.error);
                $scope.markedForDeletion = '';
                Core.$apply($scope);
            });
        };

        $scope.doCreateFile = function () {
            $scope.newFileDialog = false;
            Fabric.newConfigFile(jolokia, $scope.versionId, $scope.profileId, $scope.newFileName, function () {
                notification('success', 'Created new configuration file ' + $scope.newFileName);
                $location.path("/fabric/profile/" + $scope.versionId + "/" + $scope.profileId + "/" + $scope.newFileName);
            }, function (response) {
                notification('error', 'Failed to create ' + $scope.newFileName + ' due to ' + response.error);
            });
        };

        $scope.copyProfile = function () {
            $scope.copyProfileDialog = false;

            if ($scope.profileId.has('-') && !$scope.newProfileName.has('-')) {
                var parts = $scope.profileId.split('-');
                parts.pop();
                parts.push($scope.newProfileName);
                $scope.newProfileName = parts.join('-');
            }

            notification('info', 'Copying ' + $scope.profileId + ' to ' + $scope.newProfileName);

            Fabric.copyProfile(jolokia, $scope.versionId, $scope.profileId, $scope.newProfileName, true, function () {
                notification('success', 'Created new profile ' + $scope.newProfileName);
                Fabric.gotoProfile(workspace, jolokia, localStorage, $location, $scope.versionId, { id: $scope.newProfileName });
                Core.$apply($scope);
            }, function (response) {
                notification('error', 'Failed to create new profile ' + $scope.newProfileName + ' due to ' + response.error);
                Core.$apply($scope);
            });
        };

        function render(response) {
            if (!angular.isDefined($scope.row)) {
                $scope.loading = false;
            }
            var responseJson = angular.toJson(response.value);

            if ($scope.profileResponseJson !== responseJson) {
                if (!$scope.activeTab) {
                    $scope.activeTab = "features";
                }
                $scope.profileResponseJson = responseJson;
                $scope.row = response.value;
                var id = $scope.row.id;
                var version = $scope.row.version;
                $scope.configFolderLink = null;
                if ($scope.hasFabricWiki() && id && version) {
                    $scope.configFolderLink = "#/wiki/branch/" + version + "/view/fabric/profiles/" + Fabric.profilePath(id);
                }
                Core.$apply($scope);
            }
        }
    }
    Fabric.ProfileController = ProfileController;
})(Fabric || (Fabric = {}));
var Fabric;
(function (Fabric) {
    function FabricApisController($scope, localStorage, $routeParams, $location, jolokia, workspace, $compile, $templateCache) {
        $scope.path = "apis";

        Fabric.initScope($scope, $location, jolokia, workspace);

        $scope.apis = null;
        $scope.selectedApis = [];

        $scope.versionId = Fabric.getDefaultVersionId(jolokia);

        $scope.apiOptions = {
            //plugins: [searchProvider],
            data: 'apis',
            showFilter: false,
            showColumnMenu: false,
            filterOptions: {
                filterText: "",
                useExternalFilter: false
            },
            selectedItems: $scope.selectedApis,
            rowHeight: 32,
            selectWithCheckboxOnly: true,
            columnDefs: [
                {
                    field: 'serviceName',
                    displayName: 'Service',
                    cellTemplate: '<div class="ngCellText">{{row.entity.serviceName}}</div>',
                    //width: 400
                    width: "***"
                },
                {
                    field: 'wadlHref',
                    displayName: 'APIs',
                    cellTemplate: '<div class="ngCellText">' + '<a ng-show="row.entity.apidocsHref" ng-href="{{row.entity.apidocsHref}}"><i class="icon-puzzle-piece"></i> Swagger</a> ' + '<a ng-show="row.entity.wadlHref" ng-href="{{row.entity.wadlHref}}"><i class="icon-puzzle-piece"></i> WADL</a> ' + '<a ng-show="row.entity.wsdlHref" ng-href="{{row.entity.wsdlHref}}"><i class="icon-puzzle-piece"></i> WSDL</a>' + '</div>',
                    //width: 100
                    width: "*"
                },
                {
                    field: 'container',
                    displayName: 'Container',
                    cellTemplate: '<div class="ngCellText"><span fabric-container-link="{{row.entity.container}}"/></div>',
                    //width: 100
                    width: "*"
                },
                {
                    field: 'version',
                    displayName: 'Version',
                    cellTemplate: '<div class="ngCellText">{{row.entity.version}}</div>',
                    //width: 100
                    width: "*"
                },
                {
                    field: 'endpoint',
                    displayName: 'Location',
                    cellTemplate: '<div class="ngCellText"><a target="endpoint" href="{{row.entity.endpoint}}">{{row.entity.endpoint}}</a></div>',
                    width: "***"
                }
            ]
        };

        function matchesFilter(text) {
            var filter = $scope.searchFilter;
            return !filter || (text && text.has(filter));
        }

        if (Fabric.fabricCreated(workspace)) {
            Core.register(jolokia, $scope, {
                type: 'exec',
                mbean: Fabric.managerMBean,
                operation: "clusterJson",
                arguments: [$scope.path] }, onSuccess(onClusterData, { error: onClusterDataError }));
        }

        /*
        * Pulls all the properties out of the objectName and adds them to the object
        */
        function addObjectNameProperties(object) {
            var objectName = object["objectName"];
            if (objectName) {
                var properties = Core.objectNameProperties(objectName);
                if (properties) {
                    angular.forEach(properties, function (value, key) {
                        if (!object[key]) {
                            object[key] = value;
                        }
                    });
                }
            }
            return null;
        }

        function createFlatList(array, json, path) {
            if (typeof path === "undefined") { path = ""; }
            angular.forEach(json, function (value, key) {
                var childPath = path + "/" + key;

                function addParameters(href) {
                    angular.forEach(["container", "objectName"], function (name) {
                        var param = value[name];
                        if (param) {
                            href += "&" + name + "=" + encodeURIComponent(param);
                        }
                    });
                    return href;
                }

                // lets check if we are a services object or a folder
                var services = value["services"];
                if (services && angular.isArray(services) && value["id"]) {
                    value["path"] = childPath;
                    if (services.length) {
                        var url = services[0];
                        value["endpoint"] = url;
                        addObjectNameProperties(value);

                        // lets use proxy if external URL
                        url = Core.useProxyIfExternal(url);
                        value["serviceName"] = trimQuotes(value["service"]);
                        var apidocs = value["apidocs"];
                        var wadl = value["wadl"];
                        var wsdl = value["wsdl"];
                        if (apidocs) {
                            value["apidocsHref"] = addParameters("/hawtio-swagger/index.html?baseUri=" + url + apidocs);
                        }
                        if (wadl) {
                            value["wadlHref"] = addParameters("#/fabric/api/wadl?wadl=" + encodeURIComponent(url + wadl));
                        }
                        if (wsdl) {
                            value["wsdlHref"] = addParameters("#/fabric/api/wsdl?wsdl=" + encodeURIComponent(url + wsdl));
                        }
                    }
                    array.push(value);
                } else {
                    createFlatList(array, value, childPath);
                }
            });
        }

        function onClusterData(response) {
            var responseJson = null;
            if (response) {
                responseJson = response.value;
            }
            if ($scope.responseJson === responseJson) {
                return;
            }
            $scope.apis = [];
            $scope.responseJson = responseJson;

            try  {
                var json = JSON.parse(responseJson);
                createFlatList($scope.apis, json);
                Core.$apply($scope);
            } catch (e) {
                console.log("Failed to parse JSON " + e);
                console.log("JSON: " + responseJson);
            }
        }

        function onClusterDataError(response) {
            // make sure we initialise the apis so we know to show the warning of no
            // APIs available yet
            $scope.apis = [];
            Core.$apply($scope);
            Core.defaultJolokiaErrorHandler(response);
        }
    }
    Fabric.FabricApisController = FabricApisController;
})(Fabric || (Fabric = {}));
var Fabric;
(function (Fabric) {
    function VersionSelector($templateCache) {
        return {
            restrict: 'A',
            replace: true,
            templateUrl: Fabric.templatePath + "versionSelector.html",
            scope: {
                selectedVersion: '=fabricVersionSelector',
                availableVersions: '=?',
                menuBind: '=?',
                exclude: '@'
            },
            controller: function ($scope, $element, $attrs, jolokia) {
                $scope.versions = [];
                $scope.responseJson = '';

                $scope.$watch('selectedVersion', function (newValue, oldValue) {
                    if (newValue !== oldValue) {
                        if (newValue && 'id' in newValue) {
                            $scope.selectedVersion = $scope.versions.find(function (version) {
                                return version.id === newValue['id'];
                            });
                        } else {
                            $scope.selectedVersion = $scope.versions.find(function (version) {
                                return version.defaultVersion;
                            });
                        }
                    }
                });

                $scope.$watch('versions', function (newValue, oldValue) {
                    if (newValue !== oldValue) {
                        if ($scope.selectedVersion && 'id' in $scope.selectedVersion) {
                            $scope.selectedVersion = $scope.versions.find(function (version) {
                                return version.id === $scope.selectedVersion['id'];
                            });
                        } else {
                            $scope.selectedVersion = $scope.versions.find(function (version) {
                                return version.defaultVersion;
                            });
                        }
                    }
                }, true);

                function excludeVersions(versions, exclude) {
                    if (angular.isString(exclude)) {
                        if (exclude.has("[") && exclude.has("]")) {
                            exclude = angular.fromJson(exclude);
                        } else {
                            exclude = [exclude];
                        }
                    }

                    //log.debug("exclude: ", exclude);
                    if (!exclude || exclude.length === 0) {
                        return versions;
                    }
                    return versions.exclude(function (v) {
                        return exclude.some(function (e) {
                            return e === v.id;
                        });
                    });
                }

                function generateMenu(versions) {
                    return $scope.versions.map(function (v) {
                        return {
                            title: v.id,
                            action: function () {
                                $scope.selectedVersion = v;
                                if (!Core.isBlank($scope.onPick)) {
                                    $scope.$parent.$eval($scope.onPick, {
                                        version: v['id']
                                    });
                                }
                            }
                        };
                    });
                }

                $scope.$watch('exclude', function (newValue, oldValue) {
                    if (newValue !== oldValue) {
                        // need to rebuild the original version list
                        if ($scope.responseJson) {
                            var versions = angular.fromJson($scope.responseJson);
                            buildArray(versions);
                        }
                    }
                });

                function buildArray(versions) {
                    //log.debug("Building array from: ", versions);
                    $scope.versions = Fabric.sortVersions(versions, $scope.desc);
                    $scope.versions = excludeVersions($scope.versions, $scope.exclude);
                    if ($scope.config) {
                        $scope.config.items = generateMenu($scope.versions);
                    }
                    $scope.availableVersions = $scope.versions;
                }

                $scope.render = function (response) {
                    var responseJson = angular.toJson(response.value);
                    if ($scope.responseJson !== responseJson) {
                        $scope.responseJson = responseJson;
                        buildArray(response.value);
                        Core.$apply($scope);
                    }
                };

                Core.register(jolokia, $scope, {
                    type: 'exec',
                    mbean: Fabric.managerMBean,
                    operation: 'versions(java.util.List)',
                    arguments: [
                        ['id', 'defaultVersion']
                    ]
                }, onSuccess($scope.render));
            },
            link: function ($scope, $element, $attrs) {
                $scope.template = $templateCache.get('withSelect');
                if (Core.parseBooleanValue($attrs['useMenu'])) {
                    $scope.config = {
                        title: 'Version'
                    };
                    if (!Core.isBlank($attrs['menuTitle'])) {
                        $scope.config.title = $attrs['menuTitle'];
                    }
                    if (!Core.isBlank($attrs['menuBind'])) {
                        $scope.$watch('menuBind', function (newValue, oldValue) {
                            if (!Core.isBlank(newValue)) {
                                $scope.config.title = newValue;
                            }
                        });
                    }
                    if (!Core.isBlank($attrs['onPick'])) {
                        $scope.onPick = $attrs['onPick'];
                    }
                    if (!Core.isBlank($attrs['useIcon'])) {
                        $scope.config.icon = $attrs['useIcon'];
                    }
                    $scope.desc = 'desc' in $attrs;
                    $scope.template = $templateCache.get('withMenu');
                }
            }
        };
    }
    Fabric.VersionSelector = VersionSelector;
})(Fabric || (Fabric = {}));
var Fabric;
(function (Fabric) {
    function ContainersController($scope, $location, $route, jolokia, workspace) {
        Fabric.initScope($scope, $location, jolokia, workspace);

        // bind model values to search params...
        Core.bindModelToSearchParam($scope, $location, "containerIdFilter", "q", "");

        // only reload the page if certain search parameters change
        Core.reloadWhenParametersChange($route, $scope, $location);

        $scope.addToDashboardLink = function () {
            var href = "#/fabric/containers";
            var title = "Containers";
            var size = angular.toJson({ size_y: 1, size_x: 4 });

            return "#/dashboard/add?tab=dashboard" + "&href=" + encodeURIComponent(href) + "&size=" + encodeURIComponent(size) + "&title=" + encodeURIComponent(title);
        };

        $scope.$watch('containers', function (oldValue, newValue) {
            if (oldValue !== newValue) {
                $scope.selectedContainers = $scope.containers.filter(function (c) {
                    return c.selected;
                });

                if ($scope.selectedContainers.length > 0) {
                    $scope.activeContainerId = '';
                }
            }
        }, true);

        $scope.showChangeVersionDialog = function () {
            $scope.changeVersionDialog.open($scope.selectedContainers);
        };
    }
    Fabric.ContainersController = ContainersController;
})(Fabric || (Fabric = {}));
var Fabric;
(function (Fabric) {
    function PIDController($scope, $routeParams, jolokia, $location) {
        $scope.versionId = $routeParams.versionId;
        $scope.profileId = $routeParams.profileId;
        $scope.fname = $routeParams.fname;
        $scope.response = undefined;
        $scope.data = "";
        $scope.dirty = false;

        $scope.getMode = function () {
            var parts = $scope.fname.split('.');
            var mode = parts[parts.length - 1];
            if (!mode) {
                return 'text';
            }
            switch (mode) {
                case 'cfg':
                    mode = "properties";
                    break;
            }
            return mode;
        };

        $scope.mode = $scope.getMode();

        if (angular.isDefined($scope.versionId) && angular.isDefined($scope.profileId) && angular.isDefined($scope.fname)) {
            Core.register(jolokia, $scope, {
                type: 'exec', mbean: Fabric.managerMBean,
                operation: 'getConfigurationFile(java.lang.String,java.lang.String,java.lang.String)',
                arguments: [$scope.versionId, $scope.profileId, $scope.fname]
            }, onSuccess(render));
        }

        $scope.save = function () {
            Fabric.saveConfigFile(jolokia, $scope.versionId, $scope.profileId, $scope.fname, $scope.data.encodeBase64(), function () {
                $scope.dirty = false;
                notification('success', "Saved " + $scope.fname);
                $location.path("/fabric/profile/" + $scope.versionId + "/" + $scope.profileId);
            }, function (response) {
                notification('error', "Failed to save " + $scope.fname + " due to " + response.error);
            });
        };

        function stringToBytes(s) {
            return s.codes();
        }

        function bytesToString(b) {
            var answer = [];
            b.forEach(function (b) {
                answer.push(String.fromCharCode(b));
            });
            return answer.join('');
        }

        function render(response) {
            if (!Object.equal($scope.response, response.value)) {
                $scope.response = response.value;
                $scope.data = $scope.response.decodeBase64();
                $scope.mode = $scope.getMode();
                Core.$apply($scope);
            }
        }
    }
    Fabric.PIDController = PIDController;
})(Fabric || (Fabric = {}));
var Fabric;
(function (Fabric) {
    function PatchingController($scope, jolokia, localStorage, $location) {
        $scope.files = [];
        $scope.targetVersion = $location.search()['versionId'];
        $scope.newVersionName = '';
        $scope.proxyUser = localStorage['fabric.userName'];
        $scope.proxyPassword = localStorage['fabric.password'];
        $scope.saveJmxCredentials = false;

        $scope.cancel = function () {
            $location.url('/fabric/view').search({ cv: $scope.targetVersion });
        };

        $scope.valid = function () {
            return $scope.files && $scope.files.length > 0 && $scope.targetVersion !== null && $scope.proxyUser && $scope.proxyPassword;
        };

        $scope.go = function () {
            var message = $scope.files.length + ' patches';

            if ($scope.files.length === 1) {
                message = "patch: " + $scope.files[0].fileName;
            }

            notification('info', "Applying " + message);

            if ($scope.saveJmxCredentials) {
                localStorage['fabric.userName'] = $scope.proxyUser;
                localStorage['fabric.password'] = $scope.proxyPassword;
            }

            var files = $scope.files.map(function (file) {
                return file.absolutePath;
            });

            Fabric.applyPatches(jolokia, files, $scope.targetVersion, $scope.newVersionName, $scope.proxyUser, $scope.proxyPassword, function () {
                notification('success', "Successfully applied " + message);
                $location.url("/fabric/view");
                Core.$apply($scope);
            }, function (response) {
                Fabric.log.error("Failed to apply ", message, " due to ", response.error);
                Fabric.log.info("Stack trace: ", response.stacktrace);
                Core.$apply($scope);
            });
        };
    }
    Fabric.PatchingController = PatchingController;
})(Fabric || (Fabric = {}));
var Fabric;
(function (Fabric) {
    

    function createSshHostConfiguration() {
        return {
            hostName: null,
            port: null,
            username: null,
            password: null,
            maximumContainerCount: null,
            tags: [],
            path: null,
            passPhrase: null,
            privateKeyFile: null,
            preferredAddress: null
        };
    }
    Fabric.createSshHostConfiguration = createSshHostConfiguration;

    function createSshConfiguration() {
        return {
            hosts: [],
            defaultPath: null,
            defaultPort: null,
            defaultUsername: null,
            defaultPassword: null,
            fallbackRepositories: [],
            defaultPassPhrase: null,
            defaultPrivateKeyFile: null
        };
    }
    Fabric.createSshConfiguration = createSshConfiguration;

    function createDockerHostConfiguration() {
        return {
            hostName: null,
            port: null,
            username: null,
            password: null,
            maximumContainerCount: null,
            tags: [],
            path: null,
            passPhrase: null,
            privateKeyFile: null,
            preferredAddress: null
        };
    }
    Fabric.createDockerHostConfiguration = createDockerHostConfiguration;

    function createDockerConfiguration() {
        return {
            hosts: []
        };
    }
    Fabric.createDockerConfiguration = createDockerConfiguration;

    ;

    ;
})(Fabric || (Fabric = {}));
var Fabric;
(function (Fabric) {
    function ActiveProfileController($scope, jolokia) {
        $scope.addToDashboardLink = function () {
            var href = "#/fabric/activeProfiles";
            var title = "Active Profiles";
            var size = angular.toJson({
                size_y: 1,
                size_x: 5
            });

            return "#/dashboard/add?tab=dashboard" + "&href=" + encodeURIComponent(href) + "&size=" + encodeURIComponent(size) + "&title=" + encodeURIComponent(title);
        };
    }
    Fabric.ActiveProfileController = ActiveProfileController;
})(Fabric || (Fabric = {}));
/**
* @module Fabric
* @main Fabric
*/
var Fabric;
(function (Fabric) {
    Fabric.templatePath = 'app/fabric/html/';
    Fabric.activeMQTemplatePath = 'app/activemq/html/';

    Fabric.currentContainerId = '';

    angular.module('fabric', ['bootstrap', 'ui.bootstrap', 'ui.bootstrap.dialog', 'ngResource', 'ngGrid', 'hawtio-forms', 'hawtioCore', 'ngDragDrop', 'wiki']).config(function ($routeProvider) {
        $routeProvider.when('/fabric/containers/createContainer', { templateUrl: Fabric.templatePath + 'createContainer.html', reloadOnSearch: false }).when('/fabric/map', { templateUrl: Fabric.templatePath + 'map.html' }).when('/fabric/clusters/*page', { templateUrl: Fabric.templatePath + 'clusters.html' }).when('/fabric/containers', { templateUrl: Fabric.templatePath + 'containers.html', reloadOnSearch: false }).when('/fabric/container/:containerId', { templateUrl: Fabric.templatePath + 'container.html' }).when('/fabric/assignProfile', { templateUrl: Fabric.templatePath + 'assignProfile.html' }).when('/fabric/activeProfiles', { templateUrl: Fabric.templatePath + 'activeProfiles.html' }).when('/wiki/profile/:versionId/:profileId/editFeatures', { templateUrl: Fabric.templatePath + 'editFeatures.html' }).when('/fabric/profile/:versionId/:profileId/:fname', { templateUrl: Fabric.templatePath + 'pid.html' }).when('/fabric/view', { templateUrl: Fabric.templatePath + 'fabricView.html', reloadOnSearch: false }).when('/fabric/migrate', { templateUrl: Fabric.templatePath + 'migrateVersions.html' }).when('/fabric/patching', { templateUrl: Fabric.templatePath + 'patching.html' }).when('/fabric/configurations/:versionId/:profileId', { templateUrl: 'app/osgi/html/configurations.html' }).when('/fabric/configuration/:versionId/:profileId/:pid', { templateUrl: 'app/osgi/html/pid.html' }).when('/fabric/configuration/:versionId/:profileId/:pid/:factoryPid', { templateUrl: 'app/osgi/html/pid.html' }).when('/fabric/mq/brokers', { templateUrl: Fabric.templatePath + 'brokers.html' }).when('/fabric/mq/brokerDiagram', { templateUrl: Fabric.activeMQTemplatePath + 'brokerDiagram.html', reloadOnSearch: false }).when('/fabric/mq/brokerNetwork', { templateUrl: Fabric.templatePath + 'brokerNetwork.html' }).when('/fabric/mq/createBroker', { templateUrl: Fabric.templatePath + 'createBroker.html' }).when('/fabric/camel/diagram', { templateUrl: 'app/camel/html/fabricDiagram.html', reloadOnSearch: false }).when('/fabric/api', { templateUrl: Fabric.templatePath + 'apis.html' }).when('/fabric/api/wsdl', { templateUrl: 'app/api/html/wsdl.html' }).when('/fabric/api/wadl', { templateUrl: 'app/api/html/wadl.html' }).when('/fabric/test', { templateUrl: Fabric.templatePath + 'test.html' });
    }).directive('fabricVersionSelector', function ($templateCache) {
        return Fabric.VersionSelector($templateCache);
    }).directive('fabricProfileSelector', function () {
        return new Fabric.ProfileSelector();
    }).directive('fabricContainerList', function () {
        return new Fabric.ContainerList();
    }).directive('fabricProfileDetails', function () {
        return new Fabric.ProfileDetails();
    }).directive('fabricActiveProfileList', function () {
        return new Fabric.ActiveProfileList();
    }).directive('fabricProfileLink', function (workspace, jolokia, localStorage) {
        return {
            restrict: 'A',
            link: function ($scope, $element, $attrs) {
                var profileId = $attrs['fabricProfileLink'];

                if (profileId && !profileId.isBlank() && Fabric.fabricCreated(workspace)) {
                    var container = Fabric.getCurrentContainer(jolokia, ['versionId']);
                    var versionId = container['versionId'];
                    if (versionId && !versionId.isBlank()) {
                        var url = '#' + Fabric.profileLink(workspace, jolokia, localStorage, versionId, profileId);
                        if (angular.isDefined($attrs['file'])) {
                            url = url + "/" + $attrs['file'];
                        }

                        $element.attr('href', url);
                    }
                }
            }
        };
    }).directive('fabricContainers', function ($location, jolokia, workspace, $compile) {
        return {
            restrict: 'A',
            link: function ($scope, $element, $attrs) {
                var model = $attrs['fabricContainers'];
                var profileId = $attrs['profile'];
                var version = $scope.versionId || $scope.version || "1.0";
                if (model && !model.isBlank() && profileId && !profileId.isBlank()) {
                    // lets expose the $scope.connect object!
                    Fabric.initScope($scope, $location, jolokia, workspace);
                    var containerIds = Fabric.getContainerIdsForProfile(jolokia, version, profileId);
                    Fabric.log.info("Searching for containers for profile: " + profileId + " version " + version + ". Found: " + containerIds);
                    $scope[model] = containerIds;

                    $scope["onCancel"] = function () {
                        console.log("In our new cancel thingy!");
                    };

                    // now lets add the connect dialog
                    var dialog = $("<div ng-include=\"'app/fabric/html/connectToContainerDialog.html'\"></div>");
                    var answer = $compile(dialog)($scope);
                    $element.append(answer);
                }
            }
        };
    }).directive('fabricContainerLink', function ($location, jolokia, workspace) {
        return {
            restrict: 'A',
            link: function ($scope, $element, $attrs) {
                var modelName = $attrs['fabricContainerLink'];
                var containerId = modelName;
                var container = null;
                if (modelName && !modelName.isBlank()) {
                    // lets check if the value is a model object containing the container details
                    var modelValue = Core.pathGet($scope, modelName);
                    if (angular.isObject(modelValue)) {
                        var id = modelValue["container"] || modelValue["containerId"] || modelValue["id"];
                        if (id && modelValue["provisionResult"]) {
                            container = modelValue;
                            containerId = id;
                        }
                    }
                    if (!container) {
                        var fields = ["alive", "provisionResult", "versionId", "jmxDomains"];
                        container = Fabric.getContainerFields(jolokia, containerId, fields);
                    }

                    var link = "#/fabric/container/" + containerId;
                    var title = Fabric.statusTitle(container) || "container " + containerId;
                    var icon = Fabric.statusIcon(container) || "";

                    var html = "<a href='" + link + "' title='" + title + "'><i class='" + icon + "'></i> " + containerId + "</a>";
                    $element.html(html);

                    Core.$apply($scope);
                }
            }
        };
    }).directive('fabricContainerConnect', function ($location, jolokia) {
        return {
            restrict: 'A',
            link: function ($scope, $element, $attrs) {
                var containerId = $attrs['fabricContainerConnect'];
                var view = $attrs['view'];
                if (containerId && !containerId.isBlank()) {
                    //var fields = ["parentId", "profileIds", "versionId", "provisionResult", "jolokiaUrl", "root", 'jmxDomains'];
                    var fields = ["jolokiaUrl"];

                    //Fabric.initScope($scope, $location, jolokia, workspace);
                    var connectFn = function () {
                        var container = Fabric.getContainerFields(jolokia, containerId, fields);
                        Fabric.log.info("Connecting to container id " + containerId + " view + " + view);
                        container["id"] = containerId;
                        $scope.doConnect(container, view);
                        Core.$apply($scope);
                    };
                    $element.on("click", connectFn);
                }
            }
        };
    }).directive('fabricVersionLink', function (workspace, jolokia, localStorage) {
        return {
            restrict: 'A',
            link: function ($scope, $element, $attrs) {
                var versionLink = $attrs['fabricVersionLink'];

                if (versionLink && !versionLink.isBlank() && Fabric.fabricCreated(workspace)) {
                    var container = Fabric.getCurrentContainer(jolokia, ['versionId']);
                    var versionId = container['versionId'] || "1.0";
                    if (versionId && !versionId.isBlank()) {
                        var url = "#/wiki/branch/" + versionId + "/" + Core.trimLeading(versionLink, "/");
                        $element.attr('href', url);
                    }
                }
            }
        };
    }).run(function ($location, workspace, jolokia, viewRegistry, pageTitle, helpRegistry, layoutFull) {
        viewRegistry['fabric'] = Fabric.templatePath + 'layoutFabric.html';

        pageTitle.addTitleElement(function () {
            if (Fabric.currentContainerId === '' && Fabric.fabricCreated(workspace)) {
                try  {
                    Fabric.currentContainerId = jolokia.getAttribute(Fabric.managerMBean, 'CurrentContainerName', { timeout: 1 });
                } catch (e) {
                    // ignore
                }
            }
            return Fabric.currentContainerId;
        });

        workspace.topLevelTabs.push({
            id: "fabric.runtime",
            content: "Runtime",
            title: "Manage your containers in this fabric",
            isValid: function (workspace) {
                return Fabric.isFMCContainer(workspace);
            },
            href: function () {
                return "#/fabric/containers";
            },
            isActive: function (workspace) {
                return workspace.isLinkActive("fabric");
            }
        });
        workspace.topLevelTabs.push({
            id: "fabric.configuration",
            content: "Wiki",
            title: "View the documentation and configuration of your profiles in Fabric",
            isValid: function (workspace) {
                var answer = Fabric.isFMCContainer(workspace);
                if (answer) {
                    // must be in fabric perspective as we have wiki in container perspective as well which is not this plugin
                    var currentId = Perspective.currentPerspectiveId($location, workspace, jolokia, localStorage);
                    answer = "fabric" === currentId;
                }
                return answer;
            },
            href: function () {
                return "#/wiki/branch/" + Fabric.getActiveVersion($location) + "/view/fabric/profiles";
            },
            isActive: function (workspace) {
                return workspace.isLinkActive("/wiki") && (workspace.linkContains("fabric", "profiles") || workspace.linkContains("editFeatures"));
            }
        });
        workspace.topLevelTabs.push({
            id: "fabric.insight",
            content: "Insight",
            title: "View insight into your fabric looking at logs, metrics and messages across the fabric",
            isValid: function (workspace) {
                return Fabric.isFMCContainer(workspace) && Insight.hasInsight(workspace);
            },
            href: function () {
                return "#/insight/all?p=insight";
            },
            isActive: function (workspace) {
                return workspace.isLinkActive("/insight");
            }
        });

        helpRegistry.addUserDoc('fabric', 'app/fabric/doc/help.md', function () {
            return Fabric.isFMCContainer(workspace);
        });

        // don't need to pass the isValid parameter in subsequent calls...
        helpRegistry.addDevDoc("fabric", 'app/fabric/doc/developer.md');
    });

    hawtioPluginLoader.addModule('fabric');
})(Fabric || (Fabric = {}));
var Fabric;
(function (Fabric) {
    function MigrateContainersController($scope, jolokia, $location) {
        $scope.versions = [];
        $scope.containers = [];
        $scope.containersResponse = [];

        $scope.selectedVersion = [];
        $scope.selectedContainers = [];

        $scope.showApply = false;

        $scope.versionGridOptions = {
            data: 'versions',
            selectedItems: $scope.selectedVersion,
            showSelectionCheckbox: true,
            multiSelect: false,
            keepLastSelected: true,
            columnDefs: [{
                    field: 'id',
                    displayName: 'Version Name',
                    width: '94%'
                }],
            filterOptions: {
                filterText: ''
            }
        };

        $scope.containerGridOptions = {
            data: 'containers',
            selectedItems: $scope.selectedContainers,
            showSelectionCheckbox: true,
            multiSelect: true,
            keepLastSelected: false,
            columnDefs: [{
                    field: 'id',
                    displayName: 'Container Name',
                    width: '94%'
                }],
            filterOptions: {
                filterText: ''
            }
        };

        $scope.canApply = function () {
            return !($scope.selectedVersion.length > 0 && $scope.selectedContainers.length > 0);
        };

        $scope.render = function (response) {
            if (response.request.operation === 'versions()') {
                if (!Object.equal($scope.versions, response.value)) {
                    $scope.versions = response.value;
                    Core.$apply($scope);
                }
            }

            if (response.request.operation === 'containerIds()') {
                if (!Object.equal($scope.containersResponse, response.value)) {
                    $scope.containersResponse = response.value;

                    $scope.containers = [];

                    $scope.containersResponse.each(function (container) {
                        $scope.containers.push({
                            id: container
                        });
                    });
                    Core.$apply($scope);
                }
            }
        };

        $scope.migrateContainers = function () {
            var containerIds = $scope.selectedContainers.map(function (container) {
                return container.id;
            });
            var versionId = $scope.selectedVersion[0].id;

            notification('info', "Moving containers to version " + versionId);
            $location.path("/fabric/containers");

            Fabric.migrateContainers(jolokia, versionId, containerIds, function () {
                notification('success', "Successfully migrated containers");
            }, function (response) {
                notification('error', "Failed to migrate containers due to " + response.error);
            });
        };

        Core.register(jolokia, $scope, [
            { type: 'exec', mbean: Fabric.managerMBean, operation: 'versions()' },
            { type: 'exec', mbean: Fabric.managerMBean, operation: 'containerIds()' }
        ], onSuccess($scope.render));
    }
    Fabric.MigrateContainersController = MigrateContainersController;
})(Fabric || (Fabric = {}));
/**
* @module Fabric
*/
/// <reference path="fabricInterfaces.ts"/>
var Fabric;
(function (Fabric) {
    Fabric.log = Logger.get("Fabric");

    Fabric.jmxDomain = 'io.fabric8';

    Fabric.managerMBean = Fabric.jmxDomain + ":type=Fabric";
    Fabric.clusterManagerMBean = Fabric.jmxDomain + ":type=ClusterServiceManager";
    Fabric.clusterBootstrapManagerMBean = Fabric.jmxDomain + ":type=ClusterBootstrapManager";
    Fabric.openShiftFabricMBean = Fabric.jmxDomain + ":type=OpenShift";
    Fabric.mqManagerMBean = Fabric.jmxDomain + ":type=MQManager";

    var schemaLookupDomain = "hawtio";
    var schemaLookupType = "SchemaLookup";

    Fabric.schemaLookupMBean = schemaLookupDomain + ":type=" + schemaLookupType;

    Fabric.useDirectoriesInGit = true;
    Fabric.fabricTopLevel = "fabric/profiles/";
    Fabric.profileSuffix = ".profile";

    Fabric.jolokiaWebAppGroupId = Fabric.jmxDomain + ".fabric-jolokia";
    Fabric.OpenShiftCredentials = {
        username: null,
        password: null
    };

    function fabricCreated(workspace) {
        return workspace.treeContainsDomainAndProperties(Fabric.jmxDomain, { type: "Fabric" });
    }
    Fabric.fabricCreated = fabricCreated;

    function canBootstrapFabric(workspace) {
        return hasClusterBootstrapManager(workspace);
    }
    Fabric.canBootstrapFabric = canBootstrapFabric;

    function hasClusterBootstrapManager(workspace) {
        return workspace.treeContainsDomainAndProperties(Fabric.jmxDomain, { type: "ClusterBootstrapManager" });
    }
    Fabric.hasClusterBootstrapManager = hasClusterBootstrapManager;

    function hasClusterServiceManager(workspace) {
        return workspace.treeContainsDomainAndProperties(Fabric.jmxDomain, { type: "ClusterServiceManager" });
    }
    Fabric.hasClusterServiceManager = hasClusterServiceManager;

    function hasZooKeeper(workspace) {
        return workspace.treeContainsDomainAndProperties(Fabric.jmxDomain, { type: "ZooKeeper" });
    }
    Fabric.hasZooKeeper = hasZooKeeper;

    function hasOpenShiftFabric(workspace) {
        return workspace.treeContainsDomainAndProperties(Fabric.jmxDomain, { type: "OpenShift" });
    }
    Fabric.hasOpenShiftFabric = hasOpenShiftFabric;

    function hasMQManager(workspace) {
        return workspace.treeContainsDomainAndProperties(Fabric.jmxDomain, { type: "MQManager" });
    }
    Fabric.hasMQManager = hasMQManager;

    function hasSchemaMBean(workspace) {
        return workspace.treeContainsDomainAndProperties(schemaLookupDomain, { type: schemaLookupType });
    }
    Fabric.hasSchemaMBean = hasSchemaMBean;

    function hasGitMBean(workspace) {
        return workspace.treeContainsDomainAndProperties(Git.jmxDomain, { type: Git.mbeanType });
    }
    Fabric.hasGitMBean = hasGitMBean;

    function isFMCContainer(workspace) {
        var hasFabric = Fabric.hasFabric(workspace);
        var hasSchemaMBean = Fabric.hasSchemaMBean(workspace);
        var hasGitMBean = Fabric.hasGitMBean(workspace);

        // Too noisy...
        // log.debug("is FMC container, hasFabric: ", hasFabric, " hasSchemaMBean:", hasSchemaMBean, " hasGitMBean:", hasGitMBean);
        return hasFabric && hasSchemaMBean && hasGitMBean;
    }
    Fabric.isFMCContainer = isFMCContainer;

    function hasFabric(workspace) {
        // lets make sure we only have a fabric if we have
        // the ClusterServiceManager or ClusterBootstrapManager available
        // so that we hide Fabric for 6.0 or earlier of JBoss Fuse
        // which doesn't have the necessary mbeans for hawtio awesomeness
        return fabricCreated(workspace) && (hasClusterServiceManager(workspace) || hasClusterBootstrapManager(workspace) || hasZooKeeper(workspace));
    }
    Fabric.hasFabric = hasFabric;

    /**
    * Adds a bunch of common helper functions to the given scope
    * @method initScope
    * @for Fabric
    * @param {*} $scope
    * @param {ng.ILocationService} $location
    * @paran {*} jolokia
    * @param {Workspace} workspace
    */
    function initScope($scope, $location, jolokia, workspace) {
        $scope.gotoProfile = function (versionId, profileId) {
            Fabric.gotoProfile(workspace, jolokia, workspace.localStorage, $location, versionId, profileId);
        };

        $scope.getStatusTitle = function (container) {
            return Fabric.statusTitle(container);
        };

        $scope.isCurrentContainer = function (container) {
            if (!container) {
                return false;
            }
            if (Core.isBlank(Fabric.currentContainerId)) {
                return false;
            }
            if (angular.isObject(container)) {
                return container['id'] === Fabric.currentContainerId;
            }
            if (angular.isString(container)) {
                return container === Fabric.currentContainerId;
            }

            return false;
        };

        $scope.canConnect = function (container) {
            if (!container) {
                return false;
            }
            if (Core.isBlank(container['jolokiaUrl'])) {
                return false;
            }

            if (!Core.parseBooleanValue(container['alive'])) {
                return false;
            }
            return true;
        };

        $scope.refreshProfile = function (versionId, profileId) {
            Fabric.log.debug('Refreshing profile: ' + profileId + '/' + versionId);
            if (!versionId || !profileId) {
                return;
            }
            jolokia.request({
                type: 'exec',
                mbean: Fabric.managerMBean,
                operation: 'refreshProfile',
                arguments: [versionId, profileId]
            }, {
                method: 'POST',
                success: function () {
                    notification('success', 'Triggered refresh of profile ' + profileId + '/' + versionId);
                    Core.$apply($scope);
                },
                error: function (response) {
                    Fabric.log.warn('Failed to trigger refresh for profile ' + profileId + '/' + versionId + ' due to: ', response.error);
                    Fabric.log.info("Stack trace: ", response.stacktrace);
                    Core.$apply($scope);
                }
            });
        };

        $scope.getVersionsToExclude = function () {
            if (!$scope.selectedContainers || $scope.selectedContainers.length === 0) {
                return [];
            }
            var answer = $scope.selectedContainers.map(function (c) {
                return c['versionId'];
            });
            answer = answer.unique();
            if (answer.length > 1) {
                return [];
            } else {
                return answer;
            }
        };

        $scope.hasFabricWiki = function () {
            return Git.isGitMBeanFabric(workspace);
        };

        $scope.showContainer = function (container) {
            $location.path('/fabric/container/' + container.id);
        };

        $scope.createRequiredContainers = function (profile) {
            var profileId = profile.id;
            var args = {};
            if (profileId) {
                args["profileIds"] = profileId;
            }
            var versionId = profile.versionId || profile.version;
            if (versionId) {
                args["versionId"] = versionId;
            }
            var requirements = profile.requirements;
            if (requirements) {
                var min = requirements.minimumInstances;
                if (min) {
                    var delta = min - (profile.count || 0);
                    if (delta > 1) {
                        args["number"] = delta;
                    }
                }
            }
            $location.url('/fabric/containers/createContainer').search(args);
        };

        $scope.createContainer = function () {
            var kind = null;

            // lets see if there is an openshift option
            var providers = registeredProviders(jolokia);
            angular.forEach(["openshift", "docker", "jclouds"], function (value) {
                if (!kind && providers[value]) {
                    kind = value;
                }
            });
            if (!kind) {
                kind = 'child';
            }
            $location.url('/fabric/containers/createContainer').search('tab', kind);
        };

        $scope.createChildContainer = function (container) {
            $location.url('/fabric/containers/createContainer').search({ 'tab': 'child', 'parentId': container.id });
        };

        $scope.createChildContainer = function (container) {
            $location.url('/fabric/containers/createContainer').search({ 'tab': 'child', 'parentId': container.id });
        };

        $scope.showProfile = function (profile) {
            var version = profile.versionId || profile.version || $scope.activeVersionId;
            Fabric.gotoProfile(workspace, jolokia, localStorage, $location, version, profile);
        };

        $scope.getSelectedClass = function (obj) {
            var answer = [];
            if (obj.selected) {
                answer.push('selected');
            }
            if (angular.isDefined(obj['root']) && obj['root'] === false) {
                answer.push('child-container');
            }
            return answer.join(' ');
        };

        $scope.statusIcon = function (row) {
            return Fabric.statusIcon(row);
        };

        $scope.isEnsembleContainer = function (containerId) {
            if ($scope.ensembleContainerIds) {
                return $scope.ensembleContainerIds.any(containerId);
            }
            return false;
        };

        // for connection dialog
        $scope.connect = {
            dialog: new UI.Dialog(),
            saveCredentials: false,
            userName: null,
            password: null,
            container: null,
            view: null,
            onOK: function () {
                var userName = $scope.connect.userName;
                var password = $scope.connect.password;
                var userDetails = Core.injector.get('userDetails');
                if (!userDetails.password) {
                    // this can get unset if the user happens to refresh and hasn't checked rememberMe
                    userDetails.password = password;
                }
                var container = $scope.connect.container;
                if ($scope.connect.saveCredentials) {
                    $scope.connect.saveCredentials = false;
                    if (userName) {
                        localStorage['fabric.userName'] = userName;
                    }
                    if (password) {
                        localStorage['fabric.password'] = password;
                    }
                }
                var options = Core.createConnectOptions({
                    jolokiaUrl: container.jolokiaUrl,
                    userName: userName,
                    password: password,
                    useProxy: true,
                    view: $scope.connect.view,
                    name: container.id
                });
                Core.connectToServer(localStorage, options);
                $scope.connect.container = {};
                setTimeout(function () {
                    $scope.connect.dialog.close();
                    Core.$apply($scope);
                }, 100);
            }
        };

        $scope.doConnect = function (container, view) {
            if (!$scope.canConnect(container)) {
                return;
            }
            var userDetails = Core.injector.get('userDetails');
            $scope.connect.userName = userDetails.username;
            $scope.connect.password = userDetails.password;
            $scope.connect.container = container;
            $scope.connect.view = view || "#/logs";

            var alwaysPrompt = localStorage['fabricAlwaysPrompt'];
            if ((alwaysPrompt && alwaysPrompt !== "false") || !$scope.connect.userName || !$scope.connect.password) {
                $scope.connect.dialog.open();
            } else {
                $scope.connect.onOK();
            }
        };

        $scope.confirmDeleteDialog = {
            dialog: new UI.Dialog(),
            onOk: function () {
                $scope.confirmDeleteDialog.dialog.close();
                if (angular.isDefined($scope.containerId)) {
                    // avoid any nasty errors that the container doesn't existing anymore
                    Core.unregister(jolokia, $scope);
                    $location.path('/fabric/containers');

                    Fabric.doDeleteContainer($scope, jolokia, $scope.containerId);
                } else if (angular.isDefined($scope.selectedContainers)) {
                    $scope.selectedContainers.each(function (c) {
                        doDeleteContainer($scope, jolokia, c.id);
                    });
                } else {
                    // bail...
                    Fabric.log.info("Asked to delete containers but no containerId or selectedContainers attributes available");
                }
            },
            open: function () {
                $scope.confirmDeleteDialog.dialog.open();
            },
            close: function () {
                $scope.confirmDeleteDialog.dialog.close();
            }
        };

        $scope.createVersionDialog = {
            dialog: new UI.Dialog(),
            newVersionName: "",
            open: function () {
                $scope.createVersionDialog.newVersionName = "";
                $scope.createVersionDialog.dialog.open();
            },
            onOk: function () {
                Fabric.doCreateVersion($scope, jolokia, $location, $scope.createVersionDialog.newVersionName);
                $scope.createVersionDialog.newVersionName = "";
                $scope.createVersionDialog.dialog.close();
            }
        };

        $scope.$watch('selectedContainers', function (newValue, oldValue) {
            if (newValue !== oldValue) {
                var num = $scope.selectedContainers.length;
                $scope.versionTitle = "Migrate " + Core.maybePlural(num, "Container") + " to:";
            }
        });

        $scope.onVersionChange = function (version) {
            var containerIds = [];

            if (angular.isDefined($scope.selectedContainers)) {
                containerIds = $scope.selectedContainers.map(function (c) {
                    return c.id;
                });
            } else if (angular.isDefined($scope.row)) {
                containerIds = [$scope.row.id];
            } else {
                return;
            }

            Fabric.log.info("Setting version to " + version + " on containers: " + containerIds);

            Fabric.migrateContainers(jolokia, version, containerIds, function () {
                notification('success', "Initiated container migration to version <strong>" + version + "</strong>, changes make take some time to complete");
                Core.$apply($scope);
            }, function (response) {
                Fabric.log.error("Failed to migrate containers due to ", response.error);
                Fabric.log.info("Stack trace: ", response.stacktrace);
                Core.$apply($scope);
            });
        };

        var verbose = workspace.localStorage['fabricVerboseNotifications'];
        $scope.fabricVerboseNotifications = verbose && verbose !== "false";
    }
    Fabric.initScope = initScope;

    function doCreateVersion($scope, jolokia, $location, newVersionName) {
        var success = function (response) {
            notification('success', "Created version <strong>" + response.value.id + "</strong>, switching to this new version");

            // broadcast events to force reloads
            var $rootScope = $scope.$root || $scope.$rootScope || $scope;
            if ($rootScope) {
                $rootScope.$broadcast('wikiBranchesUpdated');
            }

            var defaultTarget = '/wiki/branch/' + response.value.id + '/view/fabric/profiles';

            var path = $location.path();
            var branch = $scope.branch || $scope.$parent.branch;

            if (!path.startsWith('/wiki/branch/') || !branch) {
                $location.path(defaultTarget);
            } else {
                path = path.replace('/branch/' + branch, '/branch/' + response.value.id);
                $location.path(path);
            }
            Core.$apply($scope);
        };

        var error = function (response) {
            Fabric.log.error("Failed to create version due to :", response.error);
            Fabric.log.info("stack trace: ", response.stacktrace);
            Core.$apply($scope);
        };

        if (!Core.isBlank(newVersionName)) {
            Fabric.createVersionWithId(jolokia, newVersionName, success, error);
        } else {
            Fabric.createVersion(jolokia, success, error);
        }
    }
    Fabric.doCreateVersion = doCreateVersion;

    function sortVersions(versions, order) {
        return (versions || []).sortBy(function (v) {
            var answer = parseFloat(v['id']);
            if (answer === NaN) {
                answer = v['id'];
            }
            return answer;
        }, order);
    }
    Fabric.sortVersions = sortVersions;

    /**
    * Converts the given path from the wiki into a profile ID
    * @method pagePathToProfileId
    * @param {String} pageId
    * @return {String}
    */
    function pagePathToProfileId(pageId) {
        var answer = null;
        if (angular.isDefined(pageId) && pageId.has(Fabric.fabricTopLevel) && pageId !== Fabric.fabricTopLevel) {
            var profileId = pageId.remove(Fabric.fabricTopLevel);
            if ((Fabric.useDirectoriesInGit || !profileId.has("/"))) {
                var profileSeparator = profileId.indexOf(Fabric.profileSuffix + "/");
                var endsWithSuffix = profileId.endsWith(Fabric.profileSuffix);
                if (!Fabric.useDirectoriesInGit || endsWithSuffix || profileSeparator > 0) {
                    if (Fabric.useDirectoriesInGit) {
                        if (endsWithSuffix) {
                            profileId = Core.trimTrailing(profileId, Fabric.profileSuffix);
                        } else if (profileSeparator > 0) {
                            profileId = profileId.substring(0, profileSeparator);
                        }
                        profileId = profileId.replace(/\//g, "-");
                    }
                    answer = profileId;
                }
            }
        }
        return answer;
    }
    Fabric.pagePathToProfileId = pagePathToProfileId;

    function profilePath(profileId) {
        if (profileId) {
            return profileId.replace(/-/g, "/") + Fabric.profileSuffix;
        } else {
            return null;
        }
    }
    Fabric.profilePath = profilePath;

    function profileLink(workspace, jolokia, localStorage, versionId, profileId) {
        var path;
        if (Wiki.isWikiEnabled(workspace, jolokia, localStorage)) {
            path = "/wiki/branch/" + versionId + "/view/fabric/profiles/" + Fabric.profilePath(profileId);
        } else {
            path = "/fabric/profile/" + versionId + "/" + profileId;
        }
        return path;
    }
    Fabric.profileLink = profileLink;

    /**
    * Returns the CSS style for the number of containers badge
    * @method containerCountBadgeStyle
    * @param {Number} min
    * @param {number} count
    * @return {string}
    */
    function containerCountBadgeStyle(min, count) {
        if (min) {
            if (!count) {
                return "badge-important";
            } else {
                return min <= count ? "badge-success" : "badge-warning";
            }
        }
        return "";
    }
    Fabric.containerCountBadgeStyle = containerCountBadgeStyle;

    function gotoProfile(workspace, jolokia, localStorage, $location, versionId, profile) {
        var path = '';
        if (angular.isString(profile)) {
            path = profileLink(workspace, jolokia, localStorage, versionId, profile);
        } else {
            path = profileLink(workspace, jolokia, localStorage, versionId, profile.id);
        }
        if (!Core.isBlank(path)) {
            $location.url(path);
        }
    }
    Fabric.gotoProfile = gotoProfile;

    function setSelect(selection, group) {
        if (!angular.isDefined(selection)) {
            return group[0];
        }
        var answer = group.findIndex(function (item) {
            return item.id === selection.id;
        });
        if (answer !== -1) {
            return group[answer];
        } else {
            return group[0];
        }
    }
    Fabric.setSelect = setSelect;

    function doDeleteContainer($scope, jolokia, name, onDelete) {
        if (typeof onDelete === "undefined") { onDelete = null; }
        notification('info', "Deleting " + name);
        destroyContainer(jolokia, name, function () {
            notification('success', "Deleted " + name);
            if (onDelete) {
                onDelete();
            }
            Core.$apply($scope);
        }, function (response) {
            notification('error', "Failed to delete " + name + " due to " + response.error);
            Core.logJolokiaStackTrace(response);
            Core.$apply($scope);
        });
    }
    Fabric.doDeleteContainer = doDeleteContainer;

    function doStartContainer($scope, jolokia, name) {
        if ($scope.fabricVerboseNotifications) {
            notification('info', "Starting " + name);
        }
        startContainer(jolokia, name, function () {
            notification('success', "Started " + name);
            Core.$apply($scope);
        }, function (response) {
            notification('error', "Failed to start " + name + " due to " + response.error);
            Core.logJolokiaStackTrace(response);
            Core.$apply($scope);
        });
    }
    Fabric.doStartContainer = doStartContainer;

    function doStopContainer($scope, jolokia, name) {
        if ($scope.fabricVerboseNotifications) {
            notification('info', "Stopping " + name);
        }
        stopContainer(jolokia, name, function () {
            notification('success', "Stopped " + name);
            Core.$apply($scope);
        }, function (response) {
            notification('error', "Failed to stop " + name + " due to " + response.error);
            Core.logJolokiaStackTrace(response);
            Core.$apply($scope);
        });
    }
    Fabric.doStopContainer = doStopContainer;

    Fabric.urlResolvers = ['http:', 'ftp:', 'mvn:'];

    function completeUri($q, $scope, workspace, jolokia, something) {
    }
    Fabric.completeUri = completeUri;

    function applyPatches(jolokia, files, targetVersion, newVersionName, proxyUser, proxyPass, success, error) {
        doAction('applyPatches(java.util.List,java.lang.String,java.lang.String,java.lang.String,java.lang.String)', jolokia, [files, targetVersion, newVersionName, proxyUser, proxyPass], success, error);
    }
    Fabric.applyPatches = applyPatches;

    function setContainerProperty(jolokia, containerId, property, value, success, error) {
        doAction('setContainerProperty(java.lang.String, java.lang.String, java.lang.Object)', jolokia, [containerId, property, value], success, error);
    }
    Fabric.setContainerProperty = setContainerProperty;

    function deleteConfigFile(jolokia, version, profile, pid, success, error) {
        doAction('deleteConfigurationFile(java.lang.String, java.lang.String, java.lang.String)', jolokia, [version, profile, pid], success, error);
    }
    Fabric.deleteConfigFile = deleteConfigFile;

    function newConfigFile(jolokia, version, profile, pid, success, error) {
        doAction('setConfigurationFile(java.lang.String, java.lang.String, java.lang.String, java.lang.String)', jolokia, [version, profile, pid, ''], success, error);
    }
    Fabric.newConfigFile = newConfigFile;

    function saveConfigFile(jolokia, version, profile, pid, data, success, error) {
        doAction('setConfigurationFile(java.lang.String, java.lang.String, java.lang.String, java.lang.String)', jolokia, [version, profile, pid, data], success, error);
    }
    Fabric.saveConfigFile = saveConfigFile;

    function addProfilesToContainer(jolokia, container, profiles, success, error) {
        doAction('addProfilesToContainer(java.lang.String, java.util.List)', jolokia, [container, profiles], success, error);
    }
    Fabric.addProfilesToContainer = addProfilesToContainer;

    function removeProfilesFromContainer(jolokia, container, profiles, success, error) {
        doAction('removeProfilesFromContainer(java.lang.String, java.util.List)', jolokia, [container, profiles], success, error);
    }
    Fabric.removeProfilesFromContainer = removeProfilesFromContainer;

    function applyProfiles(jolokia, version, profiles, containers, success, error) {
        doAction('applyProfilesToContainers(java.lang.String, java.util.List, java.util.List)', jolokia, [version, profiles, containers], success, error);
    }
    Fabric.applyProfiles = applyProfiles;

    function migrateContainers(jolokia, version, containers, success, error) {
        doAction('applyVersionToContainers(java.lang.String, java.util.List)', jolokia, [version, containers], success, error);
    }
    Fabric.migrateContainers = migrateContainers;

    function changeProfileParents(jolokia, version, id, parents, success, error) {
        doAction('changeProfileParents(java.lang.String, java.lang.String, java.util.List)', jolokia, [version, id, parents], success, error);
    }
    Fabric.changeProfileParents = changeProfileParents;

    function createProfile(jolokia, version, id, parents, success, error) {
        doAction('createProfile(java.lang.String, java.lang.String, java.util.List)', jolokia, [version, id, parents], success, error);
    }
    Fabric.createProfile = createProfile;

    function copyProfile(jolokia, version, sourceName, targetName, force, success, error) {
        doAction('copyProfile(java.lang.String, java.lang.String, java.lang.String, boolean)', jolokia, [version, sourceName, targetName, force], success, error);
    }
    Fabric.copyProfile = copyProfile;

    function createVersionWithParentAndId(jolokia, base, id, success, error) {
        doAction('createVersion(java.lang.String, java.lang.String)', jolokia, [base, id], success, error);
    }
    Fabric.createVersionWithParentAndId = createVersionWithParentAndId;

    function createVersionWithId(jolokia, id, success, error) {
        doAction('createVersion(java.lang.String)', jolokia, [id], success, error);
    }
    Fabric.createVersionWithId = createVersionWithId;

    function createVersion(jolokia, success, error) {
        doAction('createVersion()', jolokia, [], success, error);
    }
    Fabric.createVersion = createVersion;

    function deleteVersion(jolokia, id, success, error) {
        doAction('deleteVersion(java.lang.String)', jolokia, [id], success, error);
    }
    Fabric.deleteVersion = deleteVersion;

    // TODO cache the current active version? Then clear the cached value if we delete it
    function getActiveVersion($location) {
        return $location.search()['cv'] || "1.0";
    }
    Fabric.getActiveVersion = getActiveVersion;

    function getContainerIdsForProfile(jolokia, version, profileId) {
        return jolokia.execute(Fabric.managerMBean, "containerIdsForProfile", version, profileId, { method: 'POST' });
    }
    Fabric.getContainerIdsForProfile = getContainerIdsForProfile;

    function deleteProfile(jolokia, version, id, success, error) {
        doAction('deleteProfile(java.lang.String, java.lang.String)', jolokia, [version, id], success, error);
    }
    Fabric.deleteProfile = deleteProfile;

    function profileWebAppURL(jolokia, webAppId, profileId, versionId, success, error) {
        doAction('profileWebAppURL', jolokia, [webAppId, profileId, versionId], success, error);
    }
    Fabric.profileWebAppURL = profileWebAppURL;

    function onJolokiaUrlCreateJolokia(response, fn) {
        var jolokia = null;
        if (response) {
            var url = response.value;
            if (url) {
                // lets use a proxy if the URL is external
                url = Core.useProxyIfExternal(url);
                jolokia = Fabric.createJolokia(url);
            } else {
                if (response.error) {
                    Fabric.log.debug("Failed to fetch remote jolokia URL: ", response.error);
                    Fabric.log.debug("Stack trace: ", response.stacktrace);
                }
            }
            if (fn) {
                fn(jolokia);
            }
        }
        return jolokia;
    }

    /**
    * Attempts to create a jolokia for the given profile and version passing the created object
    * into the onJolokia function
    * @method profileJolokia
    *
    * @paran {*} jolokia
    * @param {String} profileId
    * @param {String} versionId
    * @param {Function} onJolokia a function to receive the jolokia object or null if one cannot be created
    */
    function profileJolokia(jolokia, profileId, versionId, onJolokia) {
        function onJolokiaUrl(response) {
            return onJolokiaUrlCreateJolokia(response, onJolokia);
        }
        if (profileId && versionId) {
            return Fabric.profileWebAppURL(jolokia, Fabric.jolokiaWebAppGroupId, profileId, versionId, onJolokiaUrl, onJolokiaUrl);
        } else {
            onJolokia(null);
        }
    }
    Fabric.profileJolokia = profileJolokia;

    /**
    * Attempts to create a jolokia for the given container id, passing the created object
    * into the onJolokia function
    * @method containerJolokia
    * @paran {*} jolokia
    * @param {String} containerId the id of the container to connect to
    * @param {Function} onJolokia a function to receive the jolokia object or null if one cannot be created
    */
    function containerJolokia(jolokia, containerId, onJolokia) {
        function onJolokiaUrl(response) {
            return onJolokiaUrlCreateJolokia(response, onJolokia);
        }
        return Fabric.containerWebAppURL(jolokia, Fabric.jolokiaWebAppGroupId, containerId, onJolokiaUrl, onJolokiaUrl);
    }
    Fabric.containerJolokia = containerJolokia;

    function containerWebAppURL(jolokia, webAppId, containerId, success, error) {
        doAction('containerWebAppURL', jolokia, [webAppId, containerId], success, error);
    }
    Fabric.containerWebAppURL = containerWebAppURL;

    function doAction(action, jolokia, arguments, success, error) {
        jolokia.request({
            type: 'exec', mbean: Fabric.managerMBean,
            operation: action,
            arguments: arguments
        }, {
            method: 'POST',
            success: success,
            error: error
        });
    }
    Fabric.doAction = doAction;

    function stopContainer(jolokia, id, success, error) {
        doAction('stopContainer(java.lang.String)', jolokia, [id], success, error);
    }
    Fabric.stopContainer = stopContainer;

    function destroyContainer(jolokia, id, success, error) {
        doAction('destroyContainer(java.lang.String)', jolokia, [id], success, error);
    }
    Fabric.destroyContainer = destroyContainer;

    function startContainer(jolokia, id, success, error) {
        doAction('startContainer(java.lang.String)', jolokia, [id], success, error);
    }
    Fabric.startContainer = startContainer;

    function getServiceList(container) {
        var answer = [];
        if (angular.isDefined(container) && angular.isDefined(container.jmxDomains) && angular.isArray(container.jmxDomains) && container.alive) {
            container.jmxDomains.forEach(function (domain) {
                if (domain === "org.apache.cxf") {
                    answer.push({
                        title: "Apache CXF",
                        type: "icon",
                        src: "icon-puzzle-piece"
                    });
                }
                if (domain === "org.fusesource.insight" || domain === "io.fabric8.insight") {
                    answer.push({
                        title: "Fabric8 Insight",
                        type: "icon",
                        src: "icon-eye-open"
                    });
                }
                if (domain === "org.apache.activemq") {
                    answer.push({
                        title: "Apache ActiveMQ",
                        type: "img",
                        src: "app/fabric/img/message_broker.png"
                    });
                }
                if (domain === "org.apache.camel") {
                    answer.push({
                        title: "Apache Camel",
                        type: "img",
                        src: "app/fabric/img/camel.png"
                    });
                }
                if (domain === "io.fabric8") {
                    answer.push({
                        title: "Fabric8",
                        type: "img",
                        src: "app/fabric/img/fabric.png"
                    });
                }
                if (domain === "hawtio") {
                    answer.push({
                        title: "hawtio",
                        type: "img",
                        src: "app/fabric/img/hawtio.png"
                    });
                }
                if (domain === "org.apache.karaf") {
                    answer.push({
                        title: "Apache Karaf",
                        type: "icon",
                        src: "icon-beaker"
                    });
                }
                if (domain === "org.apache.zookeeper") {
                    answer.push({
                        title: "Apache Zookeeper",
                        type: "icon",
                        src: "icon-group"
                    });
                }
            });
        }
        return answer;
    }
    Fabric.getServiceList = getServiceList;

    /**
    * Returns the default version ID for the current fabric
    * @param jolokia
    * @returns the version ID as a string; or defaults to 1.0 if not available
    */
    function getDefaultVersionId(jolokia) {
        return (getDefaultVersion(jolokia) || {})["id"] || "1.0";
    }
    Fabric.getDefaultVersionId = getDefaultVersionId;

    /**
    * Returns the default version object for the current fabric
    * @param jolokia
    * @returns the version object
    */
    function getDefaultVersion(jolokia) {
        return jolokia.execute(Fabric.managerMBean, "defaultVersion()");
    }
    Fabric.getDefaultVersion = getDefaultVersion;

    /**
    * Default the values that are missing in the returned JSON
    * @method defaultContainerValues
    * @param {Workspace} workspace
    * @param {any} $scope
    * @param {Array} values
    */
    function defaultContainerValues(workspace, $scope, values) {
        var map = {};
        angular.forEach(values, function (row) {
            var profileIds = row["profileIds"];
            if (profileIds) {
                angular.forEach(profileIds, function (profileId) {
                    var containers = map[profileId];
                    if (!containers) {
                        containers = [];
                        map[profileId] = containers;
                    }
                    containers.push(row);
                });
            }
            $scope.profileMap = map;
            row["link"] = containerLinks(workspace, row["id"]);
            row["profileLinks"] = profileLinks(workspace, row["versionId"], profileIds);

            var versionId = row["versionId"];
            var versionHref = url("#/fabric/profiles?v=" + versionId);
            var versionLink = "<a href='" + versionHref + "'>" + versionId + "</a>";
            row["versionHref"] = versionHref;
            row["versionLink"] = versionLink;

            var id = row['id'] || "";
            var title = "container " + id + " ";
            var img = "red-dot.png";
            if (row['managed'] === false) {
                img = "spacer.gif";
            } else if (!row['alive']) {
                img = "gray-dot.png";
            } else if (row['provisionPending']) {
                img = "pending.gif";
            } else if (row['provisionStatus'] === 'success') {
                img = "green-dot.png";
            }
            img = "img/dots/" + img;
            row["statusImageHref"] = img;
            row["link"] = "<img src='" + img + "' title='" + title + "'/> " + (row["link"] || id);
        });
        return values;
    }
    Fabric.defaultContainerValues = defaultContainerValues;

    // TODO move to core?
    function toCollection(values) {
        var collection = values;
        if (!angular.isArray(values)) {
            collection = [values];
        }
        return collection;
    }
    Fabric.toCollection = toCollection;

    function containerLinks(workspace, values) {
        var answer = "";
        angular.forEach(toCollection(values), function (value, key) {
            var prefix = "";
            if (answer.length > 0) {
                prefix = " ";
            }
            answer += prefix + "<a href='" + url("#/fabric/container/" + value + workspace.hash()) + "'>" + value + "</a>";
        });
        return answer;
    }
    Fabric.containerLinks = containerLinks;

    function profileLinks(workspace, versionId, values) {
        var answer = "";
        angular.forEach(toCollection(values), function (value, key) {
            var prefix = "";
            if (answer.length > 0) {
                prefix = " ";
            }
            answer += prefix + "<a href='" + url("#/fabric/profile/" + versionId + "/" + value + workspace.hash()) + "'>" + value + "</a>";
        });
        return answer;
    }
    Fabric.profileLinks = profileLinks;

    /**
    * Default the values that are missing in the returned JSON
    * @method defaultProfileValues
    * @param {Workspace} workspace
    * @param {String} versionId
    * @param {Array} values
    */
    function defaultProfileValues(workspace, versionId, values) {
        angular.forEach(values, function (row) {
            var id = row["id"];
            row["link"] = profileLinks(workspace, versionId, id);
            row["parentLinks"] = profileLinks(workspace, versionId, row["parentIds"]);
            var containersHref = url("#/fabric/containers?p=" + id);
            var containerCount = row["containerCount"];
            var containersLink = "";
            if (containerCount) {
                containersLink = "<a href='" + containersHref + "'>" + containerCount + "</a>";
            }
            row["containersCountLink"] = containersLink;
            row["containersHref"] = containersHref;
        });
        return values;
    }
    Fabric.defaultProfileValues = defaultProfileValues;

    function getZooKeeperFacadeMBean(workspace) {
        var folder = workspace.findMBeanWithProperties(Fabric.jmxDomain, { type: "ZooKeeper" });
        return Core.pathGet(folder, "objectName");
    }
    Fabric.getZooKeeperFacadeMBean = getZooKeeperFacadeMBean;

    function statusTitle(container) {
        var answer = 'Alive';
        if (!container.alive) {
            answer = 'Not Running';
        } else {
            answer += ' - ' + humanizeValue(container.provisionResult);
        }
        return answer;
    }
    Fabric.statusTitle = statusTitle;

    function statusIcon(row) {
        if (row) {
            if (row.alive) {
                switch (row.provisionResult) {
                    case 'success':
                        return "green icon-play-circle";
                    case 'downloading':
                        return "icon-download-alt";
                    case 'installing':
                        return "icon-hdd";
                    case 'analyzing':
                    case 'finalizing':
                        return "icon-refresh icon-spin";
                    case 'resolving':
                        return "icon-sitemap";
                    case 'error':
                        return "red icon-warning-sign";
                }
            } else {
                return "orange icon-off";
            }
        }
        return "icon-refresh icon-spin";
    }
    Fabric.statusIcon = statusIcon;

    /**
    * Creates a jolokia object for connecting to the container with the given remote jolokia URL
    * @method createJolokia
    * @param {String} url
    */
    function createJolokia(url) {
        // lets default to the user/pwd for the login
        var userDetails = Core.injector.get("userDetails");
        Fabric.log.info("Logging into remote jolokia " + url + " using user details: " + StringHelpers.toString(userDetails));
        return Core.createJolokia(url, userDetails.username, userDetails.password);
    }
    Fabric.createJolokia = createJolokia;

    function registeredProviders(jolokia) {
        var providers = jolokia.execute(Fabric.managerMBean, 'registeredValidProviders()');
        var answer = {};
        angular.forEach(providers, function (value, key) {
            answer[key] = {
                id: key,
                className: value
            };
        });
        return answer;
    }
    Fabric.registeredProviders = registeredProviders;

    function getSchema(id, className, jolokia, cb) {
        jolokia.execute(Fabric.schemaLookupMBean, 'getSchemaForClass(java.lang.String)', className, {
            method: 'POST',
            success: function (value) {
                cb(Fabric.customizeSchema(id, angular.fromJson(value)));
            }
        });
    }
    Fabric.getSchema = getSchema;

    function getDtoSchema(id, className, jolokia, cb) {
        jolokia.execute(Fabric.schemaLookupMBean, 'getSchemaForClass(java.lang.String)', className, {
            method: 'POST',
            success: function (value) {
                cb(angular.fromJson(value));
            }
        });
    }
    Fabric.getDtoSchema = getDtoSchema;

    function getCurrentContainer(jolokia, fields) {
        var name = jolokia.getAttribute(Fabric.managerMBean, 'CurrentContainerName', { method: 'POST' });
        return jolokia.execute(Fabric.managerMBean, "getContainer(java.lang.String, java.util.List)", name, fields, { method: 'POST' });
    }
    Fabric.getCurrentContainer = getCurrentContainer;

    function getContainerFields(jolokia, name, fields) {
        return jolokia.execute(Fabric.managerMBean, "getContainer(java.lang.String, java.util.List)", name, fields, { method: 'POST' });
    }
    Fabric.getContainerFields = getContainerFields;

    function getRootContainers(jolokia) {
        var fields = ["id", "root"];
        var answer = jolokia.execute(Fabric.managerMBean, "containers(java.util.List)", fields, { method: 'POST' });
        return answer.filter({ root: true }).map(function (v) {
            return v["id"];
        });
    }
    Fabric.getRootContainers = getRootContainers;

    /**
    * Queries the given fields on the contianers in the fabric invoking the given function or returning the results if the fn is null
    * @param jolokia
    * @param fields
    * @param fn
    * @return the result if fn is null
    */
    function getContainersFields(jolokia, fields, fn) {
        if (typeof fn === "undefined") { fn = null; }
        return jolokia.execute(Fabric.managerMBean, "containers(java.util.List)", fields, onSuccess(fn));
    }
    Fabric.getContainersFields = getContainersFields;

    function getOpenShiftDomains(workspace, jolokia, serverUrl, login, password, fn, onError) {
        if (typeof fn === "undefined") { fn = null; }
        if (typeof onError === "undefined") { onError = null; }
        if (hasOpenShiftFabric(workspace) && serverUrl && login && password) {
            var options = onSuccess(fn, { error: onError });
            return jolokia.execute(Fabric.openShiftFabricMBean, "getDomains", serverUrl, login, password, options);
        } else {
            if (fn) {
                fn([]);
            }
            return [];
        }
    }
    Fabric.getOpenShiftDomains = getOpenShiftDomains;

    function getOpenShiftGearProfiles(workspace, jolokia, serverUrl, login, password, fn) {
        if (typeof fn === "undefined") { fn = null; }
        if (hasOpenShiftFabric(workspace) && serverUrl && login && password) {
            return jolokia.execute(Fabric.openShiftFabricMBean, "getGearProfiles", serverUrl, login, password, onSuccess(fn));
        } else {
            if (fn) {
                fn([]);
            }
            return [];
        }
    }
    Fabric.getOpenShiftGearProfiles = getOpenShiftGearProfiles;

    function filterProfiles(jolokia, versionId, profileIds) {
        var profiles = [];
        if (versionId) {
            profiles = jolokia.execute(Fabric.managerMBean, "getProfiles(java.lang.String, java.util.List)", versionId, ['id', 'hidden', 'abstract'], { method: 'POST' });
        }

        profiles = profiles.filter(function (profile) {
            return profileIds.some(function (id) {
                return profile.id === id;
            });
        });
        profiles = profiles.filter((function (profile) {
            return !profile.abstract && !profile.hidden;
        }));

        return profiles.map(function (p) {
            return p.id;
        });
    }
    Fabric.filterProfiles = filterProfiles;

    function getProfileData(jolokia, versionId, profileId, fields) {
        return jolokia.execute(Fabric.managerMBean, "getProfile(java.lang.String, java.lang.String, java.util.List)", versionId, profileId, fields, { method: 'POST' });
    }
    Fabric.getProfileData = getProfileData;

    function getConfigFile(jolokia, versionId, profileId, fileName, fn) {
        if (typeof fn === "undefined") { fn = null; }
        function onResults(answer) {
            return answer ? answer.decodeBase64() : null;
        }

        var callback = !fn ? null : function (result) {
            fn(onResults(result));
        };
        var answer = jolokia.execute(Fabric.managerMBean, "getConfigurationFile(java.lang.String, java.lang.String, java.lang.String)", versionId, profileId, fileName, onSuccess(callback));
        return fn ? answer : onResults(answer);
    }
    Fabric.getConfigFile = getConfigFile;

    /**
    * Creates a link to the given broker configuration so we can connect in the UI
    * @param workspace
    * @param jolokia
    * @param localStorage
    * @param brokerVersion
    * @param brokerProfile
    * @param brokerId
    * @return the link to the broker page
    */
    function brokerConfigLink(workspace, jolokia, localStorage, brokerVersion, brokerProfile, brokerId) {
        var path = Fabric.profileLink(workspace, jolokia, localStorage, brokerVersion, brokerProfile);
        path += "/org.fusesource.mq.fabric.server-" + brokerId + ".properties";
        return path;
    }
    Fabric.brokerConfigLink = brokerConfigLink;

    /**
    * Connects to the broker in a new window
    */
    function connectToBroker($scope, container, postfix) {
        if (typeof postfix === "undefined") { postfix = null; }
        var view = "#/jmx/attributes?tab=activemq";
        if (postfix) {
            view += "&" + postfix;
        }
        $scope.doConnect(container, view);
    }
    Fabric.connectToBroker = connectToBroker;

    /**
    * Removes any attributes from the object that are set to an empty string.
    *
    * @method sanitizeJson
    * @for Fabric
    * @param {Object} json
    * @return {Object}
    */
    function sanitizeJson(json) {
        angular.forEach(json, function (value, key) {
            if (value === "") {
                delete json[key];
            }
        });
        return json;
    }
    Fabric.sanitizeJson = sanitizeJson;
})(Fabric || (Fabric = {}));
var Fabric;
(function (Fabric) {
    function TestController($scope, jolokia, $q, workspace, $templateCache) {
        $scope.mavenMBean = Maven.getMavenIndexerMBean(workspace);

        $scope.html = "text/html";
        $scope.versionSelector = $templateCache.get("versionSelectorTemplate");
        $scope.profileIncludes = $templateCache.get("profile-includes");
        $scope.profileExcludes = $templateCache.get("profile-excludes");
        $scope.containerList = $templateCache.get("containerListTemplate");
        $scope.profileLink = $templateCache.get("profileLinkTemplate");

        $scope.version = {};
        $scope.versionId = '';
        $scope.someUri = '';
        $scope.uriParts = [];

        $scope.version = {};

        $scope.osp = [];
        $scope.vid = '1.0';
        $scope.someProfiles = ['a-mq', 'aws-ec2'];

        $scope.selectedProfiles = [
            {
                id: '1-dot-0',
                selected: true
            }, {
                id: 'a-mq',
                selected: true
            }];

        $scope.selectedProfilesString = "";

        $scope.$watch('version', function (newValue, oldValue) {
            if (newValue !== oldValue) {
                if ($scope.version && !Object.equal($scope.version, {})) {
                    $scope.versionId = $scope.version.id;
                }
            }
        });

        $scope.$watch('osp', function (newValue, oldValue) {
            $scope.selectedProfilesString = angular.toJson($scope.osp);
        });

        $scope.$watch('someUri', function (newValue, oldValue) {
            if (newValue !== oldValue) {
                $scope.uriParts = newValue.split("/");
            }
        });

        $scope.$watch('uriParts', function (newValue, oldValue) {
            if (newValue !== oldValue) {
                if (newValue.length === 1 && newValue.length < oldValue.length) {
                    if (oldValue.last() !== '' && newValue.first().has(oldValue.last())) {
                        var merged = oldValue.first(oldValue.length - 1).include(newValue.first());
                        $scope.someUri = merged.join('/');
                    }
                }
            }
        }, true);

        $scope.doCompletionMaven = function (something) {
            return Maven.completeMavenUri($q, $scope, workspace, jolokia, something);
        };

        $scope.doCompletionFabric = function (something) {
            return Fabric.completeUri($q, $scope, workspace, jolokia, something);
        };
    }
    Fabric.TestController = TestController;
})(Fabric || (Fabric = {}));
var Fabric;
(function (Fabric) {
    function FabricBrokersController($scope, localStorage, $routeParams, $location, jolokia, workspace, $compile, $templateCache) {
        Fabric.initScope($scope, $location, jolokia, workspace);

        $scope.maps = {
            group: {},
            profile: {},
            broker: {},
            container: {}
        };

        $scope.showBroker = function (broker) {
            var brokerVersion = broker.version;
            var brokerProfile = broker.profile;
            var brokerId = broker.id;
            var path = Fabric.brokerConfigLink(workspace, jolokia, localStorage, brokerVersion, brokerProfile, brokerId);
            $location.path(path);
        };

        $scope.connectToBroker = function (container, broker) {
            Fabric.connectToBroker($scope, container);
        };

        $scope.createBroker = function (group, profile) {
            var args = {};
            if (group) {
                var groupId = group["id"];
                if (groupId) {
                    args["group"] = groupId;
                }
            }
            if (profile) {
                var profileId = profile["id"];
                if (profileId) {
                    args["profile"] = profileId;
                }
            }
            $location.url("/fabric/mq/createBroker").search(args);
        };

        function matchesFilter(text) {
            var filter = $scope.searchFilter;
            return !filter || (text && text.has(filter));
        }

        $scope.groupMatchesFilter = function (group) {
            return matchesFilter(group.id) || group.profiles.find(function (item) {
                return $scope.profileMatchesFilter(item);
            });
        };

        $scope.profileMatchesFilter = function (profile) {
            return matchesFilter(profile.id) || matchesFilter(profile.group) || matchesFilter(profile.version) || profile.brokers.find(function (item) {
                return $scope.brokerMatchesFilter(item);
            });
        };

        $scope.brokerMatchesFilter = function (broker) {
            return matchesFilter(broker.id) || matchesFilter(broker.group) || matchesFilter(broker.version) || broker.containers.find(function (item) {
                return $scope.containerMatchesFilter(item);
            });
        };

        $scope.containerMatchesFilter = function (container) {
            return matchesFilter(container.id) || matchesFilter(container.group) || matchesFilter(container.profile) || matchesFilter(container.version) || matchesFilter(container.brokerName) || (container.master && $scope.searchFilter && $scope.searchFilter.has("master"));
        };

        if (Fabric.hasMQManager) {
            Core.register(jolokia, $scope, { type: 'exec', mbean: Fabric.mqManagerMBean, operation: "loadBrokerStatus()" }, onSuccess(onBrokerData));
        }

        function onBrokerData(response) {
            if (response) {
                var responseJson = angular.toJson(response.value);
                if ($scope.responseJson === responseJson) {
                    return;
                }

                $scope.responseJson = responseJson;

                var brokers = response.value;

                function findByIdOrCreate(collection, id, map, fn) {
                    var value = collection.find(function (v) {
                        return v && v['id'] === id;
                    });
                    if (!value) {
                        value = fn();
                        value["id"] = id;
                        collection.push(value);

                        var old = map[id];

                        // copy any view related across
                        value["expanded"] = old ? old["expanded"] : true;
                        map[id] = value;
                    }
                    return value;
                }

                $scope.groups = [];
                var maps = $scope.maps;

                angular.forEach(brokers, function (brokerStatus) {
                    var groupId = brokerStatus.group || "Unknown";
                    var profileId = brokerStatus.profile || "Unknown";
                    var brokerId = brokerStatus.brokerName || "Unknown";
                    var containerId = brokerStatus.container;
                    var versionId = brokerStatus.version || "1.0";

                    var group = findByIdOrCreate($scope.groups, groupId, maps.group, function () {
                        return {
                            profiles: []
                        };
                    });
                    var profile = findByIdOrCreate(group.profiles, profileId, maps.profile, function () {
                        return {
                            group: groupId,
                            version: versionId,
                            requirements: {
                                minimumInstances: brokerStatus.minimumInstances
                            },
                            brokers: [],
                            containers: {}
                        };
                    });
                    var connectTo = (brokerStatus.networks || []).join(",");
                    var broker = findByIdOrCreate(profile.brokers, brokerId, maps.broker, function () {
                        return {
                            group: groupId,
                            profile: profileId,
                            version: versionId,
                            containers: [],
                            connectTo: connectTo
                        };
                    });
                    if (containerId) {
                        // lets create a container object per broker for the N+1 case
                        var container = findByIdOrCreate(broker.containers, containerId, maps.container, function () {
                            return brokerStatus;
                        });
                        if (container.master) {
                            container.masterTooltip = " is the master for broker: " + brokerId;
                        }
                        profile.containers[containerId] = container;
                    }
                });

                // update the stats
                angular.forEach($scope.groups, function (group) {
                    angular.forEach(group.profiles, function (profile) {
                        angular.forEach(profile.brokers, function (broker) {
                            broker.containers = broker.containers.sortBy(function (c) {
                                return c.id;
                            });
                        });
                        var count = Object.values(profile.containers).length;
                        var required = profile.requirements.minimumInstances || 0;
                        profile.requireStyle = Fabric.containerCountBadgeStyle(required, count);
                        profile.count = count;
                        profile.requiredToolTip = "this profile requires " + Core.maybePlural(required, "container") + " to be running but is currently running " + Core.maybePlural(count, "container");
                        if (required > count) {
                            profile.requiredToolTip += ". click here to create more containers";
                        }
                    });
                });

                Core.$apply($scope);
            }
        }
    }
    Fabric.FabricBrokersController = FabricBrokersController;
})(Fabric || (Fabric = {}));
var Fabric;
(function (Fabric) {
    function ContainerController($scope, $routeParams, $location, localStorage, jolokia, workspace, userDetails) {
        Fabric.initScope($scope, $location, jolokia, workspace);

        if ($scope.inDashboard) {
            $scope.operation = 'getContainer(java.lang.String, java.util.List)';
        } else {
            $scope.operation = 'getContainer(java.lang.String)';
        }

        $scope.username = userDetails.username;
        $scope.password = userDetails.password;

        $scope.tab = $routeParams['tab'];
        if (!$scope.tab) {
            $scope.tab = 'Status';
        }

        $scope.$watch('tab', function (newValue, oldValue) {
            if (newValue !== oldValue) {
                $location.search({ tab: newValue }).replace();
            }
        });

        /*
        // handy for working around any randomly added fields that won't marshal
        $scope.fields = jolokia.execute(Fabric.managerMBean, 'getFields(java.lang.String)', 'io.fabric8.api.Container');
        $scope.fields.remove('fabricService');
        $scope.operation = 'getContainer(java.lang.String, java.util.List)'
        */
        $scope.loading = true;

        $scope.containerId = $routeParams.containerId;

        $scope.addToDashboardLink = function () {
            var href = "#/fabric/container/:containerId";
            var routeParams = angular.toJson($routeParams);
            var title = $scope.containerId;
            return "#/dashboard/add?tab=dashboard&href=" + encodeURIComponent(href) + "&routeParams=" + encodeURIComponent(routeParams) + "&title=" + encodeURIComponent(title);
        };

        $scope.versionTitle = "Migrate to:";

        $scope.selectedProfiles = [];
        $scope.selectedProfilesDialog = [];
        $scope.selectedProfilesString = '';

        $scope.addProfileDialog = new UI.Dialog();
        $scope.deleteProfileDialog = new UI.Dialog();
        $scope.deleteContainerDialog = new UI.Dialog();

        $scope.$watch('selectedProfiles', function (newValue, oldValue) {
            if (newValue !== oldValue) {
                $scope.selectedProfilesString = '';
                $scope.selectedProfiles.each(function (p) {
                    $scope.selectedProfilesString += '<li>' + p.id + '</li>\n';
                });
            }
        }, true);

        $scope.stop = function () {
            Fabric.doStopContainer($scope, jolokia, $scope.containerId);
        };

        $scope.start = function () {
            Fabric.doStartContainer($scope, jolokia, $scope.containerId);
        };

        $scope.statusIcon = function () {
            return Fabric.statusIcon($scope.row);
        };

        $scope.getGitURL = function (jolokiaUrl) {
            var answer = jolokiaUrl ? jolokiaUrl.replace("jolokia", "git/fabric") : null;
            if (answer !== null) {
                var command = "git clone -b 1.0 " + answer;
                if ($scope.username !== null && $scope.password !== null) {
                    command = command.replace("://", "://" + $scope.username + ":" + $scope.password + "@");
                }
                answer = command;
            }
            return answer;
        };

        $scope.getSshURL = function (sshUrl) {
            if (!sshUrl) {
                return '';
            }
            var answer = sshUrl;
            if ($scope.username !== null && $scope.password !== null) {
                var parts = sshUrl.split(":");
                if (parts.length === 2) {
                    answer = "ssh -p " + parts[1] + " " + $scope.username + "@" + parts[0];
                }
            }
            return answer;
        };

        $scope.getJmxURL = function (jmxUrl) {
            return jmxUrl;
        };

        $scope.getType = function () {
            if ($scope.row) {
                if ($scope.row.ensembleServer) {
                    return "Fabric Server";
                } else if ($scope.row.managed) {
                    return "Managed Container";
                } else {
                    return "Unmanaged Container";
                }
            }
            return "";
        };

        $scope.updateContainerProperty = function (propertyName, row) {
            Fabric.setContainerProperty(jolokia, row.id, propertyName, row[propertyName], function () {
                Core.$apply($scope);
            }, function (response) {
                notification('error', 'Failed to set container property due to : ' + response.error);
                Core.$apply($scope);
            });
        };

        $scope.getClass = function (item) {
            if (!$scope.provisionListFilter) {
                return 'no-filter';
            } else if (item.has($scope.provisionListFilter)) {
                return 'match-filter';
            } else {
                return 'no-match-filter';
            }
        };

        /*
        $scope.$watch('selectedProfilesDialog', (newValue, oldValue) => {
        if (newValue !== oldValue) {
        console.log("Selected profiles: ", $scope.selectedProfilesDialog);
        }
        }, true);
        */
        $scope.addProfiles = function () {
            $scope.addProfileDialog.close();
            var addedProfiles = $scope.selectedProfilesDialog.map(function (p) {
                return p.id;
            });
            var text = Core.maybePlural(addedProfiles.length, "profile");
            Fabric.addProfilesToContainer(jolokia, $scope.row.id, addedProfiles, function () {
                notification('success', "Successfully added " + text);
                $scope.selectedProfilesDialog = [];
                $scope.$broadcast('fabricProfileRefresh');
                Core.$apply($scope);
            }, function (response) {
                notification('error', "Failed to add " + text + " due to " + response.error);
                $scope.selectedProfilesDialog = [];
                Core.$apply($scope);
            });
        };

        $scope.getArguments = function () {
            if ($scope.inDashboard) {
                return [$scope.containerId, ['id', 'versionId', 'profileIds', 'provisionResult', 'jolokiaUrl', 'alive', 'jmxDomains', 'ensembleServer']];
            }
            return [$scope.containerId];
        };

        $scope.deleteProfiles = function () {
            $scope.deleteProfileDialog.close();
            var removedProfiles = $scope.selectedProfiles.map(function (p) {
                return p.id;
            });
            var text = Core.maybePlural(removedProfiles.length, "profile");
            Fabric.removeProfilesFromContainer(jolokia, $scope.row.id, removedProfiles, function () {
                notification('success', "Successfully removed " + text);
                $scope.selectedProfiles = [];
                $scope.$broadcast('fabricProfileRefresh');
                Core.$apply($scope);
            }, function (response) {
                notification('error', "Failed to remove " + text + " due to " + response.error);
                $scope.selectedProfiles = [];
                Core.$apply($scope);
            });
        };

        $scope.$on("fabricProfileRefresh", function () {
            setTimeout(function () {
                jolokia.request({
                    type: 'exec', mbean: Fabric.managerMBean,
                    operation: $scope.operation,
                    arguments: $scope.getArguments()
                }, {
                    method: 'POST',
                    success: function (response) {
                        render(response);
                    }
                });
            }, 500);
        });

        if (angular.isDefined($scope.containerId)) {
            Core.register(jolokia, $scope, {
                type: 'exec', mbean: Fabric.managerMBean,
                operation: $scope.operation,
                arguments: $scope.getArguments()
            }, onSuccess(render));
        }

        $scope.formatStackTrace = function (exception) {
            return Log.formatStackTrace(exception);
        };

        function render(response) {
            if (!angular.isDefined($scope.responseJson)) {
                $scope.loading = false;
            }
            var responseJson = angular.toJson(response.value);
            if ($scope.responseJson !== responseJson) {
                $scope.responseJson = responseJson;
                $scope.row = response.value;
                $scope.container = $scope.row;
                if ($scope.row) {
                    if (angular.isDefined($scope.row.provisionException) && angular.isString($scope.row.provisionException)) {
                        $scope.row.provisionExceptionArray = $scope.row.provisionException.lines();
                    }
                    $scope.services = Fabric.getServiceList($scope.row);
                    if (angular.isDefined($scope.resolverWatch) && angular.isFunction($scope.resolverWatch)) {
                        $scope.resolverWatch();
                    }
                    $scope.resolverWatch = $scope.$watch('row.resolver', function (newValue, oldValue) {
                        if (newValue !== oldValue) {
                            $scope.updateContainerProperty('resolver', $scope.row);
                        }
                    });
                }
                Core.$apply($scope);
            }
        }
    }
    Fabric.ContainerController = ContainerController;
})(Fabric || (Fabric = {}));
/**
* @module Core
*/
var Core;
(function (Core) {
    var HelpRegistry = (function () {
        function HelpRegistry($rootScope) {
            this.$rootScope = $rootScope;
            this.discoverableDocTypes = {
                user: 'help.md'
            };
            this.topicNameMappings = {
                activemq: 'ActiveMQ',
                camel: 'Camel',
                jboss: 'JBoss',
                jclouds: 'jclouds',
                jmx: 'JMX',
                jvm: 'Connect',
                log: 'Logs',
                openejb: 'OpenEJB'
            };
            this.subTopicNameMappings = {
                user: 'For Users',
                developer: 'For Developers',
                faq: 'FAQ'
            };
            // map plugin names to their path in the app
            this.pluginNameMappings = {
                hawtioCore: 'core',
                'hawtio-branding': 'branding',
                forceGraph: 'forcegraph',
                'hawtio-ui': 'ui',
                'hawtio-forms': 'forms',
                elasticjs: 'elasticsearch'
            };
            // let's not auto-discover help files in these plugins
            this.ignoredPlugins = [
                'core',
                'branding',
                'datatable',
                'forcegraph',
                'forms',
                'perspective',
                'tree',
                'ui'
            ];
            this.topics = {};
        }
        HelpRegistry.prototype.addUserDoc = function (topic, path, isValid) {
            if (typeof isValid === "undefined") { isValid = null; }
            this.addSubTopic(topic, 'user', path, isValid);
        };

        HelpRegistry.prototype.addDevDoc = function (topic, path, isValid) {
            if (typeof isValid === "undefined") { isValid = null; }
            this.addSubTopic(topic, 'developer', path, isValid);
        };

        HelpRegistry.prototype.addSubTopic = function (topic, subtopic, path, isValid) {
            if (typeof isValid === "undefined") { isValid = null; }
            this.getOrCreateTopic(topic, isValid)[subtopic] = path;
        };

        HelpRegistry.prototype.getOrCreateTopic = function (topic, isValid) {
            if (typeof isValid === "undefined") { isValid = null; }
            if (!angular.isDefined(this.topics[topic])) {
                if (isValid === null) {
                    isValid = function () {
                        return true;
                    };
                }

                this.topics[topic] = {
                    isValid: isValid
                };
                this.$rootScope.$broadcast('hawtioNewHelpTopic');
            }
            return this.topics[topic];
        };

        HelpRegistry.prototype.mapTopicName = function (name) {
            if (angular.isDefined(this.topicNameMappings[name])) {
                return this.topicNameMappings[name];
            }
            return name.capitalize();
        };

        HelpRegistry.prototype.mapSubTopicName = function (name) {
            if (angular.isDefined(this.subTopicNameMappings[name])) {
                return this.subTopicNameMappings[name];
            }
            return name.capitalize();
        };

        HelpRegistry.prototype.getTopics = function () {
            var answer = {};

            angular.forEach(this.topics, function (value, key) {
                if (value.isValid()) {
                    Core.log.debug(key, " is available");

                    // strip out any functions...
                    answer[key] = angular.fromJson(angular.toJson(value));
                } else {
                    Core.log.debug(key, " is not available");
                }
            });

            return answer;
        };

        HelpRegistry.prototype.disableAutodiscover = function (name) {
            this.ignoredPlugins.push(name);
        };

        HelpRegistry.prototype.discoverHelpFiles = function (plugins) {
            var self = this;

            console.log("Ignored plugins: ", self.ignoredPlugins);

            plugins.forEach(function (plugin) {
                var pluginName = self.pluginNameMappings[plugin];
                if (!angular.isDefined(pluginName)) {
                    pluginName = plugin;
                }

                if (!self.ignoredPlugins.any(function (p) {
                    return p === pluginName;
                })) {
                    angular.forEach(self.discoverableDocTypes, function (value, key) {
                        // avoid trying to discover these if plugins register them
                        if (!angular.isDefined(self[pluginName]) || !angular.isDefined(self[pluginName][key])) {
                            var target = 'app/' + pluginName + '/doc/' + value;
                            console.log("checking: ", target);

                            $.ajax(target, {
                                type: 'HEAD',
                                statusCode: {
                                    200: function () {
                                        self.getOrCreateTopic(plugin)[key] = target;
                                    }
                                }
                            });
                        }
                    });
                }
            });
        };
        return HelpRegistry;
    })();
    Core.HelpRegistry = HelpRegistry;
})(Core || (Core = {}));
/**
* @module Core
*/
var Core;
(function (Core) {
    function NavBarController($scope, $location, workspace, $route, jolokia, localStorage) {
        $scope.hash = workspace.hash();
        $scope.topLevelTabs = [];
        $scope.subLevelTabs = workspace.subLevelTabs;
        $scope.currentPerspective = null;
        $scope.perspectiveDetails = {
            perspective: null
        };

        $scope.topLevelTabs = function () {
            reloadPerspective();

            // TODO transform the top level tabs based on the current perspective
            // TODO watch for changes to workspace.topLevelTabs and for the current perspective
            return workspace.topLevelTabs;
        };

        $scope.$on('jmxTreeUpdated', function () {
            reloadPerspective();
        });

        $scope.$watch('workspace.topLevelTabs', function () {
            reloadPerspective();
        });

        $scope.validSelection = function (uri) {
            return workspace.validSelection(uri);
        };

        $scope.isValid = function (nav) {
            return nav && nav.isValid(workspace);
        };

        $scope.switchPerspective = function (perspective) {
            var searchPerspectiveId = $location.search()[Perspective.perspectiveSearchId];
            if (perspective && ($scope.currentPerspective !== perspective || perspective.id !== searchPerspectiveId)) {
                Logger.debug("Changed the perspective to " + JSON.stringify(perspective) + " from search id " + searchPerspectiveId);
                if ($scope.currentPerspective) {
                    $scope.currentPerspective.lastPage = $location.url();
                }
                var pid = perspective.id;
                $location.search(Perspective.perspectiveSearchId, pid);
                Logger.debug("Setting perspective to " + pid);
                $scope.currentPerspective = perspective;
                reloadPerspective();
                $scope.topLevelTabs = Perspective.getTopLevelTabsForPerspective($location, workspace, jolokia, localStorage);

                // is any of the top level tabs marked as default?
                var defaultPlugin = Core.getDefaultPlugin(pid, workspace, jolokia, localStorage);
                var defaultTab;
                var path;
                if (defaultPlugin) {
                    $scope.topLevelTabs.forEach(funct