/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.stat;

import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.revwalk.RevCommit;

public class FileCommitActivity
implements Serializable {
    private static final long serialVersionUID = -6252001423443439822L;
    private int adds;
    private int copies;
    private int deletes;
    private int edits;
    private int renames;
    private final String path;
    private final Set<String> previousPaths = new LinkedHashSet<String>(4);

    public FileCommitActivity(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public Set<String> getPreviousPaths() {
        return this.previousPaths;
    }

    public int getRevisions() {
        return this.deletes + this.adds + this.edits + this.renames + this.copies;
    }

    public int getAdds() {
        return this.adds;
    }

    public int getCopies() {
        return this.copies;
    }

    public int getDeletes() {
        return this.deletes;
    }

    public int getEdits() {
        return this.edits;
    }

    public int getRenames() {
        return this.renames;
    }

    public FileCommitActivity include(RevCommit commit, DiffEntry entry) {
        switch (entry.getChangeType()) {
            case ADD: {
                ++this.adds;
                break;
            }
            case MODIFY: {
                ++this.edits;
                break;
            }
            case DELETE: {
                ++this.deletes;
                break;
            }
            case RENAME: {
                ++this.renames;
                this.previousPaths.add(entry.getOldPath());
                break;
            }
            case COPY: {
                ++this.copies;
            }
        }
        return this;
    }
}

