/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.tree;

import java.io.IOException;
import org.eclipse.jgit.errors.StopWalkException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public abstract class BaseTreeFilter
extends TreeFilter {
    private boolean stop;
    protected Repository repository;

    public static BaseTreeFilter wrap(TreeFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Filter cannot be null");
        }
        if (filter instanceof BaseTreeFilter) {
            return (BaseTreeFilter)filter;
        }
        return new FilterWrapper(filter);
    }

    public BaseTreeFilter setStop(boolean stop) {
        this.stop = stop;
        return this;
    }

    public BaseTreeFilter setRepository(Repository repository) {
        this.repository = repository;
        return this;
    }

    public boolean include(RevWalk commitWalk, RevCommit commit, TreeWalk treeWalk) throws IOException {
        return this.include(treeWalk);
    }

    protected boolean include(boolean include) {
        if (!include && this.stop) {
            throw StopWalkException.INSTANCE;
        }
        return include;
    }

    public BaseTreeFilter reset() {
        return this;
    }

    @Override
    public boolean shouldBeRecursive() {
        return true;
    }

    @Override
    public TreeFilter clone() {
        throw new UnsupportedOperationException("Clone not supported");
    }

    private static class FilterWrapper
    extends BaseTreeFilter {
        private final TreeFilter filter;

        protected FilterWrapper(TreeFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean include(TreeWalk walker) throws IOException {
            return this.filter.include(walker);
        }
    }
}

