/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.commit;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.gitective.core.TreeUtils;
import org.gitective.core.filter.commit.CommitFilter;
import org.gitective.core.filter.commit.DuplicateContainer;

public class DuplicateTreeFilter
extends CommitFilter {
    private final Map<RevCommit, DuplicateContainer> duplicates = new HashMap<RevCommit, DuplicateContainer>();

    @Override
    public boolean include(RevWalk walker, RevCommit commit) throws IOException {
        TreeWalk walk = TreeUtils.diffWithParents(walker, commit);
        MutableObjectId id = new MutableObjectId();
        ObjectId zero = ObjectId.zeroId();
        DuplicateContainer dupes = new DuplicateContainer(commit);
        while (walk.next()) {
            if (!walk.isSubtree()) continue;
            String path = walk.getPathString();
            for (int i = 0; i < walk.getTreeCount(); ++i) {
                walk.getObjectId(id, i);
                if (zero.equals(id)) continue;
                dupes.include(id.toObjectId(), path);
            }
            walk.enterSubtree();
        }
        if (dupes.validate()) {
            this.duplicates.put(commit, dupes);
        }
        return true;
    }

    public Map<RevCommit, DuplicateContainer> getDuplicates() {
        return this.duplicates;
    }

    public boolean hasDuplicates() {
        return !this.duplicates.isEmpty();
    }

    @Override
    public CommitFilter reset() {
        this.duplicates.clear();
        return super.reset();
    }

    @Override
    public RevFilter clone() {
        return new DuplicateTreeFilter();
    }
}

