/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.jsonschema.maven.plugin;

import io.hawt.jsonschema.maven.plugin.util.CollectionStringBuffer;
import io.hawt.jsonschema.maven.plugin.util.FileHelper;
import io.hawt.jsonschema.maven.plugin.util.JSonSchemaHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate-camel-model", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class CamelModelGeneratorMojo
extends AbstractMojo {
    @Parameter(property="project", required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDir;
    @Parameter(defaultValue="${schema-outdir}/camelModel.js")
    protected File schemaFile;
    private final Properties icons = new Properties();

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Assembling Camel model schema");
        Artifact camelCatalog = CamelModelGeneratorMojo.findCamelCatalogArtifact(this.project);
        if (camelCatalog == null) {
            this.getLog().warn((CharSequence)"Cannot find Apache Camel on the classpath");
            return;
        }
        this.getLog().info((CharSequence)("Using Apache Camel " + camelCatalog.getVersion()));
        this.initIcons();
        TreeMap<String, String> eips = new TreeMap<String, String>();
        TreeMap<String, String> rests = new TreeMap<String, String>();
        TreeMap<String, String> dataformats = new TreeMap<String, String>();
        TreeMap<String, String> languages = new TreeMap<String, String>();
        try {
            File core = camelCatalog.getFile();
            if (core != null) {
                URL url = new URL("file", null, core.getAbsolutePath());
                URLClassLoader loader = new URLClassLoader(new URL[]{url});
                InputStream is = loader.getResourceAsStream("org/apache/camel/catalog/models.properties");
                String lines = FileHelper.loadText(is);
                for (String name : lines.split("\n")) {
                    is = loader.getResourceAsStream("org/apache/camel/catalog/models/" + name + ".json");
                    String text = FileHelper.loadText(is);
                    if (text == null) continue;
                    List<Map<String, String>> model = JSonSchemaHelper.parseJsonSchema("model", text, false);
                    if (CamelModelGeneratorMojo.hasLabel(model, "rest")) {
                        rests.put(name, text);
                        continue;
                    }
                    if (CamelModelGeneratorMojo.hasLabel(model, "dataformat")) {
                        dataformats.put(name, text);
                        continue;
                    }
                    if (CamelModelGeneratorMojo.hasLabel(model, "language")) {
                        languages.put(name, text);
                        continue;
                    }
                    eips.put(name, text);
                }
            }
        }
        catch (Exception e) {
            throw new MojoFailureException("Error loading models from camel-catalog due " + e.getMessage());
        }
        if (eips.isEmpty()) {
            this.getLog().info((CharSequence)("Cannot update " + this.schemaFile + " as no Camel models found in the Apache Camel version"));
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream(this.schemaFile, false);
            String version = "var _apacheCamelModelVersion = '" + camelCatalog.getVersion() + "';\n\n";
            fos.write(version.getBytes());
            fos.write("var _apacheCamelModel =".getBytes());
            fos.write("{\n".getBytes());
            fos.write("  \"definitions\": {\n".getBytes());
            this.generateExpression(languages.keySet(), fos);
            Iterator<String> it = eips.keySet().iterator();
            this.generateSchema("eips", "model", eips, fos, it);
            fos.write("  },\n".getBytes());
            fos.write("  \"rests\": {\n".getBytes());
            it = rests.keySet().iterator();
            this.generateSchema("rests", "model", rests, fos, it);
            fos.write("  },\n".getBytes());
            fos.write("  \"dataformats\": {\n".getBytes());
            it = dataformats.keySet().iterator();
            this.generateSchema("dataformats", "model", dataformats, fos, it);
            fos.write("  },\n".getBytes());
            fos.write("  \"languages\": {\n".getBytes());
            it = languages.keySet().iterator();
            this.generateSchema("languages", "model", languages, fos, it);
            fos.write("  }\n".getBytes());
            fos.write("}\n".getBytes());
            fos.close();
        }
        catch (Exception e) {
            throw new MojoFailureException("Error writing to file " + this.schemaFile);
        }
        this.getLog().info((CharSequence)("Assembled Camel models into combined schema: " + this.schemaFile));
    }

    private void initIcons() throws MojoExecutionException {
        try {
            this.icons.load(CamelModelGeneratorMojo.class.getClassLoader().getResourceAsStream("icons.properties"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot load list of icons", (Exception)e);
        }
    }

    private void generateExpression(Set<String> languages, FileOutputStream fos) throws IOException {
        StringBuilder sb = new StringBuilder();
        CollectionStringBuffer enums = new CollectionStringBuffer(", ");
        for (String name : languages) {
            if ("expression".equals(name)) continue;
            enums.append(JSonSchemaHelper.doubleQuote(name));
        }
        String enumValues = enums.toString();
        CollectionStringBuffer cst = new CollectionStringBuffer(",\n");
        sb.append("    ").append(JSonSchemaHelper.doubleQuote("expression")).append(": {\n");
        cst.append("      \"type\": \"object\"");
        cst.append("      \"title\": " + JSonSchemaHelper.doubleQuote("expression"));
        cst.append("      \"group\": " + JSonSchemaHelper.doubleQuote("language"));
        cst.append("      \"icon\": " + JSonSchemaHelper.doubleQuote("generic24.png"));
        cst.append("      \"description\": " + JSonSchemaHelper.doubleQuote("Expression in the choose language"));
        sb.append(cst.toString()).append(",\n");
        cst = new CollectionStringBuffer(",\n");
        sb.append("      \"properties\": {\n");
        sb.append("        ").append(JSonSchemaHelper.doubleQuote("expression")).append(": {\n");
        cst.append("          \"kind\": " + JSonSchemaHelper.doubleQuote("element"));
        cst.append("          \"type\": " + JSonSchemaHelper.doubleQuote("string"));
        cst.append("          \"title\": " + JSonSchemaHelper.doubleQuote("Expression"));
        cst.append("          \"description\": " + JSonSchemaHelper.doubleQuote("The expression"));
        cst.append("          \"required\": true\n");
        sb.append(cst.toString());
        sb.append("        },\n");
        cst = new CollectionStringBuffer(",\n");
        sb.append("        ").append(JSonSchemaHelper.doubleQuote("language")).append(": {\n");
        cst.append("          \"kind\": " + JSonSchemaHelper.doubleQuote("element"));
        cst.append("          \"type\": " + JSonSchemaHelper.doubleQuote("string"));
        cst.append("          \"title\": " + JSonSchemaHelper.doubleQuote("Expression"));
        cst.append("          \"description\": " + JSonSchemaHelper.doubleQuote("The chosen language"));
        cst.append("          \"required\": true");
        cst.append("          \"enum\": [ " + enumValues + " ]");
        sb.append(cst.toString()).append("\n");
        sb.append("        }\n");
        sb.append("      }\n");
        sb.append("    },\n");
        fos.write(sb.toString().getBytes());
    }

    private void generateSchema(String schema, String parent, Map<String, String> models, FileOutputStream fos, Iterator<String> it) throws IOException {
        while (it.hasNext()) {
            String name = it.next();
            String json = models.get(name);
            StringBuilder sb = new StringBuilder();
            List<Map<String, String>> model = JSonSchemaHelper.parseJsonSchema(parent, json, false);
            List<Map<String, String>> properties = JSonSchemaHelper.parseJsonSchema("properties", json, true);
            String group = JSonSchemaHelper.getValue("label", model);
            String title = JSonSchemaHelper.getValue("title", model);
            String input = JSonSchemaHelper.getValue("input", model);
            String output = JSonSchemaHelper.getValue("output", model);
            String nextSiblingAddedAsChild = "false";
            if ("true".equals(input) && "false".equals(output)) {
                nextSiblingAddedAsChild = "true";
            }
            String description = JSonSchemaHelper.getValue("description", model);
            String icon = this.findIcon(name);
            if (group == null) continue;
            CollectionStringBuffer cst = new CollectionStringBuffer(",\n");
            sb.append("    ").append(JSonSchemaHelper.doubleQuote(name)).append(": {\n");
            cst.append("      \"type\": \"object\"");
            cst.append("      \"title\": " + JSonSchemaHelper.doubleQuote(title));
            cst.append("      \"group\": " + JSonSchemaHelper.doubleQuote(group));
            cst.append("      \"icon\": " + JSonSchemaHelper.doubleQuote(icon));
            cst.append("      \"description\": " + JSonSchemaHelper.doubleQuote(CamelModelGeneratorMojo.safeDescription(description)));
            if ("eips".equals(schema) || "rests".equals(schema)) {
                cst.append("      \"acceptInput\": " + JSonSchemaHelper.doubleQuote(input));
                cst.append("      \"acceptOutput\": " + JSonSchemaHelper.doubleQuote(output));
                cst.append("      \"nextSiblingAddedAsChild\": " + JSonSchemaHelper.doubleQuote(nextSiblingAddedAsChild));
            }
            sb.append(cst.toString()).append(",\n");
            sb.append("      \"properties\": {\n");
            Iterator<Map<String, String>> it2 = properties.iterator();
            while (it2.hasNext()) {
                Map<String, String> option = it2.next();
                cst = new CollectionStringBuffer(",\n");
                String optionName = option.get("name");
                title = this.asTitle(optionName);
                String kind = option.get("kind");
                String type = option.get("type");
                String required = option.get("required");
                String deprecated = option.get("deprecated");
                description = option.get("description");
                String defaultValue = option.get("defaultValue");
                String enumValues = option.get("enum");
                if ("completionSize".equals(optionName) && "expression".equals(kind)) {
                    optionName = "completionSizeExpression";
                } else if ("completionTimeout".equals(optionName) && "expression".equals(kind)) {
                    optionName = "completionTimeoutExpression";
                }
                if ("inputs".equals(optionName) || "outputs".equals(optionName)) continue;
                sb.append("        ").append(JSonSchemaHelper.doubleQuote(optionName)).append(": {\n");
                cst.append("          \"kind\": " + JSonSchemaHelper.doubleQuote(kind));
                cst.append("          \"type\": " + JSonSchemaHelper.doubleQuote(type));
                if (defaultValue != null) {
                    cst.append("          \"defaultValue\": " + JSonSchemaHelper.doubleQuote(CamelModelGeneratorMojo.safeDefaultValue(defaultValue)));
                }
                if (enumValues != null) {
                    cst.append("          \"enum\": [ " + this.safeEnumJson(enumValues) + " ]");
                }
                cst.append("          \"description\": " + JSonSchemaHelper.doubleQuote(CamelModelGeneratorMojo.safeDescription(description)));
                cst.append("          \"title\": " + JSonSchemaHelper.doubleQuote(title));
                if ("true".equals(required)) {
                    cst.append("          \"required\": true");
                } else {
                    cst.append("          \"required\": false");
                }
                if ("true".equals(deprecated)) {
                    cst.append("          \"deprecated\": true");
                } else {
                    cst.append("          \"deprecated\": false");
                }
                sb.append(cst.toString());
                sb.append("\n");
                if (it2.hasNext()) {
                    sb.append("        },\n");
                    continue;
                }
                sb.append("        }\n");
            }
            sb.append("      }\n");
            if (it.hasNext()) {
                sb.append("    },\n");
            } else {
                sb.append("    }\n");
            }
            fos.write(sb.toString().getBytes());
        }
    }

    private String findIcon(String name) {
        String answer = this.icons.getProperty(name);
        if (answer == null) {
            answer = "generic24.png";
        }
        return answer;
    }

    private String asTitle(String name) {
        return JSonSchemaHelper.asTitle(name);
    }

    private String safeEnumJson(String values) {
        CollectionStringBuffer cst = new CollectionStringBuffer();
        cst.setSeparator(", ");
        for (String v : values.split(",")) {
            cst.append(JSonSchemaHelper.doubleQuote(v));
        }
        return cst.toString();
    }

    private static String safeDefaultValue(String value) {
        if ("\"".equals(value)) {
            return "\\\"";
        }
        if ("\\".equals(value)) {
            return "\\\\";
        }
        return value;
    }

    private static String safeDescription(String description) {
        if (description == null) {
            return "";
        }
        description = description.replaceAll("\"", "\\\\\"");
        return description;
    }

    private static Artifact findCamelCatalogArtifact(MavenProject project) {
        for (Artifact artifact : project.getDependencyArtifacts()) {
            if (!artifact.getGroupId().equals("org.apache.camel") || !artifact.getArtifactId().equals("camel-catalog")) continue;
            return artifact;
        }
        return null;
    }

    private static boolean hasLabel(List<Map<String, String>> model, String label) {
        for (Map<String, String> row : model) {
            String entry = row.get("label");
            if (entry == null) continue;
            return entry.contains(label);
        }
        return false;
    }
}

