/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.jsonschema.maven.plugin.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FileHelper {
    private FileHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadText(InputStream in) throws IOException {
        StringBuilder builder = new StringBuilder();
        InputStreamReader isr = new InputStreamReader(in);
        try {
            String line;
            LineNumberReader reader = new LineNumberReader(isr);
            while ((line = ((BufferedReader)reader).readLine()) != null) {
                builder.append(line);
                builder.append("\n");
            }
            String string = builder.toString();
            return string;
        }
        finally {
            isr.close();
            in.close();
        }
    }

    public static String after(String text, String after) {
        if (!text.contains(after)) {
            return null;
        }
        return text.substring(text.indexOf(after) + after.length());
    }

    public static Map<String, String> parseAsMap(String data) {
        HashMap<String, String> answer = new HashMap<String, String>();
        if (data != null) {
            String[] lines;
            for (String line : lines = data.split("\n")) {
                int idx = line.indexOf(61);
                if (idx == -1) continue;
                String key = line.substring(0, idx);
                String value = line.substring(idx + 1);
                value = value.trim().replaceAll("\n", "");
                answer.put(key.trim(), value);
            }
        }
        return answer;
    }

    public static void findJsonFiles(File dir, Set<File> found, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        if (files != null) {
            for (File file : files) {
                boolean jsonFile;
                boolean bl = jsonFile = file.isFile() && file.getName().endsWith(".json");
                if (jsonFile) {
                    found.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                FileHelper.findJsonFiles(file, found, filter);
            }
        }
    }

    public static class JsonFileFilter
    implements FileFilter {
        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.getName().endsWith(".json");
        }
    }
}

