/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.junit;

import io.hawt.junit.InProgressDTO;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class InProgressRunListener
extends RunListener {
    private long startTime;
    private long runTime;
    private final InProgressDTO inProgressDTO;

    public InProgressRunListener(InProgressDTO inProgressDTO) {
        this.inProgressDTO = inProgressDTO;
    }

    public void testRunStarted(Description description) throws Exception {
        this.startTime = System.currentTimeMillis();
        this.inProgressDTO.setStartTime(this.startTime);
    }

    public void testRunFinished(Result result) throws Exception {
        long endTime = System.currentTimeMillis();
        this.inProgressDTO.setEndTime(endTime);
        this.runTime += endTime - this.startTime;
        this.inProgressDTO.updateRuntime(this.runTime);
    }

    public void testStarted(Description description) throws Exception {
        this.inProgressDTO.setTestClass(description.getTestClass().getName());
        this.inProgressDTO.setTestMethod(description.getMethodName());
    }

    public void testFinished(Description description) throws Exception {
        this.inProgressDTO.onTestFinished();
        this.inProgressDTO.setTestClass(null);
        this.inProgressDTO.setTestMethod(null);
    }

    public void testFailure(Failure failure) throws Exception {
        this.inProgressDTO.onTestFailed();
        this.inProgressDTO.setTestClass(null);
        this.inProgressDTO.setTestMethod(null);
    }

    public void testAssumptionFailure(Failure failure) {
    }

    public void testIgnored(Description description) throws Exception {
        this.inProgressDTO.onTestIgnored();
        this.inProgressDTO.setTestClass(null);
        this.inProgressDTO.setTestMethod(null);
    }
}

