/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.junit;

import io.hawt.junit.ThrowableDTO;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;

public class FailureDTO {
    private String description;
    private String trace;
    private String testHeader;
    private String message;
    private List<ThrowableDTO> exceptions = new ArrayList<ThrowableDTO>();

    public FailureDTO() {
    }

    public FailureDTO(Failure failure) {
        this.message = failure.getMessage();
        this.testHeader = failure.getTestHeader();
        this.trace = failure.getTrace();
        Description description = failure.getDescription();
        if (description != null) {
            this.description = description.toString();
        }
        ThrowableDTO.addThrowableAndCauses(this.exceptions, failure.getException());
    }

    public String toString() {
        return "FailureDTO{testHeader='" + this.testHeader + '\'' + ", message='" + this.message + '\'' + '}';
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTrace() {
        return this.trace;
    }

    public void setTrace(String trace) {
        this.trace = trace;
    }

    public String getTestHeader() {
        return this.testHeader;
    }

    public void setTestHeader(String testHeader) {
        this.testHeader = testHeader;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public List<ThrowableDTO> getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(List<ThrowableDTO> exceptions) {
        this.exceptions = exceptions;
    }
}

