/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.junit;

import io.hawt.junit.FailureDTO;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;

public class ResultDTO {
    boolean successful;
    int ignoreCount;
    int failureCount;
    int runCount;
    long runTime;
    List<FailureDTO> failures = new ArrayList<FailureDTO>();

    public ResultDTO() {
    }

    public ResultDTO(Result result) {
        this.successful = result.wasSuccessful();
        this.ignoreCount = result.getIgnoreCount();
        this.failureCount = result.getFailureCount();
        this.runCount = result.getRunCount();
        this.runTime = result.getRunTime();
        List failureList = result.getFailures();
        for (Failure failure : failureList) {
            this.failures.add(new FailureDTO(failure));
        }
    }

    public String toString() {
        return "ResultDTO{successful=" + this.successful + ", runCount=" + this.runCount + ", failureCount=" + this.failureCount + ", ignoreCount=" + this.ignoreCount + ", runTime=" + this.runTime + '}';
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public void setSuccessful(boolean successful) {
        this.successful = successful;
    }

    public int getIgnoreCount() {
        return this.ignoreCount;
    }

    public void setIgnoreCount(int ignoreCount) {
        this.ignoreCount = ignoreCount;
    }

    public int getFailureCount() {
        return this.failureCount;
    }

    public void setFailureCount(int failureCount) {
        this.failureCount = failureCount;
    }

    public int getRunCount() {
        return this.runCount;
    }

    public void setRunCount(int runCount) {
        this.runCount = runCount;
    }

    public long getRunTime() {
        return this.runTime;
    }

    public void setRunTime(long runTime) {
        this.runTime = runTime;
    }

    public List<FailureDTO> getFailures() {
        return this.failures;
    }

    public void setFailures(List<FailureDTO> failures) {
        this.failures = failures;
    }
}

